/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer;

import com.ibm.ws.report.analyze.AnalysisRule;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.RuleInfo;
import com.ibm.ws.report.utilities.RuleSeverity;
import com.ibm.ws.report.writer.ReportWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public abstract class DetailAnalysisReportWriter
implements ReportWriter {
    protected StringBuilder resultBuffer = new StringBuilder();
    protected List<String> projects = null;
    protected Map<String, List<DetailResult>> results = null;
    protected Map<String, Map<String, Map<String, List<String>>>> rulesAnalyzed = null;
    protected boolean formatByFile = false;
    protected String[] sourceOptions = null;
    protected String[] targetOptions = null;
    protected SortedMap<String, String> scanOptions = null;
    protected List<String> ruleIdentifiers = null;
    protected List<String> filesAffected = null;
    protected Map<String, String> categoryByRuleDesc;
    protected Map<String, List<String>> filesAffectedByRuleId;
    protected Map<String, List<DetailResult>> resultsByFileName;
    protected Map<String, List<DetailResult>> resultsByRuleId;
    protected String returnString;
    protected Map<String, String> ruleHelp = null;
    protected Map<String, String> helpByRuleId;
    protected int totalNumberOfResults = 0;
    protected List<String> connectivityRulesAnalyzed = null;
    protected Map<String, RuleSeverity> ruleSeverities = null;
    protected Map<String, RuleInfo> ruleCosts = null;
    protected Map<String, RuleSeverity> severityByRuleId;
    protected Map<String, String> ruleDescriptionByRuleId;
    protected SortedMap<String, AnalysisRule> mapOfIdToAnalysisRules = null;
    protected int numSevereRules = 0;
    protected int numWarningRules = 0;
    protected int numInfoRules = 0;
    protected int numNoSeverityRules = 0;
    protected int numSevereRuleResults = 0;
    protected int numWarningRuleResults = 0;
    protected int numInfoRuleResults = 0;
    protected int numNoSeverityRuleResults = 0;

    public DetailAnalysisReportWriter(List<String> arrayOfProjects, String[] sourceOptions, String[] targetOptions, SortedMap<String, String> scanOptions, Map<String, List<DetailResult>> results, Map<String, Map<String, Map<String, List<String>>>> rulesAnalyzed, boolean formatByFile, Map<String, String> ruleHelp, List<String> connectivityRulesAnalyzed, Map<String, RuleSeverity> ruleSeverities, Map<String, RuleInfo> costs, boolean isNewHtmlWriter, SortedMap<String, AnalysisRule> mapOfIdToAnalysisRules) {
        this.projects = arrayOfProjects;
        this.rulesAnalyzed = rulesAnalyzed;
        this.formatByFile = formatByFile;
        this.sourceOptions = sourceOptions;
        this.targetOptions = targetOptions;
        this.scanOptions = scanOptions;
        this.connectivityRulesAnalyzed = connectivityRulesAnalyzed;
        this.mapOfIdToAnalysisRules = mapOfIdToAnalysisRules;
        if (!isNewHtmlWriter) {
            this.categoryByRuleDesc = new HashMap<String, String>();
            this.filesAffectedByRuleId = new HashMap<String, List<String>>();
            this.resultsByFileName = new HashMap<String, List<DetailResult>>();
            this.resultsByRuleId = new HashMap<String, List<DetailResult>>();
            this.helpByRuleId = new HashMap<String, String>();
            this.severityByRuleId = new HashMap<String, RuleSeverity>();
            this.ruleDescriptionByRuleId = new HashMap<String, String>();
            this.results = results;
            this.ruleSeverities = ruleSeverities;
            this.ruleCosts = costs;
            this.ruleHelp = ruleHelp;
            this.loadRuleDescriptions();
        }
    }

    public String parseRuleIdFromIdentfier(String ruleIdentifier) {
        return ruleIdentifier.substring(ruleIdentifier.lastIndexOf(61) + 1);
    }

    public String parseRuleNameFromIdentfier(String ruleIdentifier) {
        return ruleIdentifier.substring(0, ruleIdentifier.lastIndexOf(61));
    }

    protected void loadRuleDescriptions() {
        HashSet<String> unsortedRuleIdentifiers = new HashSet<String>();
        HashSet<String> unsortedFileNames = new HashSet<String>();
        HashMap ruleIdToFileNames = new HashMap();
        HashSet<String> ruleIdProcessed = new HashSet<String>();
        Set<String> keys = this.results.keySet();
        for (String key : keys) {
            List<DetailResult> list = this.results.get(key);
            for (DetailResult thisResult : list) {
                List<Object> results;
                Set<String> fileNames;
                String ruleId = thisResult.getRuleName();
                String ruleDesc = thisResult.getRuleDesc();
                if (this.mapOfIdToAnalysisRules != null && !this.mapOfIdToAnalysisRules.containsKey(ruleId)) continue;
                RuleSeverity ruleSeverity = this.ruleSeverities.get(ruleId);
                if (!ruleIdProcessed.contains(ruleId)) {
                    ruleIdProcessed.add(ruleId);
                    String helpId = this.ruleHelp.get(ruleId);
                    if (helpId != null) {
                        this.helpByRuleId.put(ruleId, helpId);
                    }
                    this.severityByRuleId.put(ruleId, ruleSeverity);
                    this.ruleDescriptionByRuleId.put(ruleId, ruleDesc);
                    if (!ruleIdToFileNames.containsKey(ruleId)) {
                        switch (ruleSeverity) {
                            case SEVERE: {
                                ++this.numSevereRules;
                                break;
                            }
                            case WARNING: {
                                ++this.numWarningRules;
                                break;
                            }
                            case INFO: {
                                ++this.numInfoRules;
                                break;
                            }
                            case NONE: {
                                ++this.numNoSeverityRules;
                            }
                        }
                    }
                }
                int numResults = thisResult.getNumberOfOccurrences();
                this.totalNumberOfResults += numResults;
                switch (ruleSeverity) {
                    case SEVERE: {
                        this.numSevereRuleResults += numResults;
                        break;
                    }
                    case WARNING: {
                        this.numWarningRuleResults += numResults;
                        break;
                    }
                    case INFO: {
                        this.numInfoRuleResults += numResults;
                        break;
                    }
                    case NONE: {
                        this.numNoSeverityRuleResults += numResults;
                    }
                }
                String fileName = thisResult.getFileName();
                if (ruleIdToFileNames.containsKey(ruleId)) {
                    fileNames = (Set)ruleIdToFileNames.get(ruleId);
                    fileNames.add(fileName);
                } else {
                    fileNames = new HashSet();
                    fileNames.add(fileName);
                    ruleIdToFileNames.put(ruleId, fileNames);
                }
                if (this.resultsByFileName.containsKey(fileName)) {
                    results = this.resultsByFileName.get(fileName);
                    results.add(thisResult);
                } else {
                    results = new ArrayList<DetailResult>();
                    results.add(thisResult);
                    this.resultsByFileName.put(fileName, results);
                }
                if (this.resultsByRuleId.containsKey(ruleId)) {
                    results = this.resultsByRuleId.get(ruleId);
                    results.add(thisResult);
                } else {
                    results = new ArrayList();
                    results.add(thisResult);
                    this.resultsByRuleId.put(ruleId, results);
                }
                String ruleIdentifier = String.valueOf(ruleDesc) + "=" + ruleId;
                unsortedRuleIdentifiers.add(ruleIdentifier);
                unsortedFileNames.add(fileName);
            }
        }
        ArrayList<String> sortedKeys = new ArrayList<String>(unsortedRuleIdentifiers);
        Collections.sort(sortedKeys);
        this.filesAffected = new ArrayList<String>(unsortedFileNames);
        Collections.sort(this.filesAffected);
        Set ruleIdToFileNamesKeys = ruleIdToFileNames.keySet();
        for (String string : ruleIdToFileNamesKeys) {
            Set fileNames = (Set)ruleIdToFileNames.get(string);
            ArrayList filesAffectedByRule = new ArrayList(fileNames);
            Collections.sort(filesAffectedByRule);
            this.filesAffectedByRuleId.put(string, filesAffectedByRule);
        }
        this.ruleIdentifiers = sortedKeys;
        for (Map.Entry entry : this.rulesAnalyzed.entrySet()) {
            String mainCatKey = (String)entry.getKey();
            for (Map.Entry subCatsEntry : ((Map)entry.getValue()).entrySet()) {
                String subcatKey = (String)subCatsEntry.getKey();
                String category = !mainCatKey.equals(subcatKey) ? String.valueOf(mainCatKey) + " / " + subcatKey : mainCatKey;
                this.storeCategoryNamesByRuleDescription(category, (Map)subCatsEntry.getValue());
            }
        }
    }

    protected void storeCategoryNamesByRuleDescription(String category, Map<String, List<String>> rulesByType) {
        Set<String> ruleTypes = rulesByType.keySet();
        for (String ruleType : ruleTypes) {
            List<String> ruleIndentifiers = rulesByType.get(ruleType);
            for (String ruleIndentifier : ruleIndentifiers) {
                String ruleDesc = this.parseRuleNameFromIdentfier(ruleIndentifier);
                if (!this.ruleIdentifiers.contains(ruleIndentifier) || this.categoryByRuleDesc.containsKey(ruleDesc)) continue;
                this.categoryByRuleDesc.put(ruleDesc, category);
            }
        }
    }

    public void close() {
        this.returnString = this.resultBuffer.toString();
    }

    @Override
    public String getResult() {
        return this.returnString;
    }
}

