/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.analyze.AnalysisRule;
import com.ibm.ws.report.utilities.RewriteDependency;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SortedMap;

public class RewriteGradleConfigWriter {
    static String configTemplate = "plugins {\n    id 'java'\n    id 'maven-publish'\n    id '%s' version '%s'\n}\n\nrewrite {\n    activeRecipe(\n%s    )\n}\n\ndependencies {\n%s}";

    public static String buildRewriteConfig(Map<String, LinkedHashSet<String>> rulesToRecipes, SortedMap<String, AnalysisRule> mapOfIdToAnalysisRules, boolean showAllHelp) {
        HashSet<RewriteDependency> rewriteDependencies = new HashSet<RewriteDependency>();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, LinkedHashSet<String>> entry : rulesToRecipes.entrySet()) {
            String ruleId = entry.getKey();
            LinkedHashSet<String> recipes = entry.getValue();
            AnalysisRule rule = (AnalysisRule)mapOfIdToAnalysisRules.get(ruleId);
            if (rule == null || !showAllHelp && rule.getResults().isEmpty()) continue;
            String defaultRecipe = (String)recipes.iterator().next();
            sb.append("        // ").append(rule.getRuleName()).append("\n");
            RewriteDependency recipeDependency = RewriteDependency.resolveRecipeDependency(defaultRecipe);
            if (recipeDependency != null) {
                rewriteDependencies.add(recipeDependency);
            } else {
                sb.append("        // ").append(Messages.getString("RewriteConfigWriter_Dependecy_Maybe_Required")).append("\n");
            }
            sb.append("        '").append(defaultRecipe).append("',\n");
        }
        String activeRevipes = sb.toString();
        sb.setLength(0);
        for (RewriteDependency recipeDependency : rewriteDependencies) {
            sb.append("        rewrite('").append(recipeDependency.getGroupId()).append(":").append(recipeDependency.getArtifactId()).append(":").append(recipeDependency.getVersion()).append("')\n");
        }
        String dependency = sb.toString();
        sb.setLength(0);
        return String.format(configTemplate, "org.openrewrite.rewrite", "6.1.25", activeRevipes, dependency);
    }
}

