/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.html;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.inventory.AppPackage;
import com.ibm.ws.report.inventory.Archive;
import com.ibm.ws.report.inventory.ArchiveInventory;
import com.ibm.ws.report.inventory.UtilityJar;
import com.ibm.ws.report.inventory.qos.QosClusterTarget;
import com.ibm.ws.report.inventory.qos.QosDeploymentTargets;
import com.ibm.ws.report.inventory.qos.QosServerTarget;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.writer.ReportWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class HTMLInventoryReportWriter
implements ReportWriter {
    private static final int WIDE_CHART_THRESHOLD = 926;
    protected final ArchiveInventory inv;
    private SortedMap<String, String> scanOptions = null;
    private final List<String> arrayOfProjects;
    private final List<String> sharedLibProjectNames;
    private boolean isSingleApplication = false;
    private boolean hasSharedLibraries = false;
    private boolean hasPerformanceConsiderations = false;
    private boolean hasDetailsByArchiveTable = false;
    private boolean hasWebDetailsByArchiveTable = false;
    private String result = null;
    private static final String TREE_CHART_SCRIPT_LOCATION = "/resources/inventoryReportTreeChart.js";
    protected StringBuilder jsBuffer = new StringBuilder();
    private final boolean[] projectsWithCharts;
    private String treeChartJS = null;

    public HTMLInventoryReportWriter(ArchiveInventory inv, List<String> arrayOfProjects, List<String> sharedLibProjectNames, SortedMap<String, String> scanOptions) {
        this.inv = inv;
        this.scanOptions = scanOptions;
        this.arrayOfProjects = arrayOfProjects;
        this.sharedLibProjectNames = sharedLibProjectNames;
        this.hasSharedLibraries = sharedLibProjectNames.size() != 0;
        Collections.sort(this.arrayOfProjects);
        Collections.sort(this.sharedLibProjectNames);
        this.projectsWithCharts = new boolean[arrayOfProjects.size()];
        this.isSingleApplication = inv.getArchiveNames().size() == 1;
        this.treeChartJS = ReportUtility.loadFileAsString(TREE_CHART_SCRIPT_LOCATION);
    }

    @Override
    public String getResult() {
        return this.result;
    }

    @Override
    public void writeReport() {
        StringBuilder sb = new StringBuilder(65536);
        ReportUtility.writeHtmlTag(sb);
        ReportUtility.writeHeader(sb, Messages.getString("INVENTORY_REPORT_MAIN_TITLE"), Messages.getString("TECH_EVAL_REPORT_AUTHOR_BINARY_SCANNER"), true, 0);
        this.buildBody(sb);
        sb.append("</html>\n");
        this.result = sb.toString();
    }

    private void buildBody(StringBuilder sb) {
        String excludedFiles;
        sb.append("<body id=\"top\" class=\"inventory\">\n");
        sb.append("<div id=\"wrapper\" class=\"wrapper\" role=\"main\">\n");
        this.buildJumpTo(sb);
        sb.append("<h1>");
        sb.append(Messages.getString("INVENTORY_REPORT_MAIN_TITLE"));
        sb.append("</h1>\n");
        sb.append("<p class=\"date-time\"><span class=\"date\">");
        SimpleDateFormat localDateFormat = new SimpleDateFormat();
        sb.append(localDateFormat.format(new Date()));
        sb.append("</span></p>\n");
        sb.append("<p class=\"courier archivePath\">");
        int i = 0;
        while (i < this.arrayOfProjects.size() - 1) {
            sb.append(ReportUtility.encodeHTMLEntities(this.arrayOfProjects.get(i)));
            sb.append("<br>\n");
            ++i;
        }
        sb.append(ReportUtility.encodeHTMLEntities(this.arrayOfProjects.get(this.arrayOfProjects.size() - 1)));
        sb.append("</p>\n");
        if (this.scanOptions != null && this.scanOptions.keySet().size() > 0) {
            ReportUtility.writeOptions(sb, Messages.getString("ANALYSIS_REPORT_SCAN_OPTIONS_LABEL"), ReportUtility.getOptions(this.scanOptions, true));
            String excludedPackages = ReportUtility.encodeHTMLEntities((String)this.scanOptions.get("excludePackages"));
            String includedPackages = ReportUtility.encodeHTMLEntities((String)this.scanOptions.get("includePackages"));
            if (excludedPackages != null) {
                ReportUtility.writeOptions(sb, Messages.getString("ANALYSIS_REPORT_EXCLUDED_PACKAGES_LABEL"), excludedPackages);
            }
            if (includedPackages != null) {
                ReportUtility.writeOptions(sb, Messages.getString("ANALYSIS_REPORT_INCLUDED_PACKAGES_LABEL"), includedPackages);
            }
        }
        if ((excludedFiles = ReportUtility.encodeHTMLEntities((String)this.scanOptions.get("excludeFiles"))) != null) {
            ReportUtility.writeOptions(sb, Messages.getString("ANALYSIS_REPORT_EXCLUDED_FILES_LABEL"), excludedFiles);
        }
        if (this.hasSharedLibraries) {
            sb.append("<p>\n");
            sb.append("<b>").append(Messages.getString("INVENTORY_REPORT_SHARED_LIBRARIES_COLON")).append("</b>");
            sb.append("</p>\n");
            sb.append("<p class=\"courier\">");
            int i2 = 0;
            while (i2 < this.sharedLibProjectNames.size() - 1) {
                sb.append(ReportUtility.encodeHTMLEntities(this.sharedLibProjectNames.get(i2)));
                sb.append("<br>\n");
                ++i2;
            }
            sb.append(ReportUtility.encodeHTMLEntities(this.sharedLibProjectNames.get(this.sharedLibProjectNames.size() - 1)));
            sb.append("</p>\n");
        }
        this.buildTopLevelDashBoard(sb);
        sb.append("<div tabindex=\"0\"  id=\"inventoryDetailsByApp\" class=\"header-sections\">\n");
        sb.append("<h2>");
        sb.append(Messages.getString("INVENTORY_REPORT_INV_DETAILS_BY_APP"));
        sb.append("</h2>\n");
        sb.append("<div class=\"expand-collapse-holder noprint\">\n");
        if (this.isSingleApplication && this.inv.get(this.arrayOfProjects.get(0)).getTotalNumberOfArchives() == 0) {
            sb.append("<a href=\"#\" class=\"expand-all almighty disabled\">");
        } else {
            sb.append("<a href=\"#\" class=\"expand-all almighty\">");
        }
        sb.append(Messages.getString("ANALYSIS_REPORT_EXPAND_ALL"));
        sb.append("</a>\n");
        if (this.isSingleApplication) {
            sb.append("<a href=\"#\" class=\"collapse-all almighty\">");
        } else {
            sb.append("<a href=\"#\" class=\"collapse-all almighty disabled\">");
        }
        sb.append(Messages.getString("ANALYSIS_REPORT_COLLAPSE_ALL"));
        sb.append("</a>\n");
        sb.append("</div>\n");
        sb.append("</div>\n");
        sb.append("<div class=\"inventory-details-by-app clear\">\n");
        sb.append("  <ul>\n");
        int nthApp = 0;
        for (String nextProject : this.arrayOfProjects) {
            sb.append("<li id=\"app");
            sb.append(nthApp);
            sb.append("\" class=\"archive\">\n");
            Archive arc = this.inv.get(nextProject);
            this.buildArchiveDetails(sb, arc, true, true, nthApp++);
            sb.append("</li>\n");
        }
        sb.append("</ul>\n");
        sb.append("</div>\n");
        if (this.hasSharedLibraries) {
            this.buildSharedLibDetails(sb, false);
        }
        this.buildEmbeddedJS(sb);
        sb.append("</div>\n");
        sb.append("</body>\n");
    }

    protected void buildSharedLibDetails(StringBuilder sb, boolean consolidated) {
        sb.append(consolidated ? "<div class=\"header-sections horizontal-breaks\">\n" : "<div class=\"header-sections\">\n");
        sb.append("<h2 id=\"inventory_sharedLibDetails\">");
        sb.append(Messages.getString("INVENTORY_REPORT_SHARED_LIBRARY_DETAILS"));
        sb.append("</h2>\n");
        sb.append("</div>\n");
        LinkedHashSet<UtilityJar> utilitySet = new LinkedHashSet<UtilityJar>();
        Archive arc = this.inv.get(this.arrayOfProjects.get(0));
        for (Archive sharedLib : arc.getSharedLibraries()) {
            utilitySet.add((UtilityJar)sharedLib);
        }
        sb.append("<div>\n");
        this.buildUtilityJarBreakdown(sb, utilitySet, false, false);
        sb.append("</div>\n");
    }

    private void buildJumpTo(StringBuilder sb) {
        sb.append("<div class=\"nav-wrapper na-fixed noprint\" role=\"navigation\" aria-label=\"Report Navigation Menu\">\n");
        sb.append("  <nav class=\"jump-to-nav\" aria-label=\"Report Navigation Menu Links\">\n");
        sb.append("  <ul>\n");
        sb.append("    <li>\n");
        sb.append("<a href=\"#\">");
        sb.append(Messages.getString("INVENTORY_REPORT_JUMP_TO_APPLICATION"));
        sb.append("<div class=\"scroll-bottom-caret show\">v</div>");
        sb.append("</a>\n");
        sb.append("      <ul class=\"inner--list--hide\">\n");
        sb.append("        <li id=\"backToTopNav\">");
        sb.append("<a href=\"#top\" class=\"na-title jump-item\">");
        sb.append(Messages.getString("ANALYSIS_REPORT_BACK_TO_TOP"));
        sb.append("</a>");
        sb.append("</li>\n");
        sb.append("        <li><a href=\"#summary\" class=\"na-title jump-item\">");
        sb.append(Messages.getString("ANALYSIS_REPORT_SUMMARY"));
        sb.append("</a>");
        sb.append("</li>\n");
        sb.append("        <li><a href=\"#inventoryDetailsByApp\" class=\"na-title jump-item\">");
        sb.append(Messages.getString("INVENTORY_REPORT_INV_DETAILS_BY_APP"));
        sb.append("</a>");
        sb.append("</li>\n");
        int i = 0;
        for (String nextProject : this.arrayOfProjects) {
            sb.append("<li><a href=\"#app");
            sb.append(i);
            sb.append("\" class=\"jump-item\">");
            int index = nextProject.lastIndexOf(47);
            if (index > -1) {
                sb.append(ReportUtility.encodeHTMLEntities(nextProject.substring(index + 1)));
            } else {
                sb.append(ReportUtility.encodeHTMLEntities(nextProject));
            }
            sb.append("</a></li>\n");
            ++i;
        }
        sb.append("      </ul>\n");
        sb.append("    </li>\n");
        sb.append("  </ul>\n");
        sb.append("  </nav>\n");
        sb.append("</div>\n");
    }

    private void buildTopLevelDashBoard(StringBuilder sb) {
        int n;
        sb.append("<div class=\"recap\">\n");
        sb.append("  <ul>\n");
        ArchiveInventory.ArchiveTypes[] archiveTypesArray = ArchiveInventory.ArchiveTypes.values();
        int n2 = archiveTypesArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ArchiveInventory.ArchiveTypes arcType = archiveTypesArray[n3];
            sb.append("    <li>\n");
            sb.append("      <p class=\"flash__numbers bolden\">");
            if (arcType == ArchiveInventory.ArchiveTypes.UTILITY_JAR) {
                sb.append(this.inv.getArchiveCount(arcType) + this.inv.get(this.arrayOfProjects.get(0)).getSharedLibraries().size());
            } else {
                sb.append(this.inv.getArchiveCount(arcType));
            }
            sb.append("</p>\n");
            sb.append("      <p>");
            sb.append(arcType.toString());
            sb.append("</p>\n");
            sb.append("    </li>\n");
            ++n3;
        }
        sb.append("  </ul>\n");
        sb.append("</div>\n");
        sb.append("<div id=\"summary\" class=\"header-sections\">");
        sb.append("<h2>");
        sb.append(Messages.getString("ANALYSIS_REPORT_SUMMARY"));
        sb.append("</h2>\n");
        sb.append("</div>\n");
        sb.append("<div class=\"wrapSummary\">\n");
        sb.append("<div class=\"floating-box-medium\">\n");
        sb.append("<table summary=\"").append(Messages.getString("INVENTORY_REPORT_TABLE_SUMMARY_OVERALL_SUMMARY")).append("\">\n");
        sb.append("<tbody>\n");
        sb.append("<tr class=\"alternate-row\">\n");
        sb.append("<th>");
        sb.append(Messages.getString("INVENTORY_REPORT_TECHNOLOGY"));
        sb.append("</th>\n");
        sb.append("<th>");
        sb.append(Messages.getString("INVENTORY_REPORT_COUNT"));
        sb.append("</th>\n");
        sb.append("</tr>\n");
        int[] topLevelFieldCounts = new int[Archive.Fields.values().length];
        for (Archive arc : this.inv) {
            Archive.Fields[] fieldsArray = Archive.Fields.values();
            n = fieldsArray.length;
            int n4 = 0;
            while (n4 < n) {
                Archive.Fields f = fieldsArray[n4];
                int n5 = f.ordinal();
                topLevelFieldCounts[n5] = topLevelFieldCounts[n5] + arc.getFieldTotal(f);
                ++n4;
            }
        }
        int row = 1;
        int webServiceTotal = 0;
        int springBeanTotal = 0;
        Archive.Fields[] fieldsArray = Archive.Fields.values();
        int n6 = fieldsArray.length;
        n = 0;
        while (n < n6) {
            Archive.Fields f = fieldsArray[n];
            if (f.isWebService()) {
                webServiceTotal += topLevelFieldCounts[f.ordinal()];
            } else if (f.isSpringBean()) {
                springBeanTotal += topLevelFieldCounts[f.ordinal()];
            } else {
                sb.append("<tr");
                sb.append(row % 2 == 0 ? " class=\"alternate-row\"" : "");
                sb.append(">\n");
                sb.append("<td>");
                sb.append(this.getTableHeaderString(f));
                sb.append("</td>\n");
                sb.append("<td>");
                sb.append(topLevelFieldCounts[f.ordinal()]);
                sb.append("</td>\n");
                sb.append("</tr>\n");
                ++row;
            }
            ++n;
        }
        sb.append("<tr");
        sb.append(row % 2 == 0 ? " class=\"alternate-row\"" : "");
        sb.append(">\n");
        sb.append("<td>");
        sb.append(ReportUtility.replace(Messages.getString("INVENTORY_REPORT_WEB_SERVICES"), "-", "-<wbr>"));
        sb.append("</td>\n");
        sb.append("<td>");
        sb.append(webServiceTotal);
        sb.append("</td>\n");
        sb.append("</tr>\n");
        ++row;
        if (springBeanTotal > 0) {
            sb.append("<tr");
            sb.append(row % 2 == 0 ? " class=\"alternate-row\"" : "");
            sb.append(">\n");
            sb.append("<td>");
            sb.append(ReportUtility.replace(Messages.getString("INVENTORY_REPORT_SPRING_BEANS"), "-", "-<wbr>"));
            sb.append("</td>\n");
            sb.append("<td>");
            sb.append(springBeanTotal);
            sb.append("</td>\n");
            sb.append("</tr>\n");
            ++row;
        }
        sb.append("</tbody>\n");
        sb.append("</table>\n");
        sb.append("</div>\n");
        sb.append("</div>\n");
    }

    private void buildArchiveDetails(StringBuilder sb, Archive arc, boolean isTopLevelArchive, boolean useAlternateColorScheme, int nthApp) {
        assert (arc.getArchiveType() != ArchiveInventory.ArchiveTypes.UTILITY_JAR);
        sb.append("<div class=\"archive-title\">\n");
        sb.append("<h3>");
        sb.append(ReportUtility.encodeHTMLEntities(arc.getName()));
        sb.append("</h3>\n");
        sb.append("<div class=\"js-toggle-actions noprint\">\n");
        sb.append("<a href=\"#\" class=\"recommendation-toggle archive-toggle\">");
        if (this.isSingleApplication && isTopLevelArchive) {
            sb.append(Messages.getString("INVENTORY_REPORT_CLOSE_DETAILS"));
        } else {
            sb.append(Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
        }
        sb.append("</a>\n");
        sb.append("</div>\n");
        sb.append("</div>\n");
        sb.append("<div class=\"archive-details shared");
        if (!this.isSingleApplication || !isTopLevelArchive) {
            sb.append(" hide");
        }
        sb.append("\">\n");
        this.buildArchiveDetailsContent(sb, arc, isTopLevelArchive, useAlternateColorScheme, nthApp);
        sb.append("</div>\n");
    }

    protected void buildArchiveDetailsContent(StringBuilder sb, Archive arc, boolean isTopLevelArchive, boolean useAlternateColorScheme, int nthApp) {
        long arcSize;
        String arcChecksum;
        String springSchemaVersions;
        this.addAppAttributes(sb, "INVENTORY_REPORT_ARCHIVE_TYPE", arc.getArchiveType().getType());
        String version = arc.getVersion();
        if (version == null) {
            version = Messages.getString("INVENTORY_REPORT_UNSPECIFIED_ATTRIBUTE");
        }
        this.addAppAttributes(sb, "INVENTORY_REPORT_ARCHIVE_VERSION", version);
        String metadataComplete = arc.getMetadataComplete();
        if (metadataComplete == null) {
            metadataComplete = Messages.getString("INVENTORY_REPORT_UNSPECIFIED_ATTRIBUTE");
        } else if (metadataComplete.equals("ignored")) {
            metadataComplete = Messages.getString("INVENTORY_REPORT_IGNORED_ATTRIBUTE");
        }
        this.addAppAttributes(sb, "INVENTORY_REPORT_METADATA_COMPLETE", metadataComplete);
        String springManifestVersions = arc.getSpringManifestVersionsString();
        if (springManifestVersions != null) {
            this.addAppAttributes(sb, "INVENTORY_REPORT_ARCHIVE_SPRING_MANIFEST_VERSION", springManifestVersions);
        }
        if ((springSchemaVersions = arc.getSpringSchemaVersionsString()) != null) {
            this.addAppAttributes(sb, "INVENTORY_REPORT_ARCHIVE_SPRING_SCHEMA_VERSION", springSchemaVersions);
        }
        if ((arcChecksum = arc.getChecksum()) != null) {
            this.addAppAttributes(sb, "INVENTORY_REPORT_ARCHIVE_CHECKSUM", arcChecksum);
        }
        if ((arcSize = arc.getArchiveSize()) != 0L) {
            String[] sizes = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
            String archiveSize = null;
            int count = 0;
            while (arcSize / 1024L != 0L) {
                arcSize = Math.round((double)arcSize / 1024.0);
                ++count;
            }
            archiveSize = count > sizes.length - 1 ? String.valueOf(arcSize) : String.valueOf(String.valueOf(arcSize)) + " " + sizes[count];
            this.addAppAttributes(sb, "INVENTORY_REPORT_ARCHIVE_SIZE", archiveSize);
        }
        int numSubArchives = arc.getSubArchives().size();
        this.buildArchiveQuantities(sb, arc, useAlternateColorScheme);
        if (isTopLevelArchive && numSubArchives > 0) {
            this.buildRaveTree(sb, arc, nthApp, isTopLevelArchive);
        }
        this.buildSummary(sb, arc, isTopLevelArchive, nthApp);
        if (isTopLevelArchive) {
            if (arc.hasIssues()) {
                this.buildAppProblemBreakdown(sb, arc, isTopLevelArchive, nthApp);
            }
            this.buildOperationalConsiderations(sb, arc);
            Set<String> metadataSuggestionArchives = arc.getMetadataSuggestions(false);
            TreeMap<String, String> excessClassArchiveMap = arc.getArchivesWithExcessFiles(Archive.ExcessFileType.EXCESS_CLASS);
            TreeMap<String, String> excessWebModuleResourcesArchiveMap = arc.getArchivesWithExcessFiles(Archive.ExcessFileType.EXCESS_WEB_MODULE_RESOURCE);
            if (!(metadataSuggestionArchives.isEmpty() && excessClassArchiveMap.isEmpty() && excessWebModuleResourcesArchiveMap.isEmpty())) {
                boolean isWAR = arc.getArchiveType() == ArchiveInventory.ArchiveTypes.WAR;
                this.buildPerformanceConsiderations(sb, metadataSuggestionArchives, excessClassArchiveMap, excessWebModuleResourcesArchiveMap, arc.getName(), isWAR);
                this.hasPerformanceConsiderations = true;
            }
        }
        if (arc.getSubArchives().size() > 0) {
            TreeSet<UtilityJar> utilitySet = new TreeSet<UtilityJar>(new Comparator<UtilityJar>(){

                @Override
                public int compare(UtilityJar a1, UtilityJar a2) {
                    return a1.getName().compareToIgnoreCase(a2.getName());
                }
            });
            sb.append("<div class=\"horizontal-breaks\">\n");
            String inventoryCA = this.isSingleApplication ? "<h2 id=\"inventory_CA\">" : "<h2 id=\"inventory_CA_" + ReportUtility.encodeHTMLEntities(arc.getName()) + "\">";
            sb.append(isTopLevelArchive ? inventoryCA : "<h2>");
            sb.append(Messages.getString("INVENTORY_REPORT_CONTAINED_ARCHIVES"));
            sb.append("</h2>\n");
            sb.append("<ul>\n");
            for (Archive subArc : arc.getSubArchives()) {
                if (subArc.getArchiveType() != ArchiveInventory.ArchiveTypes.UTILITY_JAR) {
                    if (useAlternateColorScheme) {
                        sb.append("<li class=\"archive alternate\">\n");
                    } else {
                        sb.append("<li class=\"archive\">\n");
                    }
                    this.buildArchiveDetails(sb, subArc, false, !useAlternateColorScheme, -1);
                    sb.append("</li>\n");
                    continue;
                }
                utilitySet.add((UtilityJar)subArc);
            }
            if (!utilitySet.isEmpty()) {
                if (useAlternateColorScheme) {
                    sb.append("<li class=\"archive alternate\">\n");
                } else {
                    sb.append("<li class=\"archive\">\n");
                }
                this.buildUtilityJarBreakdown(sb, utilitySet, !useAlternateColorScheme, true);
                sb.append("</li>\n");
            }
            sb.append("</ul>\n");
            sb.append("</div>\n");
        }
    }

    private void addAppAttributes(StringBuilder sb, String message, String value) {
        sb.append("<div class=\"archive-info\">");
        sb.append(Messages.getFormattedMessage(Messages.getString(message), value));
        sb.append("</div>\n");
    }

    protected boolean hasProblemConsideration() {
        return this.hasPerformanceConsiderations;
    }

    protected boolean hasDetailsByArchiveTable() {
        return this.hasDetailsByArchiveTable;
    }

    protected boolean hasWebDetailsByArchiveTable() {
        return this.hasWebDetailsByArchiveTable;
    }

    private void buildArchiveQuantities(StringBuilder sb, Archive arc, boolean useAlternateColorScheme) {
        if (useAlternateColorScheme) {
            sb.append("<div class=\"recap recap-alternate\">\n");
        } else {
            sb.append("<div class=\"recap\">\n");
        }
        sb.append("<ul>\n");
        ArchiveInventory.ArchiveTypes[] containedArchiveTypes = ArchiveInventory.ArchiveTypes.getAllowedArchiveTypes(arc.getArchiveType());
        if (containedArchiveTypes.length > 0 && !ArchiveInventory.ArchiveTypes.isJarArchiveType(arc.getArchiveType())) {
            ArchiveInventory.ArchiveTypes[] archiveTypesArray = ArchiveInventory.ArchiveTypes.values();
            int n = archiveTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArchiveInventory.ArchiveTypes arcType = archiveTypesArray[n2];
                if (arc.getArchiveType().canContain(arcType)) {
                    sb.append("<li>\n");
                    sb.append("<p class=\"flash__numbers bolden\">");
                    sb.append(arc.getArchiveCount(arcType));
                    sb.append("</p>\n");
                    sb.append("<p>");
                    sb.append(arcType.toString());
                    sb.append("</p>\n");
                    sb.append("</li>\n");
                }
                ++n2;
            }
        }
        sb.append("</ul>\n");
        sb.append("</div>\n");
    }

    private void buildSummary(StringBuilder sb, Archive arc, boolean isTopLevelArchive, int nthApp) {
        int totalCount = 0;
        if (isTopLevelArchive) {
            sb.append(this.isSingleApplication ? "<h2 id=\"inventory_Summary\">" : "<h2 id=\"inventory_Summary_" + ReportUtility.encodeHTMLEntities(arc.getName()) + "\">");
            sb.append(Messages.getString("ANALYSIS_REPORT_SUMMARY"));
            sb.append("</h2>\n");
            sb.append("<div class=\"wrapSummary\">\n");
            sb.append("<div class=\"floating-box-narrow\">\n");
        } else {
            sb.append("<div class=\"wrapSummary\">\n");
            sb.append("<h2>");
            sb.append(Messages.getString("ANALYSIS_REPORT_SUMMARY"));
            sb.append("</h2>\n");
            sb.append("<div class=\"floating-box-medium\">\n");
        }
        sb.append("<table summary=\"").append(Messages.getString("INVENTORY_REPORT_TABLE_SUMMARY_ARCHIVE_SUMMARY")).append("\">\n");
        sb.append("<tbody>\n");
        sb.append("<tr class=\"alternate-row\">\n");
        sb.append("<th>");
        sb.append(Messages.getString("INVENTORY_REPORT_TECHNOLOGY"));
        sb.append("</th>\n");
        sb.append("<th>");
        sb.append(Messages.getString("INVENTORY_REPORT_COUNT"));
        sb.append("</th>\n");
        sb.append("</tr>\n");
        int row = 1;
        int webServiceTotal = 0;
        int springBeanCount = 0;
        LinkedHashMap<Archive.Fields, Integer> webDetailsMap = new LinkedHashMap<Archive.Fields, Integer>();
        int count = 0;
        Archive.Fields[] fieldsArray = Archive.Fields.values();
        int n = fieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Archive.Fields f = fieldsArray[n2];
            count = arc.getFieldTotal(f);
            totalCount += count;
            if (f.isWebService()) {
                webServiceTotal += count;
                webDetailsMap.put(f, count);
            } else if (f.isSpringBean()) {
                springBeanCount = count;
            } else {
                if (row % 2 == 0) {
                    sb.append("<tr class=\"alternate-row\">\n");
                } else {
                    sb.append("<tr>\n");
                }
                sb.append("<td>");
                sb.append(this.getTableHeaderString(f));
                sb.append("</td>\n");
                sb.append("<td>");
                sb.append(count);
                sb.append("</td>\n");
                sb.append("</tr>\n");
                ++row;
            }
            ++n2;
        }
        if (webServiceTotal != 0 && !isTopLevelArchive) {
            for (Archive.Fields key : webDetailsMap.keySet()) {
                if (row % 2 == 0) {
                    sb.append("<tr class=\"alternate-row\">\n");
                } else {
                    sb.append("<tr>\n");
                }
                sb.append("<td>");
                sb.append(this.getTableHeaderString(key));
                sb.append("</td>\n");
                sb.append("<td>");
                sb.append(webDetailsMap.get((Object)key));
                sb.append("</td>\n");
                sb.append("</tr>\n");
                ++row;
            }
        } else {
            if (row % 2 == 0) {
                sb.append("<tr class=\"alternate-row\">\n");
            } else {
                sb.append("<tr>\n");
            }
            sb.append("<td>");
            sb.append(ReportUtility.replace(Messages.getString("INVENTORY_REPORT_WEB_SERVICES"), "-", "-<wbr>"));
            sb.append("</td>\n");
            sb.append("<td>");
            sb.append(webServiceTotal);
            sb.append("</td>\n");
            sb.append("</tr>\n");
            ++row;
        }
        if (springBeanCount > 0) {
            if (row % 2 == 0) {
                sb.append("<tr class=\"alternate-row\">\n");
            } else {
                sb.append("<tr>\n");
            }
            sb.append("<td>");
            sb.append(ReportUtility.replace(Messages.getString("INVENTORY_REPORT_SPRING_BEANS"), "-", "-<wbr>"));
            sb.append("</td>\n");
            sb.append("<td>");
            sb.append(springBeanCount);
            sb.append("</td>\n");
            sb.append("</tr>\n");
            ++row;
        }
        sb.append("</tbody>\n");
        sb.append("</table>\n");
        sb.append("</div>\n");
        if (nthApp >= 0 && totalCount > 0) {
            this.projectsWithCharts[nthApp] = true;
        }
        if (isTopLevelArchive) {
            if (this.projectsWithCharts[nthApp]) {
                this.buildBarChart(sb, arc, nthApp);
            }
            sb.append("</div>\n");
            this.buildDataTable(sb, arc);
        } else {
            sb.append("</div>\n");
        }
    }

    private void buildRaveTree(StringBuilder sb, Archive arc, int nthApp, boolean isTopLevelArchive) {
        assert (nthApp >= 0);
        if (this.treeChartJS != null) {
            int totalLevels;
            String treeId = "tree" + nthApp;
            sb.append("<div>");
            sb.append("<p>");
            sb.append(Messages.getString("INVENTORY_REPORT_RAVE_HIGHLIGHT"));
            sb.append("</p>");
            sb.append("</div>");
            sb.append("<div class=\"treeKey\">");
            sb.append("<ul>");
            sb.append("<li><span class=\"rectangle dup\"></span>");
            sb.append("(1) ");
            sb.append(Messages.getString("INVENTORY_REPORT_DUPLICATE"));
            sb.append("</li>");
            sb.append("<li><span class=\"rectangle javaee\"></span>");
            sb.append("(2) ");
            sb.append(Messages.getString("INVENTORY_REPORT_JAVAEE"));
            sb.append("</li>");
            sb.append("<li><span class=\"rectangle thirdparty\"></span>");
            sb.append("(3) ");
            sb.append(Messages.getString("INVENTORY_REPORT_OSS"));
            sb.append("</li>");
            sb.append("<li><span class=\"rectangle websphere\"></span>");
            sb.append("(4) ");
            sb.append(Messages.getString("INVENTORY_REPORT_WS"));
            sb.append("</li>");
            sb.append("<li><span class=\"rectangle unused\"></span>");
            sb.append("(5) ");
            sb.append(Messages.getString("INVENTORY_REPORT_UNUSED"));
            sb.append("</li>");
            sb.append("<li><span class=\"rectangle missing\"></span>");
            sb.append("(6) ");
            sb.append(Messages.getString("INVENTORY_REPORT_MISSING"));
            sb.append("</li>");
            sb.append("</ul>");
            sb.append("<div id=\"");
            sb.append(treeId);
            sb.append("\" class=\"trees\"></div>\n");
            sb.append("</div>");
            int height = 600;
            int width = 1280;
            int totalArchives = arc.getTotalArchiveCount();
            if (totalArchives > 30) {
                height = totalArchives * 20;
            }
            if ((totalLevels = arc.getTotalLevelsOfDescendants()) > 3) {
                width += (totalLevels - 3) * 300;
            }
            StringBuilder treeSB = new StringBuilder();
            this.buildTreeJson(treeSB, arc, isTopLevelArchive, 0);
            String text = arc.getRaveTreeName();
            int leftIndent = text.length() * 7 + 12;
            String js = this.treeChartJS.replace("TREE_ID", treeId);
            js = js.replace("TREE_INDENT", Integer.toString(leftIndent));
            js = js.replace("TREE_HEIGHT", Integer.toString(height));
            js = js.replace("TREE_WIDTH", Integer.toString(width));
            js = js.replace("TREE_ROOT_NAME", ReportUtility.encodeJSEntities(text));
            js = js.replace("TREE_CONTENT", treeSB);
            this.jsBuffer.append(js);
        }
    }

    private void buildTreeJson(StringBuilder sb, Archive arc, boolean isTopLevelArchive, int level) {
        boolean hasIssue = false;
        sb.append("\"name\":\"");
        sb.append(ReportUtility.encodeJSEntities(arc.getName()));
        StringBuilder nameSB = new StringBuilder();
        if (arc.getArchiveIssueCount(AppPackage.Issue.DUPLICATE_CLASS) > 0) {
            nameSB.append(" (1");
            hasIssue = true;
        }
        if (arc.getArchiveIssueCount(AppPackage.Issue.JAVA_EE_SE_CLASS) > 0) {
            this.buildIssueKey(nameSB, hasIssue, "2");
            hasIssue = true;
        }
        if (arc.getArchiveIssueCount(AppPackage.Issue.OSS_CLASS) > 0) {
            this.buildIssueKey(nameSB, hasIssue, "3");
            hasIssue = true;
        }
        if (arc.getArchiveIssueCount(AppPackage.Issue.WAS_CLASS) > 0) {
            this.buildIssueKey(nameSB, hasIssue, "4");
            hasIssue = true;
        }
        if (arc.getArchiveIssueCount(AppPackage.Issue.UNUSED_ARCHIVES) > 0) {
            this.buildIssueKey(nameSB, hasIssue, "5");
            hasIssue = true;
        }
        if (arc.getArchiveIssueCount(AppPackage.Issue.MISSING_DEP) > 0) {
            this.buildIssueKey(nameSB, hasIssue, "6");
            hasIssue = true;
        }
        if (hasIssue) {
            nameSB.append(")");
            arc.setRaveTreeName(String.valueOf(arc.getName()) + nameSB.toString());
        }
        sb.append("\",\n");
        sb.append("\"issues\":\"");
        sb.append((CharSequence)nameSB);
        sb.append("\",\n");
        if (arc.getSubArchives().size() > 0) {
            sb.append("\"children\": [\n");
            for (Archive subArc : arc.getSubArchives()) {
                sb.append("{\n");
                this.buildTreeJson(sb, subArc, isTopLevelArchive, level + 1);
                sb.append("},\n");
            }
            if (level == 0 && !arc.getSharedLibraries().isEmpty()) {
                sb.append("{\n");
                sb.append("\"name\":\"").append(Messages.getString("INVENTORY_REPORT_SHARED_LIBRARIES")).append("\",\n");
                sb.append("\"issues\":\"\",\n");
                sb.append("\"children\": [\n");
                for (Archive sharedLibArc : arc.getSharedLibraries()) {
                    sb.append("{\n");
                    this.buildTreeJson(sb, sharedLibArc, isTopLevelArchive, level + 1);
                    sb.append("},\n");
                }
                sb.append("]\n");
                sb.append("},\n");
            }
            sb.append("]\n");
        }
    }

    private void buildIssueKey(StringBuilder sb, boolean hasIssue, String num) {
        if (!hasIssue) {
            sb.append(" (");
        } else {
            sb.append(",");
        }
        sb.append(num);
    }

    private void buildBarChart(StringBuilder sb, Archive arc, int nthApp) {
        int width;
        int n;
        assert (nthApp >= 0);
        boolean isWar = arc.getArchiveType() == ArchiveInventory.ArchiveTypes.WAR;
        this.jsBuffer.append("barChartArray.push({\n");
        boolean barEmpty = true;
        ArrayList<String> listOfExcludedArchives = new ArrayList<String>();
        int numBars = arc.getTotalNumberOfArchives();
        this.jsBuffer.append("labels: [");
        if (isWar) {
            Archive.Fields[] fieldsArray = Archive.Fields.values();
            n = fieldsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Archive.Fields f = fieldsArray[n2];
                if (arc.getField(f) > 0) {
                    barEmpty = false;
                    break;
                }
                ++n2;
            }
            ++numBars;
            if (!barEmpty) {
                this.jsBuffer.append("\"");
                this.jsBuffer.append(ReportUtility.encodeJSEntities(arc.getName()));
                this.jsBuffer.append("\", ");
            } else {
                listOfExcludedArchives.add(arc.getFullName());
            }
        }
        for (Archive subArc : arc.getSubArchives()) {
            barEmpty = true;
            Archive.Fields[] fieldsArray = Archive.Fields.values();
            int n3 = fieldsArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Archive.Fields f = fieldsArray[n4];
                if (subArc.getFieldTotal(f) > 0) {
                    barEmpty = false;
                    break;
                }
                ++n4;
            }
            if (!barEmpty) {
                this.jsBuffer.append("\"");
                this.jsBuffer.append(ReportUtility.encodeJSEntities(subArc.getName()));
                this.jsBuffer.append("\", ");
                continue;
            }
            listOfExcludedArchives.add(subArc.getFullName());
        }
        if ((width = 68 * ((numBars -= listOfExcludedArchives.size()) > 32 ? 32 : numBars)) < 926) {
            sb.append("<div class=\"floating-box-wide fixedCanvasContainer\">\n");
            sb.append("<canvas id=\"canvas");
            sb.append(nthApp);
            sb.append("\" class=\"fixedCanvas\"></canvas>\n");
            sb.append("</div>\n");
        } else {
            sb.append("<div style=\"overflow-y: scroll;\" class=\"floating-box-wider\">\n");
            sb.append("<div style=\"width: ");
            sb.append(width);
            sb.append("px;\">\n");
            sb.append("<canvas id=\"canvas");
            sb.append(nthApp);
            sb.append("\"></canvas>\n");
            sb.append("</div>\n");
            sb.append("</div>\n");
        }
        this.jsBuffer.append("],\n");
        this.jsBuffer.append("maintainAspectRatio: " + String.valueOf(width >= 926) + ",\n");
        this.jsBuffer.append("datasets: [\n");
        Archive.Fields[] fieldsArray = Archive.Fields.values();
        int n5 = fieldsArray.length;
        n = 0;
        while (n < n5) {
            Archive.Fields f = fieldsArray[n];
            if (arc.getFieldTotal(f) > 0) {
                this.jsBuffer.append("{\n");
                this.jsBuffer.append("label: '");
                this.jsBuffer.append(f.toString());
                this.jsBuffer.append("',\n");
                this.jsBuffer.append("backgroundColor: \"");
                this.jsBuffer.append(f.getColor());
                this.jsBuffer.append("\",\n");
                this.jsBuffer.append("data: [");
                if (isWar && !listOfExcludedArchives.contains(arc.getFullName())) {
                    this.jsBuffer.append(arc.getField(f));
                    this.jsBuffer.append(", ");
                }
                for (Archive subArc : arc.getSubArchives()) {
                    if (listOfExcludedArchives.contains(subArc.getFullName())) continue;
                    this.jsBuffer.append(subArc.getFieldTotal(f));
                    this.jsBuffer.append(", ");
                }
                this.jsBuffer.append("]\n");
                this.jsBuffer.append("},\n");
            }
            ++n;
        }
        this.jsBuffer.append("]\n");
        this.jsBuffer.append("});\n");
    }

    private void buildDataTable(StringBuilder sb, Archive arc) {
        boolean allFieldsZero;
        StringBuilder archiveDetails = new StringBuilder();
        archiveDetails.append(this.isSingleApplication ? "<h2 id=\"inventory_Details\">" : "<h2 id=\"inventory_Details_" + ReportUtility.encodeHTMLEntities(arc.getName()) + "\">");
        archiveDetails.append(Messages.getString("INVENTORY_REPORT_INV_DETAILS_BY_ARCHIVE"));
        archiveDetails.append("</h2>\n");
        archiveDetails.append("<table summary=\"").append(Messages.getString("INVENTORY_REPORT_TABLE_SUMMARY_INV_DETAILS")).append("\">\n");
        archiveDetails.append("<thead>\n");
        archiveDetails.append("<tr class=\"alternate-row\">\n");
        archiveDetails.append("<th>");
        archiveDetails.append(Messages.getString("INVENTORY_REPORT_ARCHIVE_LABEL"));
        archiveDetails.append("</th>\n");
        boolean foundNonZeroWebService = false;
        boolean zeroSpringBeans = false;
        Archive.Fields[] fieldsArray = Archive.Fields.values();
        int n = fieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Archive.Fields f = fieldsArray[n2];
            if (f.isWebService()) {
                foundNonZeroWebService = arc.getFieldTotal(f) > 0 ? true : foundNonZeroWebService;
            } else if (f.isSpringBean()) {
                if (arc.getFieldTotal(f) == 0) {
                    zeroSpringBeans = true;
                }
            } else {
                archiveDetails.append("<th>");
                archiveDetails.append(this.getTableHeaderString(f));
                archiveDetails.append("</th>\n");
            }
            ++n2;
        }
        if (!foundNonZeroWebService) {
            archiveDetails.append("<th>");
            archiveDetails.append(ReportUtility.replace(Messages.getString("INVENTORY_REPORT_WEB_SERVICES"), "-", "-<wbr>"));
            archiveDetails.append("</th>\n");
        }
        if (!zeroSpringBeans) {
            archiveDetails.append("<th>");
            archiveDetails.append(ReportUtility.replace(Messages.getString("INVENTORY_REPORT_SPRING_BEANS"), "-", "-<wbr>"));
            archiveDetails.append("</th>\n");
        }
        archiveDetails.append("</tr>\n");
        archiveDetails.append("</thead>\n");
        int row = 1;
        archiveDetails.append("<tbody>\n");
        if (arc.getArchiveType() == ArchiveInventory.ArchiveTypes.WAR) {
            allFieldsZero = true;
            StringBuilder rowInfo = new StringBuilder();
            rowInfo.append("<tr>\n");
            rowInfo.append("<td>");
            rowInfo.append(ReportUtility.encodeHTMLEntities(arc.getName()));
            rowInfo.append("</td>\n");
            Archive.Fields[] fieldsArray2 = Archive.Fields.values();
            int n3 = fieldsArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Archive.Fields f = fieldsArray2[n4];
                if (!f.isWebService() && !f.isSpringBean()) {
                    int count = arc.getField(f);
                    rowInfo.append("<td>");
                    rowInfo.append(count);
                    rowInfo.append("</td>\n");
                    allFieldsZero = count > 0 ? false : allFieldsZero;
                }
                ++n4;
            }
            if (!foundNonZeroWebService) {
                rowInfo.append("<td>");
                rowInfo.append(0);
                rowInfo.append("</td>\n");
            }
            if (!zeroSpringBeans) {
                rowInfo.append("<td>");
                rowInfo.append(arc.getFieldTotal(Archive.Fields.SPRING_BEANS));
                rowInfo.append("</td>\n");
            }
            rowInfo.append("</tr>\n");
            if (!allFieldsZero) {
                archiveDetails.append((CharSequence)rowInfo);
                ++row;
            }
        }
        for (Archive subArc : arc.getSubArchives()) {
            allFieldsZero = true;
            StringBuilder rowInfo = new StringBuilder();
            if (row % 2 == 0) {
                rowInfo.append("<tr class=\"alternate-row\">\n");
            } else {
                rowInfo.append("<tr>\n");
            }
            rowInfo.append("<td>");
            rowInfo.append(ReportUtility.encodeHTMLEntities(subArc.getName()));
            rowInfo.append("</td>\n");
            Archive.Fields[] fieldsArray3 = Archive.Fields.values();
            int n5 = fieldsArray3.length;
            int n6 = 0;
            while (n6 < n5) {
                Archive.Fields f = fieldsArray3[n6];
                if (!f.isWebService() && !f.isSpringBean()) {
                    int count = subArc.getFieldTotal(f);
                    rowInfo.append("<td>");
                    rowInfo.append(count);
                    rowInfo.append("</td>\n");
                    allFieldsZero = count > 0 ? false : allFieldsZero;
                }
                ++n6;
            }
            if (!foundNonZeroWebService) {
                rowInfo.append("<td>");
                rowInfo.append(0);
                rowInfo.append("</td>\n");
            }
            if (!zeroSpringBeans) {
                rowInfo.append("<td>");
                rowInfo.append(subArc.getField(Archive.Fields.SPRING_BEANS));
                rowInfo.append("</td>\n");
            }
            rowInfo.append("</tr>\n");
            if (allFieldsZero) continue;
            archiveDetails.append((CharSequence)rowInfo);
            ++row;
        }
        archiveDetails.append("</tbody>\n");
        archiveDetails.append("</table>\n");
        if (row > 1) {
            this.hasDetailsByArchiveTable = true;
            sb.append((CharSequence)archiveDetails);
        }
        if (foundNonZeroWebService) {
            this.hasWebDetailsByArchiveTable = true;
            this.buildWebServiceBreakdown(sb, arc);
        }
    }

    private String getTableHeaderString(Archive.Fields f) {
        return ReportUtility.replace(f.toString(), "-", "-<wbr>");
    }

    private void buildWebServiceBreakdown(StringBuilder sb, Archive arc) {
        StringBuilder webArchiveDetails = new StringBuilder();
        webArchiveDetails.append(this.isSingleApplication ? "<h2 id=\"inventory_WebDetails\">" : "<h2 id=\"inventory_WebDetails_" + ReportUtility.encodeHTMLEntities(arc.getName()) + "\">");
        webArchiveDetails.append(Messages.getString("INVENTORY_REPORT_WEB_SERVICE_DETAILS_BY_ARCHIVE"));
        webArchiveDetails.append("</h2>\n");
        EnumSet<Archive.Fields> webServices = Archive.Fields.getWebServiceFields();
        webArchiveDetails.append("<table summary=\"").append(Messages.getString("INVENTORY_REPORT_TABLE_SUMMARY_WEB_SERVICE_DETAILS")).append("\">\n");
        webArchiveDetails.append("<thead>\n");
        webArchiveDetails.append("<tr class=\"alternate-row\">\n");
        webArchiveDetails.append("<th>");
        webArchiveDetails.append(Messages.getString("INVENTORY_REPORT_ARCHIVE_LABEL"));
        webArchiveDetails.append("</th>\n");
        for (Archive.Fields f : webServices) {
            webArchiveDetails.append("<th>");
            webArchiveDetails.append(this.getTableHeaderString(f));
            webArchiveDetails.append("</th>\n");
        }
        webArchiveDetails.append("</tr>\n");
        webArchiveDetails.append("</thead>\n");
        webArchiveDetails.append("<tbody>\n");
        int row = 1;
        boolean allFieldsZero = true;
        StringBuilder rowInfo = new StringBuilder();
        rowInfo.append("<tr>\n");
        rowInfo.append("<td>");
        rowInfo.append(ReportUtility.encodeHTMLEntities(arc.getName()));
        rowInfo.append("</td>\n");
        for (Archive.Fields f : webServices) {
            int count = arc.getField(f);
            rowInfo.append("<td>");
            rowInfo.append(count);
            rowInfo.append("</td>\n");
            boolean bl = allFieldsZero = count > 0 ? false : allFieldsZero;
        }
        rowInfo.append("</tr>\n");
        if (!allFieldsZero) {
            webArchiveDetails.append((CharSequence)rowInfo);
            ++row;
        }
        for (Archive subArc : arc.getSubArchives()) {
            allFieldsZero = true;
            rowInfo = new StringBuilder();
            if (row % 2 == 0) {
                rowInfo.append("<tr class=\"alternate-row\">\n");
            } else {
                rowInfo.append("<tr>\n");
            }
            rowInfo.append("<td>");
            rowInfo.append(ReportUtility.encodeHTMLEntities(subArc.getName()));
            rowInfo.append("</td>\n");
            for (Archive.Fields f : webServices) {
                int count = subArc.getFieldTotal(f);
                rowInfo.append("<td>");
                rowInfo.append(count);
                rowInfo.append("</td>\n");
                boolean bl = allFieldsZero = count > 0 ? false : allFieldsZero;
            }
            rowInfo.append("</tr>\n");
            if (allFieldsZero) continue;
            webArchiveDetails.append((CharSequence)rowInfo);
            ++row;
        }
        webArchiveDetails.append("</tbody>\n");
        webArchiveDetails.append("</table>\n");
        if (row > 1) {
            sb.append((CharSequence)webArchiveDetails);
        }
    }

    private void buildAppProblemBreakdown(StringBuilder sb, Archive arc, boolean isTopLevelArchive, int nthApp) {
        sb.append("<div class=\"horizontal-breaks\">\n");
        sb.append(this.isSingleApplication ? "<h2 id=\"inventory_PDP\">" : "<h2 id=\"inventory_PDP_" + ReportUtility.encodeHTMLEntities(arc.getName()) + "\">");
        sb.append(Messages.getString("INVENTORY_REPORT_PROBLEM_SECTION"));
        sb.append("</h2>\n");
        sb.append("<ul>\n");
        sb.append("<li class=\"problemSummary alternate\">\n");
        sb.append("<h3>");
        sb.append(Messages.getString("INVENTORY_REPORT_PROBLEM_SUMMARY"));
        sb.append("</h3>\n");
        sb.append("<div class=\"wrapSummary\">\n");
        sb.append("<div class=\"floating-box-medium\">");
        sb.append("<table summary=\"").append(Messages.getString("INVENTORY_REPORT_TABLE_SUMMARY_APP_PROBLEMS")).append("\">\n");
        sb.append("<tbody>\n");
        sb.append("<tr class=\"alternate-row\">\n");
        sb.append("<th>");
        sb.append(Messages.getString("INVENTORY_REPORT_PROBLEM_TYPE"));
        sb.append("</th>\n");
        sb.append("<th>");
        sb.append(Messages.getString("INVENTORY_REPORT_COUNT"));
        sb.append("</th>\n");
        sb.append("</tr>\n");
        sb.append("<tr>\n");
        sb.append("<td>");
        sb.append(Messages.getString("INVENTORY_REPORT_DUP_PROBLEM_SUMMARY"));
        sb.append("</td>\n");
        sb.append("<td>");
        sb.append(arc.getArchiveCount(AppPackage.Issue.DUPLICATE_CLASS));
        sb.append("</td>\n");
        sb.append("</tr>\n");
        sb.append("<tr class=\"alternate-row\">\n");
        sb.append("<td>");
        sb.append(Messages.getString("INVENTORY_REPORT_JAVAEE_SE_PROBLEM_SUMMARY"));
        sb.append("</td>\n");
        sb.append("<td>");
        sb.append(arc.getArchiveCount(AppPackage.Issue.JAVA_EE_SE_CLASS));
        sb.append("</td>\n");
        sb.append("</tr>\n");
        sb.append("<tr>\n");
        sb.append("<td>");
        sb.append(Messages.getString("INVENTORY_REPORT_THIRD_PARTY_PROBLEM_SUMMARY"));
        sb.append("</td>\n");
        sb.append("<td>");
        sb.append(arc.getArchiveCount(AppPackage.Issue.OSS_CLASS));
        sb.append("</td>\n");
        sb.append("</tr>\n");
        sb.append("<tr class=\"alternate-row\">\n");
        sb.append("<td>");
        sb.append(Messages.getString("INVENTORY_REPORT_WEBSPHERE_CLASSES_PROBLEM_SUMMARY"));
        sb.append("</td>\n");
        sb.append("<td>");
        sb.append(arc.getArchiveCount(AppPackage.Issue.WAS_CLASS));
        sb.append("</td>\n");
        sb.append("</tr>\n");
        sb.append("<tr>\n");
        sb.append("<td>");
        sb.append(Messages.getString("INVENTORY_REPORT_UNUSED_ARCHIVES_PROBLEM_SUMMARY"));
        sb.append("</td>\n");
        sb.append("<td>");
        sb.append(arc.getArchiveCount(AppPackage.Issue.UNUSED_ARCHIVES));
        sb.append("</td>\n");
        sb.append("</tr>\n");
        sb.append("<tr class=\"alternate-row\">\n");
        sb.append("<td>");
        sb.append(Messages.getString("INVENTORY_REPORT_MISSING_DEPENDENCIES_PROBLEM_SUMMARY"));
        sb.append("</td>\n");
        sb.append("<td>");
        sb.append(arc.getArchiveCount(AppPackage.Issue.MISSING_DEP));
        sb.append("</td>\n");
        sb.append("</tr>\n");
        sb.append("<tr>\n");
        sb.append("<td>");
        sb.append(Messages.getString("INVENTORY_REPORT_SYSTEM_LEVEL_PROPERTIES_PROBLEM_SUMMARY"));
        sb.append("</td>\n");
        sb.append("<td>");
        sb.append(arc.getArchiveCount(AppPackage.Issue.SYSTEM_LEVEL_PROPERTIES));
        sb.append("</td>\n");
        sb.append("</tr>\n");
        if (this.hasSharedLibraries) {
            sb.append("<tr class=\"alternate-row\">\n");
            sb.append("<td>");
            sb.append(Messages.getString("INVENTORY_REPORT_SHARED_LIBRARY_DEPENDENCIES_PROBLEM_SUMMARY"));
            sb.append("</td>\n");
            sb.append("<td>");
            sb.append(arc.getArchiveCount(AppPackage.Issue.SHARED_LIB_DEPENDENCIES));
            sb.append("</td>\n");
            sb.append("</tr>\n");
        }
        sb.append("</tbody>\n");
        sb.append("</table>\n");
        sb.append("</div>");
        sb.append("</div>");
        sb.append("</li>");
        sb.append("<li class=\"archive alternate\">\n");
        sb.append("<div class=\"archive-title\">\n");
        sb.append("<h3>\n");
        sb.append(Messages.getString("INVENTORY_REPORT_PROBLEM_DETAILS"));
        sb.append("</h3>\n");
        sb.append("<div class=\"js-toggle-actions noprint\">");
        sb.append("<a href=\"#\" class=\"recommendation-toggle archive-toggle\">");
        sb.append(Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
        sb.append("</a>");
        sb.append("</div>\n");
        sb.append("</div>\n");
        sb.append("<div class=\"archive-details shared hide\">\n");
        LinkedHashMap<String, String> locationMapAcross = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> locationMapWithin = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> locationMapJavaEE = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> locationMapWS = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> locationMapOS = new LinkedHashMap<String, String>();
        HashMap<String, String> serversMapOS = new HashMap<String, String>();
        LinkedHashMap<String, String> locationMapMissingDeps = new LinkedHashMap<String, String>();
        List<AppPackage> listOfAppPackages = arc.getPackages();
        if (listOfAppPackages != null) {
            for (AppPackage pack : listOfAppPackages) {
                List<String> listOfLocations;
                List<AppPackage.Issue> issueList = pack.getIssues();
                if (issueList.contains((Object)AppPackage.Issue.DUPLICATE_CLASS)) {
                    listOfLocations = pack.getLocations(AppPackage.Issue.DUPLICATE_CLASS);
                    this.addLocation(listOfLocations, pack, locationMapAcross, locationMapWithin);
                }
                if (issueList.contains((Object)AppPackage.Issue.JAVA_EE_SE_CLASS)) {
                    listOfLocations = pack.getLocations(AppPackage.Issue.JAVA_EE_SE_CLASS);
                    this.addLocation(pack, locationMapJavaEE, null, listOfLocations);
                }
                if (issueList.contains((Object)AppPackage.Issue.WAS_CLASS)) {
                    listOfLocations = pack.getLocations(AppPackage.Issue.WAS_CLASS);
                    this.addLocation(pack, locationMapWS, null, listOfLocations);
                }
                if (issueList.contains((Object)AppPackage.Issue.OSS_CLASS)) {
                    listOfLocations = pack.getLocations(AppPackage.Issue.OSS_CLASS);
                    this.addLocation(pack, locationMapOS, serversMapOS, listOfLocations);
                }
                if (!issueList.contains((Object)AppPackage.Issue.MISSING_DEP)) continue;
                listOfLocations = pack.getLocations(AppPackage.Issue.MISSING_DEP);
                this.addLocation(pack, locationMapMissingDeps, null, listOfLocations);
            }
        }
        SortedMap<String, String> locationMapUnusedJars = arc.getUnusedArchives();
        SortedMap<String, String> checksumMapUnusedJars = arc.getUnusedArchiveChecksums();
        SortedMap<String, String> locationMapSharedLibDependencies = arc.getSharedLibDependencies();
        SortedMap<String, String> mapOfSystemProperties = arc.getMapOfSystemProperties();
        this.buildAppProblemSection(AppPackage.Issue.DUPLICATE_CLASS_WITHIN, locationMapWithin, null, sb);
        this.buildAppProblemSection(AppPackage.Issue.DUPLICATE_CLASS_ACROSS, locationMapAcross, null, sb);
        this.buildAppProblemSection(AppPackage.Issue.JAVA_EE_SE_CLASS, locationMapJavaEE, null, sb);
        this.buildAppProblemSection(AppPackage.Issue.WAS_CLASS, locationMapWS, null, sb);
        this.buildAppProblemSection(AppPackage.Issue.OSS_CLASS, locationMapOS, serversMapOS, sb);
        this.buildAppProblemSection(AppPackage.Issue.UNUSED_ARCHIVES, new LinkedHashMap<String, String>(locationMapUnusedJars), null, new LinkedHashMap<String, String>(checksumMapUnusedJars), sb);
        this.buildAppProblemSection(AppPackage.Issue.MISSING_DEP, locationMapMissingDeps, null, sb);
        this.buildAppProblemSection(AppPackage.Issue.SYSTEM_LEVEL_PROPERTIES, new LinkedHashMap<String, String>(mapOfSystemProperties), null, sb);
        this.buildAppProblemSection(AppPackage.Issue.SHARED_LIB_DEPENDENCIES, new LinkedHashMap<String, String>(locationMapSharedLibDependencies), null, sb);
        sb.append("</div>\n");
        sb.append("</li>\n");
        sb.append("</ul>");
        sb.append("</div>");
    }

    public void buildOperationalConsiderations(StringBuilder sb, Archive arc) {
        QosDeploymentTargets deploymentTargets = arc.getDeploymentTargets();
        List<String> listOfClusters = arc.getListOfClusters();
        List<String> listOfClustersWithSessionReplication = arc.getListOfClustersWithSessionReplication();
        List<String> listOfClustersWithSessionDatabase = arc.getListOfClustersWithSessionDatabase();
        List<String> listOfClustersWithTransactionLogDatabase = arc.getListOfClustersWithTransactionLogDatabase();
        List<String> listOfClustersWithTransactionLogFile = arc.getListOfClustersWithTransactionLogFile();
        List<String> listOfDeployedServers = arc.getListOfDeployedServer();
        boolean standAloneServer = listOfClusters.isEmpty() && listOfDeployedServers.size() == 1;
        boolean multipleStandAloneServers = listOfClusters.isEmpty() && listOfDeployedServers.size() > 1;
        boolean mixedDeployment = !listOfClusters.isEmpty() && !listOfDeployedServers.isEmpty();
        boolean singleCluster = listOfClusters.size() == 1;
        boolean multipleClusters = listOfClusters.size() > 1;
        boolean atLeastOneDynamicCluster = listOfClusters.size() > 0 ? this.isAnyClusterDynamic(deploymentTargets.getClusterTargets()) : false;
        boolean noQualitiesOfService = standAloneServer || multipleStandAloneServers;
        boolean isZos = arc.isZos();
        if (standAloneServer || multipleStandAloneServers || singleCluster || multipleClusters || mixedDeployment) {
            sb.append("<div class=\"horizontal-breaks\">\n");
            sb.append(this.isSingleApplication ? "<h2 id=\"inventory_OC\">" : "<h2 id=\"inventory_OC_" + ReportUtility.encodeHTMLEntities(arc.getName()) + "\">");
            sb.append(Messages.getString("INVENTORY_REPORT_QOS_TITLE"));
            sb.append("</h2>\n");
            sb.append("<ul>\n");
            sb.append("<li class=\"problemSummary alternate\">\n");
            sb.append("<div class=\"archive-title\">\n");
            sb.append("<h3>\n");
            sb.append(Messages.getString("INVENTORY_REPORT_QOS_Overview"));
            sb.append("</h3>\n");
            sb.append("</div>\n");
            sb.append("<div class=\"archive-details shared\">\n");
            sb.append("<p class=\"summary-item\"><b>");
            sb.append(Messages.getString("INVENTORY_REPORT_QOS_PRODUCT"));
            sb.append("</b>");
            sb.append(this.getStringForWebSphereEdition(arc));
            sb.append("</p>\n");
            sb.append("<p class=\"summary-item\"><b>");
            sb.append(Messages.getString("INVENTORY_REPORT_QOS_VERSION"));
            sb.append("</b>");
            sb.append(ReportUtility.encodeHTMLEntities(arc.getWebSphereVersion()));
            sb.append("</p>\n");
            sb.append("<p class=\"summary-item\"><b>");
            sb.append(Messages.getString("INVENTORY_REPORT_QOS_HOST"));
            sb.append("</b>");
            sb.append(ReportUtility.encodeHTMLEntities(arc.getAdminHost()));
            sb.append(":");
            sb.append(ReportUtility.encodeHTMLEntities(arc.getAdminPort()));
            sb.append("</p>\n");
            sb.append("<p class=\"summary-item\"><b>");
            sb.append(Messages.getString("INVENTORY_REPORT_QOS_CELL"));
            sb.append("</b>");
            sb.append(ReportUtility.encodeHTMLEntities(arc.getCellName()));
            sb.append("</p>\n");
            sb.append("<div class=\"deployment-targets\">\n");
            sb.append("<ul class=\"targets\">\n");
            sb.append("<li class=\"targets-root\">").append("<svg focusable=\"false\" preserveAspectRatio=\"xMidYMid meet\" xmlns=\"http://www.w3.org/2000/svg\" width=\"32\" height=\"32\" viewBox=\"0 0 32 32\" aria-hidden=\"true\" style=\"will-change: transform;\"><path d=\"M16,18H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H16a2,2,0,0,1,2,2V16A2,2,0,0,1,16,18ZM6,6V16H16V6Z\"></path><path d=\"M26,12v4H22V12h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z\"></path><path d=\"M26,22v4H22V22h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z\"></path><path d=\"M16,22v4H12V22h4m0-2H12a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z\"></path></svg>").append(Messages.getFormattedMessage(Messages.getString("INVENTORY_REPORT_QOS_DEPLOYMENT_TARGETS"), ReportUtility.encodeHTMLEntities(arc.getName()))).append("\n");
            sb.append("<ul>\n");
            for (QosClusterTarget cluster : deploymentTargets.getClusterTargets()) {
                sb.append("<li>").append("<svg focusable=\"false\" preserveAspectRatio=\"xMidYMid meet\" xmlns=\"http://www.w3.org/2000/svg\" width=\"32\" height=\"32\" viewBox=\"0 0 32 32\" aria-hidden=\"true\" style=\"will-change: transform;\"><path d=\"M26,28H6a2.0021,2.0021,0,0,1-2-2V11A2.0021,2.0021,0,0,1,6,9h5.6665a2.0119,2.0119,0,0,1,1.2007.4L16.3335,12H26a2.0021,2.0021,0,0,1,2,2V26A2.0021,2.0021,0,0,1,26,28ZM11.6665,11H5.9985L6,26H26V14H15.6665Z\"></path><path d=\"M28,9H17.6665l-4-3H6V4h7.6665a2.0119,2.0119,0,0,1,1.2007.4L18.3335,7H28Z\"></path></svg>").append(ReportUtility.encodeHTMLEntities(cluster.getName())).append("\n");
                if (!cluster.getMembers().isEmpty()) {
                    sb.append("<ul>\n");
                    for (QosServerTarget server : cluster.getMembers()) {
                        sb.append("<li>").append("<svg focusable=\"false\" preserveAspectRatio=\"xMidYMid meet\" xmlns=\"http://www.w3.org/2000/svg\" width=\"32\" height=\"32\" viewBox=\"0 0 32 32\" aria-hidden=\"true\" style=\"will-change: transform;\"><rect width=\"4\" height=\"2\" x=\"14\" y=\"19\"></rect><path d=\"M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z\"></path></svg>").append(ReportUtility.encodeHTMLEntities(server.getServerName())).append(" (").append(ReportUtility.encodeHTMLEntities(server.getNodeName())).append(")</li>\n");
                    }
                    sb.append("</ul>\n");
                }
                sb.append("</li>\n");
            }
            for (QosServerTarget server : deploymentTargets.getServerTargets()) {
                sb.append("<li>").append("<svg focusable=\"false\" preserveAspectRatio=\"xMidYMid meet\" xmlns=\"http://www.w3.org/2000/svg\" width=\"32\" height=\"32\" viewBox=\"0 0 32 32\" aria-hidden=\"true\" style=\"will-change: transform;\"><rect width=\"4\" height=\"2\" x=\"14\" y=\"19\"></rect><path d=\"M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z\"></path></svg>").append(ReportUtility.encodeHTMLEntities(server.getServerName())).append(" (").append(ReportUtility.encodeHTMLEntities(server.getNodeName())).append(")</li>\n");
            }
            sb.append("</ul>\n");
            sb.append("</li>\n");
            sb.append("</ul>\n");
            sb.append("</div>\n");
            sb.append("<p>\n");
            sb.append(Messages.getString("INVENTORY_REPORT_QOS_SUMMARY"));
            if (isZos) {
                sb.append(" ").append(Messages.getString("INVENTORY_REPORT_QOS_SUMMARY_ZOS_ADDENDUM"));
            }
            sb.append("</p>\n");
            if (multipleStandAloneServers || multipleClusters || mixedDeployment) {
                sb.append("<p class=\"summary-item-title\">");
                sb.append(Messages.getString("INVENTORY_REPORT_QOS_MULTI_DEP_TARGET"));
                sb.append("</p>\n");
                sb.append("<p class=\"summary-item\">\n");
                sb.append(Messages.getString("INVENTORY_REPORT_QOS_MULTI_DEP_SUMMARY"));
                sb.append("</p>\n");
            }
            if (noQualitiesOfService) {
                sb.append("<p>\n");
                sb.append(Messages.getString("INVENTORY_REPORT_NO_QOS"));
                if (isZos) {
                    sb.append(" ").append(Messages.getString("INVENTORY_REPORT_QOS_SC_SUMMARY_ZOS_ADDENDUM"));
                }
                sb.append("</p>\n");
                sb.append("</div>\n");
                sb.append("</li>\n");
            } else {
                sb.append("</div>\n");
                sb.append("</li>\n");
                sb.append("<li class=\"archive alternate\">\n");
                sb.append("<div class=\"archive-title\">\n");
                sb.append("<h3>\n");
                if (singleCluster && atLeastOneDynamicCluster) {
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_DYNAMIC_CLUSTERING_TITLE"));
                } else if (singleCluster) {
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_STATIC_CLUSTERING_TITLE"));
                } else if (multipleClusters) {
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_CLUSTERING_TITLE"));
                }
                sb.append("</h3>\n");
                sb.append("<div class=\"js-toggle-actions noprint\">");
                sb.append("<a href=\"#\" class=\"recommendation-toggle archive-toggle\">");
                sb.append(Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
                sb.append("</a>");
                sb.append("</div>\n");
                sb.append("</div>\n");
                sb.append("<div class=\"archive-details shared hide\">\n");
                sb.append("<p class=\"summary-item\">");
                StringBuilder depTargets = new StringBuilder();
                int count = 1;
                for (String cluster : listOfClusters) {
                    depTargets.append(ReportUtility.encodeHTMLEntities(cluster));
                    if (count != listOfClusters.size()) {
                        depTargets.append(", ");
                    }
                    ++count;
                }
                sb.append("<b>");
                sb.append(Messages.getString("INVENTORY_REPORT_QOS_DEP_TARGET"));
                sb.append("</b> ");
                sb.append(depTargets.toString());
                depTargets.setLength(0);
                sb.append("</p>\n");
                if (arc.getRecommendedMinimumNumberOfReplicas() > -1) {
                    sb.append("<p class=\"summary-item\">");
                    sb.append("<b>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_DC_MIN_REPLICA_NUMBER"));
                    sb.append("</b> ");
                    sb.append(arc.getRecommendedMinimumNumberOfReplicas());
                    sb.append("</p>\n");
                    sb.append("<p class=\"summary-item\">");
                    sb.append("<b>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_DC_MAX_REPLICA_NUMBER"));
                    sb.append("</b> ");
                    sb.append(arc.getRecommendedMaximumNumberOfReplicas());
                    sb.append("</p>\n");
                } else if (arc.getRecommendedNumberOfReplicas() > 1) {
                    sb.append("<p class=\"summary-item\">");
                    sb.append("<b>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_REPLICA_NUMBER"));
                    sb.append("</b> ");
                    sb.append(arc.getRecommendedNumberOfReplicas());
                    sb.append("</p>\n");
                }
                sb.append("<p>");
                if (singleCluster && atLeastOneDynamicCluster) {
                    sb.append(Messages.getFormattedMessage(Messages.getString("INVENTORY_REPORT_QOS_SINGLE_CLUSTER_DC_SUMMARY"), arc.getRecommendedMinimumNumberOfReplicas(), arc.getRecommendedMaximumNumberOfReplicas()));
                } else if (singleCluster) {
                    if (arc.getRecommendedNumberOfReplicas() == 1) {
                        sb.append(Messages.getString("INVENTORY_REPORT_QOS_SINGLE_CLUSTER_MEMBER_SC_SUMMARY"));
                    } else {
                        sb.append(Messages.getFormattedMessage(Messages.getString("INVENTORY_REPORT_QOS_SINGLE_CLUSTER_SC_SUMMARY"), arc.getRecommendedNumberOfReplicas()));
                    }
                } else if (multipleClusters && atLeastOneDynamicCluster) {
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_MULTI_CLUSTER_SUMMARY"));
                } else if (multipleClusters) {
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_MULTI_CLUSTER_SC_SUMMARY"));
                }
                if (isZos) {
                    sb.append(" ").append(Messages.getString("INVENTORY_REPORT_QOS_SC_SUMMARY_ZOS_ADDENDUM"));
                }
                sb.append("</p>\n");
                sb.append("</div>\n");
                sb.append("</li>\n");
                if (!listOfClustersWithSessionReplication.isEmpty()) {
                    sb.append("<li class=\"archive alternate\">\n");
                    sb.append("<div class=\"archive-title\">\n");
                    sb.append("<h3>\n");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_SESSION_REPLICATION_TITLE"));
                    sb.append("</h3>\n");
                    sb.append("<div class=\"js-toggle-actions noprint\">");
                    sb.append("<a href=\"#\" class=\"recommendation-toggle archive-toggle\">");
                    sb.append(Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
                    sb.append("</a>");
                    sb.append("</div>\n");
                    sb.append("</div>\n");
                    sb.append("<div class=\"archive-details shared hide\">\n");
                    sb.append("<p class=\"summary-item\">");
                    count = 1;
                    depTargets = new StringBuilder();
                    for (String cluster : listOfClustersWithSessionReplication) {
                        depTargets.append(ReportUtility.encodeHTMLEntities(cluster));
                        if (count != listOfClustersWithSessionReplication.size()) {
                            depTargets.append(", ");
                        }
                        ++count;
                    }
                    sb.append("<b>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_DEP_TARGET"));
                    sb.append("</b>");
                    sb.append(depTargets.toString());
                    sb.append("</p>\n");
                    sb.append("<p>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_SESSION_REPLICATION_SUMMARY_PART1"));
                    sb.append("</p>\n");
                    sb.append("<p class=\"summary-item-title\">");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_SESSION_REPLICATION_SUMMARY_PART2"));
                    sb.append("</p>\n");
                    sb.append("<p class=\"summary-item\">\n");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_SESSION_REPLICATION_SUMMARY_PART3_PARAGRAPH1"));
                    sb.append("</p>\n");
                    sb.append("<p>\n");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_SESSION_REPLICATION_SUMMARY_PART3_PARAGRAPH2"));
                    sb.append("</p>\n");
                    sb.append("<p class=\"summary-item-title\">");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_SESSION_REPLICATION_SUMMARY_PART4"));
                    sb.append("</p>\n");
                    sb.append("<p class=\"summary-item\">\n");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_SESSION_REPLICATION_SUMMARY_PART5"));
                    sb.append("</p>\n");
                    sb.append("<ul class=\"bulletList\">\n");
                    sb.append("<li><a href=\"https://www.ibm.com/support/knowledgecenter/SSD28V_liberty/com.ibm.websphere.wlp.core.doc/ae/twlp_admin_session_persistence.html\" title=\"Opens a new window\" target=\"_blank\" rel=\"noopener noreferrer\">");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_SESSION_REPLICATION_SUMMARY_LIBERTY_LINK"));
                    sb.append("</a></li>\n");
                    sb.append("<li><a href=\"https://www.ibm.com/support/knowledgecenter/SSEQTP_9.0.5/com.ibm.websphere.base.doc/ae/tprs_cnfp.html\" title=\"Opens a new window\" target=\"_blank\" rel=\"noopener noreferrer\">");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_SESSION_REPLICATION_SUMMARY_TWAS_LINK"));
                    sb.append("</a></li>\n");
                    sb.append("</ul\n");
                    sb.append("</div>\n");
                    sb.append("</li>\n");
                }
                if (!listOfClustersWithSessionDatabase.isEmpty()) {
                    sb.append("<li class=\"archive alternate\">\n");
                    sb.append("<div class=\"archive-title\">\n");
                    sb.append("<h3>\n");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_SESSION_DB_PERSISTENCE_TITLE"));
                    sb.append("</h3>\n");
                    sb.append("<div class=\"js-toggle-actions noprint\">");
                    sb.append("<a href=\"#\" class=\"recommendation-toggle archive-toggle\">");
                    sb.append(Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
                    sb.append("</a>");
                    sb.append("</div>\n");
                    sb.append("</div>\n");
                    sb.append("<div class=\"archive-details shared hide\">\n");
                    sb.append("<p class=\"summary-item\">");
                    count = 1;
                    depTargets = new StringBuilder();
                    for (String cluster : listOfClustersWithSessionDatabase) {
                        depTargets.append(ReportUtility.encodeHTMLEntities(cluster));
                        if (count != listOfClustersWithSessionDatabase.size()) {
                            depTargets.append(", ");
                        }
                        ++count;
                    }
                    sb.append("<b>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_DEP_TARGET"));
                    sb.append("</b>");
                    sb.append(depTargets.toString());
                    sb.append("</p>\n");
                    sb.append("<p>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_SESSION_DB_PERSISTENCE_SUMMARY"));
                    sb.append("</p>\n");
                    sb.append("<ul class=\"bulletList\">\n");
                    sb.append("<li><a href=\"https://www.ibm.com/support/knowledgecenter/SSD28V_liberty/com.ibm.websphere.wlp.core.doc/ae/twlp_admin_session_persistence.html\" title=\"Opens a new window\" target=\"_blank\" rel=\"noopener noreferrer\">");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_SESSION_REPLICATION_SUMMARY_LIBERTY_LINK"));
                    sb.append("</a></li>\n");
                    sb.append("<li><a href=\"https://www.ibm.com/support/knowledgecenter/SSEQTP_9.0.5/com.ibm.websphere.base.doc/ae/tprs_cnfp.html\" title=\"Opens a new window\" target=\"_blank\" rel=\"noopener noreferrer\">");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_SESSION_REPLICATION_SUMMARY_TWAS_LINK"));
                    sb.append("</a></li>\n");
                    sb.append("</ul\n");
                    sb.append("</div>\n");
                    sb.append("</li>\n");
                }
                if (!listOfClustersWithTransactionLogDatabase.isEmpty()) {
                    sb.append("<li class=\"archive alternate\">\n");
                    sb.append("<div class=\"archive-title\">\n");
                    sb.append("<h3>\n");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_TRANSACTION_LOG_DATABASE_TITLE"));
                    sb.append("</h3>\n");
                    sb.append("<div class=\"js-toggle-actions noprint\">");
                    sb.append("<a href=\"#\" class=\"recommendation-toggle archive-toggle\">");
                    sb.append(Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
                    sb.append("</a>");
                    sb.append("</div>\n");
                    sb.append("</div>\n");
                    sb.append("<div class=\"archive-details shared hide\">\n");
                    sb.append("<p class=\"summary-item\">");
                    count = 1;
                    depTargets = new StringBuilder();
                    for (String cluster : listOfClustersWithTransactionLogDatabase) {
                        depTargets.append(ReportUtility.encodeHTMLEntities(cluster));
                        if (count != listOfClustersWithTransactionLogDatabase.size()) {
                            depTargets.append(", ");
                        }
                        ++count;
                    }
                    sb.append("<b>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_DEP_TARGET"));
                    sb.append("</b>");
                    sb.append(depTargets.toString());
                    sb.append("</p>\n");
                    sb.append("<p>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_TRANSACTION_LOG_INTRO"));
                    sb.append("</p>\n");
                    sb.append("<p>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_TRANSACTION_LOG_END"));
                    sb.append("</p>\n");
                }
                if (!listOfClustersWithTransactionLogFile.isEmpty()) {
                    sb.append("<li class=\"archive alternate\">\n");
                    sb.append("<div class=\"archive-title\">\n");
                    sb.append("<h3>\n");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_TRANSACTION_LOG_FILE_BASED_TITLE"));
                    sb.append("</h3>\n");
                    sb.append("<div class=\"js-toggle-actions noprint\">");
                    sb.append("<a href=\"#\" class=\"recommendation-toggle archive-toggle\">");
                    sb.append(Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
                    sb.append("</a>");
                    sb.append("</div>\n");
                    sb.append("</div>\n");
                    sb.append("<div class=\"archive-details shared hide\">\n");
                    sb.append("<p class=\"summary-item\">");
                    count = 1;
                    depTargets = new StringBuilder();
                    for (String cluster : listOfClustersWithTransactionLogFile) {
                        depTargets.append(ReportUtility.encodeHTMLEntities(cluster));
                        if (count != listOfClustersWithTransactionLogFile.size()) {
                            depTargets.append(", ");
                        }
                        ++count;
                    }
                    sb.append("<b>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_DEP_TARGET"));
                    sb.append("</b>");
                    sb.append(depTargets.toString());
                    sb.append("</p>\n");
                    sb.append("<p>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_TRANSACTION_LOG_INTRO"));
                    sb.append("</p>\n");
                    sb.append("<p>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_TRANSACTION_LOG_FILE_ADDITIONAL_ADVICE"));
                    sb.append("</p>\n");
                    sb.append("<p>");
                    sb.append(Messages.getString("INVENTORY_REPORT_QOS_TRANSACTION_LOG_END"));
                    sb.append("</p>\n");
                }
            }
            sb.append("</ul>");
            sb.append("</div>");
        }
    }

    private boolean isAnyClusterDynamic(List<QosClusterTarget> listOfClusters) {
        for (QosClusterTarget cluster : listOfClusters) {
            if (!cluster.isDynamic()) continue;
            return true;
        }
        return false;
    }

    private String getStringForWebSphereEdition(Archive arc) {
        if (arc.isZos()) {
            return Messages.getString("INVENTORY_REPORT_QOS_ZOS");
        }
        return arc.getWebSphereEdition().equals("ND") ? Messages.getString("INVENTORY_REPORT_QOS_ND") : Messages.getString("INVENTORY_REPORT_QOS_BASE");
    }

    private void addLocation(AppPackage pack, LinkedHashMap<String, String> locationMap, Map<String, String> serverMap, List<String> listOfLocations) {
        Collections.sort(listOfLocations);
        StringBuilder dupLocationSB = new StringBuilder();
        int size = listOfLocations.size();
        int i = 0;
        while (i < size) {
            String location = listOfLocations.get(i);
            dupLocationSB.append(ReportUtility.encodeHTMLEntities(location));
            if (++i == size) continue;
            dupLocationSB.append("<br>");
        }
        this.addToLocationMap(locationMap, serverMap, dupLocationSB, pack);
    }

    private void addLocation(List<String> listOfLocations, AppPackage pack, LinkedHashMap<String, String> locationMapAcross, LinkedHashMap<String, String> locationMapWithin) {
        StringBuilder dupLocationSB = new StringBuilder();
        boolean includeInWithin = false;
        boolean includeInBoth = false;
        String prevParentArcName = "";
        LinkedHashMap<String, StringBuilder> mapOfParentArchToChild = new LinkedHashMap<String, StringBuilder>();
        int i = 0;
        while (i < listOfLocations.size()) {
            StringBuilder childArchs;
            String currentPackageLocation = listOfLocations.get(i);
            String currentParentArcName = Pattern.compile("([a-zA-Z]:)?\\/.*").matcher(currentPackageLocation).replaceFirst("");
            if (currentParentArcName.equals(currentPackageLocation)) {
                currentParentArcName = "topArchive";
            }
            if (mapOfParentArchToChild.containsKey(currentParentArcName)) {
                childArchs = (StringBuilder)mapOfParentArchToChild.get(currentParentArcName);
                childArchs.append("<br>");
                childArchs.append(ReportUtility.encodeHTMLEntities(currentPackageLocation));
                mapOfParentArchToChild.put(currentParentArcName, childArchs);
            } else {
                childArchs = new StringBuilder(ReportUtility.encodeHTMLEntities(currentPackageLocation));
                mapOfParentArchToChild.put(currentParentArcName, childArchs);
            }
            if (!includeInWithin && !prevParentArcName.isEmpty() && currentPackageLocation.endsWith(".jar") && currentParentArcName.equals(prevParentArcName)) {
                includeInWithin = true;
                if (i > 1) {
                    includeInBoth = true;
                }
            }
            if (includeInWithin && !prevParentArcName.equals(currentParentArcName)) {
                includeInBoth = true;
            }
            prevParentArcName = currentParentArcName;
            dupLocationSB.append(ReportUtility.encodeHTMLEntities(currentPackageLocation));
            if (i + 1 != listOfLocations.size()) {
                dupLocationSB.append("<br>");
            }
            ++i;
        }
        if (includeInBoth) {
            this.addToLocationMap(locationMapAcross, null, dupLocationSB, pack);
            for (String key : mapOfParentArchToChild.keySet()) {
                StringBuilder locationsSB = (StringBuilder)mapOfParentArchToChild.get(key);
                String locations = locationsSB.toString();
                if (!locations.contains("<br>") || !key.endsWith(".war") && !key.endsWith(".ear")) continue;
                this.addToLocationMap(locationMapWithin, null, locationsSB, pack);
            }
        } else if (includeInWithin) {
            this.addToLocationMap(locationMapWithin, null, dupLocationSB, pack);
        } else {
            this.addToLocationMap(locationMapAcross, null, dupLocationSB, pack);
        }
    }

    private void buildAppProblemSection(AppPackage.Issue issue, LinkedHashMap<String, String> locationMap, Map<String, String> serverMap, StringBuilder sb) {
        this.buildAppProblemSection(issue, locationMap, serverMap, null, sb);
    }

    private void buildAppProblemSection(AppPackage.Issue issue, LinkedHashMap<String, String> locationMap, Map<String, String> serverMap, LinkedHashMap<String, String> unusedArchiveChecksumMap, StringBuilder sb) {
        if (!locationMap.isEmpty()) {
            StringBuilder dupWithinSB = new StringBuilder();
            dupWithinSB.append("<h2>");
            dupWithinSB.append(issue.getTitle());
            dupWithinSB.append("</h2>\n");
            dupWithinSB.append("<p>");
            dupWithinSB.append(issue.getDescription());
            dupWithinSB.append("</p>\n");
            dupWithinSB.append("<p>");
            dupWithinSB.append("<b>");
            dupWithinSB.append(Messages.getString("INVENTORY_REPORT_REC_LABEL"));
            dupWithinSB.append("</b> ");
            dupWithinSB.append(issue.getRecommendation());
            dupWithinSB.append("</p>\n");
            String tableSummary = issue.getTableSummary();
            dupWithinSB.append("<table class=\"duplicate-jar-contents\" summary=\"").append(tableSummary).append("\">\n");
            dupWithinSB.append("<thead>\n");
            dupWithinSB.append("<tr class=\"alternate-row\">\n");
            dupWithinSB.append("<th>");
            if (AppPackage.Issue.UNUSED_ARCHIVES == issue) {
                dupWithinSB.append(Messages.getString("INVENTORY_REPORT_DEP_ARCHIVE"));
            } else if (AppPackage.Issue.SHARED_LIB_DEPENDENCIES == issue) {
                dupWithinSB.append(Messages.getString("INVENTORY_REPORT_SHARED_LIB"));
            } else if (AppPackage.Issue.MISSING_DEP == issue) {
                dupWithinSB.append(Messages.getString("INVENTORY_REPORT_MISSING_DEP"));
            } else if (AppPackage.Issue.SYSTEM_LEVEL_PROPERTIES == issue) {
                dupWithinSB.append(Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_EXCESSIVE_CLASS_HEADER_CLASS_FILES"));
            } else {
                dupWithinSB.append(Messages.getString("INVENTORY_REPORT_CONFLICTING_PACKAGES"));
            }
            dupWithinSB.append("</th>\n");
            dupWithinSB.append("<th>");
            if (AppPackage.Issue.UNUSED_ARCHIVES == issue) {
                dupWithinSB.append(Messages.getString("INVENTORY_REPORT_REFERENCED_BY"));
            } else if (AppPackage.Issue.SHARED_LIB_DEPENDENCIES == issue) {
                dupWithinSB.append(Messages.getString("INVENTORY_REPORT_REFERENCED_CLASS"));
            } else if (AppPackage.Issue.MISSING_DEP == issue) {
                dupWithinSB.append(Messages.getString("INVENTORY_REPORT_DEP_ARCHIVE"));
            } else if (AppPackage.Issue.SYSTEM_LEVEL_PROPERTIES == issue) {
                dupWithinSB.append(Messages.getString("INVENTORY_REPORT_METHODS_FOUND"));
            } else {
                dupWithinSB.append(Messages.getString("INVENTORY_REPORT_PACKAGE_LOCATION"));
            }
            if (AppPackage.Issue.UNUSED_ARCHIVES == issue) {
                dupWithinSB.append("</th>\n");
                dupWithinSB.append("<th>");
                dupWithinSB.append(Messages.getString("INVENTORY_REPORT_ARCHIVE_CHECKSUM_LABEL"));
            } else if (AppPackage.Issue.OSS_CLASS == issue) {
                dupWithinSB.append("</th>\n");
                dupWithinSB.append("<th>");
                dupWithinSB.append(Messages.getString("INVENTORY_REPORT_APPLIES_TO"));
            }
            dupWithinSB.append("</th>\n");
            dupWithinSB.append("</tr>\n");
            dupWithinSB.append("</thead>\n");
            dupWithinSB.append("<tbody>\n");
            boolean altRow = false;
            for (String path : locationMap.keySet()) {
                if (altRow) {
                    dupWithinSB.append("<tr class=\"alternate-row\">\n");
                } else {
                    dupWithinSB.append("<tr>\n");
                }
                altRow = !altRow;
                dupWithinSB.append("<td>");
                if (AppPackage.Issue.UNUSED_ARCHIVES == issue || AppPackage.Issue.SYSTEM_LEVEL_PROPERTIES == issue) {
                    dupWithinSB.append(ReportUtility.encodeHTMLEntities(path));
                } else if (AppPackage.Issue.SHARED_LIB_DEPENDENCIES == issue) {
                    dupWithinSB.append(path);
                } else {
                    dupWithinSB.append(locationMap.get(path));
                }
                dupWithinSB.append("</td>\n");
                dupWithinSB.append("<td>");
                if (AppPackage.Issue.UNUSED_ARCHIVES == issue) {
                    dupWithinSB.append(locationMap.get(path));
                } else if (AppPackage.Issue.SHARED_LIB_DEPENDENCIES == issue) {
                    dupWithinSB.append(locationMap.get(path));
                } else if (AppPackage.Issue.SYSTEM_LEVEL_PROPERTIES == issue) {
                    dupWithinSB.append(locationMap.get(path).replace(", ", "<br>\n"));
                } else {
                    dupWithinSB.append(path);
                }
                dupWithinSB.append("</td>\n");
                if (AppPackage.Issue.UNUSED_ARCHIVES == issue) {
                    dupWithinSB.append("<td>");
                    dupWithinSB.append(unusedArchiveChecksumMap.get(path));
                    dupWithinSB.append("</td>\n");
                } else if (AppPackage.Issue.OSS_CLASS == issue) {
                    dupWithinSB.append("<td>");
                    dupWithinSB.append(ReportUtility.encodeHTMLEntities(serverMap.get(path)));
                    dupWithinSB.append("</td>\n");
                }
                dupWithinSB.append("</tr>\n");
            }
            dupWithinSB.append("</tbody>\n");
            dupWithinSB.append("</table>\n");
            sb.append((CharSequence)dupWithinSB);
        }
    }

    private void addToLocationMap(LinkedHashMap<String, String> locationMap, Map<String, String> serverMap, StringBuilder sb, AppPackage pack) {
        String locations = sb.toString();
        if (serverMap != null) {
            serverMap.put(locations, pack.getAffectServers());
        }
        if (locationMap.containsKey(locations)) {
            String packageNames = locationMap.get(locations);
            packageNames = String.valueOf(packageNames) + "<br>" + ReportUtility.encodeHTMLEntities(pack.getName());
            locationMap.put(locations, packageNames);
        } else {
            locationMap.put(locations, ReportUtility.encodeHTMLEntities(pack.getName()));
        }
    }

    private void buildUtilityJarBreakdown(StringBuilder sb, Set<UtilityJar> utilitySet, boolean useAlternateColorScheme, boolean collapsable) {
        if (collapsable) {
            sb.append("<div class=\"archive-title\">\n");
            sb.append("<h3>");
            sb.append(Messages.getString("INVENTORY_REPORT_UTILITY_JAR_FILES"));
            sb.append("</h3>\n");
            sb.append("<div class=\"js-toggle-actions noprint\">");
            sb.append("<a href=\"#\" class=\"recommendation-toggle archive-toggle\">");
            sb.append(Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
            sb.append("</a>");
            sb.append("</div>\n");
            sb.append("</div>\n");
            sb.append("<div class=\"archive-details shared hide\">\n");
        }
        sb.append("<table class=\"utility-jar-contents\" summary=\"").append(Messages.getString("INVENTORY_REPORT_TABLE_SUMMARY_UTILITY_JAR_CONTENTS")).append("\">\n");
        sb.append("<thead>\n");
        sb.append("<tr class=\"alternate-row\">\n");
        sb.append("<th>");
        sb.append(Messages.getString("INVENTORY_REPORT_ARCHIVE_LABEL"));
        sb.append("</th>\n");
        sb.append("<th>");
        sb.append(Messages.getString("INVENTORY_REPORT_ARCHIVE_CHECKSUM_LABEL"));
        sb.append("</th>\n");
        sb.append("<th>");
        sb.append(Messages.getString("INVENTORY_REPORT_PACKAGES"));
        sb.append("</th>\n");
        sb.append("</tr>\n");
        sb.append("</thead>\n");
        sb.append("<tbody>\n");
        int row = 1;
        for (UtilityJar util : utilitySet) {
            row = this.addRowsForUtilityJarAndSubArchives(sb, util, row, null);
        }
        sb.append("</tbody>\n");
        sb.append("</table>\n");
        if (collapsable) {
            sb.append("</div>\n");
        }
    }

    private int addRowsForUtilityJarAndSubArchives(StringBuilder sb, UtilityJar util, int row, String containingArchiveName) {
        if (row % 2 == 0) {
            sb.append("<tr class=\"alternate-row\">\n");
        } else {
            sb.append("<tr>\n");
        }
        sb.append("<td>");
        String nameToDisplay = util.getName();
        if (containingArchiveName != null) {
            String fullName = util.getFullName();
            String lastArchiveContainingArchiveName = containingArchiveName.contains("/") ? containingArchiveName.substring(containingArchiveName.lastIndexOf(47) + 1) : containingArchiveName;
            nameToDisplay = fullName.replace(containingArchiveName, lastArchiveContainingArchiveName);
        }
        sb.append(ReportUtility.encodeHTMLEntities(nameToDisplay));
        sb.append("</td>\n");
        String checksum = util.getChecksum();
        sb.append("<td>\n");
        if (checksum != null) {
            sb.append(checksum);
        }
        sb.append("</td>\n");
        sb.append("<td>\n");
        for (String utilPackage : util) {
            sb.append(ReportUtility.encodeHTMLEntities(utilPackage));
            sb.append("<br />\n");
        }
        sb.append("</td>\n");
        sb.append("</tr>\n");
        ++row;
        Collection<Archive> subArchives = util.getSubArchives();
        if (!subArchives.isEmpty()) {
            for (Archive next : subArchives) {
                if (!(next instanceof UtilityJar)) continue;
                UtilityJar nextUtil = (UtilityJar)next;
                row = this.addRowsForUtilityJarAndSubArchives(sb, nextUtil, row, util.getFullName());
            }
        }
        return row;
    }

    protected void buildEmbeddedJS(StringBuilder sb) {
        String js = ReportUtility.getSharedJS();
        StringBuilder jsSB = new StringBuilder();
        if (js != null) {
            sb.append("<script type=\"text/javascript\">\n");
            jsSB.append(js);
            jsSB.append("var initializeCharts = function() {\n");
            jsSB.append("var barChartArray = [];\n");
            jsSB.append("var raveTreeFunctionArray = [];\n");
            jsSB.append((CharSequence)this.jsBuffer);
            jsSB.append("const canvasBackgroundPlugin = {  id: 'customCanvasBackgroundColor',\n  beforeDraw: function (chart, args, options) {\n    const ctx = chart.ctx;\n    ctx.save();\n    ctx.globalCompositeOperation = 'destination-over';\n    ctx.fillStyle = options.color || '#99ffff';\n    ctx.fillRect(0, 0, chart.width, chart.height);\n    ctx.restore();\n  }\n};\n");
            jsSB.append("var loadBarCharts = function() {\n");
            int i = 0;
            int barChartArrayIndex = 0;
            for (String nextProject : this.arrayOfProjects) {
                if (this.projectsWithCharts[i]) {
                    Archive arc = this.inv.get(nextProject);
                    jsSB.append("var ctx");
                    jsSB.append(i);
                    jsSB.append(" = document.getElementById(\"canvas");
                    jsSB.append(i);
                    jsSB.append("\").getContext(\"2d\");\n");
                    jsSB.append("window.myBar");
                    jsSB.append(i);
                    jsSB.append(" = new Chart(ctx");
                    jsSB.append(i);
                    jsSB.append(", {\n");
                    jsSB.append("type: 'bar',\n");
                    jsSB.append("data: barChartArray[");
                    jsSB.append(barChartArrayIndex);
                    jsSB.append("],\n");
                    jsSB.append("options: {\n");
                    jsSB.append("  plugins: {\n");
                    jsSB.append("    title: {\n");
                    jsSB.append("      display: true,\n");
                    jsSB.append("      text: \"");
                    jsSB.append(ReportUtility.encodeJSEntities(arc.getName()));
                    jsSB.append("\"\n");
                    jsSB.append("    },\n");
                    jsSB.append("    customCanvasBackgroundColor: { color: 'white' }\n");
                    jsSB.append("  },\n");
                    jsSB.append("interaction: { mode: 'index' },\n");
                    jsSB.append("responsive: true,\n");
                    jsSB.append("maintainAspectRatio: barChartArray[" + barChartArrayIndex + "].maintainAspectRatio,\n");
                    jsSB.append("scales: {\n");
                    jsSB.append("x: { stacked: true, }, y: { stacked: true, ticks: { callback: function (value) { if (Number.isInteger(value)) { return value; } } } }\n");
                    jsSB.append("}\n");
                    jsSB.append("},\n");
                    jsSB.append("plugins: [canvasBackgroundPlugin]\n");
                    jsSB.append("});\n");
                    ++barChartArrayIndex;
                }
                ++i;
            }
            jsSB.append("};\n");
            jsSB.append("loadBarCharts();\n");
            jsSB.append("for (var i=0; i < raveTreeFunctionArray.length; i++) {\n");
            jsSB.append("    raveTreeFunctionArray[i]();\n");
            jsSB.append("}\n");
            jsSB.append("};\n\n");
            jsSB.append("// This is required to initialize charts for all browsers other than IE\n");
            jsSB.append("window.onload = function() {\n");
            jsSB.append("        initializeCharts();\n");
            jsSB.append("};\n\n");
            String minifiedJS = ReportUtility.minifyJS(jsSB.toString());
            if (minifiedJS != null) {
                sb.append(minifiedJS);
            }
            sb.append("</script>\n");
        }
    }

    private void buildPerformanceConsiderations(StringBuilder sb, Set<String> setOfJARs, TreeMap<String, String> archivesWithExcessClasses, TreeMap<String, String> archivesWithExcessWebModuleResources, String archiveName, boolean isWAR) {
        sb.append("<div class=\"horizontal-breaks\">\n");
        sb.append(this.isSingleApplication ? "<h2 id=\"inventory_PC\">" : "<h2 id=\"inventory_PC_" + ReportUtility.encodeHTMLEntities(archiveName) + "\">");
        sb.append(Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_SECTION"));
        sb.append("</h2>\n");
        if (!setOfJARs.isEmpty()) {
            this.addPerformanceConsiderationBulletList(sb, setOfJARs, Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_METADATA_SUGGESTIONS_TITLE"), Messages.getString("INVENTORY_REPORT_PERFORMANCE_CONSIDERATIONS_METADATA_SUGGESTIONS_SUMMARY"));
        }
        if (!archivesWithExcessClasses.isEmpty()) {
            this.buildExcessFileSection(sb, Archive.ExcessFileType.EXCESS_CLASS, isWAR, archivesWithExcessClasses);
        }
        if (!archivesWithExcessWebModuleResources.isEmpty()) {
            this.buildExcessFileSection(sb, Archive.ExcessFileType.EXCESS_WEB_MODULE_RESOURCE, isWAR, archivesWithExcessWebModuleResources);
        }
        sb.append("</div>");
    }

    public void buildExcessFileSection(StringBuilder sb, Archive.ExcessFileType type, boolean isWAR, TreeMap<String, String> archivesWithExcessFiles) {
        if (isWAR) {
            this.addPerformanceConsiderationDescription(sb, null, type.getArchiveList(), MessageFormat.format(type.getWarSummary(), archivesWithExcessFiles.firstEntry().getValue()));
        } else {
            this.addPerformanceConsiderationTable(sb, type, archivesWithExcessFiles, type.getArchiveList(), type.getSummary());
        }
    }

    private void addPerformanceConsiderationDescription(StringBuilder sb, TreeMap<String, String> setOfArchiveNames, String title, String summary) {
        sb.append("<ul class=\"performance-considerations-list-of-jars\">\n");
        sb.append("<li class=\"problemSummary alternate\">\n");
        sb.append("<h3>");
        sb.append(title);
        sb.append("</h3>\n");
        sb.append("<p>");
        sb.append(summary);
        sb.append("</p>\n");
        sb.append("</li>");
        sb.append("</ul>");
    }

    private void addPerformanceConsiderationTable(StringBuilder sb, Archive.ExcessFileType type, TreeMap<String, String> setOfArchiveNames, String title, String summary) {
        sb.append("<ul class=\"performance-considerations-list-of-jars\">\n");
        sb.append("<li class=\"problemSummary alternate\">\n");
        sb.append("<h3>");
        sb.append(title);
        sb.append("</h3>\n");
        sb.append("<p>");
        sb.append(summary);
        sb.append("</p>\n");
        sb.append("<div class=\"wrapSummary\">\n");
        sb.append("<div class=\"performance-considerations\">");
        sb.append("<table summary=\"").append(Messages.getString("INVENTORY_REPORT_TABLE_SUMMARY_PERF_CONSIDERATIONS")).append("\">\n");
        sb.append("<thead>\n");
        sb.append("<tr>");
        sb.append("<th>");
        sb.append(Messages.getString("INVENTORY_REPORT_ARCHIVE_LABEL"));
        sb.append("</th>");
        sb.append("<th>");
        sb.append(type.getFileType());
        sb.append("</th>");
        sb.append("</tr>");
        sb.append("</thead>\n");
        sb.append("<tbody>\n");
        ArrayList<String> keySet = new ArrayList<String>(setOfArchiveNames.keySet());
        int arcName = 0;
        while (arcName < keySet.size()) {
            String archiveName = (String)keySet.get(arcName);
            if (arcName == 0 || arcName % 2 == 0) {
                sb.append("<tr class=\"alternate-row\">\n");
            } else {
                sb.append("<tr>\n");
            }
            sb.append("<td>");
            sb.append(ReportUtility.encodeHTMLEntities(archiveName));
            sb.append("</td>\n");
            sb.append("<td>");
            sb.append(ReportUtility.encodeHTMLEntities(setOfArchiveNames.get(archiveName)));
            sb.append("</td>\n");
            sb.append("</tr>\n");
            ++arcName;
        }
        sb.append("</tbody>\n");
        sb.append("</table>\n");
        sb.append("</div>");
        sb.append("</div>");
        sb.append("</li>");
        sb.append("</ul>");
    }

    private void addPerformanceConsiderationBulletList(StringBuilder sb, Set<String> setOfArchiveNames, String title, String summary) {
        sb.append("<ul class=\"performance-considerations-list-of-jars\">\n");
        sb.append("<li class=\"problemSummary alternate\">\n");
        sb.append("<h3>");
        sb.append(title);
        sb.append("</h3>\n");
        sb.append("<p>");
        sb.append(summary);
        sb.append("</p>\n");
        sb.append("<div class=\"wrapSummary\">\n");
        sb.append("<div class=\"performance-considerations\">\n");
        sb.append("<ul class=\"bulletList\">\n");
        ArrayList<String> listOfJARs = new ArrayList<String>(setOfArchiveNames);
        Collections.sort(listOfJARs);
        int jar = 0;
        while (jar < listOfJARs.size()) {
            sb.append("<li>");
            sb.append(ReportUtility.encodeHTMLEntities((String)listOfJARs.get(jar)));
            sb.append("</li>\n");
            ++jar;
        }
        sb.append("</ul>\n");
        sb.append("</div>");
        sb.append("</div>");
        sb.append("</li>");
        sb.append("</ul>");
    }
}

