/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.html;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.analyze.AnalysisResults;
import com.ibm.ws.report.inventory.Archive;
import com.ibm.ws.report.inventory.ArchiveInventory;
import com.ibm.ws.report.technology.TechSummary;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.writer.ReportWriter;
import com.ibm.ws.report.writer.html.HTMLDetailAnalysisStreamlinedReportWriter;
import com.ibm.ws.report.writer.html.HTMLEvaluationReportWriter;
import com.ibm.ws.report.writer.html.HTMLInventoryReportWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLMigrationReportWriter
implements ReportWriter {
    private String returnString;
    private List<String> projects = null;
    private boolean hasSharedLibraries = false;
    private List<String> sharedLibProjectNames = null;
    private SortedSet<String> coreFeatures = null;
    private SortedSet<String> baseFeatures = null;
    private String serverXml = null;
    private List<String> featureConflictMessages = null;
    private TechSummary tech = null;
    private boolean hasConflicts = false;
    private boolean isLiberty = false;
    int offsetOfJumpToRule = 0;
    private Archive arc = null;
    private boolean targetPlatformFullySupported = false;
    private int targetAppServerIndex = -1;
    private boolean isLibertyCoreTarget = false;
    private HTMLDetailAnalysisStreamlinedReportWriter analyzeWriter = null;
    private HTMLEvaluationReportWriter evalWriter = null;
    private HTMLInventoryReportWriter invWriter = null;
    private static final Pattern MATCH_JUMP_TO_SECTION_CONTENT_PATTERN = Pattern.compile("<h2 .*?id\\=.+?>[\\s\\S]+?</h2>|<li .*?id\\=.+class=\".*archive\">[\\s\\S]*?</h3>");
    private static final Pattern MATCH_ID_EQUAL_CASES_PATTERN = Pattern.compile("evaluation|analyze|inventory|generateConfig");
    private static final Pattern MATCH_ID_CONTAIN_CASES_PATTERN = Pattern.compile("(analyze|inventory).+");
    private static final String[] optionLabels = new String[]{"ANALYSIS_REPORT_SCAN_OPTIONS_LABEL", "ANALYSIS_REPORT_SOURCE_OPTIONS_LABEL", "ANALYSIS_REPORT_TARGET_OPTIONS_LABEL", "ANALYSIS_REPORT_EXCLUDED_PACKAGES_LABEL", "ANALYSIS_REPORT_INCLUDED_PACKAGES_LABEL", "ANALYSIS_REPORT_EXCLUDED_FILES_LABEL", "USER_RULE_LOCATION_LABEL"};
    private String[] optionValues = null;

    public HTMLMigrationReportWriter(List<String> arrayOfProjects, SortedMap<String, TechSummary> listOfTechSummaries, List<String> productsToShow, String[] sourceOptions, String[] targetOptions, SortedMap<String, String> scanOptions, int targetAppSeverColumnIndex, Map<String, Map<String, Map<String, List<String>>>> rulesAnalyzed, AnalysisResults analysisResults, List<String> connectivityRulesAnalyzed, ArchiveInventory ai, List<String> sharedLibProjectNames, boolean isLiberty, SortedSet<String> coreFeatures, SortedSet<String> baseFeatures, String serverXml, List<String> featureConflictMessages, boolean hasConflicts, boolean isLibertyCoreTarget, boolean showAllHelp, boolean allRulesLoaded, int maxUserDefinedRuleResults) {
        this.optionValues = new String[]{ReportUtility.getOptions(scanOptions, true), ReportUtility.getOptions(sourceOptions, true), ReportUtility.getOptions(targetOptions, true), ReportUtility.encodeHTMLEntities((String)scanOptions.get("excludePackages")), ReportUtility.encodeHTMLEntities((String)scanOptions.get("includePackages")), ReportUtility.encodeHTMLEntities((String)scanOptions.get("excludeFiles")), ReportUtility.encodeHTMLEntities((String)scanOptions.get("userRuleLocation"))};
        this.projects = arrayOfProjects;
        this.sharedLibProjectNames = sharedLibProjectNames;
        this.hasSharedLibraries = !sharedLibProjectNames.isEmpty();
        this.coreFeatures = coreFeatures;
        this.baseFeatures = baseFeatures;
        this.serverXml = serverXml;
        this.featureConflictMessages = featureConflictMessages;
        this.hasConflicts = hasConflicts;
        this.isLiberty = isLiberty;
        this.tech = listOfTechSummaries.entrySet().iterator().next().getValue();
        this.targetAppServerIndex = targetAppSeverColumnIndex;
        this.isLibertyCoreTarget = isLibertyCoreTarget;
        this.evalWriter = new HTMLEvaluationReportWriter(analysisResults.getRuleIds(), targetAppSeverColumnIndex, arrayOfProjects, listOfTechSummaries, productsToShow, scanOptions);
        this.analyzeWriter = new HTMLDetailAnalysisStreamlinedReportWriter(arrayOfProjects, sourceOptions, targetOptions, scanOptions, rulesAnalyzed, false, analysisResults, connectivityRulesAnalyzed, showAllHelp, allRulesLoaded, maxUserDefinedRuleResults);
        this.invWriter = new HTMLInventoryReportWriter(ai, arrayOfProjects, sharedLibProjectNames, scanOptions);
        this.arc = this.invWriter.inv.get(this.projects.get(0));
    }

    private void writeBodyHeader(StringBuilder sb) {
        this.offsetOfJumpToRule = sb.length();
        sb.append("<h1>");
        sb.append(Messages.getString("CONSOLIDATED_REPORT_MIGRATION_DETAILS_TITLE"));
        sb.append("</h1>\n");
        sb.append("<p class=\"date-time\"><span class=\"date\">");
        SimpleDateFormat localDateFormat = new SimpleDateFormat();
        sb.append(localDateFormat.format(new Date()));
        sb.append("</span></p>\n");
        sb.append("<p class=\"courier archivePath\">");
        sb.append(ReportUtility.encodeHTMLEntities(this.projects.get(0)));
        sb.append("</p>\n");
        if (this.hasSharedLibraries) {
            sb.append("<p>\n");
            sb.append(Messages.getString("INVENTORY_REPORT_SHARED_LIBRARIES_COLON"));
            sb.append("</p>\n");
            sb.append("<p class=\"courier\">");
            int i = 0;
            while (i < this.sharedLibProjectNames.size() - 1) {
                sb.append(ReportUtility.encodeHTMLEntities(this.sharedLibProjectNames.get(i)));
                sb.append("<br>\n");
                ++i;
            }
            sb.append(ReportUtility.encodeHTMLEntities(this.sharedLibProjectNames.get(this.sharedLibProjectNames.size() - 1)));
            sb.append("</p>\n");
        }
        ReportUtility.writeOptions(sb, optionLabels, this.optionValues);
        sb.append("<div class=\"consolidated-header-sections\">\n");
        sb.append("<h2 id=\"summary\">").append(Messages.getString("CONSOLIDATED_REPORT_EVAL_SUMMARY_HEADER")).append("</h2>\n");
        sb.append("<p>");
        sb.append(Messages.getFormattedMessage(Messages.getString("CONSOLIDATED_REPORT_EVAL_SUMMARY_DESC"), "<a class=\"blueAnchor jump-item\" href=\"#evaluation\">", "<a class=\"blueAnchor jump-item\" href=\"#analyze\">"));
        sb.append("</p>\n");
        sb.append("<p>");
        sb.append(Messages.getString("CONSOLIDATED_REPORT_EVAL_SUMMARY_REC"));
        sb.append("</p>\n");
        sb.append("</div>");
        sb.append("<div class=\"evaluate\">\n");
        this.evalWriter.writeTopSummaryTable(sb);
        sb.append("</div>");
        sb.append("<div class=\"header-sections\">\n");
        sb.append("<h2 id=\"rule_summary\">").append(Messages.getString("CONSOLIDATED_REPORT_SEVERITY_SUMMARY_HEADER")).append("</h2>\n");
        sb.append("</div>");
        sb.append("<div class=\"analyze\">\n");
        this.analyzeWriter.buildRuleSeveritySummary(sb, true);
        sb.append("</div>");
    }

    private void writeJumpTo(StringBuilder sb) {
        StringBuilder tempSB = new StringBuilder();
        tempSB.append("<div class=\"nav-wrapper na-fixed noprint\" role=\"navigation\" aria-label=\"Report Navigation Menu\">\n");
        tempSB.append("  <nav class=\"jump-to-nav\" aria-label=\"Report Navigation Menu Links\">\n");
        tempSB.append("  <ul>\n");
        tempSB.append("    <li>\n");
        tempSB.append("<a href=\"#\">");
        tempSB.append(Messages.getString("CONSOLIDATED_REPORT_JUMP_TO"));
        tempSB.append("<div class=\"scroll-bottom-caret show\">v</div>");
        tempSB.append("</a>\n");
        tempSB.append("      <ul class=\"inner--list--hide\">\n");
        tempSB.append("        <li id=\"backToTopNav\">");
        tempSB.append("<a href=\"#top\" class=\"na-title jump-item\">");
        tempSB.append(Messages.getString("ANALYSIS_REPORT_BACK_TO_TOP"));
        tempSB.append("</a>");
        tempSB.append("</li>\n");
        Matcher m = MATCH_JUMP_TO_SECTION_CONTENT_PATTERN.matcher(sb.toString());
        while (m.find()) {
            String element = m.group();
            String id = ReportUtility.getAttributeValue("id", element);
            String text = ReportUtility.getAttributeValue("text", element);
            if (text == null || id == null) continue;
            String htmlClass = this.getAppropriateJumpClass(id);
            tempSB.append("        <li><a href=\"#").append(id).append("\" class=\"").append(htmlClass).append("\">").append(text).append("</a>").append("</li>\n");
        }
        tempSB.append("      </ul>\n");
        tempSB.append("    </li>\n");
        tempSB.append("  </ul>\n");
        tempSB.append("  </nav>\n");
        tempSB.append("</div>\n");
        sb.insert(this.offsetOfJumpToRule, tempSB.toString());
    }

    private String getAppropriateJumpClass(String id) {
        String htmlClass = "na-title jump-item";
        if (MATCH_ID_EQUAL_CASES_PATTERN.matcher(id).matches()) {
            htmlClass = "na-sub-title jump-item";
        } else if (MATCH_ID_CONTAIN_CASES_PATTERN.matcher(id).matches()) {
            htmlClass = "jump-item";
        }
        return htmlClass;
    }

    private void writeBody(StringBuilder sb) {
        sb.append("<body id=\"top\" class=\"consolidated\">\n");
        sb.append("<div id=\"wrapper\" class=\"wrapper\" role=\"main\">\n");
        this.evalWriter.getFootNotesAndDetermineOverallSupportedPlatforms();
        this.targetPlatformFullySupported = this.targetAppServerIndex == -1 ? true : this.evalWriter.isPlatformFullySupported(this.targetAppServerIndex);
        this.writeBodyHeader(sb);
        this.writeMigrationDetails(sb);
        sb.append("</div>");
        this.writeJumpTo(sb);
        String js = ReportUtility.loadFileAsString("/help/ruleinfo/appconversion/resources/externalHelp.js");
        if (js != null) {
            sb.append("<script type=\"text/javascript\"> \n");
            String minifiedJS = ReportUtility.minifyJS(js);
            if (minifiedJS != null) {
                sb.append(minifiedJS);
            }
            sb.append("</script> \n");
        }
        this.invWriter.buildEmbeddedJS(sb);
        sb.append("</body>");
    }

    private void writeMigrationDetails(StringBuilder sb) {
        String out;
        sb.append("<div class=\"header-sections\">\n");
        sb.append("<h2 id=\"details\">").append(Messages.getString("CONSOLIDATED_REPORT_MIGRATION_DETAILS")).append("</h2>\n");
        sb.append("  <div class=\"expand-collapse-holder noprint\">\n");
        sb.append("    <a href=\"#\" class=\"expand-all almighty\">").append(Messages.getString("ANALYSIS_REPORT_EXPAND_ALL")).append("</a>\n");
        sb.append("    <a href=\"#\" class=\"collapse-all almighty disabled\">").append(Messages.getString("ANALYSIS_REPORT_COLLAPSE_ALL")).append("</a>\n");
        sb.append("  </div>\n");
        sb.append("</div>\n");
        sb.append("<ul>\n");
        this.writeTechEval(sb);
        this.writeMigrationAnal(sb);
        this.writeInventory(sb);
        if (this.isLiberty) {
            this.writeServerXml(sb);
        }
        sb.append("</ul>\n");
        if (ReportUtility.isWebApp() && !(out = ReportUtility.getLogOutputStream()).isEmpty()) {
            sb.append("<h3 class=\"log-message-title\">").append(Messages.getString("LOG_MESSAGES_TITLE")).append("</h3>\n");
            sb.append("<div class=\"log-message-textbox\">");
            sb.append("<ul>");
            sb.append(ReportUtility.encodeHTMLEntities(out));
            sb.append("</ul>");
            sb.append("</div>");
        }
    }

    private void writeTechEval(StringBuilder sb) {
        sb.append("<li id=\"evaluation\" class=\"evaluate archive\">\n");
        sb.append("<div class=\"archive-title\">\n");
        sb.append("<h3>\n").append(Messages.getString("CONSOLIDATED_REPORT_EVAL")).append("</h3>");
        sb.append("<div class=\"js-toggle-actions noprint\">\n");
        sb.append("<a href=\"#\" class=\"recommendation-toggle archive-toggle\">");
        sb.append(Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
        sb.append("</a>");
        sb.append("</div>");
        sb.append("</div>");
        sb.append("<div class=\"archive-details shared hide\">");
        sb.append("<p>").append(Messages.getString("CONSOLIDATED_REPORT_EVAL_TABLE_DESC")).append("</p>");
        sb.append(this.evalWriter.buildTechTable(this.tech, this.projects.get(0).replaceFirst(".*/", "")));
        this.evalWriter.writeFootnote(sb);
        sb.append("</div>");
        sb.append("</li>\n");
    }

    private void writeMigrationAnal(StringBuilder sb) {
        sb.append("<li id=\"analyze\" class=\"analyze archive\">\n");
        sb.append("<div class=\"archive-title\">\n");
        sb.append("<h3>\n").append(Messages.getString("CONSOLIDATED_REPORT_DETAILED_ANAL")).append("</h3>");
        sb.append("<div class=\"js-toggle-actions noprint\">\n");
        sb.append("<a href=\"#\" class=\"recommendation-toggle archive-toggle\">");
        sb.append(Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
        sb.append("</a>");
        sb.append("</div>");
        sb.append("</div>");
        sb.append("<div class=\"archive-details hide\">");
        this.analyzeWriter.buildArchiveQuantities(sb, true);
        int offsetOfSummary = sb.length();
        this.analyzeWriter.buildResultsByRule(sb);
        String connectivitySummary = this.analyzeWriter.buildConnectivitySummary();
        if (connectivitySummary != null) {
            sb.insert(offsetOfSummary, connectivitySummary);
        }
        this.analyzeWriter.buildAdditionalHelp(sb, true);
        if (this.analyzeWriter.analysisResults.containsAutomatedFix()) {
            this.analyzeWriter.buildAutomatedFixConfiguration(sb, true);
        }
        this.analyzeWriter.buildRulesAnalyzed(sb, true);
        sb.append("</div>");
        sb.append("</li>\n");
    }

    private void writeInventory(StringBuilder sb) {
        sb.append("<li id=\"inventory\" class=\"inventory archive\">\n");
        sb.append("<div class=\"archive-title\">\n");
        sb.append("<h3>\n").append(Messages.getString("CONSOLIDATED_REPORT_INVENTORY")).append("</h3>");
        sb.append("<div class=\"js-toggle-actions noprint\">\n");
        sb.append("<a href=\"#\" class=\"recommendation-toggle archive-toggle\">");
        sb.append(Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
        sb.append("</a>");
        sb.append("</div>");
        sb.append("</div>");
        sb.append("<div class=\"archive-details shared hide\">");
        this.invWriter.buildArchiveDetailsContent(sb, this.arc, true, true, 0);
        if (this.hasSharedLibraries) {
            this.invWriter.buildSharedLibDetails(sb, true);
        }
        sb.append("</div>");
        sb.append("</li>\n");
    }

    private void writeServerXml(StringBuilder sb) {
        boolean hasConfig;
        sb.append("<li id=\"generateConfig\" class=\"archive\">\n");
        sb.append("<div class=\"archive-title\">\n");
        sb.append("<h3>\n").append(Messages.getString("CONSOLIDATED_REPORT_SERVER_XML")).append("</h3>");
        sb.append("<div class=\"js-toggle-actions noprint\">\n");
        sb.append("<a href=\"#\" class=\"recommendation-toggle archive-toggle\">");
        sb.append(Messages.getString("INVENTORY_REPORT_SHOW_DETAILS"));
        sb.append("</a>");
        sb.append("</div>");
        sb.append("</div>");
        sb.append("<div class=\"archive-details shared hide\">");
        boolean hasCoreFeatures = !this.coreFeatures.isEmpty();
        boolean hasBaseFeatures = !this.baseFeatures.isEmpty();
        boolean bl = hasConfig = this.serverXml != null && this.serverXml != "";
        if (hasCoreFeatures || hasBaseFeatures || hasConfig) {
            if (!this.hasConflicts) {
                sb.append("<p>").append(Messages.getString("CONSOLIDATED_REPORT_SERVER_XML_DESC")).append("</p>\n");
                if (!this.targetPlatformFullySupported && !this.evalWriter.isPlatformFullySupported(2)) {
                    String HREF_TECHNOLOGY_EVALUATION = "<a class=\"blueAnchor jump-item\" href=\"#evaluation\">" + Messages.getString("CONSOLIDATED_REPORT_EVAL") + "</a>";
                    sb.append("<p><b>").append(Messages.getString("CONSOLIDATED_REPORT_NOTE")).append("</b> ");
                    sb.append(Messages.getFormattedMessage(Messages.getString("CONSOLIDATED_REPORT_FEATURE_LIST_NOT_FULLY_SUPPORTED"), HREF_TECHNOLOGY_EVALUATION)).append("</p>\n");
                }
                if (this.isLibertyCoreTarget && hasBaseFeatures) {
                    sb.append("<p><b>").append(Messages.getString("CONSOLIDATED_REPORT_WARNING")).append("</b> ");
                    sb.append(Messages.getFormattedMessage(Messages.getString("CONSOLIDATED_REPORT_FEATURE_LIST_FEATURES_NOT_AVAILABLE"), Messages.getString(HTMLEvaluationReportWriter.productEnum[this.targetAppServerIndex]))).append("</p>\n");
                }
                sb.append(ReportUtility.buildCopyArea(this.serverXml, "serverXml"));
            } else {
                sb.append("<p>").append(Messages.getFormattedMessage(Messages.getString("CONSOLIDATED_REPORT_FEATURE_LIST_ERROR"), ReportUtility.encodeHTMLEntities(this.projects.get(0).replaceFirst(".*/", "")))).append("</p>");
                if (hasCoreFeatures) {
                    sb.append("<p>").append(Messages.getString("CONSOLIDATED_REPORT_FEATURE_LIST_BASE")).append("</p>");
                    sb.append("    <ul class=\"rec-generateConfig\">");
                    for (String feature : this.coreFeatures) {
                        sb.append("        <li>").append(feature).append("</li>");
                    }
                    sb.append("</ul>");
                }
                if (hasBaseFeatures) {
                    sb.append("<p>").append(Messages.getString("CONSOLIDATED_REPORT_FEATURE_LIST_BASE")).append("</p>");
                    sb.append("    <ul class=\"rec-generateConfig\">");
                    for (String feature : this.baseFeatures) {
                        sb.append("        <li>").append(feature).append("</li>");
                    }
                    sb.append("</ul>");
                }
                for (String feature : this.featureConflictMessages) {
                    sb.append("        <p>").append(feature).append("</p>");
                }
            }
        } else {
            sb.append("<p>").append(Messages.getString("CONSOLIDATED_REPORT_FEATURE_LIST_NO_FEATURES")).append("</p>");
        }
        sb.append("</div>");
        sb.append("</li>\n");
    }

    @Override
    public void writeReport() {
        StringBuilder sb = new StringBuilder();
        ReportUtility.writeHtmlTag(sb);
        ReportUtility.writeHeader(sb, Messages.getString("CONSOLIDATED_REPORT_MIGRATION_DETAILS_TITLE"), Messages.getString("TECH_EVAL_REPORT_AUTHOR_BINARY_SCANNER"), true, this.evalWriter.getNumberOfColumns());
        this.writeBody(sb);
        sb.append("</html>\n");
        this.returnString = sb.toString();
    }

    @Override
    public String getResult() {
        return this.returnString;
    }
}

