/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.json;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.json.xml.XMLToJSONTransformer;
import com.ibm.ws.report.Messages;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.utilities.XMLHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AssessmentUnitWriter {
    private final String domain;
    private final String middleWare;
    private final String binaryScannerVersion;
    private final String hostname;
    private final String assessmentUnitName;
    private String applicationName;
    private String checksum;
    private final String connectionUnitType;
    private final String connectionUnitName;
    private boolean isVirtual;
    private final Properties identifier;
    private final List<AssessmentUnitWriter> rawDependencies;
    private final boolean isSharedLib;

    public AssessmentUnitWriter(String domain, String middleWare, String binaryScannerVersion, String hostname, String assessmentUnitName, String connectionUnitType, String connectionUnitName) {
        this.domain = domain;
        this.middleWare = middleWare;
        this.binaryScannerVersion = binaryScannerVersion;
        this.hostname = hostname;
        this.applicationName = this.assessmentUnitName = assessmentUnitName;
        this.connectionUnitType = connectionUnitType;
        this.connectionUnitName = connectionUnitName;
        this.identifier = new Properties();
        this.rawDependencies = new ArrayList<AssessmentUnitWriter>();
        this.isVirtual = false;
        this.isSharedLib = false;
    }

    public AssessmentUnitWriter(String domain, String middleWare, String binaryScannerVersion, String hostname, String assessmentUnitName, String applicationName, String connectionUnitType, String connectionUnitName, String libraryName, String profileName, String checksum, boolean isOutsideLib) {
        this.isSharedLib = libraryName != null;
        this.domain = domain;
        this.middleWare = middleWare;
        this.binaryScannerVersion = binaryScannerVersion;
        this.hostname = hostname;
        this.assessmentUnitName = this.isSharedLib && !isOutsideLib ? String.valueOf(libraryName) + "-" + assessmentUnitName : assessmentUnitName;
        this.applicationName = this.isSharedLib && !isOutsideLib ? String.valueOf(libraryName) + "-" + assessmentUnitName : assessmentUnitName;
        this.connectionUnitType = connectionUnitType;
        this.connectionUnitName = connectionUnitName;
        this.identifier = new Properties();
        if (this.isSharedLib && !isOutsideLib) {
            this.createLibraryIdentifier(connectionUnitName, libraryName, profileName);
        }
        this.rawDependencies = new ArrayList<AssessmentUnitWriter>();
        this.isVirtual = false;
        this.checksum = checksum;
    }

    public void createLibraryIdentifier(String connectionUnitName, String libraryName, String profileName) {
        this.identifier.put("sharedLibraryName", libraryName);
        this.identifier.put("profile", profileName);
        this.identifier.put("assessmentUnitName", this.assessmentUnitName);
    }

    public String getAssessmentUnitName() {
        return this.assessmentUnitName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void addIdentifier(String key, Object value) {
        this.identifier.put(key, value);
    }

    public void addDependency(AssessmentUnitWriter aUnit) {
        this.rawDependencies.add(aUnit);
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public boolean hasRawDependency() {
        return this.rawDependencies != null && !this.rawDependencies.isEmpty();
    }

    public List<AssessmentUnitWriter> getRawDependencies() {
        return this.rawDependencies;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void markAsVirtual() {
        this.isVirtual = true;
    }

    public OrderedJSONObject toJSONObject() {
        OrderedJSONObject assessUnitJson = new OrderedJSONObject();
        assessUnitJson.put("domain", this.domain);
        assessUnitJson.put("middleware", this.middleWare);
        if (this.hostname != null) {
            assessUnitJson.put("host", this.hostname);
        }
        if (this.assessmentUnitName != null) {
            assessUnitJson.put("assessmentUnitName", this.assessmentUnitName);
        }
        if (this.applicationName != null) {
            assessUnitJson.put("applicationName", this.applicationName);
        }
        if (this.checksum != null) {
            assessUnitJson.put("checksum", this.checksum);
        }
        if (this.binaryScannerVersion != null) {
            assessUnitJson.put("dcVersion", "");
            assessUnitJson.put("binaryScannerVersion", this.binaryScannerVersion);
        }
        if (this.connectionUnitType != null) {
            assessUnitJson.put("collectionUnitType", this.connectionUnitType);
        }
        if (this.connectionUnitName != null) {
            assessUnitJson.put("collectionUnitName", this.connectionUnitName);
        }
        if (this.isVirtual) {
            assessUnitJson.put("isVirtual", Boolean.TRUE.toString());
        } else {
            assessUnitJson.put("isVirtual", Boolean.FALSE.toString());
        }
        if (!this.identifier.isEmpty()) {
            OrderedJSONObject identifierObject = new OrderedJSONObject();
            TreeSet<String> identifierKeys = new TreeSet<String>(this.identifier.stringPropertyNames());
            for (String identifierKey : identifierKeys) {
                identifierObject.put(identifierKey, this.identifier.getProperty(identifierKey));
            }
            assessUnitJson.put("identifier", identifierObject);
        }
        if (!this.rawDependencies.isEmpty()) {
            JSONArray dependencyArray = new JSONArray();
            for (AssessmentUnitWriter dependency : this.rawDependencies) {
                dependencyArray.add(dependency.toJSONObject());
            }
            assessUnitJson.put("rawDependencies", dependencyArray);
        }
        return assessUnitJson;
    }

    public void writeToJsonFile(String outputDir) {
        String name2 = this.isSharedLib ? this.assessmentUnitName.replace(String.valueOf(this.identifier.getProperty("sharedLibraryName")) + "-", "") : this.assessmentUnitName;
        File outputFile = new File(String.valueOf(outputDir) + File.separator + name2 + "." + "assessmentUnit.json");
        ReportUtility.logger.get().log(Level.FINE, "Write the assessmentUnit.json file in " + outputFile);
        String serverXmlPath = String.valueOf(outputDir) + File.separator + this.assessmentUnitName + "_" + "server.xml";
        boolean hasServerXML = false;
        if (!this.isSharedLib) {
            try {
                File file = new File(serverXmlPath);
                if (file.exists()) {
                    hasServerXML = true;
                    FileInputStream xmlFile = new FileInputStream(file);
                    Document xmlDoc = XMLHelper.getParsedDocument(xmlFile);
                    if (xmlDoc != null) {
                        this.addDataBaseRawDependencies(xmlDoc);
                    }
                }
            }
            catch (Exception e) {
                if (ReportUtility.shouldExceptionsBeLogged()) {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getString("ReportBuilder_Server_XML_Parse_Error"), e);
                }
                ReportUtility.logger.get().log(Level.WARNING, Messages.getString("ReportBuilder_Server_XML_Parse_Error"));
            }
        }
        OrderedJSONObject assessUnitJson = this.toJSONObject();
        if ("javaAppServer".equalsIgnoreCase(this.domain) && hasServerXML) {
            ReportUtility.logger.get().log(Level.FINE, "insert app specific server xml file : " + serverXmlPath + " to assessment.json file");
            try {
                String s = XMLToJSONTransformer.transform(new File(serverXmlPath));
                JSONObject serverXmlJson = JSONObject.parse(s);
                JSONObject featureManagerJE = (JSONObject)((JSONObject)serverXmlJson.get("server")).get("featureManager");
                if (featureManagerJE.isEmpty()) {
                    OrderedJSONObject featureManJO = new OrderedJSONObject();
                    featureManJO.put("feature", new JSONArray());
                    ((JSONObject)serverXmlJson.get("server")).put("featureManager", featureManJO);
                }
                assessUnitJson.put("serverXml", serverXmlJson);
            }
            catch (IOException e) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("ReportBuilder_Server_XML_Insert_Error"), this.assessmentUnitName), e);
            }
            catch (SAXException se) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getString("ReportBuilder_Server_XML_Parse_Error"), se);
            }
        }
        try {
            ReportUtility.writeOutStream(outputFile, assessUnitJson.serialize(true).replace("\\/", "/"));
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("ReportBuilder_AssessmentUnit_Fail"), this.assessmentUnitName), e);
        }
    }

    public void addDataBaseRawDependencies(Document xmlDoc) {
        NodeList dataSourceNL = xmlDoc.getElementsByTagName("dataSource");
        int dataSourceIndex = 0;
        while (dataSourceIndex < dataSourceNL.getLength()) {
            Node dataSourceNode = dataSourceNL.item(dataSourceIndex);
            NodeList dataSourceChildrenNL = dataSourceNode.getChildNodes();
            int dataSourceChildSize = dataSourceChildrenNL.getLength();
            int i = 0;
            while (i < dataSourceChildSize) {
                Element dataSourceChild;
                String tagName;
                Node childNode = dataSourceChildrenNL.item(i);
                if (childNode instanceof Element && (tagName = (dataSourceChild = (Element)dataSourceChildrenNL.item(i)).getNodeName()).startsWith("properties")) {
                    String[] pLabelSplit = tagName.split("\\.");
                    String middleware = "mysql";
                    if (pLabelSplit.length > 1 && (middleware = pLabelSplit[1]).equals("microsoft")) {
                        middleware = pLabelSplit[2];
                    }
                    NamedNodeMap attributes = dataSourceChild.getAttributes();
                    int attributeSize = attributes.getLength();
                    int j = 0;
                    while (j < attributeSize) {
                        String[] arr;
                        String dbName = "";
                        Node attribute = attributes.item(j);
                        if (attribute.getNodeName().equals("databaseName")) {
                            dbName = attribute.getNodeValue();
                        } else if (attribute.getNodeName().equals("URL")) {
                            arr = attribute.getNodeValue().split(":");
                            dbName = arr[arr.length - 1];
                        }
                        if (!dbName.isEmpty()) {
                            if (dbName.contains("/")) {
                                arr = dbName.split("/");
                                dbName = arr[arr.length - 1];
                            }
                            AssessmentUnitWriter dbAssessUnit = new AssessmentUnitWriter("database", middleware, null, null, dbName, "instance", null);
                            dbAssessUnit.addIdentifier("databaseName", dbName);
                            if (attribute.getNodeName().equals("portNumber")) {
                                dbAssessUnit.addIdentifier("portNumber", attribute.getNodeValue());
                            }
                            if (attribute.getNodeName().equals("URL")) {
                                dbAssessUnit.addIdentifier("url", attribute.getNodeValue());
                            }
                            this.addDependency(dbAssessUnit);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++dataSourceIndex;
        }
    }

    public void addMQRawDependencies(Document xmlDoc) {
        HashMap<String, HashSet<String>> queueManagerMap = new HashMap<String, HashSet<String>>();
        HashMap<String, HashSet<String>> queueManagerTopicMap = new HashMap<String, HashSet<String>>();
        NodeList nl = xmlDoc.getElementsByTagName("jmsActivationSpec");
        if (nl.getLength() > 0) {
            Set<String> baseQueueNameSet;
            String queManager;
            Node queueNameAttr;
            Node jmsQueueNode;
            NamedNodeMap jmsQueueAttrs;
            Node jndiNameAttr;
            Node jmsActivationSpecNode = nl.item(0);
            NamedNodeMap jmsActivationSpeceAttrs = jmsActivationSpecNode.getAttributes();
            Node queueManagerAttr = jmsActivationSpeceAttrs.getNamedItem("queueManager");
            Node destinationRefAttr = jmsActivationSpeceAttrs.getNamedItem("destinationRef");
            nl = xmlDoc.getElementsByTagName("jmsQueue");
            if (nl.getLength() > 0 && (jndiNameAttr = (jmsQueueAttrs = (jmsQueueNode = nl.item(0)).getAttributes()).getNamedItem("jndiName")) != null && destinationRefAttr != null && jndiNameAttr.getNodeName().equals(destinationRefAttr.getNodeName()) && (queueNameAttr = jmsQueueAttrs.getNamedItem("baseQueueName")) != null && queueManagerAttr != null) {
                queManager = queueManagerAttr.getNodeName();
                String queueName = queueNameAttr.getNodeName().toUpperCase();
                baseQueueNameSet = (HashSet<String>)queueManagerMap.get(queManager);
                if (baseQueueNameSet == null) {
                    baseQueueNameSet = new HashSet<String>();
                    queueManagerMap.put(queManager, (HashSet<String>)baseQueueNameSet);
                }
                baseQueueNameSet.add(queueName);
            }
            if ((nl = xmlDoc.getElementsByTagName("jmsTopic")).getLength() > 0 && (jndiNameAttr = (jmsQueueAttrs = (jmsQueueNode = nl.item(0)).getAttributes()).getNamedItem("jndiName")) != null && destinationRefAttr != null && jndiNameAttr.getNodeName().equals(destinationRefAttr.getNodeName()) && (queueNameAttr = jmsQueueAttrs.getNamedItem("baseTopicName")) != null && queueManagerAttr != null) {
                queManager = queueManagerAttr.getNodeName();
                String topicName = queueNameAttr.getNodeName().toUpperCase();
                HashSet<String> baseTopicNameSet = (HashSet<String>)queueManagerTopicMap.get(queManager);
                if (baseTopicNameSet == null) {
                    baseTopicNameSet = new HashSet<String>();
                    queueManagerTopicMap.put(queManager, baseTopicNameSet);
                }
                baseTopicNameSet.add(topicName);
            }
            new ArrayList();
            nl = xmlDoc.getElementsByTagName("properties.wmqJms");
            if (nl.getLength() > 0) {
                Node wmqJmsNode = nl.item(0);
                NamedNodeMap wmqJmsAttrs = wmqJmsNode.getAttributes();
                Node baseQueueManagerNameAttr = wmqJmsAttrs.getNamedItem("baseQueueManagerName");
                Node baseQueueNameAttr = wmqJmsAttrs.getNamedItem("baseQueueName");
                if (baseQueueManagerNameAttr != null && baseQueueNameAttr != null) {
                    String baseQueueManagerName = baseQueueManagerNameAttr.getNodeName();
                    String baseQueueName = baseQueueNameAttr.getNodeName();
                    baseQueueNameSet = (Set)queueManagerMap.get(baseQueueManagerName);
                    if (baseQueueNameSet == null) {
                        baseQueueNameSet = new HashSet();
                        queueManagerMap.put(baseQueueManagerName, (HashSet<String>)baseQueueNameSet);
                    }
                    baseQueueNameSet.add(baseQueueName);
                }
            }
        }
    }
}

