/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.text;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.technology.TechSummary;
import com.ibm.ws.report.writer.ReportWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class TextEvaluationReportWriter
implements ReportWriter {
    private final boolean darkColorRow = true;
    private SortedMap<String, String> scanOptions = null;
    private static SimpleDateFormat localDateFormat = new SimpleDateFormat();
    private static final int ROW_FOR_OPEN_LIBERTY = 0;
    private static final int ROW_FOR_LIBERTY_CORE_855 = 1;
    private static final int ROW_FOR_LIBERTY_PROFLIE_855 = 2;
    private static final int ROW_FOR_FULL_855 = 3;
    private static final int ROW_FOR_LIBERTY_PROFILE_ND_855 = 4;
    private static final int ROW_FOR_FULL_ND_855 = 5;
    private static final int ROW_FOR_LIBERTY_PROFILE_ZOS_855 = 6;
    private static final int ROW_FOR_FULL_ZOS_855 = 7;
    private boolean hasSingleSummaryTable = false;
    private final boolean[] showColumn = new boolean[9];
    private boolean[] supportedPlatforms = new boolean[]{true, true, true, true, true, true, true, true, true};
    private SortedMap<String, TechSummary> listOfTechSummaries = null;
    private final String[] columnNames = new String[]{"OpenLiberty", "WASLibertyCore", "WASLibertyProfile", "WASFullProfile", "WASNDLiberty", "WASNDFullProfile", "WASZOSLiberty", "WASZOSFull"};
    private List<String> projects = null;
    private static String newLine = System.getProperty("line.separator");
    private static final String fourSpaces = "    ";
    private static final String eightSpaces = "        ";
    String returnString;

    public TextEvaluationReportWriter(List<String> arrayOfProjects, SortedMap<String, TechSummary> listOfTechSummaries) {
        this.projects = arrayOfProjects;
        this.listOfTechSummaries = listOfTechSummaries;
        this.hasSingleSummaryTable = listOfTechSummaries.size() == 1;
    }

    public TextEvaluationReportWriter(List<String> arrayOfProjects, SortedMap<String, TechSummary> listOfTechSummaries, List<String> productsToShow, SortedMap<String, String> scanOptions) {
        this(arrayOfProjects, listOfTechSummaries, productsToShow);
        this.scanOptions = scanOptions;
    }

    public TextEvaluationReportWriter(List<String> arrayOfProjects, SortedMap<String, TechSummary> listOfTechSummaries, List<String> productsToShow) {
        this.projects = arrayOfProjects;
        this.listOfTechSummaries = listOfTechSummaries;
        this.hasSingleSummaryTable = listOfTechSummaries.size() == 1;
        for (String product : productsToShow) {
            if (product.equals(Messages.getString("OpenLiberty"))) {
                this.showColumn[0] = true;
                continue;
            }
            if (product.equals(Messages.getString("WASLibertyCore"))) {
                this.showColumn[1] = true;
                continue;
            }
            if (product.equals(Messages.getString("WASLibertyProfile"))) {
                this.showColumn[2] = true;
                continue;
            }
            if (product.equals(Messages.getString("WASFullProfile"))) {
                this.showColumn[3] = true;
                continue;
            }
            if (product.equals(Messages.getString("WASNDLiberty"))) {
                this.showColumn[4] = true;
                continue;
            }
            if (product.equals(Messages.getString("WASNDFullProfile"))) {
                this.showColumn[5] = true;
                continue;
            }
            if (product.equals(Messages.getString("WASZOSLiberty"))) {
                this.showColumn[6] = true;
                continue;
            }
            if (!product.equals(Messages.getString("WASZOSFull"))) continue;
            this.showColumn[7] = true;
        }
    }

    public TextEvaluationReportWriter() {
    }

    private void writeHeader(StringBuilder sb) {
        sb.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        sb.append(Messages.getString("TECH_EVAL_REPORT_TITLE_FOR_TEXT_FORMAT"));
        sb.append(newLine);
        sb.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        sb.append(Messages.getFormattedMessage(Messages.getString("TECH_EVAL_REPORT_FOOTER"), localDateFormat.format(new Date())));
        sb.append(newLine);
        if (this.projects != null) {
            int rowCounter = 0;
            int total = this.projects.size();
            for (String item : this.projects) {
                if (++rowCounter < total) {
                    sb.append(item);
                    sb.append(newLine);
                    continue;
                }
                sb.append(item);
            }
        }
        sb.append(newLine);
        if (this.scanOptions != null && this.scanOptions.keySet().size() > 0) {
            sb.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
            sb.append(Messages.getFormattedMessage(Messages.getString("TECH_EVAL_REPORT_OPTIONS"), this.scanOptions.values().toString()));
        }
        sb.append(newLine);
    }

    private void writeBody(StringBuilder sb) {
        sb.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        sb.append(Messages.getString("TECH_EVAL_REPORT_HEADER_DETAILED_ANALYSIS"));
        sb.append(newLine);
        sb.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        sb.append(Messages.getString("ANALYSIS_REPORT_SUMMARY"));
        sb.append(newLine);
        sb.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        boolean[] platformsSupported = this.hasSingleSummaryTable ? this.listOfTechSummaries.values().iterator().next().getSupportedPlatforms() : this.supportedPlatforms;
        this.writeSummaryTable(sb, platformsSupported, this.hasSingleSummaryTable);
        sb.append(newLine);
        this.writeTechnologyDetailsSection(sb);
    }

    private void writeTechnologyDetailsSection(StringBuilder sb) {
        sb.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        sb.append(Messages.getString("TECH_EVAL_BREAKDOWN"));
        sb.append(newLine);
        int remainingTech = this.listOfTechSummaries.size();
        for (String key : this.projects) {
            TechSummary summary = (TechSummary)this.listOfTechSummaries.get(key);
            sb.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
            sb.append(Messages.getFormattedMessage(Messages.getString("INVENTORY_REPORT_APP"), summary.getProjectName().replaceFirst(".*/", "")));
            sb.append(newLine);
            sb.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
            if (!this.hasSingleSummaryTable) {
                this.writeSummaryTable(sb, summary.getSupportedPlatforms(), true);
                sb.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
            }
            sb.append(this.buildTechTable(summary));
            if (--remainingTech == 0) continue;
            sb.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
            sb.append(newLine);
        }
    }

    private String buildTechTable(TechSummary summary) {
        StringBuilder tableSB = new StringBuilder();
        TreeMap<TechSummary.OrderedTech, TreeSet<TechSummary.OrderedTech>> mapOfRowHeaderToTechnologies = summary.getMapOfRowHeaderToTechnologies();
        if (mapOfRowHeaderToTechnologies.isEmpty()) {
            tableSB.append(Messages.getString("TECH_EVAL_REPORT_HEADER_TXT_ALT"));
            tableSB.append(newLine);
        } else {
            tableSB.append(Messages.getString("TECH_EVAL_REPORT_HEADER_TXT"));
            tableSB.append(newLine);
            for (TechSummary.OrderedTech techLineBreak : mapOfRowHeaderToTechnologies.keySet()) {
                String tableLine = this.buildLineBreak(techLineBreak.getTech().getName(), techLineBreak.getTech().getSupport(), true);
                tableSB.append(tableLine);
                TreeSet<TechSummary.OrderedTech> setOfTech = mapOfRowHeaderToTechnologies.get(techLineBreak);
                for (TechSummary.OrderedTech orderedTech : setOfTech) {
                    tableLine = this.buildRow(orderedTech.getTech().getName(), orderedTech.getTech().getSupport(), true);
                    tableSB.append(tableLine);
                }
            }
        }
        return tableSB.toString();
    }

    private void writeSummaryTable(StringBuilder sb, boolean[] platformsSupported, boolean singleApp) {
        StringBuilder summarySB = new StringBuilder();
        String appendString = singleApp ? Messages.getString("TECH_EVAL_SUMMARY_SPECIFIED_PRODUCTS_SUPPORT") : Messages.getString("TECH_EVAL_SUMMARY_SPECIFIED_PRODUCTS_SUPPORT_PLURAL");
        summarySB.append(appendString);
        summarySB.append(newLine);
        boolean hasProducts = true;
        int i = 0;
        while (i < this.showColumn.length) {
            if (this.showColumn[i] && platformsSupported[i]) {
                hasProducts = false;
                summarySB.append(fourSpaces);
                summarySB.append(Messages.getString(this.columnNames[i]));
                summarySB.append(newLine);
            }
            ++i;
        }
        if (hasProducts) {
            summarySB.append(fourSpaces);
            summarySB.append(Messages.getString("ANALYSIS_REPORT_SEVERITY_NONE_LABEL"));
            summarySB.append(newLine);
        }
        appendString = singleApp ? Messages.getString("TECH_EVAL_SUMMARY_SPECIFIED_PRODUCTS_DO_NOT_SUPPORT") : Messages.getString("TECH_EVAL_SUMMARY_SPECIFIED_PRODUCTS_DO_NOT_SUPPORT_PLURAL");
        summarySB.append(appendString);
        summarySB.append(newLine);
        hasProducts = true;
        i = 0;
        while (i < this.showColumn.length) {
            if (this.showColumn[i] && !platformsSupported[i]) {
                hasProducts = false;
                summarySB.append(fourSpaces);
                summarySB.append(Messages.getString(this.columnNames[i]));
                summarySB.append(newLine);
            }
            ++i;
        }
        if (hasProducts) {
            summarySB.append(fourSpaces);
            summarySB.append(Messages.getString("ANALYSIS_REPORT_SEVERITY_NONE_LABEL"));
            summarySB.append(newLine);
        }
        sb.append((CharSequence)summarySB);
    }

    private String buildRow(String label, int[] rowXs, boolean rowColorDark) {
        StringBuilder row = new StringBuilder();
        row.append(Messages.getFormattedMessage(Messages.getString("TECH_EVAL_TECHNOLOGY_DETECTED"), label));
        row.append(newLine);
        row.append(Messages.getString("TECH_EVAL_SPECIFIED_PRODUCTS_SUPPORT"));
        row.append(newLine);
        boolean hasPlatforms = true;
        int i = 0;
        while (i < this.showColumn.length) {
            if (this.showColumn[i] && rowXs[i] != -1) {
                hasPlatforms = false;
                row.append(eightSpaces);
                row.append(Messages.getString(this.columnNames[i]));
                row.append(newLine);
            }
            ++i;
        }
        if (hasPlatforms) {
            row.append(eightSpaces);
            row.append(Messages.getString("ANALYSIS_REPORT_SEVERITY_NONE_LABEL"));
            row.append(newLine);
        }
        row.append(Messages.getString("TECH_EVAL_SPECIFIED_PRODUCTS_DO_NOT_SUPPORT"));
        row.append(newLine);
        hasPlatforms = true;
        i = 0;
        while (i < this.showColumn.length) {
            if (this.showColumn[i] && rowXs[i] == -1) {
                hasPlatforms = false;
                row.append(eightSpaces);
                row.append(Messages.getString(this.columnNames[i]));
                row.append(newLine);
            }
            ++i;
        }
        if (hasPlatforms) {
            row.append(eightSpaces);
            row.append(Messages.getString("ANALYSIS_REPORT_SEVERITY_NONE_LABEL"));
            row.append(newLine);
        }
        return row.toString();
    }

    private String buildLineBreak(String label, int[] rowXs, boolean rowColorDark) {
        String key = label.substring(12, label.length());
        StringBuilder row = new StringBuilder();
        row.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        row.append(key);
        row.append(newLine);
        row.append(Messages.getString("TECH_EVAL_REPORT_SEPARATOR"));
        return row.toString();
    }

    @Override
    public String getResult() {
        return this.returnString;
    }

    @Override
    public void writeReport() {
        StringBuilder sb = new StringBuilder(65536);
        this.determineOverallPlatformSupport();
        this.writeHeader(sb);
        this.writeBody(sb);
        this.returnString = sb.toString();
    }

    private void determineOverallPlatformSupport() {
        if (!this.hasSingleSummaryTable) {
            for (TechSummary summary : this.listOfTechSummaries.values()) {
                boolean[] platformsSupportedByApp = summary.getSupportedPlatforms();
                int i = 0;
                while (i < platformsSupportedByApp.length) {
                    this.supportedPlatforms[i] = !platformsSupportedByApp[i] ? false : this.supportedPlatforms[i];
                    ++i;
                }
            }
        } else {
            this.supportedPlatforms = this.listOfTechSummaries.values().iterator().next().getSupportedPlatforms();
        }
    }
}

