/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.xml;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.utilities.ServerXmlFormatter;
import com.ibm.ws.report.utilities.XMLHelper;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class ServerXmlWriter {
    private static final String SERVER_ELEMENT = "server";
    private static final String SERVER_DESC_ATTR = "description";
    private static final String FEATURE_MANAGER_ELEMENT = "featureManager";
    private static final String FEATURE_ELEMENT = "feature";
    private static final String SERVER_DESC = "Feature list generated by binaryAppScanner";

    public static String buildServerXML(Collection<String> coreFeatures, Collection<String> baseFeatures, String migratedConfig, boolean isOpenLiberty, boolean hasConflicts) throws TransformerException {
        String serverXml = "";
        if (coreFeatures.isEmpty() && baseFeatures.isEmpty() && migratedConfig == null) {
            return serverXml;
        }
        Document xmlDoc = ServerXmlWriter.initDoc(migratedConfig);
        if (xmlDoc != null) {
            Element featureManagerElement = (Element)xmlDoc.getElementsByTagName(FEATURE_MANAGER_ELEMENT).item(0);
            if (coreFeatures.isEmpty() && baseFeatures.isEmpty()) {
                Comment comment = xmlDoc.createComment(Messages.getString("CONSOLIDATED_REPORT_FEATURE_LIST_NO_FEATURES_DETECTED"));
                featureManagerElement.appendChild(comment);
            } else {
                if (hasConflicts) {
                    Comment comment = xmlDoc.createComment(Messages.getString("Invalid_Feature_List_Server_Xml_Comment"));
                    featureManagerElement.appendChild(comment);
                }
                if (!isOpenLiberty) {
                    if (!coreFeatures.isEmpty()) {
                        ServerXmlWriter.addFeatureElements(xmlDoc, coreFeatures, featureManagerElement, "core");
                    }
                    if (!baseFeatures.isEmpty()) {
                        ServerXmlWriter.addFeatureElements(xmlDoc, baseFeatures, featureManagerElement, "base");
                    }
                } else {
                    ArrayList<String> openLibertyFeatures = new ArrayList<String>();
                    openLibertyFeatures.addAll(baseFeatures);
                    openLibertyFeatures.addAll(coreFeatures);
                    ServerXmlWriter.addFeatureElements(xmlDoc, openLibertyFeatures, featureManagerElement, "openLiberty");
                }
            }
            serverXml = XMLHelper.getStringFromDocument(xmlDoc, true);
            serverXml = serverXml.replace(" standalone=\"no\"", "");
            serverXml = serverXml.replaceAll("((jndiEntry.*value=)\"((?!.*&quot;|.*').*)\")", "$2'\"$3\"'");
            if (migratedConfig != null && !migratedConfig.trim().isEmpty()) {
                serverXml = ServerXmlFormatter.formatServerXml(serverXml);
            }
        }
        return serverXml;
    }

    private static Document initDoc(String migratedConfig) {
        ReportUtility.logger.get().log(Level.FINE, "Initializing config writer with migrated config: \n" + migratedConfig);
        Document xmlDoc = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            if (migratedConfig != null) {
                InputSource is = new InputSource(new StringReader(migratedConfig));
                xmlDoc = docBuilder.parse(is);
            } else {
                xmlDoc = docBuilder.newDocument();
                Element serverElement = xmlDoc.createElement(SERVER_ELEMENT);
                xmlDoc.appendChild(serverElement);
                Attr attr = xmlDoc.createAttribute(SERVER_DESC_ATTR);
                attr.setValue(SERVER_DESC);
                serverElement.setAttributeNode(attr);
                Element featureManagerElement = xmlDoc.createElement(FEATURE_MANAGER_ELEMENT);
                serverElement.appendChild(featureManagerElement);
            }
        }
        catch (Exception e) {
            if (ReportUtility.isDebug()) {
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getString("ConfigWriter_XML_Doc_Init_Error_Log"), e);
            }
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("ConfigWriter_XML_Doc_Init_Error"), e.getMessage()));
        }
        return xmlDoc;
    }

    public String getSerialStringFromDocument(Document doc) throws TransformerException {
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)doc.getImplementation());
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        return lsSerializer.writeToString(doc);
    }

    private static void addFeatureElements(Document xmlDoc, Collection<String> featureList, Element parentElement, String version) {
        Comment comment = null;
        if (version != null) {
            if (version.equals("core")) {
                comment = xmlDoc.createComment(Messages.getString("CONSOLIDATED_REPORT_FEATURE_LIST_CORE_MESSAGE"));
            } else if (version.equals("base")) {
                comment = xmlDoc.createComment(Messages.getString("CONSOLIDATED_REPORT_FEATURE_LIST_BASE_MESSAGE"));
            } else if (version.equals("openLiberty")) {
                comment = xmlDoc.createComment(Messages.getString("CONSOLIDATED_REPORT_FEATURE_LIST_OPEN_LIBERTY_MESSAGE"));
            }
            parentElement.appendChild(comment);
        }
        ArrayList<String> sortedFeatures = new ArrayList<String>(featureList);
        Collections.sort(sortedFeatures);
        for (String ftr : sortedFeatures) {
            Element feature = xmlDoc.createElement(FEATURE_ELEMENT);
            feature.appendChild(xmlDoc.createTextNode(ftr));
            parentElement.appendChild(feature);
        }
    }
}

