/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.buddy;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.buddy.IBuddyPolicy;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class GlobalPolicy
implements IBuddyPolicy {
    private PackageAdmin admin;

    public GlobalPolicy(PackageAdmin admin) {
        this.admin = admin;
    }

    @Override
    public Class<?> loadClass(String name2) {
        ExportedPackage pkg = this.admin.getExportedPackage(BundleLoader.getPackageName(name2));
        if (pkg == null) {
            return null;
        }
        try {
            return pkg.getExportingBundle().loadClass(name2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public URL loadResource(String name2) {
        ExportedPackage pkg = this.admin.getExportedPackage(BundleLoader.getResourcePackageName(name2));
        if (pkg == null) {
            return null;
        }
        return pkg.getExportingBundle().getResource(name2);
    }

    @Override
    public Enumeration<URL> loadResources(String name2) {
        ExportedPackage[] pkgs = this.admin.getExportedPackages(BundleLoader.getResourcePackageName(name2));
        if (pkgs == null || pkgs.length == 0) {
            return null;
        }
        Enumeration<URL> results = null;
        int i = 0;
        while (i < pkgs.length) {
            try {
                results = BundleLoader.compoundEnumerations(results, pkgs[i].getExportingBundle().getResources(name2));
            }
            catch (IOException iOException) {}
            ++i;
        }
        return results;
    }
}

