/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.signedcontent;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import org.eclipse.osgi.internal.signedcontent.SignatureBlockProcessor;
import org.eclipse.osgi.internal.signedcontent.SignedBundleHook;
import org.eclipse.osgi.internal.signedcontent.SignedContentConstants;
import org.eclipse.osgi.internal.signedcontent.SignedContentImpl;
import org.eclipse.osgi.internal.signedcontent.SignedContentMessages;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentEntry;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.eclipse.osgi.util.NLS;

public class SignedBundleFile
extends BundleFileWrapper
implements SignedContentConstants,
SignedContent {
    SignedContentImpl signedContent;
    private final int supportFlags;
    private final SignedBundleHook signedBundleHook;

    SignedBundleFile(BundleFile bundleFile, SignedContentImpl signedContent, int supportFlags, SignedBundleHook signedBundleHook) {
        super(bundleFile);
        this.signedContent = signedContent;
        this.supportFlags = supportFlags;
        this.signedBundleHook = signedBundleHook;
    }

    void initializeSignedContent() throws IOException, InvalidKeyException, SignatureException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        if (this.signedContent == null) {
            SignatureBlockProcessor signatureProcessor = new SignatureBlockProcessor(this, this.supportFlags, this.signedBundleHook);
            this.signedContent = signatureProcessor.process();
            if (this.signedContent != null) {
                this.signedBundleHook.determineTrust(this.signedContent, this.supportFlags);
            }
        }
    }

    @Override
    public BundleEntry getEntry(String path) {
        int lastSlash;
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        BundleEntry be = this.getBundleFile().getEntry(path);
        if ((this.supportFlags & 4) == 0 || this.signedContent == null) {
            return be;
        }
        if (path.startsWith("META-INF/") && (lastSlash = path.lastIndexOf(47)) == "META-INF/".length() - 1) {
            if (path.equals("META-INF/MANIFEST.MF") || path.endsWith(".DSA") || path.endsWith(".RSA") || path.endsWith(".SF") || path.indexOf("SIG-") == "META-INF/".length()) {
                return be;
            }
            SignedContentEntry signedEntry = this.signedContent.getSignedEntry(path);
            if (signedEntry == null) {
                return be;
            }
        }
        if (be == null) {
            SignedContentEntry signedEntry = this.signedContent.getSignedEntry(path);
            if (signedEntry != null) {
                throw new SecurityException(NLS.bind(SignedContentMessages.file_is_removed_from_jar, path, this.getBaseFile().toString()));
            }
            return null;
        }
        return new SignedBundleEntry(be);
    }

    SignedContentImpl getSignedContent() {
        return this.signedContent;
    }

    @Override
    public SignedContentEntry[] getSignedEntries() {
        return this.signedContent == null ? null : this.signedContent.getSignedEntries();
    }

    @Override
    public SignedContentEntry getSignedEntry(String name2) {
        return this.signedContent == null ? null : this.signedContent.getSignedEntry(name2);
    }

    @Override
    public SignerInfo[] getSignerInfos() {
        return this.signedContent == null ? null : this.signedContent.getSignerInfos();
    }

    @Override
    public Date getSigningTime(SignerInfo signerInfo) {
        return this.signedContent == null ? null : this.signedContent.getSigningTime(signerInfo);
    }

    @Override
    public SignerInfo getTSASignerInfo(SignerInfo signerInfo) {
        return this.signedContent == null ? null : this.signedContent.getTSASignerInfo(signerInfo);
    }

    @Override
    public boolean isSigned() {
        return this.signedContent == null ? false : this.signedContent.isSigned();
    }

    @Override
    public void checkValidity(SignerInfo signerInfo) throws CertificateExpiredException, CertificateNotYetValidException {
        if (this.signedContent != null) {
            this.signedContent.checkValidity(signerInfo);
        }
    }

    class SignedBundleEntry
    extends BundleEntry {
        BundleEntry nestedEntry;

        SignedBundleEntry(BundleEntry nestedEntry) {
            this.nestedEntry = nestedEntry;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            InputStream in = SignedBundleFile.this.signedContent.getDigestInputStream(this.nestedEntry);
            if (in == null) {
                throw new SecurityException("Corrupted file: the digest does not exist for the file " + this.nestedEntry.getName());
            }
            return in;
        }

        @Override
        public long getSize() {
            return this.nestedEntry.getSize();
        }

        @Override
        public String getName() {
            return this.nestedEntry.getName();
        }

        @Override
        public long getTime() {
            return this.nestedEntry.getTime();
        }

        @Override
        public URL getLocalURL() {
            return this.nestedEntry.getLocalURL();
        }

        @Override
        public URL getFileURL() {
            return this.nestedEntry.getFileURL();
        }
    }
}

