/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;

final class IRFactory {
    private Parser parser;
    private static final int LOOP_DO_WHILE = 0;
    private static final int LOOP_WHILE = 1;
    private static final int LOOP_FOR = 2;
    private static final int ALWAYS_TRUE_BOOLEAN = 1;
    private static final int ALWAYS_FALSE_BOOLEAN = -1;

    IRFactory(Parser parser) {
        this.parser = parser;
    }

    ScriptOrFnNode createScript() {
        return new ScriptOrFnNode(135);
    }

    void initScript(ScriptOrFnNode scriptNode, Node body) {
        Node children = body.getFirstChild();
        if (children != null) {
            scriptNode.addChildrenToBack(children);
        }
    }

    Node createLeaf(int nodeType) {
        return new Node(nodeType);
    }

    Node createSwitch(Node expr, int lineno) {
        Node.Jump switchNode = new Node.Jump(113, expr, lineno);
        Node block = new Node(128, switchNode);
        return block;
    }

    void addSwitchCase(Node switchBlock, Node caseExpression, Node statements) {
        if (switchBlock.getType() != 128) {
            throw Kit.codeBug();
        }
        Node.Jump switchNode = (Node.Jump)switchBlock.getFirstChild();
        if (switchNode.getType() != 113) {
            throw Kit.codeBug();
        }
        Node gotoTarget = Node.newTarget();
        if (caseExpression != null) {
            Node.Jump caseNode = new Node.Jump(114, caseExpression);
            caseNode.target = gotoTarget;
            switchNode.addChildToBack(caseNode);
        } else {
            switchNode.setDefault(gotoTarget);
        }
        switchBlock.addChildToBack(gotoTarget);
        switchBlock.addChildToBack(statements);
    }

    void closeSwitch(Node switchBlock) {
        Node switchBreakTarget;
        if (switchBlock.getType() != 128) {
            throw Kit.codeBug();
        }
        Node.Jump switchNode = (Node.Jump)switchBlock.getFirstChild();
        if (switchNode.getType() != 113) {
            throw Kit.codeBug();
        }
        switchNode.target = switchBreakTarget = Node.newTarget();
        Node defaultTarget = switchNode.getDefault();
        if (defaultTarget == null) {
            defaultTarget = switchBreakTarget;
        }
        switchBlock.addChildAfter(this.makeJump(5, defaultTarget), switchNode);
        switchBlock.addChildToBack(switchBreakTarget);
    }

    Node createVariables(int token, int lineno) {
        return new Node(token, lineno);
    }

    Node createExprStatement(Node expr, int lineno) {
        int type = this.parser.insideFunction() ? 132 : 133;
        return new Node(type, expr, lineno);
    }

    Node createExprStatementNoReturn(Node expr, int lineno) {
        return new Node(132, expr, lineno);
    }

    Node createDefaultNamespace(Node expr, int lineno) {
        this.setRequiresActivation();
        Node n = this.createUnary(73, expr);
        Node result = this.createExprStatement(n, lineno);
        return result;
    }

    Node createName(String name2) {
        this.checkActivationName(name2, 39);
        return Node.newString(39, name2);
    }

    private Node createName(int type, String name2, Node child) {
        Node result = this.createName(name2);
        result.setType(type);
        if (child != null) {
            result.addChildToBack(child);
        }
        return result;
    }

    Node createString(String string) {
        return Node.newString(string);
    }

    Node createNumber(double number) {
        return Node.newNumber(number);
    }

    Node createCatch(String varName, Node catchCond, Node stmts, int lineno) {
        if (catchCond == null) {
            catchCond = new Node(127);
        }
        return new Node(123, this.createName(varName), catchCond, stmts, lineno);
    }

    Node createThrow(Node expr, int lineno) {
        return new Node(50, expr, lineno);
    }

    Node createReturn(Node expr, int lineno) {
        return expr == null ? new Node(4, lineno) : new Node(4, expr, lineno);
    }

    Node createDebugger(int lineno) {
        return new Node(159, lineno);
    }

    Node createLabel(int lineno) {
        return new Node.Jump(129, lineno);
    }

    Node getLabelLoop(Node label) {
        return ((Node.Jump)label).getLoop();
    }

    Node createLabeledStatement(Node labelArg, Node statement) {
        Node.Jump label = (Node.Jump)labelArg;
        Node breakTarget = Node.newTarget();
        Node block = new Node(128, (Node)label, statement, breakTarget);
        label.target = breakTarget;
        return block;
    }

    Node createBreak(Node breakStatement, int lineno) {
        Node.Jump jumpStatement;
        Node.Jump n = new Node.Jump(119, lineno);
        int t = breakStatement.getType();
        if (t == 131 || t == 129) {
            jumpStatement = (Node.Jump)breakStatement;
        } else if (t == 128 && breakStatement.getFirstChild().getType() == 113) {
            jumpStatement = (Node.Jump)breakStatement.getFirstChild();
        } else {
            throw Kit.codeBug();
        }
        n.setJumpStatement(jumpStatement);
        return n;
    }

    Node createContinue(Node loop, int lineno) {
        if (loop.getType() != 131) {
            Kit.codeBug();
        }
        Node.Jump n = new Node.Jump(120, lineno);
        n.setJumpStatement((Node.Jump)loop);
        return n;
    }

    Node createBlock(int lineno) {
        return new Node(128, lineno);
    }

    FunctionNode createFunction(String name2) {
        return new FunctionNode(name2);
    }

    Node initFunction(FunctionNode fnNode, int functionIndex, Node statements, int functionType) {
        Node lastStmt;
        String name2;
        fnNode.itsFunctionType = functionType;
        fnNode.addChildToBack(statements);
        int functionCount = fnNode.getFunctionCount();
        if (functionCount != 0) {
            fnNode.itsNeedsActivation = true;
        }
        if (functionType == 2 && (name2 = fnNode.getFunctionName()) != null && name2.length() != 0) {
            Node setFn = new Node(132, new Node(8, Node.newString(49, name2), new Node(63)));
            statements.addChildrenToFront(setFn);
        }
        if ((lastStmt = statements.getLastChild()) == null || lastStmt.getType() != 4) {
            statements.addChildToBack(new Node(4));
        }
        Node result = Node.newString(108, fnNode.getFunctionName());
        result.putIntProp(1, functionIndex);
        return result;
    }

    void addChildToBack(Node parent, Node child) {
        parent.addChildToBack(child);
    }

    Node createScopeNode(int token, int lineno) {
        return new Node.Scope(token, lineno);
    }

    Node createLoopNode(Node loopLabel, int lineno) {
        Node.Scope result = new Node.Scope(131, lineno);
        if (loopLabel != null) {
            ((Node.Jump)loopLabel).setLoop(result);
        }
        return result;
    }

    Node createWhile(Node loop, Node cond, Node body) {
        return this.createLoop((Node.Jump)loop, 1, body, cond, null, null);
    }

    Node createDoWhile(Node loop, Node body, Node cond) {
        return this.createLoop((Node.Jump)loop, 0, body, cond, null, null);
    }

    Node createFor(Node loop, Node init, Node test, Node incr, Node body) {
        if (init.getType() == 152) {
            Node.Scope let = Node.Scope.splitScope((Node.Scope)loop);
            let.setType(152);
            let.addChildrenToBack(init);
            let.addChildToBack(this.createLoop((Node.Jump)loop, 2, body, test, new Node(127), incr));
            return let;
        }
        return this.createLoop((Node.Jump)loop, 2, body, test, init, incr);
    }

    private Node createLoop(Node.Jump loop, int loopType, Node body, Node cond, Node init, Node incr) {
        Node bodyTarget = Node.newTarget();
        Node condTarget = Node.newTarget();
        if (loopType == 2 && cond.getType() == 127) {
            cond = new Node(45);
        }
        Node.Jump IFEQ = new Node.Jump(6, cond);
        IFEQ.target = bodyTarget;
        Node breakTarget = Node.newTarget();
        loop.addChildToBack(bodyTarget);
        loop.addChildrenToBack(body);
        if (loopType == 1 || loopType == 2) {
            loop.addChildrenToBack(new Node(127, loop.getLineno()));
        }
        loop.addChildToBack(condTarget);
        loop.addChildToBack(IFEQ);
        loop.addChildToBack(breakTarget);
        loop.target = breakTarget;
        Node continueTarget = condTarget;
        if (loopType == 1 || loopType == 2) {
            loop.addChildToFront(this.makeJump(5, condTarget));
            if (loopType == 2) {
                int initType = init.getType();
                if (initType != 127) {
                    if (initType != 121 && initType != 152) {
                        init = new Node(132, init);
                    }
                    loop.addChildToFront(init);
                }
                Node incrTarget = Node.newTarget();
                loop.addChildAfter(incrTarget, body);
                if (incr.getType() != 127) {
                    incr = new Node(132, incr);
                    loop.addChildAfter(incr, incrTarget);
                }
                continueTarget = incrTarget;
            }
        }
        loop.setContinue(continueTarget);
        return loop;
    }

    /*
     * Enabled aggressive block sorting
     */
    Node createForIn(int declType, Node loop, Node lhs, Node obj, Node body, boolean isForEach) {
        Node assign;
        Node lvalue;
        int destructuring = -1;
        int destructuringLen = 0;
        int type = lhs.getType();
        if (type == 121 || type == 152) {
            Node lastChild = lhs.getLastChild();
            if (lhs.getFirstChild() != lastChild) {
                this.parser.reportError("msg.mult.index");
            }
            if (lastChild.getType() == 65 || lastChild.getType() == 66) {
                type = destructuring = lastChild.getType();
                lvalue = lastChild;
                destructuringLen = lastChild.getIntProp(21, 0);
            } else {
                if (lastChild.getType() != 39) {
                    this.parser.reportError("msg.bad.for.in.lhs");
                    return obj;
                }
                lvalue = Node.newString(39, lastChild.getString());
            }
        } else if (type == 65 || type == 66) {
            destructuring = type;
            lvalue = lhs;
            destructuringLen = lhs.getIntProp(21, 0);
        } else {
            lvalue = this.makeReference(lhs);
            if (lvalue == null) {
                this.parser.reportError("msg.bad.for.in.lhs");
                return obj;
            }
        }
        Node localBlock = new Node(140);
        int initType = isForEach ? 59 : (destructuring != -1 ? 60 : 58);
        Node init = new Node(initType, obj);
        init.putProp(3, localBlock);
        Node cond = new Node(61);
        cond.putProp(3, localBlock);
        Node id = new Node(62);
        id.putProp(3, localBlock);
        Node newBody = new Node(128);
        if (destructuring != -1) {
            assign = this.createDestructuringAssignment(declType, lvalue, id);
            if (!(isForEach || destructuring != 66 && destructuringLen == 2)) {
                this.parser.reportError("msg.bad.for.in.destruct");
            }
        } else {
            assign = this.simpleAssignment(lvalue, id);
        }
        newBody.addChildToBack(new Node(132, assign));
        newBody.addChildToBack(body);
        loop = this.createWhile(loop, cond, newBody);
        loop.addChildToFront(init);
        if (type == 121 || type == 152) {
            loop.addChildToFront(lhs);
        }
        localBlock.addChildToBack(loop);
        return localBlock;
    }

    Node createTryCatchFinally(Node tryBlock, Node catchBlocks, Node finallyBlock, int lineno) {
        boolean hasFinally;
        boolean bl = hasFinally = finallyBlock != null && (finallyBlock.getType() != 128 || finallyBlock.hasChildren());
        if (tryBlock.getType() == 128 && !tryBlock.hasChildren() && !hasFinally) {
            return tryBlock;
        }
        boolean hasCatch = catchBlocks.hasChildren();
        if (!hasFinally && !hasCatch) {
            return tryBlock;
        }
        Node handlerBlock = new Node(140);
        Node.Jump pn = new Node.Jump(80, tryBlock, lineno);
        pn.putProp(3, handlerBlock);
        if (hasCatch) {
            Node catchTarget;
            Node endCatch = Node.newTarget();
            pn.addChildToBack(this.makeJump(5, endCatch));
            pn.target = catchTarget = Node.newTarget();
            pn.addChildToBack(catchTarget);
            Node catchScopeBlock = new Node(140);
            Node cb = catchBlocks.getFirstChild();
            boolean hasDefault = false;
            int scopeIndex = 0;
            while (cb != null) {
                Node condStmt;
                int catchLineNo = cb.getLineno();
                Node name2 = cb.getFirstChild();
                Node cond = name2.getNext();
                Node catchStatement = cond.getNext();
                cb.removeChild(name2);
                cb.removeChild(cond);
                cb.removeChild(catchStatement);
                catchStatement.addChildToBack(new Node(3));
                catchStatement.addChildToBack(this.makeJump(5, endCatch));
                if (cond.getType() == 127) {
                    condStmt = catchStatement;
                    hasDefault = true;
                } else {
                    condStmt = this.createIf(cond, catchStatement, null, catchLineNo);
                }
                Node catchScope = new Node(57, name2, this.createUseLocal(handlerBlock));
                catchScope.putProp(3, catchScopeBlock);
                catchScope.putIntProp(14, scopeIndex);
                catchScopeBlock.addChildToBack(catchScope);
                catchScopeBlock.addChildToBack(this.createWith(this.createUseLocal(catchScopeBlock), condStmt, catchLineNo));
                cb = cb.getNext();
                ++scopeIndex;
            }
            pn.addChildToBack(catchScopeBlock);
            if (!hasDefault) {
                Node rethrow = new Node(51);
                rethrow.putProp(3, handlerBlock);
                pn.addChildToBack(rethrow);
            }
            pn.addChildToBack(endCatch);
        }
        if (hasFinally) {
            Node finallyTarget = Node.newTarget();
            pn.setFinally(finallyTarget);
            pn.addChildToBack(this.makeJump(134, finallyTarget));
            Node finallyEnd = Node.newTarget();
            pn.addChildToBack(this.makeJump(5, finallyEnd));
            pn.addChildToBack(finallyTarget);
            Node fBlock = new Node(124, finallyBlock);
            fBlock.putProp(3, handlerBlock);
            pn.addChildToBack(fBlock);
            pn.addChildToBack(finallyEnd);
        }
        handlerBlock.addChildToBack(pn);
        return handlerBlock;
    }

    Node createWith(Node obj, Node body, int lineno) {
        this.setRequiresActivation();
        Node result = new Node(128, lineno);
        result.addChildToBack(new Node(2, obj));
        Node bodyNode = new Node(122, body, lineno);
        result.addChildrenToBack(bodyNode);
        result.addChildToBack(new Node(3));
        return result;
    }

    public Node createDotQuery(Node obj, Node body, int lineno) {
        this.setRequiresActivation();
        Node result = new Node(145, obj, body, lineno);
        return result;
    }

    Node createArrayLiteral(ObjArray elems, int skipCount, int destructuringLen) {
        int length = elems.size();
        int[] skipIndexes = null;
        if (skipCount != 0) {
            skipIndexes = new int[skipCount];
        }
        Node array = new Node(65);
        int j = 0;
        for (int i = 0; i != length; ++i) {
            Node elem = (Node)elems.get(i);
            if (elem != null) {
                array.addChildToBack(elem);
                continue;
            }
            skipIndexes[j] = i;
            ++j;
        }
        if (skipCount != 0) {
            array.putProp(11, skipIndexes);
        }
        array.putIntProp(21, destructuringLen);
        return array;
    }

    Node createObjectLiteral(ObjArray elems) {
        Object[] properties;
        int size = elems.size() / 2;
        Node object = new Node(66);
        if (size == 0) {
            properties = ScriptRuntime.emptyArgs;
        } else {
            properties = new Object[size];
            for (int i = 0; i != size; ++i) {
                properties[i] = elems.get(2 * i);
                Node value = (Node)elems.get(2 * i + 1);
                object.addChildToBack(value);
            }
        }
        object.putProp(12, properties);
        return object;
    }

    Node createRegExp(int regexpIndex) {
        Node n = new Node(48);
        n.putIntProp(4, regexpIndex);
        return n;
    }

    Node createIf(Node cond, Node ifTrue, Node ifFalse, int lineno) {
        int condStatus = IRFactory.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            if (ifFalse != null) {
                return ifFalse;
            }
            return new Node(128, lineno);
        }
        Node result = new Node(128, lineno);
        Node ifNotTarget = Node.newTarget();
        Node.Jump IFNE = new Node.Jump(7, cond);
        IFNE.target = ifNotTarget;
        result.addChildToBack(IFNE);
        result.addChildrenToBack(ifTrue);
        if (ifFalse != null) {
            Node endTarget = Node.newTarget();
            result.addChildToBack(this.makeJump(5, endTarget));
            result.addChildToBack(ifNotTarget);
            result.addChildrenToBack(ifFalse);
            result.addChildToBack(endTarget);
        } else {
            result.addChildToBack(ifNotTarget);
        }
        return result;
    }

    Node createCondExpr(Node cond, Node ifTrue, Node ifFalse) {
        int condStatus = IRFactory.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            return ifFalse;
        }
        return new Node(101, cond, ifTrue, ifFalse);
    }

    Node createUnary(int nodeType, Node child) {
        int childType = child.getType();
        switch (nodeType) {
            case 31: {
                Node n;
                if (childType == 39) {
                    child.setType(49);
                    Node left = child;
                    Node right = Node.newString(child.getString());
                    n = new Node(nodeType, left, right);
                } else if (childType == 33 || childType == 36) {
                    Node left = child.getFirstChild();
                    Node right = child.getLastChild();
                    child.removeChild(left);
                    child.removeChild(right);
                    n = new Node(nodeType, left, right);
                } else if (childType == 67) {
                    Node ref = child.getFirstChild();
                    child.removeChild(ref);
                    n = new Node(69, ref);
                } else {
                    n = new Node(45);
                }
                return n;
            }
            case 32: {
                if (childType != 39) break;
                child.setType(136);
                return child;
            }
            case 27: {
                if (childType != 40) break;
                int value = ScriptRuntime.toInt32(child.getDouble());
                child.setDouble(~value);
                return child;
            }
            case 29: {
                if (childType != 40) break;
                child.setDouble(-child.getDouble());
                return child;
            }
            case 26: {
                int status2 = IRFactory.isAlwaysDefinedBoolean(child);
                if (status2 == 0) break;
                int type = status2 == 1 ? 44 : 45;
                if (childType == 45 || childType == 44) {
                    child.setType(type);
                    return child;
                }
                return new Node(type);
            }
        }
        return new Node(nodeType, child);
    }

    Node createYield(Node child, int lineno) {
        if (!this.parser.insideFunction()) {
            this.parser.reportError("msg.bad.yield");
        }
        this.setRequiresActivation();
        this.setIsGenerator();
        if (child != null) {
            return new Node(72, child, lineno);
        }
        return new Node(72, lineno);
    }

    Node createCallOrNew(int nodeType, Node child) {
        String name2;
        int type = 0;
        if (child.getType() == 39) {
            name2 = child.getString();
            if (name2.equals("eval")) {
                type = 1;
            } else if (name2.equals("With")) {
                type = 2;
            }
        } else if (child.getType() == 33 && (name2 = child.getLastChild().getString()).equals("eval")) {
            type = 1;
        }
        Node node = new Node(nodeType, child);
        if (type != 0) {
            this.setRequiresActivation();
            node.putIntProp(10, type);
        }
        return node;
    }

    Node createIncDec(int nodeType, boolean post, Node child) {
        if ((child = this.makeReference(child)) == null) {
            String msg = nodeType == 106 ? "msg.bad.decr" : "msg.bad.incr";
            this.parser.reportError(msg);
            return null;
        }
        int childType = child.getType();
        switch (childType) {
            case 33: 
            case 36: 
            case 39: 
            case 67: {
                Node n = new Node(nodeType, child);
                int incrDecrMask = 0;
                if (nodeType == 106) {
                    incrDecrMask |= 1;
                }
                if (post) {
                    incrDecrMask |= 2;
                }
                n.putIntProp(13, incrDecrMask);
                return n;
            }
        }
        throw Kit.codeBug();
    }

    Node createPropertyGet(Node target, String namespace, String name2, int memberTypeFlags) {
        if (namespace == null && memberTypeFlags == 0) {
            if (target == null) {
                return this.createName(name2);
            }
            this.checkActivationName(name2, 33);
            if (ScriptRuntime.isSpecialProperty(name2)) {
                Node ref = new Node(71, target);
                ref.putProp(17, name2);
                return new Node(67, ref);
            }
            return new Node(33, target, this.createString(name2));
        }
        Node elem = this.createString(name2);
        return this.createMemberRefGet(target, namespace, elem, memberTypeFlags |= 1);
    }

    Node createElementGet(Node target, String namespace, Node elem, int memberTypeFlags) {
        if (namespace == null && memberTypeFlags == 0) {
            if (target == null) {
                throw Kit.codeBug();
            }
            return new Node(36, target, elem);
        }
        return this.createMemberRefGet(target, namespace, elem, memberTypeFlags);
    }

    private Node createMemberRefGet(Node target, String namespace, Node elem, int memberTypeFlags) {
        Node nsNode = null;
        if (namespace != null) {
            nsNode = namespace.equals("*") ? new Node(42) : this.createName(namespace);
        }
        Node ref = target == null ? (namespace == null ? new Node(78, elem) : new Node(79, nsNode, elem)) : (namespace == null ? new Node(76, target, elem) : new Node(77, target, nsNode, elem));
        if (memberTypeFlags != 0) {
            ref.putIntProp(16, memberTypeFlags);
        }
        return new Node(67, ref);
    }

    Node createBinary(int nodeType, Node left, Node right) {
        switch (nodeType) {
            case 21: {
                if (left.type == 41) {
                    String s2;
                    if (right.type == 41) {
                        s2 = right.getString();
                    } else {
                        if (right.type != 40) break;
                        s2 = ScriptRuntime.numberToString(right.getDouble(), 10);
                    }
                    String s1 = left.getString();
                    left.setString(s1.concat(s2));
                    return left;
                }
                if (left.type != 40) break;
                if (right.type == 40) {
                    left.setDouble(left.getDouble() + right.getDouble());
                    return left;
                }
                if (right.type != 41) break;
                String s1 = ScriptRuntime.numberToString(left.getDouble(), 10);
                String s2 = right.getString();
                right.setString(s1.concat(s2));
                return right;
            }
            case 22: {
                if (left.type == 40) {
                    double ld = left.getDouble();
                    if (right.type == 40) {
                        left.setDouble(ld - right.getDouble());
                        return left;
                    }
                    if (ld != 0.0) break;
                    return new Node(29, right);
                }
                if (right.type != 40 || right.getDouble() != 0.0) break;
                return new Node(28, left);
            }
            case 23: {
                if (left.type == 40) {
                    double ld = left.getDouble();
                    if (right.type == 40) {
                        left.setDouble(ld * right.getDouble());
                        return left;
                    }
                    if (ld != 1.0) break;
                    return new Node(28, right);
                }
                if (right.type != 40 || right.getDouble() != 1.0) break;
                return new Node(28, left);
            }
            case 24: {
                if (right.type != 40) break;
                double rd = right.getDouble();
                if (left.type == 40) {
                    left.setDouble(left.getDouble() / rd);
                    return left;
                }
                if (rd != 1.0) break;
                return new Node(28, left);
            }
            case 104: {
                int leftStatus = IRFactory.isAlwaysDefinedBoolean(left);
                if (leftStatus == -1) {
                    return left;
                }
                if (leftStatus != 1) break;
                return right;
            }
            case 103: {
                int leftStatus = IRFactory.isAlwaysDefinedBoolean(left);
                if (leftStatus == 1) {
                    return left;
                }
                if (leftStatus != -1) break;
                return right;
            }
        }
        return new Node(nodeType, left, right);
    }

    private Node simpleAssignment(Node left, Node right) {
        int nodeType = left.getType();
        switch (nodeType) {
            case 39: {
                left.setType(49);
                return new Node(8, left, right);
            }
            case 33: 
            case 36: {
                Node obj = left.getFirstChild();
                Node id = left.getLastChild();
                int type = nodeType == 33 ? 35 : 37;
                return new Node(type, obj, id, right);
            }
            case 67: {
                Node ref = left.getFirstChild();
                this.checkMutableReference(ref);
                return new Node(68, ref, right);
            }
        }
        throw Kit.codeBug();
    }

    private void checkMutableReference(Node n) {
        int memberTypeFlags = n.getIntProp(16, 0);
        if ((memberTypeFlags & 4) != 0) {
            this.parser.reportError("msg.bad.assign.left");
        }
    }

    Node createAssignment(int assignType, Node left, Node right) {
        int assignOp;
        Node ref = this.makeReference(left);
        if (ref == null) {
            if (left.getType() == 65 || left.getType() == 66) {
                if (assignType != 89) {
                    this.parser.reportError("msg.bad.destruct.op");
                    return right;
                }
                return this.createDestructuringAssignment(-1, left, right);
            }
            this.parser.reportError("msg.bad.assign.left");
            return right;
        }
        left = ref;
        switch (assignType) {
            case 89: {
                return this.simpleAssignment(left, right);
            }
            case 90: {
                assignOp = 9;
                break;
            }
            case 91: {
                assignOp = 10;
                break;
            }
            case 92: {
                assignOp = 11;
                break;
            }
            case 93: {
                assignOp = 18;
                break;
            }
            case 94: {
                assignOp = 19;
                break;
            }
            case 95: {
                assignOp = 20;
                break;
            }
            case 96: {
                assignOp = 21;
                break;
            }
            case 97: {
                assignOp = 22;
                break;
            }
            case 98: {
                assignOp = 23;
                break;
            }
            case 99: {
                assignOp = 24;
                break;
            }
            case 100: {
                assignOp = 25;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        int nodeType = left.getType();
        switch (nodeType) {
            case 39: {
                Node op = new Node(assignOp, left, right);
                Node lvalueLeft = Node.newString(49, left.getString());
                return new Node(8, lvalueLeft, op);
            }
            case 33: 
            case 36: {
                Node obj = left.getFirstChild();
                Node id = left.getLastChild();
                int type = nodeType == 33 ? 138 : 139;
                Node opLeft = new Node(137);
                Node op = new Node(assignOp, opLeft, right);
                return new Node(type, obj, id, op);
            }
            case 67: {
                ref = left.getFirstChild();
                this.checkMutableReference(ref);
                Node opLeft = new Node(137);
                Node op = new Node(assignOp, opLeft, right);
                return new Node(141, ref, op);
            }
        }
        throw Kit.codeBug();
    }

    Node createDestructuringAssignment(int type, Node left, Node right) {
        String tempName = this.parser.currentScriptOrFn.getNextTempName();
        Node result = this.destructuringAssignmentHelper(type, left, right, tempName);
        Node comma = result.getLastChild();
        comma.addChildToBack(this.createName(tempName));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node destructuringAssignmentHelper(int variableType, Node left, Node right, String tempName) {
        Node result = this.createScopeNode(157, this.parser.getCurrentLineNumber());
        result.addChildToFront(new Node(152, this.createName(39, tempName, right)));
        try {
            this.parser.pushScope(result);
            this.parser.defineSymbol(152, true, tempName);
        }
        finally {
            this.parser.popScope();
        }
        Node comma = new Node(88);
        result.addChildToBack(comma);
        int setOp = variableType == 153 ? 154 : 8;
        ArrayList<String> destructuringNames = new ArrayList<String>();
        boolean empty = true;
        int type = left.getType();
        if (type == 65) {
            int index = 0;
            int[] skipIndices = (int[])left.getProp(11);
            int skip = 0;
            Node n = left.getFirstChild();
            while (true) {
                if (skipIndices != null) {
                    while (skip < skipIndices.length && skipIndices[skip] == index) {
                        ++skip;
                        ++index;
                    }
                }
                if (n != null) {
                    Node rightElem = new Node(36, this.createName(tempName), this.createNumber(index));
                    if (n.getType() == 39) {
                        String name2 = n.getString();
                        comma.addChildToBack(new Node(setOp, this.createName(49, name2, null), rightElem));
                        if (variableType != -1) {
                            this.parser.defineSymbol(variableType, true, name2);
                            destructuringNames.add(name2);
                        }
                    } else {
                        comma.addChildToBack(this.destructuringAssignmentHelper(variableType, n, rightElem, this.parser.currentScriptOrFn.getNextTempName()));
                    }
                    ++index;
                    empty = false;
                    n = n.getNext();
                    continue;
                }
                break;
            }
        } else if (type == 66) {
            int index = 0;
            Object[] propertyIds = (Object[])left.getProp(12);
            for (Node n = left.getFirstChild(); n != null; n = n.getNext()) {
                Node rightElem;
                Object id = propertyIds[index];
                Node node = rightElem = id instanceof String ? new Node(33, this.createName(tempName), this.createString((String)id)) : new Node(36, this.createName(tempName), this.createNumber(((Number)id).intValue()));
                if (n.getType() == 39) {
                    String name3 = n.getString();
                    comma.addChildToBack(new Node(setOp, this.createName(49, name3, null), rightElem));
                    if (variableType != -1) {
                        this.parser.defineSymbol(variableType, true, name3);
                        destructuringNames.add(name3);
                    }
                } else {
                    comma.addChildToBack(this.destructuringAssignmentHelper(variableType, n, rightElem, this.parser.currentScriptOrFn.getNextTempName()));
                }
                ++index;
                empty = false;
            }
        } else if (type == 33 || type == 36) {
            comma.addChildToBack(this.simpleAssignment(left, this.createName(tempName)));
        } else {
            this.parser.reportError("msg.bad.assign.left");
        }
        if (empty) {
            comma.addChildToBack(this.createNumber(0.0));
        }
        result.putProp(22, destructuringNames);
        return result;
    }

    Node createUseLocal(Node localBlock) {
        if (140 != localBlock.getType()) {
            throw Kit.codeBug();
        }
        Node result = new Node(54);
        result.putProp(3, localBlock);
        return result;
    }

    private Node.Jump makeJump(int type, Node target) {
        Node.Jump n = new Node.Jump(type);
        n.target = target;
        return n;
    }

    private Node makeReference(Node node) {
        int type = node.getType();
        switch (type) {
            case 33: 
            case 36: 
            case 39: 
            case 67: {
                return node;
            }
            case 38: {
                node.setType(70);
                return new Node(67, node);
            }
        }
        return null;
    }

    private static int isAlwaysDefinedBoolean(Node node) {
        switch (node.getType()) {
            case 42: 
            case 44: {
                return -1;
            }
            case 45: {
                return 1;
            }
            case 40: {
                double num = node.getDouble();
                if (num == num && num != 0.0) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    private void checkActivationName(String name2, int token) {
        if (this.parser.insideFunction()) {
            boolean activation = false;
            if ("arguments".equals(name2) || this.parser.compilerEnv.activationNames != null && this.parser.compilerEnv.activationNames.contains(name2)) {
                activation = true;
            } else if ("length".equals(name2) && token == 33 && this.parser.compilerEnv.getLanguageVersion() == 120) {
                activation = true;
            }
            if (activation) {
                this.setRequiresActivation();
            }
        }
    }

    private void setRequiresActivation() {
        if (this.parser.insideFunction()) {
            ((FunctionNode)this.parser.currentScriptOrFn).itsNeedsActivation = true;
        }
    }

    private void setIsGenerator() {
        if (this.parser.insideFunction()) {
            ((FunctionNode)this.parser.currentScriptOrFn).itsIsGenerator = true;
        }
    }
}

