/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.util.Properties;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Environment
extends ScriptableObject {
    static final long serialVersionUID = -430727378460177065L;
    private Environment thePrototypeInstance = null;

    public static void defineClass(ScriptableObject scope) {
        try {
            ScriptableObject.defineClass(scope, Environment.class);
        }
        catch (Exception e) {
            throw new Error(e.getMessage());
        }
    }

    public String getClassName() {
        return "Environment";
    }

    public Environment() {
        if (this.thePrototypeInstance == null) {
            this.thePrototypeInstance = this;
        }
    }

    public Environment(ScriptableObject scope) {
        this.setParentScope(scope);
        Object ctor = ScriptRuntime.getTopLevelProp(scope, "Environment");
        if (ctor != null && ctor instanceof Scriptable) {
            Scriptable s = (Scriptable)ctor;
            this.setPrototype((Scriptable)s.get("prototype", s));
        }
    }

    public boolean has(String name2, Scriptable start) {
        if (this == this.thePrototypeInstance) {
            return super.has(name2, start);
        }
        return System.getProperty(name2) != null;
    }

    public Object get(String name2, Scriptable start) {
        if (this == this.thePrototypeInstance) {
            return super.get(name2, start);
        }
        String result = System.getProperty(name2);
        if (result != null) {
            return ScriptRuntime.toObject(this.getParentScope(), result);
        }
        return Scriptable.NOT_FOUND;
    }

    public void put(String name2, Scriptable start, Object value) {
        if (this == this.thePrototypeInstance) {
            super.put(name2, start, value);
        } else {
            System.getProperties().put(name2, ScriptRuntime.toString(value));
        }
    }

    private Object[] collectIds() {
        Properties props = System.getProperties();
        return props.keySet().toArray();
    }

    public Object[] getIds() {
        if (this == this.thePrototypeInstance) {
            return super.getIds();
        }
        return this.collectIds();
    }

    public Object[] getAllIds() {
        if (this == this.thePrototypeInstance) {
            return super.getAllIds();
        }
        return this.collectIds();
    }
}

