/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common;

import com.ibm.websphere.appserver.tools.jaxrpc.common.CommonLoggerI;
import com.ibm.websphere.appserver.tools.jaxrpc.common.DocumentUtil;
import com.ibm.websphere.appserver.tools.jaxrpc.common.JavaAssistHelperUtil;
import com.ibm.websphere.appserver.tools.jaxrpc.common.PredeployUtil;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.ClassResources;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.ClientServiceEndpointInterface;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.ServiceEndpointInterface;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.ServiceEndpointMethod;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.WSDLResource;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.WSDLResources;
import com.ibm.websphere.appserver.tools.jaxrpc.common.data.XMLResources;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javassist.ClassMap;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;

public class ArchiveResources {
    private boolean archiveModified = false;
    private boolean archiveSigned = false;
    private File expandedResourceDirectory;
    private File tmpDirectory;
    private String archiveName = null;
    private String expandedResourceDirectoryPath;
    private File originalArchive;
    private File convertedArchive;
    private String archiveType;
    private File manifestFile;
    private File appXmlFile;
    private File appClientXmlFile;
    private boolean hasHolders = false;
    private ArchiveResources parentArchive;
    private List<ArchiveResources> containedArchives = new ArrayList<ArchiveResources>();
    private Set<String> containedArchiveExpandedDirectories = new HashSet<String>();
    private Map<String, String> implMigrationMap = new HashMap<String, String>();
    private Map<String, String> serviceImplToSeiMap = new HashMap<String, String>();
    private Set<String> implSeiSpecialConversion = new HashSet<String>();
    private Map<String, String> replaceServletClasses = new HashMap<String, String>();
    private Map<String, String> servletClassToPortComponentNames = new HashMap<String, String>();
    private Set<String> clientClassesToDelete = new HashSet<String>();
    private Set<String> clientClassesReferenceStub = new HashSet<String>();
    private Set<String> clientClassesReferenceServiceException = new HashSet<String>();
    private Map<String, String> clientClassesReferenceService = new HashMap<String, String>();
    private ClassMap customExceptionMapping = new ClassMap();
    private Set<String> classesReferenceServiceFactory = new HashSet<String>();
    private Map<ModificationType, Set<String>> archiveModifications = new HashMap<ModificationType, Set<String>>();
    private Map<String, String> movedFileDestinations = new HashMap<String, String>();
    private Set<String> deleteFailedCollection = new HashSet<String>();
    private Set<ClassPath> classPathsInserted = new HashSet<ClassPath>();
    private Map<String, ClientServiceEndpointInterface> mappingFilesToMapClientSEI = new HashMap<String, ClientServiceEndpointInterface>();
    private Map<String, WSDLResource> mappingFilesToCollectXsdTypesService = new HashMap<String, WSDLResource>();
    private Map<String, WSDLResource> mappingFilesToCollectXsdTypesClient = new HashMap<String, WSDLResource>();
    private Map<String, String> xsdTypeToMappingType = new HashMap<String, String>();
    private transient CommonLoggerI log;
    private List<String> warnMsgList = new ArrayList<String>();
    private List<String> errMsgList = new ArrayList<String>();
    private List<String> overlappingSEIs = new ArrayList<String>();
    private WSDLResources wsdlResources = new WSDLResources(this);
    private XMLResources xmlResources = new XMLResources(this);
    private Set<String> holderSet = new HashSet<String>();
    private ClassResources classResources = new ClassResources(this);
    private Map<String, ServiceEndpointInterface> serviceSeiMap = new HashMap<String, ServiceEndpointInterface>();
    private Map<String, ClientServiceEndpointInterface> clientSeiMap = new HashMap<String, ClientServiceEndpointInterface>();
    private Map<String, ClientServiceEndpointInterface> clientSeiRenamedMap = new HashMap<String, ClientServiceEndpointInterface>();
    private Map<String, ClientServiceEndpointInterface> clientSeiServiceMap = new HashMap<String, ClientServiceEndpointInterface>();
    private Map<String, ClientServiceEndpointInterface> clientSeiMapAlternate = new HashMap<String, ClientServiceEndpointInterface>();
    private Map<String, ClientServiceEndpointInterface> clientSeiServiceMapAlternate = new HashMap<String, ClientServiceEndpointInterface>();

    public ArchiveResources(File archive, File destDir) {
        this.originalArchive = archive;
        this.expandedResourceDirectory = destDir;
        try {
            this.expandedResourceDirectoryPath = destDir.getCanonicalPath();
        }
        catch (IOException e) {
            this.expandedResourceDirectoryPath = destDir.getAbsolutePath();
        }
        this.archiveName = this.getOriginalArchive().getName();
        this.archiveType = this.archiveName.substring(this.archiveName.lastIndexOf(46) + 1);
    }

    public ArchiveResources(File archive, File destDir, CommonLoggerI log) {
        this(archive, destDir);
        this.log = log;
    }

    public void logWarn(String msg) {
        this.warnMsgList.add(msg);
        this.log.warn(msg);
    }

    public void logError(String msg) {
        this.errMsgList.add(msg);
        this.log.error(msg);
    }

    public List<String> getWarnMsgList() {
        return this.warnMsgList;
    }

    public List<String> getErrMsgList() {
        return this.errMsgList;
    }

    public File getTmpDirectory() {
        return this.tmpDirectory;
    }

    public void moveWsimportClassFiles(String classFileRoot, CommonLoggerI log) throws IOException {
        Set<File> migratedDirsInArchive = this.getWsdlResources().getAllMigrateDirs();
        if (!this.containedArchives.isEmpty()) {
            for (ArchiveResources subArchive : this.containedArchives) {
                migratedDirsInArchive.removeAll(subArchive.getWsdlResources().getAllMigrateDirs());
            }
        }
        for (File migrateDir : migratedDirsInArchive) {
            String migrateDirPath = migrateDir.getCanonicalPath();
            Iterator migrateDirIterator = FileUtils.iterateFiles((File)migrateDir, (String[])new String[]{"class"}, (boolean)true);
            while (migrateDirIterator.hasNext()) {
                File migratedClassFile = (File)migrateDirIterator.next();
                String migratedClassFilePath = migratedClassFile.getCanonicalPath();
                if (this.deleteFailedCollection.contains(migratedClassFilePath)) {
                    log.debug("Skipping clone of file that should have been deleted: " + migratedClassFilePath);
                    continue;
                }
                String classPathTopPackage = migratedClassFilePath.substring(migrateDirPath.length());
                File destClassFile = new File(classFileRoot, classPathTopPackage);
                log.debug("Cloning class file " + migratedClassFile.getCanonicalPath() + "\nto " + destClassFile.getCanonicalPath());
                this.moveFile(migratedClassFile, destClassFile);
            }
        }
    }

    public Boolean prepareAndRepackageArchive(final CommonLoggerI log, File convertedApplicationsDir, File outputDir) throws Exception {
        boolean archiveModified = this.archiveModified;
        final String expandedResourceDirName = this.expandedResourceDirectory.getName();
        final String tmpDirName = expandedResourceDirName + "_tmp";
        String tmpDirPath = this.expandedResourceDirectoryPath + "_tmp";
        this.tmpDirectory = new File(tmpDirPath);
        String WEB_INF_CLASSES = "WEB-INF" + File.separator + "classes";
        final String classFilesRootOriginal = this.isWarArchive() ? this.expandedResourceDirectoryPath + File.separator + WEB_INF_CLASSES + File.separator : this.expandedResourceDirectoryPath;
        String classFilesRootDestination = this.isWarArchive() ? tmpDirPath + File.separator + WEB_INF_CLASSES + File.separator : tmpDirPath;
        HashSet<String> warModulesToRemove = new HashSet<String>();
        for (ArchiveResources ca : this.containedArchives) {
            if (this.isEarArchive() && PredeployUtil.isRouterModule(ca)) {
                archiveModified = true;
                File warFileToDelete = ca.getOriginalArchive();
                warModulesToRemove.add(warFileToDelete.getName());
                log.info("Found router module. Deleting file: " + warFileToDelete.getCanonicalPath());
                this.deleteFile(warFileToDelete);
                continue;
            }
            if (!ca.archiveModified()) continue;
            Boolean childRepackage = ca.prepareAndRepackageArchive(log, null, outputDir);
            if (childRepackage == null || !childRepackage.booleanValue()) {
                log.error("There was an error in preparing and repackaging the child archive " + ca.getArchiveName());
                return false;
            }
            File containedArchiveConverted = ca.getConvertedArchiveLocation();
            File containedArchiveOriginalDir = ca.getExpandedResourceDirectory().getParentFile();
            String tmpDirectoryArchiveLocation = containedArchiveOriginalDir.getCanonicalPath().replace(this.getExpandedResourceDirectoryPath(), this.tmpDirectory.getCanonicalPath());
            this.moveFile(containedArchiveConverted, new File(tmpDirectoryArchiveLocation, containedArchiveConverted.getName()));
            archiveModified = true;
        }
        if (!warModulesToRemove.isEmpty()) {
            PredeployUtil.updateApplicationXmlOrClientXml(this, warModulesToRemove);
        }
        if (archiveModified) {
            this.moveWsimportClassFiles(classFilesRootDestination, log);
            FileFilter ff = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String name2;
                    try {
                        name2 = pathname.getCanonicalPath();
                    }
                    catch (IOException e) {
                        name2 = pathname.getAbsolutePath();
                    }
                    boolean copy = true;
                    if (pathname.isDirectory()) {
                        if (name2.contains("jaxrpc-tools-wsimport") || ArchiveResources.this.containedArchiveExpandedDirectories.contains(name2)) {
                            log.debug("Skipping clone of directory: " + name2);
                            copy = false;
                        }
                    } else if (ArchiveResources.this.deleteFailedCollection.contains(name2)) {
                        log.debug("Skipping clone of file that should have been deleted: " + name2);
                        ArchiveResources.this.recordArchiveModification(name2, ModificationType.DELETE);
                        copy = false;
                    } else {
                        for (String nextExpandedDir : ArchiveResources.this.containedArchiveExpandedDirectories) {
                            if (!name2.startsWith(nextExpandedDir)) continue;
                            log.debug("Skipping clone of file that is in contained archive expanded dir: " + name2);
                            copy = false;
                        }
                        if (copy) {
                            String destName;
                            File tmpDirDestinationFile;
                            if (name2.contains("jaxrpc-tools-wsimport")) {
                                log.debug("Skipping clone of file that was already copied from generated wsimport dir: " + name2);
                                copy = false;
                            } else if (name2.endsWith(".class") && name2.startsWith(classFilesRootOriginal)) {
                                String classPathRootPackage = name2.substring(ArchiveResources.this.expandedResourceDirectoryPath.length());
                                String destName2 = name2.replace(expandedResourceDirName, tmpDirName);
                                File tmpDirDestinationFile2 = new File(destName2);
                                if (tmpDirDestinationFile2.exists()) {
                                    log.debug("Skipping clone of class file that was already copied from generated wsimport dir: " + name2);
                                    copy = false;
                                } else if (name2.endsWith("_Helper.class") || name2.endsWith("_Ser.class") || name2.endsWith("_Deser.class")) {
                                    String originalClass = classPathRootPackage.substring(0, classPathRootPackage.lastIndexOf("_")) + ".class";
                                    File tmpDirDestFileOriginalClass = new File(ArchiveResources.this.tmpDirectory, originalClass);
                                    if (tmpDirDestFileOriginalClass.exists()) {
                                        log.debug("Skipping clone of unneeded class file: " + name2);
                                        ArchiveResources.this.recordArchiveModification(name2, ModificationType.DELETE);
                                        copy = false;
                                    }
                                }
                            } else if ((name2.endsWith(".jar") || name2.endsWith(".war")) && (tmpDirDestinationFile = new File(destName = name2.replace(expandedResourceDirName, tmpDirName))).exists()) {
                                log.debug("Skipping clone of archive file that was already copied from contained archive expanded directory: " + name2);
                                copy = false;
                            }
                        }
                    }
                    if (copy) {
                        if (pathname.isDirectory()) {
                            log.debug("Cloning directory: " + name2);
                        } else {
                            log.debug("Cloning file: " + name2);
                        }
                    }
                    return copy;
                }
            };
            FileUtils.copyDirectory((File)this.expandedResourceDirectory, (File)this.tmpDirectory, (FileFilter)ff);
            if (this.getArchiveSigned()) {
                log.warn("The following signed archive was modified and will need to be re-signed. " + this.archiveName);
            }
            if (this.processBuilderJarCommand(log, new File(outputDir, this.archiveName + ".repackage.log"))) {
                File pbJar = new File(this.tmpDirectory, this.archiveName);
                if (pbJar.exists() && pbJar.length() != 0L) {
                    log.info("Repackaging complete for archive: " + this.archiveName);
                    if (convertedApplicationsDir != null) {
                        if (!convertedApplicationsDir.exists()) {
                            convertedApplicationsDir.mkdirs();
                        }
                        FileUtils.copyFileToDirectory((File)pbJar, (File)convertedApplicationsDir);
                        log.debug("Moved repackaged archive from: " + pbJar.getCanonicalPath() + " to: " + convertedApplicationsDir.getCanonicalPath());
                        this.setConvertedArchiveLocation(new File(convertedApplicationsDir, this.archiveName));
                    } else {
                        this.setConvertedArchiveLocation(pbJar);
                    }
                    return true;
                }
                log.error("The process builder jar command failed on temp directory " + this.tmpDirectory);
                return false;
            }
            log.error("The process builder jar timed out for archive: " + this.archiveName);
            return false;
        }
        log.info("There were no modifications made to the following archive. " + this.archiveName);
        return null;
    }

    private boolean processBuilderJarCommand(CommonLoggerI log, File repackageOutputLog) throws InterruptedException, IOException {
        ProcessBuilder pb;
        StringBuilder jarPackagingFlags = new StringBuilder("-cvf");
        if (this.manifestFile != null) {
            jarPackagingFlags.append("m");
            pb = new ProcessBuilder("jar", jarPackagingFlags.toString(), this.archiveName, this.manifestFile.getCanonicalPath(), ".");
        } else {
            jarPackagingFlags.append("M");
            pb = new ProcessBuilder("jar", jarPackagingFlags.toString(), this.archiveName, ".");
        }
        pb.directory(this.tmpDirectory);
        pb.redirectErrorStream(true);
        pb.redirectOutput(repackageOutputLog);
        log.info("Calling jar command to repackage archive: " + this.archiveName);
        try {
            Process proc = pb.start();
            if (!proc.waitFor(60L, TimeUnit.SECONDS)) {
                log.error("Repackaging did not complete within the 60 second timeout. See the log for more details: " + repackageOutputLog.getCanonicalPath());
                proc.destroy();
                return false;
            }
        }
        catch (InterruptedException e) {
            log.error("The jar process has been interrupted while repackaging for archive " + this.archiveName);
            throw e;
        }
        catch (IOException e) {
            log.error("Manifest file " + this.manifestFile.getName() + " for archive " + this.archiveName + " could not be found.");
            throw e;
        }
        return true;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveSigned(boolean archiveSigned) {
        this.archiveSigned = archiveSigned;
    }

    public boolean getArchiveSigned() {
        return this.archiveSigned;
    }

    public void setManifestFile(File manifestFile) {
        this.manifestFile = manifestFile;
    }

    public File getManifestFile() {
        return this.manifestFile;
    }

    public void setApplicationXmlFile(File appXml) {
        this.appXmlFile = appXml;
    }

    public File getApplicationXmlFile() {
        return this.appXmlFile;
    }

    public void setApplicationClientXmlFile(File appClientXml) {
        this.appClientXmlFile = appClientXml;
    }

    public File getApplicationClientXmlFile() {
        return this.appClientXmlFile;
    }

    public File getExpandedResourceDirectory() {
        return this.expandedResourceDirectory;
    }

    public String getExpandedResourceDirectoryPath() {
        return this.expandedResourceDirectoryPath;
    }

    public File getOriginalArchive() {
        return this.originalArchive;
    }

    public void setConvertedArchiveLocation(File convertedArchive) {
        this.convertedArchive = convertedArchive;
    }

    public File getConvertedArchiveLocation() {
        return this.convertedArchive;
    }

    public WSDLResources getWsdlResources() {
        return this.wsdlResources;
    }

    public WSDLResource addServiceWsdl(String wsdl, String wsdlReferenceFile) throws Exception {
        return this.wsdlResources.addServiceWsdl(wsdl, wsdlReferenceFile);
    }

    public WSDLResource addClientWsdl(String wsdl, String wsdlReferenceFile) throws Exception {
        return this.wsdlResources.addClientWsdl(wsdl, wsdlReferenceFile);
    }

    public void setContainedArchives(List<ArchiveResources> containedArchives) {
        this.containedArchives = containedArchives;
    }

    public void addContainedArchive(ArchiveResources containedArchive) {
        containedArchive.setParentArchive(this);
        this.consolidate(containedArchive);
        this.containedArchives.add(containedArchive);
        this.containedArchiveExpandedDirectories.add(containedArchive.getExpandedResourceDirectoryPath());
        this.containedArchiveExpandedDirectories.add(containedArchive.getExpandedResourceDirectoryPath() + "_tmp");
    }

    public boolean archiveModified() {
        return this.archiveModified;
    }

    private void setArchiveModified(boolean archiveModified) {
        this.archiveModified = this.archiveModified || archiveModified;
    }

    public void setArchiveModified(String path) {
        if (path.startsWith(this.expandedResourceDirectoryPath)) {
            this.setArchiveModified(true);
            for (ArchiveResources ar : this.containedArchives) {
                ar.setArchiveModified(path);
            }
        }
    }

    public void recordArchiveModification(String path, ModificationType type) {
        this.recordArchiveModification(path, type, true);
    }

    public void recordArchiveModification(String path, ModificationType type, boolean setArchiveModifiedFlag) {
        Set<Object> paths = null;
        if (this.archiveModifications.containsKey((Object)type)) {
            paths = this.archiveModifications.get((Object)type);
        } else {
            paths = new HashSet();
            this.archiveModifications.put(type, paths);
        }
        paths.add(path);
        if (setArchiveModifiedFlag) {
            this.setArchiveModified(path);
        }
        if (type == ModificationType.DELETE && this.archiveModifications.containsKey((Object)ModificationType.UPDATE)) {
            this.archiveModifications.get((Object)ModificationType.UPDATE).remove(path);
        }
    }

    public void trackGeneratedClasses(File classDir) throws IOException {
        Collection allClassFiles = FileUtils.listFiles((File)classDir, (String[])new String[]{"class"}, (boolean)true);
        for (File nextClass : allClassFiles) {
            this.recordArchiveModification(nextClass.getCanonicalPath(), ModificationType.CREATE, false);
        }
    }

    public Map<ModificationType, Set<String>> getArchiveModifications() {
        HashMap<ModificationType, Set<String>> returnCollection = new HashMap<ModificationType, Set<String>>();
        returnCollection.putAll(this.archiveModifications);
        if (!this.containedArchives.isEmpty()) {
            for (ArchiveResources ar : this.containedArchives) {
                Map<ModificationType, Set<String>> childCollection = ar.getArchiveModifications();
                for (ModificationType type : childCollection.keySet()) {
                    Set<String> values = childCollection.get((Object)type);
                    if (returnCollection.containsKey((Object)type)) {
                        ((Set)returnCollection.get((Object)type)).addAll(values);
                        continue;
                    }
                    returnCollection.put(type, values);
                }
            }
        }
        return returnCollection;
    }

    public Map<String, String> getMovedFileDestinations() {
        HashMap<String, String> returnCollection = new HashMap<String, String>();
        returnCollection.putAll(this.movedFileDestinations);
        if (this.isEarArchive()) {
            for (ArchiveResources ar : this.containedArchives) {
                Map<String, String> childCollection = ar.getMovedFileDestinations();
                returnCollection.putAll(childCollection);
            }
        }
        return returnCollection;
    }

    public boolean deleteFile(File fileToDelete) {
        if (fileToDelete.exists()) {
            String path = null;
            try {
                path = fileToDelete.getCanonicalPath();
            }
            catch (IOException e) {
                path = fileToDelete.getAbsolutePath();
            }
            if (fileToDelete.delete()) {
                this.deleteFailedCollection.remove(path);
                this.recordArchiveModification(path, ModificationType.DELETE);
                return true;
            }
            this.deleteFailedCollection.add(path);
        }
        return false;
    }

    public boolean deleteFiles(Collection<File> filesToDelete) {
        boolean success = true;
        for (File file : filesToDelete) {
            success &= this.deleteFile(file);
        }
        return success;
    }

    public void moveFile(File sourceFile, File destinationFile) throws IOException {
        FileUtils.copyFileToDirectory((File)sourceFile, (File)destinationFile.getParentFile());
        this.movedFileDestinations.put(sourceFile.getCanonicalPath(), destinationFile.getCanonicalPath());
        this.recordArchiveModification(sourceFile.getCanonicalPath(), ModificationType.MOVE, false);
    }

    public void createClass(CtClass ctClass, String path) {
        this.modifyClass(ctClass, path, ModificationType.CREATE);
    }

    public void updateClass(CtClass ctClass, String path) {
        this.modifyClass(ctClass, path, ModificationType.UPDATE);
    }

    private void modifyClass(CtClass ctClass, String path, ModificationType type) {
        String classPath = path.endsWith(File.separator) ? path.substring(0, path.length() - File.separator.length()) : path;
        String className = ctClass.getName().replace(".", File.separator) + ".class";
        String fileName = classPath + File.separator + className;
        ctClass.debugWriteFile(classPath);
        this.recordArchiveModification(fileName, type);
    }

    public void createOrUpdateFile(Document doc, File fileToWrite) throws Exception {
        ModificationType type = fileToWrite.exists() ? ModificationType.UPDATE : ModificationType.CREATE;
        String path = null;
        try {
            path = fileToWrite.getCanonicalPath();
        }
        catch (IOException e) {
            path = fileToWrite.getAbsolutePath();
        }
        DocumentUtil.writeDocToXmlFile((Document)doc, (File)fileToWrite);
        this.recordArchiveModification(path, type);
    }

    public void createOrUpdateFile(Path filePath, String content, String path) throws IOException {
        File fileToWrite = new File(path);
        ModificationType type = fileToWrite.exists() ? ModificationType.UPDATE : ModificationType.CREATE;
        Files.write(filePath, content.getBytes(), new OpenOption[0]);
        this.recordArchiveModification(path, type);
    }

    public List<ArchiveResources> getContainedArchives() {
        return this.containedArchives;
    }

    public String retrieveClassFilePath(String className) {
        String path = null;
        if (this.isEarArchive()) {
            List<ArchiveResources> children = this.getContainedArchives();
            for (ArchiveResources child : children) {
                if (child.isJarArchive() && (path = child.retrieveClassFilePath(className)) != null) break;
            }
        } else {
            path = this.classResources.retrieveClassFilePath(className);
            if (path == null && this.isWarArchive() && this.getParentArchive() != null) {
                ArchiveResources parent = this.getParentArchive();
                path = parent.retrieveClassFilePath(className);
            }
        }
        return path;
    }

    public File retrieveGenClassFile(String className) {
        String packageClass = className.replace(".", File.separator) + ".class";
        Set<File> wsimportDirs = this.wsdlResources.getAllMigrateDirs();
        for (File dir : wsimportDirs) {
            File genDirFile = new File(dir, packageClass);
            if (!genDirFile.exists()) continue;
            return genDirFile;
        }
        return null;
    }

    public void consolidate(ArchiveResources ar) {
        this.wsdlResources.consolidate(ar.getWsdlResources());
        this.xmlResources.consolidate(ar.getXmlResources());
        this.warnMsgList.addAll(ar.getWarnMsgList());
        this.errMsgList.addAll(ar.getErrMsgList());
        if (ar.hasHolders()) {
            this.setHolderPresent();
        }
        if (ar.getParentArchive() != null && !ar.getParentArchive().isEarArchive()) {
            this.classResources.consolidate(ar.getClassResources());
            this.serviceSeiMap.putAll(ar.getServiceSeiMap());
            this.clientSeiMap.putAll(ar.getClientSeiMap());
            this.clientSeiRenamedMap.putAll(ar.getClientSeiRenamedMap());
            this.clientSeiServiceMap.putAll(ar.getClientSeiServiceMap());
            this.clientSeiMapAlternate.putAll(ar.getClientSeiMapAlternate());
            this.clientSeiServiceMapAlternate.putAll(ar.getClientSeiServiceMapAlternate());
        }
    }

    public void addClassPathForClassPool(ClassPath cp) {
        this.classPathsInserted.add(cp);
    }

    public void cleanupClassPathsFromClassPool(ClassPool pool) {
        for (ClassPath nextPath : this.classPathsInserted) {
            pool.removeClassPath(nextPath);
        }
    }

    public Set<String> getDeleteFailedCollection() {
        return new HashSet<String>(this.deleteFailedCollection);
    }

    public ClassResources getClassResources() {
        return this.classResources;
    }

    public XMLResources getXmlResources() {
        return this.xmlResources;
    }

    public String getArchiveType() {
        return this.archiveType;
    }

    public boolean isContainedInEar() {
        return this.getParentArchive() != null && this.getParentArchive().isEarArchive();
    }

    public boolean isJarContainedInEar() {
        return this.isJarArchive() && this.isContainedInEar();
    }

    public boolean isJarContainedInEar(ArchiveResources containingArchive) {
        return this.isJarArchive() && containingArchive != null && containingArchive.isEarArchive();
    }

    public boolean isEarArchive() {
        return this.archiveType.equalsIgnoreCase("ear");
    }

    public boolean isWarArchive() {
        return this.archiveType.equalsIgnoreCase("war");
    }

    public boolean isJarArchive() {
        return this.archiveType.equalsIgnoreCase("jar");
    }

    public File getExpandedClassFile(String className, File webservericesXmlLocation) {
        String classFilePath = className.replace(".", File.separator) + ".class";
        File directoryForClasses = JavaAssistHelperUtil.getDirectoryForClassWriting((File)webservericesXmlLocation);
        return new File(directoryForClasses, classFilePath);
    }

    public void addServiceMigrateDir(File migrateDir, WSDLResource wsdl) throws IOException {
        this.wsdlResources.addServiceMigrateDir(migrateDir, wsdl);
        this.trackGeneratedClasses(migrateDir);
    }

    public void addClientMigrateDir(File migrateDir, WSDLResource wsdl) throws IOException {
        this.wsdlResources.addClientMigrateDir(migrateDir, wsdl);
        this.trackGeneratedClasses(migrateDir);
    }

    public Map<String, String> getImplMigrationMap() {
        return this.implMigrationMap;
    }

    public boolean isBusinessImplFile(String classpath) {
        return this.implMigrationMap.values().contains(classpath);
    }

    public Map<String, String> getServletClassToPortComponentNames() {
        return this.servletClassToPortComponentNames;
    }

    public void addServletClassToPortComponentName(String servletClass, String name2) {
        this.servletClassToPortComponentNames.put(servletClass, name2);
    }

    public Map<String, String> getServletClassReplacements() {
        return this.replaceServletClasses;
    }

    public void addServletClassReplacement(String original, String replacement) {
        this.replaceServletClasses.put(original, replacement);
    }

    public void addBusinessImplFileRequiringSpecialConversion(String path) {
        this.implSeiSpecialConversion.add(path);
    }

    public boolean isBusinessImplFileRequiringSpecialConversion(String path) {
        return this.implSeiSpecialConversion.contains(path);
    }

    public Map<String, String> getServiceImplToSeiMap() {
        return this.serviceImplToSeiMap;
    }

    public ArchiveResources getParentArchive() {
        return this.parentArchive;
    }

    public void setParentArchive(ArchiveResources parentArchive) {
        this.parentArchive = parentArchive;
    }

    public Map<String, ServiceEndpointInterface> getServiceSeiMap() {
        return this.serviceSeiMap;
    }

    public Map<String, ClientServiceEndpointInterface> getClientSeiMap() {
        return this.clientSeiMap;
    }

    public Map<String, ClientServiceEndpointInterface> getClientSeiMapAlternate() {
        return this.clientSeiMapAlternate;
    }

    public Map<String, ClientServiceEndpointInterface> getClientSeiRenamedMap() {
        return this.clientSeiRenamedMap;
    }

    public Map<String, ClientServiceEndpointInterface> getClientSeiServiceMap() {
        return this.clientSeiServiceMap;
    }

    public Map<String, ClientServiceEndpointInterface> getClientSeiServiceMapAlternate() {
        return this.clientSeiServiceMapAlternate;
    }

    public Set<String> getClientSEIServices() {
        return this.clientSeiServiceMap.keySet();
    }

    public Set<String> getClientSEIs() {
        return this.clientSeiMap.keySet();
    }

    public Set<String> getClientSEIsRenamed() {
        return this.clientSeiRenamedMap.keySet();
    }

    public ClientServiceEndpointInterface getClientSEIByName(String seiName) {
        return this.clientSeiMap.get(seiName);
    }

    public ClientServiceEndpointInterface getClientSEIByRename(String seiName) {
        return this.clientSeiRenamedMap.get(seiName);
    }

    public ClientServiceEndpointInterface getClientSEIByServiceInterface(String serviceName) {
        return this.clientSeiServiceMap.get(serviceName);
    }

    public Set<ClientServiceEndpointInterface> findClientSEIByServiceInterface(String serviceName) {
        HashSet<ClientServiceEndpointInterface> cseis = new HashSet<ClientServiceEndpointInterface>();
        if (this.isEarArchive()) {
            for (ArchiveResources nextChild : this.containedArchives) {
                ClientServiceEndpointInterface csei;
                if (!nextChild.isWarArchive() || (csei = nextChild.getClientSEIByServiceInterface(serviceName)) == null) continue;
                cseis.add(csei);
            }
        }
        return cseis;
    }

    public void addClientClassToDelete(String classFilePath) {
        this.clientClassesToDelete.add(classFilePath);
    }

    public Set<String> getClientClassesToDelete() {
        return this.clientClassesToDelete;
    }

    public void addClientClassReferencesStub(String classFilePath) {
        this.clientClassesReferenceStub.add(classFilePath);
    }

    public Set<String> getClientClassesReferenceStub() {
        return this.clientClassesReferenceStub;
    }

    public void addClientClassReferencesService(String classFilePath, String className) {
        this.clientClassesReferenceService.put(classFilePath, className);
    }

    public Map<String, String> getClientClassesReferenceService() {
        return this.clientClassesReferenceService;
    }

    public void addClientClassReferencesServiceException(String classFilePath) {
        this.clientClassesReferenceServiceException.add(classFilePath);
    }

    public Set<String> getClientClassesReferenceServiceException() {
        return this.clientClassesReferenceServiceException;
    }

    public ServiceEndpointInterface addServiceSEI(String seiName, String portComponentName, WSDLResource wsdl) {
        ServiceEndpointInterface sei = null;
        if (this.serviceSeiMap.containsKey(seiName)) {
            sei = this.serviceSeiMap.get(seiName);
            sei.setWsdlResource(wsdl);
            if (portComponentName != null) {
                sei.setPortComponentName(portComponentName);
            }
        } else {
            sei = new ServiceEndpointInterface(seiName, portComponentName, wsdl);
            this.serviceSeiMap.put(seiName, sei);
        }
        String packageName = seiName.contains(".") ? seiName.substring(0, seiName.lastIndexOf(".")) : null;
        wsdl.setPackageName(packageName);
        return sei;
    }

    public ClientServiceEndpointInterface addClientSEI(String seiName, String serviceName, WSDLResource wsdl) {
        ClientServiceEndpointInterface csei = null;
        if (this.clientSeiMap.containsKey(seiName)) {
            csei = this.clientSeiMap.get(seiName);
            csei.setServiceName(serviceName);
            csei.setWsdlResource(wsdl);
        } else if (this.clientSeiRenamedMap.containsKey(seiName)) {
            csei = this.clientSeiRenamedMap.get(seiName);
            csei.setServiceName(serviceName);
            csei.setWsdlResource(wsdl);
        } else {
            csei = new ClientServiceEndpointInterface(seiName, serviceName, wsdl);
            this.clientSeiMap.put(seiName, csei);
            this.clientSeiRenamedMap.put(seiName + "_original", csei);
        }
        if (!csei.isGenericService()) {
            this.clientSeiServiceMap.put(serviceName, csei);
        }
        String packageName = seiName.contains(".") ? seiName.substring(0, seiName.lastIndexOf(".")) : null;
        wsdl.setPackageName(packageName);
        return csei;
    }

    public void addClientSEI(ClientServiceEndpointInterface csei, String altSeiName, String altServiceName) {
        if (altSeiName != null) {
            csei.setAlternateSeiName(altSeiName);
            this.clientSeiMapAlternate.put(altSeiName, csei);
        }
        if (altServiceName != null) {
            csei.setAlternateServiceName(altServiceName);
            this.clientSeiServiceMapAlternate.put(altServiceName, csei);
        }
    }

    public ServiceEndpointInterface createSeiObject(boolean isService, String seiName) {
        ServiceEndpointInterface newSei = null;
        if (isService) {
            newSei = new ServiceEndpointInterface(seiName);
            this.serviceSeiMap.put(seiName, newSei);
        } else {
            ClientServiceEndpointInterface clientSei = new ClientServiceEndpointInterface(seiName);
            this.clientSeiMap.put(seiName, clientSei);
            this.clientSeiRenamedMap.put(seiName + "_original", clientSei);
            newSei = clientSei;
        }
        return newSei;
    }

    public ServiceEndpointInterface getSeiObject(boolean isService, String seiName) {
        if (isService) {
            return this.serviceSeiMap.get(seiName);
        }
        ClientServiceEndpointInterface clientSei = this.clientSeiMap.get(seiName);
        return clientSei == null ? this.clientSeiRenamedMap.get(seiName) : clientSei;
    }

    public void addSeiMethodToInterface(boolean isService, String seiName, ServiceEndpointMethod seiMethodInfo) {
        ServiceEndpointInterface sei = this.getSeiObject(isService, seiName);
        if (sei == null) {
            sei = !isService && this.clientSeiMapAlternate.containsKey(seiName) ? (ServiceEndpointInterface)this.clientSeiMapAlternate.get(seiName) : this.createSeiObject(isService, seiName);
        }
        sei.addMethod(seiMethodInfo);
    }

    public void addMappingFileToMapClientSEI(String filePath, ClientServiceEndpointInterface csei) {
        this.mappingFilesToMapClientSEI.put(filePath, csei);
    }

    public void addMappingFileToCollectXsdTypes(String filePath, WSDLResource wsdl, boolean isService) {
        if (isService) {
            this.mappingFilesToCollectXsdTypesService.put(filePath, wsdl);
        } else {
            this.mappingFilesToCollectXsdTypesClient.put(filePath, wsdl);
        }
    }

    public Map<String, ClientServiceEndpointInterface> getMappingFilesToMapClientSEI() {
        return this.mappingFilesToMapClientSEI;
    }

    public Map<String, WSDLResource> getMappingFilesToCollectXsdTypesClient() {
        return this.mappingFilesToCollectXsdTypesClient;
    }

    public Map<String, WSDLResource> getMappingFilesToCollectXsdTypesService() {
        return this.mappingFilesToCollectXsdTypesService;
    }

    public void addXsdTypeToMappingType(String xsdType, String mappingType) {
        this.xsdTypeToMappingType.put(xsdType, mappingType);
    }

    public Map<String, String> getMappingTypeForXsdTypes() {
        return this.xsdTypeToMappingType;
    }

    public Set<String> getHolderSet() {
        return this.holderSet;
    }

    public void addHolder(String holder) {
        this.holderSet.add(holder);
        this.setHolderPresent();
    }

    public boolean hasHolders() {
        return this.hasHolders;
    }

    public void setHolderPresent() {
        this.hasHolders = true;
    }

    public boolean hasOverlappingSEIs() {
        return !this.overlappingSEIs.isEmpty();
    }

    public void addOverlappingSEI(String sei) {
        this.overlappingSEIs.add(sei);
    }

    public List<String> getOverlappingSEIs() {
        return this.overlappingSEIs;
    }

    public void addCustomExceptionMapping(String originalClass) {
        this.customExceptionMapping.put(originalClass, originalClass + "_Exception");
    }

    public ClassMap getCustomExceptionMapping() {
        return this.customExceptionMapping;
    }

    public boolean containsCustomException(String className) {
        return this.customExceptionMapping.containsKey(className);
    }

    public Set<String> getClassesReferenceServiceFactory() {
        return this.classesReferenceServiceFactory;
    }

    public void addClassReferenceServiceFactory(String classFilePath) {
        this.classesReferenceServiceFactory.add(classFilePath);
    }

    public static enum ModificationType {
        CREATE,
        DELETE,
        MOVE,
        UPDATE;

    }
}

