/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.appserver.tools.jaxrpc.common.data;

import com.ibm.websphere.appserver.tools.jaxrpc.common.ArchiveResources;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassResources {
    private ArchiveResources archiveResource;
    private Set<String> javaTypes = new HashSet<String>();
    private Set<String> implClasses = new HashSet<String>();
    private Set<String> ejbClassFilePaths = new HashSet<String>();
    private Set<String> servletClassFilePaths = new HashSet<String>();
    private Set<String> allClassFilePaths = new HashSet<String>();
    private Set<String> classPaths = new HashSet<String>();
    private HashMap<String, Set<String>> servletClassToNameMap = new HashMap();
    private HashMap<String, Set<String>> ejbClassToNameMap = new HashMap();
    private Set<String> enumClasses = new HashSet<String>();
    private Set<String> ejbServiceEndpoints = new HashSet<String>();
    private Set<String> classesWithPredefinedHolders = new HashSet<String>();
    private Set<String> classesWithEnumRefs = new HashSet<String>();
    private Set<String> classesWithMessageContext = new HashSet<String>();
    private Set<String> classesWithServletEndpointContext = new HashSet<String>();
    private Set<String> classesWithHandlers = new HashSet<String>();
    private List<String> clientEjbWebServices = new ArrayList<String>();

    public ClassResources(ArchiveResources ar) {
        this.archiveResource = ar;
    }

    public ArchiveResources getArchiveResources() {
        return this.archiveResource;
    }

    public void setJavaTypes(Set<String> javaTypes) {
        this.javaTypes = javaTypes;
    }

    public Set<String> getJavaTypes() {
        return this.javaTypes;
    }

    public void consolidate(ClassResources c) {
        this.putAllEjbClassToNameMap(c.getEjbClassToNameMap());
        this.implClasses.addAll(c.getImplClasses());
        this.ejbClassFilePaths.addAll(c.getEjbClassFilePaths());
        this.servletClassFilePaths.addAll(c.getServletClassFilePaths());
        this.allClassFilePaths.addAll(c.getAllClassFilePaths());
        this.classPaths.addAll(c.getClassPaths());
        this.enumClasses.addAll(c.getEnumClasses());
        this.ejbServiceEndpoints.addAll(c.getEjbServiceEndpoints());
        this.classesWithPredefinedHolders.addAll(c.getClassesWithPredefinedHolders());
        this.classesWithEnumRefs.addAll(c.getClassesWithEnumRefs());
        this.classesWithMessageContext.addAll(c.getClassesWithMessageContext());
        this.classesWithServletEndpointContext.addAll(c.getClassesWithServletEndpointContext());
    }

    public Set<String> getImplClasses() {
        return this.implClasses;
    }

    public void addImplClasses(Set<String> classes) {
        this.implClasses.addAll(classes);
    }

    public Set<String> getImplClassFilePaths() {
        HashSet<String> union = new HashSet<String>(this.servletClassFilePaths);
        union.addAll(this.ejbClassFilePaths);
        return union;
    }

    public Set<String> getEjbClassFilePaths() {
        return this.ejbClassFilePaths;
    }

    public void addEjbClassFilePath(String ejbPath) {
        this.ejbClassFilePaths.add(ejbPath);
    }

    public Set<String> getServletClassFilePaths() {
        return this.servletClassFilePaths;
    }

    public void addServletClassFilePath(String servletPath) {
        this.servletClassFilePaths.add(servletPath);
    }

    public String retrieveClassFilePath(String className) {
        String packageClass = className.replace(".", File.separator) + ".class";
        for (String classFilePath : this.allClassFilePaths) {
            if (!classFilePath.endsWith(packageClass)) continue;
            return classFilePath;
        }
        return null;
    }

    public Set<String> getAllClassFilePaths() {
        return this.allClassFilePaths;
    }

    public void addToAllClassFilePath(String canonicalPath) {
        this.allClassFilePaths.add(canonicalPath);
    }

    public Set<String> getClassPaths() {
        return this.classPaths;
    }

    public void addClassPath(String path) {
        this.classPaths.add(path);
    }

    public HashMap<String, Set<String>> getServletClassToNameMap() {
        return this.servletClassToNameMap;
    }

    public void addServletClassToName(String servletClass, Set<String> servletNames) {
        if (this.servletClassToNameMap.containsKey(servletClass)) {
            this.servletClassToNameMap.get(servletClass).addAll(servletNames);
        } else {
            this.servletClassToNameMap.put(servletClass, servletNames);
        }
    }

    public HashMap<String, Set<String>> getEjbClassToNameMap() {
        return this.ejbClassToNameMap;
    }

    public void putAllServletClassToNameMap(HashMap<String, Set<String>> map) {
        for (String servletClass : map.keySet()) {
            this.addServletClassToName(servletClass, map.get(servletClass));
        }
    }

    public void addEjbClassToName(String ejbClass, Set<String> ejbNames) {
        if (this.ejbClassToNameMap.containsKey(ejbClass)) {
            this.ejbClassToNameMap.get(ejbClass).addAll(ejbNames);
        } else {
            this.ejbClassToNameMap.put(ejbClass, ejbNames);
        }
    }

    public void putAllEjbClassToNameMap(HashMap<String, Set<String>> map) {
        for (String ejbClass : map.keySet()) {
            this.addEjbClassToName(ejbClass, map.get(ejbClass));
        }
    }

    public Set<String> getEnumClasses() {
        return this.enumClasses;
    }

    public void addEnumClass(String classname) {
        this.enumClasses.add(classname);
    }

    public boolean hasEnumClasses() {
        return !this.enumClasses.isEmpty();
    }

    public Set<String> getEjbServiceEndpoints() {
        return this.ejbServiceEndpoints;
    }

    public void addEjbServiceEndpoint(String ejbServiceEndpoint) {
        this.ejbServiceEndpoints.add(ejbServiceEndpoint);
    }

    public Set<String> getClassesWithPredefinedHolders() {
        return this.classesWithPredefinedHolders;
    }

    public void addClassWithPredefinedHolder(String rpcHolderClassFilePath) {
        this.classesWithPredefinedHolders.add(rpcHolderClassFilePath);
    }

    public Set<String> getClassesWithEnumRefs() {
        return this.classesWithEnumRefs;
    }

    public void addClassWithEnumRef(String classFilePath) {
        this.classesWithEnumRefs.add(classFilePath);
    }

    public Set<String> getClassesWithMessageContext() {
        return this.classesWithMessageContext;
    }

    public void addClassWithMessageContext(String classFilePath) {
        this.classesWithMessageContext.add(classFilePath);
    }

    public Set<String> getClassesWithServletEndpointContext() {
        return this.classesWithServletEndpointContext;
    }

    public void addClassWithServletEndpointContext(String classFilePath) {
        this.classesWithServletEndpointContext.add(classFilePath);
    }

    public Set<String> getClassesWithHandlers() {
        return this.classesWithHandlers;
    }

    public void addClassWithHandlers(String classFilePath) {
        this.classesWithHandlers.add(classFilePath);
    }

    public List<String> getClientEjbWebServicesList() {
        return this.clientEjbWebServices;
    }

    public void addClientEjbWebServicesClass(String ejbClass) {
        this.clientEjbWebServices.add(ejbClass);
    }
}

