/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.binary.cmdline;

import com.google.gson.stream.JsonReader;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.binary.cmdline.MergeFeaturesResult;
import com.ibm.websphere.binary.cmdline.exceptions.FeatureConflictException;
import com.ibm.websphere.binary.cmdline.exceptions.FeatureNotAvailableAtRequestedLevelException;
import com.ibm.websphere.binary.cmdline.exceptions.IllegalTargetCombinationException;
import com.ibm.websphere.binary.cmdline.exceptions.IllegalTargetException;
import com.ibm.websphere.binary.cmdline.exceptions.ProvidedFeatureConflictException;
import com.ibm.websphere.binary.cmdline.exceptions.RequiredFeatureModifiedException;
import com.ibm.ws.report.analyze.AnalysisResults;
import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.cmdline.DriveScan;
import com.ibm.ws.report.binary.cmdline.DriveScanAll;
import com.ibm.ws.report.binary.cmdline.DriveScanDetailedAnalysis;
import com.ibm.ws.report.binary.cmdline.DriveScanEvaluation;
import com.ibm.ws.report.binary.cmdline.DriveScanGenerateConfig;
import com.ibm.ws.report.binary.cmdline.DriveScanInventory;
import com.ibm.ws.report.binary.cmdline.DriveScanTA;
import com.ibm.ws.report.binary.cmdline.Messages;
import com.ibm.ws.report.binary.cmdline.utilities.ReportBuilderHelper;
import com.ibm.ws.report.binary.configutility.ConfigManagerFactory;
import com.ibm.ws.report.binary.utilities.BinaryReportBuilder;
import com.ibm.ws.report.ta.RewriteConfig;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ManagedLibertyFeatureSets;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.utilities.RuleSeverity;
import com.ibm.ws.report.writer.DetailAnalysisReportWriter;
import com.ibm.ws.report.writer.ReportWriter;
import com.ibm.ws.report.writer.html.HTMLDetailAnalysisStreamlinedReportWriter;
import com.ibm.ws.report.writer.json.JSONDetailAnalysisReportWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class BinaryScanner {
    public static final String TARGET_APP_SERVER_LIBERTY = "liberty";
    public static final String TARGET_APP_SERVER_OPEN_LIBERTY = "openLiberty";
    private static final EnumSet<ReportInputData.AppServer> SET_OF_SUPPORTED_FEATURE_VALIDATION_TARGETS = EnumSet.of(ReportInputData.AppServer.LIBERTY, ReportInputData.AppServer.OPEN_LIBERTY, ReportInputData.AppServer.EASE, ReportInputData.AppServer.MANAGED_LIBERTY);

    public static Set<String> generateFeatureList(Set<String> binaryInputs, String targetJavaEE, String targetMicroProfile, Set<String> currentFeatures, String logLocation, String logLevel, Locale locale) throws FeatureConflictException, RequiredFeatureModifiedException, ProvidedFeatureConflictException, FeatureNotAvailableAtRequestedLevelException, IllegalTargetException, IllegalTargetCombinationException {
        ReportUtility.setLocale(locale == null ? Locale.getDefault() : locale);
        ReportInputData data = DriveScan.processGenerateFeatureListAPIParameters(binaryInputs, targetJavaEE, targetMicroProfile, logLocation, logLevel);
        DriveScanGenerateConfig scanner = new DriveScanGenerateConfig(data, true);
        return scanner.runFeatureList((List<String>)(null == currentFeatures ? null : new ArrayList<String>(currentFeatures)));
    }

    public static MergeFeaturesResult mergeFeatures(Set<String> features, String targetAppServer) throws IllegalArgumentException {
        return BinaryScanner.mergeFeatures(features, targetAppServer, null, null, Locale.getDefault());
    }

    private static MergeFeaturesResult mergeFeatures(Set<String> features, String targetAppServer, String logLocation, String logLevel, Locale locale) throws IllegalArgumentException {
        ReportUtility.setLocale(locale);
        ReportInputData data = DriveScan.processMergeFeaturesAPIParameters(targetAppServer, logLocation, logLevel);
        DriveScanGenerateConfig scanner = new DriveScanGenerateConfig(data, true);
        return scanner.mergeFeatures(features);
    }

    public static AnalysisResults getAllRulesAnalysisResults() {
        ReportUtility.initiateLogger(false, false);
        ReportUtility.setLocale(Locale.getDefault());
        BinaryReportBuilder builder = new BinaryReportBuilder();
        builder._loadAllRules = true;
        ReportBuilderHelper.loadAllRules(builder);
        HashSet<String> rulesFlagged = new HashSet<String>();
        AnalysisResults analysisResults = new AnalysisResults(builder._descToRuleIds, null, builder.getSortedRulesByCategories(), builder.getSortedRulesAnalyzedForCategoriesStartingWithPrefix("appconversion.cloud.category.technology.connectivity"), builder._severities, builder._helpIds, rulesFlagged, true, null, builder.getRulesToRecipesMap());
        return analysisResults;
    }

    public static RewriteConfig getRecipeConfigFromRuleIds(List<String> ruleIds) {
        AnalysisResults analysisResults = BinaryScanner.getAllRulesAnalysisResults();
        RewriteConfig config = analysisResults.getRewriteConfig(ruleIds);
        return config;
    }

    public static String getHelpFromRuleIdDynamically(String ruleId) {
        ReportUtility.initiateLogger(false, false);
        ReportUtility.setLocale(Locale.getDefault());
        BinaryReportBuilder analyze = new BinaryReportBuilder();
        analyze._loadAllRules = true;
        ReportBuilderHelper.loadAllRules(analyze);
        String helpFileLoc = (String)analyze._helpIds.get(ruleId);
        String loadedHelp = null;
        try {
            loadedHelp = ReportUtility.loadRuleHelpBody(helpFileLoc, Locale.getDefault());
        }
        catch (FileNotFoundException e) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("File_Not_Loaded"), helpFileLoc));
        }
        return loadedHelp;
    }

    public static String getHelpFromRuleId(String ruleId) {
        return BinaryScanner.getHelpFromRuleId(ruleId, Locale.getDefault());
    }

    public static String getHelpFromRuleId(String ruleId, Locale locale) {
        ReportUtility.initiateLogger(false, false);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ReportUtility.setLocale(locale);
        String helpFileLocation = null;
        String helpContent = null;
        try {
            String jsonData = ReportUtility.loadFileAsString("/resources/ruleIdToHelp.json");
            JSONObject jsonObject = JSONObject.parse(jsonData.toString());
            helpFileLocation = (String)jsonObject.get(ruleId);
            helpContent = ReportUtility.loadRuleHelpBody(helpFileLocation, locale);
        }
        catch (Exception e) {
            if (null != helpFileLocation) {
                if (ReportUtility.isDebug()) {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("File_Not_Loaded_Log"), helpFileLocation), e);
                } else {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("File_Not_Loaded"), helpFileLocation));
                }
            }
            if (ReportUtility.isDebug()) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("BinaryScanner_NoHelpForRuleID"), ruleId), e);
            }
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("BinaryScanner_NoHelpForRuleID"), ruleId));
        }
        return helpContent;
    }

    public static Set<String> getListOfFeaturesExcludedInEASe() {
        TreeSet<String> sortedFeatures = new TreeSet<String>();
        sortedFeatures.addAll(DriveScanGenerateConfig.getSetOfFeaturesExcludedInEASe());
        return sortedFeatures;
    }

    public static Set<String> validateTargetServerSupportsFeatureSet(ReportInputData.AppServer targetAppServer, Set<String> features) throws IllegalArgumentException {
        if (!SET_OF_SUPPORTED_FEATURE_VALIDATION_TARGETS.contains((Object)targetAppServer)) {
            throw new IllegalArgumentException("This method only validate features for EASE, OPEN_LIBERTY, or MANAGED_LIBERTY. It also tolerates LIBERTY.");
        }
        if (ReportInputData.AppServer.LIBERTY == targetAppServer || features == null || features.isEmpty()) {
            return Collections.emptySet();
        }
        DriveScanGenerateConfig scanner = new DriveScanGenerateConfig(null);
        HashSet<String> setOfUnsupportedFeatures = new HashSet<String>();
        Set<String> unsupportedEaseFeatures = DriveScanGenerateConfig.getSetOfFeaturesExcludedInEASe();
        Set<String> supportedMLSFeatures = ManagedLibertyFeatureSets.LONDON_FEATURES_EE10;
        Set<String> supportedOLFeatures = scanner.getOpenFeatures();
        Set<String> workingSet = null;
        boolean isIncludesList = true;
        switch (targetAppServer) {
            case EASE: {
                workingSet = unsupportedEaseFeatures;
                isIncludesList = false;
                break;
            }
            case OPEN_LIBERTY: {
                workingSet = supportedOLFeatures;
                break;
            }
            case MANAGED_LIBERTY: {
                workingSet = supportedMLSFeatures;
            }
        }
        for (String feature : features) {
            if ((!isIncludesList || workingSet.contains(feature)) && (isIncludesList || !workingSet.contains(feature))) continue;
            setOfUnsupportedFeatures.add(feature);
        }
        return setOfUnsupportedFeatures;
    }

    public static int invoke(String[] args) throws Exception {
        return BinaryScanner.invoke(args, null);
    }

    public static int invoke(String[] args, Locale locale) throws Exception {
        return DriveScanInvoker.invoke(args, locale, null, null);
    }

    public static JsonReader readDevCostsRulesJsonFile() throws UnsupportedEncodingException, FileNotFoundException {
        InputStream fileLocation = BinaryScanner.class.getClassLoader().getResourceAsStream("resources/devCostRules-instanceCosts.json");
        JsonReader jsonReader = new JsonReader(new InputStreamReader(fileLocation, "UTF-8"));
        return jsonReader;
    }

    public static int migratetWASConfig(String tWASRoot, String profile, String server, Set<String> features, String platform, String outputLocation, boolean migrateAllConfig, String debugArguments, boolean includeSensitiveData, Locale locale) throws Exception {
        if (tWASRoot == null) {
            throw new IllegalArgumentException("No tWAS root directory was specified");
        }
        if (outputLocation == null) {
            throw new IllegalArgumentException("No output location was specified");
        }
        int numParameters = 3;
        if (profile != null) {
            ++numParameters;
        }
        if (server != null) {
            ++numParameters;
        }
        if (migrateAllConfig) {
            ++numParameters;
        }
        if (debugArguments != null) {
            ++numParameters;
        }
        if (includeSensitiveData) {
            ++numParameters;
        }
        int currentParameter = 0;
        String[] args = new String[numParameters];
        args[currentParameter++] = tWASRoot;
        args[currentParameter++] = "--generateConfig";
        args[currentParameter++] = "--output=" + outputLocation;
        if (profile != null) {
            args[currentParameter++] = "--profile=" + profile;
        }
        if (server != null) {
            args[currentParameter++] = "--server=" + server;
        }
        if (migrateAllConfig) {
            args[currentParameter++] = "--migrateAllConfig";
        }
        if (debugArguments != null) {
            args[currentParameter++] = debugArguments.length() > 0 ? "--debug=" + outputLocation : "--debug";
        }
        if (includeSensitiveData) {
            args[currentParameter++] = "--includeSensitiveData";
        }
        ConfigManagerFactory.clearConfigManagerMap();
        int returnCode = DriveScanInvoker.invoke(args, locale, features, platform);
        ReportUtility.cleanUpMoRELogs();
        return returnCode;
    }

    private static void buildFlaggedRulesCollections(JSONObject analysisJsonData, BinaryReportBuilder builder, Set<String> rulesFlagged, Map<String, Map<String, Map<String, List<String>>>> userRulesAnalyzedByCategory, Map<String, List<DetailResult>> projectsToRulesFound) {
        JSONArray rules = (JSONArray)analysisJsonData.get("rules");
        if (rules == null || rules.isEmpty()) {
            return;
        }
        String application = (String)((JSONArray)analysisJsonData.get("applications")).get(0);
        ArrayList<DetailResult> listOfResults = new ArrayList<DetailResult>();
        projectsToRulesFound.put(application, listOfResults);
        for (Object entry : rules) {
            JSONObject rule = (JSONObject)entry;
            String ruleId = (String)rule.get("ruleId");
            String categoryStr = (String)rule.get("category");
            boolean isUserDefinedRule = ruleId.startsWith("userDefined_");
            String ruleName = (String)rule.get("ruleName");
            String severityId = (String)rule.get("severityId");
            if (!builder._ruleIds.contains(ruleId) && !isUserDefinedRule) continue;
            rulesFlagged.add(ruleId);
            if (isUserDefinedRule) {
                Map<String, List<String>> typeMap;
                ((Set)builder.targetToCategories.entrySet().iterator().next().getValue()).add(categoryStr);
                TreeSet<String> setOfRuleIds = (TreeSet<String>)builder._descToRuleIds.get(ruleName);
                if (setOfRuleIds == null) {
                    setOfRuleIds = new TreeSet<String>();
                    builder._descToRuleIds.put(ruleName, setOfRuleIds);
                }
                setOfRuleIds.add(ruleId);
                builder._severities.put(ruleId, RuleSeverity.getRuleSeverity(severityId));
                String[] categoryArr = categoryStr.split(" / ");
                String mainCat = categoryArr[0];
                String secondaryCat = categoryArr.length > 1 ? categoryArr[1] : mainCat;
                String type = "java";
                Map<String, Map<String, List<String>>> secondaryCatMap = userRulesAnalyzedByCategory.get(mainCat);
                if (secondaryCatMap == null) {
                    secondaryCatMap = new HashMap<String, Map<String, List<String>>>();
                    userRulesAnalyzedByCategory.put(mainCat, secondaryCatMap);
                }
                if ((typeMap = secondaryCatMap.get(secondaryCat)) == null) {
                    ArrayList listOfUserRules = new ArrayList();
                    typeMap = new HashMap<String, List<String>>();
                    typeMap.put(type, listOfUserRules);
                    secondaryCatMap.put(secondaryCat, typeMap);
                }
                typeMap.get(type).add(ruleName + "=" + ruleId);
            }
            JSONArray results = (JSONArray)rule.get("results");
            for (Object resultEntry : results) {
                JSONObject result = (JSONObject)resultEntry;
                String fileName = (String)result.get("fileName");
                JSONArray resultDetails = (JSONArray)result.get("details");
                for (Object resultDetailEntry : resultDetails) {
                    JSONObject resultDetail = (JSONObject)resultDetailEntry;
                    String reference = (String)resultDetail.get("reference");
                    String match = (String)resultDetail.get("match");
                    Long lineNumber = (Long)resultDetail.get("lineNumber");
                    listOfResults.add(new DetailResult(ruleId, fileName, ruleName, match, 1, reference, lineNumber.intValue()));
                }
            }
        }
    }

    private static ReportInputData processReportInputForAnalyze(JSONObject analysisJsonData, ReportInputData.OutputType format, ReportInputData.AppServer sourceAppServer, ReportInputData.AppServer targetAppServer, ReportInputData.JavaVersion sourceJava, ReportInputData.JavaVersion targetJava, ReportInputData.JavaEEVersion sourceJavaEE, ReportInputData.JavaEEVersion targetJavaEE, ReportInputData.TargetCloud targetCloud) {
        String application = (String)((JSONArray)analysisJsonData.get("applications")).get(0);
        File appFile = new File(application);
        String appName = appFile.getName();
        String includePackages = null;
        String excludePackages = null;
        Pattern excludeFilesPattern = null;
        JSONArray options = (JSONArray)analysisJsonData.get("options");
        for (Object optionEntry : options) {
            String option = (String)optionEntry;
            if (option.startsWith("--includePackages=")) {
                includePackages = option.split("=")[1];
                continue;
            }
            if (option.startsWith("--excludePackages=")) {
                excludePackages = option.split("=")[1];
                continue;
            }
            if (!option.startsWith("--excludeFiles=")) continue;
            excludeFilesPattern = Pattern.compile(option.split("=")[1]);
        }
        return new ReportInputData(null, false, EnumSet.of(format), sourceAppServer, targetAppServer, sourceJava, targetJava, sourceJavaEE, targetJavaEE, targetCloud, null, new ArrayList<File>(Arrays.asList(appFile)), new ArrayList<String>(Arrays.asList(application)), new ArrayList<String>(Arrays.asList(appName)), null, ReportInputData.ReportType.ANALYZE, includePackages, excludePackages, excludeFilesPattern, null, null);
    }

    public static boolean isValidAnalysisJSON(JSONObject analysisJsonData) {
        if (analysisJsonData.get("report") == null || analysisJsonData.get("version") == null || analysisJsonData.get("options") == null || analysisJsonData.get("totalRulesFlagged") == null || analysisJsonData.get("filesAffected") == null || analysisJsonData.get("totalResults") == null || analysisJsonData.get("severitySummary") == null || analysisJsonData.get("applications") == null || analysisJsonData.get("rules") == null) {
            return false;
        }
        String reportType = (String)analysisJsonData.get("report");
        return reportType != "analysis";
    }

    public static String buildAnalysisReportFromAllRulesJSON(JSONObject analysisJsonData, Locale locale, ReportInputData.OutputType format, ReportInputData.AppServer sourceAppServer, ReportInputData.AppServer targetAppServer, ReportInputData.JavaVersion sourceJava, ReportInputData.JavaVersion targetJava, ReportInputData.JavaEEVersion sourceJavaEE, ReportInputData.JavaEEVersion targetJavaEE, ReportInputData.TargetCloud targetCloud) throws IllegalArgumentException, Exception {
        if (analysisJsonData == null || sourceAppServer == null || targetAppServer == null || sourceJava == null || targetJava == null || sourceJavaEE == null || targetJavaEE == null || format == null) {
            throw new IllegalArgumentException("Required parameters were not provided. View javadocs to identify required parameters");
        }
        if (!BinaryScanner.isValidAnalysisJSON(analysisJsonData)) {
            throw new IllegalArgumentException("Invalid analysis JSON provided");
        }
        if (!sourceAppServer.isValidTargetAppServer(targetAppServer)) {
            throw new IllegalArgumentException((Object)((Object)sourceAppServer) + " to " + (Object)((Object)targetAppServer) + " is not a supported migration scenerio");
        }
        if (!sourceAppServer.isValidSourceJava(sourceJava)) {
            throw new IllegalArgumentException((Object)((Object)sourceJava) + " is not a valid java version for " + (Object)((Object)sourceAppServer));
        }
        if (!targetAppServer.isValidTargetJava(targetJava)) {
            throw new IllegalArgumentException((Object)((Object)targetJava) + " is not a valid java version for " + (Object)((Object)targetAppServer));
        }
        if (!sourceAppServer.isValidJavaEE(sourceJavaEE)) {
            throw new IllegalArgumentException((Object)((Object)sourceJavaEE) + " is not a valid java ee version for " + (Object)((Object)sourceAppServer));
        }
        if (!targetAppServer.isValidJavaEE(targetJavaEE)) {
            throw new IllegalArgumentException((Object)((Object)targetJavaEE) + " is not a valid java ee version for " + (Object)((Object)targetAppServer));
        }
        if (targetCloud != null && !targetAppServer.isValidTargetCloud(targetCloud)) {
            throw new IllegalArgumentException((Object)((Object)targetCloud) + " is not supported on " + (Object)((Object)targetAppServer));
        }
        if (format != ReportInputData.OutputType.HTML && format != ReportInputData.OutputType.JSON) {
            throw new IllegalArgumentException((Object)((Object)format) + " is not a valid analysis report format");
        }
        ReportUtility.setLocale(locale == null ? Locale.getDefault() : locale);
        ReportUtility.initiateLogger(false, false);
        ReportInputData data = BinaryScanner.processReportInputForAnalyze(analysisJsonData, format, sourceAppServer, targetAppServer, sourceJava, targetJava, sourceJavaEE, targetJavaEE, targetCloud);
        BinaryReportBuilder builder = ReportBuilderHelper.loadAnalyzeRules(data, false);
        Map<String, Map<String, Map<String, List<String>>>> rulesAnalyzedByCategory = builder.getSortedRulesByCategories();
        List<String> connectivityRulesAnalyzed = builder.getSortedRulesAnalyzedForCategoriesStartingWithPrefix("appconversion.cloud.category.technology.connectivity");
        HashSet<String> rulesFlagged = new HashSet<String>();
        HashMap<String, Map<String, Map<String, List<String>>>> userRulesAnalyzedByCategory = new HashMap<String, Map<String, Map<String, List<String>>>>();
        HashMap<String, List<DetailResult>> projectsToRulesFound = new HashMap<String, List<DetailResult>>();
        BinaryScanner.buildFlaggedRulesCollections(analysisJsonData, builder, rulesFlagged, userRulesAnalyzedByCategory, projectsToRulesFound);
        rulesAnalyzedByCategory.putAll(userRulesAnalyzedByCategory);
        data.setMaxUserDefinedRuleResults(userRulesAnalyzedByCategory.isEmpty() ? -1 : 100);
        AnalysisResults analysisResults = new AnalysisResults(builder._descToRuleIds, projectsToRulesFound, rulesAnalyzedByCategory, connectivityRulesAnalyzed, builder._severities, builder._helpIds, rulesFlagged, false, (Set)builder.targetToCategories.get(data.getTargetAppServer().toString()), builder.getRulesToRecipesMap());
        ReportWriter reportWriter = null;
        if (format == ReportInputData.OutputType.HTML) {
            reportWriter = new HTMLDetailAnalysisStreamlinedReportWriter(data.getProjectNames(), data.getSourceOptions(), data.getTargetOptions(), data.getScanOptionsDisplay(), rulesAnalyzedByCategory, false, analysisResults, connectivityRulesAnalyzed, false, data.loadAllRules(), data.getMaxUserDefinedRuleResults(), builder._costs);
        } else if (format == ReportInputData.OutputType.JSON) {
            reportWriter = new JSONDetailAnalysisReportWriter(data.getProjectNames(), data.getSourceOptions(), data.getTargetOptions(), data.getScanOptions(), projectsToRulesFound, rulesAnalyzedByCategory, false, builder._helpIds, builder._severities, builder._costs, data.getApplicationNames(), builder.getCategoryNamesMappedToKeys(), data.includeHelpLocation(), data.getMaxUserDefinedRuleResults(), analysisResults);
        }
        reportWriter.writeReport();
        return ((DetailAnalysisReportWriter)reportWriter).getResult();
    }

    private static class DriveScanInvoker
    extends DriveScan {
        public DriveScanInvoker(ReportInputData data) {
            super(data);
        }

        @Override
        public Map<ReportInputData.OutputType, String> generateReport() {
            return null;
        }

        protected static int invoke(String[] args, Locale locale) throws Exception {
            return DriveScanInvoker.invoke(args, locale, null, null);
        }

        private static int invoke(String[] args, Locale locale, Set<String> staticFeatures, String platform) throws Exception {
            System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
            ReportUtility.setLocale(locale == null ? Locale.getDefault() : locale);
            DriveScanInvoker.initialize();
            ReportInputData data = DriveScanInvoker.processParameters(args);
            if (data == null) {
                if (_progressIndicatorActive) {
                    cli.finishOff();
                }
                if (ReportUtility.logger.get() != null) {
                    ReportUtility.cleanLog();
                }
                return 1;
            }
            DriveScan scanner = null;
            EnumSet<ReportInputData.ReportType> reportTypes = data.getReportTypes();
            if (reportTypes.size() == 1) {
                ReportInputData.ReportType reportType = (ReportInputData.ReportType)((Object)reportTypes.iterator().next());
                switch (reportType) {
                    case ANALYZE: {
                        scanner = new DriveScanDetailedAnalysis(data);
                        break;
                    }
                    case EVALUATE: {
                        scanner = new DriveScanEvaluation(data);
                        break;
                    }
                    case GENERATE_CONFIG: {
                        scanner = new DriveScanGenerateConfig(data, false, staticFeatures, platform);
                        break;
                    }
                    case INVENTORY: {
                        scanner = new DriveScanInventory(data);
                    }
                }
            } else {
                scanner = !data.isGenerateTA() ? new DriveScanAll(data) : new DriveScanTA(data);
            }
            scanner.runReport();
            ReportUtility.cleanLog();
            if (_progressIndicatorActive) {
                cli.finishOff();
            }
            return scanner.getReturnCode();
        }
    }
}

