/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.analyze;

import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.DetailResultComparator;
import com.ibm.ws.report.utilities.RuleSeverity;
import java.util.LinkedHashSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class AnalysisRule {
    private String ruleName;
    private RuleSeverity severity;
    private SortedMap<String, TreeSet<DetailResult>> resultsByArchive;
    private String ruleId;
    private String helpId;
    private String helpFileName;
    private String helpContent;
    private String category;
    private int resultSize;
    private String ruleIndexAdded;
    private LinkedHashSet<String> recipes;

    public AnalysisRule(String ruleId, String ruleName, String category, RuleSeverity severity, LinkedHashSet<String> recipes) {
        this.ruleId = ruleId;
        this.ruleName = ruleName;
        this.category = category;
        this.severity = severity;
        this.recipes = recipes;
        this.resultsByArchive = new TreeMap<String, TreeSet<DetailResult>>();
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public String getHelpContent() {
        return this.helpContent;
    }

    public String getHelpFileName() {
        return this.helpFileName;
    }

    public String getCategory() {
        return this.category;
    }

    public RuleSeverity getSeverity() {
        return this.severity;
    }

    public void addResult(DetailResult result, String archiveName) {
        TreeSet<DetailResult> lisOfResults;
        if (!this.resultsByArchive.containsKey(archiveName)) {
            lisOfResults = new TreeSet<DetailResult>(new DetailResultComparator());
            this.resultsByArchive.put(archiveName, lisOfResults);
        } else {
            lisOfResults = (TreeSet<DetailResult>)this.resultsByArchive.get(archiveName);
        }
        lisOfResults.add(result);
        this.resultSize += result.getNumberOfOccurrences();
    }

    public SortedMap<String, TreeSet<DetailResult>> getResults() {
        return this.resultsByArchive;
    }

    public void setHelpInfo(String helpContent, String helpId, String helpFileName) {
        this.helpId = helpId;
        this.helpContent = helpContent;
        this.helpFileName = helpFileName;
    }

    public int getResultSize() {
        return this.resultSize;
    }

    public void setRuleIndexAdded(int id) {
        this.ruleIndexAdded = "rule" + id;
    }

    public String getRuleIndexAdded() {
        return this.ruleIndexAdded;
    }

    public boolean hasRecipe() {
        return this.recipes != null && !this.recipes.isEmpty();
    }

    public LinkedHashSet<String> getRecipes() {
        return this.recipes;
    }
}

