/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.asm.utilities;

import com.ibm.ws.report.binary.asm.utilities.MethodInfo;
import com.ibm.ws.report.binary.asm.utilities.StackDetails;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class MethodDetails {
    private static boolean DEBUG = false;
    private String name = null;
    private String signature = null;
    private boolean isPublic;
    private final Map<String, Set<MethodInfo>> methodInformation = new HashMap<String, Set<MethodInfo>>();

    public MethodDetails(String name2, String signature, String owner, String returnType, String[] argumentTypes) {
        this(name2, signature, owner, returnType, argumentTypes, null, 0, null, null, null, -1);
    }

    public MethodDetails(String name2, String signature, String owner, String returnType, String[] argumentTypes, String methodName, int lineNumber, ArrayDeque<StackDetails> sd, List<String> activeCatchExceptions, List<String> activeThrowsExceptions, int methodNumber) {
        this.name = name2;
        this.signature = signature;
        this.addOccurence(owner, returnType, argumentTypes, methodName, lineNumber, sd, activeCatchExceptions, activeThrowsExceptions, methodNumber);
    }

    public void addOccurence(String owner, String returnType, String[] argumentTypes, String methodName, int lineNumber, ArrayDeque<StackDetails> sd, List<String> activeCatchExceptions, List<String> activeThrowsExceptions, int methodNumber) {
        StringBuilder message = new StringBuilder(500);
        message.append("MethodDetails.addOccurrence for method: ").append(this.name);
        if (methodName != null) {
            message.append("     methodName: ").append(methodName).append(" line: ").append(lineNumber);
        }
        ReportUtility.logger.get().log(Level.FINEST, message.toString());
        MethodInfo mi = new MethodInfo(this.name, owner, returnType, argumentTypes);
        Set<MethodInfo> existingMI = this.methodInformation.get(owner);
        if (existingMI == null) {
            mi.addOccurrence(methodName, lineNumber, sd, activeCatchExceptions, activeThrowsExceptions, methodNumber);
            HashSet<MethodInfo> mis = new HashSet<MethodInfo>();
            mis.add(mi);
            this.methodInformation.put(owner, mis);
        } else {
            Iterator<MethodInfo> it = existingMI.iterator();
            boolean foundMatch = false;
            while (it.hasNext() && !foundMatch) {
                MethodInfo thisMI = it.next();
                if (!mi.matchSignature(thisMI)) continue;
                thisMI.addOccurrence(methodName, lineNumber, sd, activeCatchExceptions, activeThrowsExceptions, methodNumber);
                foundMatch = true;
            }
            if (!foundMatch) {
                mi.addOccurrence(methodName, lineNumber, sd, activeCatchExceptions, activeThrowsExceptions, methodNumber);
                existingMI.add(mi);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public Set<MethodInfo> getMethodInfo(String owner) {
        HashSet<MethodInfo> mis = null;
        if (owner.equals("*")) {
            mis = new HashSet();
            for (String key : this.methodInformation.keySet()) {
                mis.addAll((Collection<MethodInfo>)this.methodInformation.get(key));
            }
        } else {
            mis = this.methodInformation.get(owner);
        }
        return mis;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }
}

