/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.asm.utilities;

import com.ibm.ws.report.binary.asm.utilities.StackDetails;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class MethodInfo {
    private static boolean DEBUG = false;
    private String _name = null;
    private String _ownerName = null;
    private String _returnType = null;
    private String[] _argumentTypes = null;
    private int _occurrences = 0;
    private Map<String, List<Integer>> _methodAndLine = new HashMap<String, List<Integer>>();
    private Map<String, List<Integer>> _methodAndMethodNumber = new HashMap<String, List<Integer>>();
    private Map<String, List<ArrayDeque<StackDetails>>> _methodAndStack = new HashMap<String, List<ArrayDeque<StackDetails>>>();
    private Map<String, List<List<String>>> _methodAndCatchExceptions = new HashMap<String, List<List<String>>>();
    private Map<String, List<List<String>>> _methodAndThrowsExceptions = new HashMap<String, List<List<String>>>();

    public MethodInfo(String name2, String owner, String returnType, String[] argumentTypes) {
        this._name = name2;
        this._ownerName = owner;
        this._returnType = returnType;
        this._argumentTypes = argumentTypes;
    }

    public boolean matchSignature(Object compareObject) {
        MethodInfo mi;
        boolean flag = false;
        if (compareObject instanceof MethodInfo && this._name.equals((mi = (MethodInfo)compareObject).getName()) && this._ownerName.equals(mi.getOwner()) && (this._returnType != null && this._returnType.equals(mi.getReturnType()) || this._returnType == null && mi.getReturnType() == null)) {
            Object[] miArgs = mi.getArgumentTypes();
            if (this._argumentTypes != null && miArgs != null && Arrays.equals(this._argumentTypes, miArgs) || this._argumentTypes == null && miArgs == null) {
                flag = true;
            }
        }
        return flag;
    }

    public void addOccurrence(String methodName, int lineNumber, ArrayDeque<StackDetails> sd, List<String> activeCatchExceptions, List<String> activeThrowsExceptions, int methodNumber) {
        ++this._occurrences;
        StringBuilder message = new StringBuilder(500);
        message.append("MethodInfo.addOccurrence for methodName: ").append(methodName).append(" occurences: ").append(this._occurrences);
        if (methodName != null) {
            message.append("     methodName: ").append(methodName).append(" line: ").append(lineNumber).append(" methodNumber: ").append(methodNumber);
            if (this._methodAndLine.containsKey(methodName)) {
                List<Integer> lines = this._methodAndLine.get(methodName);
                lines.add(lineNumber);
                List<Integer> methodNumbers = this._methodAndMethodNumber.get(methodName);
                methodNumbers.add(methodNumber);
                List<ArrayDeque<StackDetails>> stacks = this._methodAndStack.get(methodName);
                stacks.add(sd);
                List<List<String>> catchExceptions = this._methodAndCatchExceptions.get(methodName);
                catchExceptions.add(activeCatchExceptions);
                List<List<String>> throwsExceptions = this._methodAndThrowsExceptions.get(methodName);
                throwsExceptions.add(activeThrowsExceptions);
            } else {
                ArrayList<Integer> lines = new ArrayList<Integer>();
                lines.add(lineNumber);
                this._methodAndLine.put(methodName, lines);
                ArrayList<Integer> methodNumbers = new ArrayList<Integer>();
                methodNumbers.add(methodNumber);
                this._methodAndMethodNumber.put(methodName, methodNumbers);
                ArrayList<ArrayDeque<StackDetails>> stacks = new ArrayList<ArrayDeque<StackDetails>>();
                stacks.add(sd);
                this._methodAndStack.put(methodName, stacks);
                ArrayList<List<String>> catchExceptions = new ArrayList<List<String>>();
                catchExceptions.add(activeCatchExceptions);
                this._methodAndCatchExceptions.put(methodName, catchExceptions);
                ArrayList<List<String>> throwsExceptions = new ArrayList<List<String>>();
                throwsExceptions.add(activeThrowsExceptions);
                this._methodAndThrowsExceptions.put(methodName, throwsExceptions);
            }
        }
        ReportUtility.logger.get().log(Level.FINEST, message.toString());
    }

    public boolean matches(String returnType, String[] arguments) {
        boolean flag = false;
        if (returnType == null || returnType != null && returnType.equals(this._returnType)) {
            if (arguments == null) {
                flag = true;
            } else if (Arrays.equals(this._argumentTypes, arguments)) {
                flag = true;
            } else if (arguments.length == 1 && arguments[0].equals("") && this._argumentTypes.length == 0) {
                flag = true;
            } else if (this.matchesWithEllipsis(arguments)) {
                flag = true;
            }
        }
        return flag;
    }

    protected boolean matchesWithEllipsis(String[] arguments) {
        if (arguments.length != this._argumentTypes.length) {
            return false;
        }
        int i = 0;
        while (i < arguments.length) {
            String nextArg = arguments[i];
            if (!nextArg.equals(this._argumentTypes[i])) {
                if (nextArg.endsWith("...")) {
                    String arrayArg = String.valueOf(nextArg.substring(0, nextArg.length() - 3)) + "[]";
                    if (!arrayArg.equals(this._argumentTypes[i])) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public String getName() {
        return this._name;
    }

    public String getOwner() {
        return this._ownerName;
    }

    public String getReturnType() {
        return this._returnType;
    }

    public String[] getArgumentTypes() {
        return this._argumentTypes;
    }

    public int getOccurrences() {
        return this._occurrences;
    }

    public Map<String, List<Integer>> getMethodAndLineInfo() {
        return this._methodAndLine;
    }

    public Map<String, List<Integer>> getMethodAndMethodNumber() {
        return this._methodAndMethodNumber;
    }

    public Map<String, List<ArrayDeque<StackDetails>>> getMethodAndStackInfo() {
        return this._methodAndStack;
    }

    public Map<String, List<List<String>>> getCatchExceptionInfo() {
        return this._methodAndCatchExceptions;
    }

    public Map<String, List<List<String>>> getThrowsExceptionInfo() {
        return this._methodAndThrowsExceptions;
    }
}

