/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.websphere.binary.cmdline.BinaryScanner;
import com.ibm.websphere.binary.cmdline.exceptions.FeatureConflictException;
import com.ibm.websphere.binary.cmdline.exceptions.FeatureNotAvailableAtRequestedLevelException;
import com.ibm.websphere.binary.cmdline.exceptions.IllegalTargetException;
import com.ibm.websphere.binary.cmdline.exceptions.ProvidedFeatureConflictException;
import com.ibm.websphere.binary.cmdline.exceptions.RequiredFeatureModifiedException;
import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.cmdline.DriveScanAll;
import com.ibm.ws.report.binary.cmdline.DriveScanDetailedAnalysis;
import com.ibm.ws.report.binary.cmdline.DriveScanEvaluation;
import com.ibm.ws.report.binary.cmdline.DriveScanGenerateConfig;
import com.ibm.ws.report.binary.cmdline.DriveScanInventory;
import com.ibm.ws.report.binary.cmdline.DriveScanTA;
import com.ibm.ws.report.binary.cmdline.Messages;
import com.ibm.ws.report.binary.cmdline.ReportGeneration;
import com.ibm.ws.report.binary.cmdline.ta.cli.CLI;
import com.ibm.ws.report.binary.cmdline.ta.cli.sections.CliConfigFilesSection;
import com.ibm.ws.report.binary.cmdline.ta.cli.sections.CliStatusSection;
import com.ibm.ws.report.binary.cmdline.utilities.ConfigUtility;
import com.ibm.ws.report.binary.configutility.ConfigManagerFactory;
import com.ibm.ws.report.binary.configutility.RequestedServers;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.generator.DeploymentEnvironment;
import com.ibm.ws.report.binary.configutility.generator.LibertyServerXml;
import com.ibm.ws.report.binary.configutility.generator.TargetConfig;
import com.ibm.ws.report.binary.configutility.twas.ConfigManager;
import com.ibm.ws.report.binary.reader.BinaryReportReader;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.BinaryReportBuilder;
import com.ibm.ws.report.binary.utilities.ConfigFeatureVersionInfo;
import com.ibm.ws.report.binary.utilities.DataCollectionHelper;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.binary.utilities.eetechnologies.Technology;
import com.ibm.ws.report.processor.ReportBuilder;
import com.ibm.ws.report.technology.AbstractTechnologyFactory;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.Constants;
import com.ibm.ws.report.utilities.FileComparator;
import com.ibm.ws.report.utilities.FileHelper;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.was2liberty.technology.Was2LibertyTechnologyFactory;
import com.ibm.ws.report.writer.json.ScanResult;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DriveScan
implements ReportGeneration {
    protected static boolean _hiddenJunitFlag = false;
    private static File[] _ruleXmlFiles = null;
    private static boolean reportTypeSpecified = false;
    protected boolean _isDirectoryWithMultipleApps = false;
    private static List<String> _applicationNames = new ArrayList<String>();
    private static List<String> _projectNames = new ArrayList<String>();
    private static List<File> _projectFiles = new ArrayList<File>();
    protected static List<File> _sharedLibraryFiles = new ArrayList<File>();
    protected static List<File> _tempSharedLibraryFiles = new ArrayList<File>();
    private static Map<File, String> _mapOfAppsToProfiles = new HashMap<File, String>();
    private static Map<String, String> _mapOfProfilesToPaths = new HashMap<String, String>();
    protected static boolean _isOldHtml = false;
    protected static String _preFileName = "_";
    public Map<String, Rule> _rules = null;
    List<Rule> configRules = new ArrayList<Rule>();
    public BinaryReportReader _reader = null;
    public AbstractTechnologyFactory _techFactory = null;
    public BinaryReportBuilder _builder = null;
    protected int returnCode = 0;
    protected static ReportInputData _data = null;
    static boolean _foundInvalidRule = false;
    public static boolean london = false;
    protected static boolean _progressIndicatorActive = false;
    private static File _outputDir = null;
    private static boolean _delete = false;
    protected static CLI cli;
    private static Pattern FILENAME_REGEX;
    private static Pattern FILENAME_WITH_EXTENSION_REGEX;
    private static String ASM_PACKAGE;
    private static String VALID_OUTPUT_FILE_EXTENSION;
    protected static List<String> _missingBinaries;

    public DriveScan(ReportInputData data) {
        _data = data;
    }

    public DriveScan(ReportInputData data, AbstractTechnologyFactory techFactory) {
        _data = data;
        this._techFactory = techFactory;
    }

    @Override
    public String getDefaultReportName() {
        return "TechnologyReport";
    }

    public void addConfigRule(Map<String, Rule> rules) {
        if (rules != null && !rules.isEmpty()) {
            Rule detectJndiRule = rules.get("DetectConfigJNDI");
            Rule availableThirdPartyPackagesApacheMyFaces = rules.get("AvailableThirdPartyPackagesApacheMyFaces");
            this.configRules.add(detectJndiRule);
            this.configRules.add(availableThirdPartyPackagesApacheMyFaces);
            rules.remove("DetectConfigJNDI");
        }
    }

    @Override
    public Map<String, Rule> getRules() {
        if (this._rules == null) {
            this._builder = new BinaryReportBuilder();
            this._builder.buildReport(this.getTechnologyFactory(), "/rules/technology/ReportList.xml");
            if (this._builder._foundInvalidRule) {
                return null;
            }
            this._rules = this._builder._reportRules;
        }
        return this._rules;
    }

    public List<Rule> getNonTechRules() {
        ArrayList<Rule> nonTechRules = new ArrayList<Rule>();
        HashSet<String> ruleNames = new HashSet<String>();
        this._builder.loadList("/rules/java/JavaList.xml", ruleNames, ReportBuilder.ListType.Analysis);
        if (this._builder._foundInvalidRule) {
            return null;
        }
        for (String ruleName : ruleNames) {
            Rule thisRule = this._builder._reportRules.get(ruleName);
            if (thisRule == null) continue;
            nonTechRules.add(thisRule);
            this._builder._reportRules.remove(ruleName);
        }
        return nonTechRules;
    }

    public Map<String, String> getRuleHelp() {
        HashMap<String, String> helpFileNames = null;
        helpFileNames = this._builder != null ? this._builder._helpIds : new HashMap<String, String>();
        return helpFileNames;
    }

    public AbstractTechnologyFactory getTechnologyFactory() {
        if (this._techFactory == null) {
            this._techFactory = new Was2LibertyTechnologyFactory();
        }
        return this._techFactory;
    }

    @Override
    public BinaryReportReader getBinaryReportReader() {
        if (this._reader == null) {
            this._reader = new BinaryReportReader(_data, this.getRules(), this.getTechnologyFactory().getListOfTechnologies(), this.getNonTechRules());
        }
        return this._reader;
    }

    public void openHtmlReport(File outputFile, String output, ReportInputData.OutputType outputType, boolean isDirectoryWithMultipleApps) {
        block20: {
            try {
                this.setReturnCode(ReportUtility.writeOutStream(outputFile, output));
                if (_data.isDisplay() && !isDirectoryWithMultipleApps && !"z/os".equalsIgnoreCase(ReportUtility.OS)) {
                    String outputHtmlFilePath = outputFile.getAbsolutePath();
                    URI fileURI = outputFile.toURI();
                    try {
                        if (Desktop.isDesktopSupported()) {
                            Desktop.getDesktop().browse(fileURI);
                            break block20;
                        }
                        ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_No_Default_Browser"), outputHtmlFilePath));
                    }
                    catch (Exception e) {
                        try {
                            this.openInBrowserAlt(fileURI);
                            break block20;
                        }
                        catch (Exception ex) {
                            if (outputHtmlFilePath != null) {
                                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Opening_Browser_Log"), outputHtmlFilePath), ex);
                                break block20;
                            }
                            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Opening_Browser_Log_Path_Null"), new Object[0]), ex);
                        }
                    }
                    break block20;
                }
                if ("z/os".equalsIgnoreCase(ReportUtility.OS)) {
                    ReportUtility.logger.get().log(Level.FINE, "Skip opening a browser because the tool is running on z/OS.");
                }
            }
            catch (Exception e) {
                if (_data.isDisplay()) {
                    if (ReportUtility.isDebug()) {
                        ReportUtility.logger.get().log(Level.SEVERE, Messages.getString("DriveScan_Error_Display_Report_Html_Log"), e);
                    } else {
                        ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Display_Report_Html"), e.getMessage()));
                    }
                } else if (outputFile != null) {
                    if (ReportUtility.isDebug()) {
                        ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Write_Report_Log"), outputFile.getAbsolutePath()), e);
                    } else {
                        ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Write_Report"), outputFile.getAbsolutePath(), e.getMessage()));
                    }
                } else if (ReportUtility.isDebug()) {
                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getString("DriveScan_Error_Write_Report_No_File_Log"), e);
                } else {
                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Write_Report_No_File"), e.getMessage()));
                }
                this.setReturnCode(2);
            }
        }
    }

    public void openInBrowserAlt(URI fileURI) throws Exception {
        String os = ReportUtility.OS;
        Runtime runtime = Runtime.getRuntime();
        if (os.indexOf("win") >= 0) {
            runtime.exec("rundll32 url.dll,FileProtocolHandler " + fileURI);
        } else if (os.indexOf("mac") >= 0) {
            runtime.exec("open " + fileURI);
        } else if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
            String[] browsers = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
            StringBuilder cmdSB = new StringBuilder();
            int i = 0;
            for (String browser : browsers) {
                cmdSB.append((i == 0 ? "" : " || ") + browser + " \"" + fileURI + "\" ");
                ++i;
            }
            runtime.exec(new String[]{"sh", "-c", cmdSB.toString()});
        } else {
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_No_Default_Browser"), fileURI.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReport() {
        FileOutputStream fos = null;
        OutputStreamWriter out = null;
        List<File> apps = _data.getProjectFiles();
        if (apps.size() > 1) {
            this._isDirectoryWithMultipleApps = true;
        }
        boolean showAllHelp = _data.showAllHelp();
        Collections.sort(apps, new FileComparator());
        List<String> appNames = _data.getProjectNames();
        Collections.sort(appNames);
        Map<ReportInputData.OutputType, File> outputFileMap = _data.getOutputFile();
        EnumSet<ReportInputData.OutputType> ouputTypes = _data.getOutputType();
        boolean i = false;
        if (showAllHelp && apps.isEmpty()) {
            apps.add(new File("Dummy.ear"));
        }
        Iterator<File> appsIteractor = apps.iterator();
        while (appsIteractor.hasNext()) {
            Map<ReportInputData.OutputType, String> outputMap;
            File app = appsIteractor.next();
            ArrayList<String> projectName = new ArrayList<String>();
            ArrayList<File> projectFile = new ArrayList<File>();
            String fileName = app.getName();
            if (fileName.equals("Dummy.ear")) {
                appsIteractor.remove();
            } else {
                String appName = app.getAbsolutePath();
                appName = ReportUtility.filterUppercaseFileExtension(appName);
                appName = appName.replace("\\", "/");
                projectName.add(appName);
                projectFile.add(app);
                _data.setProjectData(projectFile, projectName);
            }
            if ((outputMap = this.generateReport()).isEmpty()) continue;
            for (ReportInputData.OutputType outputType : ouputTypes) {
                File outputFile = outputFileMap.get((Object)outputType);
                String output = outputMap.get((Object)outputType);
                switch (outputType) {
                    case HTML: {
                        if (outputFile == null || apps.size() > 1) {
                            outputFile = new File(this.getDefaultReportFileName(app) + outputType.getExtension());
                        }
                        this.openHtmlReport(outputFile, output, outputType, this._isDirectoryWithMultipleApps);
                        break;
                    }
                    case JSON: {
                        try {
                            if (outputFile == null || apps.size() > 1) {
                                outputFile = new File(this.getDefaultReportFileName(app) + outputType.getExtension());
                            }
                            this.setReturnCode(ReportUtility.writeOutStream(outputFile, output));
                        }
                        catch (Exception e) {
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Write_Report"), outputFile.getAbsolutePath(), e.getMessage()));
                            this.setReturnCode(2);
                        }
                        break;
                    }
                    case TEXT: {
                        if (outputFile != null) {
                            PrintWriter pw = null;
                            try {
                                fos = new FileOutputStream(outputFile, false);
                                out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                                pw = new PrintWriter((Writer)out, true);
                                pw.write("\ufeff");
                                pw.println(output);
                                System.out.println(Messages.getFormattedMessage(Messages.getString("DriveScan_Report_File_Written"), outputFile.getAbsolutePath()));
                            }
                            catch (Exception e) {
                                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Write_Report"), outputFile.getAbsolutePath(), e.getMessage()));
                            }
                            finally {
                                if (pw != null) {
                                    pw.close();
                                } else if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException iOException) {}
                                } else if (fos != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                        if (!_data.isDisplay() && outputFile != null) break;
                        System.out.println(output);
                        break;
                    }
                }
            }
        }
        if (!ReportUtility.getFilesWithParsingError().isEmpty()) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Processing_Files"), ReportUtility.getFilesWithParsingError()));
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
        ReportUtility.setLocale(Locale.getDefault());
        DriveScan.initialize();
        ReportInputData data = DriveScan.processParameters(args);
        if (data == null) {
            if (_progressIndicatorActive) {
                cli.finishOff();
            }
            if (ReportUtility.logger.get() != null) {
                ReportUtility.cleanLog();
            }
            String junitMessage = "An invalid parameter was specified.";
            DriveScan.systemExit(1, junitMessage);
        }
        DriveScan scanner = null;
        EnumSet<ReportInputData.ReportType> reportTypes = data.getReportTypes();
        if (reportTypes.size() == 1) {
            ReportInputData.ReportType reportType = (ReportInputData.ReportType)((Object)reportTypes.iterator().next());
            switch (reportType) {
                case ANALYZE: {
                    scanner = new DriveScanDetailedAnalysis(data);
                    break;
                }
                case EVALUATE: {
                    scanner = new DriveScanEvaluation(data);
                    break;
                }
                case GENERATE_CONFIG: {
                    scanner = new DriveScanGenerateConfig(data);
                    break;
                }
                case INVENTORY: {
                    scanner = new DriveScanInventory(data);
                }
            }
        } else {
            scanner = !data.isGenerateTA() ? new DriveScanAll(data) : new DriveScanTA(data);
        }
        scanner.runReport();
        ReportUtility.cleanLog();
        if (_progressIndicatorActive) {
            cli.finishOff();
        }
        String junitMessage = "Scan was not successful.";
        DriveScan.systemExit(scanner.getReturnCode(), junitMessage);
    }

    public static String DriveScanWeb(String[] args, File binaryInput) throws Exception {
        return DriveScan.DriveScanWeb(args, binaryInput, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String DriveScanWeb(String[] args, File binaryInput, Locale locale) throws Exception {
        if (locale != null) {
            ReportUtility.setLocale(locale);
        } else {
            ReportUtility.setLocale(Locale.getDefault());
        }
        ReportUtility.initiateLogger(false, true);
        String binaryWorkspace = binaryInput.getCanonicalPath();
        String outputFileName = binaryInput.getName() + "_MigrationReport.html";
        binaryWorkspace = binaryWorkspace.substring(0, binaryWorkspace.lastIndexOf("input") - 1);
        ReportInputData data = DriveScan.processWebAppParameters(args, binaryInput);
        if (data == null) {
            throw new Exception("ReportInputData is null");
        }
        DriveScanAll scanner = new DriveScanAll(data);
        Map<ReportInputData.OutputType, Set<String>> outputMap = scanner.generateReportString(binaryInput.getCanonicalFile(), data.getProjectNames().get(0), new StringBuilder());
        Map.Entry<ReportInputData.OutputType, Set<String>> entry = outputMap.entrySet().iterator().next();
        String output = entry.getValue().iterator().next();
        File binaryDirectory = new File(binaryWorkspace, locale != null ? "output/" + locale.toString() : "output");
        binaryDirectory.mkdirs();
        BufferedWriter bw = null;
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(binaryDirectory + "/" + outputFileName);
            bw = new BufferedWriter(fw);
            bw.write(output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return output;
    }

    public static String DriveScanWeb(String[] args, InputStream binaryInput, BinaryReportReader.BinaryType type, String reportName, Locale locale) throws Exception {
        ReportUtility.setLocale(locale);
        ReportUtility.initiateLogger(true, true);
        ReportInputData data = DriveScan.processWebAppParameters(args, binaryInput, type, reportName);
        if (data == null) {
            throw new Exception("ReportInputData is null");
        }
        DriveScanAll scanner = new DriveScanAll(data);
        Map<ReportInputData.OutputType, Set<String>> outputMap = scanner.generateReportString(null, data.getProjectNames().get(0), new StringBuilder());
        Map.Entry<ReportInputData.OutputType, Set<String>> entry = outputMap.entrySet().iterator().next();
        return entry.getValue().iterator().next();
    }

    public static Set<String> driveScanMavenFeatureList(String[] binaryInputs, String targetJavaEE, String targetMicroProfile, List<String> currentFeatures, Locale locale) throws com.ibm.ws.report.exceptions.FeatureConflictException, com.ibm.ws.report.exceptions.RequiredFeatureModifiedException {
        try {
            return BinaryScanner.generateFeatureList(binaryInputs == null ? null : new HashSet<String>(Arrays.asList(binaryInputs)), targetJavaEE, targetMicroProfile, currentFeatures == null ? null : new HashSet<String>(currentFeatures), null, null, locale);
        }
        catch (FeatureConflictException ex) {
            com.ibm.ws.report.exceptions.FeatureConflictException reportEx = new com.ibm.ws.report.exceptions.FeatureConflictException();
            reportEx.setFeatures(ex.getFeatures());
            for (String message : ex.getMessages()) {
                reportEx.addMessage(message);
            }
            throw reportEx;
        }
        catch (RequiredFeatureModifiedException ex) {
            throw new com.ibm.ws.report.exceptions.RequiredFeatureModifiedException(ex.getMessage(), ex.getFeatures());
        }
        catch (ProvidedFeatureConflictException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        catch (FeatureNotAvailableAtRequestedLevelException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public static ReportInputData processGenerateFeatureListAPIParameters(Set<String> binaryInputs, String targetJavaEE, String targetMicroProfile, String logLocation, String logLevel) {
        boolean isValidMP;
        SortedMap<String, Level> processedLogArgs = null;
        if (null != logLevel && !"".equals(logLevel) && !"*=off".equalsIgnoreCase(logLevel)) {
            if (!logLevel.startsWith("--debug=")) {
                logLevel = "--debug=" + logLevel;
            }
            processedLogArgs = DriveScan.processLogArgs(logLevel, true);
        }
        boolean debug = processedLogArgs != null;
        ReportUtility.initiateLogger(debug, false, processedLogArgs == null, processedLogArgs, logLocation);
        boolean isValidEE = targetJavaEE != null ? ReportInputData.JavaEEVersion.isValidOption(targetJavaEE) : true;
        boolean bl = isValidMP = targetMicroProfile != null ? ReportInputData.MicroProfileVersion.isValidOption(targetMicroProfile) : true;
        if (!isValidEE || !isValidMP) {
            String illegalOption = "";
            String illegalOptionParameter = "";
            if (!isValidEE && !isValidMP) {
                illegalOption = targetJavaEE + "," + targetMicroProfile;
                illegalOptionParameter = "targetJavaEE,targetMicroProfile";
            } else if (!isValidEE) {
                illegalOption = targetJavaEE;
                illegalOptionParameter = "targetJavaEE";
            } else {
                illegalOption = targetMicroProfile;
                illegalOptionParameter = "targetMicroProfile";
            }
            String message = Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), illegalOption, illegalOptionParameter);
            throw new IllegalTargetException(message, isValidMP ? null : targetMicroProfile, isValidEE ? null : targetJavaEE);
        }
        ArrayList<File> projectFiles = new ArrayList<File>();
        ArrayList<String> projectNames = new ArrayList<String>();
        if (binaryInputs != null) {
            for (String binaryLocationPath : binaryInputs) {
                File binaryLocation = new File(binaryLocationPath);
                if (!binaryLocation.exists()) {
                    String message = Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_BinaryInputPath_Not_Valid_File"), binaryLocationPath);
                    throw new IllegalArgumentException(message);
                }
                String path = DriveScan.getFileName(binaryLocation);
                boolean inputIsDirectory = binaryLocation.isDirectory();
                if (inputIsDirectory) {
                    DriveScan.addAllBinaryFilesForDirectory(new File(path), projectNames, projectFiles, true);
                    continue;
                }
                projectFiles.add(binaryLocation);
                projectNames.add(path);
            }
        }
        ReportInputData data = new ReportInputData(projectFiles, projectNames, targetJavaEE, targetMicroProfile);
        return data;
    }

    public static ReportInputData processMergeFeaturesAPIParameters(String targetAppServer, String logLocation, String logLevel) {
        ReportInputData.AppServer appServer;
        SortedMap<String, Level> processedLogArgs = null;
        if (null != logLevel && !"".equals(logLevel) && !"*=off".equalsIgnoreCase(logLevel)) {
            if (!logLevel.startsWith("--debug=")) {
                logLevel = "--debug=" + logLevel;
            }
            processedLogArgs = DriveScan.processLogArgs(logLevel, true);
        }
        boolean debug = processedLogArgs != null;
        ReportUtility.initiateLogger(debug, false, processedLogArgs == null, processedLogArgs, logLocation);
        if (targetAppServer != null) {
            String targetAppServerOption = targetAppServer.startsWith("--targetAppServer=") ? targetAppServer : "--targetAppServer=" + targetAppServer;
            appServer = ReportInputData.AppServer.getAppServer(targetAppServerOption);
            if (appServer == null) {
                String message = Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), targetAppServer, "targetAppServer");
                throw new IllegalArgumentException(message);
            }
            if (!appServer.isLiberty()) {
                String message = Messages.getString("DriveScan_No_Feature_Support");
                throw new IllegalArgumentException(message);
            }
        } else {
            appServer = ReportInputData.AppServer.LIBERTY;
        }
        ReportInputData.JavaEEVersion targetJavaEE = null;
        ReportInputData data = new ReportInputData(appServer, targetJavaEE);
        return data;
    }

    private static ReportInputData processWebAppParameters(String[] args, File inputFile) {
        String binaryLocationPath = inputFile.getAbsolutePath();
        File binaryLocation = new File(binaryLocationPath);
        String path = DriveScan.getFileName(inputFile);
        if (!binaryLocationPath.startsWith(path)) {
            binaryLocationPath = path;
            binaryLocation = new File(binaryLocationPath);
        }
        ArrayList<File> projectFiles = new ArrayList<File>(Arrays.asList(binaryLocation));
        ArrayList<String> projectNames = new ArrayList<String>(Arrays.asList(binaryLocationPath));
        ReportInputData data = new ReportInputData(projectFiles, projectNames, args);
        String pathNormalized = binaryLocationPath.replace("\\", "/");
        int index = pathNormalized.lastIndexOf(47);
        if (index > -1) {
            String dirPath = pathNormalized.substring(0, index);
            data.addProjectDirPath(dirPath);
        }
        return data;
    }

    private static ReportInputData processWebAppParameters(String[] args, InputStream inputFileStream, BinaryReportReader.BinaryType type, String inputArchiveName) {
        ArrayList<String> projectNames = new ArrayList<String>(Arrays.asList("/WebApp/" + inputArchiveName));
        ReportInputData data = new ReportInputData(inputFileStream, projectNames, args, type);
        data.addProjectDirPath("/WebApp");
        return data;
    }

    public static void initialize() {
        _data = null;
        _ruleXmlFiles = null;
        _isOldHtml = false;
        _foundInvalidRule = false;
        _preFileName = "_";
        _hiddenJunitFlag = false;
        _progressIndicatorActive = false;
        _delete = false;
        _projectNames.clear();
        _projectFiles.clear();
        _applicationNames.clear();
        _sharedLibraryFiles.clear();
        _tempSharedLibraryFiles.clear();
        _mapOfAppsToProfiles.clear();
        _mapOfProfilesToPaths.clear();
        _missingBinaries.clear();
        reportTypeSpecified = false;
        cli = null;
    }

    private static SortedMap<String, Level> processLogArgs(String param) {
        return DriveScan.processLogArgs(param, false);
    }

    private static SortedMap<String, Level> processLogArgs(String param, boolean throwExceptionForInvalidArgs) {
        boolean asmPackageSpecified = false;
        Pattern asmPackagePattern = Pattern.compile("com\\.ibm\\.ws\\.report\\.binary\\.asm(\\.\\*|\\*)");
        Pattern validPackagePattern = Pattern.compile("\\*|([0-9a-zA-Z_$]+\\.?)+\\*?");
        int indexOfEquals = param.indexOf(61);
        if (indexOfEquals > 0) {
            String[] args;
            TreeMap<String, Level> mapOfLogArgs = new TreeMap<String, Level>(Collections.reverseOrder());
            String value = param.substring(indexOfEquals + 1);
            for (String arg : args = value.split(":")) {
                String[] entry = arg.split("=");
                if (entry.length == 2) {
                    String packageArg = entry[0];
                    String levelArg = entry[1];
                    if (validPackagePattern.matcher(packageArg).matches()) {
                        if (!asmPackageSpecified && asmPackagePattern.matcher(packageArg).matches()) {
                            asmPackageSpecified = true;
                        }
                        try {
                            mapOfLogArgs.put(packageArg, Level.parse(levelArg.toUpperCase()));
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            String message = Messages.getFormattedMessage(Messages.getString("DriveScan_Invalid_Log_Argument"), arg);
                            if (throwExceptionForInvalidArgs) {
                                throw new IllegalArgumentException(message);
                            }
                            System.out.println(message);
                            return null;
                        }
                    }
                    String message = Messages.getFormattedMessage(Messages.getString("DriveScan_Invalid_Debug_Package"), packageArg);
                    if (throwExceptionForInvalidArgs) {
                        throw new IllegalArgumentException(message);
                    }
                    System.out.println(message);
                    return null;
                }
                String message = Messages.getFormattedMessage(Messages.getString("DriveScan_Missing_Debug_Arg"), arg);
                if (throwExceptionForInvalidArgs) {
                    throw new IllegalArgumentException(message);
                }
                System.out.println(message);
                return null;
            }
            if (!asmPackageSpecified) {
                mapOfLogArgs.put(ASM_PACKAGE, Level.INFO);
            }
            return mapOfLogArgs;
        }
        return null;
    }

    private static String resolveLocationsForEnvVariables(String location, String wasHome) {
        String resolvedLocation = location.replace("${was.install.root}", wasHome);
        return resolvedLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties loadPropertyParams(List<String> logMessagesToPrint, String scannerPropsLocation) {
        Properties prop;
        block24: {
            BufferedReader reader;
            String propPath;
            block23: {
                prop = new Properties();
                FileInputStream inputStream = null;
                boolean failIfPropsFileNotFound = false;
                propPath = "";
                if (null != scannerPropsLocation) {
                    propPath = scannerPropsLocation.toLowerCase().endsWith(".properties") ? scannerPropsLocation : scannerPropsLocation + File.separator + "scanner.properties";
                    failIfPropsFileNotFound = true;
                } else {
                    try {
                        URL thisLocation = ClassLoader.getSystemClassLoader().getResource(".");
                        String jarDirectory = "";
                        if (null == thisLocation) {
                            logMessagesToPrint.add("System Classloader null, attempting CodeSource");
                            CodeSource codeSource = DriveScan.class.getProtectionDomain().getCodeSource();
                            URL location = codeSource.getLocation();
                            File jarFile = new File(location.getPath());
                            jarDirectory = jarFile.getParentFile().getCanonicalPath();
                        } else {
                            String pathToBinaryScanerDir = thisLocation.getPath();
                            jarDirectory = new File(pathToBinaryScanerDir).getCanonicalPath();
                        }
                        propPath = jarDirectory + File.separator + "scanner.properties";
                    }
                    catch (Exception e) {
                        prop = null;
                        logMessagesToPrint.add(Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Loading_Generic"), "scanner.properties", e.getLocalizedMessage()));
                    }
                }
                File propFile = new File(propPath);
                reader = null;
                if (!propFile.exists() && !failIfPropsFileNotFound) break block23;
                inputStream = new FileInputStream(propFile);
                reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, "UTF-8"));
                prop.load(reader);
                if (prop.isEmpty()) break block23;
                String firstKey = (String)prop.keys().nextElement();
                if (prop.size() != 1 || !"".equals(prop.get(firstKey))) break block23;
                logMessagesToPrint.add("Only a single property with no value when reading the file with a UTF-8 encoding. Trying EBCDIC.");
                reader.close();
                inputStream = new FileInputStream(propFile);
                String fileContents = ReportUtility.getFileStringEbcdic(inputStream);
                reader = new BufferedReader(new StringReader(fileContents));
                Properties ebcdicProps = new Properties();
                ebcdicProps.load(reader);
                if (!ebcdicProps.isEmpty()) {
                    firstKey = (String)ebcdicProps.keys().nextElement();
                    if (ebcdicProps.size() == 1 && "".equals(ebcdicProps.get(firstKey))) {
                        logMessagesToPrint.add("Only a single property with no value when reading the file with an EBCDIC encoding. Using the value from UTF-8.");
                    } else {
                        prop = ebcdicProps;
                    }
                    break block23;
                }
                prop = ebcdicProps;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
                break block24;
            }
            catch (IOException e) {
                logMessagesToPrint.add(String.format("The following error occured when attepmting to close", propPath, e.getLocalizedMessage()));
            }
            break block24;
            catch (Exception e) {
                try {
                    prop = null;
                    logMessagesToPrint.add(Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Loading_Generic"), propPath, e.getLocalizedMessage()));
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e2) {
                        logMessagesToPrint.add(String.format("The following error occured when attepmting to close", propPath, e2.getLocalizedMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e3) {
                    logMessagesToPrint.add(String.format("The following error occured when attepmting to close", propPath, e3.getLocalizedMessage()));
                }
            }
        }
        if (prop != null && !prop.isEmpty()) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            prop.list(writer);
            String propsList = out.toString();
            propsList = propsList.substring(propsList.indexOf("\n") + 1, propsList.lastIndexOf("\n"));
            logMessagesToPrint.add(Messages.getFormattedMessage(Messages.getString("DriveScan_Properties_Parameter_Detected"), propsList));
            writer.close();
        }
        return prop;
    }

    public static void pruneAppsDeployedToManagedLibertyServer() {
        ReportUtility.logger.get().log(Level.FINE, "Prunning apps deployed to a managed liberty server");
        Iterator<File> it = _projectFiles.iterator();
        _projectNames.clear();
        while (it.hasNext()) {
            File nextFile = it.next();
            String nextFilePath = nextFile.getAbsolutePath();
            String normalizedNextFilePath = nextFilePath.replace("\\", "/");
            ReportUtility.logger.get().log(Level.FINE, "Verifying " + nextFilePath);
            File parentDir = nextFile.getParentFile();
            String appName = nextFile.getName();
            String appNameNoExt = appName.substring(0, appName.lastIndexOf(46));
            File deployment = new File(parentDir + File.separator + "deployments" + File.separator + appNameNoExt + File.separator + "deployment.xml");
            if (!deployment.canRead()) {
                ReportUtility.logger.get().log(Level.FINE, "No deployment file could be resolved for app at: " + nextFilePath);
                it.remove();
                continue;
            }
            try {
                Document deploymentDoc = FileHelper.getParsedDocument(new FileInputStream(deployment));
                List<Node> deploymentTargetNodes = XMLRuleUtil.getTagDeclarations(deploymentDoc, nextFilePath, new String[]{normalizedNextFilePath}, "*", new String[]{"deploymentTargets"});
                if (deploymentTargetNodes.isEmpty()) continue;
                for (Node deploymentTargetNode : deploymentTargetNodes) {
                    String appServerName = XMLRuleUtil.getAttributeValue(deploymentTargetNode.getAttributes(), "*", "name");
                    ReportUtility.logger.get().log(Level.FINE, "Processing: " + deployment.getAbsolutePath());
                    HashMap<Object, Object> serverTypes = new HashMap();
                    serverTypes = DriveScan.getServerTypes(deploymentTargetNode);
                    Iterator<Object> iterator = serverTypes.keySet().iterator();
                    while (iterator.hasNext()) {
                        String e;
                        String serverName = e = (String)iterator.next();
                        String serverType = (String)serverTypes.get(e);
                        if (!serverName.equals(appServerName) || !"MANAGED_LIBERTY_SERVER".equals(serverType)) continue;
                        ReportUtility.logger.get().log(Level.FINE, "This is a managed liberty server. Prunning this app");
                        it.remove();
                        _mapOfAppsToProfiles.remove(nextFile);
                    }
                }
            }
            catch (Exception e) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Error_Generic"), "--server", e.toString()));
            }
        }
    }

    private static List<String> getClusterMembers(File ApplicationDir, String clusterName) throws Exception {
        File clusterDirPath = new File(ApplicationDir.getParentFile().getAbsolutePath().substring(0, ApplicationDir.getParentFile().getAbsolutePath().indexOf("applications")) + "/clusters/");
        File clusterFile = new File(clusterDirPath, clusterName + "/cluster.xml");
        String clusterFilePath = clusterFile.getAbsolutePath();
        ArrayList<String> membersOfCluster = new ArrayList<String>();
        Document clusterDoc = FileHelper.getParsedDocument(new FileInputStream(clusterFile));
        List<Node> clusterNodes = XMLRuleUtil.getTagDeclarations(clusterDoc, clusterFilePath, new String[]{clusterFilePath}, "*", new String[]{"members"});
        for (Node e : clusterNodes) {
            membersOfCluster.add(XMLRuleUtil.getAttributeValue(e.getAttributes(), "*", "memberName"));
        }
        return membersOfCluster;
    }

    public static void pruneAppsNotConfiguredToServer(List<String> servers) {
        ReportUtility.logger.get().log(Level.FINE, "Prunning apps external to the provided server(s): " + Arrays.toString(servers.toArray()));
        Iterator<File> it = _projectFiles.iterator();
        _projectNames.clear();
        while (it.hasNext()) {
            File nextFile = it.next();
            String nextFilePath = nextFile.getAbsolutePath();
            String normalizedNextFilePath = nextFilePath.replace("\\", "/");
            ReportUtility.logger.get().log(Level.FINE, "Verifying " + nextFilePath);
            File parentDir = nextFile.getParentFile();
            String appName = nextFile.getName();
            String appNameNoExt = appName.substring(0, appName.lastIndexOf(46));
            File deployment = new File(parentDir + File.separator + "deployments" + File.separator + appNameNoExt + File.separator + "deployment.xml");
            HashSet<File> listOfAppsToServer = new HashSet<File>();
            HashSet<File> listOfAppsToDelete = new HashSet<File>();
            List<Object> membersOfCluster = new ArrayList();
            if (!deployment.canRead()) {
                ReportUtility.logger.get().log(Level.FINE, "No deployment file could be resolved for app at: " + nextFilePath);
                it.remove();
                continue;
            }
            try {
                ReportUtility.logger.get().log(Level.FINE, "Processing: " + deployment.getAbsolutePath());
                Document doc = FileHelper.getParsedDocument(new FileInputStream(deployment));
                List<Node> nodes = XMLRuleUtil.getTagDeclarations(doc, nextFilePath, new String[]{normalizedNextFilePath}, "*", new String[]{"deploymentTargets"});
                ReportUtility.logger.get().log(Level.FINE, "Found " + nodes.size() + " deploymentTargets node(s)");
                if (nodes.isEmpty()) {
                    ReportUtility.logger.get().log(Level.FINE, "Prunning this app");
                    it.remove();
                    _mapOfAppsToProfiles.remove(nextFile);
                    continue;
                }
                for (Node node : nodes) {
                    String servername = XMLRuleUtil.getAttributeValue(node.getAttributes(), "*", "name");
                    ReportUtility.logger.get().log(Level.FINE, "App is configured to server:" + servername);
                    String type = XMLRuleUtil.getAttributeValue(node.getAttributes(), "*", "type");
                    boolean isCluster = false;
                    if (type.equals("appdeployment:ClusteredTarget")) {
                        membersOfCluster = DriveScan.getClusterMembers(parentDir, servername);
                    }
                    if (!servers.contains(servername)) {
                        if (type.equals("appdeployment:ClusteredTarget")) {
                            for (String server : servers) {
                                if (!membersOfCluster.contains(server)) continue;
                                isCluster = true;
                            }
                        }
                        if (!isCluster) {
                            listOfAppsToDelete.add(nextFile);
                            continue;
                        }
                        listOfAppsToServer.add(nextFile);
                        continue;
                    }
                    listOfAppsToServer.add(nextFile);
                }
                for (File e : listOfAppsToDelete) {
                    if (listOfAppsToServer.contains(e)) continue;
                    ReportUtility.logger.get().log(Level.FINE, "Prunning app " + e.getName());
                    it.remove();
                    _mapOfAppsToProfiles.remove(e);
                }
                for (File e : listOfAppsToServer) {
                    ReportUtility.logger.get().log(Level.FINE, "Verified " + e.getName() + " was configured to desired server");
                    _projectNames.add(ReportUtility.filterUppercaseFileExtension(DriveScan.getFileName(e)));
                }
            }
            catch (Exception e) {
                ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Error_Generic"), "--server", e.toString()));
            }
        }
    }

    private static HashMap<String, String> getServerTypes(Node deploymentTargetNode) throws Exception, Exception {
        HashMap<String, String> out = new HashMap<String, String>();
        for (File nextFile : _projectFiles) {
            String nextFilePath = nextFile.getAbsolutePath();
            String normalizedNextFilePath = nextFilePath.replace("\\", "/");
            ReportUtility.logger.get().log(Level.FINE, "Verifying " + nextFilePath);
            File parentDir = nextFile.getParentFile();
            File applicationsDir = parentDir.getParentFile();
            File cellDir = applicationsDir.getParentFile();
            String nodeName = XMLRuleUtil.getAttributeValue(deploymentTargetNode.getAttributes(), "*", "nodeName");
            File serverIndexFile = new File(cellDir + File.separator + "nodes" + File.separator + nodeName + File.separator + "serverindex.xml");
            if (!serverIndexFile.canRead()) {
                ReportUtility.logger.get().log(Level.FINE, "This serverindex.xml file does not exists:" + serverIndexFile.getAbsolutePath());
                continue;
            }
            Document serDoc = FileHelper.getParsedDocument(new FileInputStream(serverIndexFile));
            List<Node> serverEntriesNodes = XMLRuleUtil.getTagDeclarations(serDoc, nextFilePath, new String[]{normalizedNextFilePath}, "*", new String[]{"serverEntries"});
            if (serverEntriesNodes.isEmpty()) continue;
            for (Node serverEntriesNode : serverEntriesNodes) {
                String serverType = XMLRuleUtil.getAttributeValue(serverEntriesNode.getAttributes(), "*", "serverType");
                String serverName = XMLRuleUtil.getAttributeValue(serverEntriesNode.getAttributes(), "*", "serverName");
                out.put(serverName, serverType);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> findProfiles(File binaryLocation, String binaryLocationPath, List<String> profiles, List<String> profilesNotFound, boolean allProfiles, boolean stopOnMissingBinary, boolean runFromTaDc) {
        Document registryXmlDoc = null;
        Properties wasProperties = new Properties();
        FileInputStream wasPropertiesInput = null;
        File registry = new File(binaryLocationPath + File.separator + "properties" + File.separator + "profileRegistry.xml");
        BufferedReader buffReader = null;
        try {
            wasPropertiesInput = new FileInputStream(binaryLocationPath + File.separator + "properties" + File.separator + "wasprofile.properties");
            InputStreamReader isr = new InputStreamReader((InputStream)wasPropertiesInput, Charset.forName("UTF-8").newDecoder());
            buffReader = new BufferedReader(isr);
            wasProperties.load(buffReader);
            String profileRegistryPath = wasProperties.getProperty("WS_PROFILE_REGISTRY");
            if (profileRegistryPath != null) {
                String resolvedPath = DriveScan.resolveLocationsForEnvVariables(profileRegistryPath, binaryLocationPath);
                File resolvedRegistry = new File(resolvedPath);
                if (resolvedRegistry.canRead()) {
                    registry = resolvedRegistry;
                } else {
                    ReportUtility.logger.get().log(Level.FINE, "Could not resolve the registryProfile file path listed in wasprofiles.properties, trying default location instead. Resolved path: " + resolvedPath);
                }
            }
            if (!registry.canRead()) {
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getString("DriveScan_Profile_Unresolved"));
            }
            registryXmlDoc = FileHelper.getParsedDocument(new FileInputStream(registry));
            NodeList nodeList = registryXmlDoc.getElementsByTagName("profile");
            if (allProfiles) {
                profiles = new ArrayList<String>();
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node currentNode = nodeList.item(i);
                String profileName = currentNode.getAttributes().getNamedItem("name").getNodeValue();
                String profilePath = currentNode.getAttributes().getNamedItem("path").getNodeValue();
                boolean isDefault = Boolean.parseBoolean(currentNode.getAttributes().getNamedItem("isDefault").getNodeValue());
                profilePath = profilePath.replace("\\", "/");
                String originalProfilePath = profilePath.replace("/", "\\");
                _mapOfProfilesToPaths.put(profileName, profilePath);
                String cellPath = "/config/cells";
                if (london && profiles != null && (profiles.contains(profilePath) || profiles.contains(originalProfilePath) || profiles.contains(profilePath + "/") || profiles.contains(originalProfilePath + "\\"))) {
                    if (profiles.contains(profilePath)) {
                        profiles.remove(profilePath);
                        profilesNotFound.remove(profilePath);
                    } else if (profiles.contains(originalProfilePath)) {
                        profiles.remove(originalProfilePath);
                        profilesNotFound.remove(originalProfilePath);
                    } else if (profiles.contains(profilePath + "/")) {
                        profiles.remove(profilePath + "/");
                        profilesNotFound.remove(profilePath + "/");
                    } else if (profiles.contains(originalProfilePath + "\\")) {
                        profiles.remove(originalProfilePath + "\\");
                        profilesNotFound.remove(originalProfilePath + "\\");
                    }
                    profiles.add(profileName);
                    DriveScan.addAllBinaryFilesForDirectory(new File(profilePath + cellPath), null, null, profileName, _mapOfAppsToProfiles, true, stopOnMissingBinary, runFromTaDc);
                    continue;
                }
                if (allProfiles) {
                    boolean addProfile;
                    block37: {
                        addProfile = true;
                        try {
                            File profileFile = DriveScan.getRealFile(new File(profilePath + File.separator + "bin"));
                            File setupCmdLineBat = new File(profileFile + File.separator + "setupCmdLine.bat");
                            File setupCmdLineSh = new File(profileFile + File.separator + "setupCmdLine.sh");
                            String owningNode = null;
                            String owningCell = null;
                            if (setupCmdLineBat.exists()) {
                                owningNode = DriveScan.getOwningNode(setupCmdLineBat);
                                owningCell = DriveScan.getOwningCell(setupCmdLineBat);
                            } else if (setupCmdLineSh.exists()) {
                                owningNode = DriveScan.getOwningNode(setupCmdLineSh);
                                owningCell = DriveScan.getOwningCell(setupCmdLineSh);
                            } else {
                                ReportUtility.logger.get().log(Level.FINE, "Could not find setupCmdLine.bat|sh for profile " + profileName + ". Data will be collected from this profile.");
                            }
                            if (owningNode != null && owningCell != null) {
                                Node serverEntry;
                                String serverType;
                                File serverIndexFile = DriveScan.getRealFile(new File(profilePath + cellPath + File.separator + owningCell + File.separator + "nodes" + File.separator + owningNode + File.separator + "serverindex.xml"));
                                if (!serverIndexFile.exists()) break block37;
                                Document cellXmlDoc = FileHelper.getParsedDocument(new FileInputStream(serverIndexFile));
                                NodeList serverEntries = cellXmlDoc.getElementsByTagName("serverEntries");
                                for (int j = 0; j < serverEntries.getLength() && !"DEPLOYMENT_MANAGER".equals(serverType = (serverEntry = serverEntries.item(j)).getAttributes().getNamedItem("serverType").getNodeValue()); ++j) {
                                    if (!"NODE_AGENT".equals(serverType)) continue;
                                    addProfile = false;
                                    break block37;
                                }
                                break block37;
                            }
                            ReportUtility.logger.get().log(Level.FINE, "Unable to load owning node for profile " + profileName + ". Data will be collected from this profile.");
                        }
                        catch (Exception ex) {
                            ReportUtility.logger.get().log(Level.FINE, "Caught exception trying to determine if this this profile is federated. Profile will be added. Exception: ", ex);
                        }
                    }
                    if (addProfile) {
                        profiles.add(profileName);
                        DriveScan.addAllBinaryFilesForDirectory(new File(profilePath + cellPath), null, null, profileName, _mapOfAppsToProfiles, true, stopOnMissingBinary, runFromTaDc);
                        continue;
                    }
                    ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScan_Profile_Not_Scanned"), profileName));
                    continue;
                }
                if (profiles == null && isDefault) {
                    profiles = new ArrayList<String>(Arrays.asList(profileName));
                    DriveScan.addAllBinaryFilesForDirectory(new File(profilePath + cellPath), null, null, profileName, _mapOfAppsToProfiles, true, stopOnMissingBinary, runFromTaDc);
                    break;
                }
                if (profiles == null || !profiles.contains(profileName)) continue;
                profilesNotFound.remove(profileName);
                DriveScan.addAllBinaryFilesForDirectory(new File(profilePath + cellPath), null, null, profileName, _mapOfAppsToProfiles, true, stopOnMissingBinary, runFromTaDc);
            }
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.FINE, "A WAS home directory could not be found.", e);
        }
        finally {
            block39: {
                if (buffReader != null) {
                    try {
                        buffReader.close();
                    }
                    catch (IOException e) {
                        if (!ReportUtility.isDebug()) break block39;
                        ReportUtility.logger.get().log(Level.FINEST, "wasprofile.properties not closed", e);
                    }
                }
            }
        }
        return profiles;
    }

    private static String getOwningNode(File file) {
        return DriveScan.getOwning("WAS_NODE=", file);
    }

    private static String getOwningCell(File file) {
        return DriveScan.getOwning("WAS_CELL=", file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getOwning(String prefix, File file) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = "";
            while (null != (line = reader.readLine())) {
                if (!line.contains(prefix)) continue;
                String string = line.substring(line.indexOf("=") + 1);
                return string;
            }
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.FINE, "Caught exception trying to read file " + file.getName(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     */
    protected static ReportInputData processParameters(String[] args) {
        String loggingStr;
        Iterator lvl;
        ReportInputData data = null;
        boolean validParms = true;
        boolean helpRequested = false;
        boolean hiddenOptionsRequested = false;
        boolean versionRequested = false;
        boolean optionsRequested = false;
        boolean userRulesOnlyRequested = false;
        boolean analyzeJavaSE = false;
        String includePackages = null;
        String excludePackages = null;
        String excludeRules = null;
        HashSet<String> excludedRulesSet = null;
        Pattern excludeFilesPattern = null;
        boolean isConsolidatedScan = false;
        ReportInputData.ReportType reportType = null;
        EnumSet<ReportInputData.ReportType> reportTypes = EnumSet.noneOf(ReportInputData.ReportType.class);
        boolean coreEdition = false;
        boolean baseEdition = false;
        boolean ndEdition = false;
        boolean zosEdition = false;
        boolean libertyProfile = false;
        boolean fullProfile = false;
        ReportInputData.AppServer sourceAppServer = null;
        String originalSourceAppServerOption = null;
        ReportInputData.AppServer targetAppServer = null;
        Enum targetCloud = null;
        Enum derivedTargetCloud = null;
        String originalTargetAppServerOption = null;
        ReportInputData.JavaVersion sourceJava = null;
        ReportInputData.JavaVersion targetJava = null;
        ReportInputData.JavaEEVersion sourceJavaEE = null;
        ReportInputData.JavaEEVersion targetJavaEE = null;
        boolean targetJakartaEEUsed = false;
        boolean sourceJakartaEEUsed = false;
        EnumSet<ReportInputData.OutputType> reportOutputTypes = EnumSet.noneOf(ReportInputData.OutputType.class);
        boolean isJava6 = false;
        boolean isIBMJava6 = false;
        String targetJavaUserInputValue = null;
        boolean display = false;
        boolean inputIsDirectory = false;
        boolean configDetected = false;
        boolean configSuccess = true;
        boolean isCurrentDir = false;
        File outputDir = null;
        String outputDirPath = null;
        EnumMap<ReportInputData.OutputType, File> outputFiles = new EnumMap<ReportInputData.OutputType, File>(ReportInputData.OutputType.class);
        File userRuleLocationDir = null;
        String userRuleLocationPath = null;
        int maxUserDefinedRuleResults = -1;
        String scannerPropsLocations = null;
        HashMap<File, File> appToConfigDir = new HashMap<File, File>();
        HashSet<String> binaryLocationPaths = new HashSet<String>();
        HashSet<File> binaryLocations = new HashSet<File>();
        String configLocationPath = null;
        File configLocation = null;
        boolean includeSensitiveData = false;
        int positionalArg = 0;
        boolean optionsFound = false;
        boolean multipleBinaryFilesSpecified = false;
        boolean inputIsDirWithOneArchive = false;
        HashSet<String> binaryPathNames = new HashSet<String>();
        boolean migrateAllConfig = false;
        boolean scanAll = false;
        boolean containsEbaOrCba = false;
        boolean nobrowser = false;
        boolean includeHelpLocation = false;
        boolean stopOnMissingBinary = false;
        boolean stopOnMissingSharedLibrary = false;
        boolean detectSharedLibraries = false;
        boolean loadAllRules = false;
        boolean showAllHelp = false;
        boolean skipConfig = false;
        boolean usedDeprecatedFeatureList = false;
        boolean debug = false;
        boolean verbose = false;
        boolean generateAllSeparateReports = false;
        boolean generateTa = false;
        boolean clean = false;
        boolean allProfiles = false;
        boolean noProgressIndicator = false;
        boolean saveTAScanStatusToJson = false;
        boolean runFromTaDc = false;
        ArrayList<String> includeApplications = null;
        ArrayList<String> excludeApplications = null;
        SortedMap<String, Level> mapOfLogArgs = null;
        ArrayList<String> logMessagesToPrint = new ArrayList<String>();
        List<String> profiles = null;
        ArrayList<String> servers = null;
        ArrayList<String> profilesNotFound = null;
        ArrayList<String> listOfArgs = new ArrayList<String>(Arrays.asList(args));
        HashMap<String, String> argsMap = new HashMap<String, String>();
        for (Object arg : listOfArgs) {
            String key = ((String)arg).split("=")[0];
            String value = ((String)arg).replace(key + "=", "");
            if (key.equals("--scannerPropertiesLocation")) {
                scannerPropsLocations = value;
                if (!scannerPropsLocations.startsWith("\"") || !scannerPropsLocations.endsWith("\"")) continue;
                scannerPropsLocations = scannerPropsLocations.substring(1, scannerPropsLocations.length() - 1);
                continue;
            }
            if (value.isEmpty()) {
                value = "true";
            }
            argsMap.put(key, value);
        }
        Properties propertyParams = DriveScan.loadPropertyParams(logMessagesToPrint, scannerPropsLocations);
        if (propertyParams == null) {
            validParms = false;
        } else {
            for (Map.Entry entry : propertyParams.entrySet()) {
                String arg;
                String key = "--" + entry.getKey();
                String value = (String)entry.getValue();
                if ("true".equals(value) || "false".equals(value)) {
                    arg = key;
                    if (argsMap.containsKey(arg) || !"true".equals(value)) continue;
                    listOfArgs.add(arg);
                    continue;
                }
                arg = key + "=" + value;
                String argsMapValue = (String)argsMap.get(key);
                if (argsMapValue != null) {
                    if (argsMapValue.equals(value)) continue;
                    logMessagesToPrint.add(Messages.getFormattedMessage(Messages.getString("DriveScan_Duplicate_Parameter"), key, argsMapValue, value));
                    continue;
                }
                listOfArgs.add(arg);
            }
        }
        Iterator itr = listOfArgs.iterator();
        while (itr.hasNext()) {
            String param = (String)itr.next();
            if (param.equals("--hiddenJunitFlag")) {
                _hiddenJunitFlag = true;
                itr.remove();
                if (args.length != 1) continue;
                helpRequested = true;
                continue;
            }
            if (param.equals("--showAllHelp")) {
                showAllHelp = true;
                itr.remove();
                continue;
            }
            if (param.equals("--includeHelpLocation")) {
                includeHelpLocation = true;
                itr.remove();
                continue;
            }
            if (param.equals("--loadAllRules")) {
                loadAllRules = true;
                itr.remove();
                continue;
            }
            if (param.equals("--skipConfig")) {
                skipConfig = true;
                itr.remove();
                continue;
            }
            if (param.equals("--stopOnMissingBinary")) {
                stopOnMissingBinary = true;
                itr.remove();
                continue;
            }
            if (param.equals("--stopOnMissingSharedLibrary")) {
                stopOnMissingSharedLibrary = true;
                itr.remove();
                continue;
            }
            if (param.equals("--detectSharedLibraries")) {
                detectSharedLibraries = true;
                itr.remove();
                continue;
            }
            if (param.equals("help") || param.equals("-help") || param.equals("--help") || param.equals("?")) {
                if (helpRequested) continue;
                helpRequested = true;
                itr.remove();
                continue;
            }
            if (param.equals("--options") || param.equals("options")) {
                optionsRequested = true;
                itr.remove();
                continue;
            }
            if (param.equals("--internal")) {
                hiddenOptionsRequested = true;
                itr.remove();
                continue;
            }
            if (param.startsWith("--debug")) {
                debug = true;
                mapOfLogArgs = DriveScan.processLogArgs(param);
                itr.remove();
                continue;
            }
            if (param.startsWith("--verbose")) {
                verbose = true;
                itr.remove();
                continue;
            }
            if (param.equals("--ta")) {
                generateTa = true;
                reportOutputTypes.add(ReportInputData.OutputType.HTML);
                reportOutputTypes.add(ReportInputData.OutputType.JSON);
                includeHelpLocation = true;
                maxUserDefinedRuleResults = 100;
                detectSharedLibraries = true;
                targetCloud = ReportInputData.TargetCloud.CONTAINERS;
                continue;
            }
            if (param.startsWith("--profile=")) {
                if (generateTa) {
                    profiles = new ArrayList<String>(Arrays.asList(param.substring(param.indexOf(61) + 1).split(",")));
                    profilesNotFound = new ArrayList<String>(profiles);
                } else if (london) {
                    profiles = new ArrayList<String>(Arrays.asList(param.substring(param.indexOf(61) + 1)));
                    profilesNotFound = new ArrayList<String>(profiles);
                } else {
                    System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Unknown_Option"), param));
                    validParms = false;
                }
                itr.remove();
                continue;
            }
            if (param.startsWith("--server=")) {
                if (london) {
                    servers = new ArrayList<String>(Arrays.asList(param.substring(param.indexOf(61) + 1).split(",")));
                    ReportUtility.setListOfServers(servers);
                } else {
                    System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Unknown_Option"), param));
                    validParms = false;
                }
                itr.remove();
                continue;
            }
            if (param.startsWith("--all-profiles")) {
                if (generateTa) {
                    allProfiles = true;
                } else {
                    System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Unknown_Option"), param));
                    validParms = false;
                }
                itr.remove();
                continue;
            }
            if (param.equals("--noProgressIndicator")) {
                if (generateTa) {
                    noProgressIndicator = true;
                } else {
                    System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Required"), param));
                    validParms = false;
                }
                itr.remove();
                continue;
            }
            if (param.equals("--ta-dc")) {
                if (generateTa) {
                    runFromTaDc = true;
                } else {
                    System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Required"), param));
                    validParms = false;
                }
                itr.remove();
                continue;
            }
            if (param.startsWith("--output")) {
                if (param.startsWith("--output=")) {
                    outputDirPath = param.substring(param.indexOf(61) + 1);
                    if (outputDirPath.startsWith("\"") && outputDirPath.endsWith("\"")) {
                        outputDirPath = outputDirPath.substring(1, outputDirPath.length() - 1);
                    }
                    if (outputDirPath.startsWith("~") || outputDirPath.startsWith(File.separator + "~")) {
                        outputDirPath = outputDirPath.replaceFirst("~", System.getProperty("user.home"));
                    }
                    try {
                        outputDir = new File(outputDirPath).getCanonicalFile();
                        outputDirPath = outputDir.getAbsolutePath();
                    }
                    catch (IOException e) {
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_Output_Directory_Resolve_Failed"));
                    }
                    catch (SecurityException e2) {
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_Output_Directory_Security_Fail"));
                    }
                    if (validParms && !outputDir.exists() && outputDirPath.matches("(?:^\\..*)|(?:.*\\/\\.[^\\/]+.*)")) {
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_Output_Directory_Dot_Failed"));
                    }
                } else {
                    isCurrentDir = true;
                    outputDir = new File(".");
                }
                _outputDir = outputDir;
                itr.remove();
                continue;
            }
            if (!param.equals("--delete")) continue;
            if (generateTa) {
                _delete = true;
            } else {
                validParms = false;
                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Required"), param));
            }
            itr.remove();
        }
        if (profiles != null && allProfiles) {
            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Mutually_Exclusive_Parms"), "--profile", "--all-profiles"));
            validParms = false;
        }
        if (debug && verbose) {
            System.out.println("WARN: " + Messages.getString("DriveScan_Verbose_Ignore"));
        } else if (verbose) {
            debug = true;
            System.out.println("WARN: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_DeprecatedOption"), "--verbose", "--debug"));
            mapOfLogArgs = DriveScan.processLogArgs("--debug=*=all");
        }
        if (generateTa && !debug && !noProgressIndicator) {
            debug = true;
            mapOfLogArgs = DriveScan.processLogArgs("--debug=*=info");
        }
        ReportUtility.initiateLogger(debug, false, mapOfLogArgs);
        ReportUtility.setTaMode(generateTa);
        ReportUtility.setNoProgressIndicator(noProgressIndicator);
        ReportUtility.setBuildVariables();
        ReportUtility.logger.get().log(Level.FINE, "Operating System: " + ReportUtility.OS);
        ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScan_product_name"), "WebSphere Application Server Migration Toolkit for Application Binaries"));
        ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScan_product_version"), "25.0.0.2"));
        ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScan_build_agent"), Constants.buildAgent));
        ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScan_build_id"), Constants.buildID));
        ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScan_latest_commit"), Constants.latestCommit));
        if (mapOfLogArgs != null && mapOfLogArgs.containsKey(ASM_PACKAGE) && (lvl = (Level)mapOfLogArgs.get(ASM_PACKAGE)) == Level.INFO) {
            ReportUtility.logger.get().log(Level.FINE, Messages.getString("DriveScan_ASM_EXCLUDED"));
        }
        for (String message : logMessagesToPrint) {
            Level level = message.matches("CWMIG\\d+E:[\\s\\S]*") ? Level.SEVERE : (message.matches("CWMIG\\d+W:[\\s\\S]*") ? Level.WARNING : (message.matches("CWMIG\\d+I:[\\s\\S]*") ? Level.INFO : Level.FINE));
            ReportUtility.logger.get().log(level, message);
        }
        if (generateTa) {
            DriveScan.removeTAScanResults();
        }
        if (!helpRequested && !optionsRequested) {
            for (String thisArg : listOfArgs) {
                ++positionalArg;
                if (generateTa && !DriveScan.isValidTAOption(thisArg, profiles)) {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Option_Not_Supported_With_Action"), thisArg, "--ta"));
                    continue;
                }
                if (!helpRequested && (showAllHelp && !thisArg.startsWith("--") || !showAllHelp && (positionalArg == 1 || !optionsFound && !thisArg.startsWith("--")))) {
                    File binaryLocation;
                    String path;
                    String binaryLocationPath;
                    if (thisArg.equals("--version") || thisArg.equals("version")) {
                        versionRequested = true;
                        break;
                    }
                    if (thisArg.startsWith("--")) {
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_First"));
                        break;
                    }
                    if (positionalArg > 1) {
                        multipleBinaryFilesSpecified = true;
                        if (generateTa) {
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getString("DriveScan_TA_Multiple_Inputs"));
                        }
                    }
                    if ((binaryLocationPath = thisArg).startsWith("\"") && binaryLocationPath.endsWith("\"")) {
                        binaryLocationPath = binaryLocationPath.substring(1, binaryLocationPath.length() - 1);
                    }
                    if (binaryLocationPath.startsWith("~") || binaryLocationPath.startsWith(File.separator + "~")) {
                        binaryLocationPath = binaryLocationPath.replaceFirst("~", System.getProperty("user.home"));
                    }
                    if (!binaryLocationPath.startsWith(path = DriveScan.getFileName(binaryLocation = new File(binaryLocationPath)))) {
                        binaryLocationPath = path;
                        binaryLocation = new File(binaryLocationPath);
                    }
                    binaryLocationPaths.add(binaryLocationPath);
                    binaryLocations.add(binaryLocation);
                    inputIsDirectory = binaryLocation.isDirectory();
                    if (inputIsDirectory) {
                        if (generateTa || london) {
                            profiles = DriveScan.findProfiles(binaryLocation, binaryLocationPath, profiles, profilesNotFound, allProfiles, stopOnMissingBinary, runFromTaDc);
                        }
                        if (london) {
                            if (profiles == null || profiles.isEmpty()) {
                                validParms = false;
                                System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_No_Files"));
                            } else if (servers != null && !servers.isEmpty()) {
                                DriveScan.pruneAppsNotConfiguredToServer(servers);
                                new RequestedServers(servers);
                            }
                        } else if (profiles == null || profiles.isEmpty()) {
                            if (generateTa || london) {
                                DriveScan.addAllBinaryFilesForDirectory(new File(path), false);
                            } else {
                                DriveScan.addAllBinaryFilesForDirectory(new File(path), true);
                            }
                            if (_projectFiles.isEmpty()) {
                                validParms = false;
                                System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_No_Files"));
                            } else if (!binaryPathNames.contains(path)) {
                                binaryPathNames.add(path);
                                String footerMessage = _projectFiles.size() > 1 ? Messages.getString("DriveScan_Report_Footer_Directory_Plural") : Messages.getString("DriveScan_Report_Footer_Directory");
                                _projectNames.add(Messages.getFormattedMessage(footerMessage, path, _projectFiles.size()));
                                String pathNormalized = path.replace("\\", "/");
                                int index = pathNormalized.lastIndexOf(47);
                                if (index > -1) {
                                    String fileName = path.substring(index + 1, path.length());
                                    _preFileName = fileName + _preFileName;
                                }
                            }
                        } else {
                            DriveScan.pruneAppsDeployedToManagedLibertyServer();
                        }
                    } else if (binaryLocation.isFile()) {
                        String pathFiltered = ReportUtility.filterUppercaseFileExtension(path);
                        if (!_projectNames.contains(pathFiltered)) {
                            String binaryLocationPathLowerCase = binaryLocationPath.toLowerCase();
                            if (binaryLocationPath.endsWith("MANIFEST.MF") || binaryLocationPath.endsWith("COMPOSITEBUNDLE.MF") || com.ibm.ws.report.binary.utilities.Constants.FILE_EXTENSION_REGEX.matcher(binaryLocationPathLowerCase).matches()) {
                                String pathNormalized = path.replace("\\", "/");
                                int index = pathNormalized.lastIndexOf(47);
                                if (index > -1) {
                                    String dirPath = path.substring(0, index);
                                    String fileName = path.substring(index + 1);
                                    binaryPathNames.add(dirPath);
                                    _preFileName = fileName + _preFileName;
                                }
                                _projectNames.add(pathFiltered);
                                _projectFiles.add(binaryLocation);
                                ReportUtility.logger.get().log(Level.FINEST, "Added binary file: " + binaryLocation.getAbsolutePath());
                            }
                        }
                    } else {
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_BinaryInputPath_Not_Valid_File"), binaryLocation.getAbsolutePath()));
                    }
                    if (profilesNotFound != null && !profilesNotFound.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        int size = profilesNotFound.size();
                        for (int i = 0; i < size; ++i) {
                            sb.append((String)profilesNotFound.get(i));
                            if (i + 1 == size) continue;
                            sb.append(", ");
                        }
                        validParms = false;
                        String profileNotFoundMessage = profiles.size() > 1 ? Messages.getString("DriveScan_Profile_Not_Found_Plural") : Messages.getString("DriveScan_Profile_Not_Found");
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(profileNotFoundMessage, sb));
                    }
                    containsEbaOrCba = DriveScan.containsEbaOrCba();
                    continue;
                }
                if (!optionsFound) {
                    optionsFound = true;
                    if (thisArg.equals("--version")) {
                        versionRequested = true;
                        break;
                    }
                    if (thisArg.equals("--evaluateApplication") || thisArg.equals("--evaluate")) {
                        reportTypeSpecified = true;
                        reportType = ReportInputData.ReportType.EVALUATE;
                        reportTypes.add(ReportInputData.ReportType.EVALUATE);
                        if (!thisArg.equals("--evaluateApplication")) continue;
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_DeprecatedAction"), thisArg, "--evaluate"));
                        continue;
                    }
                    if (thisArg.equals("--analyzeMigrationDetails")) {
                        reportTypeSpecified = true;
                        DriveScan.pruneBinariesExceptArchives();
                        if (_projectFiles.isEmpty() && !showAllHelp) {
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_No_Files"));
                        }
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_DeprecatedAction"), thisArg, "--analyze"));
                        reportType = ReportInputData.ReportType.ANALYZE;
                        reportTypes.add(ReportInputData.ReportType.ANALYZE);
                        continue;
                    }
                    if (thisArg.equals("--analyze") || thisArg.equalsIgnoreCase("--analyzeJavaSE")) {
                        reportTypeSpecified = true;
                        DriveScan.pruneBinariesExceptArchives();
                        if (_projectFiles.isEmpty() && !showAllHelp) {
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_No_Files"));
                        }
                        reportType = ReportInputData.ReportType.ANALYZE;
                        reportTypes.add(ReportInputData.ReportType.ANALYZE);
                        if (!thisArg.equalsIgnoreCase("--analyzeJavaSE")) continue;
                        analyzeJavaSE = true;
                        continue;
                    }
                    if (thisArg.equals("--generateConfig") || thisArg.equals("--featureList")) {
                        reportTypeSpecified = true;
                        reportType = ReportInputData.ReportType.GENERATE_CONFIG;
                        reportTypes.add(ReportInputData.ReportType.GENERATE_CONFIG);
                        reportOutputTypes.add(ReportInputData.OutputType.XML);
                        if (thisArg.equals("--featureList")) {
                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_DeprecatedAction"), thisArg, "--generateConfig"));
                            skipConfig = true;
                            usedDeprecatedFeatureList = true;
                        }
                        if (!validParms) continue;
                        DriveScan.pruneBinariesExceptEARsandWARs();
                        if (!_projectFiles.isEmpty()) continue;
                        if (london) {
                            File dummyEar = ReportUtility.generateDummyEar();
                            _projectFiles.add(dummyEar);
                            _projectNames.add(DriveScan.getFileName(dummyEar));
                            continue;
                        }
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_No_EARorWAR_Files"));
                        continue;
                    }
                    if (thisArg.equals("--inventory")) {
                        reportTypeSpecified = true;
                        reportType = ReportInputData.ReportType.INVENTORY;
                        reportTypes.add(ReportInputData.ReportType.INVENTORY);
                        if (!validParms) continue;
                        DriveScan.pruneBinariesExceptEARsandWARs();
                        if (!_projectFiles.isEmpty()) continue;
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_No_EARorWAR_Files"));
                        continue;
                    }
                    if (reportTypes.isEmpty()) {
                        isConsolidatedScan = true;
                        if (generateTa) {
                            DriveScan.pruneBinariesExceptEARsWARsJARs();
                        } else {
                            DriveScan.pruneBinariesExceptEARsandWARs();
                        }
                        if (_projectFiles.isEmpty()) {
                            validParms = false;
                            if (generateTa) {
                                System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_No_EARorWARorJAR_Files"));
                            } else {
                                System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_No_EARorWAR_Files"));
                            }
                        }
                        reportTypes.add(ReportInputData.ReportType.ANALYZE);
                        reportTypes.add(ReportInputData.ReportType.EVALUATE);
                        reportTypes.add(ReportInputData.ReportType.INVENTORY);
                        reportTypes.add(ReportInputData.ReportType.GENERATE_CONFIG);
                        if (thisArg.equals("--all-separate-reports")) {
                            generateAllSeparateReports = true;
                            if (validParms && outputDir != null && outputDir.getAbsolutePath().matches(VALID_OUTPUT_FILE_EXTENSION)) {
                                validParms = false;
                                System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_Output_Directory_File_Name_All_Separate_Reports_Error"));
                            }
                        }
                        if (thisArg.equals("--all") || thisArg.equals("--all-separate-reports") || thisArg.equals("--ta")) continue;
                    }
                }
                if (thisArg.startsWith("--")) {
                    ArrayList<String> processedFiles;
                    if (thisArg.equals("--scanAllJars")) continue;
                    if (thisArg.equals("--scanAll")) {
                        scanAll = true;
                        continue;
                    }
                    if (thisArg.equals("--migrateAllConfig")) {
                        migrateAllConfig = true;
                        continue;
                    }
                    if (thisArg.equals("--nobrowser")) {
                        nobrowser = true;
                        continue;
                    }
                    if (reportTypeSpecified && reportType == ReportInputData.ReportType.GENERATE_CONFIG && (thisArg.startsWith("--format") || thisArg.equals("--html"))) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Option_Not_Supported_With_Action"), "--format", reportType.toString()));
                        continue;
                    }
                    if (thisArg.startsWith("--configLocation=")) {
                        configLocationPath = thisArg.substring(thisArg.indexOf(61) + 1);
                        if (configLocationPath.startsWith("\"") && configLocationPath.endsWith("\"")) {
                            configLocationPath = configLocationPath.substring(1, configLocationPath.length() - 1);
                        }
                        if (configLocationPath.startsWith("~") || configLocationPath.startsWith(File.separator + "~")) {
                            configLocationPath = configLocationPath.replaceFirst("~", System.getProperty("user.home"));
                        }
                        if ((configLocation = new File(configLocationPath)).isDirectory()) continue;
                        configLocation = null;
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Config_Location_Not_Valid"), configLocationPath));
                        continue;
                    }
                    if (thisArg.equals("--includeSensitiveData")) {
                        includeSensitiveData = true;
                        continue;
                    }
                    if (thisArg.equals("--html")) {
                        if (reportOutputTypes.isEmpty()) {
                            reportOutputTypes.add(ReportInputData.OutputType.HTML);
                            continue;
                        }
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_Format_Not_Valid"));
                        continue;
                    }
                    if (thisArg.startsWith("--format=")) {
                        String[] formats = thisArg.split("=")[1].split(",");
                        if (!reportOutputTypes.isEmpty()) continue;
                        for (String format : formats) {
                            if (format.equals("html")) {
                                reportOutputTypes.add(ReportInputData.OutputType.HTML);
                                continue;
                            }
                            if (format.equals("txt")) {
                                reportOutputTypes.add(ReportInputData.OutputType.TEXT);
                                continue;
                            }
                            if (format.equals("oldHtml")) {
                                _isOldHtml = true;
                                reportOutputTypes.add(ReportInputData.OutputType.HTML);
                                continue;
                            }
                            if (format.equals("json")) {
                                reportOutputTypes.add(ReportInputData.OutputType.JSON);
                                continue;
                            }
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Unknown_Option"), thisArg));
                        }
                        continue;
                    }
                    if (thisArg.startsWith("--excludeFiles=")) {
                        if (thisArg.length() > "--excludeFiles=".length()) {
                            try {
                                excludeFilesPattern = Pattern.compile(thisArg.split("=")[1]);
                            }
                            catch (PatternSyntaxException ex) {
                                validParms = false;
                                if (ReportUtility.isDebug()) {
                                    System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Regex_Cannot_Compile_Log"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61)), ex.toString()));
                                    continue;
                                }
                                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Regex_Cannot_Compile"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61)), ex.getMessage()));
                            }
                            continue;
                        }
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61))));
                        continue;
                    }
                    if (thisArg.startsWith("--includePackages=")) {
                        if (thisArg.length() > "--includePackages=".length() && ReportUtility.validPackages(thisArg.substring(thisArg.indexOf(61) + 1))) {
                            includePackages = thisArg;
                            continue;
                        }
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61))));
                        continue;
                    }
                    if (thisArg.startsWith("--excludePackages=")) {
                        if (thisArg.length() > "--excludePackages=".length() && ReportUtility.validPackages(thisArg.substring(thisArg.indexOf(61) + 1))) {
                            excludePackages = thisArg;
                            continue;
                        }
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61))));
                        continue;
                    }
                    if (thisArg.startsWith("--excludeRules=")) {
                        if (thisArg.length() > "--excludeRules=".length() && DriveScan.validRuleIds(thisArg.substring(thisArg.indexOf(61) + 1))) {
                            String[] valuesArray;
                            excludeRules = thisArg;
                            excludeRules = thisArg.split("=")[1];
                            excludedRulesSet = new HashSet<String>();
                            for (String value : valuesArray = excludeRules.split(",")) {
                                excludedRulesSet.add(value);
                            }
                            continue;
                        }
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61))));
                        continue;
                    }
                    if (thisArg.equals("--clean")) {
                        if (generateTa) {
                            clean = true;
                            continue;
                        }
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Required"), thisArg));
                        continue;
                    }
                    if (thisArg.equals("--saveTAScanStatusToJson")) {
                        if (generateTa) {
                            saveTAScanStatusToJson = true;
                            continue;
                        }
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Required"), thisArg));
                        continue;
                    }
                    if (thisArg.startsWith("--includeApplications=")) {
                        if (generateTa) {
                            if (includeApplications == null && excludeApplications == null) {
                                includeApplications = new ArrayList<String>(Arrays.asList(thisArg.substring(thisArg.indexOf(61) + 1).split(",")));
                                continue;
                            }
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Include_Exclude_Apps"), new Object[0]));
                            continue;
                        }
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Required"), thisArg.substring(0, thisArg.indexOf(61))));
                        continue;
                    }
                    if (thisArg.startsWith("--includeApplicationsFile=")) {
                        processedFiles = new ArrayList<String>();
                        validParms = DriveScan.processApplicationsFile(generateTa, includeApplications, excludeApplications, processedFiles, thisArg);
                        if (processedFiles.isEmpty()) continue;
                        includeApplications = processedFiles;
                        continue;
                    }
                    if (thisArg.startsWith("--excludeApplications=")) {
                        if (generateTa) {
                            if (includeApplications == null && excludeApplications == null) {
                                excludeApplications = new ArrayList<String>(Arrays.asList(thisArg.substring(thisArg.indexOf(61) + 1).split(",")));
                                continue;
                            }
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Include_Exclude_Apps"), new Object[0]));
                            continue;
                        }
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Required"), thisArg.substring(0, thisArg.indexOf(61))));
                        continue;
                    }
                    if (thisArg.startsWith("--excludeApplicationsFile=")) {
                        processedFiles = new ArrayList();
                        validParms = DriveScan.processApplicationsFile(generateTa, includeApplications, excludeApplications, processedFiles, thisArg);
                        if (processedFiles.isEmpty()) continue;
                        excludeApplications = processedFiles;
                        continue;
                    }
                    if (thisArg.equals("--help")) {
                        helpRequested = true;
                        break;
                    }
                    if (thisArg.startsWith("--scannerPropertiesLocation")) continue;
                    if ((reportTypes.contains((Object)ReportInputData.ReportType.INVENTORY) || reportTypes.contains((Object)ReportInputData.ReportType.GENERATE_CONFIG)) && thisArg.startsWith("--sharedLibraries=")) {
                        if (_projectFiles.size() == 1) {
                            for (ArrayList<String> path : thisArg.replaceFirst(".*=", "").split(",")) {
                                File sharedLibLocation;
                                if (((String)((Object)path)).startsWith("~") || ((String)((Object)path)).startsWith(File.separator + "~")) {
                                    path = ((String)((Object)path)).replaceFirst("~", System.getProperty("user.home"));
                                }
                                if ((sharedLibLocation = new File((String)((Object)path))).isDirectory()) {
                                    DriveScan.addAllSharedBinaryFilesForDirectory(sharedLibLocation, true);
                                    continue;
                                }
                                if (sharedLibLocation.isFile()) {
                                    if (!((String)((Object)path)).endsWith(".jar")) continue;
                                    String sharedLibProjectName = DriveScan.addRealFileToCollectionAndReturnRealPath(sharedLibLocation, _sharedLibraryFiles);
                                    _applicationNames.add(sharedLibProjectName);
                                    continue;
                                }
                                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_File_Does_Not_Exist"), sharedLibLocation.getAbsolutePath()));
                            }
                            if (!_sharedLibraryFiles.isEmpty()) continue;
                            ReportUtility.logger.get().log(Level.WARNING, Messages.getString("DriveScan_Parm_SharedLibPath_No_Files"));
                            continue;
                        }
                        validParms = false;
                        if (_projectFiles.size() > 1) {
                            System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_Not_Valid_For_Shared_Libraries"));
                            continue;
                        }
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Unknown_Option"), thisArg));
                        continue;
                    }
                    if (reportType == ReportInputData.ReportType.EVALUATE || reportTypes.contains((Object)ReportInputData.ReportType.EVALUATE)) {
                        if (thisArg.equals("--bluemixEdition")) {
                            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Removed"), thisArg));
                            continue;
                        }
                        if (thisArg.equals("--libertyBuildpackEdition")) {
                            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Removed"), thisArg));
                            continue;
                        }
                        if (thisArg.equals("--coreEdition")) {
                            coreEdition = true;
                            continue;
                        }
                        if (thisArg.equals("--baseEdition")) {
                            baseEdition = true;
                            continue;
                        }
                        if (thisArg.equals("--ndEdition")) {
                            ndEdition = true;
                            continue;
                        }
                        if (thisArg.equals("--zosEdition")) {
                            zosEdition = true;
                            continue;
                        }
                        if (thisArg.equals("--fullProfile") || thisArg.equals("--classic") || thisArg.equals("--traditional")) {
                            fullProfile = true;
                            continue;
                        }
                        if (thisArg.equals("--libertyProfile") || thisArg.equals("--liberty")) {
                            libertyProfile = true;
                            continue;
                        }
                    }
                    if (reportTypes.contains((Object)ReportInputData.ReportType.ANALYZE) || reportTypes.contains((Object)ReportInputData.ReportType.GENERATE_CONFIG)) {
                        if (thisArg.startsWith("--sourceAppServer=")) {
                            if (sourceAppServer == null) {
                                sourceAppServer = ReportInputData.AppServer.getAppServer(thisArg);
                                originalSourceAppServerOption = thisArg;
                                if (sourceAppServer == null) {
                                    validParms = false;
                                    System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61))));
                                    continue;
                                }
                                if (thisArg.equals(sourceAppServer.getSourceOption())) continue;
                                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_DeprecatedOption"), thisArg, sourceAppServer.getSourceOption()));
                                continue;
                            }
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_SourceAppServer_Not_Valid"));
                            continue;
                        }
                        if (thisArg.startsWith("--targetAppServer=")) {
                            if (targetAppServer == null) {
                                if (ReportInputData.AppServer.isRemoved(thisArg)) {
                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Removed"), thisArg));
                                    continue;
                                }
                                targetAppServer = ReportInputData.AppServer.getAppServer(thisArg);
                                originalTargetAppServerOption = thisArg;
                                if (targetAppServer == null) {
                                    validParms = false;
                                    if (thisArg.equals("--targetAppServer=was80") || thisArg.equals("--targetAppServer=fullProfile80")) {
                                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_TargetAppServer_No_Longer_Valid"), thisArg));
                                    } else {
                                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61))));
                                    }
                                } else if (derivedTargetCloud == null) {
                                    derivedTargetCloud = ReportInputData.TargetCloud.getTargetCloud(thisArg);
                                    if (!thisArg.equals(targetAppServer.getTargetOption())) {
                                        if (derivedTargetCloud != null) {
                                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_DeprecatedOption_Complex"), thisArg, targetAppServer.getTargetOption(), ((ReportInputData.TargetCloud)derivedTargetCloud).toString()));
                                        } else {
                                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_DeprecatedOption"), thisArg, targetAppServer.getTargetOption()));
                                        }
                                    }
                                    if (thisArg.equals("--targetAppServer=was90") && usedDeprecatedFeatureList) {
                                        validParms = false;
                                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_FeatureList_NoGeneration"), thisArg, "--targetAppServer=liberty"));
                                    }
                                }
                                if (!generateTa || targetAppServer == ReportInputData.AppServer.WAS90) continue;
                                validParms = false;
                                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61))));
                                continue;
                            }
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_TargetAppServer_Not_Valid"));
                            continue;
                        }
                        if (thisArg.startsWith("--targetJavaEE=") || thisArg.startsWith("--targetJakartaEE=")) {
                            if (thisArg.startsWith("--targetJakartaEE=")) {
                                targetJakartaEEUsed = true;
                            }
                            if (targetJavaEE == null) {
                                targetJavaEE = ReportInputData.JavaEEVersion.getJavaEEVersion(thisArg);
                                if (targetJavaEE != null) continue;
                                validParms = false;
                                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61))));
                                continue;
                            }
                            if (targetJavaEE == ReportInputData.JavaEEVersion.getJavaEEVersion(thisArg)) continue;
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_TargetJavaEE_Not_Valid"));
                            continue;
                        }
                    }
                    if (reportTypes.contains((Object)ReportInputData.ReportType.ANALYZE)) {
                        if (thisArg.equals("--replaceRules") || thisArg.equals("--userRulesOnly")) {
                            userRulesOnlyRequested = true;
                            if (!thisArg.equals("--replaceRules")) continue;
                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_DeprecatedOption"), thisArg, "--userRulesOnly"));
                            continue;
                        }
                        if (thisArg.startsWith("--ruleLocation=") || thisArg.startsWith("--userRuleLocation=")) {
                            userRuleLocationPath = thisArg.substring(thisArg.indexOf(61) + 1).replace("\\", "/");
                            if (userRuleLocationPath.startsWith("\"") && userRuleLocationPath.endsWith("\"")) {
                                userRuleLocationPath = userRuleLocationPath.substring(1, userRuleLocationPath.length() - 1);
                            }
                            userRuleLocationDir = new File(userRuleLocationPath);
                            if (!thisArg.startsWith("--ruleLocation=")) continue;
                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_DeprecatedOption"), thisArg, "--userRuleLocation"));
                            continue;
                        }
                        if (thisArg.startsWith("--maxUserDefinedRuleResults=")) {
                            String maxResults = thisArg.substring(thisArg.indexOf(61) + 1);
                            try {
                                maxUserDefinedRuleResults = Integer.parseInt(maxResults);
                                if (maxUserDefinedRuleResults > 0) continue;
                                throw new IllegalArgumentException();
                            }
                            catch (Exception ex) {
                                validParms = false;
                                ReportUtility.logger.get().log(Level.FINE, "Caught exception parsing maxUserDefinedRuleResults: ", ex);
                                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Invalid_maxUserDefinedRuleResults"), maxResults));
                                continue;
                            }
                        }
                        if (thisArg.startsWith("--targetCloud=")) {
                            if (targetCloud == null) {
                                if (ReportInputData.TargetCloud.isRemoved(thisArg)) {
                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Removed"), thisArg));
                                    continue;
                                }
                                targetCloud = ReportInputData.TargetCloud.getTargetCloud(thisArg);
                                if (targetCloud == null) {
                                    validParms = false;
                                    System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61))));
                                    continue;
                                }
                                if (((ReportInputData.TargetCloud)targetCloud).toString().equals(thisArg)) continue;
                                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_DeprecatedOption"), thisArg, ((ReportInputData.TargetCloud)targetCloud).toString()));
                                continue;
                            }
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_TargetCloud_Not_Valid"));
                            continue;
                        }
                        if (thisArg.startsWith("--sourceJava=")) {
                            if (sourceJava == null) {
                                sourceJava = ReportInputData.JavaVersion.getJavaVersion(thisArg);
                                if (sourceJava != null) continue;
                                validParms = false;
                                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61))));
                                continue;
                            }
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_SourceJava_Not_Valid"));
                            continue;
                        }
                        if (thisArg.startsWith("--targetJava=")) {
                            if (targetJava == null) {
                                targetJava = ReportInputData.JavaVersion.getJavaVersion(thisArg);
                                targetJavaUserInputValue = thisArg;
                                if (targetJava != null) continue;
                                if (thisArg.equals("--targetJava=openjdk11")) {
                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_DeprecatedOption"), thisArg, "--targetJava=java11"));
                                    targetJava = ReportInputData.JavaVersion.JAVA11;
                                    continue;
                                }
                                if (DriveScan.isDeprecatedJavaVersion(thisArg)) {
                                    ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_TargetJava_Version_Deprecated"), thisArg, ReportInputData.JavaVersion.JAVA21.getTargetOption()));
                                    targetJava = ReportInputData.JavaVersion.JAVA21;
                                    continue;
                                }
                                validParms = false;
                                if (ReportInputData.JavaVersion.isJava6(thisArg)) {
                                    isJava6 = true;
                                    if (!ReportInputData.JavaVersion.isIBMJAVA6(thisArg)) continue;
                                    isIBMJava6 = true;
                                    continue;
                                }
                                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61))));
                                continue;
                            }
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_TargetJava_Not_Valid"));
                            continue;
                        }
                        if (thisArg.startsWith("--sourceJavaEE=") || thisArg.startsWith("--sourceJakartaEE=")) {
                            if (thisArg.startsWith("--sourceJakartaEE=")) {
                                sourceJakartaEEUsed = true;
                            }
                            if (sourceJavaEE == null) {
                                sourceJavaEE = ReportInputData.JavaEEVersion.getJavaEEVersion(thisArg);
                                if (sourceJavaEE != null) continue;
                                validParms = false;
                                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61))));
                                continue;
                            }
                            if (sourceJavaEE == ReportInputData.JavaEEVersion.getJavaEEVersion(thisArg)) continue;
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_SourceJavaEE_Not_Valid"));
                            continue;
                        }
                    }
                    validParms = false;
                    System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Unknown_Option"), thisArg));
                    continue;
                }
                if (thisArg.equals("help") || thisArg.equals("-help") || thisArg.equals("?")) {
                    helpRequested = true;
                    break;
                }
                validParms = false;
                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Unknown_Option"), thisArg));
            }
        }
        if (includeApplications != null || excludeApplications != null) {
            DriveScan.pruneUserSpecifiedBinaries(includeApplications, excludeApplications);
            if (_projectFiles.isEmpty()) {
                validParms = false;
                System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_No_Files"));
            }
        }
        if (outputDir != null && outputDir.getAbsolutePath().matches(VALID_OUTPUT_FILE_EXTENSION) && (_projectFiles.size() > 1 || generateTa) && (reportTypes.size() > 1 || reportTypes.contains((Object)ReportInputData.ReportType.GENERATE_CONFIG))) {
            validParms = false;
            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Output_Directory_File_Name_Error"), "--generateConfig"));
        }
        if (isJava6) {
            if (isIBMJava6 && targetAppServer == ReportInputData.AppServer.WAS855) {
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Target_Java6_Not_Valid"), new Object[0]));
            } else {
                String targetAppOptionString = originalTargetAppServerOption == null ? "--targetAppServer=liberty" : originalTargetAppServerOption;
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_OptionCombo_Not_Valid"), targetJavaUserInputValue, targetAppOptionString));
            }
        }
        if (!(sourceJavaEE == null || sourceAppServer != null && sourceAppServer.isLiberty())) {
            sourceJavaEE = null;
            loggingStr = DriveScan.getSourceJavaEELoggingString(sourceJakartaEEUsed, false, 0);
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_SourceJavaEE_Not_Allowed_For_AppServer"), loggingStr));
        }
        if (targetJavaEE != null && sourceAppServer != null && sourceAppServer.isCompetitiveAppServer()) {
            targetJavaEE = null;
            loggingStr = DriveScan.getTargetJavaEELoggingString(targetJakartaEEUsed, false, 0);
            ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_TargetJavaEE_Not_Allowed_With_Competitive_Source_AppServer"), loggingStr));
        }
        if (targetJavaEE == null && (targetAppServer == ReportInputData.AppServer.OPEN_LIBERTY || targetAppServer == ReportInputData.AppServer.EASE)) {
            targetJavaEE = ReportInputData.JavaEEVersion.EE7;
        }
        if (reportType == ReportInputData.ReportType.INVENTORY && detectSharedLibraries && _projectFiles.size() > 1) {
            validParms = false;
            System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_Not_Valid_For_Shared_Libraries"));
        }
        if (args.length == 0) {
            helpRequested = true;
        }
        if (ReportUtility.CONTAINS_2_OR_MORE_ARCHIVES_PATTERN.matcher(_preFileName).matches()) {
            _preFileName = "";
        }
        String fileName = _preFileName + "TechnologyReport";
        if (!helpRequested && !versionRequested) {
            String invalidOption;
            if (reportOutputTypes.contains((Object)ReportInputData.OutputType.TEXT)) {
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_RemovedOption"), "--format=txt", "--format=json"));
                if (!_hiddenJunitFlag) {
                    validParms = false;
                }
            }
            if (scanAll && excludePackages != null) {
                invalidOption = excludePackages.substring(0, excludePackages.indexOf(61));
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Warning_Invalid_Option_Ignored"), invalidOption, "--scanAll", invalidOption));
                excludePackages = null;
            }
            if (scanAll && excludeRules != null) {
                invalidOption = "--excludeRules=";
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), invalidOption, "--scanAll", invalidOption));
                validParms = false;
            }
            if (scanAll && includePackages != null) {
                invalidOption = includePackages.substring(0, includePackages.indexOf(61));
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Warning_Invalid_Option_Ignored"), invalidOption, "--scanAll", invalidOption));
                includePackages = null;
            }
            if (reportOutputTypes.isEmpty() && validParms) {
                if (outputDirPath != null) {
                    if (outputDir.exists()) {
                        if (outputDir.isFile()) {
                            if (FILENAME_REGEX.matcher(outputDirPath).matches()) {
                                System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_Output_Not_Valid_Extension"));
                                validParms = false;
                            } else if (outputDirPath.endsWith(".json")) {
                                reportOutputTypes.add(ReportInputData.OutputType.JSON);
                            } else if (outputDirPath.endsWith(".html") || outputDirPath.endsWith(".htm")) {
                                reportOutputTypes.add(ReportInputData.OutputType.HTML);
                            }
                        } else {
                            reportOutputTypes.add(ReportInputData.OutputType.HTML);
                        }
                    } else {
                        String outputDirName = outputDir.getName();
                        if (FILENAME_WITH_EXTENSION_REGEX.matcher(outputDirName).matches()) {
                            if (outputDirName.endsWith(".html") || outputDirName.endsWith(".htm")) {
                                reportOutputTypes.add(ReportInputData.OutputType.HTML);
                            } else if (outputDirName.endsWith(".json")) {
                                reportOutputTypes.add(ReportInputData.OutputType.JSON);
                            } else if (outputDirName.endsWith(".xml")) {
                                reportOutputTypes.add(ReportInputData.OutputType.XML);
                            } else if (outputDirName.endsWith(".py")) {
                                reportOutputTypes.add(ReportInputData.OutputType.PY);
                            } else {
                                System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_Output_Not_Valid_Extension"));
                                validParms = false;
                            }
                        } else {
                            reportOutputTypes.add(ReportInputData.OutputType.HTML);
                        }
                    }
                } else {
                    reportOutputTypes.add(ReportInputData.OutputType.HTML);
                }
            }
            if (reportOutputTypes.contains((Object)ReportInputData.OutputType.TEXT) || reportOutputTypes.contains((Object)ReportInputData.OutputType.JSON)) {
                fileName = _preFileName + "TechnologyReport";
            }
            if (validParms && reportType == ReportInputData.ReportType.EVALUATE && (!containsEbaOrCba || reportOutputTypes.contains((Object)ReportInputData.OutputType.JSON))) {
                DriveScan.pruneBinariesExceptArchives();
                if (_projectFiles.isEmpty()) {
                    validParms = false;
                    System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_No_Files"));
                }
            } else if (validParms && reportType == null && reportTypes.isEmpty()) {
                DriveScan.pruneBinariesExceptEARsandWARs();
                if (_projectFiles.isEmpty() && !optionsRequested) {
                    validParms = false;
                    System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_No_Files"));
                }
                reportTypes.add(ReportInputData.ReportType.ANALYZE);
                reportTypes.add(ReportInputData.ReportType.EVALUATE);
                reportTypes.add(ReportInputData.ReportType.INVENTORY);
                reportTypes.add(ReportInputData.ReportType.GENERATE_CONFIG);
            }
            if (reportType != null && !reportTypes.contains((Object)ReportInputData.ReportType.GENERATE_CONFIG)) {
                String action = reportType.toString();
                if (reportTypes.contains((Object)ReportInputData.ReportType.EVALUATE)) {
                    skipConfig = true;
                    if (configLocationPath != null) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Option_Not_Supported_With_Action"), "--configLocation", action));
                    }
                }
                if ((reportTypes.contains((Object)ReportInputData.ReportType.EVALUATE) || reportTypes.contains((Object)ReportInputData.ReportType.ANALYZE)) && detectSharedLibraries) {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Option_Not_Supported_With_Action"), "--detectSharedLibraries", action));
                }
                if (migrateAllConfig) {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Option_Not_Supported_With_Action"), "--migrateAllConfig", action));
                }
                if (includeSensitiveData) {
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Option_Not_Supported_With_Action"), "--includeSensitiveData", action));
                }
            }
            if (sourceAppServer != null) {
                if (sourceAppServer.isLiberty()) {
                    skipConfig = true;
                } else if (sourceAppServer.isCompetitiveAppServer()) {
                    skipConfig = true;
                    if (reportTypes.contains((Object)ReportInputData.ReportType.GENERATE_CONFIG) && reportTypes.size() == 1 && targetAppServer != null && targetAppServer.isWAS_Traditional()) {
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_GenerateConfig_Invalid_With_Competitive_To_WAS"), "--generateConfig", sourceAppServer.getSourceOption(), "--all"));
                        validParms = false;
                    } else if (configLocationPath != null) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getString("DriveScan_Parm_Config_Location_Not_Allowed_With_Competitive_Source_AppServer"));
                    }
                }
            }
            if (!skipConfig && validParms) {
                for (File projectFile : _projectFiles) {
                    appToConfigDir.put(projectFile, null);
                    if (!"Dummy.ear".equals(projectFile.getName())) continue;
                    for (String profile : profiles) {
                        _mapOfAppsToProfiles.put(projectFile, profile);
                    }
                }
                ConfigUtility.populateAppToConfigDir(appToConfigDir, _mapOfAppsToProfiles, _mapOfProfilesToPaths, configLocation, reportTypes);
                if (targetAppServer != null && targetAppServer.isWAS_Traditional() && reportOutputTypes.contains((Object)ReportInputData.OutputType.XML)) {
                    reportOutputTypes.remove((Object)ReportInputData.OutputType.XML);
                    reportOutputTypes.add(ReportInputData.OutputType.PY);
                }
            }
            if (!(showAllHelp || !binaryPathNames.isEmpty() || inputIsDirectory || optionsRequested || !reportTypes.contains((Object)ReportInputData.ReportType.EVALUATE) && !reportTypes.contains((Object)ReportInputData.ReportType.ANALYZE) || generateTa)) {
                validParms = false;
                if (reportTypes.contains((Object)ReportInputData.ReportType.ANALYZE) && !isConsolidatedScan) {
                    System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_Not_Valid_File_Type"));
                } else if (reportTypes.contains((Object)ReportInputData.ReportType.EVALUATE) && !isConsolidatedScan) {
                    System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_BinaryInputPath_Not_Valid_File_Type_FOR_EVAL"));
                }
            }
            if (appToConfigDir != null) {
                ReportInputData.JavaVersion oldestJava = null;
                ReportInputData.AppServer oldestAppServer = null;
                HashMap<String, ReportInputData.JavaVersion> mapOfAppsToOldestJavasDetected = new HashMap<String, ReportInputData.JavaVersion>();
                HashMap<String, ReportInputData.AppServer> mapOfAppsToOldestAppServersDetected = new HashMap<String, ReportInputData.AppServer>();
                HashSet<String> setOfAppsWithConfig = new HashSet<String>();
                for (Map.Entry entry : appToConfigDir.entrySet()) {
                    ConfigManager configMgr = null;
                    File appFile = (File)entry.getKey();
                    File configDir = (File)entry.getValue();
                    if (configDir == null) continue;
                    configDetected = true;
                    LibertyServerXml appConfig = null;
                    String appName = appFile.getName();
                    String appPath = appFile.getAbsolutePath();
                    try {
                        ConfigManagerFactory.setIncludeSensitiveData(includeSensitiveData);
                        ConfigManagerFactory.setMigrateAllConfig(migrateAllConfig);
                        ConfigManagerFactory.setLondon(london);
                        configMgr = ConfigManagerFactory.getConfigManager(configDir.getAbsolutePath());
                        setOfAppsWithConfig.add(appPath);
                    }
                    catch (Exception e) {
                        ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScan_Config_Scan_Error_Log"), appFile.getAbsolutePath()), e);
                    }
                    if (configMgr == null) continue;
                    try {
                        ReportInputData.AppServer appServer;
                        ReportInputData.JavaVersion javaVersion;
                        appConfig = new LibertyServerXml(configMgr, appName, null, false);
                        if ("Dummy.ear".equals(appName)) {
                            javaVersion = ReportInputData.JavaVersion.IBM8;
                            appServer = ReportInputData.AppServer.WAS90;
                        } else {
                            DeploymentEnvironment deploymentEnvironment = appConfig.getDeploymentEnvironment();
                            javaVersion = ReportInputData.JavaVersion.parseIBMJava(deploymentEnvironment.getOldestJavaVersion());
                            appServer = ReportInputData.AppServer.parseWebSphereVersion(deploymentEnvironment.getOldestWebSphereVersion());
                        }
                        if (javaVersion != null) {
                            if (oldestJava == null || oldestJava.getVersionNumber() > javaVersion.getVersionNumber()) {
                                oldestJava = javaVersion;
                            }
                            mapOfAppsToOldestJavasDetected.put(appPath, javaVersion);
                        }
                        if (appServer != null) {
                            if (oldestAppServer == null || oldestAppServer.getWasVersion().compareTo(appServer.getWasVersion()) > 0) {
                                oldestAppServer = appServer;
                            }
                            mapOfAppsToOldestAppServersDetected.put(appPath, appServer);
                        }
                        configSuccess = true;
                    }
                    catch (Exception e) {
                        ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScan_Config_Scan_Error_Log"), appFile.getAbsolutePath()), e);
                    }
                }
                HashSet setOfOldestJavasDetected = new HashSet();
                setOfOldestJavasDetected.addAll(mapOfAppsToOldestJavasDetected.values());
                HashSet setOfOldestAppServersDetected = new HashSet();
                setOfOldestAppServersDetected.addAll(mapOfAppsToOldestAppServersDetected.values());
                if (!setOfOldestJavasDetected.isEmpty() && !setOfOldestAppServersDetected.isEmpty()) {
                    ReportInputData.AppServer appVersion;
                    ReportInputData.JavaVersion javaVersion = oldestJava;
                    String versionMismatchMessage = mapOfAppsToOldestAppServersDetected.keySet().size() > 1 ? Messages.getString("DriveScan_Different_Version_Detected_Plural") : Messages.getString("DriveScan_Different_Version_Detected");
                    if (sourceJava != javaVersion) {
                        if (sourceJava != null && setOfOldestJavasDetected.size() == 1) {
                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(versionMismatchMessage, "--sourceJava", javaVersion.getSourceOption()));
                        } else {
                            sourceJava = javaVersion;
                        }
                    }
                    if (sourceAppServer != (appVersion = oldestAppServer)) {
                        if (sourceAppServer != null && setOfOldestAppServersDetected.size() == 1) {
                            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(versionMismatchMessage, "--sourceAppServer", appVersion.getSourceOption()));
                        } else {
                            sourceAppServer = appVersion;
                        }
                    }
                    if (!(setOfOldestJavasDetected.size() <= 1 && setOfOldestAppServersDetected.size() <= 1 || setOfAppsWithConfig.isEmpty())) {
                        StringBuilder sb = new StringBuilder();
                        boolean first = true;
                        for (String name2 : setOfAppsWithConfig) {
                            if (first) {
                                first = false;
                            } else {
                                sb.append("\n");
                            }
                            ReportInputData.JavaVersion jv = (ReportInputData.JavaVersion)((Object)mapOfAppsToOldestJavasDetected.get(name2));
                            ReportInputData.AppServer as = (ReportInputData.AppServer)((Object)mapOfAppsToOldestAppServersDetected.get(name2));
                            String sourceJavaOption = jv != null ? jv.getSourceOption() : "";
                            String sourceAppServerOption = as != null ? as.getSourceOption() : "";
                            sb.append(name2).append(" ").append(sourceJavaOption).append(" ").append(sourceAppServerOption);
                        }
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Multiple_Versions_Detected"), sb.toString()));
                    }
                }
            }
            if (generateTa) {
                if (profiles == null) {
                    if (sourceAppServer == null || sourceAppServer.isCompetitiveAppServer()) {
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getString("DriveScan_TA_SourceAppServer_Requred"));
                    }
                    if (sourceJava == null) {
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getString("DriveScan_TA_SourceJava_Requred"));
                    }
                }
                if (validParms) {
                    sourceJavaEE = sourceAppServer.getDefaultSourceJavaEE();
                }
            }
            if (reportTypes.contains((Object)ReportInputData.ReportType.ANALYZE)) {
                fileName = _preFileName + "AnalysisReport";
                if (!userRulesOnlyRequested) {
                    boolean setDefaultValues;
                    boolean treatSourceAndTargetAppServerAsSame = false;
                    if (!generateTa) {
                        if (analyzeJavaSE) {
                            if (sourceAppServer == null && targetAppServer == null) {
                                sourceAppServer = ReportInputData.AppServer.LIBERTY;
                                targetAppServer = ReportInputData.AppServer.LIBERTY;
                            } else if (sourceAppServer == null || targetAppServer == null || !sourceAppServer.name().equals(targetAppServer.name())) {
                                validParms = false;
                                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_AnalyzeJavaSE_Option_AppServer_Not_Valid"), "--sourceAppServer=", "--targetAppServer=", "--analyzeJavaSE", "--analyze"));
                            }
                            if (sourceJava == null || targetJava == null || sourceJava == targetJava) {
                                validParms = false;
                                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_AnalyzeJavaSE_Option_JavaVersion_Not_Valid"), "--sourceJava=", "--targetJava=", "--analyzeJavaSE"));
                            }
                        } else if (targetCloud != null) {
                            if (derivedTargetCloud != null && !derivedTargetCloud.equals(targetCloud)) {
                                validParms = false;
                                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_OptionCombo_Not_Valid"), originalTargetAppServerOption, ((ReportInputData.TargetCloud)targetCloud).toString()));
                            }
                            if (validParms && (sourceAppServer == null && targetAppServer != null || sourceAppServer != null && targetAppServer == null)) {
                                if (sourceAppServer == null) {
                                    sourceAppServer = targetAppServer == ReportInputData.AppServer.LIBERTY || targetAppServer == ReportInputData.AppServer.OPEN_LIBERTY || targetAppServer == ReportInputData.AppServer.EASE ? ReportInputData.AppServer.WAS855 : targetAppServer;
                                }
                                if (targetAppServer == null) {
                                    if (sourceAppServer.isWAS_Traditional()) {
                                        targetAppServer = ReportInputData.AppServer.LIBERTY;
                                    } else if (sourceAppServer == ReportInputData.AppServer.LIBERTY_CORE) {
                                        if (targetCloud == ReportInputData.TargetCloud.THIRD_PARTY) {
                                            targetAppServer = ReportInputData.AppServer.LIBERTY;
                                            treatSourceAndTargetAppServerAsSame = true;
                                        } else {
                                            targetAppServer = ReportInputData.AppServer.LIBERTY_CORE;
                                        }
                                    } else {
                                        targetAppServer = ReportInputData.AppServer.LIBERTY;
                                    }
                                }
                            } else if (sourceAppServer == null && targetAppServer == null) {
                                sourceAppServer = ReportInputData.AppServer.WAS855;
                                targetAppServer = ReportInputData.AppServer.LIBERTY;
                            }
                        } else {
                            if (sourceAppServer == null) {
                                sourceAppServer = ReportInputData.AppServer.WAS855;
                            }
                            if (targetAppServer == null) {
                                targetAppServer = reportType == null && fullProfile && !libertyProfile && sourceAppServer.isWAS_Traditional() ? ReportInputData.AppServer.WAS90 : ReportInputData.AppServer.LIBERTY;
                            }
                            if ((targetCloud = derivedTargetCloud) != null && sourceAppServer == ReportInputData.AppServer.LIBERTY_CORE && targetAppServer == ReportInputData.AppServer.LIBERTY) {
                                treatSourceAndTargetAppServerAsSame = true;
                            }
                        }
                    }
                    if (targetAppServer != null && targetCloud != null && !targetAppServer.isValidTargetCloud((ReportInputData.TargetCloud)targetCloud)) {
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_OptionCombo_Not_Valid"), ((ReportInputData.TargetCloud)targetCloud).toString(), targetAppServer.getTargetOption()));
                    }
                    if (targetJava != null && targetAppServer == ReportInputData.AppServer.WAS855 && targetJava == ReportInputData.JavaVersion.IBM7) {
                        ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_TargetJava_Version_Deprecated"), targetJava.getTargetOption(), ReportInputData.JavaVersion.IBM8.getTargetOption()));
                        targetJava = ReportInputData.JavaVersion.IBM8;
                    }
                    if (reportType == null && targetAppServer != null) {
                        if (fullProfile && !libertyProfile && !targetAppServer.isWAS_Traditional()) {
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_All_Option_Error_Specific"), "--liberty", "--traditional", originalTargetAppServerOption != null ? originalTargetAppServerOption : targetAppServer.getTargetOption()));
                            validParms = false;
                        } else if (coreEdition && !baseEdition && !ndEdition && !zosEdition) {
                            if (targetAppServer.isWAS_Traditional()) {
                                String editionOption = "--coreEdition";
                                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Invalid_Option"), editionOption, originalTargetAppServerOption != null ? originalTargetAppServerOption : targetAppServer.getTargetOption(), "--baseEdition"));
                                validParms = false;
                            } else if (targetAppServer == ReportInputData.AppServer.LIBERTY && coreEdition) {
                                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Invalid_Option"), "--coreEdition", originalTargetAppServerOption != null ? originalTargetAppServerOption : targetAppServer.getTargetOption(), "--baseEdition"));
                                validParms = false;
                            }
                        } else if (libertyProfile && !fullProfile && targetAppServer.isWAS_Traditional()) {
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_All_Option_Error_Specific"), "--traditional", "--liberty", originalTargetAppServerOption != null ? originalTargetAppServerOption : targetAppServer.getTargetOption()));
                            validParms = false;
                        } else if ((ndEdition || baseEdition || zosEdition) && !coreEdition && targetAppServer == ReportInputData.AppServer.LIBERTY_CORE) {
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_All_Option_Error"), "--coreEdition", originalTargetAppServerOption != null ? originalTargetAppServerOption : targetAppServer.getTargetOption()));
                            validParms = false;
                        }
                    }
                    boolean isSourceAndTargetAppServerSet = sourceAppServer != null && targetAppServer != null;
                    boolean isSourceAndTargetAppServerSame = isSourceAndTargetAppServerSet && sourceAppServer.name().equals(targetAppServer.name());
                    boolean bl = setDefaultValues = isSourceAndTargetAppServerSet && !isSourceAndTargetAppServerSame && !treatSourceAndTargetAppServerAsSame;
                    if (targetJavaEE == null && setDefaultValues && !sourceAppServer.isCompetitiveAppServer()) {
                        if (targetAppServer == ReportInputData.AppServer.WAS855) {
                            targetJavaEE = ReportInputData.JavaEEVersion.EE6;
                        } else if (targetAppServer == ReportInputData.AppServer.WAS90) {
                            targetJavaEE = ReportInputData.JavaEEVersion.EE7;
                        }
                    }
                    if (validParms && sourceJava == null && setDefaultValues) {
                        if (sourceAppServer.isWAS_Traditional()) {
                            sourceJava = sourceAppServer.isValidSourceJava(ReportInputData.JavaVersion.IBM5) ? ReportInputData.JavaVersion.IBM5 : (sourceAppServer.isValidSourceJava(ReportInputData.JavaVersion.IBM6) ? ReportInputData.JavaVersion.IBM6 : ReportInputData.JavaVersion.IBM8);
                        } else if (sourceAppServer.isCompetitiveAppServer()) {
                            String sourceJavaOption = "--sourceJava=";
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Source_Java_Option_Required"), sourceJavaOption.subSequence(0, sourceJavaOption.indexOf(61)), originalSourceAppServerOption));
                            validParms = false;
                        } else {
                            sourceJava = ReportInputData.JavaVersion.IBM7;
                        }
                    }
                    if (validParms && sourceJava != null && sourceAppServer != null && !sourceAppServer.isCompetitiveAppServer() && !sourceAppServer.isValidSourceJava(sourceJava)) {
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_OptionCombo_Not_Valid"), sourceJava.getSourceOption(), sourceAppServer.getSourceOption()));
                    }
                    if (targetJava == null && setDefaultValues && validParms) {
                        targetJava = targetAppServer.isValidTargetJava(ReportInputData.JavaVersion.IBM8) ? ReportInputData.JavaVersion.IBM8 : targetAppServer.getLatestSupportedJavaVersion();
                    }
                    if (sourceJava == null && targetJava != null || targetJava == null && sourceJava != null) {
                        if (sourceJava == null) {
                            sourceJava = targetJava;
                        } else {
                            targetJava = targetAppServer == null || targetAppServer.isValidTargetJava(sourceJava) ? (sourceJava.getVersionNumber() > 7 ? sourceJava : ReportInputData.JavaVersion.IBM8) : ReportInputData.JavaVersion.IBM8;
                        }
                    }
                    if (sourceJava != null && targetJava != null) {
                        double sourceJavaNum = sourceJava.getVersionNumber();
                        double targetJavaNum = targetJava.getVersionNumber();
                        if (validParms && targetJavaNum < sourceJavaNum) {
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_TargetJava_BackwardMigration_Not_Valid"), targetJava.getTargetOption(), sourceJava.getSourceOption()));
                            validParms = false;
                        }
                    }
                    if (sourceJavaEE != null && targetJavaEE != null) {
                        int sourceJavaEENum = sourceJavaEE.getVersionNumber();
                        int targetJavaEENum = targetJavaEE.getVersionNumber();
                        if (validParms && targetJavaEENum < sourceJavaEENum) {
                            String targetloggingStr = DriveScan.getTargetJavaEELoggingString(targetJakartaEEUsed, true, targetJavaEENum);
                            String sourceloggingStr = DriveScan.getSourceJavaEELoggingString(sourceJakartaEEUsed, true, sourceJavaEENum);
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_TargetJava_BackwardMigration_Not_Valid"), targetloggingStr, sourceloggingStr));
                            validParms = false;
                        }
                    }
                    if (sourceJavaEE == null && (setDefaultValues || targetJavaEE != null)) {
                        boolean setLibertySourceJavaEE;
                        boolean isSourceAppServerTWAS = sourceAppServer == null || sourceAppServer.isWAS_Traditional();
                        boolean bl2 = setLibertySourceJavaEE = sourceAppServer != null && sourceAppServer.isLiberty() && targetJavaEE != null;
                        if (isSourceAppServerTWAS || setLibertySourceJavaEE) {
                            sourceJavaEE = sourceAppServer.getDefaultSourceJavaEE();
                        }
                    }
                    if (validParms && reportTypes.contains((Object)ReportInputData.ReportType.ANALYZE) && isSourceAndTargetAppServerSet && !sourceAppServer.isValidTargetAppServer(targetAppServer)) {
                        validParms = false;
                        if (originalSourceAppServerOption == null) {
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_OneDefault_SourceAndTargetAppServerCombo_Not_Valid"), originalTargetAppServerOption, sourceAppServer.getSourceOption()));
                        } else if (originalTargetAppServerOption == null) {
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_OneDefault_SourceAndTargetAppServerCombo_Not_Valid"), originalSourceAppServerOption, targetAppServer.getTargetOption()));
                        } else {
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_SourceAndTargetAppServerCombo_Not_Valid"), originalSourceAppServerOption, originalTargetAppServerOption));
                        }
                    }
                    if (validParms && targetJava != null && targetAppServer != null && !generateTa && !targetAppServer.isValidTargetJava(targetJava)) {
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_OptionCombo_Not_Valid"), targetJava.getTargetOption(), targetAppServer.getTargetOption()));
                    }
                    if (validParms && sourceJavaEE != null) {
                        String loggingStr2 = DriveScan.getSourceJavaEELoggingString(targetJakartaEEUsed, true, sourceJavaEE.getVersionNumber());
                        if (sourceAppServer != null && !sourceAppServer.isValidJavaEE(sourceJavaEE)) {
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_OptionCombo_Not_Valid"), loggingStr2, sourceAppServer.getTargetOption()));
                        } else if (sourceJava != null && !sourceJavaEE.isValid(sourceJava)) {
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_OptionCombo_Not_Valid"), sourceJava.getTargetOption(), loggingStr2));
                        }
                    }
                    if (validParms && targetJavaEE != null) {
                        int targetJavaEENum = targetJavaEE.getVersionNumber();
                        String loggingStr3 = DriveScan.getTargetJavaEELoggingString(targetJakartaEEUsed, true, targetJavaEENum);
                        if (targetAppServer != null && !targetAppServer.isValidJavaEE(targetJavaEE)) {
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_OptionCombo_Not_Valid"), loggingStr3, targetAppServer.getTargetOption()));
                        } else if (targetJava != null && !targetJavaEE.isValid(targetJava)) {
                            validParms = false;
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_OptionCombo_Not_Valid"), targetJava.getTargetOption(), loggingStr3));
                        }
                    }
                    if (validParms && reportTypes.contains((Object)ReportInputData.ReportType.ANALYZE) && reportTypes.size() == 1 && targetCloud == null && isSourceAndTargetAppServerSet && (isSourceAndTargetAppServerSame || treatSourceAndTargetAppServerAsSame) && (targetJavaEE == null || targetJavaEE == ReportInputData.JavaEEVersion.EE6 || sourceJavaEE != null && sourceJavaEE.name().equals(targetJavaEE.name())) && (sourceJava == null && targetJava == null || sourceJava != null && targetJava != null && sourceJava.name().equals(targetJava.name()))) {
                        validParms = false;
                        if (originalSourceAppServerOption == null) {
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_OneDefault_SourceAndTargetAppServerCombo_Not_Valid"), originalTargetAppServerOption, sourceAppServer.getSourceOption()));
                        } else if (originalTargetAppServerOption == null) {
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_OneDefault_SourceAndTargetAppServerCombo_Not_Valid"), originalSourceAppServerOption, targetAppServer.getTargetOption()));
                        } else {
                            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_SourceAndTargetAppServerCombo_Not_Valid"), originalSourceAppServerOption, originalTargetAppServerOption));
                        }
                    }
                }
                if (userRulesOnlyRequested && (sourceAppServer != null || targetAppServer != null || targetJava != null || sourceJava != null || targetJavaEE != null || sourceJavaEE != null)) {
                    validParms = false;
                    System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_SourceOptions_Not_Valid"));
                }
            }
            if (reportTypes.contains((Object)ReportInputData.ReportType.INVENTORY)) {
                fileName = _preFileName + "InventoryReport";
            }
            if (reportTypes.contains((Object)ReportInputData.ReportType.GENERATE_CONFIG)) {
                fileName = targetAppServer != null && targetAppServer.isWAS_Traditional() ? _preFileName + "wsadmin" : _preFileName + "server";
            }
            if (reportTypes.size() > 1) {
                fileName = null;
            }
        }
        if (!validParms || helpRequested || versionRequested || optionsRequested) {
            if (helpRequested) {
                if (!listOfArgs.isEmpty()) {
                    String nextArg = (String)listOfArgs.get(0);
                    if (nextArg.equals("--analyzeMigrationDetails") || nextArg.equals("analyzeMigrationDetails")) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_DeprecatedAction"), nextArg, "--analyze"));
                        DriveScan.printMigrationHelp("analyze", hiddenOptionsRequested);
                    } else if (nextArg.equals("--analyze") || nextArg.equals("analyze")) {
                        DriveScan.printMigrationHelp("analyze", hiddenOptionsRequested);
                    } else if (nextArg.equals("--all") || nextArg.equals("all")) {
                        DriveScan.printMigrationHelp(null, hiddenOptionsRequested);
                    } else if (nextArg.equals("--all-separate-reports") || nextArg.equals("all-separate-reports")) {
                        DriveScan.printMigrationHelp("all-separate-reports", hiddenOptionsRequested);
                    } else if (nextArg.equals("--evaluateApplication") || nextArg.equals("evaluateApplication")) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_DeprecatedAction"), nextArg, "--evaluate"));
                        DriveScan.printMigrationHelp("evaluate", hiddenOptionsRequested);
                    } else if (nextArg.equals("--evaluate") || nextArg.equals("evaluate")) {
                        DriveScan.printMigrationHelp("evaluate", hiddenOptionsRequested);
                    } else if (nextArg.equals("--inventory") || nextArg.equals("inventory")) {
                        DriveScan.printMigrationHelp("inventory", hiddenOptionsRequested);
                    } else if (nextArg.equals("--generateConfig") || nextArg.equals("generateConfig")) {
                        DriveScan.printMigrationHelp("generateConfig", hiddenOptionsRequested);
                    } else if (nextArg.equalsIgnoreCase("--analyzeJavaSE") || nextArg.equalsIgnoreCase("analyzeJavaSE")) {
                        DriveScan.printMigrationHelp("analyzeJavaSE", hiddenOptionsRequested);
                    } else if (nextArg.equals("ta") || nextArg.equals("--ta")) {
                        DriveScan.printMigrationHelp("ta", hiddenOptionsRequested);
                    } else if (nextArg.equals("version") || nextArg.equals("--version")) {
                        DriveScan.printVersionHelp();
                    } else if (nextArg.equals("help") || nextArg.equals("--help")) {
                        DriveScan.printHelpHelp();
                    } else if (nextArg.equals("--hiddenJunitFlag")) {
                        DriveScan.printHelp();
                    } else {
                        System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Unknown_Option"), nextArg));
                        DriveScan.printUsage();
                    }
                } else {
                    DriveScan.printHelp();
                }
            } else if (versionRequested) {
                DriveScan.printVersionInfo();
            } else if (optionsRequested) {
                DriveScan.printOptionsInfo(targetJava, targetAppServer);
            } else if (!runFromTaDc) {
                DriveScan.printUsage();
            }
        } else {
            if (outputDir != null) {
                if (validParms) {
                    if (outputDir.exists()) {
                        if (outputDir.isFile()) {
                            if (reportOutputTypes.contains((Object)ReportInputData.OutputType.XML)) {
                                if (outputDirPath.endsWith(".xml") && inputIsDirectory && _projectFiles.size() > 1) {
                                    validParms = false;
                                    System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_Output_Directory_Creation_Failed_Due_to_File"));
                                } else if (!outputDirPath.endsWith(".xml")) {
                                    validParms = false;
                                    System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_Output_Not_Valid_XML_Extension"));
                                }
                            } else if (reportOutputTypes.contains((Object)ReportInputData.OutputType.PY)) {
                                if (outputDirPath.endsWith(".py") && inputIsDirectory && _projectFiles.size() > 1) {
                                    validParms = false;
                                    System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_Output_Directory_Creation_Failed_Due_to_File"));
                                } else if (!outputDirPath.endsWith(".py")) {
                                    validParms = false;
                                    System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_Output_Not_Valid_PY_Extension"));
                                }
                            } else {
                                if (_projectFiles.size() > 1) {
                                    outputDir = outputDir.getParentFile();
                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getString("DriveScan_Parm_Output_Directory_Ignored"));
                                }
                                outputDirPath = DriveScan.removeExtension(outputDirPath);
                                for (ReportInputData.OutputType type : reportOutputTypes) {
                                    outputFiles.put(type, new File(outputDirPath + type.getExtension()));
                                }
                            }
                        } else if (fileName != null) {
                            if (isCurrentDir) {
                                for (ReportInputData.OutputType type : reportOutputTypes) {
                                    outputFiles.put(type, new File(outputDirPath + type.getExtension()));
                                }
                            } else {
                                fileName = DriveScan.convertFileName(inputIsDirectory, fileName);
                                for (ReportInputData.OutputType type : reportOutputTypes) {
                                    outputFiles.put(type, new File(outputDir, fileName + type.getExtension()));
                                }
                            }
                        }
                    } else {
                        String outputDirName = outputDir.getName();
                        if (FILENAME_WITH_EXTENSION_REGEX.matcher(outputDirName).matches() && (reportOutputTypes.contains((Object)ReportInputData.OutputType.TEXT) || reportOutputTypes.contains((Object)ReportInputData.OutputType.HTML) && (outputDirPath.endsWith(".html") || outputDirPath.endsWith(".htm")) || reportOutputTypes.contains((Object)ReportInputData.OutputType.JSON) && outputDirPath.endsWith(".json")) || (reportOutputTypes.contains((Object)ReportInputData.OutputType.XML) && outputDirPath.endsWith(".xml") || reportOutputTypes.contains((Object)ReportInputData.OutputType.PY) && outputDirPath.endsWith(".py")) && (!inputIsDirectory || _projectFiles.size() == 1)) {
                            boolean dirCreated;
                            File parentDir = outputDir.getParentFile();
                            if (parentDir != null && !parentDir.exists() && !(dirCreated = parentDir.mkdirs())) {
                                validParms = false;
                                System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_Output_Directory_Creation_Failed"));
                            }
                            if (validParms) {
                                if (_projectFiles.size() > 1) {
                                    outputDir = parentDir;
                                    ReportUtility.logger.get().log(Level.WARNING, Messages.getString("DriveScan_Parm_Output_Directory_Ignored"));
                                }
                                outputDirPath = DriveScan.removeExtension(outputDirPath);
                                for (ReportInputData.OutputType type : reportOutputTypes) {
                                    outputFiles.put(type, new File(outputDirPath + type.getExtension()));
                                }
                            }
                        } else {
                            boolean dirCreated = outputDir.mkdirs();
                            if (!dirCreated) {
                                validParms = false;
                                System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_Output_Directory_Creation_Failed"));
                            } else if (fileName != null) {
                                fileName = DriveScan.convertFileName(inputIsDirectory, fileName);
                                for (ReportInputData.OutputType type : reportOutputTypes) {
                                    outputFiles.put(type, new File(outputDir, fileName + type.getExtension()));
                                }
                            }
                        }
                    }
                }
            } else {
                if (inputIsDirectory && _projectFiles.size() == 1) {
                    inputIsDirWithOneArchive = true;
                }
                if (!_hiddenJunitFlag && !nobrowser) {
                    display = true;
                }
            }
            if (userRuleLocationDir != null) {
                if (userRuleLocationDir.exists()) {
                    if (!DriveScan.isRuleLocationValid(userRuleLocationDir)) {
                        validParms = false;
                        System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_RuleLocation_Not_Valid"));
                    }
                } else {
                    validParms = false;
                    System.out.println("SEVERE: " + Messages.getString("DriveScan_Parm_RuleLocation_Does_Not_Exist"));
                }
            } else {
                if (userRulesOnlyRequested) {
                    validParms = false;
                    System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_RuleLocation_Required"), "--userRulesOnly"));
                }
                if (generateTa && userRuleLocationPath == null) {
                    maxUserDefinedRuleResults = -1;
                }
                if (maxUserDefinedRuleResults != -1) {
                    validParms = false;
                    System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_RuleLocation_Required"), "--maxUserDefinedRuleResults"));
                }
            }
            if (validParms) {
                if (multipleBinaryFilesSpecified) {
                    Iterator it = binaryPathNames.iterator();
                    String rootPath = null;
                    while (it.hasNext()) {
                        String pathName = (String)it.next();
                        if (rootPath == null) {
                            rootPath = pathName;
                            continue;
                        }
                        if (rootPath.equals(pathName) || rootPath.startsWith(pathName + "/")) {
                            rootPath = pathName;
                            continue;
                        }
                        if (pathName.equals(rootPath) || pathName.startsWith(rootPath + "/")) continue;
                        rootPath = null;
                        break;
                    }
                    if (rootPath != null) {
                        binaryLocations.clear();
                        if (reportType == ReportInputData.ReportType.ANALYZE && reportTypes.size() == 1) {
                            StringBuilder sb = new StringBuilder();
                            for (File projectFile : _projectFiles) {
                                if (sb.length() > 0) {
                                    sb.append("\n");
                                }
                                String path = DriveScan.getFileName(projectFile);
                                sb.append(path);
                            }
                            String listOfProjectNames = sb.toString();
                            _projectNames.clear();
                            if (_projectFiles.size() > 1) {
                                _projectNames.add(Messages.getFormattedMessage(Messages.getString("DriveScan_Report_Footer_Directory_Wildcard_Plural"), rootPath, _projectFiles.size(), listOfProjectNames));
                            } else {
                                _projectNames.add(Messages.getFormattedMessage(Messages.getString("DriveScan_Report_Footer_Directory_Wildcard"), rootPath, listOfProjectNames));
                            }
                        }
                        inputIsDirectory = true;
                        binaryLocations.add(new File(rootPath));
                    }
                }
                if (reportTypes.size() <= 1) {
                    switch (reportType) {
                        case ANALYZE: {
                            data = new ReportInputData(outputDir, display, reportOutputTypes, sourceAppServer, targetAppServer, sourceJava, targetJava, sourceJavaEE, targetJavaEE, (ReportInputData.TargetCloud)targetCloud, outputFiles, _projectFiles, _projectNames, _applicationNames, appToConfigDir, reportType, includePackages, excludePackages, excludeFilesPattern, _preFileName, excludedRulesSet);
                            break;
                        }
                        case EVALUATE: {
                            data = new ReportInputData(outputDir, display, reportOutputTypes, libertyProfile, fullProfile, coreEdition, baseEdition, ndEdition, zosEdition, outputFiles, _projectFiles, _projectNames, _applicationNames, reportType, includePackages, excludePackages, excludeFilesPattern, _preFileName);
                            break;
                        }
                        case GENERATE_CONFIG: {
                            data = new ReportInputData(reportOutputTypes, outputFiles, sourceAppServer, targetAppServer, targetJavaEE, _projectFiles, _projectNames, reportType, appToConfigDir, includeSensitiveData, includePackages, excludePackages, excludeFilesPattern, inputIsDirWithOneArchive, _preFileName, _sharedLibraryFiles);
                            break;
                        }
                        case INVENTORY: {
                            data = new ReportInputData(outputDir, display, reportOutputTypes, outputFiles, _projectFiles, _projectNames, _sharedLibraryFiles, reportType, includePackages, excludePackages, excludeFilesPattern, inputIsDirWithOneArchive, _preFileName, appToConfigDir);
                        }
                    }
                } else {
                    data = new ReportInputData(outputDir, display, reportOutputTypes, outputFiles, _projectFiles, _projectNames, _applicationNames, appToConfigDir, includeSensitiveData, includePackages, excludePackages, excludeFilesPattern, libertyProfile, fullProfile, coreEdition, baseEdition, ndEdition, zosEdition, sourceAppServer, targetAppServer, sourceJava, targetJava, sourceJavaEE, targetJavaEE, (ReportInputData.TargetCloud)targetCloud, _sharedLibraryFiles, inputIsDirWithOneArchive, _preFileName);
                    data.setIsRunFromTaDc(runFromTaDc);
                    data.generateTA(generateTa);
                }
                data.setBinaryLocations(new HashSet<File>(binaryLocations));
                data.setClean(clean);
                data.setDelete(_delete);
                data.setIncludeApplications(includeApplications);
                data.setExcludeApplications(excludeApplications);
                data.setStopOnMissingBinary(stopOnMissingBinary);
                data.setStopOnMissingSharedLibrary(stopOnMissingSharedLibrary);
                data.setTargetJakartaEEParameterUsed(targetJakartaEEUsed);
                data.setSourceJakartaEEParameterUsed(sourceJakartaEEUsed);
                data.setMapOfAppsToProfiles(_mapOfAppsToProfiles);
                data.setMapOfProfilesToPaths(_mapOfProfilesToPaths);
                data.setJunitFlag(_hiddenJunitFlag);
                if (scanAll) {
                    data.overrideDefaultExcludePackagesRegex();
                }
                data.setReplaceRulesFlag(userRulesOnlyRequested);
                data.setMaxUserDefinedRuleResults(maxUserDefinedRuleResults);
                if (userRuleLocationDir != null) {
                    data.setUserRuleLocation(userRuleLocationPath);
                }
                if (_ruleXmlFiles != null) {
                    data.setRuleXmlFiles(_ruleXmlFiles);
                }
                data.setMigrateAllConfig(migrateAllConfig);
                data.setLondon(london);
                data.setShowAllHelp(showAllHelp);
                data.setIncludeHelpLocation(includeHelpLocation);
                data.setDetectSharedLibraries(detectSharedLibraries);
                data.setLoadAllRules(loadAllRules);
                data.setGenerateAllSeparateReports(generateAllSeparateReports);
                if (binaryLocations != null) {
                    for (File binaryLocation : binaryLocations) {
                        String pathNormalized;
                        int index;
                        String path = DriveScan.getFileName(binaryLocation);
                        if (inputIsDirectory) {
                            data.addProjectDirPath(path);
                            continue;
                        }
                        if (multipleBinaryFilesSpecified || (index = (pathNormalized = path.replace("\\", "/")).lastIndexOf(47)) <= -1) continue;
                        String dirPath = pathNormalized.substring(0, index);
                        data.addProjectDirPath(dirPath);
                    }
                }
            } else if (!runFromTaDc) {
                DriveScan.printUsage();
            }
        }
        ReportUtility.logger.get().log(Level.FINE, "DriveScan: arguments provided " + Arrays.toString(args));
        if (generateTa && validParms && !helpRequested && data != null) {
            DriveScan.initializeProgressIndicator(_projectFiles, profiles, binaryLocations, configDetected, configSuccess, noProgressIndicator, outputDir, saveTAScanStatusToJson);
        }
        return data;
    }

    private static boolean processApplicationsFile(boolean generateTa, ArrayList<String> includeApplications, ArrayList<String> excludeApplications, ArrayList<String> applicationsToProcess, String thisArg) {
        boolean validParms = true;
        if (generateTa) {
            if (includeApplications == null && excludeApplications == null) {
                File applicationsFile = new File(thisArg.substring(thisArg.indexOf(61) + 1));
                BufferedReader br = null;
                try {
                    String line;
                    br = new BufferedReader(new FileReader(applicationsFile));
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).isEmpty()) continue;
                        String[] apps = line.trim().split("\\s*,+\\s*,*\\s*");
                        applicationsToProcess.addAll(Arrays.asList(apps));
                    }
                    br.close();
                }
                catch (IOException e) {
                    validParms = false;
                    System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid"), thisArg.substring(thisArg.indexOf(61) + 1), thisArg.substring(0, thisArg.indexOf(61))));
                }
            } else {
                validParms = false;
                System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Include_Exclude_Apps"), new Object[0]));
            }
        } else {
            validParms = false;
            System.out.println("SEVERE: " + Messages.getFormattedMessage(Messages.getString("DriveScan_TA_Required"), thisArg.substring(0, thisArg.indexOf(61))));
        }
        return validParms;
    }

    private static boolean isDeprecatedJavaVersion(String thisArg) {
        boolean isDeprecated = false;
        String[] deprecatedVersions = com.ibm.ws.report.binary.utilities.Constants.TARGET_JAVA_DEPRECATED_PARM;
        for (int i = 0; i < deprecatedVersions.length; ++i) {
            if (!thisArg.equals(deprecatedVersions[i])) continue;
            isDeprecated = true;
        }
        return isDeprecated;
    }

    private static String getTargetJavaEELoggingString(boolean targetJakartaEEUsed, boolean includeValue, int targetJavaEENum) {
        String returnValue = targetJakartaEEUsed ? "--targetJakartaEE" : "--targetJavaEE";
        if (includeValue) {
            returnValue = returnValue + "=ee" + targetJavaEENum;
        }
        return returnValue;
    }

    private static String getSourceJavaEELoggingString(boolean sourceJakartaEEUsed, boolean includeValue, int sourceJavaEENum) {
        String returnValue = sourceJakartaEEUsed ? "--sourceJakartaEE" : "--sourceJavaEE";
        if (includeValue) {
            returnValue = returnValue + "=ee" + sourceJavaEENum;
        }
        return returnValue;
    }

    public static boolean isValidTAOption(String option, List<String> profiles) {
        boolean supported = true;
        if (option.equals("--coreEdition") || option.equals("--baseEdition") || option.equals("--ndEdition") || option.equals("--zosEdition") || option.equals("--classic") || option.equals("--traditional") || option.equals("--libertyProfile") || option.equals("--liberty") || option.startsWith("--targetCloud=") || option.startsWith("--targetJavaEE=") || option.startsWith("--targetJakartaEE=") || option.startsWith("--sourceJavaEE=") || option.startsWith("--sourceJakartaEE=") || option.startsWith("--format") || option.startsWith("--sharedLibraries=") || option.equals("--userRulesOnly") || option.startsWith("--configLocation") || option.equals("--includeSensitiveData")) {
            supported = false;
        } else if (profiles != null && !profiles.isEmpty() && (option.startsWith("--sourceAppServer=") || option.startsWith("--sourceJava="))) {
            supported = false;
        }
        return supported;
    }

    private static String removeExtension(String outputDirPath) {
        return outputDirPath.substring(0, outputDirPath.lastIndexOf("."));
    }

    private static String convertFileName(boolean inputIsDirectory, String fileName) {
        if (inputIsDirectory && _projectFiles.size() == 1) {
            String preFileName = _projectNames.get(0);
            preFileName = preFileName.replace('\\', '/');
            int indexOfSlash = preFileName.lastIndexOf(47);
            preFileName = preFileName.substring(indexOfSlash + 1, preFileName.length());
            fileName = fileName.replaceFirst(".*(?=_(server\\.xml|wsadmin\\.py|InventoryReport\\..*))", preFileName);
        }
        return fileName;
    }

    private static boolean isRuleLocationValid(File location) {
        File[] matchingFiles = location.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name2) {
                return this.isListFile(new File(dir.getAbsolutePath() + File.separator + name2));
            }

            public boolean isListFile(File ruleListFile) {
                boolean usedSchema;
                boolean rootNodeIsRules;
                block7: {
                    rootNodeIsRules = false;
                    usedSchema = false;
                    String fileName = ruleListFile.getName();
                    if (fileName.endsWith(".xml")) {
                        if (ruleListFile.length() > 0L) {
                            FileInputStream xmlFile = null;
                            try {
                                String xmlbsValue;
                                NamedNodeMap rulesAttrs;
                                Node xmlbsNode;
                                xmlFile = new FileInputStream(ruleListFile);
                                Document xmlDoc = FileHelper.getParsedDocument(xmlFile);
                                if (xmlDoc == null) break block7;
                                Element rootEl = xmlDoc.getDocumentElement();
                                if (rootEl.getNodeName().equals("rules")) {
                                    rootNodeIsRules = true;
                                }
                                if ((xmlbsNode = (rulesAttrs = rootEl.getAttributes()).getNamedItem("xmlns")) != null && "http://websphere.ibm.com/xml/ns/wamt/binary-scanner-rule-list".equals(xmlbsValue = xmlbsNode.getNodeValue())) {
                                    usedSchema = true;
                                }
                            }
                            catch (Exception e) {
                                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Parse_Exception"), ruleListFile.getAbsolutePath(), e.toString()));
                                _foundInvalidRule = true;
                            }
                        } else {
                            ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScan_Empty_XML_File"), ruleListFile.getAbsolutePath()));
                        }
                    }
                }
                return rootNodeIsRules || usedSchema;
            }
        });
        if (!_foundInvalidRule && matchingFiles != null && matchingFiles.length > 0) {
            _ruleXmlFiles = matchingFiles;
            return true;
        }
        return false;
    }

    private static void pruneBinariesExceptEARsandWARs() {
        Iterator<File> it = _projectFiles.iterator();
        _projectNames.clear();
        while (it.hasNext()) {
            File nextFile = it.next();
            if (com.ibm.ws.report.binary.utilities.Constants.APP_EXTENSION_REGEX.matcher(nextFile.getName()).matches()) {
                _projectNames.add(ReportUtility.filterUppercaseFileExtension(DriveScan.getFileName(nextFile)));
                continue;
            }
            it.remove();
            _mapOfAppsToProfiles.remove(nextFile);
        }
    }

    private static void pruneBinariesExceptEARsWARsJARs() {
        Iterator<File> it = _projectFiles.iterator();
        _projectNames.clear();
        while (it.hasNext()) {
            File nextFile = it.next();
            if (com.ibm.ws.report.binary.utilities.Constants.EAR_WAR_JAR_EXTENSION_REGEX.matcher(nextFile.getName()).matches() && !com.ibm.ws.report.binary.utilities.Constants.BINARY_SCANNER_REGEX.matcher(nextFile.getName()).matches()) {
                _projectNames.add(ReportUtility.filterUppercaseFileExtension(DriveScan.getFileName(nextFile)));
                continue;
            }
            it.remove();
            _mapOfAppsToProfiles.remove(nextFile);
        }
    }

    private static void pruneBinariesExceptArchives() {
        Iterator<File> it = _projectFiles.iterator();
        _projectNames.clear();
        while (it.hasNext()) {
            File nextFile = it.next();
            if (com.ibm.ws.report.binary.utilities.Constants.J2EE_ARCHIVE_EXTENSION_REGEX.matcher(nextFile.getName()).matches()) {
                _projectNames.add(ReportUtility.filterUppercaseFileExtension(DriveScan.getFileName(nextFile)));
                continue;
            }
            it.remove();
            _mapOfAppsToProfiles.remove(nextFile);
        }
    }

    public ConfigManager getConfigManager(File app) {
        File configDir;
        ConfigManager configMgr = null;
        Map<File, File> appToConfigDir = _data.getAppToConfigDir();
        File file = configDir = appToConfigDir != null ? appToConfigDir.get(app) : null;
        if (configDir != null) {
            try {
                configMgr = ConfigManagerFactory.getConfigManager(configDir.getAbsolutePath());
            }
            catch (Exception e) {
                if (ReportUtility.isDebug()) {
                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error_Log"), app.getName()), e);
                }
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error"), app.getName(), e.getMessage()));
            }
        }
        return configMgr;
    }

    private static boolean containsEbaOrCba() {
        for (File nextFile : _projectFiles) {
            if (!com.ibm.ws.report.binary.utilities.Constants.EBA_CBA_EXTENSION_REGEX.matcher(nextFile.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    public void detectSharedLibraries(TargetConfig appConfig, File profileDir) {
        Set<String> sharedLibrariesFoundByConfig;
        if (appConfig != null && (sharedLibrariesFoundByConfig = appConfig.getLibraryPaths()) != null && !sharedLibrariesFoundByConfig.isEmpty()) {
            if (_data.detectSharedLibraries()) {
                for (String path : sharedLibrariesFoundByConfig) {
                    File file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(profileDir.getAbsoluteFile() + File.separator + path);
                    }
                    this.addSharedLibraries(file);
                }
            } else {
                ReportUtility.logger.get().log(Level.INFO, Messages.getString("DriveScan_Shared_Libraries_Found"));
            }
        }
    }

    public Set<File> addSharedLibraries(File library) {
        HashSet<File> addedLibraries = new HashSet<File>();
        String path = library.getAbsolutePath();
        if (library.isDirectory()) {
            DriveScan.addAllSharedBinaryFilesForDirectory(library, true, 0, addedLibraries);
        } else if (library.isFile()) {
            if (path.endsWith(".jar")) {
                if (_data != null && _data.isGenerateTA()) {
                    _tempSharedLibraryFiles.add(library);
                } else {
                    _sharedLibraryFiles.add(library);
                }
                addedLibraries.add(library);
                ReportUtility.logger.get().log(Level.FINEST, "Added binary shared libary file: " + library.getAbsolutePath());
            } else if (com.ibm.ws.report.binary.utilities.Constants.SUPPORTED_SHARED_LIBRARY_LOOSE_FILES.matcher(path).matches()) {
                if (_data != null && _data.isGenerateTA()) {
                    _tempSharedLibraryFiles.add(library);
                } else {
                    _sharedLibraryFiles.add(library);
                }
                addedLibraries.add(library);
                ReportUtility.logger.get().log(Level.FINEST, "Added loose shared libary file: " + library.getAbsolutePath());
            }
        } else {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_File_Does_Not_Exist"), library.getAbsolutePath()));
            return null;
        }
        return addedLibraries;
    }

    protected static String getFileName(File fileProcessed) {
        String fileName = null;
        try {
            fileName = fileProcessed.getCanonicalPath();
        }
        catch (IOException e) {
            fileName = fileProcessed.getAbsolutePath();
        }
        fileName = fileName.replace("\\", "/");
        return fileName;
    }

    private static void printMigrationUsage() {
        System.out.println();
        System.out.println(Messages.getString("DriveScan_usage"));
        System.out.println(Messages.getString("DriveScan_usage_all_details_action"));
    }

    private static void printInventoryUsage() {
        System.out.println();
        System.out.println(Messages.getString("DriveScan_usage"));
        System.out.println(Messages.getString("DriveScan_usage_inventory_action"));
    }

    private static void printGenerateConfigUsage() {
        System.out.println();
        System.out.println(Messages.getString("DriveScan_usage"));
        System.out.println(Messages.getString("DriveScan_usage_generateConfig_action"));
    }

    private static void printEvaluateApplicationUsage() {
        System.out.println();
        System.out.println(Messages.getString("DriveScan_usage"));
        System.out.println(Messages.getString("DriveScan_usage_evaluate_application_action"));
    }

    private static void printAnalyzeMigrationDetailsUsage() {
        System.out.println();
        System.out.println(Messages.getString("DriveScan_usage"));
        System.out.println(Messages.getString("DriveScan_usage_analyze_migration_details_action"));
    }

    private static void printAnalyzeJavaSEMigrationDetailsUsage() {
        System.out.println();
        System.out.println(Messages.getString("DriveScan_usage"));
        System.out.println(Messages.getString("DriveScan_usage_analyzeJavaSE_migration_details_action"));
    }

    private static void printAllSeparateReportsUsage() {
        System.out.println();
        System.out.println(Messages.getString("DriveScan_usage"));
        System.out.println(Messages.getString("DriveScan_usage_all_separate_reports_action"));
    }

    private static void printTAUsage() {
        System.out.println();
        System.out.println(Messages.getString("DriveScan_usage"));
        System.out.println(Messages.getString("DriveScan_usage_ta_action"));
    }

    private static void printHelpUsage() {
        System.out.println();
        System.out.println(Messages.getString("DriveScan_usage"));
        System.out.println(Messages.getString("DriveScan_usage_help_action"));
    }

    private static void printVersionUsage() {
        System.out.println();
        System.out.println(Messages.getString("DriveScan_usage"));
        System.out.println(Messages.getString("DriveScan_usage_version_action"));
    }

    private static void printVersionInfo() {
        System.out.println(Messages.getFormattedMessage(Messages.getString("DriveScan_product_name"), "WebSphere Application Server Migration Toolkit for Application Binaries"));
        System.out.println(Messages.getFormattedMessage(Messages.getString("DriveScan_product_version"), "25.0.0.2"));
        System.out.println(Messages.getFormattedMessage(Messages.getString("DriveScan_build_id"), Constants.buildID));
    }

    private static void printMigrationHelp(String type, boolean showInternalOptions) {
        if ("analyze".equals(type)) {
            DriveScan.printAnalyzeMigrationDetailsUsage();
        } else if ("analyzeJavaSE".equals(type)) {
            DriveScan.printAnalyzeJavaSEMigrationDetailsUsage();
        } else if ("evaluate".equals(type)) {
            DriveScan.printEvaluateApplicationUsage();
        } else if ("inventory".equals(type)) {
            DriveScan.printInventoryUsage();
        } else if ("generateConfig".equals(type)) {
            DriveScan.printGenerateConfigUsage();
        } else if ("all-separate-reports".equals(type)) {
            DriveScan.printAllSeparateReportsUsage();
        } else if ("ta".equals(type)) {
            DriveScan.printTAUsage();
        } else if (type == null) {
            DriveScan.printMigrationUsage();
        }
        System.out.println();
        System.out.println(Messages.getString("DriveScan_binaryInputPath_key"));
        if ("inventory".equals(type) || "generateConfig".equals(type) || "all-separate-reports".equals(type) || type == null) {
            System.out.println(Messages.getString("DriveScan_binaryInputPath_inventory_desc"));
        } else if ("ta".equals(type)) {
            System.out.println(Messages.getString("DriveScan_binaryInputPath_ta_desc"));
        } else {
            System.out.println(Messages.getString("DriveScan_binaryInputPath_j2ee_desc"));
        }
        System.out.println();
        System.out.println(Messages.getString("DriveScan_desc_key"));
        if ("analyze".equals(type)) {
            System.out.println(Messages.getString("DriveScan_action_analyze_migration_details_desc"));
        } else if ("analyzeJavaSE".equals(type)) {
            System.out.println(Messages.getString("DriveScan_action_analyzeJavaSE_migration_details_desc"));
        } else if ("evaluate".equals(type)) {
            System.out.println(Messages.getString("DriveScan_action_evaluate_application_desc"));
        } else if ("inventory".equals(type)) {
            System.out.println(Messages.getString("DriveScan_action_inventory_desc"));
        } else if ("generateConfig".equals(type)) {
            System.out.println(Messages.getString("DriveScan_action_generateConfig_application_desc"));
        } else if ("all-separate-reports".equals(type)) {
            System.out.println(Messages.getString("DriveScan_action_allSeparateReports_migration_details_desc"));
        } else if ("ta".equals(type)) {
            System.out.println(Messages.getString("DriveScan_action_ta_desc"));
        } else if (type == null) {
            System.out.println(Messages.getString("DriveScan_action_migration_details_desc"));
        }
        if ("analyze".equals(type) || type == null || "all-separate-reports".equals(type)) {
            System.out.println();
            System.out.println(Messages.getString("DriveScan_appserver_option_key"));
            System.out.println(Messages.getString("DriveScan_appserver_option_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_appserver_source_key"));
            System.out.println(Messages.getString("DriveScan_appserver_source_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_appserver_target_key"));
            System.out.println(Messages.getString("DriveScan_appserver_target_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_cloud_target_key"));
            System.out.println(Messages.getString("DriveScan_cloud_target_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_java_option_key"));
            System.out.println(Messages.getString("DriveScan_java_option_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_java_source_key"));
            System.out.println(Messages.getString("DriveScan_java_source_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_java_target_key"));
            System.out.println(Messages.getString("DriveScan_java_target_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_javaee_source_key"));
            System.out.println(Messages.getString("DriveScan_javaee_source_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_jakartaee_source_key"));
            System.out.println(Messages.getString("DriveScan_jakartaee_source_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_javaee_target_key"));
            System.out.println(Messages.getString("DriveScan_javaee_target_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_jakartaee_target_key"));
            System.out.println(Messages.getString("DriveScan_jakartaee_target_desc"));
        }
        if ("analyzeJavaSE".equals(type)) {
            System.out.println();
            System.out.println(Messages.getString("DriveScan_java_option_key"));
            System.out.println(Messages.getString("DriveScan_java_se_only_option_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_java_source_key"));
            System.out.println(Messages.getString("DriveScan_java_source_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_java_target_key"));
            System.out.println(Messages.getString("DriveScan_java_target_desc"));
        }
        if ("evaluate".equals(type) || type == null || "all-separate-reports".equals(type)) {
            System.out.println();
            System.out.println(Messages.getString("DriveScan_edition_option_key"));
            System.out.println(Messages.getString("DriveScan_edition_option_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_edition_base_key"));
            System.out.println(Messages.getString("DriveScan_edition_base_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_edition_core_key"));
            System.out.println(Messages.getString("DriveScan_edition_core_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_edition_nd_key"));
            System.out.println(Messages.getString("DriveScan_edition_nd_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_edition_zos_key"));
            System.out.println(Messages.getString("DriveScan_edition_zos_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_profile_option_key"));
            System.out.println(Messages.getString("DriveScan_profile_option_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_profile_liberty_key"));
            System.out.println(Messages.getString("DriveScan_profile_liberty_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_profile_full_key"));
            System.out.println(Messages.getString("DriveScan_profile_full_desc"));
        }
        if ("generateConfig".equals(type)) {
            System.out.println();
            System.out.println(Messages.getString("DriveScan_appserver_source_key"));
            System.out.println(Messages.getString("DriveScan_appserver_source_generateConfig_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_appserver_target_key"));
            System.out.println(Messages.getString("DriveScan_appserver_target_generateConfig_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_javaee_target_key"));
            System.out.println(Messages.getString("DriveScan_javaee_target_generateConfig_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_jakartaee_target_key"));
            System.out.println(Messages.getString("DriveScan_jakartaee_target_generateConfig_desc"));
        } else if ("ta".equals(type)) {
            System.out.println();
            System.out.println(Messages.getString("DriveScan_ta_profile_key"));
            System.out.println(Messages.getString("DriveScan_ta_profile_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_ta_all_profiles_key"));
            System.out.println(Messages.getString("DriveScan_ta_all_profiles_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_appserver_option_key"));
            System.out.println(Messages.getString("DriveScan_appserver_option_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_ta_appserver_source_key"));
            System.out.println(Messages.getString("DriveScan_ta_appserver_source_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_ta_appserver_target_key"));
            System.out.println(Messages.getString("DriveScan_ta_appserver_target_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_java_option_key"));
            System.out.println(Messages.getString("DriveScan_java_option_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_java_source_key"));
            System.out.println(Messages.getString("DriveScan_ta_java_source_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_java_target_key"));
            System.out.println(Messages.getString("DriveScan_java_target_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_output_option_key"));
            System.out.println(Messages.getString("DriveScan_output_option_ta_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_clean_key"));
            System.out.println(Messages.getString("DriveScan_clean_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_include_applications_key"));
            System.out.println(Messages.getString("DriveScan_include_applications_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_include_applications_file_key"));
            System.out.println(Messages.getString("DriveScan_include_applications_file_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_exclude_applications_key"));
            System.out.println(Messages.getString("DriveScan_exclude_applications_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_exclude_applications_file_key"));
            System.out.println(Messages.getString("DriveScan_exclude_applications_file_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_no_progress_indicator_key"));
            System.out.println(Messages.getString("DriveScan_no_progress_indicator_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_stop_on_missing_binary_key"));
            System.out.println(Messages.getString("DriveScan_stop_on_missing_binary_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_stop_on_missing_shared_library_key"));
            System.out.println(Messages.getString("DriveScan_stop_on_missing_shared_library_desc"));
        } else {
            System.out.println();
            System.out.println(Messages.getString("DriveScan_output_option_key"));
            System.out.println(Messages.getString("DriveScan_output_option_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_output_format_key"));
            System.out.println(Messages.getString("DriveScan_output_format_desc"));
        }
        System.out.println();
        if ("ta".equals(type)) {
            System.out.println(Messages.getString("DriveScan_output_ta_key"));
        } else {
            System.out.println(Messages.getString("DriveScan_output_key"));
        }
        if ("ta".equals(type)) {
            System.out.println(Messages.getString("DriveScan_output_ta_desc"));
        } else if ("analyze".equals(type)) {
            System.out.println(Messages.getString("DriveScan_output_detailed_analysis_desc"));
        } else if ("analyzeJavaSE".equals(type)) {
            System.out.println(Messages.getString("DriveScan_output_detailed_analysis_desc"));
        } else if ("evaluate".equals(type)) {
            System.out.println(Messages.getString("DriveScan_output_detailed_evaluate_desc"));
        } else if ("inventory".equals(type)) {
            System.out.println(Messages.getString("DriveScan_output_inventory_desc"));
        } else if ("generateConfig".equals(type)) {
            System.out.println(Messages.getString("DriveScan_output_generateConfig_desc"));
        } else if ("all-separate-reports".equals(type)) {
            System.out.println(Messages.getString("DriveScan_output_all_separate_reports_desc"));
        } else if (type == null) {
            System.out.println(Messages.getString("DriveScan_output_desc"));
        }
        System.out.println();
        System.out.println(Messages.getString("DriveScan_scan_option_key"));
        System.out.println(Messages.getString("DriveScan_scan_option_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_debug_key"));
        System.out.println(Messages.getString("DriveScan_debug_desc"));
        System.out.println();
        if (!"inventory".equals(type)) {
            System.out.println(Messages.getString("DriveScan_scan_excludepackages_key"));
            System.out.println(Messages.getString("DriveScan_scan_excludepackages_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_scan_includepackages_key"));
            System.out.println(Messages.getString("DriveScan_scan_includepackages_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_scan_all_key"));
            System.out.println(Messages.getString("DriveScan_scan_all_desc"));
        }
        System.out.println();
        System.out.println(Messages.getString("DriveScan_scan_excludefiles_key"));
        System.out.println(Messages.getString("DriveScan_scan_excludefiles_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_scannerPropertiesLocation_key"));
        System.out.println(Messages.getString("DriveScan_scannerPropertiesLocation_desc"));
        if ("inventory".equals(type) || "generateConfig".equals(type) || "all-separate-reports".equals(type) || type == null) {
            System.out.println();
            System.out.println(Messages.getString("DriveScan_sharedLibraries_key"));
            System.out.println(Messages.getString("DriveScan_sharedLibraries_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_detectSharedLibraries_key"));
            System.out.println(Messages.getString("DriveScan_detectSharedLibraries_desc"));
        }
        if ("analyze".equals(type) || "all-separate-reports".equals(type) || type == null || "ta".equals(type)) {
            System.out.println();
            System.out.println(Messages.getString("DriveScan_user_rule_location_key"));
            System.out.println(Messages.getString("DriveScan_user_rule_location_desc"));
            if (!"ta".equals(type)) {
                System.out.println();
                System.out.println(Messages.getString("DriveScan_user_rules_only_key"));
                System.out.println(Messages.getString("DriveScan_user_rules_only_desc"));
            }
            System.out.println();
            System.out.println(Messages.getString("DriveScan_max_user_rules_results_key"));
            System.out.println(Messages.getString("DriveScan_max_user_rules_results_desc"));
        }
        if ("analyze".equals(type)) {
            System.out.println();
            System.out.println(Messages.getString("DriveScan_config_location_key"));
            System.out.println(Messages.getString("DriveScan_config_location_desc"));
        }
        if ("generateConfig".equals(type) || "all-separate-reports".equals(type) || type == null) {
            System.out.println();
            System.out.println(Messages.getString("DriveScan_config_option_key"));
            System.out.println(Messages.getString("DriveScan_config_option_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_config_location_key"));
            System.out.println(Messages.getString("DriveScan_config_location_desc"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_include_sensitive_data_key"));
            System.out.println(Messages.getString("DriveScan_include_sensitive_data_desc"));
        }
        if (!"generateConfig".equals(type) && !"ta".equals(type)) {
            System.out.println();
            System.out.println(Messages.getString("DriveScan_nobrowser_key"));
            System.out.println(Messages.getString("DriveScan_nobrowser_desc"));
        }
        if (showInternalOptions) {
            System.out.println();
            System.out.println(Messages.getString("DriveScan_internal_option_key"));
            System.out.println();
            System.out.println(Messages.getString("DriveScan_scan_all_jars_key"));
            System.out.println(Messages.getString("DriveScan_scan_all_jars_desc"));
            if (type == null || "all-separate-reports".equals(type) || "analyze".equals(type) || "evaluate".equals(type)) {
                System.out.println();
                System.out.println(Messages.getString("DriveScan_loadAllRules_key"));
                System.out.println(Messages.getString("DriveScan_loadAllRules_desc"));
            }
            if (type == null || "all-separate-reports".equals(type) || "analyze".equals(type)) {
                System.out.println();
                System.out.println(Messages.getString("DriveScan_showAllHelp_key"));
                System.out.println(Messages.getString("DriveScan_showAllHelp_desc"));
                System.out.println();
                System.out.println(Messages.getString("DriveScan_includeHelpLocation_key"));
                System.out.println(Messages.getString("DriveScan_includeHelpLocation_desc"));
            }
            if (type == null || "all-separate-reports".equals(type) || "generateConfig".equals(type)) {
                System.out.println();
                System.out.println(Messages.getString("DriveScan_migrateAll_key"));
                System.out.println(Messages.getString("DriveScan_migrateAll_desc"));
            }
            if (type == null || "ta".equals(type)) {
                System.out.println();
                System.out.println(Messages.getString("DriveScan_save_ta_scan_status_to_json_key"));
                System.out.println(Messages.getString("DriveScan_save_ta_scan_status_to_json_desc"));
                System.out.println();
                System.out.println(Messages.getString("DriveScan_delete_key"));
                System.out.println(Messages.getString("DriveScan_delete_desc"));
                System.out.println();
                System.out.println(Messages.getString("DriveScan_ta_dc_key"));
                System.out.println(Messages.getString("DriveScan_ta_dc_desc"));
            }
        }
    }

    private static void printHelpHelp() {
        DriveScan.printHelpUsage();
        System.out.println();
        System.out.println(Messages.getString("DriveScan_desc_key"));
        System.out.println(Messages.getString("DriveScan_action_help_desc"));
        System.out.println();
    }

    private static void printVersionHelp() {
        DriveScan.printVersionUsage();
        System.out.println();
        System.out.println(Messages.getString("DriveScan_desc_key"));
        System.out.println(Messages.getString("DriveScan_action_version_desc"));
        System.out.println();
    }

    private static void printHelp() {
        DriveScan.printUsage();
        System.out.println();
        System.out.println(Messages.getString("DriveScan_binaryInputPath_key"));
        System.out.println(Messages.getString("DriveScan_binaryInputPath_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_action_key"));
        System.out.println(Messages.getString("DriveScan_action_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_action_migration_details_key"));
        System.out.println(Messages.getString("DriveScan_action_migration_details_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_action_ta_key"));
        System.out.println(Messages.getString("DriveScan_action_ta_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_action_analyze_migration_details_key"));
        System.out.println(Messages.getString("DriveScan_action_analyze_migration_details_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_action_analyzeJavaSE_migration_details_key"));
        System.out.println(Messages.getString("DriveScan_action_analyzeJavaSE_migration_details_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_action_evaluate_application_key"));
        System.out.println(Messages.getString("DriveScan_action_evaluate_application_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_action_generateConfig_application_key"));
        System.out.println(Messages.getString("DriveScan_action_generateConfig_application_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_action_inventory_key"));
        System.out.println(Messages.getString("DriveScan_action_inventory_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_action_allSeparateReports_migration_details_key"));
        System.out.println(Messages.getString("DriveScan_action_allSeparateReports_migration_details_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_action_help_key"));
        System.out.println(Messages.getString("DriveScan_action_help_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_action_version_key"));
        System.out.println(Messages.getString("DriveScan_action_version_desc"));
        System.out.println();
        System.out.println(Messages.getString("DriveScan_options_key"));
        System.out.println(Messages.getString("DriveScan_options_desc"));
        System.out.println();
    }

    private static void printUsage() {
        System.out.println();
        System.out.println(Messages.getString("DriveScan_briefUsage"));
    }

    private static void printOptionsInfo(ReportInputData.JavaVersion defaultTargetJava, ReportInputData.AppServer targetAppServer) {
        if (defaultTargetJava != null && targetAppServer != null) {
            JSONArray optionsArray = new JSONArray();
            optionsArray.add(DriveScan.buildTextOptionJSONObject("includePackages", ""));
            optionsArray.add(DriveScan.buildTextOptionJSONObject("excludePackages", "ch.qos,com.cloudant,com.cognos,com.fasterxml,com.filenet,com.ibatis,com.ibm,com.informix,com.lowagie,com.mchange,com.meterware,com.microsoft,com.mongodb,com.mysql,com.sun,com.sybase,filenet,freemarker,groovy,jakarta,java,javax,net,oracle,org,sqlj,sun,twitter4j,_ibmjsp"));
            String defaultJava = defaultTargetJava.getTargetOption().replaceAll("--targetJava=", "");
            OrderedJSONObject javaVersionValues = new OrderedJSONObject();
            EnumSet<ReportInputData.JavaVersion> supportedJavaVersions = targetAppServer.getSupportedTargetJavaVersions();
            for (ReportInputData.JavaVersion version : supportedJavaVersions) {
                String supportedJava = version.getTargetOption().replaceAll("--targetJava=", "");
                javaVersionValues.put(supportedJava, Messages.getString("DriveScan_java_target_" + supportedJava));
            }
            optionsArray.add(DriveScan.buildSelectOptionJSONObject("targetJava", defaultJava, javaVersionValues));
            System.out.println(optionsArray);
        } else {
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getString("DriveScan_Parm_Options_Failed_to_Run"));
        }
    }

    private static OrderedJSONObject buildTextOptionJSONObject(String optionName, String optionDefaultValue) {
        OrderedJSONObject option = new OrderedJSONObject();
        option.put("name", optionName);
        option.put("type", "text");
        option.put("default", optionDefaultValue);
        return option;
    }

    private static OrderedJSONObject buildSelectOptionJSONObject(String optionName, String optionDefaultValue, OrderedJSONObject optionChoicesValue) {
        OrderedJSONObject option = new OrderedJSONObject();
        option.put("name", optionName);
        option.put("type", "select");
        option.put("default", optionDefaultValue);
        option.put("choices", optionChoicesValue);
        return option;
    }

    public static void addAllSharedBinaryFilesForDirectory(File dir) {
        DriveScan.addAllSharedBinaryFilesForDirectory(dir, false);
    }

    public static void addAllSharedBinaryFilesForDirectory(File dir, boolean supportLooseFiles) {
        DriveScan.addAllSharedBinaryFilesForDirectory(dir, supportLooseFiles, 0);
    }

    public static void addAllSharedBinaryFilesForDirectory(File dir, boolean supportLooseFiles, int level) {
        DriveScan.addAllSharedBinaryFilesForDirectory(dir, supportLooseFiles, 0, null);
    }

    public static void addAllSharedBinaryFilesForDirectory(File dir, final boolean supportLooseFiles, int level, Set<File> addedLibraries) {
        if (_data != null && _data.isGenerateTA() && level > 0) {
            return;
        }
        ReportUtility.logger.get().log(Level.FINE, "Add binary files for directory: " + dir.getAbsolutePath());
        File[] dirContents = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String thisFileName = file.getName().toLowerCase();
                boolean isValidFileType = thisFileName.endsWith(".jar");
                isValidFileType = !supportLooseFiles ? isValidFileType : isValidFileType || com.ibm.ws.report.binary.utilities.Constants.SUPPORTED_SHARED_LIBRARY_LOOSE_FILES.matcher(thisFileName).matches();
                return file.isDirectory() || file.isFile() && isValidFileType;
            }
        });
        if (dirContents != null) {
            for (File nextFile : dirContents) {
                if (nextFile.isDirectory()) {
                    DriveScan.addAllSharedBinaryFilesForDirectory(nextFile, supportLooseFiles, level + 1, addedLibraries);
                    continue;
                }
                String realPath = DriveScan.addRealFileToCollectionAndReturnRealPath(nextFile, _data != null && _data.isGenerateTA() ? _tempSharedLibraryFiles : _sharedLibraryFiles, addedLibraries);
                if (realPath.endsWith(".jar")) {
                    if (!supportLooseFiles) {
                        _applicationNames.add(ReportUtility.filterUppercaseFileExtension(realPath));
                    }
                    ReportUtility.logger.get().log(Level.FINEST, "Added binary shared libary file: " + nextFile.getAbsolutePath());
                    continue;
                }
                ReportUtility.logger.get().log(Level.FINEST, "Added loose shared libary file: " + nextFile.getAbsolutePath());
            }
        }
    }

    public static File getRealFile(File file) {
        File realFile = null;
        try {
            realFile = file.toPath().toRealPath(new LinkOption[0]).toFile();
        }
        catch (IOException e) {
            realFile = file.getAbsoluteFile();
        }
        return realFile;
    }

    public static String getRealFilePath(File file) {
        return DriveScan.getRealFile(file).getAbsolutePath();
    }

    public static File[] getDirContent(File dir, final String profileName) {
        File[] dirContents = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String thisFileName = file.getName().toLowerCase();
                if (file.isDirectory() || file.isFile() && (file.getName().equals("MANIFEST.MF") || file.getName().equals("COMPOSITEBUNDLE.MF") || com.ibm.ws.report.binary.utilities.Constants.FILE_EXTENSION_REGEX.matcher(thisFileName).matches())) {
                    return profileName == null || file.isDirectory() || file.getAbsolutePath().contains(File.separator + "applications" + File.separator);
                }
                return _hiddenJunitFlag && file.isFile() && file.getName().endsWith(".mf");
            }
        });
        return dirContents;
    }

    public static void addAllBinaryFilesForDirectory(File dir, boolean includeSubDirs) {
        DriveScan.addAllBinaryFilesForDirectory(dir, null, null, includeSubDirs);
    }

    public static void addAllBinaryFilesForDirectory(File dir, List<String> projectNames, List<File> projectFiles, boolean includeSubDirs) {
        DriveScan.addAllBinaryFilesForDirectory(dir, projectNames, projectFiles, null, null, includeSubDirs, false, false);
    }

    public static void addAllBinaryFilesForDirectory(File dir, List<String> projectNames, List<File> projectFiles, String profileName, Map<File, String> mapOfAppsToProfiles, boolean includeSubDirs, boolean stopOnMissingBinary, boolean runFromTaDc) {
        DriveScan.addAllBinaryFilesForDirectory(dir, projectNames, projectFiles, profileName, mapOfAppsToProfiles, includeSubDirs, stopOnMissingBinary, runFromTaDc, new HashSet<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAllBinaryFilesForDirectory(File dir, List<String> projectNames, List<File> projectFiles, String profileName, Map<File, String> mapOfAppsToProfiles, boolean includeSubDirs, boolean stopOnMissingBinary, boolean runFromTaDc, Set<String> activeSymlinks) {
        boolean isApplicationDirectory;
        File[] dirContents;
        block25: {
            if (activeSymlinks.contains(dir.getAbsolutePath())) {
                return;
            }
            if (Files.isSymbolicLink(dir.toPath())) {
                activeSymlinks.add(dir.getAbsolutePath());
            }
            dir = DriveScan.getRealFile(dir);
            File editionPropFile = new File(dir.getAbsolutePath() + File.separator + "ibm-edition-metadata.props");
            dirContents = null;
            ReportUtility.logger.get().log(Level.FINEST, "Add binary files for directory: " + dir.getAbsolutePath());
            if (editionPropFile != null && editionPropFile.exists()) {
                try {
                    String baseName = dir.getName();
                    File appBinaryFile = new File(dir.getAbsolutePath() + File.separator + baseName);
                    try (Scanner scanner = new Scanner(editionPropFile);){
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine();
                            if (!line.contains("=ACTIVE") || !line.contains("-edition")) continue;
                            String editionName = line.substring(12, line.indexOf("=ACTIVE"));
                            int appNameIndex = baseName.lastIndexOf(46);
                            appBinaryFile = new File(dir.getAbsolutePath() + File.separator + baseName.substring(0, appNameIndex) + editionName + baseName.substring(appNameIndex));
                            break;
                        }
                    }
                    if (appBinaryFile.exists()) {
                        dirContents = new File[]{appBinaryFile};
                        break block25;
                    }
                    dirContents = DriveScan.getDirContent(dir, profileName);
                }
                catch (FileNotFoundException e) {
                    ReportUtility.logger.get().log(Level.FINE, "The file " + editionPropFile.getAbsolutePath() + " does not exist.", e);
                }
            } else {
                dirContents = DriveScan.getDirContent(dir, profileName);
            }
        }
        File parentDir = dir.getParentFile();
        boolean bl = isApplicationDirectory = profileName != null && parentDir.getName().equals("applications");
        if (dirContents != null) {
            boolean hasApp = false;
            for (File nextFile : dirContents) {
                if (nextFile.isDirectory()) {
                    if (isApplicationDirectory || !includeSubDirs) continue;
                    DriveScan.addAllBinaryFilesForDirectory(nextFile, projectNames, projectFiles, profileName, mapOfAppsToProfiles, true, stopOnMissingBinary, runFromTaDc, activeSymlinks);
                    continue;
                }
                String realPath = DriveScan.addRealFileToCollectionAndReturnRealPath(nextFile, projectFiles == null ? _projectFiles : projectFiles, true);
                if (realPath == null) continue;
                if (projectNames == null) {
                    String appName = ReportUtility.filterUppercaseFileExtension(realPath);
                    _applicationNames.add(appName);
                    if (profileName != null) {
                        mapOfAppsToProfiles.put(nextFile, profileName);
                    }
                } else {
                    projectNames.add(ReportUtility.filterUppercaseFileExtension(realPath));
                }
                hasApp = true;
                ReportUtility.logger.get().log(Level.FINEST, "Added binary file: " + nextFile.getAbsolutePath());
            }
            if (!hasApp && isApplicationDirectory && !DataCollectionHelper.isSystemApp(dir.getName())) {
                ArrayList<File> resultContainer = new ArrayList<File>();
                int returnCode = DataCollectionHelper.convertDirectoryToEar(dir, resultContainer, _mapOfProfilesToPaths.get(profileName), stopOnMissingBinary, runFromTaDc);
                if (!resultContainer.isEmpty()) {
                    File appFile = DriveScan.getRealFile((File)resultContainer.get(0));
                    appFile.deleteOnExit();
                    if (projectFiles == null) {
                        _projectFiles.add(appFile);
                    } else {
                        projectFiles.add(appFile);
                    }
                    _applicationNames.add(appFile.getAbsolutePath());
                    mapOfAppsToProfiles.put(appFile, profileName);
                } else {
                    _missingBinaries.add(dir.getName());
                }
                if (returnCode != 0) {
                    DriveScan.systemExitNoJunitSupport(returnCode);
                }
            }
        }
    }

    protected void setReturnCode(int rc) {
        if (this.returnCode == 0) {
            this.returnCode = rc;
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    protected static String addRealFileToCollectionAndReturnRealPath(File fileToAdd, Collection<File> collectionToAddTo) {
        return DriveScan.addRealFileToCollectionAndReturnRealPath(fileToAdd, collectionToAddTo, null, false);
    }

    protected static String addRealFileToCollectionAndReturnRealPath(File fileToAdd, Collection<File> collectionToAddTo, boolean preventDuplicates) {
        return DriveScan.addRealFileToCollectionAndReturnRealPath(fileToAdd, collectionToAddTo, null, preventDuplicates);
    }

    protected static String addRealFileToCollectionAndReturnRealPath(File fileToAdd, Collection<File> collectionToAddTo, Set<File> addedLibraries) {
        return DriveScan.addRealFileToCollectionAndReturnRealPath(fileToAdd, collectionToAddTo, addedLibraries, false);
    }

    protected static String addRealFileToCollectionAndReturnRealPath(File fileToAdd, Collection<File> collectionToAddTo, Set<File> addedLibraries, boolean preventDuplicates) {
        String absolutePath = fileToAdd.getAbsolutePath();
        String realPath = DriveScan.getFileName(fileToAdd);
        boolean duplicate = false;
        if (preventDuplicates) {
            HashSet<String> fileNames = new HashSet<String>();
            for (File file : collectionToAddTo) {
                fileNames.add(DriveScan.getFileName(file));
            }
            if (fileNames.contains(realPath)) {
                duplicate = true;
                realPath = null;
            }
        }
        if (!duplicate) {
            if (!absolutePath.startsWith(realPath)) {
                File realFile = new File(realPath);
                collectionToAddTo.add(realFile);
                if (addedLibraries != null) {
                    addedLibraries.add(realFile);
                }
            } else {
                collectionToAddTo.add(fileToAdd);
                if (addedLibraries != null) {
                    addedLibraries.add(fileToAdd);
                }
            }
        }
        return realPath;
    }

    public Map<String, List<String>> getRulesByType() {
        HashMap<String, List<String>> rulesByType = new HashMap<String, List<String>>();
        Map<String, Rule> rules = this.getRules();
        Set<String> keys = rules.keySet();
        ArrayList<String> fileRules = new ArrayList<String>();
        ArrayList<String> javaRules = new ArrayList<String>();
        ArrayList<String> jspRules = new ArrayList<String>();
        ArrayList<String> manifestRules = new ArrayList<String>();
        ArrayList<String> propertyRules = new ArrayList<String>();
        ArrayList<String> xmlRules = new ArrayList<String>();
        for (String key : keys) {
            Rule rule = rules.get(key);
            EnumSet<RuleType> ruleType = rule.getRuleTypes();
            String desc = rule.getRuleDescription();
            if (ruleType.contains((Object)RuleType.FileRule) && !fileRules.contains(desc)) {
                fileRules.add(desc);
            }
            if (ruleType.contains((Object)RuleType.JavaRule) && !javaRules.contains(desc)) {
                javaRules.add(desc);
            }
            if (ruleType.contains((Object)RuleType.JspRule) && !jspRules.contains(desc)) {
                jspRules.add(desc);
            }
            if (ruleType.contains((Object)RuleType.ManifestRule) && !manifestRules.contains(desc)) {
                manifestRules.add(desc);
            }
            if (ruleType.contains((Object)RuleType.PropertyRule) && !propertyRules.contains(desc)) {
                propertyRules.add(desc);
            }
            if (!ruleType.contains((Object)RuleType.XmlRule) || xmlRules.contains(desc)) continue;
            xmlRules.add(desc);
        }
        Collections.sort(fileRules);
        Collections.sort(javaRules);
        Collections.sort(jspRules);
        Collections.sort(manifestRules);
        Collections.sort(propertyRules);
        Collections.sort(xmlRules);
        rulesByType.put("file", fileRules);
        rulesByType.put("java", javaRules);
        rulesByType.put("jsp", jspRules);
        rulesByType.put("mf", manifestRules);
        rulesByType.put("property", propertyRules);
        rulesByType.put("xml", xmlRules);
        return rulesByType;
    }

    @Override
    public String getDefaultReportFileName(File app) {
        String subDir;
        String nameForFile = null;
        File outputDir = _data.getOutputDir();
        String outputDirPath = outputDir == null ? "" : DriveScan.getOutputDirPath(outputDir);
        String defaultReportName = "_" + this.getDefaultReportName();
        String dirPath = _data.getProjectDirPathNormalized(app.getAbsolutePath());
        String appName = app.getName();
        nameForFile = this._isDirectoryWithMultipleApps ? ((subDir = ReportUtility.getSubDir(DriveScan.getFileName(app), dirPath, appName)) == null ? outputDirPath + appName + defaultReportName : outputDirPath + subDir.replaceAll("/", "_") + "_" + appName + defaultReportName) : outputDirPath + appName + defaultReportName;
        return nameForFile;
    }

    protected void filterJavaEERules(Map<String, List<DetailResult>> projectsToRulesFound, Map<String, Map<String, Map<String, List<String>>>> rulesAnalyzedByCategory, Set<String> allFeatures, ReportInputData.AppServer targetAppServer, ConfigFeatureVersionInfo cfvi, BinaryReportBuilder analyzeBuilder, Map<ReportInputData.JavaEEVersion, Set<String>> libertyJavaEEJakartaFeatures) {
        if (analyzeBuilder == null) {
            return;
        }
        List<Technology> technologies = analyzeBuilder._technologies.get((Object)targetAppServer);
        Set<String> allJavaEERulesId = this.getAllJavaEERulesId(technologies);
        Set<String> validJavaEERules = this.getValidJavaEERules(allFeatures, targetAppServer, cfvi, technologies, libertyJavaEEJakartaFeatures);
        Iterator<Map.Entry<String, Map<String, Map<String, List<String>>>>> parentCatIt = rulesAnalyzedByCategory.entrySet().iterator();
        while (parentCatIt.hasNext()) {
            Map<String, Map<String, List<String>>> parentCatRules = parentCatIt.next().getValue();
            Iterator<Map.Entry<String, Map<String, List<String>>>> childCatEntryIt = parentCatRules.entrySet().iterator();
            while (childCatEntryIt.hasNext()) {
                Map<String, List<String>> childCatRules = childCatEntryIt.next().getValue();
                Iterator<Map.Entry<String, List<String>>> typeToRulesIt = childCatRules.entrySet().iterator();
                while (typeToRulesIt.hasNext()) {
                    Map.Entry<String, List<String>> typeToRulesEntry = typeToRulesIt.next();
                    ArrayList ruleIdentifiers = new ArrayList(typeToRulesEntry.getValue());
                    Iterator ruleIdentifiersIt = ruleIdentifiers.iterator();
                    while (ruleIdentifiersIt.hasNext()) {
                        String ruleIdentifier = (String)ruleIdentifiersIt.next();
                        String ruleId = ruleIdentifier.substring(ruleIdentifier.lastIndexOf(61) + 1);
                        if (ruleId == null || !allJavaEERulesId.contains(ruleId) || validJavaEERules.contains(ruleId)) continue;
                        ruleIdentifiersIt.remove();
                    }
                    typeToRulesEntry.setValue(ruleIdentifiers);
                    if (!ruleIdentifiers.isEmpty()) continue;
                    typeToRulesIt.remove();
                }
                if (!childCatRules.isEmpty()) continue;
                childCatEntryIt.remove();
            }
            if (!parentCatRules.isEmpty()) continue;
            parentCatIt.remove();
        }
        for (List<DetailResult> rulesFound : projectsToRulesFound.values()) {
            Iterator<DetailResult> itr = rulesFound.iterator();
            while (itr.hasNext()) {
                DetailResult result = itr.next();
                if (!allJavaEERulesId.contains(result.getRuleName()) || validJavaEERules.contains(result.getRuleName())) continue;
                itr.remove();
            }
        }
    }

    private Set<String> getAllJavaEERulesId(List<Technology> technologies) {
        HashSet<String> ruleIds = new HashSet<String>();
        if (technologies != null) {
            for (Technology tech : technologies) {
                for (Set<String> report : tech.getReportToRuleIds().values()) {
                    ruleIds.addAll(report);
                }
            }
        }
        return ruleIds;
    }

    protected ConfigFeatureVersionInfo getConfigFeatureVersionInfo(ReportInputData.AppServer sourceAppServer, Map<String, TargetConfig> mapOfAppToTargetConfig) {
        ConfigFeatureVersionInfo cfvi = new ConfigFeatureVersionInfo();
        for (String key : mapOfAppToTargetConfig.keySet()) {
            if (cfvi.getLowestJpaVersion() == null) {
                cfvi.setLowestJpaVersion(mapOfAppToTargetConfig.get(key).getDeploymentEnvironment().getOldestJpaVersion());
                continue;
            }
            cfvi.setLowestJpaVersion(CommonUtilities.getOldestVersion(cfvi.getLowestJpaVersion(), mapOfAppToTargetConfig.get(key).getDeploymentEnvironment().getOldestJpaVersion(), false));
        }
        if (cfvi.getLowestJpaVersion() == null) {
            boolean configScanFoundJpa;
            boolean bl = configScanFoundJpa = !this.mapOfAppToTargetConfigIsEmpty(mapOfAppToTargetConfig);
            if (sourceAppServer == ReportInputData.AppServer.WAS90 && configScanFoundJpa) {
                cfvi.setLowestJpaVersion("jpa-2.1");
            } else {
                cfvi.setLowestJpaVersion("jpa-2.0");
                cfvi.setConfigScanned(false);
            }
        } else if (cfvi.getLowestJpaVersion().length() == 3) {
            cfvi.setLowestJpaVersion("jpa-" + cfvi.getLowestJpaVersion());
        }
        return cfvi;
    }

    protected boolean mapOfAppToTargetConfigIsEmpty(Map<String, TargetConfig> mapOfAppToTargetConfig) {
        if (mapOfAppToTargetConfig == null || mapOfAppToTargetConfig.isEmpty()) {
            return true;
        }
        for (String key : mapOfAppToTargetConfig.keySet()) {
            if (mapOfAppToTargetConfig.get(key) == null) continue;
            return false;
        }
        return true;
    }

    private Set<String> getValidJavaEERules(Set<String> features, ReportInputData.AppServer targetAppServer, ConfigFeatureVersionInfo cfvi, List<Technology> technologies, Map<ReportInputData.JavaEEVersion, Set<String>> libertyJavaEEJakartaFeatures) {
        HashSet<String> validJavaEERules = new HashSet<String>();
        if (technologies != null) {
            for (Technology tech : technologies) {
                if (!features.isEmpty() || targetAppServer == ReportInputData.AppServer.WAS90) {
                    validJavaEERules.addAll(tech.getRules(features, cfvi, libertyJavaEEJakartaFeatures));
                    continue;
                }
                validJavaEERules.addAll(tech.getDefaultRuleIds());
            }
        }
        return validJavaEERules;
    }

    public static String getOutputPath(File outputFile) {
        String outputPath = outputFile.getAbsolutePath();
        String outputPathNormalized = outputPath.replace("\\", "/");
        int indexOfFolder = outputPathNormalized.lastIndexOf(47);
        outputPath = outputPath.substring(0, indexOfFolder + 1);
        return outputPath;
    }

    protected static String getOutputDirPath(File outputDir) {
        String outputPath = outputDir.getAbsolutePath();
        if (!outputPath.matches(".*(/|\\\\)")) {
            outputPath = outputPath + File.separator;
        }
        return outputPath;
    }

    @Override
    public abstract Map<ReportInputData.OutputType, String> generateReport();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void migrateFilesForConfig(Map<String, String> filesToMigrate) throws IOException {
        ArrayList<String> failureList = new ArrayList<String>();
        if (filesToMigrate != null && !filesToMigrate.isEmpty()) {
            ReportUtility.logger.get().log(Level.INFO, Messages.getString("Config_Files_Migrated"));
            for (Map.Entry<String, String> entry : filesToMigrate.entrySet()) {
                File sourceFile = new File(entry.getValue());
                File desintationFile = new File(entry.getKey());
                FileInputStream inputStream = null;
                FileOutputStream outputStream = null;
                AbstractInterruptibleChannel source = null;
                AbstractInterruptibleChannel dest = null;
                try {
                    if (!desintationFile.exists()) {
                        desintationFile.createNewFile();
                    }
                    inputStream = new FileInputStream(sourceFile);
                    outputStream = new FileOutputStream(desintationFile);
                    source = inputStream.getChannel();
                    dest = outputStream.getChannel();
                    ((FileChannel)dest).transferFrom((ReadableByteChannel)((Object)source), 0L, ((FileChannel)source).size());
                }
                catch (Exception e) {
                    failureList.add(entry.getKey());
                    ReportUtility.logger.get().log(Level.FINE, "Unable to migrate file " + entry.getValue() + " to destination " + entry.getKey(), e);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (source != null) {
                        source.close();
                    }
                    if (dest != null) {
                        dest.close();
                    }
                }
            }
        }
        if (!failureList.isEmpty()) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Cannot_Migrate_File"), failureList));
        }
    }

    public static void pruneUserSpecifiedBinaries(List<String> includeApplications, List<String> excludeApplications) {
        try {
            ArrayList<String> appsToInclude = new ArrayList<String>();
            int i = 0;
            while (i < _projectFiles.size()) {
                String path = _projectFiles.get(i).getCanonicalPath();
                String appName = path.substring(path.lastIndexOf(File.separator) + 1);
                if (DriveScan.excludedApp(appName, includeApplications, excludeApplications)) {
                    _projectNames.remove(path);
                    _projectFiles.remove(i);
                    ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScan_TA_App_Excluded"), appName));
                    continue;
                }
                ++i;
                appsToInclude.add(appName);
            }
            if (includeApplications != null || excludeApplications != null) {
                ReportUtility.logger.get().log(Level.FINE, "The following applications will be scanned:" + ((Object)appsToInclude).toString());
            }
        }
        catch (Exception e) {
            if (includeApplications != null) {
                ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Error_Generic"), "--includeApplications", e.toString()));
            }
            ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Error_Generic"), "--excludeApplications", e.toString()));
        }
    }

    public static boolean excludedApp(String appName, List<String> includeApplications, List<String> excludeApplications) {
        String appNameWithoutExtension = appName.substring(0, appName.lastIndexOf("."));
        return includeApplications != null && !includeApplications.contains(appName) && !includeApplications.contains(appNameWithoutExtension) || excludeApplications != null && (excludeApplications.contains(appName) || excludeApplications.contains(appNameWithoutExtension));
    }

    public static void initializeProgressIndicator(List<File> apps, List<String> profiles, Set<File> binaryLocations, boolean configDetected, boolean configSuccess, boolean noProgressIndicator, File outputDir, boolean saveTAScanStatusToJson) {
        boolean outsideLocation;
        String outputDirPath = outputDir == null ? "" : DriveScan.getOutputDirPath(outputDir);
        cli = new CLI(Locale.getDefault(), !noProgressIndicator, outputDirPath, saveTAScanStatusToJson);
        _progressIndicatorActive = true;
        boolean bl = outsideLocation = profiles == null || profiles.isEmpty();
        if (outsideLocation) {
            cli.setIsOutsideLocation(true);
            cli.updateOutsideLocationSection(binaryLocations.iterator().next().getAbsolutePath());
        }
        if (configDetected && configSuccess) {
            cli.updateConfigFilesSection(CliConfigFilesSection.configEventStatus.COMPLETED);
        } else if (configDetected && !configSuccess) {
            cli.updateConfigFilesSection(CliConfigFilesSection.configEventStatus.FAILED);
        } else {
            cli.updateConfigFilesSection(CliConfigFilesSection.configEventStatus.NOT_REQUESTED);
        }
        cli.updateStatusSection(CliStatusSection.status.RUNNING);
    }

    public static void setProgressIndicatorActive(boolean isActive) {
        _progressIndicatorActive = isActive;
    }

    public static void systemExit(int returnCode, String junitMessage) throws Exception {
        if (ReportUtility.isTAScan() && !_delete) {
            DriveScan.writeTAScanResults(returnCode);
        }
        if (junitMessage == null) {
            junitMessage = "The binary scanner did not execute sucessfully. No JUnit message was provided.";
        }
        if (_hiddenJunitFlag && returnCode != 0) {
            throw new Exception(junitMessage);
        }
        if (!_hiddenJunitFlag) {
            System.exit(returnCode);
        }
    }

    public static void systemExitNoJunitSupport(int returnCode) {
        if (ReportUtility.isTAScan() && !_delete) {
            DriveScan.writeTAScanResults(returnCode);
        }
        System.exit(returnCode);
    }

    public static void writeTAScanResults(int returnCode) {
        File existingScanResultsJson = new File(_outputDir != null ? _outputDir.getAbsolutePath() + File.separator + "scan_results.json" : "scan_results.json");
        if (!existingScanResultsJson.exists()) {
            try {
                if (_outputDir != null && !_outputDir.exists()) {
                    _outputDir.mkdir();
                }
            }
            catch (Exception e) {
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getString("DriveScan_Parm_Output_Directory_Creation_Failed"));
            }
            ScanResult result = new ScanResult(new ArrayList<String>());
            result.setReturnCode(returnCode);
            result.writeToJsonFile(_outputDir != null ? _outputDir.getAbsolutePath() : "");
        }
    }

    public static void removeTAScanResults() {
        File existingScanResultsJson = new File(_outputDir != null ? _outputDir.getAbsolutePath() + File.separator + "scan_results.json" : "scan_results.json");
        if (existingScanResultsJson.exists()) {
            try {
                existingScanResultsJson.delete();
            }
            catch (Exception e) {
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_File_Deletion_Error"), existingScanResultsJson.getAbsolutePath(), e.toString()));
            }
        }
    }

    public static boolean validRuleIds(String ruleIds) {
        Pattern RULEIDS_VALIDATION_REGEX = Pattern.compile("([a-zA-Z0-9_]+\\s*,\\s*)*[a-zA-Z0-9_]+\\s*,?");
        Matcher m = RULEIDS_VALIDATION_REGEX.matcher(ruleIds);
        return m.find();
    }

    static {
        FILENAME_REGEX = Pattern.compile("(?!.*\\.(html|htm|json)$).*");
        FILENAME_WITH_EXTENSION_REGEX = Pattern.compile(".+\\.[a-zA-Z0-9]+$");
        ASM_PACKAGE = "com.ibm.ws.report.binary.asm.*";
        VALID_OUTPUT_FILE_EXTENSION = ".*\\.(?:html|htm|json|xml|py)$";
        _missingBinaries = new ArrayList<String>();
    }
}

