/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline;

import com.ibm.ws.report.analyze.AnalysisResults;
import com.ibm.ws.report.analyze.IdentifierObject;
import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.cmdline.DriveScan;
import com.ibm.ws.report.binary.cmdline.DriveScanGenerateConfig;
import com.ibm.ws.report.binary.cmdline.Messages;
import com.ibm.ws.report.binary.cmdline.utilities.ReportBuilderHelper;
import com.ibm.ws.report.binary.configutility.generator.LibertyServerXml;
import com.ibm.ws.report.binary.configutility.generator.TargetConfig;
import com.ibm.ws.report.binary.configutility.twas.ConfigManager;
import com.ibm.ws.report.binary.reader.BinaryReportReader;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.utilities.BinaryReportBuilder;
import com.ibm.ws.report.binary.utilities.ConfigFeatureVersionInfo;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.writer.ReportWriter;
import com.ibm.ws.report.writer.html.HTMLDetailAnalysisStreamlinedReportWriter;
import com.ibm.ws.report.writer.json.JSONDetailAnalysisReportWriter;
import com.ibm.ws.report.writer.text.TextDetailAnalysisReportWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class DriveScanDetailedAnalysis
extends DriveScan {
    DriveScanGenerateConfig driveScanGenerateConfig;

    public DriveScanDetailedAnalysis(ReportInputData data) {
        super(data);
    }

    @Override
    public BinaryReportReader getBinaryReportReader() {
        return this.getBinaryReportReader(null);
    }

    public BinaryReportReader getBinaryReportReader(Map<String, Map<String, IdentifierObject>> possibleIdentifierNames) {
        Map<String, Rule> myrules = this.getRules();
        if (myrules != null && !myrules.isEmpty()) {
            HashMap<ReportInputData.ReportType, Collection<Rule>> rules = new HashMap<ReportInputData.ReportType, Collection<Rule>>();
            rules.put(ReportInputData.ReportType.ANALYZE, myrules.values());
            if (_data.filterAnalysisRulesByFeatureList()) {
                BinaryReportBuilder featureList = ReportBuilderHelper.loadConfigRules(true);
                if (featureList._reportRules != null && !featureList._reportRules.isEmpty()) {
                    rules.put(ReportInputData.ReportType.GENERATE_CONFIG, featureList._reportRules.values());
                    _data.getReportTypes().add(ReportInputData.ReportType.GENERATE_CONFIG);
                    this.driveScanGenerateConfig = new DriveScanGenerateConfig(_data);
                }
            }
            this._reader = new BinaryReportReader(_data, rules, null, possibleIdentifierNames, null);
        }
        return this._reader;
    }

    @Override
    public Map<String, Rule> getRules() {
        if (this._rules == null) {
            this._builder = ReportBuilderHelper.loadAnalyzeRules(_data);
            this.setReturnCode(this._builder.getReturnCode());
            if (this._builder._foundInvalidRule) {
                return null;
            }
            this._rules = this._builder._reportRules;
        }
        return this._rules;
    }

    @Override
    public String getDefaultReportName() {
        return "AnalysisReport";
    }

    @Override
    public Map<ReportInputData.OutputType, String> generateReport() {
        EnumMap<ReportInputData.OutputType, String> resultMap = new EnumMap<ReportInputData.OutputType, String>(ReportInputData.OutputType.class);
        ArrayList<String> uniqueProjectNames = new ArrayList<String>(_data.getProjectNames());
        List<File> apps = _data.getProjectFiles();
        HashMap<String, Map<String, IdentifierObject>> possibleIdentifierNames = new HashMap<String, Map<String, IdentifierObject>>();
        HashMap<String, TargetConfig> mapOfAppToTargetConfig = new HashMap<String, TargetConfig>();
        for (File appFile : apps) {
            ConfigManager configMgr = this.getConfigManager(appFile);
            LibertyServerXml appConfig = null;
            String appName = appFile.getName();
            if (configMgr == null) continue;
            try {
                possibleIdentifierNames.put(appName, configMgr.getPossibleIdentifierNames());
                appConfig = new LibertyServerXml(configMgr, appName, null, false);
                mapOfAppToTargetConfig.put(appName, appConfig);
            }
            catch (Exception e) {
                ReportUtility.logger.get().log(Level.FINE, e.getMessage());
            }
        }
        BinaryReportReader reader = this.getBinaryReportReader(possibleIdentifierNames);
        if (reader != null) {
            reader.openFile();
            Map<String, List<DetailResult>> projectsToRulesFound = reader.getProjectsToDetailResults(ReportInputData.ReportType.ANALYZE);
            HashSet<String> allFeatures = new HashSet<String>();
            Map<ReportInputData.JavaEEVersion, Set<String>> libertyJavaEEJakartaFeatures = null;
            if (this.driveScanGenerateConfig != null) {
                for (File app : apps) {
                    HashSet<String> coreFeatures = new HashSet<String>();
                    HashSet<String> baseFeatures = new HashSet<String>();
                    boolean hasConflicts = this.driveScanGenerateConfig.findCorrectFeatureList(coreFeatures, baseFeatures, null, reader, app.getName());
                    libertyJavaEEJakartaFeatures = this.driveScanGenerateConfig.getLibertyJavaEEJakartaFeatures();
                    if (hasConflicts) continue;
                    allFeatures.addAll(this.driveScanGenerateConfig.getRuleSelectedFeatures());
                }
            }
            reader.closeFile();
            Map<String, Map<String, Map<String, List<String>>>> rulesAnalyzedByCategory = this._builder.getSortedRulesByCategories();
            if (!_data.showAllHelp() && _data.filterAnalysisRulesByFeatureList() || _data.showAllHelp() && projectsToRulesFound != null) {
                ConfigFeatureVersionInfo cfvi = this.getConfigFeatureVersionInfo(_data.getSourceAppServer(), mapOfAppToTargetConfig);
                cfvi.setTargetJavaEE(_data.getTargetJavaEE());
                this.filterJavaEERules(projectsToRulesFound, rulesAnalyzedByCategory, allFeatures, _data.getTargetAppServer(), cfvi, this._builder, libertyJavaEEJakartaFeatures);
            }
            List<String> connectivityRulesAnalyzed = this._builder.getSortedRulesAnalyzedForCategoriesStartingWithPrefix("appconversion.cloud.category.technology.connectivity");
            Map ruleSeverities = this._builder._severities;
            Map costs = this._builder._costs;
            Map<String, String> helpFileNames = this.getRuleHelp();
            ReportWriter writer = null;
            AnalysisResults analysisResults = new AnalysisResults(this._builder._descToRuleIds, projectsToRulesFound, rulesAnalyzedByCategory, connectivityRulesAnalyzed, ruleSeverities, helpFileNames, reader.getRulesFlagged(), _data.showAllHelp(), null, this._builder.getRulesToRecipesMap());
            for (ReportInputData.OutputType outputType : _data.getOutputType()) {
                switch (outputType) {
                    case HTML: {
                        writer = new HTMLDetailAnalysisStreamlinedReportWriter(uniqueProjectNames, _data.getSourceOptions(), _data.getTargetOptions(), _data.getScanOptionsDisplay(), rulesAnalyzedByCategory, false, analysisResults, connectivityRulesAnalyzed, _data.showAllHelp(), _data.loadAllRules(), _data.getMaxUserDefinedRuleResults(), costs);
                        break;
                    }
                    case JSON: {
                        writer = new JSONDetailAnalysisReportWriter(uniqueProjectNames, _data.getSourceOptions(), _data.getTargetOptions(), _data.getScanOptions(), projectsToRulesFound, rulesAnalyzedByCategory, false, helpFileNames, ruleSeverities, costs, _data.getApplicationNames(), this._builder.getCategoryNamesMappedToKeys(), _data.includeHelpLocation(), _data.getMaxUserDefinedRuleResults(), analysisResults);
                        break;
                    }
                    case TEXT: {
                        writer = new TextDetailAnalysisReportWriter(uniqueProjectNames, _data.getSourceOptions(), _data.getTargetOptions(), _data.getScanOptions(), projectsToRulesFound, rulesAnalyzedByCategory, false, helpFileNames, ruleSeverities, costs);
                    }
                }
                writer.writeReport();
                resultMap.put(outputType, writer.getResult());
            }
            if (analysisResults.containsAutomatedFix()) {
                System.out.println(analysisResults.getAnalysisResultCommandlineOutputString());
            }
        } else {
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getString("DriveScan_No_Rules_Found"));
            if (!_hiddenJunitFlag) {
                System.exit(2);
            }
        }
        return resultMap;
    }
}

