/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.cmdline;

import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.binary.cmdline.MergeFeaturesResult;
import com.ibm.websphere.binary.cmdline.exceptions.FeatureConflictException;
import com.ibm.websphere.binary.cmdline.exceptions.FeatureNotAvailableAtRequestedLevelException;
import com.ibm.websphere.binary.cmdline.exceptions.IllegalTargetCombinationException;
import com.ibm.websphere.binary.cmdline.exceptions.ProvidedFeatureConflictException;
import com.ibm.websphere.binary.cmdline.exceptions.RequiredFeatureModifiedException;
import com.ibm.websphere.binary.cmdline.exceptions.VersionlessFeatureException;
import com.ibm.ws.report.analyze.IdentifierObject;
import com.ibm.ws.report.binary.ReportInputData;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.cmdline.DriveScan;
import com.ibm.ws.report.binary.cmdline.Messages;
import com.ibm.ws.report.binary.cmdline.utilities.ReportBuilderHelper;
import com.ibm.ws.report.binary.configutility.generator.LibertyServerXml;
import com.ibm.ws.report.binary.configutility.generator.TargetConfig;
import com.ibm.ws.report.binary.configutility.generator.WSAdminScript;
import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveDataHelper;
import com.ibm.ws.report.binary.configutility.twas.ConfigManager;
import com.ibm.ws.report.binary.featurelist.FeatureListFeatureResolver;
import com.ibm.ws.report.binary.featurelist.FeatureUtil;
import com.ibm.ws.report.binary.reader.BinaryReportReader;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.utilities.JakartaJavaEEFeatureVersions;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.FileComparator;
import com.ibm.ws.report.utilities.FileHelper;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.writer.xml.ServerXmlWriter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DriveScanGenerateConfig
extends DriveScan {
    private static final String LIBERTY_CORE_FEATURES = "/resources/LibertyCoreAllFeatureList.xml";
    private static final String LIBERTY_BASE_FEATURES = "/resources/LibertyBaseAllFeatureList.xml";
    private static final String OPEN_LIBERTY_FEATURES = "/resources/OpenLibertyAllFeatureList.json";
    private static final String PACKAGE_TO_FEATURE_LIST_FILE = "/resources/APIPackagesToFeatureList.xml";
    private static final String[] xmlFileList = new String[]{".*\\.xml"};
    private static final String[] tags = new String[]{"feature"};
    private static final String attribute = "name";
    private static Map<String, Set<String>> libertyCoreFeatures = new HashMap<String, Set<String>>();
    private static Map<String, Set<String>> libertyBaseFeatures = new HashMap<String, Set<String>>();
    private static Set<String> openLibertyFeatures = new HashSet<String>();
    private static Map<ReportInputData.JavaEEVersion, Set<String>> libertyJavaEEFeatures = new HashMap<ReportInputData.JavaEEVersion, Set<String>>();
    private static Map<String, Set<String>> packageToFeaturesMap = new HashMap<String, Set<String>>();
    private static Map<String, Set<String>> featureToPackagesMap = new HashMap<String, Set<String>>();
    private static final Map<String, String> PREFERRED_JAR_FEATURE_MAP = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MP1_FEATURE = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MP1_2_FEATURE = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MP1_3_FEATURE = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MP2_FEATURE = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MP2_0_FEATURE = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MP2_1_FEATURE = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MP3_FEATURE = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MP3_0_FEATURE = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MP3_2_FEATURE = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MP4_FEATURE = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MP4_0_FEATURE = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MP5_FEATURE = new HashMap<String, String>();
    private static final Map<String, String> PREFERRED_MP6_FEATURE = new HashMap<String, String>();
    private static Set<String> STATIC_FEATURES = null;
    private static String PLATFORM = null;
    private static final Set<String> JAVAEE6_FEATURE_LIST = new HashSet<String>();
    private static final Set<String> FEATURES_NOT_IN_EASE = new HashSet<String>();
    private static final Set<String> JAVAEE7_TOLERATED_LIST = new HashSet<String>();
    private static final String JPA_FEATURE_PREFIX = "jpa";
    private static final String JPA_20_FEATURE = "jpa-2.0";
    private static final String EL_FEATURE_PREFIX = "el";
    private static final String JSP_2_2_FEATURE = "jsp-2.2";
    private static boolean loadListsCalled = false;
    private boolean sentAnalysisInfoMessage = false;
    private boolean featureAPIRunning = false;
    private FeatureConflictException featureConflictException = null;
    private final Set<String> modifiedRequiredFeatures = new HashSet<String>();
    private final Set<String> unavailableMPFeatures = new HashSet<String>();
    private final Set<String> unavailableEEFeatures = new HashSet<String>();
    private boolean addJsonbIfRestfulWS = false;
    private final Set<String> ruleSelectedFeatures = new HashSet<String>();
    private static final String IGNORE_JAVA_SE_PACKAGES = "javax\\..annotation(\\..*|$)";
    private boolean isLiberty = true;
    private static boolean isOpenLiberty;
    private static boolean isEASe;
    protected static Document _featureListResource;
    public List<String> conflictMessages = new ArrayList<String>();

    @Override
    public String getDefaultReportName() {
        return this.isLiberty ? "server" : "wsadmin";
    }

    public DriveScanGenerateConfig(ReportInputData data) {
        this(data, false);
    }

    public DriveScanGenerateConfig(ReportInputData data, boolean featureAPIRunning) {
        this(data, featureAPIRunning, null, null);
    }

    public DriveScanGenerateConfig(ReportInputData data, boolean featureAPIRunning, Set<String> staticFeatures, String platform) {
        super(data);
        boolean targetAppServerSpecified;
        STATIC_FEATURES = staticFeatures;
        PLATFORM = platform;
        this.featureAPIRunning = featureAPIRunning;
        if (featureAPIRunning) {
            this.featureConflictException = new FeatureConflictException();
        }
        boolean bl = targetAppServerSpecified = data != null && data.getTargetAppServer() != null;
        if (targetAppServerSpecified && data.getTargetAppServer().isWAS_Traditional()) {
            this.isLiberty = false;
        }
        if (targetAppServerSpecified && ReportInputData.AppServer.OPEN_LIBERTY == data.getTargetAppServer()) {
            if (!libertyJavaEEFeatures.isEmpty() && !isOpenLiberty) {
                this.clearLists();
            }
            isOpenLiberty = true;
            isEASe = false;
        } else if (targetAppServerSpecified && ReportInputData.AppServer.EASE == data.getTargetAppServer()) {
            if (!libertyJavaEEFeatures.isEmpty() && !isEASe) {
                this.clearLists();
            }
            isEASe = true;
            isOpenLiberty = false;
        } else {
            if (!libertyJavaEEFeatures.isEmpty() && (isOpenLiberty || isEASe)) {
                this.clearLists();
            }
            isOpenLiberty = false;
            isEASe = false;
        }
        if (!loadListsCalled) {
            DriveScanGenerateConfig.loadLists(this.getClass());
        }
    }

    public void clearLists() {
        libertyBaseFeatures.clear();
        libertyCoreFeatures.clear();
        openLibertyFeatures.clear();
        libertyJavaEEFeatures.clear();
        loadListsCalled = false;
        this.addJsonbIfRestfulWS = false;
    }

    public void setIsOpenLiberty(boolean isOpenLiberty) {
        DriveScanGenerateConfig.isOpenLiberty = isOpenLiberty;
    }

    public void setIsLibertyEASe(boolean isEASe) {
        DriveScanGenerateConfig.isEASe = isEASe;
    }

    public Set<String> runFeatureList() throws FeatureConflictException, RequiredFeatureModifiedException, ProvidedFeatureConflictException, FeatureNotAvailableAtRequestedLevelException {
        return this.runFeatureList(null);
    }

    public Map<String, Set<String>> mapFeaturePrefixes(Set<String> features, Set<String> unidentifiedFeatures) throws RuntimeException {
        HashMap<String, Set<String>> mapOfPrefixes = new HashMap<String, Set<String>>();
        for (String feature : features) {
            String prefix = DriveScanGenerateConfig.getPrefix(feature);
            boolean identified = true;
            identified = libertyCoreFeatures.containsKey(prefix) ? libertyCoreFeatures.get(prefix).contains(feature) : (libertyBaseFeatures.containsKey(prefix) ? libertyBaseFeatures.get(prefix).contains(feature) : false);
            if (!identified) {
                unidentifiedFeatures.add(feature);
                continue;
            }
            HashSet<String> versions = (HashSet<String>)mapOfPrefixes.get(prefix);
            if (versions == null) {
                versions = new HashSet<String>();
                mapOfPrefixes.put(prefix, versions);
            }
            versions.add(feature);
        }
        return mapOfPrefixes;
    }

    public MergeFeaturesResult mergeFeatures(Set<String> features) {
        HashSet<String> allFeatures = new HashSet<String>();
        HashSet<String> baseFeatures = new HashSet<String>();
        HashSet<String> coreFeatures = new HashSet<String>();
        HashSet<String> requiredFeatures = new HashSet<String>();
        HashSet<String> unidentifiedFeatures = new HashSet<String>();
        ArrayList<String> mergedFeatures = new ArrayList<String>();
        MergeFeaturesResult result = new MergeFeaturesResult(unidentifiedFeatures, allFeatures);
        List<String> possibleConflictMessages = result.getConflictMessages();
        ReportInputData.JavaEEVersion targetJavaEE = _data.getTargetJavaEE();
        Map<String, Set<String>> mapOfPrefixes = this.mapFeaturePrefixes(features, unidentifiedFeatures);
        for (Map.Entry<String, Set<String>> entry : mapOfPrefixes.entrySet()) {
            String feature;
            String prefix = entry.getKey();
            Set<String> versions = entry.getValue();
            if (versions.size() == 1) {
                feature = versions.iterator().next();
                if (libertyBaseFeatures.containsKey(prefix)) {
                    baseFeatures.add(feature);
                } else {
                    coreFeatures.add(feature);
                }
                if (targetJavaEE != null && DriveScanGenerateConfig.isEEFeature(prefix) && libertyJavaEEFeatures.get((Object)targetJavaEE).contains(feature)) {
                    requiredFeatures.add(feature);
                }
                mergedFeatures.add(feature);
                continue;
            }
            HashSet<String> unusedVersions = new HashSet<String>();
            unusedVersions.addAll(versions);
            if (targetJavaEE != null && DriveScanGenerateConfig.isEEFeature(prefix)) {
                feature = this.getPreferredJavaEEFeature(prefix, targetJavaEE);
                if (feature != null) {
                    requiredFeatures.add(feature);
                }
            } else if (prefix.startsWith("mp")) {
                if (targetJavaEE != null) {
                    feature = this.getPreferredMicroprofileFeatureFromEELevel(prefix, targetJavaEE);
                    if (feature != null) {
                        requiredFeatures.add(feature);
                    }
                } else {
                    feature = this.getLatestCompatibleMPVersionOfFeature(prefix, mergedFeatures);
                }
            } else {
                feature = DriveScanGenerateConfig.getLatestCompatibleVersionOfFeature(versions, mergedFeatures);
            }
            if (feature != null || (feature = DriveScanGenerateConfig.getLatestVersionOfFeature(versions)) == null) {
                // empty if block
            }
            unusedVersions.remove(feature);
            if (libertyBaseFeatures.containsKey(prefix)) {
                baseFeatures.add(feature);
            } else {
                coreFeatures.add(feature);
            }
            mergedFeatures.add(feature);
            String unusedMessage = unusedVersions.size() > 1 ? Messages.getString("DriveScan_Unused_Versions_Plural") : Messages.getString("DriveScan_Unused_Versions");
            String message = Messages.getFormattedMessage(unusedMessage, feature, prefix, unusedVersions);
            possibleConflictMessages.add(message);
        }
        if (this.checkForConflicts(coreFeatures, baseFeatures, requiredFeatures, new HashSet<String>())) {
            this.handleConflictMessages(coreFeatures, baseFeatures, null, possibleConflictMessages, "API");
        }
        possibleConflictMessages.addAll(this.conflictMessages);
        allFeatures.addAll(baseFeatures);
        allFeatures.addAll(coreFeatures);
        return result;
    }

    public static Set<String> getSetOfFeaturesExcludedInEASe() {
        return FEATURES_NOT_IN_EASE;
    }

    private static ReportInputData.MicroProfileVersion getRecommendedMicroProfileVersion(List<String> currentFeatures) {
        ReportInputData.MicroProfileVersion targetMicroProfile = null;
        for (String feature : currentFeatures) {
            if (!feature.startsWith("microProfile-")) continue;
            targetMicroProfile = ReportInputData.MicroProfileVersion.getMicroProfileVersionFromConvenienceFeature(feature);
            break;
        }
        return targetMicroProfile;
    }

    private static boolean isEEConvienceFeature(String feature) {
        return feature.startsWith("javaee-") || feature.startsWith("jakartaee-") || feature.startsWith("webProfile-") || feature.startsWith("javaeeClient-") || feature.startsWith("jakartaeeClient-");
    }

    private static boolean isEJBConvienceFeature(String feature) {
        return feature.equals("ejb-3.2") || feature.equals("enterpriseBeans-4.0");
    }

    private static ReportInputData.JavaEEVersion getRecommendedJavaEEVersion(List<String> currentFeatures) {
        ReportInputData.JavaEEVersion targetJavaEE = null;
        for (String feature : currentFeatures) {
            int index;
            if (DriveScanGenerateConfig.isEEConvienceFeature(feature)) {
                targetJavaEE = ReportInputData.JavaEEVersion.getJavaEEVersionFromConvenienceFeature(feature);
                break;
            }
            if (!DriveScanGenerateConfig.isEJBConvienceFeature(feature)) continue;
            ArrayList<ReportInputData.JavaEEVersion> versions = ReportInputData.JavaEEVersion.getJavaEEVersionsFromEjbConvenienceFeature(feature);
            Collections.sort(versions);
            targetJavaEE = versions.get(index);
            boolean foundASolution = false;
            for (index = versions.size() - 1; index >= 0 && !foundASolution; --index) {
                boolean worksWithOtherFeatures = true;
                for (String featureToCheck : currentFeatures) {
                    if (feature.equals(featureToCheck) || !DriveScanGenerateConfig.isEEFeature(featureToCheck) || libertyJavaEEFeatures.get((Object)versions.get(index)).contains(featureToCheck)) continue;
                    worksWithOtherFeatures = false;
                    break;
                }
                if (!worksWithOtherFeatures) continue;
                targetJavaEE = versions.get(index);
                foundASolution = true;
            }
        }
        return targetJavaEE;
    }

    private static void removeConvenienceFeatures(Set<String> allFeatures) {
        Iterator<String> i = allFeatures.iterator();
        while (i.hasNext()) {
            String feature = i.next();
            if (!feature.startsWith("microProfile-") && !DriveScanGenerateConfig.isEEConvienceFeature(feature) && !DriveScanGenerateConfig.isEJBConvienceFeature(feature)) continue;
            i.remove();
        }
    }

    public Set<String> runFeatureList(List<String> currentFeatures) throws FeatureConflictException, RequiredFeatureModifiedException, ProvidedFeatureConflictException, FeatureNotAvailableAtRequestedLevelException, VersionlessFeatureException {
        FeatureListFeatureResolver.ResolverResult result;
        if (currentFeatures != null && !currentFeatures.isEmpty()) {
            for (String feature : currentFeatures) {
                if (feature.contains("-")) continue;
                throw new VersionlessFeatureException(Messages.getFormattedMessage(Messages.getString("DriveScan_Versionless_Feature"), feature));
            }
            if (_data.getMicroProfile() == null) {
                _data.setMicroProfile(DriveScanGenerateConfig.getRecommendedMicroProfileVersion(currentFeatures));
            }
            if (_data.getTargetJavaEE() == null) {
                _data.setTargetJavaEE(DriveScanGenerateConfig.getRecommendedJavaEEVersion(currentFeatures));
            }
        }
        if (null != _data.getMicroProfile() && null != _data.getTargetJavaEE()) {
            Set<Object> mpAndEEConflicts = new HashSet();
            ArrayList<String> javaEEAndMPFeatures = new ArrayList<String>();
            javaEEAndMPFeatures.add(_data.getMicroProfile().getConvenienceFeature());
            javaEEAndMPFeatures.add(_data.getTargetJavaEE().getConvenienceFeature());
            result = FeatureListFeatureResolver.resolve(_featureListResource, javaEEAndMPFeatures);
            mpAndEEConflicts = result.getFeatureConflicts();
            if (!mpAndEEConflicts.isEmpty()) {
                String message = Messages.getFormattedMessage(Messages.getString("DriveScan_Parm_Option_Value_Not_Valid_Combination"), new Object[]{_data.getTargetJavaEE(), "targetJavaEE", _data.getMicroProfile(), "targetMicroProfile"});
                throw new IllegalTargetCombinationException(message, _data.getMicroProfile().toString(), _data.getTargetJavaEE().toString());
            }
        }
        Set<Object> conflicts = new HashSet();
        boolean hasConflicts = false;
        if (currentFeatures != null) {
            result = FeatureListFeatureResolver.resolve(_featureListResource, currentFeatures);
            conflicts = result.getFeatureConflicts();
        }
        if (conflicts.isEmpty()) {
            boolean specifiedJpa20 = null == currentFeatures ? false : currentFeatures.contains(JPA_20_FEATURE);
            boolean specifiedJdbcVersion = false;
            if (null != currentFeatures) {
                for (String feature : currentFeatures) {
                    if (!feature.contains("jdbc")) continue;
                    specifiedJdbcVersion = true;
                }
            }
            this.replacePreferredMPAndEEFeatures(currentFeatures);
            HashSet<String> allFeatures = new HashSet<String>();
            if (_data.getProjectFiles() != null && !_data.getProjectFiles().isEmpty()) {
                HashSet<String> coreFeatures = new HashSet<String>();
                HashSet<String> baseFeatures = new HashSet<String>();
                _data.setProjectData(_data.getProjectFiles(), _data.getProjectNames());
                HashMap<ReportInputData.ReportType, Collection<Rule>> rules = new HashMap<ReportInputData.ReportType, Collection<Rule>>();
                rules.put(ReportInputData.ReportType.GENERATE_CONFIG, this.getRules().values());
                BinaryReportReader brr = new BinaryReportReader(_data, rules, this.configRules, null, null, false);
                if (brr != null) {
                    brr.openFile();
                    TreeSet<String> configFeatures = new TreeSet<String>();
                    hasConflicts = this.findCorrectFeatureList(coreFeatures, baseFeatures, configFeatures, brr, "", currentFeatures);
                    if (brr.getDataStore().getDetectedJNDINameWithConfigRule() && !this.sentAnalysisInfoMessage) {
                        ReportUtility.logger.get().log(Level.INFO, Messages.getString("Generate_Config_Run_Analysis"));
                        this.sentAnalysisInfoMessage = true;
                    }
                    brr.closeFile();
                }
                allFeatures.addAll(coreFeatures);
                allFeatures.addAll(baseFeatures);
                if (this.featureAPIRunning && hasConflicts) {
                    this.featureConflictException.setFeatures(allFeatures);
                    throw this.featureConflictException;
                }
            } else if (currentFeatures != null) {
                allFeatures.addAll(currentFeatures);
            }
            if (!specifiedJdbcVersion && allFeatures.contains("jdbc-4.3")) {
                allFeatures.remove("jdbc-4.3");
                allFeatures.add("jdbc-4.2");
            }
            if (!(!this.featureAPIRunning || this.unavailableEEFeatures.isEmpty() && this.unavailableMPFeatures.isEmpty())) {
                throw new FeatureNotAvailableAtRequestedLevelException(this.unavailableEEFeatures, this.unavailableMPFeatures, allFeatures);
            }
            ReportInputData.JavaEEVersion targetJavaEE = _data.getTargetJavaEE();
            if (this.featureAPIRunning && this.modifiedRequiredFeatures.contains(JPA_20_FEATURE) && targetJavaEE != null && targetJavaEE.equals((Object)ReportInputData.JavaEEVersion.EE7) && specifiedJpa20) {
                this.modifiedRequiredFeatures.remove(JPA_20_FEATURE);
                allFeatures.remove("jpa-2.1");
                allFeatures.add(JPA_20_FEATURE);
            }
            if (!this.modifiedRequiredFeatures.isEmpty()) {
                String msg = "";
                msg = this.modifiedRequiredFeatures.size() == 1 ? Messages.getFormattedMessage(Messages.getString("DriveScan_Required_Feature_Updated"), this.modifiedRequiredFeatures.toArray()) : Messages.getFormattedMessage(Messages.getString("DriveScan_Required_Feature_Updated"), this.modifiedRequiredFeatures);
                ReportUtility.logger.get().log(Level.WARNING, msg);
                if (this.featureAPIRunning) {
                    throw new RequiredFeatureModifiedException(msg, allFeatures);
                }
            }
            DriveScanGenerateConfig.removeConvenienceFeatures(allFeatures);
            return allFeatures;
        }
        Iterator it = conflicts.iterator();
        ProvidedFeatureConflictException exception = new ProvidedFeatureConflictException();
        HashSet<String> conflictingFeatures = new HashSet<String>();
        while (it.hasNext()) {
            FeatureListFeatureResolver.FeatureConflict conflict = (FeatureListFeatureResolver.FeatureConflict)it.next();
            exception.addMessage(this.getConflictMessage(conflict));
            conflictingFeatures.add(this.removePackageFromFeature(conflict.getConfiguredFeatureA()));
            conflictingFeatures.add(this.removePackageFromFeature(conflict.getConfiguredFeatureB()));
        }
        exception.setFeatures(conflictingFeatures);
        throw exception;
    }

    private void replacePreferredMPAndEEFeatures(List<String> currentFeatures) {
        ReportInputData.JavaEEVersion targetJavaEE = _data.getTargetJavaEE();
        ReportInputData.MicroProfileVersion microProfile = _data.getMicroProfile();
        if (null == currentFeatures || null == microProfile && null == targetJavaEE) {
            return;
        }
        HashSet<String> featuresToAdd = new HashSet<String>();
        Iterator<String> it = currentFeatures.iterator();
        while (it.hasNext()) {
            String feature = it.next();
            String prefix = DriveScanGenerateConfig.getPrefix(feature);
            if (null != microProfile && feature.startsWith("mp")) {
                String preferredMPFeature = DriveScanGenerateConfig.getPreferredMicroProfileFeature(prefix);
                if (null == preferredMPFeature) {
                    this.unavailableMPFeatures.add(prefix);
                    continue;
                }
                if (feature.equalsIgnoreCase(preferredMPFeature)) continue;
                it.remove();
                this.modifiedRequiredFeatures.add(feature);
                featuresToAdd.add(preferredMPFeature);
                continue;
            }
            if (null == targetJavaEE || !DriveScanGenerateConfig.isEEFeature(feature) || "jdbc".equalsIgnoreCase(prefix) || JPA_20_FEATURE.equalsIgnoreCase(feature) && targetJavaEE.equals((Object)ReportInputData.JavaEEVersion.EE7)) continue;
            Set<String> eeFeatures = libertyJavaEEFeatures.get((Object)targetJavaEE);
            boolean foundFeature = false;
            if (eeFeatures.contains(feature)) continue;
            for (String eeFeature : eeFeatures) {
                String eeFeaturePrefix = DriveScanGenerateConfig.getPrefix(eeFeature);
                if (!eeFeaturePrefix.equalsIgnoreCase(prefix)) continue;
                it.remove();
                this.modifiedRequiredFeatures.add(feature);
                featuresToAdd.add(eeFeature);
                foundFeature = true;
                break;
            }
            if (foundFeature) continue;
            this.unavailableEEFeatures.add(prefix);
        }
        for (String feature : featuresToAdd) {
            if (currentFeatures.contains(feature)) continue;
            currentFeatures.add(feature);
        }
    }

    @Override
    public void runReport() {
        List<File> apps = _data.getProjectFiles();
        Collections.sort(apps, new FileComparator());
        List<String> appNames = _data.getProjectNames();
        ArrayList<File> xmlFilesCreated = new ArrayList<File>();
        Collections.sort(appNames);
        boolean isDirectoryWithMultipleApps = _data.getProjectFiles().size() > 1;
        StringBuilder sensitiveDataFilesSB = new StringBuilder();
        int i = 0;
        for (File app : apps) {
            try {
                BinaryReportReader brr;
                ConfigManager configMgr = this.getConfigManager(app);
                if (configMgr == null && !this.isLiberty) continue;
                String appName = app.getName();
                File outputFile = this.getOutputFile(_data, DriveScanGenerateConfig.getFileName(app), appName, isDirectoryWithMultipleApps, null);
                System.out.println(Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Processing"), appName));
                ArrayList<String> projectName = new ArrayList<String>();
                ArrayList<File> projectFile = new ArrayList<File>();
                projectName.add(appNames.get(i++));
                projectFile.add(app);
                _data.setProjectData(projectFile, projectName);
                TargetConfig appConfig = null;
                HashMap<String, Map<String, IdentifierObject>> possibleIdentifierNames = new HashMap<String, Map<String, IdentifierObject>>();
                if (configMgr != null) {
                    possibleIdentifierNames.put(appName, configMgr.getPossibleIdentifierNames());
                    appConfig = this.isLiberty ? new LibertyServerXml(configMgr, appName, outputFile, false) : new WSAdminScript(configMgr, appName, outputFile);
                    this.detectSharedLibraries(appConfig, configMgr.getProfileDir());
                }
                HashMap<ReportInputData.ReportType, Collection<Rule>> rules = new HashMap<ReportInputData.ReportType, Collection<Rule>>();
                if (STATIC_FEATURES == null) {
                    rules.put(ReportInputData.ReportType.GENERATE_CONFIG, this.getRules().values());
                }
                if ((brr = new BinaryReportReader(_data, rules, this.configRules, possibleIdentifierNames, null)) == null) continue;
                if (this.isLiberty) {
                    TreeSet<String> configFeatures = new TreeSet<String>();
                    HashSet<String> coreFeatures = new HashSet<String>();
                    HashSet<String> baseFeatures = new HashSet<String>();
                    boolean hasConflict = false;
                    if (STATIC_FEATURES != null) {
                        if (configMgr != null) {
                            appConfig.setUsedIdentifierNames(configMgr.getPossibleIdentifierNames().keySet());
                        }
                        coreFeatures.addAll(STATIC_FEATURES);
                    } else {
                        brr.openFile();
                        Set<String> flaggedRules = brr.getConfigRulesFlagged();
                        if (appConfig != null) {
                            appConfig.setUsedIdentifierNames(brr.getFoundIdentifierNames(appName));
                            configFeatures.addAll(((LibertyServerXml)appConfig).getConfigFeatures());
                            appConfig.setConfigRulesFlagged(flaggedRules);
                        }
                        hasConflict = this.findCorrectFeatureList(coreFeatures, baseFeatures, configFeatures, brr, appName);
                        if (brr.getDataStore().getDetectedJNDINameWithConfigRule() && !this.sentAnalysisInfoMessage) {
                            ReportUtility.logger.get().log(Level.INFO, Messages.getString("Generate_Config_Run_Analysis"));
                            this.sentAnalysisInfoMessage = true;
                        }
                        brr.closeFile();
                    }
                    String migratedConfig = null;
                    File sensitiveDataFile = null;
                    String sensitiveData = null;
                    File mimeTypesFile = null;
                    String mimeTypes = null;
                    File jvmOptionsFile = null;
                    String jvmOptions = null;
                    String serverEnv = null;
                    File serverEnvFile = null;
                    Map<String, String> filesToMigrate = null;
                    if (appConfig != null) {
                        try {
                            LibertyServerXml targetConfig = (LibertyServerXml)appConfig;
                            targetConfig.migrateConfig();
                            migratedConfig = targetConfig.getServerXmlContent();
                            sensitiveData = targetConfig.getSensitiveDataContent();
                            sensitiveDataFile = targetConfig.getSensitiveDataXml();
                            mimeTypes = targetConfig.getMimeTypesData();
                            mimeTypesFile = targetConfig.getMimeTypesXml();
                            jvmOptions = targetConfig.getJvmOptionsContent();
                            jvmOptionsFile = targetConfig.getJvmOptions();
                            filesToMigrate = targetConfig.getFilesToMigrate();
                            serverEnv = targetConfig.getServerEnvContent();
                            serverEnvFile = targetConfig.getServerEnv();
                        }
                        catch (Exception e) {
                            if (ReportUtility.isDebug()) {
                                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error_Log"), appName), e);
                            }
                            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error"), appName, e.getMessage()));
                        }
                    }
                    if (coreFeatures.isEmpty() && baseFeatures.isEmpty()) {
                        ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_NoFeatureListRequired"), appName));
                        if (migratedConfig == null) {
                            return;
                        }
                    }
                    try {
                        String serverXmlContent = ServerXmlWriter.buildServerXML(coreFeatures, baseFeatures, migratedConfig, isOpenLiberty || isEASe, hasConflict, PLATFORM);
                        if (serverXmlContent == null || serverXmlContent.equals("")) continue;
                        this.setReturnCode(ReportUtility.writeOutStream(outputFile, serverXmlContent));
                        if (sensitiveDataFile != null && sensitiveData != null) {
                            this.setReturnCode(ReportUtility.writeOutStream(sensitiveDataFile, sensitiveData));
                            if (SensitiveDataHelper.isIncludeSensitiveData()) {
                                sensitiveDataFilesSB.append(sensitiveDataFile).append("\n");
                            }
                        }
                        if (jvmOptionsFile != null && jvmOptions != null) {
                            ReportUtility.writeOutStream(jvmOptionsFile, jvmOptions);
                        }
                        if (mimeTypesFile != null && mimeTypes != null) {
                            ReportUtility.writeOutStream(mimeTypesFile, mimeTypes);
                        }
                        if (serverEnvFile != null && serverEnv != null) {
                            ReportUtility.writeOutStream(serverEnvFile, serverEnv);
                        }
                        this.migrateFilesForConfig(filesToMigrate);
                        xmlFilesCreated.add(outputFile);
                    }
                    catch (Exception e) {
                        if (outputFile != null) {
                            if (ReportUtility.isDebug()) {
                                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Write_Report_Log"), outputFile.getAbsolutePath()), e);
                            } else {
                                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Write_Report"), outputFile.getAbsolutePath(), e.getMessage()));
                            }
                        } else if (ReportUtility.isDebug()) {
                            ReportUtility.logger.get().log(Level.SEVERE, Messages.getString("DriveScan_Error_Write_Report_No_File_Log"), e);
                        } else {
                            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Write_Report_No_File"), e.getMessage()));
                        }
                        this.setReturnCode(2);
                    }
                    continue;
                }
                if (configMgr == null) continue;
                brr.openFile();
                if (appConfig != null) {
                    appConfig.setUsedIdentifierNames(brr.getFoundIdentifierNames(appName));
                }
                brr.closeFile();
                String migratedConfig = null;
                if (appConfig != null) {
                    try {
                        WSAdminScript targetConfig = (WSAdminScript)appConfig;
                        targetConfig.migrateConfig();
                        migratedConfig = targetConfig.getWSAdminScriptContent();
                    }
                    catch (Exception e) {
                        if (ReportUtility.isDebug()) {
                            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error_Log"), appName), e);
                        }
                        ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_MigratedConfig_Error"), appName, e.getMessage()));
                    }
                }
                try {
                    this.setReturnCode(ReportUtility.writeOutStream(outputFile, migratedConfig));
                    if (!SensitiveDataHelper.isIncludeSensitiveData() || SensitiveDataHelper.getRegisteredVarKeys().isEmpty()) continue;
                    sensitiveDataFilesSB.append(outputFile).append("\n");
                }
                catch (Exception e) {
                    if (outputFile != null) {
                        if (ReportUtility.isDebug()) {
                            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Write_Report_Log"), outputFile.getAbsolutePath()), e);
                        } else {
                            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Write_Report"), outputFile.getAbsolutePath(), e.getMessage()));
                        }
                    } else if (ReportUtility.isDebug()) {
                        ReportUtility.logger.get().log(Level.SEVERE, Messages.getString("DriveScan_Error_Write_Report_No_File_Log"), e);
                    } else {
                        ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Write_Report_No_File"), e.getMessage()));
                    }
                    this.setReturnCode(2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_NoConfigException"), app.getName(), e.getMessage()));
                this.setReturnCode(2);
            }
        }
        if (sensitiveDataFilesSB.length() > 0) {
            ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Sensitive_Data_Msg"), sensitiveDataFilesSB.toString()));
        }
        if (!ReportUtility.getFilesWithParsingError().isEmpty()) {
            ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Processing_Files"), ReportUtility.getFilesWithParsingError()));
        }
    }

    public File getOutputFile(ReportInputData data, String appFileName, String appName, boolean isDirectoryWithMultipleApps, String profile) {
        String outputDirPath;
        File outputFile = null;
        String suffix = "";
        if (this.isLiberty) {
            outputFile = data.getOutputFile().get((Object)ReportInputData.OutputType.XML);
            suffix = this.getDefaultReportName() + ".xml";
        } else {
            outputFile = data.getOutputFile().get((Object)ReportInputData.OutputType.PY);
            suffix = this.getDefaultReportName() + ".py";
        }
        if (outputFile == null) {
            String jsonPath;
            int extIndex;
            File htmlFile = data.getOutputFile().get((Object)ReportInputData.OutputType.HTML);
            File jsonFile = data.getOutputFile().get((Object)ReportInputData.OutputType.JSON);
            if (htmlFile != null) {
                String htmlPath = htmlFile.getAbsolutePath();
                extIndex = htmlPath.lastIndexOf(ReportInputData.OutputType.HTML.getExtension());
                if (extIndex > 0) {
                    outputFile = new File(htmlPath.substring(0, extIndex) + "_" + suffix);
                }
            } else if (jsonFile != null && (extIndex = (jsonPath = jsonFile.getAbsolutePath()).lastIndexOf(ReportInputData.OutputType.JSON.getExtension())) > 0) {
                outputFile = new File(jsonPath.substring(0, extIndex) + "_" + suffix);
            }
        }
        String nameForFile = null;
        String dirPath = data.getProjectDirPathNormalized(appFileName);
        String subDir = ReportUtility.getSubDir(appFileName, dirPath, appName);
        File outputDir = data.getOutputDir();
        String string = outputDirPath = outputDir == null ? "" : DriveScanGenerateConfig.getOutputDirPath(outputDir);
        if (profile != null) {
            outputDirPath = outputDirPath + profile + File.separator;
        }
        if (outputFile == null) {
            nameForFile = isDirectoryWithMultipleApps || data.isInputDirectoryWithOneArchive() ? (subDir == null ? outputDirPath + appName + "_" + suffix : outputDirPath + subDir.replaceAll("/", "_") + "_" + appName + "_" + suffix) : outputDirPath + data.getPrefix() + suffix;
        } else if (isDirectoryWithMultipleApps) {
            String string2 = nameForFile = subDir == null ? DriveScanGenerateConfig.getOutputPath(outputFile) + appName + "_" + suffix : DriveScanGenerateConfig.getOutputPath(outputFile) + subDir.replaceAll("/", "_") + "_" + appName + "_" + suffix;
        }
        if (nameForFile != null) {
            outputFile = new File(nameForFile);
        }
        return outputFile;
    }

    public boolean findCorrectFeatureList(Set<String> coreFeatures, Set<String> baseFeatures, Set<String> configFeatures, BinaryReportReader brr, String appName) {
        return this.findCorrectFeatureList(coreFeatures, baseFeatures, configFeatures, brr, appName, null);
    }

    public Set<String> getRuleSelectedFeatures() {
        return this.ruleSelectedFeatures;
    }

    public boolean findCorrectFeatureList(Set<String> coreFeatures, Set<String> baseFeatures, Set<String> configFeatures, BinaryReportReader brr, String appName, List<String> currentFeatures) {
        HashMap<String, List<String>> requiredFeatures = new HashMap<String, List<String>>();
        HashMap<String, String> currentFeaturesPrefixMap = new HashMap<String, String>();
        if (currentFeatures != null) {
            for (String feature : currentFeatures) {
                String prefix = DriveScanGenerateConfig.getPrefix(feature);
                ArrayList<String> listOfRequiredFeatures = new ArrayList<String>();
                listOfRequiredFeatures.add(feature);
                requiredFeatures.put(prefix, listOfRequiredFeatures);
                currentFeaturesPrefixMap.put(prefix, feature);
                if (libertyCoreFeatures.containsKey(prefix)) {
                    if (!libertyCoreFeatures.get(prefix).contains(feature)) {
                        throw new RuntimeException(Messages.getFormattedMessage(Messages.getString("DriveScan_Unknown_Feature"), feature));
                    }
                    coreFeatures.add(feature);
                    continue;
                }
                if (libertyBaseFeatures.containsKey(prefix)) {
                    if (!libertyBaseFeatures.get(prefix).contains(feature)) {
                        throw new RuntimeException(Messages.getFormattedMessage(Messages.getString("DriveScan_Unknown_Feature"), feature));
                    }
                    baseFeatures.add(feature);
                    continue;
                }
                throw new RuntimeException(Messages.getFormattedMessage(Messages.getString("DriveScan_Unknown_Feature"), feature));
            }
        }
        HashMap<String, String> preferredFeaturesVersion = new HashMap<String, String>();
        Map<String, List<DetailResult>> projectsToDetailsFoundFeatureList = brr.getProjectsToDetailResults(ReportInputData.ReportType.GENERATE_CONFIG);
        ReportInputData.AppServer sourceAppServer = _data.getSourceAppServer();
        boolean preferLatestInSortingAndReplace = sourceAppServer != null && sourceAppServer.isCompetitiveAppServer();
        HashSet<String> ruleFeatures = new HashSet<String>();
        ArrayList<Set<String>> orderedRequiredFeatures = this.processResults(coreFeatures, baseFeatures, requiredFeatures, preferredFeaturesVersion, projectsToDetailsFoundFeatureList, configFeatures, appName, preferLatestInSortingAndReplace, ruleFeatures, currentFeaturesPrefixMap);
        boolean hasConflicts = true;
        ArrayList<String> possibleConflictMessages = new ArrayList<String>();
        for (int i = 0; i < orderedRequiredFeatures.size(); ++i) {
            HashSet<String> featuresToRemove = new HashSet<String>();
            for (String string : orderedRequiredFeatures.get(i)) {
                String prefix = DriveScanGenerateConfig.getPrefix(string);
                if (requiredFeatures.containsKey(prefix)) continue;
                featuresToRemove.add(string);
            }
            orderedRequiredFeatures.get(i).removeAll(featuresToRemove);
            this.replaceCoreAndBaseFeaturesWithRequired(orderedRequiredFeatures.get(i), coreFeatures, baseFeatures, preferLatestInSortingAndReplace);
            if (this.checkForConflicts(coreFeatures, baseFeatures, orderedRequiredFeatures.get(i), ruleFeatures)) continue;
            this.ruleSelectedFeatures.clear();
            this.ruleSelectedFeatures.addAll(coreFeatures);
            this.ruleSelectedFeatures.addAll(baseFeatures);
            Set<String> unresolvedPackages = this.mapReferencedPackagesToFeatures(coreFeatures, baseFeatures, brr.getDataStore(), orderedRequiredFeatures.get(i), preferredFeaturesVersion);
            if (this.addJsonbIfRestfulWS) {
                block3: for (Object feature2 : coreFeatures) {
                    if (!((String)feature2).startsWith("restfulWS")) continue;
                    ReportInputData.JavaEEVersion featureVersion = this.getJavaEEVersionOfFeature((String)feature2);
                    Set<String> features = libertyJavaEEFeatures.get((Object)featureVersion);
                    for (String potentialJsonbFeature : features) {
                        if (!potentialJsonbFeature.startsWith("jsonb")) continue;
                        ReportUtility.logger.get().log(Level.FINE, "Adding " + potentialJsonbFeature + " to feature list since addJsonbIfRestfulWS was set and restfulWS is in feature list.");
                        coreFeatures.add(potentialJsonbFeature);
                        break block3;
                    }
                }
            }
            if (!unresolvedPackages.isEmpty()) {
                Object feature2;
                StringBuilder stringBuilder = new StringBuilder();
                feature2 = unresolvedPackages.iterator();
                while (feature2.hasNext()) {
                    String nextUnresolved = (String)feature2.next();
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(nextUnresolved);
                }
                stringBuilder.append("\n");
                String message = Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_UnresolvedPackages"), appName, stringBuilder.toString());
                ReportUtility.logger.get().log(Level.WARNING, message);
                this.conflictMessages.add(message);
            }
            if (this.checkForConflicts(coreFeatures, baseFeatures, orderedRequiredFeatures.get(i), ruleFeatures)) continue;
            hasConflicts = false;
            break;
        }
        if (hasConflicts) {
            this.handleConflictMessages(coreFeatures, baseFeatures, requiredFeatures, possibleConflictMessages, appName);
        }
        boolean appSecurityFeatureEnabled = false;
        String transportSecurityFeature = null;
        for (String string : coreFeatures) {
            if (string.startsWith("appSecurity")) {
                appSecurityFeatureEnabled = true;
                continue;
            }
            if (!string.startsWith("transportSecurity")) continue;
            transportSecurityFeature = string;
        }
        if (appSecurityFeatureEnabled && transportSecurityFeature != null) {
            coreFeatures.remove(transportSecurityFeature);
            ReportUtility.logger.get().log(Level.FINE, "Removing " + transportSecurityFeature + " from feature list since appSecurity is also enabled.");
        }
        if (hasConflicts) {
            this.conflictMessages.addAll(possibleConflictMessages);
            ReportUtility.logger.get().log(Level.FINE, "DriveScanGenerateConfig: the feature list has conflicts. The core features=" + coreFeatures + ". The base features= " + baseFeatures);
        } else {
            ReportUtility.logger.get().log(Level.FINE, "DriveScanGenerateConfig: the feature list was generated successfully. The core features=" + coreFeatures + ". The base features= " + baseFeatures);
        }
        return hasConflicts;
    }

    private void handleConflictMessages(Set<String> coreFeatures, Set<String> baseFeatures, Map<String, List<String>> requiredFeatures, List<String> possibleConflictMessages, String appName) {
        StringBuilder sb = new StringBuilder();
        for (String nextFeature : coreFeatures) {
            if (requiredFeatures != null && requiredFeatures.containsKey(DriveScanGenerateConfig.getPrefix(nextFeature))) {
                sb.append(nextFeature);
            } else {
                sb.append(DriveScanGenerateConfig.getPrefix(nextFeature));
            }
            sb.append("\n");
        }
        for (String nextFeature : baseFeatures) {
            if (requiredFeatures != null && requiredFeatures.containsKey(DriveScanGenerateConfig.getPrefix(nextFeature))) {
                sb.append(nextFeature);
            } else {
                sb.append(DriveScanGenerateConfig.getPrefix(nextFeature));
            }
            sb.append("\n");
        }
        String message1 = Messages.getFormattedMessage(Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_FeaturesRequired"), appName, sb.toString()), new Object[0]);
        ReportUtility.logger.get().log(Level.INFO, message1);
        String message2 = Messages.getFormattedMessage(Messages.getFormattedMessage(Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_NoFeatureList"), appName), new Object[0]), new Object[0]);
        ReportUtility.logger.get().log(Level.SEVERE, message2);
        if (this.featureAPIRunning) {
            this.featureConflictException.addMessage(message1);
            this.featureConflictException.addMessage(message2);
        }
        possibleConflictMessages.add(message1);
        possibleConflictMessages.add(message2);
    }

    public void replaceCoreAndBaseFeaturesWithRequired(Set<String> curRequiredFeatures, Set<String> coreFeatures, Set<String> baseFeatures, boolean preferLatestInSortingAndReplace) {
        HashSet<String> coreAdd = new HashSet<String>();
        HashSet<String> baseAdd = new HashSet<String>();
        for (String reqEl : curRequiredFeatures) {
            String prefix = DriveScanGenerateConfig.getPrefix(reqEl);
            String alternativePrefix = null;
            if (JakartaJavaEEFeatureVersions.JAVAEE_PREFIXES_TO_JAKARTA_PREFIXES.containsKey(prefix)) {
                alternativePrefix = JakartaJavaEEFeatureVersions.JAVAEE_PREFIXES_TO_JAKARTA_PREFIXES.get(prefix);
            } else if (JakartaJavaEEFeatureVersions.JAKARTA_PREFIXES_TO_JAVAEE_PREFIXES.containsKey(prefix)) {
                alternativePrefix = JakartaJavaEEFeatureVersions.JAKARTA_PREFIXES_TO_JAVAEE_PREFIXES.get(prefix);
            }
            Iterator<String> coreIter = coreFeatures.iterator();
            while (coreIter.hasNext()) {
                String nxtFeat = coreIter.next();
                if (!nxtFeat.contains(prefix) && (alternativePrefix == null || !nxtFeat.contains(alternativePrefix))) continue;
                coreIter.remove();
                coreAdd.remove(nxtFeat);
                coreAdd.add(reqEl);
            }
            Iterator<String> baseIter = baseFeatures.iterator();
            while (baseIter.hasNext()) {
                String nxtFeat = baseIter.next();
                if (!nxtFeat.contains(prefix) && (alternativePrefix == null || !nxtFeat.contains(alternativePrefix))) continue;
                baseIter.remove();
                baseAdd.remove(nxtFeat);
                baseAdd.add(reqEl);
            }
        }
        coreFeatures.addAll(coreAdd);
        baseFeatures.addAll(baseAdd);
    }

    public ArrayList<Set<String>> processResults(Set<String> coreFeatures, Set<String> baseFeatures, Map<String, List<String>> requiredFeatures, Map<String, String> preferredFeaturesVersion, Map<String, List<DetailResult>> projectsToDetailsFound, Set<String> configFeatures, String appName, boolean preferLatestInSortingAndReplace, Set<String> ruleFeatures, Map<String, String> currentFeatures) {
        this.conflictMessages.clear();
        Set<String> projectNames = projectsToDetailsFound.keySet();
        ArrayList detailResults = new ArrayList();
        for (String string : projectNames) {
            detailResults.addAll(projectsToDetailsFound.get(string));
        }
        for (DetailResult detailResult : detailResults) {
            if (detailResult.getRuleName().equals("AvailableThirdPartyPackagesApacheMyFaces")) continue;
            String criteria = detailResult.getCriteria();
            if (criteria.equals("jsonbIfRestfulWS")) {
                this.addJsonbIfRestfulWS = true;
                continue;
            }
            ruleFeatures.add(criteria);
        }
        ReportUtility.logger.get().log(Level.FINE, "DriveScanGenerateConfig: The initial features detected in the application are " + ruleFeatures);
        if (configFeatures != null && !configFeatures.isEmpty()) {
            ReportUtility.logger.get().log(Level.FINE, "DriveScanGenerateConfig: The features detected in the configuration are " + configFeatures);
            for (String string : configFeatures) {
                if (this.validateFeature(string)) {
                    ruleFeatures.add(string);
                    continue;
                }
                ReportUtility.logger.get().log(Level.FINE, "DriveScanGenerateConfig: The " + string + " does not exist in the Liberty features list.");
            }
        }
        ReportInputData.JavaEEVersion targetJavaEEVersion = _data.getTargetJavaEE();
        ReportInputData.AppServer appServer = _data.getSourceAppServer();
        ReportInputData.JavaEEVersion sourceJavaEE = null;
        if (targetJavaEEVersion == null && (appServer == null || appServer.isWAS_Traditional())) {
            if (appServer != null) {
                sourceJavaEE = appServer.getDefaultSourceJavaEE();
            }
            if (sourceJavaEE == null) {
                sourceJavaEE = ReportInputData.JavaEEVersion.EE6;
            }
            this.loadPreferredFeatureList(preferredFeaturesVersion, ruleFeatures, sourceJavaEE, appServer);
        }
        boolean conflictingRequiredCoreFeatures = this.processRules(coreFeatures, ruleFeatures, libertyCoreFeatures, requiredFeatures, libertyJavaEEFeatures, targetJavaEEVersion, preferredFeaturesVersion, currentFeatures);
        boolean conflictingRequiredBaseFeatures = this.processRules(baseFeatures, ruleFeatures, libertyBaseFeatures, requiredFeatures, libertyJavaEEFeatures, targetJavaEEVersion, preferredFeaturesVersion, currentFeatures);
        if (conflictingRequiredCoreFeatures || conflictingRequiredBaseFeatures) {
            ArrayList<Set<String>> ret = new ArrayList<Set<String>>();
            if (coreFeatures.contains("appSecurity-2.0") && (coreFeatures.contains("appSecurity-3.0") || coreFeatures.contains("appSecurity-4.0") || coreFeatures.contains("appSecurity-5.0"))) {
                coreFeatures.remove("appSecurity-2.0");
            }
            HashSet<String> features = new HashSet<String>(coreFeatures);
            features.addAll(baseFeatures);
            ret.add(features);
            return ret;
        }
        return this.getRequiredFeaturesPermutations(requiredFeatures, preferLatestInSortingAndReplace);
    }

    public ArrayList<Set<String>> getRequiredFeaturesPermutations(Map<String, List<String>> requiredFeatures, boolean preferLatest) {
        ArrayList<String> keyList = new ArrayList<String>();
        keyList.addAll(requiredFeatures.keySet());
        ArrayList<Set<String>> retList = this.generateAllCombos(requiredFeatures, new HashSet<String>(), keyList, 0);
        FeatureVersionComparator c1 = new FeatureVersionComparator(preferLatest);
        for (String key : requiredFeatures.keySet()) {
            Collections.sort(requiredFeatures.get(key), c1);
        }
        FeatureSetComparator c2 = new FeatureSetComparator(requiredFeatures);
        Collections.sort(retList, c2);
        return retList;
    }

    public ArrayList<Set<String>> generateAllCombos(Map<String, List<String>> requiredFeatures, Set<String> curSet, ArrayList<String> keyList, int curKey) {
        ArrayList<Set<String>> results = new ArrayList<Set<String>>();
        if (curSet.size() == requiredFeatures.keySet().size()) {
            HashSet<String> setClone = new HashSet<String>(curSet);
            results.add(setClone);
            return results;
        }
        for (int i = 0; i < requiredFeatures.get(keyList.get(curKey)).size(); ++i) {
            curSet.add(requiredFeatures.get(keyList.get(curKey)).get(i));
            results.addAll(this.generateAllCombos(requiredFeatures, curSet, keyList, curKey + 1));
            curSet.remove(requiredFeatures.get(keyList.get(curKey)).get(i));
        }
        return results;
    }

    public String getConflictMessage(FeatureListFeatureResolver.FeatureConflict conflict) {
        String configuredFeatureA = conflict.getConfiguredFeatureA();
        configuredFeatureA = this.removePackageFromFeature(configuredFeatureA);
        String reasonFeatureAIsInConflict = conflict.getConflictingFeatureA();
        String configuredFeatureB = conflict.getConfiguredFeatureB();
        configuredFeatureB = this.removePackageFromFeature(configuredFeatureB);
        String reasonFeatureBIsInConflict = conflict.getConflictingFeatureB();
        String message = null;
        message = reasonFeatureAIsInConflict != null ? Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_FeatureA_Requires_Feature_That_Conflicts_With_FeatureB"), configuredFeatureA, reasonFeatureAIsInConflict, reasonFeatureBIsInConflict, configuredFeatureB) : Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_FeatureA_Conflicts_With_FeatureB"), configuredFeatureA, reasonFeatureBIsInConflict, configuredFeatureB);
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkForConflicts(Collection<String> coreFeatures, Collection<String> baseFeatures, Set<String> requiredFeatures, Set<String> ruleFeatures) {
        boolean featuresConflict;
        Set<FeatureListFeatureResolver.FeatureConflict> conflicts;
        FeatureListFeatureResolver.ResolverResult result;
        boolean hasConflicts = false;
        ArrayList<String> currentRequiredFeatures = new ArrayList<String>();
        currentRequiredFeatures.addAll(requiredFeatures);
        ArrayList<String> allFeatures = new ArrayList<String>();
        allFeatures.addAll(coreFeatures);
        allFeatures.addAll(baseFeatures);
        allFeatures.removeAll(requiredFeatures);
        allFeatures.addAll(requiredFeatures);
        if (allFeatures.isEmpty()) {
            return hasConflicts;
        }
        if (currentRequiredFeatures.size() > 1) {
            result = FeatureListFeatureResolver.resolve(_featureListResource, currentRequiredFeatures);
            conflicts = result.getFeatureConflicts();
            if (ReportUtility.isDebug()) {
                StringBuilder infoMessage = new StringBuilder();
                infoMessage.append("ConflictSet: \n");
                for (FeatureListFeatureResolver.FeatureConflict conflict : conflicts) {
                    infoMessage.append(conflict.toString() + ":\n");
                }
                ReportUtility.logger.get().log(Level.FINE, infoMessage.toString());
            }
            if (!conflicts.isEmpty()) {
                Iterator<FeatureListFeatureResolver.FeatureConflict> it = conflicts.iterator();
                while (it.hasNext()) {
                    FeatureListFeatureResolver.FeatureConflict conflict;
                    boolean featuresConflict2 = true;
                    conflict = it.next();
                    String configuredFeatureA = conflict.getConfiguredFeatureA();
                    configuredFeatureA = this.removePackageFromFeature(configuredFeatureA);
                    String reasonFeatureAIsInConflict = conflict.getConflictingFeatureA();
                    String configuredFeatureB = conflict.getConfiguredFeatureB();
                    configuredFeatureB = this.removePackageFromFeature(configuredFeatureB);
                    String reasonFeatureBIsInConflict = conflict.getConflictingFeatureB();
                    if (reasonFeatureAIsInConflict != null && reasonFeatureBIsInConflict != null) {
                        if (FeatureUtil.isLowerVersionWithoutNameCheck(reasonFeatureAIsInConflict, reasonFeatureBIsInConflict)) {
                            ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Attempt_Resolve_Conflict"), configuredFeatureA, configuredFeatureB, configuredFeatureA));
                            featuresConflict2 = !this.replaceConflictingFeatures(configuredFeatureA, true, coreFeatures, baseFeatures, allFeatures, currentRequiredFeatures, ruleFeatures);
                        } else {
                            ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Attempt_Resolve_Conflict"), configuredFeatureA, configuredFeatureB, configuredFeatureB));
                            boolean bl = featuresConflict2 = !this.replaceConflictingFeatures(configuredFeatureB, true, coreFeatures, baseFeatures, allFeatures, currentRequiredFeatures, ruleFeatures);
                        }
                    }
                    if (!featuresConflict2 || _data == null || ReportInputData.AppServer.MANAGED_LIBERTY == _data.getTargetAppServer()) continue;
                    String message = null;
                    message = reasonFeatureAIsInConflict != null ? Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_FeatureA_Requires_Feature_That_Conflicts_With_FeatureB"), configuredFeatureA, reasonFeatureAIsInConflict, reasonFeatureBIsInConflict, configuredFeatureB) : Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_FeatureA_Conflicts_With_FeatureB"), configuredFeatureA, reasonFeatureBIsInConflict, configuredFeatureB);
                    ReportUtility.logger.get().log(Level.SEVERE, message);
                    this.conflictMessages.add(message);
                    return true;
                }
                ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Conflict_Resolved"), requiredFeatures, currentRequiredFeatures));
            }
        }
        if ((conflicts = (result = FeatureListFeatureResolver.resolve(_featureListResource, allFeatures)).getFeatureConflicts()).isEmpty()) return hasConflicts;
        if (_data == null) return hasConflicts;
        if (ReportInputData.AppServer.MANAGED_LIBERTY == _data.getTargetAppServer()) return hasConflicts;
        hasConflicts = true;
        boolean requiredFeaturesConflict = false;
        HashSet<String> collectPotentialErrorMessages = new HashSet<String>();
        Iterator<FeatureListFeatureResolver.FeatureConflict> it = conflicts.iterator();
        if (!it.hasNext()) return hasConflicts;
        FeatureListFeatureResolver.FeatureConflict conflict = it.next();
        String configuredFeatureA = conflict.getConfiguredFeatureA();
        configuredFeatureA = this.removePackageFromFeature(configuredFeatureA);
        String reasonFeatureAIsInConflict = conflict.getConflictingFeatureA();
        String configuredFeatureB = conflict.getConfiguredFeatureB();
        configuredFeatureB = this.removePackageFromFeature(configuredFeatureB);
        String reasonFeatureBIsInConflict = conflict.getConflictingFeatureB();
        String message = null;
        message = reasonFeatureAIsInConflict != null ? Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_FeatureA_Requires_Feature_That_Conflicts_With_FeatureB"), configuredFeatureA, reasonFeatureAIsInConflict, reasonFeatureBIsInConflict, configuredFeatureB) : Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_FeatureA_Conflicts_With_FeatureB"), configuredFeatureA, reasonFeatureBIsInConflict, configuredFeatureB);
        if (requiredFeaturesConflict |= requiredFeatures.contains(configuredFeatureA) && requiredFeatures.contains(configuredFeatureB)) {
            featuresConflict = true;
            if (reasonFeatureAIsInConflict != null && reasonFeatureBIsInConflict != null) {
                if (FeatureUtil.isLowerVersionWithoutNameCheck(reasonFeatureAIsInConflict, reasonFeatureBIsInConflict)) {
                    ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Attempt_Resolve_Conflict"), configuredFeatureA, configuredFeatureB, configuredFeatureA));
                    if (this.replaceConflictingFeatures(configuredFeatureA, true, coreFeatures, baseFeatures, allFeatures, currentRequiredFeatures, ruleFeatures)) return false;
                    boolean bl = true;
                    featuresConflict = bl;
                } else {
                    ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Attempt_Resolve_Conflict"), configuredFeatureA, configuredFeatureB, configuredFeatureB));
                    if (this.replaceConflictingFeatures(configuredFeatureB, true, coreFeatures, baseFeatures, allFeatures, currentRequiredFeatures, ruleFeatures)) return false;
                    boolean bl = true;
                    featuresConflict = bl;
                }
            }
        } else {
            collectPotentialErrorMessages.add(message);
            if (requiredFeatures.contains(configuredFeatureA)) {
                hasConflicts = this.replaceConflictingFeaturesTryBoth(configuredFeatureB, configuredFeatureA, false, true, coreFeatures, baseFeatures, allFeatures, currentRequiredFeatures, ruleFeatures);
            } else if (requiredFeatures.contains(configuredFeatureB)) {
                hasConflicts = this.replaceConflictingFeaturesTryBoth(configuredFeatureA, configuredFeatureB, false, true, coreFeatures, baseFeatures, allFeatures, currentRequiredFeatures, ruleFeatures);
            } else if (reasonFeatureAIsInConflict != null && reasonFeatureBIsInConflict != null) {
                hasConflicts = FeatureUtil.isLowerVersionWithoutNameCheck(reasonFeatureBIsInConflict, reasonFeatureAIsInConflict) ? this.replaceConflictingFeaturesTryBoth(configuredFeatureA, configuredFeatureB, false, false, coreFeatures, baseFeatures, allFeatures, currentRequiredFeatures, ruleFeatures) : this.replaceConflictingFeaturesTryBoth(configuredFeatureB, configuredFeatureA, false, false, coreFeatures, baseFeatures, allFeatures, currentRequiredFeatures, ruleFeatures);
            }
            if (!hasConflicts) return hasConflicts;
            ReportUtility.logger.get().log(Level.SEVERE, message);
            this.conflictMessages.add(message);
            return hasConflicts;
        }
        if (!featuresConflict) return false;
        message = reasonFeatureAIsInConflict != null ? Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_FeatureA_Requires_Feature_That_Conflicts_With_FeatureB"), configuredFeatureA, reasonFeatureAIsInConflict, reasonFeatureBIsInConflict, configuredFeatureB) : Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_FeatureA_Conflicts_With_FeatureB"), configuredFeatureA, reasonFeatureBIsInConflict, configuredFeatureB);
        ReportUtility.logger.get().log(Level.SEVERE, message);
        this.conflictMessages.add(message);
        return hasConflicts;
    }

    private boolean replaceConflictingFeaturesTryBoth(String firstFeatureToTry, String secondFeatureToTry, boolean firstFeatureToTryRequired, boolean secondFeatureToTryRequired, Collection<String> coreFeatures, Collection<String> baseFeatures, List<String> allFeatures, List<String> currentRequiredFeatures, Set<String> ruleFeatures) {
        boolean hasConflicts = true;
        ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Attempt_Resolve_Conflict"), firstFeatureToTry, secondFeatureToTry, firstFeatureToTry));
        boolean bl = hasConflicts = !this.replaceConflictingFeatures(firstFeatureToTry, firstFeatureToTryRequired, coreFeatures, baseFeatures, allFeatures, currentRequiredFeatures, ruleFeatures);
        if (hasConflicts) {
            ReportUtility.logger.get().log(secondFeatureToTryRequired ? Level.INFO : Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Attempt_Resolve_Conflict"), firstFeatureToTry, secondFeatureToTry, secondFeatureToTry));
            hasConflicts = !this.replaceConflictingFeatures(secondFeatureToTry, secondFeatureToTryRequired, coreFeatures, baseFeatures, allFeatures, currentRequiredFeatures, ruleFeatures);
        }
        return hasConflicts;
    }

    private boolean replaceConflictingFeatures(String featureToChange, boolean required, Collection<String> coreFeatures, Collection<String> baseFeatures, List<String> allFeatures, List<String> currentRequiredFeatures, Set<String> ruleFeatures) {
        if (featureToChange == null) {
            return false;
        }
        boolean noConflictsRemain = false;
        String prefix = DriveScanGenerateConfig.getPrefix(featureToChange);
        Set<String> potentialFeatures = this.getPotentialFeatures(prefix, ruleFeatures);
        String potentialFeature = null;
        potentialFeature = required ? DriveScanGenerateConfig.getLaterVersionOfFeature(potentialFeatures, featureToChange) : DriveScanGenerateConfig.getPreviousVersionOfFeature(potentialFeatures, featureToChange);
        while (potentialFeature != null) {
            ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Attempt_Resolve_Conflict_Features"), featureToChange, potentialFeature));
            noConflictsRemain = this.resolveConflict(allFeatures, currentRequiredFeatures, featureToChange, potentialFeature, ruleFeatures, true);
            if (noConflictsRemain) {
                for (String nextFeature : allFeatures) {
                    String featurePrefix = DriveScanGenerateConfig.getPrefix(nextFeature);
                    if (libertyCoreFeatures.containsKey(featurePrefix)) {
                        this.removeAllPotentialFeatures(nextFeature, featurePrefix, coreFeatures, libertyCoreFeatures);
                        continue;
                    }
                    this.removeAllPotentialFeatures(nextFeature, featurePrefix, baseFeatures, libertyBaseFeatures);
                }
                if (required) {
                    this.modifiedRequiredFeatures.add(featureToChange);
                }
                return true;
            }
            allFeatures.remove(potentialFeature);
            currentRequiredFeatures.remove(potentialFeature);
            potentialFeatures.remove(potentialFeature);
            if (required) {
                potentialFeature = DriveScanGenerateConfig.getLaterVersionOfFeature(potentialFeatures, potentialFeature);
                continue;
            }
            potentialFeature = DriveScanGenerateConfig.getPreviousVersionOfFeature(potentialFeatures, potentialFeature);
        }
        return false;
    }

    private void removeAllPotentialFeatures(String nextFeature, String featurePrefix, Collection<String> featureSet, Map<String, Set<String>> coreOrBaseFeatures) {
        Set<String> relevantFeatures = coreOrBaseFeatures.get(featurePrefix);
        featureSet.removeAll(relevantFeatures);
        String javaeeVersionOfNextFeature = JakartaJavaEEFeatureVersions.JAKARTA_PREFIXES_TO_JAVAEE_PREFIXES.get(featurePrefix);
        String jakartaVersionOfNextFeature = JakartaJavaEEFeatureVersions.JAVAEE_PREFIXES_TO_JAKARTA_PREFIXES.get(featurePrefix);
        if (javaeeVersionOfNextFeature != null) {
            relevantFeatures = coreOrBaseFeatures.get(javaeeVersionOfNextFeature);
            if (relevantFeatures != null) {
                featureSet.removeAll(relevantFeatures);
            }
        } else if (jakartaVersionOfNextFeature != null && (relevantFeatures = coreOrBaseFeatures.get(jakartaVersionOfNextFeature)) != null) {
            featureSet.removeAll(relevantFeatures);
        }
        featureSet.add(nextFeature);
    }

    private Set<String> getPotentialFeatures(String prefix, Set<String> ruleFeatures) {
        String javaeePrefix;
        HashSet<String> potentialFeatures = new HashSet<String>();
        boolean isCoreFeature = libertyCoreFeatures.containsKey(prefix);
        potentialFeatures.addAll(isCoreFeature ? libertyCoreFeatures.get(prefix) : libertyBaseFeatures.get(prefix));
        String jakartaPrefix = JakartaJavaEEFeatureVersions.JAVAEE_PREFIXES_TO_JAKARTA_PREFIXES.get(prefix);
        if (null != jakartaPrefix) {
            boolean jakartaVersionAlsoInList = false;
            for (String string : ruleFeatures) {
                if (!string.contains(jakartaPrefix)) continue;
                jakartaVersionAlsoInList = true;
                break;
            }
            if (jakartaVersionAlsoInList) {
                Set<String> matchingJakartaVersionsOfFeature;
                Set<String> set = matchingJakartaVersionsOfFeature = isCoreFeature ? libertyCoreFeatures.get(jakartaPrefix) : libertyBaseFeatures.get(jakartaPrefix);
                if (null != matchingJakartaVersionsOfFeature) {
                    potentialFeatures.addAll(matchingJakartaVersionsOfFeature);
                }
            }
        }
        if (null != (javaeePrefix = JakartaJavaEEFeatureVersions.JAKARTA_PREFIXES_TO_JAVAEE_PREFIXES.get(prefix))) {
            boolean javaeeVersionAlsoInList = false;
            for (String feature : ruleFeatures) {
                if (!feature.contains(javaeePrefix)) continue;
                javaeeVersionAlsoInList = true;
                break;
            }
            if (javaeeVersionAlsoInList) {
                Set<String> set;
                Set<String> set2 = set = isCoreFeature ? libertyCoreFeatures.get(javaeePrefix) : libertyBaseFeatures.get(javaeePrefix);
                if (null != set) {
                    potentialFeatures.addAll(set);
                }
            }
        }
        return potentialFeatures;
    }

    private boolean resolveConflict(List<String> currentFeatures, List<String> currentRequiredFeatures, String featureInConflict, String featureReplacement, Set<String> ruleFeatures, boolean featureReplacementIsRequired) {
        String configuredFeatureA;
        FeatureListFeatureResolver.ResolverResult result;
        Set<FeatureListFeatureResolver.FeatureConflict> conflicts;
        boolean hasNoConflicts = true;
        boolean hasUnresolvableConflict = false;
        currentFeatures.remove(featureInConflict);
        if (!currentFeatures.contains(featureReplacement)) {
            currentFeatures.add(featureReplacement);
        }
        if (featureReplacementIsRequired && !currentRequiredFeatures.contains(featureReplacement)) {
            currentRequiredFeatures.add(featureReplacement);
        }
        currentRequiredFeatures.remove(featureInConflict);
        if (currentRequiredFeatures.size() > 1 && !(conflicts = (result = FeatureListFeatureResolver.resolve(_featureListResource, currentRequiredFeatures)).getFeatureConflicts()).isEmpty()) {
            for (FeatureListFeatureResolver.FeatureConflict conflict : conflicts) {
                configuredFeatureA = conflict.getConfiguredFeatureA();
                configuredFeatureA = this.removePackageFromFeature(configuredFeatureA);
                String reasonFeatureAIsInConflict = conflict.getConflictingFeatureA();
                String configuredFeatureB = conflict.getConfiguredFeatureB();
                configuredFeatureB = this.removePackageFromFeature(configuredFeatureB);
                String reasonFeatureBIsInConflict = conflict.getConflictingFeatureB();
                String featureToChange = null;
                if (reasonFeatureAIsInConflict != null && reasonFeatureBIsInConflict != null) {
                    if (FeatureUtil.isLowerVersionWithoutNameCheck(reasonFeatureAIsInConflict, reasonFeatureBIsInConflict)) {
                        ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Attempt_Resolve_Conflict"), configuredFeatureA, configuredFeatureB, configuredFeatureA));
                        featureToChange = configuredFeatureA;
                    } else {
                        ReportUtility.logger.get().log(Level.FINE, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Attempt_Resolve_Conflict"), configuredFeatureA, configuredFeatureB, configuredFeatureB));
                        featureToChange = configuredFeatureB;
                    }
                }
                if (featureToChange == null) continue;
                String prefix = DriveScanGenerateConfig.getPrefix(featureToChange);
                Set<String> potentialFeatures = this.getPotentialFeatures(prefix, ruleFeatures);
                if (potentialFeatures != null && !potentialFeatures.isEmpty()) {
                    String potentialFeature = DriveScanGenerateConfig.getLaterVersionOfFeature(potentialFeatures, featureToChange);
                    if (potentialFeature != null) {
                        String message = Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Attempt_Resolve_Conflict"), configuredFeatureA, configuredFeatureB, featureToChange, potentialFeature);
                        ReportUtility.logger.get().log(Level.FINE, message);
                        this.conflictMessages.add(message);
                        return this.resolveConflict(currentFeatures, currentRequiredFeatures, featureToChange, potentialFeature, ruleFeatures, true);
                    }
                    String message = Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_FeatureConflicts"), configuredFeatureA, configuredFeatureB);
                    ReportUtility.logger.get().log(Level.FINE, message);
                    this.conflictMessages.add(message);
                    hasNoConflicts = false;
                    return hasNoConflicts;
                }
                String message = Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_FeatureConflicts"), configuredFeatureA, configuredFeatureB);
                ReportUtility.logger.get().log(Level.FINE, message);
                this.conflictMessages.add(message);
                hasNoConflicts = false;
                return hasNoConflicts;
            }
        }
        if (!(conflicts = (result = FeatureListFeatureResolver.resolve(_featureListResource, currentFeatures)).getFeatureConflicts()).isEmpty()) {
            hasNoConflicts = false;
            for (FeatureListFeatureResolver.FeatureConflict conflict : conflicts) {
                configuredFeatureA = conflict.getConfiguredFeatureA();
                configuredFeatureA = this.removePackageFromFeature(configuredFeatureA);
                String configuredFeatureB = conflict.getConfiguredFeatureB();
                configuredFeatureB = this.removePackageFromFeature(configuredFeatureB);
                if (hasUnresolvableConflict |= currentRequiredFeatures.contains(configuredFeatureA) && currentRequiredFeatures.contains(configuredFeatureB)) {
                    return hasNoConflicts;
                }
                String featureToChange = null;
                featureToChange = currentRequiredFeatures.contains(configuredFeatureA) ? configuredFeatureB : (currentRequiredFeatures.contains(configuredFeatureB) ? configuredFeatureA : (FeatureUtil.isLowerVersionWithoutNameCheck(configuredFeatureB, configuredFeatureA) ? configuredFeatureA : configuredFeatureB));
                if (featureToChange == null) continue;
                String prefix = DriveScanGenerateConfig.getPrefix(featureToChange);
                Set<String> potentialFeatures = this.getPotentialFeatures(prefix, ruleFeatures);
                if (potentialFeatures != null && !potentialFeatures.isEmpty()) {
                    String previousFeature = DriveScanGenerateConfig.getPreviousVersionOfFeature(potentialFeatures, featureToChange);
                    if (previousFeature != null) {
                        String message = Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Attempt_Resolve_Conflict"), configuredFeatureA, configuredFeatureB, featureToChange, previousFeature);
                        ReportUtility.logger.get().log(Level.FINE, message);
                        this.conflictMessages.add(message);
                        return this.resolveConflict(currentFeatures, currentRequiredFeatures, featureToChange, previousFeature, ruleFeatures, currentRequiredFeatures.contains(featureToChange));
                    }
                    String message = Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_FeatureConflicts"), configuredFeatureA, configuredFeatureB);
                    ReportUtility.logger.get().log(Level.FINE, message);
                    this.conflictMessages.add(message);
                    return hasNoConflicts;
                }
                String message = Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_FeatureConflicts"), configuredFeatureA, configuredFeatureB);
                ReportUtility.logger.get().log(Level.FINE, message);
                this.conflictMessages.add(message);
                return hasNoConflicts;
            }
        }
        return hasNoConflicts;
    }

    public Set<String> mapReferencedPackagesToFeatures(Collection<String> coreFeatures, Collection<String> baseFeatures, SimpleDataStore dataStore, Set<String> requiredFeatures, Map<String, String> preferredFeatures) {
        Map<String, Set<String>> featuresToPackagesInApp;
        HashSet<String> refPackages = new HashSet<String>(dataStore.getReferencedPackageNames());
        int numRefPackages = 0;
        do {
            numRefPackages = refPackages.size();
            featuresToPackagesInApp = this.resolvePackages(refPackages, coreFeatures, baseFeatures, dataStore, requiredFeatures, preferredFeatures);
        } while (refPackages.size() < numRefPackages);
        if (refPackages.size() > 0) {
            do {
                numRefPackages = refPackages.size();
                this.resolvePackagesWithMultipleFeatures(refPackages, coreFeatures, baseFeatures, preferredFeatures, featuresToPackagesInApp);
            } while (refPackages.size() < numRefPackages);
        }
        return refPackages;
    }

    private void resolvePackagesWithMultipleFeatures(Set<String> refPackages, Collection<String> coreFeatures, Collection<String> baseFeatures, Map<String, String> preferredFeatures, Map<String, Set<String>> featuresToPackagesInApp) {
        Iterator<String> it = refPackages.iterator();
        while (it.hasNext()) {
            String nextPackage = it.next();
            Set<String> possibleFeatures = packageToFeaturesMap.get(nextPackage);
            boolean foundMatch = false;
            for (String possiblefeature : possibleFeatures) {
                if (!coreFeatures.contains(possiblefeature) && !baseFeatures.contains(possiblefeature)) continue;
                foundMatch = true;
            }
            if (foundMatch) {
                it.remove();
                continue;
            }
            HashSet<String> reducedPossibleFeatures = new HashSet<String>(possibleFeatures);
            boolean equalNumberOfPackages = false;
            Iterator<String> featureIt = possibleFeatures.iterator();
            String preferredFeature = featureIt.next();
            int largestSize = featuresToPackagesInApp.get(preferredFeature).size();
            while (featureIt.hasNext()) {
                String tempFeat = featureIt.next();
                int tempSize = featuresToPackagesInApp.get(tempFeat).size();
                if (largestSize < tempSize) {
                    reducedPossibleFeatures.remove(preferredFeature);
                    preferredFeature = tempFeat;
                    largestSize = tempSize;
                    equalNumberOfPackages = false;
                    continue;
                }
                if (largestSize > tempSize) {
                    reducedPossibleFeatures.remove(tempFeat);
                    continue;
                }
                if (largestSize != tempSize) continue;
                equalNumberOfPackages = true;
            }
            if (equalNumberOfPackages) {
                featureIt = reducedPossibleFeatures.iterator();
                preferredFeature = featureIt.next();
                int smallestSize = featureToPackagesMap.get(preferredFeature).size();
                while (featureIt.hasNext()) {
                    String tempFeat = featureIt.next();
                    int tempSize = featureToPackagesMap.get(tempFeat).size();
                    if (smallestSize <= tempSize) continue;
                    preferredFeature = tempFeat;
                    smallestSize = tempSize;
                }
            }
            String preferredPrefix = DriveScanGenerateConfig.getPrefix(preferredFeature);
            boolean featureRecommended = false;
            if (!preferredPrefix.equals("appSecurity") && preferredFeatures.isEmpty() && DriveScanGenerateConfig.isEEFeature(preferredFeature)) {
                featureRecommended = DriveScanGenerateConfig.addPreferredEEFeature(coreFeatures, baseFeatures, preferredPrefix, possibleFeatures);
            }
            if (!featureRecommended & preferredFeatures.isEmpty() && coreFeatures.isEmpty() && baseFeatures.isEmpty() && (_data == null || _data.getTargetJavaEE() == null)) {
                HashSet<String> reducedPreferredFeatures = new HashSet<String>();
                for (String feature : reducedPossibleFeatures) {
                    String featurePrefix = DriveScanGenerateConfig.getPrefix(feature);
                    if (!preferredPrefix.equals(featurePrefix)) continue;
                    reducedPreferredFeatures.add(feature);
                }
                String finalFeature = DriveScanGenerateConfig.getLatestVersionOfFeature(reducedPreferredFeatures);
                if (libertyCoreFeatures.containsKey(preferredPrefix)) {
                    coreFeatures.add(finalFeature);
                } else {
                    baseFeatures.add(finalFeature);
                }
                featureRecommended = true;
            }
            if (!featureRecommended) {
                this.addPreferredFeature(coreFeatures, baseFeatures, preferredPrefix, preferredFeatures);
            }
            it.remove();
        }
    }

    public static boolean isEEFeature(String preferredFeature) {
        boolean isPrefix;
        boolean bl = isPrefix = !(preferredFeature = preferredFeature.split(",")[0]).contains("-");
        if (isPrefix) {
            preferredFeature = libertyCoreFeatures.containsKey(preferredFeature) ? DriveScanGenerateConfig.getLatestVersionOfFeature(libertyCoreFeatures.get(preferredFeature)) : DriveScanGenerateConfig.getLatestVersionOfFeature(libertyBaseFeatures.get(preferredFeature));
        }
        Set<String> ee6Features = null;
        if (!isOpenLiberty && !isEASe && (ee6Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE6)).contains(preferredFeature)) {
            return true;
        }
        Set<String> ee7Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE7);
        if (ee7Features.contains(preferredFeature)) {
            return true;
        }
        Set<String> ee8Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE8);
        if (ee8Features.contains(preferredFeature)) {
            return true;
        }
        Set<String> ee9Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE9);
        if (ee9Features.contains(preferredFeature)) {
            return true;
        }
        Set<String> ee10Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE10);
        return ee10Features.contains(preferredFeature);
    }

    private static String checkForFeatureDifferentVersion(Collection<String> features, String featureName) {
        String foundFeature = null;
        String prefix = DriveScanGenerateConfig.getPrefix(featureName);
        for (String feature : features) {
            if (!feature.startsWith(prefix) || feature.equals(featureName)) continue;
            foundFeature = feature;
            break;
        }
        return foundFeature;
    }

    private Map<String, Set<String>> resolvePackages(Set<String> refPackages, Collection<String> coreFeatures, Collection<String> baseFeatures, SimpleDataStore dataStore, Set<String> requiredFeatures, Map<String, String> preferredFeaturesVersion) {
        Iterator<String> it = refPackages.iterator();
        HashMap<String, Set<String>> featureMapLeft = new HashMap<String, Set<String>>();
        while (it.hasNext()) {
            String nextPackage = it.next();
            if (nextPackage.matches(IGNORE_JAVA_SE_PACKAGES)) {
                it.remove();
                continue;
            }
            Set<String> possibleFeatures = packageToFeaturesMap.get(nextPackage);
            if (possibleFeatures == null) {
                it.remove();
                continue;
            }
            if (possibleFeatures.isEmpty()) {
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_Feature_Package_Not_In_Open_Liberty"), nextPackage));
                it.remove();
                continue;
            }
            if (dataStore.containsImplementedPackageName(nextPackage)) {
                it.remove();
                continue;
            }
            if (PREFERRED_JAR_FEATURE_MAP.containsKey(nextPackage)) {
                this.addPreferredFeature(coreFeatures, baseFeatures, PREFERRED_JAR_FEATURE_MAP.get(nextPackage), preferredFeaturesVersion);
                it.remove();
                continue;
            }
            boolean foundMatch = false;
            boolean allPrefixesAreTheSame = true;
            String lastPrefix = null;
            String lastFeature = null;
            for (String nextPossibleFeature : possibleFeatures) {
                if (featureMapLeft.get(nextPossibleFeature) == null) {
                    HashSet<String> set = new HashSet<String>();
                    set.add(nextPackage);
                    featureMapLeft.put(nextPossibleFeature, set);
                } else {
                    ((Set)featureMapLeft.get(nextPossibleFeature)).add(nextPackage);
                }
                lastFeature = nextPossibleFeature;
                if (coreFeatures.contains(nextPossibleFeature) || baseFeatures.contains(nextPossibleFeature)) {
                    foundMatch = true;
                    break;
                }
                String prefix = DriveScanGenerateConfig.getPrefix(nextPossibleFeature);
                if (lastPrefix == null) {
                    lastPrefix = prefix;
                    continue;
                }
                if (prefix.equals(lastPrefix)) continue;
                allPrefixesAreTheSame = false;
            }
            if (foundMatch) {
                it.remove();
                continue;
            }
            if (possibleFeatures.size() == 1) {
                DriveScanGenerateConfig.addToCoreOrBase(lastFeature, coreFeatures, baseFeatures, requiredFeatures);
                requiredFeatures.add(lastFeature);
                it.remove();
                continue;
            }
            if (!allPrefixesAreTheSame) continue;
            this.addPreferredFeature(coreFeatures, baseFeatures, lastPrefix, preferredFeaturesVersion);
            it.remove();
        }
        if (ReportUtility.isDebug()) {
            StringBuilder infoMessage = new StringBuilder();
            infoMessage.append("featureMapLeft: \n");
            for (String feat : featureMapLeft.keySet()) {
                infoMessage.append(feat + ":\n");
                Set packages = (Set)featureMapLeft.get(feat);
                if (packages == null) continue;
                for (String pack : packages) {
                    if (pack == null) continue;
                    infoMessage.append("\t" + pack + "\n");
                }
            }
            ReportUtility.logger.get().log(Level.FINE, infoMessage.toString());
        }
        return featureMapLeft;
    }

    private static void addToCoreOrBase(String feature, Collection<String> coreFeatures, Collection<String> baseFeatures, Set<String> requiredFeatures) {
        String prefix = DriveScanGenerateConfig.getPrefix(feature);
        if (libertyCoreFeatures.containsKey(prefix)) {
            String anotherVersionOfFeature = DriveScanGenerateConfig.checkForFeatureDifferentVersion(coreFeatures, feature);
            if (anotherVersionOfFeature != null && !requiredFeatures.contains(anotherVersionOfFeature)) {
                coreFeatures.remove(anotherVersionOfFeature);
            }
            coreFeatures.add(feature);
        } else {
            String anotherVersionOfFeature = DriveScanGenerateConfig.checkForFeatureDifferentVersion(baseFeatures, feature);
            if (anotherVersionOfFeature != null && !requiredFeatures.contains(anotherVersionOfFeature)) {
                baseFeatures.remove(anotherVersionOfFeature);
            }
            baseFeatures.add(feature);
        }
    }

    private void addPreferredFeature(Collection<String> coreFeatures, Collection<String> baseFeatures, String featurePrefix, Map<String, String> preferredFeaturesVersion) {
        String preferredFeature;
        String feature = null;
        if (preferredFeaturesVersion != null && (preferredFeature = preferredFeaturesVersion.get(featurePrefix)) != null) {
            feature = preferredFeature;
        }
        ArrayList<String> allFeatures = new ArrayList<String>();
        allFeatures.addAll(coreFeatures);
        allFeatures.addAll(baseFeatures);
        if (libertyCoreFeatures.containsKey(featurePrefix)) {
            if (feature == null) {
                if (featurePrefix.startsWith("mp") && _data.getMicroProfile() != null && (feature = DriveScanGenerateConfig.getPreferredMicroProfileFeature(featurePrefix)) == null) {
                    this.unavailableMPFeatures.add(featurePrefix);
                }
                if (feature == null) {
                    feature = featurePrefix.startsWith("mp") ? this.getLatestCompatibleMPVersionOfFeature(featurePrefix, allFeatures) : DriveScanGenerateConfig.getLatestCompatibleVersionOfFeature(libertyCoreFeatures.get(featurePrefix), allFeatures);
                }
            }
            coreFeatures.add(feature);
        } else {
            if (feature == null) {
                feature = DriveScanGenerateConfig.getLatestVersionOfFeature(libertyBaseFeatures.get(featurePrefix));
            }
            baseFeatures.add(feature);
        }
    }

    private String getLatestCompatibleMPVersionOfFeature(String featurePrefix, List<String> allFeatures) {
        String feature = null;
        feature = this.getPreferredMicroprofileFeatureFromEELevel(featurePrefix, _data.getTargetJavaEE());
        if (feature != null) {
            return feature;
        }
        Set<Object> ee6Features = new HashSet();
        if (!isOpenLiberty && !isEASe) {
            ee6Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE6);
        }
        Set<String> ee7Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE7);
        Set<String> ee8Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE8);
        Set<String> ee9Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE9);
        Set<String> ee10Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE10);
        EnumSet<ReportInputData.JavaEEVersion> javaEEVersionsRecommended = EnumSet.noneOf(ReportInputData.JavaEEVersion.class);
        for (String featureName : allFeatures) {
            if (featureName.startsWith("appSecurity")) continue;
            if (ee6Features.contains(featureName)) {
                javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE6);
                continue;
            }
            if (ee7Features.contains(featureName)) {
                javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE7);
                continue;
            }
            if (ee8Features.contains(featureName)) {
                javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE8);
                continue;
            }
            if (ee9Features.contains(featureName)) {
                javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE9);
                continue;
            }
            if (!ee10Features.contains(featureName)) continue;
            javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE10);
        }
        if (!javaEEVersionsRecommended.isEmpty()) {
            ReportInputData.JavaEEVersion highestVersion = ReportInputData.JavaEEVersion.EE6;
            for (ReportInputData.JavaEEVersion eeVersion : javaEEVersionsRecommended) {
                if (highestVersion.getVersionNumber() >= eeVersion.getVersionNumber()) continue;
                highestVersion = eeVersion;
            }
            feature = this.getPreferredMicroprofileFeatureFromEELevel(featurePrefix, highestVersion);
        }
        if (feature != null) {
            return feature;
        }
        return DriveScanGenerateConfig.getLatestVersionOfFeature(libertyCoreFeatures.get(featurePrefix));
    }

    private String getPreferredMicroprofileFeatureFromEELevel(String featurePrefix, ReportInputData.JavaEEVersion eeLevel) {
        String feature = null;
        if (null == eeLevel) {
            return feature;
        }
        switch (eeLevel) {
            case EE6: 
            case EE7: {
                feature = PREFERRED_MP1_FEATURE.get(featurePrefix);
                break;
            }
            case EE8: {
                feature = PREFERRED_MP4_FEATURE.get(featurePrefix);
                break;
            }
            case EE9: {
                feature = PREFERRED_MP5_FEATURE.get(featurePrefix);
                break;
            }
            case EE10: {
                feature = PREFERRED_MP6_FEATURE.get(featurePrefix);
            }
        }
        return feature;
    }

    private String getPreferredJavaEEFeature(String featurePrefix, ReportInputData.JavaEEVersion eeLevel) {
        Set<String> features = libertyJavaEEFeatures.get((Object)eeLevel);
        for (String feature : features) {
            String prefix = DriveScanGenerateConfig.getPrefix(feature);
            if (!prefix.equals(featurePrefix)) continue;
            return feature;
        }
        return null;
    }

    private static String getPreferredMicroProfileFeature(String featurePrefix) {
        String feature = null;
        switch (_data.getMicroProfile()) {
            case MP1: 
            case MP1_4: {
                feature = PREFERRED_MP1_FEATURE.get(featurePrefix);
                break;
            }
            case MP1_2: {
                feature = PREFERRED_MP1_2_FEATURE.get(featurePrefix);
                break;
            }
            case MP1_3: {
                feature = PREFERRED_MP1_3_FEATURE.get(featurePrefix);
                break;
            }
            case MP2: 
            case MP2_2: {
                feature = PREFERRED_MP2_FEATURE.get(featurePrefix);
                break;
            }
            case MP2_0: {
                feature = PREFERRED_MP2_0_FEATURE.get(featurePrefix);
                break;
            }
            case MP2_1: {
                feature = PREFERRED_MP2_1_FEATURE.get(featurePrefix);
                break;
            }
            case MP3: 
            case MP3_3: {
                feature = PREFERRED_MP3_FEATURE.get(featurePrefix);
                break;
            }
            case MP3_0: {
                feature = PREFERRED_MP3_0_FEATURE.get(featurePrefix);
                break;
            }
            case MP3_2: {
                feature = PREFERRED_MP3_2_FEATURE.get(featurePrefix);
                break;
            }
            case MP4: 
            case MP4_1: {
                feature = PREFERRED_MP4_FEATURE.get(featurePrefix);
                break;
            }
            case MP4_0: {
                feature = PREFERRED_MP4_0_FEATURE.get(featurePrefix);
                break;
            }
            case MP5: 
            case MP5_0: {
                feature = PREFERRED_MP5_FEATURE.get(featurePrefix);
                break;
            }
            case MP6: 
            case MP6_0: {
                feature = PREFERRED_MP6_FEATURE.get(featurePrefix);
            }
        }
        return feature;
    }

    private static boolean addPreferredEEFeature(Collection<String> coreFeatures, Collection<String> baseFeatures, String featurePrefix, Set<String> possibleFeatures) {
        ReportInputData.JavaEEVersion targetJavaEE;
        HashSet<String> possibleEEFeatures = new HashSet<String>();
        for (String possibleFeature : possibleFeatures) {
            if (!possibleFeature.startsWith(featurePrefix)) continue;
            possibleEEFeatures.add(possibleFeature);
        }
        ReportInputData.JavaEEVersion javaEEVersion = targetJavaEE = _data != null ? _data.getTargetJavaEE() : null;
        if (null != targetJavaEE && DriveScanGenerateConfig.isEEFeature(featurePrefix)) {
            Set<String> features = libertyJavaEEFeatures.get((Object)targetJavaEE);
            for (String feature : features) {
                String prefix = DriveScanGenerateConfig.getPrefix(feature);
                if (!prefix.equals(featurePrefix)) continue;
                if (libertyCoreFeatures.containsKey(featurePrefix)) {
                    coreFeatures.add(feature);
                } else {
                    baseFeatures.add(feature);
                }
                return true;
            }
        }
        Set<Object> ee6Features = new HashSet();
        if (!isOpenLiberty && !isEASe) {
            ee6Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE6);
        }
        Set<String> ee7Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE7);
        Set<String> ee8Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE8);
        Set<String> ee9Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE9);
        Set<String> ee10Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE10);
        EnumSet<ReportInputData.JavaEEVersion> javaEEVersionsRecommended = EnumSet.noneOf(ReportInputData.JavaEEVersion.class);
        for (String coreFeature : coreFeatures) {
            if (coreFeature.startsWith("appSecurity")) continue;
            if (ee6Features.contains(coreFeature)) {
                javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE6);
                continue;
            }
            if (ee7Features.contains(coreFeature)) {
                javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE7);
                continue;
            }
            if (ee8Features.contains(coreFeature)) {
                javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE8);
                continue;
            }
            if (ee9Features.contains(coreFeature)) {
                javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE9);
                continue;
            }
            if (!ee10Features.contains(coreFeature)) continue;
            javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE10);
        }
        for (String baseFeature : baseFeatures) {
            if (ee6Features.contains(baseFeature)) {
                javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE6);
                continue;
            }
            if (ee7Features.contains(baseFeature)) {
                javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE7);
                continue;
            }
            if (ee8Features.contains(baseFeature)) {
                javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE8);
                continue;
            }
            if (ee9Features.contains(baseFeature)) {
                javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE9);
                continue;
            }
            if (!ee10Features.contains(baseFeature)) continue;
            javaEEVersionsRecommended.add(ReportInputData.JavaEEVersion.EE10);
        }
        if (javaEEVersionsRecommended.isEmpty() && _data != null && _data.getTargetJavaEE() != null) {
            javaEEVersionsRecommended.add(_data.getTargetJavaEE());
        }
        boolean featureRecommended = false;
        if (!javaEEVersionsRecommended.isEmpty()) {
            ReportInputData.JavaEEVersion highestVersion = ReportInputData.JavaEEVersion.EE6;
            for (ReportInputData.JavaEEVersion eeVersion : javaEEVersionsRecommended) {
                if (highestVersion.getVersionNumber() >= eeVersion.getVersionNumber()) continue;
                highestVersion = eeVersion;
            }
            Set<String> recommendedVersionFeatures = libertyJavaEEFeatures.get((Object)highestVersion);
            for (String possibleEEFeature : possibleEEFeatures) {
                if (!recommendedVersionFeatures.contains(possibleEEFeature)) continue;
                if (libertyCoreFeatures.containsKey(featurePrefix)) {
                    coreFeatures.add(possibleEEFeature);
                } else {
                    baseFeatures.add(possibleEEFeature);
                }
                featureRecommended = true;
                break;
            }
        }
        return featureRecommended;
    }

    @Override
    public Map<String, Rule> getRules() {
        if (this._rules == null) {
            this._builder = ReportBuilderHelper.loadConfigRules(this.isLiberty);
            if (this._builder._foundInvalidRule) {
                return null;
            }
            this._rules = this._builder._reportRules;
            this.addConfigRule(this._rules);
        }
        return this._rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized <T> void loadLists(Class<T> caller) {
        if (!loadListsCalled) {
            DriveScanGenerateConfig.loadOpenFeatureList(caller, openLibertyFeatures);
            DriveScanGenerateConfig.loadCoreFeatureList(caller, LIBERTY_CORE_FEATURES, libertyCoreFeatures);
            _featureListResource = DriveScanGenerateConfig.loadBaseFeatureList(caller, LIBERTY_BASE_FEATURES, libertyBaseFeatures, libertyJavaEEFeatures, libertyCoreFeatures);
            InputStream inStream = caller.getResourceAsStream(PACKAGE_TO_FEATURE_LIST_FILE);
            BufferedInputStream bis = new BufferedInputStream(inStream);
            try {
                Document doc = FileHelper.getParsedDocument(bis);
                List<Node> children = XMLRuleUtil.getTagDeclarations(doc, "*", new String[]{"package"});
                for (Node nextPackageNode : children) {
                    String nextPackage = XMLRuleUtil.getAttributeValue(nextPackageNode.getAttributes(), "*", attribute);
                    HashSet<String> features = new HashSet<String>();
                    packageToFeaturesMap.put(nextPackage, features);
                    List<Element> featureNodes = XMLRuleUtil.getChildElements((Element)nextPackageNode, "*", "feature");
                    for (Element nextFeatureNode : featureNodes) {
                        Set<Object> packages;
                        String nextFeature = XMLRuleUtil.getAttributeValue(nextFeatureNode.getAttributes(), "*", attribute);
                        if (isOpenLiberty && !openLibertyFeatures.contains(nextFeature) || isEASe && FEATURES_NOT_IN_EASE.contains(nextFeature)) continue;
                        features.add(nextFeature);
                        if (featureToPackagesMap.containsKey(nextFeature)) {
                            packages = featureToPackagesMap.get(nextFeature);
                            packages.add(nextPackage);
                            continue;
                        }
                        packages = new HashSet();
                        packages.add(nextPackage);
                        featureToPackagesMap.put(nextFeature, packages);
                    }
                }
            }
            catch (Exception e) {
                ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Loading_Feature_List"), PACKAGE_TO_FEATURE_LIST_FILE, e.getMessage()));
            }
            finally {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
                loadListsCalled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Document loadCoreFeatureList(Class<T> caller, String fileName, Map<String, Set<String>> featureList) {
        InputStream inStream = caller.getResourceAsStream(fileName);
        BufferedInputStream bis = new BufferedInputStream(inStream);
        Document doc = null;
        try {
            doc = FileHelper.getParsedDocument(bis);
            List<Node> featureNodes = XMLRuleUtil.getTagDeclarationsByAttributeValue(doc, fileName, xmlFileList, "*", tags, "*", attribute, null);
            for (Node node : featureNodes) {
                Set<Object> featureVersions;
                String feature = node.getNodeValue();
                if (!feature.contains("-") || isOpenLiberty && !openLibertyFeatures.contains(feature) || isEASe && FEATURES_NOT_IN_EASE.contains(feature)) continue;
                String prefix = DriveScanGenerateConfig.getPrefix(feature);
                if (featureList.containsKey(prefix)) {
                    featureVersions = featureList.get(prefix);
                    featureVersions.add(feature);
                    continue;
                }
                featureVersions = new HashSet();
                featureVersions.add(feature);
                featureList.put(prefix, featureVersions);
            }
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Loading_Feature_List"), fileName, e.getMessage()));
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Document loadBaseFeatureList(Class<T> caller, String fileName, Map<String, Set<String>> featureList, Map<ReportInputData.JavaEEVersion, Set<String>> javaeeFeatureList, Map<String, Set<String>> ignoreFeatures) {
        InputStream inStream = caller.getResourceAsStream(fileName);
        BufferedInputStream bis = new BufferedInputStream(inStream);
        Document doc = null;
        try {
            doc = FileHelper.getParsedDocument(bis);
            List<Node> featureNodes = XMLRuleUtil.getTagDeclarations(doc, fileName, xmlFileList, "*", tags);
            HashMap<String, Set<String>> featureToEnabledFeatures = new HashMap<String, Set<String>>();
            for (Node node : featureNodes) {
                String feature = XMLRuleUtil.getAttributeValue(node.getAttributes(), "*", attribute);
                if (!feature.contains("-")) continue;
                String prefix = DriveScanGenerateConfig.getPrefix(feature);
                if (!(isOpenLiberty && !openLibertyFeatures.contains(feature) || isEASe && FEATURES_NOT_IN_EASE.contains(feature) || ignoreFeatures != null && ignoreFeatures.containsKey(prefix) && ignoreFeatures.get(prefix).contains(feature))) {
                    Set<Object> featureVersions;
                    if (featureList.containsKey(prefix)) {
                        featureVersions = featureList.get(prefix);
                        featureVersions.add(feature);
                    } else {
                        featureVersions = new HashSet();
                        featureVersions.add(feature);
                        featureList.put(prefix, featureVersions);
                    }
                }
                featureToEnabledFeatures.put(feature, DriveScanGenerateConfig.getEnabledFeatures(node));
            }
            if (!isOpenLiberty && !isEASe) {
                Set ee6Features = (Set)featureToEnabledFeatures.get(ReportInputData.JavaEEVersion.EE6.getConvenienceFeature());
                ee6Features.addAll(JAVAEE6_FEATURE_LIST);
                javaeeFeatureList.put(ReportInputData.JavaEEVersion.EE6, ee6Features);
            }
            javaeeFeatureList.put(ReportInputData.JavaEEVersion.EE7, (Set<String>)featureToEnabledFeatures.get(ReportInputData.JavaEEVersion.EE7.getConvenienceFeature()));
            javaeeFeatureList.put(ReportInputData.JavaEEVersion.EE8, (Set<String>)featureToEnabledFeatures.get(ReportInputData.JavaEEVersion.EE8.getConvenienceFeature()));
            javaeeFeatureList.put(ReportInputData.JavaEEVersion.EE9, (Set<String>)featureToEnabledFeatures.get(ReportInputData.JavaEEVersion.EE9.getConvenienceFeature()));
            javaeeFeatureList.put(ReportInputData.JavaEEVersion.EE10, (Set<String>)featureToEnabledFeatures.get(ReportInputData.JavaEEVersion.EE10.getConvenienceFeature()));
            for (Set set : javaeeFeatureList.values()) {
                Set<String> existingPrefix = DriveScanGenerateConfig.getFeaturesListPrefixes(set);
                HashSet<String> childFeatures = new HashSet<String>();
                for (String parentFeature : set) {
                    Set enabledFeatures = (Set)featureToEnabledFeatures.get(parentFeature);
                    for (String enabledFeature : enabledFeatures) {
                        String enabledPrefix = DriveScanGenerateConfig.getPrefix(enabledFeature);
                        if (existingPrefix.contains(enabledPrefix)) continue;
                        childFeatures.add(enabledFeature);
                    }
                }
                set.addAll(childFeatures);
            }
        }
        catch (Exception e) {
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Loading_Feature_List"), fileName, e.getMessage()));
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException iOException) {}
        }
        return doc;
    }

    private static Set<String> getFeaturesListPrefixes(Set<String> featuresList) {
        HashSet<String> prefixes = new HashSet<String>();
        for (String feature : featuresList) {
            String prefix = DriveScanGenerateConfig.getPrefix(feature);
            prefixes.add(prefix);
        }
        return prefixes;
    }

    private static Set<String> getEnabledFeatures(Node featureNode) {
        HashSet<String> enabledFeatures = new HashSet<String>();
        List<Element> enabledNodes = XMLRuleUtil.getChildElements((Element)featureNode, "*", "enables");
        for (Element enabledNode : enabledNodes) {
            String enabledFeature = XMLRuleUtil.getTextWithoutWhitespace(enabledNode);
            enabledFeatures.add(enabledFeature);
        }
        return enabledFeatures;
    }

    private boolean processRules(Set<String> featureNames, Set<String> ruleFeatures, Map<String, Set<String>> featureList, Map<String, List<String>> requiredFeatures, Map<ReportInputData.JavaEEVersion, Set<String>> libertyEEFeatures, ReportInputData.JavaEEVersion targetJavaEEVersion, Map<String, String> preferredFeaturesVersion, Map<String, String> currentFeatures) {
        Set<String> validEEFeatures = null;
        HashSet<String> invalidEEFeatures = null;
        boolean conflictingrequiredPrefixes = false;
        HashSet<String> seenPrefixes = new HashSet<String>();
        if (targetJavaEEVersion != null) {
            validEEFeatures = libertyEEFeatures.get((Object)targetJavaEEVersion);
            invalidEEFeatures = new HashSet<String>();
            if (validEEFeatures != null && !validEEFeatures.isEmpty()) {
                for (Map.Entry<ReportInputData.JavaEEVersion, Set<String>> entry : libertyEEFeatures.entrySet()) {
                    ReportInputData.JavaEEVersion version = entry.getKey();
                    Set<String> list = entry.getValue();
                    if (version == targetJavaEEVersion) continue;
                    for (String feature : list) {
                        if (validEEFeatures.contains(feature) && (!isOpenLiberty || openLibertyFeatures.contains(feature)) && (!isEASe || !FEATURES_NOT_IN_EASE.contains(feature))) continue;
                        invalidEEFeatures.add(feature);
                    }
                }
            }
        }
        boolean sendMessageAboutAppMigrationIssues = false;
        String prefix = null;
        for (String featureFromRule : ruleFeatures) {
            String[] featureFromRuleArr = featureFromRule.split(",");
            boolean breakFeatureFromRuleArrLoop = false;
            for (int i = 0; i < featureFromRuleArr.length; ++i) {
                Object currentFeature;
                boolean required = false;
                Object finalFeature = null;
                boolean detectedVersion = featureFromRuleArr[i].contains("-");
                prefix = DriveScanGenerateConfig.getPrefix(featureFromRuleArr[i]);
                boolean dontAddOtherPrefixes = false;
                if (featureFromRuleArr.length > 1) {
                    if (!ruleFeatures.contains(featureFromRuleArr[i])) {
                        boolean foundOtherFeatureFromThisRuleInDifferentRule = false;
                        for (int j = 0; j < featureFromRuleArr.length; ++j) {
                            if (!ruleFeatures.contains(featureFromRuleArr[j])) continue;
                            foundOtherFeatureFromThisRuleInDifferentRule = true;
                            break;
                        }
                        if (foundOtherFeatureFromThisRuleInDifferentRule) {
                            continue;
                        }
                    } else {
                        dontAddOtherPrefixes = true;
                    }
                }
                String javaEEPrefix = JakartaJavaEEFeatureVersions.JAKARTA_PREFIXES_TO_JAVAEE_PREFIXES.get(prefix);
                String jakartaEEPrefix = JakartaJavaEEFeatureVersions.JAVAEE_PREFIXES_TO_JAKARTA_PREFIXES.get(prefix);
                Set<String> matchingFeaturesFromList = featureList.get(prefix);
                HashSet<String> matchingFeatures = new HashSet<String>();
                if (null != matchingFeaturesFromList) {
                    matchingFeatures.addAll(matchingFeaturesFromList);
                }
                if (null != jakartaEEPrefix && !dontAddOtherPrefixes) {
                    this.addAlternateMatchingPrefixesIfRequired(jakartaEEPrefix, featureFromRule, matchingFeatures, featureList);
                }
                if (null != javaEEPrefix && !dontAddOtherPrefixes) {
                    this.addAlternateMatchingPrefixesIfRequired(javaEEPrefix, featureFromRule, matchingFeatures, featureList);
                }
                if (matchingFeatures == null || matchingFeatures.isEmpty()) continue;
                if (currentFeatures.containsKey(prefix) && featureFromRule.contains((CharSequence)(currentFeature = currentFeatures.get(prefix))) || currentFeatures.containsKey(jakartaEEPrefix) && featureFromRule.contains((CharSequence)(currentFeature = currentFeatures.get(jakartaEEPrefix)))) break;
                if (targetJavaEEVersion != null && !validEEFeatures.isEmpty()) {
                    if (targetJavaEEVersion.compareTo(ReportInputData.JavaEEVersion.EE8) <= 0) {
                        if (javaEEPrefix != null) {
                            sendMessageAboutAppMigrationIssues = true;
                            prefix = javaEEPrefix;
                        }
                    } else if (jakartaEEPrefix != null) {
                        sendMessageAboutAppMigrationIssues = true;
                        prefix = jakartaEEPrefix;
                    }
                    currentFeature = validEEFeatures.iterator();
                    while (currentFeature.hasNext()) {
                        String eeFeature = (String)currentFeature.next();
                        if (!prefix.equals(DriveScanGenerateConfig.getPrefix(eeFeature))) continue;
                        finalFeature = eeFeature;
                        required = true;
                        boolean eeFeatureEqualToOneFeatureFromRule = false;
                        for (int j = 0; j < featureFromRuleArr.length; ++j) {
                            if (!eeFeature.equals(featureFromRuleArr[j])) continue;
                            eeFeatureEqualToOneFeatureFromRule = true;
                        }
                        if (detectedVersion && !eeFeatureEqualToOneFeatureFromRule || sendMessageAboutAppMigrationIssues) {
                            if (targetJavaEEVersion == ReportInputData.JavaEEVersion.EE7 && JAVAEE7_TOLERATED_LIST.contains(featureFromRuleArr[i]) && !_data.isGenerateTA()) {
                                ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_JavaEE7ToleratedFeatures"), new Object[]{featureFromRule, targetJavaEEVersion.getTargetJavaEEOption(), targetJavaEEVersion, finalFeature}));
                            } else if (!_data.isGenerateTA()) {
                                sendMessageAboutAppMigrationIssues = true;
                            }
                            if (this.featureAPIRunning) {
                                this.modifiedRequiredFeatures.add(featureFromRule);
                            }
                        }
                        breakFeatureFromRuleArrLoop = true;
                        break;
                    }
                }
                if (finalFeature == null) {
                    if (detectedVersion) {
                        if (matchingFeatures.contains(featureFromRuleArr[i])) {
                            if (targetJavaEEVersion != null && invalidEEFeatures.contains(featureFromRuleArr[i]) && !_data.isGenerateTA()) {
                                sendMessageAboutAppMigrationIssues = true;
                            } else {
                                finalFeature = preferredFeaturesVersion != null && !preferredFeaturesVersion.isEmpty() && preferredFeaturesVersion.containsKey(prefix) ? preferredFeaturesVersion.get(prefix) : featureFromRuleArr[i];
                                required = true;
                            }
                        }
                    } else {
                        finalFeature = preferredFeaturesVersion != null && !preferredFeaturesVersion.isEmpty() && preferredFeaturesVersion.containsKey(prefix) ? preferredFeaturesVersion.get(prefix) : DriveScanGenerateConfig.getLatestVersionOfFeature(matchingFeatures);
                        if (targetJavaEEVersion != null && !matchingFeatures.isEmpty()) {
                            HashSet<String> validFeatures = new HashSet<String>();
                            validFeatures.addAll(matchingFeatures);
                            while (finalFeature != null && !validFeatures.isEmpty()) {
                                validFeatures.remove(finalFeature);
                                if (!invalidEEFeatures.contains(finalFeature)) continue;
                                finalFeature = DriveScanGenerateConfig.getLatestVersionOfFeature(validFeatures);
                            }
                            if (finalFeature == null && !_data.isGenerateTA()) {
                                sendMessageAboutAppMigrationIssues = true;
                            }
                            if (finalFeature == null && DriveScanGenerateConfig.isEEFeature(prefix)) {
                                this.unavailableEEFeatures.add(prefix);
                            }
                        }
                    }
                }
                if (finalFeature == null) continue;
                boolean commonFeatureInRequiredPrefixes = false;
                featureNames.add((String)finalFeature);
                if (required) {
                    if (i == 0 && seenPrefixes.contains(prefix)) {
                        for (String feature : requiredFeatures.get(prefix)) {
                            if (!featureFromRule.contains(feature)) continue;
                            commonFeatureInRequiredPrefixes = true;
                            break;
                        }
                    }
                    if (requiredFeatures.keySet().contains(prefix)) {
                        requiredFeatures.get(prefix).add((String)finalFeature);
                    } else {
                        ArrayList<String> featureVersions = new ArrayList<String>();
                        featureVersions.add((String)finalFeature);
                        requiredFeatures.put(prefix, featureVersions);
                    }
                    if (i == 0 && seenPrefixes.contains(prefix) && !commonFeatureInRequiredPrefixes) {
                        conflictingrequiredPrefixes = true;
                    } else {
                        seenPrefixes.add(prefix);
                    }
                }
                if (breakFeatureFromRuleArrLoop) break;
            }
            if (!sendMessageAboutAppMigrationIssues || _data.isAnalysisReport()) continue;
            ReportUtility.logger.get().log(Level.INFO, Messages.getFormattedMessage(Messages.getString("DriveScanGenerateConfig_ConflictingLibrariesWithTargetJavaEE"), new Object[]{targetJavaEEVersion}));
        }
        return conflictingrequiredPrefixes;
    }

    private void addAlternateMatchingPrefixesIfRequired(String alternativePrefix, String featureFromRule, Set<String> matchingFeatures, Map<String, Set<String>> featureList) {
        Set<String> matchingAlternativeVersionsOfFeature;
        if (featureFromRule.contains(alternativePrefix) && null != (matchingAlternativeVersionsOfFeature = featureList.get(alternativePrefix))) {
            matchingFeatures.addAll(matchingAlternativeVersionsOfFeature);
        }
    }

    private void loadPreferredFeatureList(Map<String, String> preferredFeaturesVersion, Set<String> detectedFeatures, ReportInputData.JavaEEVersion sourceJavaEE, ReportInputData.AppServer sourceAppServer) {
        HashMap<String, String> overrideFeatures = new HashMap<String, String>();
        if (sourceJavaEE == ReportInputData.JavaEEVersion.EE6 && detectedFeatures.contains(EL_FEATURE_PREFIX)) {
            overrideFeatures.put(EL_FEATURE_PREFIX, JSP_2_2_FEATURE);
        }
        ReportUtility.logger.get().log(Level.FINE, "DriveScanGenerateConfig: starting " + (Object)((Object)sourceJavaEE) + " feature level resolution...");
        DriveScanGenerateConfig.loadPrefixToFeatureVersion(preferredFeaturesVersion, libertyJavaEEFeatures.get((Object)sourceJavaEE), detectedFeatures, overrideFeatures, sourceJavaEE, true);
        ReportUtility.logger.get().log(Level.FINE, "DriveScanGenerateConfig: ending " + (Object)((Object)sourceJavaEE) + " feature level resolution...");
        overrideFeatures.clear();
        if ((preferredFeaturesVersion == null || preferredFeaturesVersion.isEmpty()) && (sourceJavaEE == ReportInputData.JavaEEVersion.EE6 || sourceJavaEE == ReportInputData.JavaEEVersion.EE7 && detectedFeatures.contains(JPA_20_FEATURE) && !isOpenLiberty)) {
            if (!isOpenLiberty && !isEASe && (detectedFeatures.contains(JPA_FEATURE_PREFIX) || detectedFeatures.contains(JPA_20_FEATURE))) {
                overrideFeatures.put(JPA_FEATURE_PREFIX, JPA_20_FEATURE);
            }
            ReportUtility.logger.get().log(Level.FINE, "DriveScanGenerateConfig: the binary scanner is attempting to load a mixed ee7 feature list with " + overrideFeatures);
            DriveScanGenerateConfig.loadPrefixToFeatureVersion(preferredFeaturesVersion, libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE7), detectedFeatures, overrideFeatures, ReportInputData.JavaEEVersion.EE7, true);
        }
        if ((preferredFeaturesVersion == null || preferredFeaturesVersion.isEmpty()) && sourceAppServer != null) {
            DriveScanGenerateConfig.loadPrefixToFeatureVersion(preferredFeaturesVersion, libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE7), detectedFeatures, overrideFeatures, sourceJavaEE, false);
        }
    }

    private static void loadPrefixToFeatureVersion(Map<String, String> preferredFeaturesVersion, Set<String> allVersionedFeatures, Set<String> detectedFeatures, Map<String, String> overrideFeatures, ReportInputData.JavaEEVersion sourceJavaEE, boolean returnNullForConflicts) {
        HashMap<String, String> allPrefixToFeatureVersion = new HashMap<String, String>();
        for (String featureWithVersion : allVersionedFeatures) {
            String featurePrefix = DriveScanGenerateConfig.getPrefix(featureWithVersion);
            allPrefixToFeatureVersion.put(featurePrefix, featureWithVersion);
        }
        if (overrideFeatures != null) {
            allPrefixToFeatureVersion.putAll(overrideFeatures);
        }
        HashSet<String> missingFeatures = new HashSet<String>();
        Set allprefixes = allPrefixToFeatureVersion.keySet();
        if (returnNullForConflicts) {
            for (String string : detectedFeatures) {
                int n;
                String missingFeaturePrefix;
                String[] versionedFeature;
                if (allprefixes.contains(string) || !DriveScanGenerateConfig.isEEFeature(string)) continue;
                boolean isFeatureMissing = true;
                if (string.contains("-") && (versionedFeature = (String[])allPrefixToFeatureVersion.get(missingFeaturePrefix = DriveScanGenerateConfig.getPrefix(string))) != null) {
                    String[] stringArray = string.split(",");
                    n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String feature = stringArray[i];
                        if (!feature.equals(versionedFeature)) continue;
                        isFeatureMissing = false;
                        break;
                    }
                }
                if (string.contains(",")) {
                    String[] features;
                    versionedFeature = features = string.split(",");
                    int n2 = versionedFeature.length;
                    for (n = 0; n < n2; ++n) {
                        String feature = versionedFeature[n];
                        if (!allPrefixToFeatureVersion.containsKey(feature)) continue;
                        isFeatureMissing = false;
                        break;
                    }
                }
                if (!isFeatureMissing) continue;
                missingFeatures.add(string);
            }
        } else {
            ReportUtility.logger.get().log(Level.FINE, "DriveScanGenerateConfig: Loading the feature list for " + (Object)((Object)sourceJavaEE) + " regardless of conflicts or missing features because returnNullForConflicts is " + returnNullForConflicts);
        }
        if (missingFeatures.isEmpty()) {
            preferredFeaturesVersion.putAll(allPrefixToFeatureVersion);
            for (Map.Entry entry : JakartaJavaEEFeatureVersions.JAKARTA_PREFIXES_TO_JAVAEE_PREFIXES.entrySet()) {
                String jakartaEEFeaturePrefix = (String)entry.getKey();
                String javaEEFeaturePrefix = (String)entry.getValue();
                if (sourceJavaEE.compareTo(ReportInputData.JavaEEVersion.EE9) < 0) {
                    String javaEEFeatureForJakartaPrefix = (String)allPrefixToFeatureVersion.get(javaEEFeaturePrefix);
                    preferredFeaturesVersion.put(jakartaEEFeaturePrefix, javaEEFeatureForJakartaPrefix);
                    continue;
                }
                String jakartaEEFeatureForJavaEEPrefix = (String)allPrefixToFeatureVersion.get(jakartaEEFeaturePrefix);
                preferredFeaturesVersion.put(javaEEFeaturePrefix, jakartaEEFeatureForJavaEEPrefix);
            }
            ReportUtility.logger.get().log(Level.FINE, "DriveScanGenerateConfig: the binary scanner was able to find all features detected by the applications.");
        } else {
            ReportUtility.logger.get().log(Level.FINE, "DriveScanGenerateConfig: the binary scanner could not resolve all features detected by the application.");
            ReportUtility.logger.get().log(Level.FINE, "DriveScanGenerateConfig: missing features: " + missingFeatures);
            ReportUtility.logger.get().log(Level.FINE, "DriveScanGenerateConfig: full Liberty EE feature list: " + allPrefixToFeatureVersion);
        }
    }

    private static String getLatestCompatibleVersionOfFeature(Set<String> featuresWithVersions, List<String> allFeatures) {
        ArrayList<String> listOfFeaturesWithVersions = new ArrayList<String>(featuresWithVersions);
        Collections.sort(listOfFeaturesWithVersions, new Comparator<String>(){

            private int major(String[] version) {
                return Integer.parseInt(version[0]);
            }

            private Integer minor(String[] version) {
                return version.length > 1 ? Integer.parseInt(version[1]) : 0;
            }

            @Override
            public int compare(String o1, String o2) {
                int major2;
                String[] v1 = o1.split("-")[1].split("\\.");
                String[] v2 = o2.split("-")[1].split("\\.");
                int major1 = this.major(v1);
                if (major1 == (major2 = this.major(v2))) {
                    return this.minor(v2).compareTo(this.minor(v1));
                }
                return major2 > major1 ? 1 : -1;
            }
        });
        String latestFeature = (String)listOfFeaturesWithVersions.get(0);
        for (String feature : listOfFeaturesWithVersions) {
            allFeatures.add(feature);
            FeatureListFeatureResolver.ResolverResult result = FeatureListFeatureResolver.resolve(_featureListResource, allFeatures);
            Set<FeatureListFeatureResolver.FeatureConflict> conflicts = result.getFeatureConflicts();
            if (conflicts.isEmpty()) {
                return feature;
            }
            allFeatures.remove(feature);
        }
        return latestFeature;
    }

    private static String getLatestVersionOfFeature(Set<String> featuresWithVersions) {
        String latestFeature = null;
        for (String nextFeatureWithVersion : featuresWithVersions) {
            if (latestFeature != null && !FeatureUtil.isLowerVersionWithoutNameCheck(latestFeature, nextFeatureWithVersion)) continue;
            latestFeature = nextFeatureWithVersion;
        }
        return latestFeature;
    }

    private static String getPreviousVersionOfFeature(Set<String> featuresWithVersions, String feature) {
        String previousFeature = null;
        for (String nextFeatureWithVersion : featuresWithVersions) {
            if (nextFeatureWithVersion.equals(feature) || !FeatureUtil.isLowerVersionWithoutNameCheck(nextFeatureWithVersion, feature) || previousFeature != null && !FeatureUtil.isLowerVersionWithoutNameCheck(previousFeature, nextFeatureWithVersion)) continue;
            previousFeature = nextFeatureWithVersion;
        }
        return previousFeature;
    }

    private static String getLaterVersionOfFeature(Set<String> featuresWithVersions, String feature) {
        String laterFeature = null;
        for (String nextFeatureWithVersion : featuresWithVersions) {
            if (nextFeatureWithVersion.equals(feature) || !FeatureUtil.isLowerVersionWithoutNameCheck(feature, nextFeatureWithVersion) || laterFeature != null && !FeatureUtil.isLowerVersionWithoutNameCheck(nextFeatureWithVersion, laterFeature)) continue;
            laterFeature = nextFeatureWithVersion;
        }
        return laterFeature;
    }

    @Override
    public Map<ReportInputData.OutputType, String> generateReport() {
        return null;
    }

    public void setDefaultTargetJavaEEVersion(SortedSet<String> coreFeatures, SortedSet<String> baseFeatures) {
        if (_data.getTargetJavaEE() == null && _data.getTargetAppServer() != null && _data.getTargetAppServer().isLiberty()) {
            boolean isEE6Valid = true;
            boolean isEE7Valid = true;
            boolean isEE8Valid = true;
            HashSet<String> allFeatures = new HashSet<String>();
            allFeatures.addAll(coreFeatures);
            allFeatures.addAll(baseFeatures);
            for (String feature : allFeatures) {
                boolean compatibleEE8 = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE8).contains(feature);
                boolean compatibleEE7 = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE7).contains(feature) || JAVAEE7_TOLERATED_LIST.contains(feature);
                boolean compatibleEE6 = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE6).contains(feature);
                if (!compatibleEE8 && !compatibleEE7 && !compatibleEE6) continue;
                if (!compatibleEE8) {
                    isEE8Valid = false;
                }
                if (!compatibleEE7) {
                    isEE7Valid = false;
                }
                if (compatibleEE6) continue;
                isEE6Valid = false;
            }
            if (isEE6Valid) {
                _data.setTargetJavaEE(ReportInputData.JavaEEVersion.EE6);
            } else if (isEE7Valid) {
                _data.setTargetJavaEE(ReportInputData.JavaEEVersion.EE7);
            } else if (isEE8Valid) {
                _data.setTargetJavaEE(ReportInputData.JavaEEVersion.EE8);
            } else {
                _data.setTargetJavaEE(ReportInputData.JavaEEVersion.EE6);
            }
        }
    }

    public Map<ReportInputData.JavaEEVersion, Set<String>> getLibertyJavaEEJakartaFeatures() {
        return libertyJavaEEFeatures;
    }

    private boolean validateFeature(String feature) {
        boolean validFeature = false;
        if (libertyCoreFeatures.keySet().contains(feature) || libertyBaseFeatures.keySet().contains(feature)) {
            validFeature = true;
        } else if (feature.contains("-")) {
            String prefix = DriveScanGenerateConfig.getPrefix(feature);
            Set<String> coreFeaturesList = libertyCoreFeatures.get(prefix);
            if (coreFeaturesList != null && coreFeaturesList.contains(feature)) {
                validFeature = true;
            } else {
                Set<String> baseFeaturesList = libertyBaseFeatures.get(prefix);
                if (baseFeaturesList != null && baseFeaturesList.contains(feature)) {
                    validFeature = true;
                }
            }
        }
        return validFeature;
    }

    private String removePackageFromFeature(String feature) {
        if (feature == null) {
            return feature;
        }
        feature = feature.replace("com.ibm.websphere.appserver.", "");
        feature = feature.replace("io.openliberty.appserver.", "");
        feature = feature.replace("io.openliberty.", "");
        return feature;
    }

    private ReportInputData.JavaEEVersion getJavaEEVersionOfFeature(String feature) {
        Set<Object> ee6Features = new HashSet();
        if (!isOpenLiberty && !isEASe) {
            ee6Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE6);
        }
        Set<String> ee7Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE7);
        Set<String> ee8Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE8);
        Set<String> ee9Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE9);
        Set<String> ee10Features = libertyJavaEEFeatures.get((Object)ReportInputData.JavaEEVersion.EE10);
        if (ee6Features.contains(feature)) {
            return ReportInputData.JavaEEVersion.EE6;
        }
        if (ee7Features.contains(feature)) {
            return ReportInputData.JavaEEVersion.EE7;
        }
        if (ee8Features.contains(feature)) {
            return ReportInputData.JavaEEVersion.EE8;
        }
        if (ee9Features.contains(feature)) {
            return ReportInputData.JavaEEVersion.EE9;
        }
        if (ee10Features.contains(feature)) {
            return ReportInputData.JavaEEVersion.EE10;
        }
        return null;
    }

    private static String getPrefix(String feature) {
        if (feature.contains("-")) {
            return feature.substring(0, feature.indexOf(45));
        }
        return feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void loadOpenFeatureList(Class<T> caller, Set<String> openLibertyFeatures) {
        InputStream inStream = caller.getResourceAsStream(OPEN_LIBERTY_FEATURES);
        BufferedInputStream bis = new BufferedInputStream(inStream);
        try {
            JSONObject jsonObject = (JSONObject)JSON.parse(bis);
            JSONArray jsonArray = (JSONArray)jsonObject.get("features");
            for (Object feature : jsonArray) {
                openLibertyFeatures.add((String)feature);
            }
        }
        catch (IOException e) {
            ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("DriveScan_Error_Loading_Feature_List"), OPEN_LIBERTY_FEATURES, e.getMessage()));
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Set<String> getOpenFeatures() {
        return openLibertyFeatures;
    }

    static {
        PREFERRED_JAR_FEATURE_MAP.put("com.ibm.ws.javaee.servlet", "servlet");
        PREFERRED_JAR_FEATURE_MAP.put("com.ibm.ws.javaee.dd.ejb", "ejbLite");
        PREFERRED_JAR_FEATURE_MAP.put("com.ibm.ws.javaee.ejb", "ejbLite");
        PREFERRED_JAR_FEATURE_MAP.put("com.ibm.ws.javaee.jsp", "jsp");
        PREFERRED_JAR_FEATURE_MAP.put("com.ibm.ws.javaee.jaxws", "javaws");
        PREFERRED_JAR_FEATURE_MAP.put("com.ibm.ws.javaee.jaxrs", "jaxrs");
        PREFERRED_MP1_FEATURE.put("mpConfig", "mpConfig-1.3");
        PREFERRED_MP1_FEATURE.put("mpFaultTolerance", "mpFaultTolerance-1.1");
        PREFERRED_MP1_FEATURE.put("mpHealth", "mpHealth-1.0");
        PREFERRED_MP1_FEATURE.put("mpJwt", "mpJwt-1.1");
        PREFERRED_MP1_FEATURE.put("mpMetrics", "mpMetrics-1.1");
        PREFERRED_MP1_FEATURE.put("mpOpenAPI", "mpOpenAPI-1.0");
        PREFERRED_MP1_FEATURE.put("mpOpenTracing", "mpOpenTracing-1.1");
        PREFERRED_MP1_FEATURE.put("mpRestClient", "mpRestClient-1.1");
        PREFERRED_MP1_2_FEATURE.put("mpConfig", "mpConfig-1.1");
        PREFERRED_MP1_2_FEATURE.put("mpFaultTolerance", "mpFaultTolerance-1.0");
        PREFERRED_MP1_2_FEATURE.put("mpHealth", "mpHealth-1.0");
        PREFERRED_MP1_2_FEATURE.put("mpJwt", "mpJwt-1.0");
        PREFERRED_MP1_2_FEATURE.put("mpMetrics", "mpMetrics-1.0");
        PREFERRED_MP1_3_FEATURE.put("mpConfig", "mpConfig-1.2");
        PREFERRED_MP1_3_FEATURE.put("mpFaultTolerance", "mpFaultTolerance-1.0");
        PREFERRED_MP1_3_FEATURE.put("mpHealth", "mpHealth-1.0");
        PREFERRED_MP1_3_FEATURE.put("mpJwt", "mpJwt-1.0");
        PREFERRED_MP1_3_FEATURE.put("mpMetrics", "mpMetrics-1.1");
        PREFERRED_MP1_3_FEATURE.put("mpOpenAPI", "mpOpenAPI-1.0");
        PREFERRED_MP1_3_FEATURE.put("mpOpenTracing", "mpOpenTracing-1.0");
        PREFERRED_MP1_3_FEATURE.put("mpRestClient", "mpRestClient-1.0");
        PREFERRED_MP2_FEATURE.put("mpConfig", "mpConfig-1.3");
        PREFERRED_MP2_FEATURE.put("mpFaultTolerance", "mpFaultTolerance-2.0");
        PREFERRED_MP2_FEATURE.put("mpHealth", "mpHealth-1.0");
        PREFERRED_MP2_FEATURE.put("mpJwt", "mpJwt-1.1");
        PREFERRED_MP2_FEATURE.put("mpMetrics", "mpMetrics-1.1");
        PREFERRED_MP2_FEATURE.put("mpOpenAPI", "mpOpenAPI-1.1");
        PREFERRED_MP2_FEATURE.put("mpOpenTracing", "mpOpenTracing-1.3");
        PREFERRED_MP2_FEATURE.put("mpRestClient", "mpRestClient-1.2");
        PREFERRED_MP2_0_FEATURE.put("mpConfig", "mpConfig-1.3");
        PREFERRED_MP2_0_FEATURE.put("mpFaultTolerance", "mpFaultTolerance-1.1");
        PREFERRED_MP2_0_FEATURE.put("mpHealth", "mpHealth-1.0");
        PREFERRED_MP2_0_FEATURE.put("mpJwt", "mpJwt-1.1");
        PREFERRED_MP2_0_FEATURE.put("mpMetrics", "mpMetrics-1.1");
        PREFERRED_MP2_0_FEATURE.put("mpOpenAPI", "mpOpenAPI-1.0");
        PREFERRED_MP2_0_FEATURE.put("mpOpenTracing", "mpOpenTracing-1.1");
        PREFERRED_MP2_0_FEATURE.put("mpRestClient", "mpRestClient-1.1");
        PREFERRED_MP2_1_FEATURE.put("mpConfig", "mpConfig-1.3");
        PREFERRED_MP2_1_FEATURE.put("mpFaultTolerance", "mpFaultTolerance-1.1");
        PREFERRED_MP2_1_FEATURE.put("mpHealth", "mpHealth-1.0");
        PREFERRED_MP2_1_FEATURE.put("mpJwt", "mpJwt-1.1");
        PREFERRED_MP2_1_FEATURE.put("mpMetrics", "mpMetrics-1.1");
        PREFERRED_MP2_1_FEATURE.put("mpOpenAPI", "mpOpenAPI-1.0");
        PREFERRED_MP2_1_FEATURE.put("mpOpenTracing", "mpOpenTracing-1.2");
        PREFERRED_MP2_1_FEATURE.put("mpRestClient", "mpRestClient-1.1");
        PREFERRED_MP3_FEATURE.put("mpConfig", "mpConfig-1.4");
        PREFERRED_MP3_FEATURE.put("mpFaultTolerance", "mpFaultTolerance-2.1");
        PREFERRED_MP3_FEATURE.put("mpHealth", "mpHealth-2.2");
        PREFERRED_MP3_FEATURE.put("mpJwt", "mpJwt-1.1");
        PREFERRED_MP3_FEATURE.put("mpMetrics", "mpMetrics-2.3");
        PREFERRED_MP3_FEATURE.put("mpOpenAPI", "mpOpenAPI-1.1");
        PREFERRED_MP3_FEATURE.put("mpOpenTracing", "mpOpenTracing-1.3");
        PREFERRED_MP3_FEATURE.put("mpRestClient", "mpRestClient-1.4");
        PREFERRED_MP3_0_FEATURE.put("mpConfig", "mpConfig-1.3");
        PREFERRED_MP3_0_FEATURE.put("mpFaultTolerance", "mpFaultTolerance-2.0");
        PREFERRED_MP3_0_FEATURE.put("mpHealth", "mpHealth-2.0");
        PREFERRED_MP3_0_FEATURE.put("mpJwt", "mpJwt-1.1");
        PREFERRED_MP3_0_FEATURE.put("mpMetrics", "mpMetrics-2.0");
        PREFERRED_MP3_0_FEATURE.put("mpOpenAPI", "mpOpenAPI-1.1");
        PREFERRED_MP3_0_FEATURE.put("mpOpenTracing", "mpOpenTracing-1.3");
        PREFERRED_MP3_0_FEATURE.put("mpRestClient", "mpRestClient-1.3");
        PREFERRED_MP3_2_FEATURE.put("mpConfig", "mpConfig-1.3");
        PREFERRED_MP3_2_FEATURE.put("mpFaultTolerance", "mpFaultTolerance-2.0");
        PREFERRED_MP3_2_FEATURE.put("mpHealth", "mpHealth-2.1");
        PREFERRED_MP3_2_FEATURE.put("mpJwt", "mpJwt-1.1");
        PREFERRED_MP3_2_FEATURE.put("mpMetrics", "mpMetrics-2.2");
        PREFERRED_MP3_2_FEATURE.put("mpOpenAPI", "mpOpenAPI-1.1");
        PREFERRED_MP3_2_FEATURE.put("mpOpenTracing", "mpOpenTracing-1.3");
        PREFERRED_MP3_2_FEATURE.put("mpRestClient", "mpRestClient-1.3");
        PREFERRED_MP4_FEATURE.put("mpConfig", "mpConfig-2.0");
        PREFERRED_MP4_FEATURE.put("mpFaultTolerance", "mpFaultTolerance-3.0");
        PREFERRED_MP4_FEATURE.put("mpHealth", "mpHealth-3.1");
        PREFERRED_MP4_FEATURE.put("mpJwt", "mpJwt-1.2");
        PREFERRED_MP4_FEATURE.put("mpMetrics", "mpMetrics-3.0");
        PREFERRED_MP4_FEATURE.put("mpOpenAPI", "mpOpenAPI-2.0");
        PREFERRED_MP4_FEATURE.put("mpOpenTracing", "mpOpenTracing-2.0");
        PREFERRED_MP4_FEATURE.put("mpRestClient", "mpRestClient-2.0");
        PREFERRED_MP4_0_FEATURE.put("mpConfig", "mpConfig-2.0");
        PREFERRED_MP4_0_FEATURE.put("mpFaultTolerance", "mpFaultTolerance-3.0");
        PREFERRED_MP4_0_FEATURE.put("mpHealth", "mpHealth-3.0");
        PREFERRED_MP4_0_FEATURE.put("mpJwt", "mpJwt-1.2");
        PREFERRED_MP4_0_FEATURE.put("mpMetrics", "mpMetrics-3.0");
        PREFERRED_MP4_0_FEATURE.put("mpOpenAPI", "mpOpenAPI-2.0");
        PREFERRED_MP4_0_FEATURE.put("mpOpenTracing", "mpOpenTracing-2.0");
        PREFERRED_MP4_0_FEATURE.put("mpRestClient", "mpRestClient-2.0");
        PREFERRED_MP5_FEATURE.put("mpConfig", "mpConfig-2.0");
        PREFERRED_MP5_FEATURE.put("mpFaultTolerance", "mpFaultTolerance-4.0");
        PREFERRED_MP5_FEATURE.put("mpHealth", "mpHealth-4.0");
        PREFERRED_MP5_FEATURE.put("mpJwt", "mpJwt-2.0");
        PREFERRED_MP5_FEATURE.put("mpMetrics", "mpMetrics-4.0");
        PREFERRED_MP5_FEATURE.put("mpOpenAPI", "mpOpenAPI-3.0");
        PREFERRED_MP5_FEATURE.put("mpOpenTracing", "mpOpenTracing-3.0");
        PREFERRED_MP5_FEATURE.put("mpRestClient", "mpRestClient-3.0");
        PREFERRED_MP6_FEATURE.put("mpConfig", "mpConfig-3.0");
        PREFERRED_MP6_FEATURE.put("mpFaultTolerance", "mpFaultTolerance-4.0");
        PREFERRED_MP6_FEATURE.put("mpHealth", "mpHealth-4.0");
        PREFERRED_MP6_FEATURE.put("mpJwt", "mpJwt-2.1");
        PREFERRED_MP6_FEATURE.put("mpMetrics", "mpMetrics-5.0");
        PREFERRED_MP6_FEATURE.put("mpOpenAPI", "mpOpenAPI-3.1");
        PREFERRED_MP6_FEATURE.put("mpTelemetry", "mpTelemetry-1.0");
        PREFERRED_MP6_FEATURE.put("mpRestClient", "mpRestClient-3.0");
        JAVAEE6_FEATURE_LIST.add("concurrent-1.0");
        JAVAEE6_FEATURE_LIST.add("jacc-1.5");
        JAVAEE6_FEATURE_LIST.add("jaspic-1.1");
        JAVAEE6_FEATURE_LIST.add("javaMail-1.5");
        JAVAEE6_FEATURE_LIST.add("jaxb-2.2");
        JAVAEE6_FEATURE_LIST.add("jaxrs-1.1");
        JAVAEE6_FEATURE_LIST.add("jaxws-2.2");
        JAVAEE6_FEATURE_LIST.add("jca-1.6");
        JAVAEE6_FEATURE_LIST.add("jcaInboundSecurity-1.0");
        JAVAEE6_FEATURE_LIST.add("jms-1.1");
        JAVAEE6_FEATURE_LIST.add("jmsMdb-3.1");
        JAVAEE6_FEATURE_LIST.add("jsonp-1.0");
        JAVAEE6_FEATURE_LIST.add("mdb-3.1");
        JAVAEE6_FEATURE_LIST.add("wasJmsClient-1.1");
        JAVAEE6_FEATURE_LIST.add("wasJmsSecurity-1.0");
        JAVAEE6_FEATURE_LIST.add("wasJmsServer-1.0");
        JAVAEE6_FEATURE_LIST.add("wmqJmsClient-1.1");
        JAVAEE6_FEATURE_LIST.add("ejbLite-3.1");
        FEATURES_NOT_IN_EASE.add("sessionCache-1.0 ");
        FEATURES_NOT_IN_EASE.add("sessionDatabase-1.0");
        FEATURES_NOT_IN_EASE.add("spnego-1.0");
        FEATURES_NOT_IN_EASE.add("constrainedDelegation-1.0");
        FEATURES_NOT_IN_EASE.add("adminCenter-1.0");
        FEATURES_NOT_IN_EASE.add("bells-1.0");
        FEATURES_NOT_IN_EASE.add("cdi-1.0");
        FEATURES_NOT_IN_EASE.add("openid-2.0");
        FEATURES_NOT_IN_EASE.add("oauth-2.0");
        FEATURES_NOT_IN_EASE.add("wsAtomicTransaction-1.2");
        FEATURES_NOT_IN_EASE.add("batchManagement-1.0");
        FEATURES_NOT_IN_EASE.add("acmeCA-2.0");
        FEATURES_NOT_IN_EASE.add("wasJmsServer-1.0");
        FEATURES_NOT_IN_EASE.add("wasJmsServerSecurity-1.0");
        FEATURES_NOT_IN_EASE.add("osgiConsole-1.0");
        FEATURES_NOT_IN_EASE.add("crac-1.4");
        FEATURES_NOT_IN_EASE.add("sipServlet-1.1");
        FEATURES_NOT_IN_EASE.add("microProfile-1.0");
        FEATURES_NOT_IN_EASE.add("microProfile-1.1");
        FEATURES_NOT_IN_EASE.add("microProfile-1.2");
        FEATURES_NOT_IN_EASE.add("microProfile-1.3");
        FEATURES_NOT_IN_EASE.add("microProfile-2.0");
        FEATURES_NOT_IN_EASE.add("microProfile-2.1");
        FEATURES_NOT_IN_EASE.add("microProfile-2.2");
        FEATURES_NOT_IN_EASE.add("microProfile-2.3");
        FEATURES_NOT_IN_EASE.add("microProfile-3.0");
        FEATURES_NOT_IN_EASE.add("microProfile-3.2");
        FEATURES_NOT_IN_EASE.add("microProfile-3.3");
        FEATURES_NOT_IN_EASE.add("microProfile-4.0");
        FEATURES_NOT_IN_EASE.add("microProfile-6.0");
        FEATURES_NOT_IN_EASE.add("mpConfig-1.0");
        FEATURES_NOT_IN_EASE.add("mpConfig-1.1");
        FEATURES_NOT_IN_EASE.add("mpConfig-1.2");
        FEATURES_NOT_IN_EASE.add("mpConfig-1.3");
        FEATURES_NOT_IN_EASE.add("mpFaultTolerance-1.0");
        FEATURES_NOT_IN_EASE.add("mpFaultTolerance-2.0");
        FEATURES_NOT_IN_EASE.add("mpFaultTolerance-2.1");
        FEATURES_NOT_IN_EASE.add("mpHealth-2.0");
        FEATURES_NOT_IN_EASE.add("mpHealth-2.1");
        FEATURES_NOT_IN_EASE.add("mpHealth-2.2");
        FEATURES_NOT_IN_EASE.add("mpHealth-3.0");
        FEATURES_NOT_IN_EASE.add("mpJWT-1.0");
        FEATURES_NOT_IN_EASE.add("mpMetrics-1.0");
        FEATURES_NOT_IN_EASE.add("mpMetrics-2.0");
        FEATURES_NOT_IN_EASE.add("mpMetrics-2.2");
        FEATURES_NOT_IN_EASE.add("mpMetrics-2.3");
        FEATURES_NOT_IN_EASE.add("mpMetrics-5.0");
        FEATURES_NOT_IN_EASE.add("mpOpenAPI-1.1");
        FEATURES_NOT_IN_EASE.add("mpOpenTracing-1.0");
        FEATURES_NOT_IN_EASE.add("mpOpenTracing-1.2");
        FEATURES_NOT_IN_EASE.add("mpOpenTracing-1.3");
        FEATURES_NOT_IN_EASE.add("mpRestClient-1.0");
        FEATURES_NOT_IN_EASE.add("mpRestClient-1.2");
        FEATURES_NOT_IN_EASE.add("mpRestClient-1.3");
        FEATURES_NOT_IN_EASE.add("mpRestClient-1.4");
        FEATURES_NOT_IN_EASE.add("mpTelemetry-1.1");
        FEATURES_NOT_IN_EASE.add("cdi-1.0");
        FEATURES_NOT_IN_EASE.add("jaxrs-1.1");
        FEATURES_NOT_IN_EASE.add("jca-1.6");
        FEATURES_NOT_IN_EASE.add("jms-1.1");
        FEATURES_NOT_IN_EASE.add("jmsMdb-3.1");
        FEATURES_NOT_IN_EASE.add(JPA_20_FEATURE);
        FEATURES_NOT_IN_EASE.add("jsf-2.0");
        FEATURES_NOT_IN_EASE.add(JSP_2_2_FEATURE);
        FEATURES_NOT_IN_EASE.add("mdb-3.1");
        FEATURES_NOT_IN_EASE.add("servlet-3.0");
        FEATURES_NOT_IN_EASE.add("wasJmsClient-1.1");
        FEATURES_NOT_IN_EASE.add("wmqJmsClient-1.1");
        FEATURES_NOT_IN_EASE.add("webProfile-6.0");
        FEATURES_NOT_IN_EASE.add("beanValidation-1.0");
        FEATURES_NOT_IN_EASE.add("ejb-3.1");
        FEATURES_NOT_IN_EASE.add("ejbLite-3.1");
        FEATURES_NOT_IN_EASE.add("jdbc-4.0");
        FEATURES_NOT_IN_EASE.add("blueprint-1.0");
        FEATURES_NOT_IN_EASE.add("httpWhiteboard-1.0");
        FEATURES_NOT_IN_EASE.add("osgiAppIntegration-1.0");
        FEATURES_NOT_IN_EASE.add("osgiBundle-1.0");
        FEATURES_NOT_IN_EASE.add("osgi.jpa-1.0");
        FEATURES_NOT_IN_EASE.add("wab-1.0");
        FEATURES_NOT_IN_EASE.add("serverStatus-1.0");
        FEATURES_NOT_IN_EASE.add("productInsights-1.0");
        FEATURES_NOT_IN_EASE.add("opentracing-1.0");
        FEATURES_NOT_IN_EASE.add("opentracing-1.1");
        FEATURES_NOT_IN_EASE.add("opentracing-1.2");
        FEATURES_NOT_IN_EASE.add("opentracing-1.3");
        FEATURES_NOT_IN_EASE.add("opentracing-2.0");
        FEATURES_NOT_IN_EASE.add("mediaServerControl-1.0");
        FEATURES_NOT_IN_EASE.add("bluemixUtility-1.0");
        FEATURES_NOT_IN_EASE.add("apiDiscovery-1.0");
        FEATURES_NOT_IN_EASE.add("rtcommGateway-1.0");
        FEATURES_NOT_IN_EASE.add("rtcomm-1.0");
        FEATURES_NOT_IN_EASE.add("mongodb-2.0");
        FEATURES_NOT_IN_EASE.add("json-1.0");
        FEATURES_NOT_IN_EASE.add("couchdb-1.0");
        FEATURES_NOT_IN_EASE.add("cloudant-1.0");
        FEATURES_NOT_IN_EASE.add("zosAutomaticRestartManager-1.0");
        FEATURES_NOT_IN_EASE.add("batchSMFLogging-1.0");
        FEATURES_NOT_IN_EASE.add("zosConnect-1.0");
        FEATURES_NOT_IN_EASE.add("zosConnect-1.2");
        FEATURES_NOT_IN_EASE.add("zosLocalAdapters-1.0");
        FEATURES_NOT_IN_EASE.add("zosRequestLogging-1.0");
        FEATURES_NOT_IN_EASE.add("zosPasswordEncryptionKey-1.0");
        FEATURES_NOT_IN_EASE.add("zosSecurity-1.0");
        FEATURES_NOT_IN_EASE.add("zosTransaction-1.0");
        FEATURES_NOT_IN_EASE.add("zosWlm-1.0");
        FEATURES_NOT_IN_EASE.add("clusterMember-1.0");
        FEATURES_NOT_IN_EASE.add("collectiveController-1.0");
        FEATURES_NOT_IN_EASE.add("collectiveMember-1.0");
        FEATURES_NOT_IN_EASE.add("dynamicRouting-1.0");
        FEATURES_NOT_IN_EASE.add("healthAnalyzer-1.0");
        FEATURES_NOT_IN_EASE.add("healthManager-1.0");
        FEATURES_NOT_IN_EASE.add("scalingController-1.0");
        FEATURES_NOT_IN_EASE.add("scalingMember-1.0");
        JAVAEE7_TOLERATED_LIST.add(JPA_20_FEATURE);
        isOpenLiberty = false;
        isEASe = false;
        _featureListResource = null;
    }

    private class FeatureSetComparator
    implements Comparator<Set<String>> {
        private final Map<String, List<String>> requiredFeatures;

        FeatureSetComparator(Map<String, List<String>> requiredFeatures) {
            this.requiredFeatures = requiredFeatures;
        }

        @Override
        public int compare(Set<String> o1, Set<String> o2) {
            int priority;
            String prefix;
            HashMap<Integer, Integer> o1PriorityCount = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> o2PriorityCount = new HashMap<Integer, Integer>();
            int o1MaxPriority = 0;
            int o2MaxPriority = 0;
            for (String feature : o1) {
                prefix = DriveScanGenerateConfig.getPrefix(feature);
                priority = this.requiredFeatures.get(prefix).indexOf(feature);
                if (this.requiredFeatures.get(prefix).indexOf(feature) > o1MaxPriority) {
                    o1MaxPriority = priority;
                }
                if (o1PriorityCount.containsKey(priority)) {
                    o1PriorityCount.put(priority, (Integer)o1PriorityCount.get(priority) + 1);
                    continue;
                }
                o1PriorityCount.put(priority, 1);
            }
            for (String feature : o2) {
                prefix = DriveScanGenerateConfig.getPrefix(feature);
                priority = this.requiredFeatures.get(prefix).indexOf(feature);
                if (this.requiredFeatures.get(prefix).indexOf(feature) > o2MaxPriority) {
                    o2MaxPriority = priority;
                }
                if (o2PriorityCount.containsKey(priority)) {
                    o2PriorityCount.put(priority, (Integer)o2PriorityCount.get(priority) + 1);
                    continue;
                }
                o2PriorityCount.put(priority, 1);
            }
            for (int i = 0; i <= o1MaxPriority; ++i) {
                int o2Freq;
                int o1Freq = o1PriorityCount.get(i) == null ? 0 : (Integer)o1PriorityCount.get(i);
                int n = o2Freq = o2PriorityCount.get(i) == null ? 0 : (Integer)o2PriorityCount.get(i);
                if (o1Freq > o2Freq) {
                    return -1;
                }
                if (o1Freq >= o2Freq) continue;
                return 1;
            }
            return 0;
        }
    }

    private class FeatureVersionComparator
    implements Comparator<String> {
        public boolean preferLatest;

        public FeatureVersionComparator(boolean preferLatest) {
            this.preferLatest = preferLatest;
        }

        @Override
        public int compare(String feat1, String feat2) {
            if (feat1.equals(feat2)) {
                return 0;
            }
            if (this.preferLatest) {
                return FeatureUtil.compareFeatureVersions(feat2, feat1);
            }
            return FeatureUtil.compareFeatureVersions(feat1, feat2);
        }
    }
}

