/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility;

import com.ibm.ws.report.utilities.ReportUtility;
import java.util.logging.Level;

public class JeeProviders {
    private static final JeeProviders VERSION_9_0 = new JeeProviders("2.1", "1.1", "2.2");
    private static final JeeProviders VERSION_8_5 = new JeeProviders("2.0", "1.1", "2.0");
    private static final JeeProviders VERSION_8_0 = new JeeProviders("2.0", "1.1", "2.0");
    private static final JeeProviders VERSION_7_0 = new JeeProviders("2.0", "", "1.2");
    private static final JeeProviders VERSION_6_1 = new JeeProviders("1.0", "", "1.1");
    private static final JeeProviders VERSION_6_0 = new JeeProviders("", "", "1.0");
    private String _jpaProvider = "";
    private String _jaxrsProvider = "";
    private String _jsfProvider = "";

    public JeeProviders() {
        this("", "", "");
    }

    public JeeProviders(String jpa, String jaxrs, String jsf) {
        this._jpaProvider = JeeProviders.getStringOrEmpty(jpa);
        this._jaxrsProvider = JeeProviders.getStringOrEmpty(jaxrs);
        this._jsfProvider = JeeProviders.getStringOrEmpty(jsf);
    }

    public JeeProviders(JeeProviders from) {
        this(from._jpaProvider, from._jaxrsProvider, from._jsfProvider);
    }

    public static JeeProviders fromProductVersion(String version) {
        if (version.startsWith("v")) {
            version = version.substring(1);
        }
        if (version.startsWith("9.0")) {
            return new JeeProviders(VERSION_9_0);
        }
        if (version.startsWith("8.5")) {
            return new JeeProviders(VERSION_8_5);
        }
        if (version.startsWith("8.0")) {
            return new JeeProviders(VERSION_8_0);
        }
        if (version.startsWith("7.0")) {
            return new JeeProviders(VERSION_7_0);
        }
        if (version.startsWith("6.1")) {
            return new JeeProviders(VERSION_6_1);
        }
        if (version.startsWith("6.0")) {
            return new JeeProviders(VERSION_6_0);
        }
        ReportUtility.logger.get().log(Level.FINEST, "Unknown product version: " + version);
        return null;
    }

    public void setEmptyProviders(JeeProviders from) {
        this._jpaProvider = JeeProviders.getIfEmpty(this._jpaProvider, from._jpaProvider);
        this._jaxrsProvider = JeeProviders.getIfEmpty(this._jaxrsProvider, from._jaxrsProvider);
        this._jsfProvider = JeeProviders.getIfEmpty(this._jsfProvider, from._jsfProvider);
    }

    private static String getStringOrEmpty(String in) {
        return in == null ? "" : in;
    }

    private static String getIfEmpty(String original, String in) {
        return original.isEmpty() ? in : original;
    }

    public String getJpaProvider() {
        return this._jpaProvider;
    }

    public void setJpaProvider(String jpa) {
        this._jpaProvider = JeeProviders.getStringOrEmpty(jpa);
    }

    public String getJaxRSProvider() {
        return this._jaxrsProvider;
    }

    public void setJaxRSProvider(String jaxrs) {
        this._jaxrsProvider = JeeProviders.getStringOrEmpty(jaxrs);
    }

    public String getJsfProvider() {
        return this._jsfProvider;
    }

    public void setJsfProvider(String jsf) {
        this._jsfProvider = JeeProviders.getStringOrEmpty(jsf);
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("jpa=" + this._jpaProvider);
        sb.append(nl + "jaxrs=" + this._jaxrsProvider);
        sb.append(nl + "jsf=" + this._jsfProvider);
        return sb.toString();
    }
}

