/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility;

import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import java.util.List;
import java.util.StringJoiner;

public class Library
implements ScopedObject,
Comparable<Library> {
    private final Scope _scope;
    private final String _xmiId;
    private final String _name;
    private final String _desc;
    private final List<String> _classPath;
    private final String _xmiVersion;
    private final String _xmlnsXmi;
    private final String _xmlnsLibraries;
    private List<String> _resolvedClassPath = null;
    private List<String> _resolvedNativePath = null;
    private final List<String> _nativePath;
    private final String _isolatedClassLoader;

    public Library(Scope scope, String name2, String xmiId, String desc, List<String> classPath, List<String> nativePath, String xmiVersion, String xmlnsXmi, String xmlnsLibraries, List<String> apiTypeVisibility, String isolatedClassLoader) {
        this._scope = scope;
        this._xmiId = xmiId;
        this._name = name2;
        this._desc = desc;
        this._classPath = classPath;
        this._nativePath = nativePath;
        this._xmiVersion = xmiVersion;
        this._xmlnsXmi = xmlnsXmi;
        this._xmlnsLibraries = xmlnsLibraries;
        this._isolatedClassLoader = isolatedClassLoader;
    }

    @Override
    public Scope getScope() {
        return this._scope;
    }

    public String getXmiId() {
        return this._xmiId;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._desc;
    }

    public List<String> getClassPath() {
        return this._classPath;
    }

    public List<String> getNativePath() {
        return this._nativePath;
    }

    public List<String> getResolvedClassPath() {
        if (this._resolvedClassPath == null) {
            return this._classPath;
        }
        return this._resolvedClassPath;
    }

    public List<String> getResolvedNativePath() {
        if (this._resolvedNativePath == null) {
            return this._nativePath;
        }
        return this._resolvedNativePath;
    }

    public String getXmiVersion() {
        return this._xmiVersion;
    }

    public String getXmlnsXmi() {
        return this._xmlnsXmi;
    }

    public String getXmlnsLibraries() {
        return this._xmlnsLibraries;
    }

    public void setResolvedClassPath(List<String> classPath) {
        this._resolvedClassPath = classPath;
    }

    public void setNativePath(List<String> nativePath) {
        this._resolvedNativePath = nativePath;
    }

    public String getIsolatedClassLoader() {
        return this._isolatedClassLoader;
    }

    public String toString() {
        return "Library[xmiId=\"" + this._xmiId + "\", name=\"" + this._name + "\", classPath=\"" + this._classPath + "\", nativePath=\"" + this._nativePath + ", description=\"" + this._desc + "\", xmiVersion=\"" + this._xmiVersion + "\", xmlnsXmi=\"" + this._xmlnsXmi + "\", xmlnsLibraries=\"" + this._xmlnsLibraries + "\", resolvedClassPath=\"" + this._resolvedClassPath + "\", resolvedNativePath=\"" + this._resolvedNativePath + "\"]";
    }

    @Override
    public String getUniqueIdentifierName() {
        return this._name;
    }

    @Override
    public boolean equalsAllowDifferentScopes(ScopedObject entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof Library)) {
            return false;
        }
        Library library = (Library)entry;
        return CommonUtilities.equals(this._xmiId, library.getXmiId()) && CommonUtilities.equals(this._name, library.getName()) && CommonUtilities.equals(this._desc, library.getDescription()) && CommonUtilities.equals(this._classPath, library.getClassPath()) && CommonUtilities.equals(this._nativePath, library.getNativePath()) && CommonUtilities.equals(this._xmiVersion, library.getXmiVersion()) && CommonUtilities.equals(this._xmlnsXmi, library.getXmlnsXmi()) && CommonUtilities.equals(this._xmlnsLibraries, library.getXmlnsLibraries());
    }

    @Override
    public int compareTo(Library library) {
        StringJoiner currentLibId = new StringJoiner("_");
        currentLibId.add(library.getName());
        currentLibId.add(library.getScope().getNameForId());
        currentLibId.add(library.getXmiId());
        StringJoiner newLibId = new StringJoiner("_");
        newLibId.add(this.getName());
        newLibId.add(this.getScope().getNameForId());
        newLibId.add(this.getXmiId());
        return currentLibId.toString().compareTo(newLibId.toString());
    }
}

