/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility;

import com.ibm.ws.report.binary.configutility.Messages;
import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;

public class ScopedMap<E extends ScopedObject> {
    private final SortedMap<String, E> _entries = new TreeMap<String, E>();
    private final SortedMap<String, List<String>> conflicts = new TreeMap<String, List<String>>();
    private Scope _scope;

    public Scope getScope() {
        return this._scope;
    }

    public void putAll(ScopedMap<E> from) {
        for (Map.Entry<String, E> e : from._entries.entrySet()) {
            this.put(e.getKey(), (ScopedObject)e.getValue());
        }
    }

    public boolean put(String key, E value) {
        ArrayList<String> conflictList;
        boolean returnValue = false;
        if (key == null) {
            throw new NullPointerException(Messages.getString("Null_Key"));
        }
        ScopedObject old = (ScopedObject)this._entries.get(key);
        if (old == null || value.getScope().getLevel().takesPriorityOver(old.getScope().getLevel())) {
            this._entries.put(key, value);
            returnValue = true;
            if (this.conflicts.containsKey(key)) {
                this.conflicts.remove(key);
                ReportUtility.logger.get().log(Level.FINEST, "Removed conflict " + key);
            }
        } else if (value.getScope().getLevel().equals((Object)old.getScope().getLevel()) && !value.equalsAllowDifferentScopes(old)) {
            if (this.conflicts.containsKey(key)) {
                ((List)this.conflicts.get(key)).add(value.getScope().getName());
            } else {
                conflictList = new ArrayList<String>();
                conflictList.add(old.getScope().getName());
                conflictList.add(value.getScope().getName());
                this.conflicts.put(key, conflictList);
            }
            ReportUtility.logger.get().log(Level.FINEST, "Found and recorded config conflict: " + System.getProperty("line.separator") + "Old value: " + old + System.getProperty("line.separator") + "New value: " + value + System.getProperty("line.separator") + "Current conflict list: " + this.conflicts);
            this._entries.put(key, value);
            returnValue = true;
        }
        if (old != null && old.getScope().getLevel().equals((Object)Scope.Level.CLUSTER) && value.getScope().getLevel().equals((Object)Scope.Level.SERVER) && !value.equalsAllowDifferentScopes(old)) {
            if (this.conflicts.containsKey(key)) {
                ((List)this.conflicts.get(key)).add(value.getScope().getName());
            } else {
                conflictList = new ArrayList();
                conflictList.add(old.getScope().getName());
                conflictList.add(value.getScope().getName());
                this.conflicts.put(key, conflictList);
            }
            ReportUtility.logger.get().log(Level.FINEST, "Found and recorded config conflict: " + System.getProperty("line.separator") + "Old value: " + old + System.getProperty("line.separator") + "New value: " + value + System.getProperty("line.separator") + "Current conflict list: " + this.conflicts);
        }
        return returnValue;
    }

    public E get(String key, SortedMap<String, List<String>> usedConflicts) {
        ScopedObject entry = (ScopedObject)this._entries.get(key);
        if (entry != null && usedConflicts != null && this.conflicts.containsKey(key)) {
            usedConflicts.put(key, (List<String>)this.conflicts.get(key));
        }
        return (E)entry;
    }

    public E getIgnoreScopeConflicts(String key) {
        return (E)((ScopedObject)this._entries.get(key));
    }

    public boolean containsEntry(String key) {
        return this._entries.containsKey(key);
    }

    public void clear() {
        this._entries.clear();
    }

    public Iterable<String> keySet() {
        return this._entries.keySet();
    }

    public Iterable<E> values(Map<String, List<String>> usedConflicts) {
        if (this.conflicts != null) {
            for (ScopedObject entry : this._entries.values()) {
                String key = entry.getUniqueIdentifierName();
                if (entry == null || usedConflicts == null || !this.conflicts.containsKey(key)) continue;
                usedConflicts.put(key, (List<String>)this.conflicts.get(key));
            }
        }
        return this._entries.values();
    }

    public Iterable<E> valuesIgnoreScopeConflicts() {
        return this.values(null);
    }

    public boolean remove(String key) {
        return this._entries.remove(key) != null;
    }

    public int size() {
        return this._entries.size();
    }
}

