/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.appmodules;

import com.ibm.ws.report.binary.configutility.appmodules.EjbJarBnd;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.util.logging.Level;

public class AppModule {
    private final String _moduleId;
    private final String _moduleDisplayName;
    private final ModuleType _moduleType;
    private final String _modulePath;
    private final EjbJarBnd _ejbJarBndInfo;
    private final String _contextRoot;

    public AppModule(String moduleId, String moduleDisplayName, ModuleType moduleType, String modulePath, EjbJarBnd ejbJarBndInfo, String contextRoot) {
        this._moduleId = moduleId;
        this._moduleDisplayName = moduleDisplayName;
        this._moduleType = moduleType;
        this._modulePath = modulePath;
        this._ejbJarBndInfo = ejbJarBndInfo;
        this._contextRoot = contextRoot;
        ReportUtility.logger.get().log(Level.FINEST, "Created AppModule: " + System.getProperty("line.separator") + this);
    }

    public String getModuleId() {
        return this._moduleId;
    }

    public String getModuleDisplayName() {
        return this._moduleDisplayName;
    }

    public ModuleType getModuleType() {
        return this._moduleType;
    }

    public String getModulePath() {
        return this._modulePath;
    }

    public String getContextRoot() {
        return this._contextRoot;
    }

    public String getModuleName(boolean tWas) {
        if (tWas) {
            if (this._moduleDisplayName.equals("")) {
                return this._modulePath;
            }
            return this._moduleDisplayName;
        }
        File moduleFile = new File(this._modulePath);
        String moduleFileName = moduleFile.getName();
        if (moduleFileName.indexOf(46) > -1) {
            return moduleFileName.substring(0, moduleFileName.lastIndexOf(46));
        }
        return moduleFileName;
    }

    public EjbJarBnd getEjbJarBndInfo() {
        return this._ejbJarBndInfo;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("AppModule: " + nl);
        sb.append("moduleId=\"" + this._moduleId + "\"" + nl);
        sb.append("moduleDisplayName=\"" + this._moduleDisplayName + "\"" + nl);
        sb.append("moduleType=\"" + (Object)((Object)this._moduleType) + "\"" + nl);
        sb.append("modulePath=\"" + this._modulePath + "\"" + nl);
        sb.append("ejbJarBndInfo=\"" + this._ejbJarBndInfo + "\"" + nl);
        sb.append("contextRoot=\"" + this._contextRoot + "\"" + nl);
        return sb.toString();
    }

    public static enum ModuleType {
        CONNECTOR,
        EJB,
        JAVA,
        WEB,
        UNKNOWN;

    }
}

