/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.mutableconfig;

import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.mutableconfig.MappedDataHelper;
import com.ibm.ws.report.binary.configutility.mutableconfig.VariablizedDataRegistry;

public class MappedData {
    protected final String _varName;
    protected final String _value;

    public MappedData(String varName, String value) {
        varName = varName == null || varName.equals("") ? "DEFAULT_MAPPED_VARIABLE" : varName;
        this._varName = VariablizedDataRegistry.generateUniqueVarName(varName);
        this._value = value == null ? "" : value;
    }

    public String getValue() {
        if (VariablizedDataRegistry._formatForLiberty && !this._value.trim().matches("^\\$\\{[^}]+}$")) {
            if (!MappedDataHelper._mappedVarsUsedInConfig.containsKey(this._varName)) {
                MappedDataHelper._mappedVarsUsedInConfig.put(this._varName, this._value);
            }
            return "${" + this._varName + "}";
        }
        return this._value;
    }

    public String getVariableValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappedData)) {
            return false;
        }
        MappedData other = (MappedData)obj;
        return CommonUtilities.equals(this._value, other._value);
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("MappedData: " + nl);
        sb.append("Current Variable Name=\"" + this._varName + "\"" + nl);
        sb.append("Value=\"" + this._value + "\"" + nl);
        return sb.toString();
    }
}

