/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.mutableconfig;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class SensitiveDataHelper {
    protected static boolean _includeSensitiveData = false;
    protected static SortedMap<String, String> _varsUsedInConfig = new TreeMap<String, String>();
    protected static String _warnAboutEncryptedDataAlgorithms = "";
    protected static final SortedMap<String, List<String>> _sensitiveDataSourceProperties = new TreeMap<String, List<String>>();

    public static void registerMappedPropertyNamebyClass(String dataType, String propertyName) {
        if (!_sensitiveDataSourceProperties.containsKey(dataType)) {
            ArrayList<String> props = new ArrayList<String>();
            props.add(propertyName);
            _sensitiveDataSourceProperties.put(dataType, props);
        } else if (!((List)_sensitiveDataSourceProperties.get(dataType)).contains(propertyName)) {
            ((List)_sensitiveDataSourceProperties.get(dataType)).add(propertyName);
        }
    }

    public static boolean checkIfSensitiveProperty(String dataType, String propertyName) {
        return propertyName.matches(".*(?i)password.*") || _sensitiveDataSourceProperties.containsKey(dataType) && ((List)_sensitiveDataSourceProperties.get(dataType)).contains(propertyName.toLowerCase());
    }

    public static void collectVarOutputForConfig() {
        _varsUsedInConfig.clear();
        _warnAboutEncryptedDataAlgorithms = "";
    }

    public static Set<String> getRegisteredVarKeys() {
        return _varsUsedInConfig.keySet();
    }

    public static String getValueForRegisteredVar(String varName) {
        String tmp = (String)_varsUsedInConfig.get(varName);
        return tmp != null ? tmp : "";
    }

    public static void setIncludeSensitiveData(boolean isd) {
        _includeSensitiveData = isd;
    }

    public static boolean isIncludeSensitiveData() {
        return _includeSensitiveData;
    }

    public static void setWarnAboutEncryptedDataAlgorithm(String warnAboutEncryptedDataAlgorithm) {
        _warnAboutEncryptedDataAlgorithms = _warnAboutEncryptedDataAlgorithms.equals("") ? warnAboutEncryptedDataAlgorithm : _warnAboutEncryptedDataAlgorithms.concat(", " + warnAboutEncryptedDataAlgorithm);
    }

    public static String getWarnAboutEncryptedDataAlgorithms() {
        return _warnAboutEncryptedDataAlgorithms;
    }
}

