/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.resource;

import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedObject;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.resource.ConnectionDefinition;
import com.ibm.ws.report.binary.configutility.resource.ConnectionPool;
import com.ibm.ws.report.binary.configutility.resource.J2CResourceAdapter;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceFactory;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceProperty;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceProvider;
import com.ibm.ws.report.binary.configutility.twas.Reference;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.logging.Level;

public class J2CConnectionFactory
extends J2EEResourceFactory
implements ScopedObject {
    static final List<String> j2cSensitiveProperties = Arrays.asList(new String[0]);
    static final List<String> j2cMappedProperties = Arrays.asList(new String[0]);
    private final Reference<ConnectionDefinition> _connectionDefinition;
    private final String _authMechanismPreference;
    private final String _componentAuthDataAlias;
    private final String _mappingConfigAlias;
    private final String _containerAuthDataAlias;
    private final String _manageCachedHandles;
    private final String _diagnoseConnectionUsage;
    private final String _logMissingTransactionContext;
    private final String _xaRecoveryAuthAlias;
    private final ConnectionPool _connectionPool;
    private final Scope _scope;
    private String _resourceAdapterId;

    public J2CConnectionFactory(String name2, String jndiName, String description, String category, String providerType, J2EEResourceProvider provider, SortedMap<String, J2EEResourceProperty> propertySet, Reference<ConnectionDefinition> connectionDefinition, String authMechanismPreference, String componentAuthDataAlias, String mappingConfigAlias, String containerAuthDataAlias, String manageCachedHandles, String diagnoseConnectionUsage, String logMissingTransactionContext, ConnectionPool connectionPool, String xaRecoveryAuthAlias, Scope scope, String xmiId) {
        super(name2, jndiName, description, category, providerType, provider, propertySet, xmiId, scope);
        this._connectionDefinition = connectionDefinition;
        this._authMechanismPreference = authMechanismPreference;
        this._componentAuthDataAlias = componentAuthDataAlias;
        this._mappingConfigAlias = mappingConfigAlias;
        this._containerAuthDataAlias = containerAuthDataAlias;
        this._manageCachedHandles = manageCachedHandles;
        this._logMissingTransactionContext = logMissingTransactionContext;
        this._diagnoseConnectionUsage = diagnoseConnectionUsage;
        this._connectionPool = connectionPool;
        this._xaRecoveryAuthAlias = xaRecoveryAuthAlias;
        this._scope = scope;
        ReportUtility.logger.get().log(Level.FINEST, "Created J2CConnectionFactory: " + System.getProperty("line.separator") + this);
    }

    @Override
    public String getUniqueIdentifierName() {
        return super.getJndiName();
    }

    public Reference<ConnectionDefinition> getConnectionDefinition() {
        return this._connectionDefinition;
    }

    public String getXaRecoveryAuthAlias() {
        return this._xaRecoveryAuthAlias;
    }

    public ConnectionPool getConnectionPool() {
        return this._connectionPool;
    }

    public String getAuthMechanismPreference() {
        return this._authMechanismPreference;
    }

    public String getComponentAuthDataAlias() {
        return this._componentAuthDataAlias;
    }

    public String getMappingConfigAlias() {
        return this._mappingConfigAlias;
    }

    public String getContainerAuthDataAlias() {
        return this._containerAuthDataAlias;
    }

    public String getManageCachedHandles() {
        return this._manageCachedHandles;
    }

    public String getLogMissingTransactionContext() {
        return this._logMissingTransactionContext;
    }

    public String getDiagnoseConnectionUsage() {
        return this._diagnoseConnectionUsage;
    }

    public void setResourceAdapterId(String raID) {
        this._resourceAdapterId = raID;
    }

    public String getResourceAdapterId() {
        return this._resourceAdapterId;
    }

    @Override
    public Scope getScope() {
        return this._scope;
    }

    @Override
    public boolean equalsAllowDifferentScopes(ScopedObject entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        if (!(entry instanceof J2CConnectionFactory)) {
            return false;
        }
        J2CConnectionFactory factory = (J2CConnectionFactory)entry;
        return CommonUtilities.equalsAllowDifferentScopes((J2CResourceAdapter)super.getProvider(), (J2CResourceAdapter)factory.getProvider()) && CommonUtilities.equals(super.getName(), factory.getName()) && CommonUtilities.equals(super.getJndiName(), factory.getJndiName()) && CommonUtilities.equals(super.getDescription(), factory.getDescription()) && CommonUtilities.equals(super.getCategory(), factory.getCategory()) && CommonUtilities.equals(super.getProviderType(), factory.getProviderType()) && CommonUtilities.equals(super.getPropertySet(), factory.getPropertySet()) && CommonUtilities.equals(this._authMechanismPreference, factory.getAuthMechanismPreference()) && CommonUtilities.equals(this._componentAuthDataAlias, factory.getComponentAuthDataAlias()) && CommonUtilities.equals(this._mappingConfigAlias, factory.getMappingConfigAlias()) && CommonUtilities.equals(this._containerAuthDataAlias, factory.getContainerAuthDataAlias()) && CommonUtilities.equals(this._manageCachedHandles, factory.getManageCachedHandles()) && CommonUtilities.equals(this._diagnoseConnectionUsage, factory.getDiagnoseConnectionUsage()) && CommonUtilities.equals(this._logMissingTransactionContext, factory.getLogMissingTransactionContext()) && CommonUtilities.equals(this._xaRecoveryAuthAlias, factory.getXaRecoveryAuthAlias()) && CommonUtilities.equals(this._connectionPool, factory.getConnectionPool()) && CommonUtilities.equals(this._connectionDefinition, factory.getConnectionDefinition());
    }

    @Override
    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("J2CConnectionFactory: " + nl);
        sb.append("superclass: " + super.toString() + nl);
        sb.append("scope=\"" + this._scope + "\"" + nl);
        sb.append("authMechanismPreference=\"" + this._authMechanismPreference + "\"" + nl);
        sb.append("componentAuthDataAlias=\"" + this._componentAuthDataAlias + "\"" + nl);
        sb.append("mappingConfigAlias=\"" + this._mappingConfigAlias + "\"" + nl);
        sb.append("containerAuthDataAlias=\"" + this._containerAuthDataAlias + "\"" + nl);
        sb.append("manageCachedHanldes=\"" + this._manageCachedHandles + "\"" + nl);
        sb.append("diagnoseConnectionUsage=\"" + this._diagnoseConnectionUsage + "\"" + nl);
        sb.append("logMissingTransactionContext=\"" + this._logMissingTransactionContext + "\"" + nl);
        sb.append("xaRecoveryAuthAlias=\"" + this._xaRecoveryAuthAlias + "\"" + nl);
        sb.append("connectionPool=\"" + this._connectionPool + "\"" + nl);
        sb.append("connectionDefinition=\"" + this._connectionDefinition + "\"" + nl);
        return sb.toString();
    }

    static {
        String jeeResourceType = J2CConnectionFactory.class.getCanonicalName();
        J2EEResourceFactory.registerPropertiesForJEEResourceType(jeeResourceType, j2cSensitiveProperties, j2cMappedProperties);
    }
}

