/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.security.tls;

import com.ibm.ws.report.binary.configutility.mutableconfig.MappedData;
import com.ibm.ws.report.binary.configutility.mutableconfig.SensitiveData;
import com.ibm.ws.report.binary.configutility.security.tls.KeyManager;
import com.ibm.ws.report.binary.configutility.security.tls.KeyStore;
import com.ibm.ws.report.binary.configutility.security.tls.TrustManager;
import com.ibm.ws.report.binary.configutility.server.Property;
import com.ibm.ws.report.binary.configutility.twas.Reference;
import java.util.List;

public class SecureSocketLayer {
    private final String _keyFileName;
    private final SensitiveData _keyFilePassword;
    private final String _keyFileFormat;
    private final MappedData _clientKeyAlias;
    private final MappedData _serverKeyAlias;
    private final String _trustFileName;
    private final SensitiveData _trustFilePassword;
    private final String _trustFileFormat;
    private final String _clientAuthentication;
    private final String _securityLevel;
    private final String _enableCryptoHardwareSupport;
    private final MappedData _enabledCiphers;
    private final String _jsseProvider;
    private final String _clientAuthenticationSupported;
    private final MappedData _sslProtocol;
    private final List<Property> _properties;
    private final Reference<KeyStore> _keyStore;
    private final Reference<KeyStore> _trustStore;
    private final Reference<KeyManager> _keyManager;
    private final List<Reference<TrustManager>> _trustManagers;

    public SecureSocketLayer(String keyFileName, String keyFilePassword, String keyFileFormat, String clientKeyAlias, String serverKeyAlias, String trustFileName, String trustFilePassword, String trustFileFormat, String clientAuthentication, String securityLevel, String enableCryptoHardwareSupport, String enabledCiphers, String jsseProvider, String clientAuthenticationSupported, String sslProtocol, List<Property> properties, Reference<KeyStore> keyStore, Reference<KeyStore> trustStore, Reference<KeyManager> keyManager, List<Reference<TrustManager>> trustManagers, String parentLibertyId) {
        this._keyFileName = keyFileName;
        this._keyFilePassword = "".equals(keyFilePassword) ? null : new SensitiveData(parentLibertyId + "_keyFilePassword", keyFilePassword);
        this._keyFileFormat = keyFileFormat;
        this._clientKeyAlias = !"".equals(clientKeyAlias) ? new MappedData(parentLibertyId + "_clientKeyAlias", clientKeyAlias) : null;
        this._serverKeyAlias = !"".equals(serverKeyAlias) ? new MappedData(parentLibertyId + "_serverKeyAlias", serverKeyAlias) : null;
        this._trustFileName = trustFileName;
        this._trustFilePassword = "".equals(trustFilePassword) ? null : new SensitiveData(parentLibertyId + "_trustFilePassword", trustFilePassword);
        this._trustFileFormat = trustFileFormat;
        this._clientAuthentication = clientAuthentication;
        this._securityLevel = securityLevel;
        this._enableCryptoHardwareSupport = enableCryptoHardwareSupport;
        this._enabledCiphers = !"".equals(enabledCiphers) ? new MappedData(parentLibertyId + "_enabledCiphers", enabledCiphers) : null;
        this._jsseProvider = jsseProvider;
        this._clientAuthenticationSupported = clientAuthenticationSupported;
        this._sslProtocol = !"".equals(sslProtocol) ? new MappedData(parentLibertyId + "_sslProtocol", sslProtocol) : null;
        this._properties = properties;
        this._keyStore = keyStore;
        this._trustStore = trustStore;
        this._keyManager = keyManager;
        this._trustManagers = trustManagers;
    }

    public String getKeyFileName() {
        return this._keyFileName;
    }

    public SensitiveData getKeyFilePassword() {
        return this._keyFilePassword;
    }

    public String getKeyFileFormat() {
        return this._keyFileFormat;
    }

    public MappedData getClientKeyAlias() {
        return this._clientKeyAlias;
    }

    public MappedData getServerKeyAlias() {
        return this._serverKeyAlias;
    }

    public String getTrustFileName() {
        return this._trustFileName;
    }

    public SensitiveData getTrustFilePassword() {
        return this._trustFilePassword;
    }

    public String getTrustFileFormat() {
        return this._trustFileFormat;
    }

    public String getClientAuthentication() {
        return this._clientAuthentication;
    }

    public String getSecurityLevel() {
        return this._securityLevel;
    }

    public String getEnableCryptoHardwareSupport() {
        return this._enableCryptoHardwareSupport;
    }

    public MappedData getEnabledCiphers() {
        return this._enabledCiphers;
    }

    public String getJsseProvider() {
        return this._jsseProvider;
    }

    public String getClientAuthenticationSupported() {
        return this._clientAuthenticationSupported;
    }

    public MappedData getSslProtocol() {
        return this._sslProtocol;
    }

    public List<Property> getProperties() {
        return this._properties;
    }

    public Reference<KeyStore> getKeyStore() {
        return this._keyStore;
    }

    public Reference<KeyStore> getTrustStore() {
        return this._trustStore;
    }

    public Reference<KeyManager> getKeyManager() {
        return this._keyManager;
    }

    public List<Reference<TrustManager>> getTrustManagers() {
        return this._trustManagers;
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("SecureSocketLayer: " + nl);
        sb.append("keyFileName=\"" + this._keyFileName + "\"" + nl);
        sb.append("keyFilePassword=\"" + this._keyFilePassword + "\"" + nl);
        sb.append("keyFileFormat=\"" + this._keyFileFormat + "\"" + nl);
        sb.append("clientKeyAlias=\"" + this._clientKeyAlias + "\"" + nl);
        sb.append("serverKeyAlias=\"" + this._serverKeyAlias + "\"" + nl);
        sb.append("trustFileName=\"" + this._trustFileName + "\"" + nl);
        sb.append("trustFilePassword=\"" + this._trustFilePassword + "\"" + nl);
        sb.append("trustFileFormat=\"" + this._trustFileFormat + "\"" + nl);
        sb.append("clientAuthentication=\"" + this._clientAuthentication + "\"" + nl);
        sb.append("securityLevel=\"" + this._securityLevel + "\"" + nl);
        sb.append("enableCryptoHardwareSupport=\"" + this._enableCryptoHardwareSupport + "\"" + nl);
        sb.append("enabledCiphers=\"" + this._enabledCiphers + "\"" + nl);
        sb.append("jsseProvider=\"" + this._jsseProvider + "\"" + nl);
        sb.append("clientAuthenticationSupported=\"" + this._clientAuthenticationSupported + "\"" + nl);
        sb.append("sslProtocol=\"" + this._sslProtocol + "\"" + nl);
        sb.append("properties: " + nl);
        if (this._properties != null) {
            for (Property property : this._properties) {
                sb.append(property + nl);
            }
        }
        sb.append("keyStore=\"" + this._keyStore + "\"" + nl);
        sb.append("trustStore=\"" + this._trustStore + "\"" + nl);
        sb.append("keyManager=\"" + this._keyManager + "\"" + nl);
        sb.append("trustManagers: " + nl);
        if (this._trustManagers != null) {
            for (Reference reference : this._trustManagers) {
                sb.append(reference + nl);
            }
        }
        return sb.toString();
    }
}

