/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.twas;

import com.ibm.ws.report.binary.configutility.Messages;
import com.ibm.ws.report.binary.configutility.generator.CommonUtilities;
import com.ibm.ws.report.binary.configutility.twas.References;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.logging.Level;

public class Reference<T> {
    private final Class<T> _type;
    private final String _id;
    private T _value = null;

    public Reference(String id, Class<T> type) {
        if (id == null) {
            throw new NullPointerException(Messages.getString("Null_Reference_ID"));
        }
        this._id = id;
        this._type = type;
    }

    public String getId() {
        return this._id;
    }

    public Class<T> getType() {
        return this._type;
    }

    public T getValue() {
        if (this._value == null) {
            Object value = References.lookup(this._id);
            if (value != null && this._type.isAssignableFrom(value.getClass())) {
                this._value = value;
            } else if (value != null) {
                ReportUtility.logger.get().log(Level.FINE, "The value for reference id " + this._id + " had a value of " + this._value + " but it didn't match the expected type " + this._type + ". The value was not set.");
            }
        }
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
        result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)obj;
        return CommonUtilities.equals(this._id, other.getId()) && CommonUtilities.equals(this._type, other.getType()) && CommonUtilities.equals(this._value, other.getValue());
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("Reference to " + this._type.getName() + "\"" + nl);
        sb.append("id=\"" + this._id + "\"" + nl);
        sb.append("value=\"" + this._value + "\"" + nl);
        return sb.toString();
    }
}

