/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.configutility.twas;

import com.ibm.ws.report.binary.configutility.ConfigManagerFactory;
import com.ibm.ws.report.binary.configutility.FileUtilities;
import com.ibm.ws.report.binary.configutility.Library;
import com.ibm.ws.report.binary.configutility.Scope;
import com.ibm.ws.report.binary.configutility.ScopedMap;
import com.ibm.ws.report.binary.configutility.Variable;
import com.ibm.ws.report.binary.configutility.appmodules.AppModule;
import com.ibm.ws.report.binary.configutility.appmodules.EjbJarBnd;
import com.ibm.ws.report.binary.configutility.appmodules.JcaAdapter;
import com.ibm.ws.report.binary.configutility.appmodules.MessageDriven;
import com.ibm.ws.report.binary.configutility.resource.ActivationSpec;
import com.ibm.ws.report.binary.configutility.resource.AdminObject;
import com.ibm.ws.report.binary.configutility.resource.ConnectionDefinition;
import com.ibm.ws.report.binary.configutility.resource.ConnectionPool;
import com.ibm.ws.report.binary.configutility.resource.Connector;
import com.ibm.ws.report.binary.configutility.resource.DataSource;
import com.ibm.ws.report.binary.configutility.resource.HostAlias;
import com.ibm.ws.report.binary.configutility.resource.InboundResourceAdapter;
import com.ibm.ws.report.binary.configutility.resource.J2CActivationSpec;
import com.ibm.ws.report.binary.configutility.resource.J2CAdminObject;
import com.ibm.ws.report.binary.configutility.resource.J2CConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.J2CResourceAdapter;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceFactory;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceProperty;
import com.ibm.ws.report.binary.configutility.resource.J2EEResourceProvider;
import com.ibm.ws.report.binary.configutility.resource.JNDIBinding;
import com.ibm.ws.report.binary.configutility.resource.JNDIObjectFactory;
import com.ibm.ws.report.binary.configutility.resource.JNDIReferenceBinding;
import com.ibm.ws.report.binary.configutility.resource.JNDIURLBinding;
import com.ibm.ws.report.binary.configutility.resource.JavaEEDefaultResource;
import com.ibm.ws.report.binary.configutility.resource.JdbcProvider;
import com.ibm.ws.report.binary.configutility.resource.JmsProvider;
import com.ibm.ws.report.binary.configutility.resource.MailProvider;
import com.ibm.ws.report.binary.configutility.resource.MailSession;
import com.ibm.ws.report.binary.configutility.resource.MessageAdapter;
import com.ibm.ws.report.binary.configutility.resource.MessageListener;
import com.ibm.ws.report.binary.configutility.resource.MimeType;
import com.ibm.ws.report.binary.configutility.resource.MqConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.MqQueue;
import com.ibm.ws.report.binary.configutility.resource.MqQueueConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.MqTopic;
import com.ibm.ws.report.binary.configutility.resource.MqTopicConnectionFactory;
import com.ibm.ws.report.binary.configutility.resource.OutboundResourceAdapter;
import com.ibm.ws.report.binary.configutility.resource.ProtocolProviders;
import com.ibm.ws.report.binary.configutility.resource.ResourceAdapter;
import com.ibm.ws.report.binary.configutility.resource.Resources;
import com.ibm.ws.report.binary.configutility.resource.SIBDestination;
import com.ibm.ws.report.binary.configutility.resource.SIBus;
import com.ibm.ws.report.binary.configutility.resource.SimpleResourceAdapter;
import com.ibm.ws.report.binary.configutility.resource.VirtualHost;
import com.ibm.ws.report.binary.configutility.security.AuthDataEntry;
import com.ibm.ws.report.binary.configutility.security.AuthMechanisms;
import com.ibm.ws.report.binary.configutility.security.DomainSecurity;
import com.ibm.ws.report.binary.configutility.security.LDAPSearchFilter;
import com.ibm.ws.report.binary.configutility.security.LDAPUserRegistry;
import com.ibm.ws.report.binary.configutility.security.LTPAAuthMechanism;
import com.ibm.ws.report.binary.configutility.security.RunAs;
import com.ibm.ws.report.binary.configutility.security.SSLConfigGroup;
import com.ibm.ws.report.binary.configutility.security.Security;
import com.ibm.ws.report.binary.configutility.security.SecurityRole;
import com.ibm.ws.report.binary.configutility.security.SingleSignOn;
import com.ibm.ws.report.binary.configutility.security.UserOrGroup;
import com.ibm.ws.report.binary.configutility.security.UserRegistry;
import com.ibm.ws.report.binary.configutility.security.WIMUserRegistry;
import com.ibm.ws.report.binary.configutility.security.tls.DynamicSSLConfigSelection;
import com.ibm.ws.report.binary.configutility.security.tls.KeyManager;
import com.ibm.ws.report.binary.configutility.security.tls.KeySet;
import com.ibm.ws.report.binary.configutility.security.tls.KeySetGroups;
import com.ibm.ws.report.binary.configutility.security.tls.KeyStore;
import com.ibm.ws.report.binary.configutility.security.tls.ManagementScope;
import com.ibm.ws.report.binary.configutility.security.tls.SSLConfig;
import com.ibm.ws.report.binary.configutility.security.tls.SecureSocketLayer;
import com.ibm.ws.report.binary.configutility.security.tls.TrustManager;
import com.ibm.ws.report.binary.configutility.security.tls.WSCertificateExpirationMonitor;
import com.ibm.ws.report.binary.configutility.security.tls.WSNotification;
import com.ibm.ws.report.binary.configutility.security.tls.WSSchedule;
import com.ibm.ws.report.binary.configutility.security.wim.Attribute;
import com.ibm.ws.report.binary.configutility.security.wim.AttributeConfiguration;
import com.ibm.ws.report.binary.configutility.security.wim.AttributesCache;
import com.ibm.ws.report.binary.configutility.security.wim.BaseEntry;
import com.ibm.ws.report.binary.configutility.security.wim.CacheConfiguration;
import com.ibm.ws.report.binary.configutility.security.wim.Connection;
import com.ibm.ws.report.binary.configutility.security.wim.ContextPool;
import com.ibm.ws.report.binary.configutility.security.wim.GroupConfiguration;
import com.ibm.ws.report.binary.configutility.security.wim.LdapEntityType;
import com.ibm.ws.report.binary.configutility.security.wim.LdapRepository;
import com.ibm.ws.report.binary.configutility.security.wim.LdapServer;
import com.ibm.ws.report.binary.configutility.security.wim.LdapServerConfiguration;
import com.ibm.ws.report.binary.configutility.security.wim.MemberAttribute;
import com.ibm.ws.report.binary.configutility.security.wim.MembershipAttribute;
import com.ibm.ws.report.binary.configutility.security.wim.PropertyMapping;
import com.ibm.ws.report.binary.configutility.security.wim.RdnAttribute;
import com.ibm.ws.report.binary.configutility.security.wim.Realm;
import com.ibm.ws.report.binary.configutility.security.wim.RealmConfiguration;
import com.ibm.ws.report.binary.configutility.security.wim.SearchResultsCache;
import com.ibm.ws.report.binary.configutility.security.wim.WimConfig;
import com.ibm.ws.report.binary.configutility.server.Cookie;
import com.ibm.ws.report.binary.configutility.server.DRSSettings;
import com.ibm.ws.report.binary.configutility.server.EndPoint;
import com.ibm.ws.report.binary.configutility.server.InvalidationSchedule;
import com.ibm.ws.report.binary.configutility.server.JpaService;
import com.ibm.ws.report.binary.configutility.server.JvmEntry;
import com.ibm.ws.report.binary.configutility.server.ProcessDefinition;
import com.ibm.ws.report.binary.configutility.server.Property;
import com.ibm.ws.report.binary.configutility.server.SessionDatabasePersistence;
import com.ibm.ws.report.binary.configutility.server.SessionManager;
import com.ibm.ws.report.binary.configutility.server.TraceLog;
import com.ibm.ws.report.binary.configutility.server.TraceService;
import com.ibm.ws.report.binary.configutility.server.TransactionService;
import com.ibm.ws.report.binary.configutility.server.TuningParams;
import com.ibm.ws.report.binary.configutility.server.WebContainer;
import com.ibm.ws.report.binary.configutility.twas.Reference;
import com.ibm.ws.report.binary.configutility.twas.References;
import com.ibm.ws.report.utilities.ReportUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TwasXmlUtilities {
    static HashMap<String, String> otherAttributes = new HashMap();

    private TwasXmlUtilities() {
    }

    public static void loadVariables(ScopedMap<Variable> out, Document document, Scope scope) {
        NodeList elements = document.getElementsByTagName("variables:VariableMap");
        if (elements.getLength() == 0) {
            return;
        }
        Element variableMap = (Element)elements.item(0);
        NodeList entries = variableMap.getElementsByTagName("entries");
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            String xmiId = entry.getAttribute("xmi:id");
            String symbolicName = entry.getAttribute("symbolicName");
            String value = entry.getAttribute("value");
            String description = entry.getAttribute("description");
            out.put(symbolicName, new Variable(scope, symbolicName, xmiId, value, description));
        }
    }

    public static void loadLibraries(ScopedMap<Library> out, Document document, Scope scope) {
        NodeList libraries = document.getElementsByTagName("libraries:Library");
        NodeList xmiXmi = document.getElementsByTagName("xmi:XMI");
        String baseXmiVersion = "";
        String baseXmlnsXmi = "";
        String baseXmlnsLibraries = "";
        if (xmiXmi.getLength() > 0) {
            Element entry = (Element)xmiXmi.item(0);
            baseXmiVersion = entry.getAttribute("xmi:version");
            baseXmlnsXmi = entry.getAttribute("xmlns:xmi");
            baseXmlnsLibraries = entry.getAttribute("xmlns:libraries");
        }
        for (int i = 0; i < libraries.getLength(); ++i) {
            Element entry = (Element)libraries.item(i);
            String xmiId = entry.getAttribute("xmi:id");
            String name2 = entry.getAttribute("name");
            String desc = entry.getAttribute("description");
            ArrayList<String> classPath = new ArrayList<String>();
            ArrayList<String> nativePath = new ArrayList<String>();
            String xmiVersion = entry.getAttribute("xmi:version");
            String xmlnsXmi = entry.getAttribute("xmlns:xmi");
            String xmlnsLibraries = entry.getAttribute("xmlns:libraries");
            String isolatedClassLoader = entry.getAttribute("isolatedClassLoader");
            if (xmiVersion.equals("")) {
                xmiVersion = baseXmiVersion;
            }
            if (xmlnsXmi.equals("")) {
                xmlnsXmi = baseXmlnsXmi;
            }
            if (xmlnsLibraries.equals("")) {
                xmlnsLibraries = baseXmlnsLibraries;
            }
            NodeList children = entry.getElementsByTagName("classPath");
            for (int j = 0; j < children.getLength(); ++j) {
                classPath.add(((Element)children.item(j)).getTextContent());
            }
            NodeList nativePaths = entry.getElementsByTagName("nativePath");
            for (int j = 0; j < nativePaths.getLength(); ++j) {
                nativePath.add(((Element)nativePaths.item(j)).getTextContent());
            }
            out.put(name2, new Library(scope, name2, xmiId, desc, classPath, nativePath, xmiVersion, xmlnsXmi, xmlnsLibraries, null, isolatedClassLoader));
        }
    }

    public static void loadResources(Resources resources, Document resourcesXml, Scope scope) {
        ScopedMap<DataSource> dataSources = resources.getDataSources();
        ScopedMap<MailSession> mailSessions = resources.getMailSessions();
        ScopedMap<J2CConnectionFactory> j2cConnectionFactories = resources.getJ2CConnectionFactories();
        ScopedMap<J2CAdminObject> j2cAdminObjects = resources.getJ2CAdminObjects();
        ScopedMap<J2CActivationSpec> j2cActivationSpecs = resources.getJ2CActivationSpecs();
        ScopedMap<MqQueueConnectionFactory> mqQueueConnectionFactories = resources.getMqQueueConnectionFactories();
        ScopedMap<MqTopicConnectionFactory> mqTopicConnectionFactories = resources.getMqTopicConnectionFactories();
        ScopedMap<MqConnectionFactory> mqConnectionFactories = resources.getMqConnectionFactories();
        ScopedMap<MqQueue> mqQueues = resources.getMqQueues();
        ScopedMap<MqTopic> mqTopics = resources.getMqTopics();
        ScopedMap<JavaEEDefaultResource> defaultResources = resources.getDefaultResources();
        ScopedMap<JNDIURLBinding> jndiURLBindings = resources.getJNDIURLBindings();
        ScopedMap<JNDIReferenceBinding> jndiReferenceBindings = resources.getJNDIReferenceBindings();
        ScopedMap<JNDIObjectFactory> jndiObjectFactories = resources.getJNDIObjectFactories();
        ScopedMap<SimpleResourceAdapter> resourceAdapters = resources.getResourceAdapters();
        ArrayList<JdbcProvider> jdbcProviders = new ArrayList<JdbcProvider>();
        NodeList resourceList = resourcesXml.getElementsByTagName("resources.jdbc:JDBCProvider");
        for (int i = 0; i < resourceList.getLength(); ++i) {
            Element resource = (Element)resourceList.item(i);
            jdbcProviders.add(TwasXmlUtilities.loadJdbcProvider(resource, scope, dataSources));
        }
        for (JdbcProvider provider : jdbcProviders) {
            for (DataSource datasource : provider.getFactories().values()) {
                dataSources.put(datasource.getJndiName(), datasource);
            }
        }
        ArrayList<MailProvider> mailProviders = new ArrayList<MailProvider>();
        NodeList mailProviderList = resourcesXml.getElementsByTagName("resources.mail:MailProvider");
        for (int i = 0; i < mailProviderList.getLength(); ++i) {
            Element resource = (Element)mailProviderList.item(i);
            mailProviders.add(TwasXmlUtilities.loadMailProvider(resource, scope, mailSessions));
        }
        for (MailProvider provider : mailProviders) {
            for (MailSession mailSession : provider.getFactories().values()) {
                mailSessions.put(mailSession.getJndiName(), mailSession);
            }
        }
        ArrayList<JmsProvider> jmsProviders = new ArrayList<JmsProvider>();
        NodeList jmsProviderList = resourcesXml.getElementsByTagName("resources.jms:JMSProvider");
        for (int i = 0; i < jmsProviderList.getLength(); ++i) {
            Element provider = (Element)jmsProviderList.item(i);
            jmsProviders.add(TwasXmlUtilities.loadJmsProvider(provider, scope));
        }
        for (JmsProvider jmsProvider : jmsProviders) {
            for (J2EEResourceFactory j2EEResourceFactory : jmsProvider.getFactories().values()) {
                if (j2EEResourceFactory instanceof MqQueueConnectionFactory) {
                    mqQueueConnectionFactories.put(j2EEResourceFactory.getJndiName(), (MqQueueConnectionFactory)j2EEResourceFactory);
                    continue;
                }
                if (j2EEResourceFactory instanceof MqTopicConnectionFactory) {
                    mqTopicConnectionFactories.put(j2EEResourceFactory.getJndiName(), (MqTopicConnectionFactory)j2EEResourceFactory);
                    continue;
                }
                if (j2EEResourceFactory instanceof MqConnectionFactory) {
                    mqConnectionFactories.put(j2EEResourceFactory.getJndiName(), (MqConnectionFactory)j2EEResourceFactory);
                    continue;
                }
                if (j2EEResourceFactory instanceof MqQueue) {
                    mqQueues.put(j2EEResourceFactory.getJndiName(), (MqQueue)j2EEResourceFactory);
                    continue;
                }
                if (!(j2EEResourceFactory instanceof MqTopic)) continue;
                mqTopics.put(j2EEResourceFactory.getJndiName(), (MqTopic)j2EEResourceFactory);
            }
        }
        ArrayList<J2CResourceAdapter> j2cResourceAdapters = new ArrayList<J2CResourceAdapter>();
        NodeList j2cResourceAdapterList = resourcesXml.getElementsByTagName("resources.j2c:J2CResourceAdapter");
        for (int i = 0; i < j2cResourceAdapterList.getLength(); ++i) {
            Element element = (Element)j2cResourceAdapterList.item(i);
            j2cResourceAdapters.add(TwasXmlUtilities.loadJ2CResourceAdapter(element, scope));
        }
        for (J2CResourceAdapter j2CResourceAdapter : j2cResourceAdapters) {
            resourceAdapters.put(j2CResourceAdapter.getName(), new SimpleResourceAdapter(scope, j2CResourceAdapter.getName(), j2CResourceAdapter.getArchivePath(), j2CResourceAdapter.getPropertySet()));
            for (J2CConnectionFactory connFactory : j2CResourceAdapter.getFactories().values()) {
                j2cConnectionFactories.put(connFactory.getJndiName(), connFactory);
            }
            for (J2CAdminObject adminObject : j2CResourceAdapter.getJ2cAdminObjects().values()) {
                j2cAdminObjects.put(adminObject.getJndiName(), adminObject);
            }
            for (J2CActivationSpec activationSpec : j2CResourceAdapter.getJ2cActivationSpec().values()) {
                j2cActivationSpecs.put(activationSpec.getJndiName(), activationSpec);
            }
        }
        NodeList defaultResourcesNodes = resourcesXml.getElementsByTagName("resources:JavaEEDefaultResources");
        if (defaultResourcesNodes.getLength() != 0) {
            Element element = (Element)defaultResourcesNodes.item(0);
            String defaultDataSource = element.getAttribute("defaultDataSource");
            String defaultJMSConnectionFactory = element.getAttribute("defaultJMSConnectionFactory");
            if (!"".equals(defaultDataSource)) {
                JavaEEDefaultResource defaultDS = new JavaEEDefaultResource(JavaEEDefaultResource.Type.DEFAULT_DS, defaultDataSource, scope);
                defaultResources.put(JavaEEDefaultResource.Type.DEFAULT_DS.toString(), defaultDS);
            }
            if (!"".equals(defaultJMSConnectionFactory)) {
                JavaEEDefaultResource defaultJMSCF = new JavaEEDefaultResource(JavaEEDefaultResource.Type.DEFAULT_JMS_CF, defaultJMSConnectionFactory, scope);
                defaultResources.put(JavaEEDefaultResource.Type.DEFAULT_JMS_CF.toString(), defaultJMSCF);
            }
        }
        NodeList nodeList = resourcesXml.getElementsByTagName("resources.env:ResourceEnvironmentProvider");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element jndiReferenceElement = (Element)nodeList.item(i);
            String xmiID = jndiReferenceElement.getAttribute("xmi:id");
            ArrayList<String> classpaths = new ArrayList<String>();
            NodeList classpathList = jndiReferenceElement.getElementsByTagName("classpath");
            for (int j = 0; j < classpathList.getLength(); ++j) {
                Element classpathElement = (Element)classpathList.item(j);
                classpaths.add(classpathElement.getTextContent());
            }
            NodeList factoriesList = jndiReferenceElement.getElementsByTagName("factories");
            for (int j = 0; j < factoriesList.getLength(); ++j) {
                Element factoryElement = (Element)factoriesList.item(j);
                String name2 = factoryElement.getAttribute("name");
                String jndiName = factoryElement.getAttribute("jndiName");
                String referenceable = factoryElement.getAttribute("referenceable");
                JNDIReferenceBinding binding = new JNDIReferenceBinding(scope, xmiID, name2, jndiName, referenceable);
                jndiReferenceBindings.put(jndiName, binding);
            }
            NodeList referencablesList = jndiReferenceElement.getElementsByTagName("referenceables");
            for (int j = 0; j < referencablesList.getLength(); ++j) {
                Element referencableElement = (Element)referencablesList.item(j);
                String id = referencableElement.getAttribute("xmi:id");
                String factoryClassName = referencableElement.getAttribute("factoryClassname");
                String classname = referencableElement.getAttribute("classname");
                JNDIObjectFactory factory = new JNDIObjectFactory(scope, xmiID, id, classpaths, factoryClassName, classname);
                jndiObjectFactories.put(id, factory);
            }
        }
        NodeList jndiURLNodes = resourcesXml.getElementsByTagName("resources.url:URLProvider");
        for (int i = 0; i < jndiURLNodes.getLength(); ++i) {
            Element jndiURLElement = (Element)jndiURLNodes.item(i);
            String xmiId = jndiURLElement.getAttribute("xmi:id");
            String id = null;
            String jndiName = null;
            String spec = null;
            NodeList factoriesList = jndiURLElement.getElementsByTagName("factories");
            if (factoriesList.getLength() <= 0) continue;
            Element factoriesElement = (Element)factoriesList.item(0);
            id = factoriesElement.getAttribute("name");
            jndiName = factoriesElement.getAttribute("jndiName");
            spec = factoriesElement.getAttribute("spec");
            JNDIURLBinding binding = new JNDIURLBinding(scope, id, jndiName, spec, xmiId);
            jndiURLBindings.put(jndiName, binding);
        }
    }

    public static Security loadSecurity(Document securityXml, Document wimconfigXml, String cellName) {
        Element wsCertMonElem;
        Map<String, AuthDataEntry> authData = TwasXmlUtilities.loadAuthDataEntries(securityXml);
        String enabled = "";
        String appEnabled = "";
        String activeUserRegistryId = "";
        String activeAuthMechanismId = "";
        LTPAAuthMechanism ltpaAuthMechanism = null;
        LDAPUserRegistry standaloneLDAPUserRegistry = null;
        WIMUserRegistry wimUserRegistry = null;
        NodeList securityList = securityXml.getElementsByTagName("security:Security");
        if (securityList.getLength() > 0) {
            Element securityElem = (Element)securityList.item(0);
            enabled = securityElem.getAttribute("enabled");
            appEnabled = securityElem.getAttribute("appEnabled");
            activeUserRegistryId = securityElem.getAttribute("activeUserRegistry");
            activeAuthMechanismId = securityElem.getAttribute("activeAuthMechanism");
        }
        Reference<UserRegistry> activeUserRegistry = null;
        if (!"".equals(activeUserRegistryId)) {
            activeUserRegistry = new Reference<UserRegistry>(activeUserRegistryId, UserRegistry.class);
        }
        Reference<AuthMechanisms> activeAuthMechanisms = null;
        if (!"".equals(activeAuthMechanismId)) {
            activeAuthMechanisms = new Reference<AuthMechanisms>(activeAuthMechanismId, AuthMechanisms.class);
        }
        NodeList authMechanismsList = securityXml.getElementsByTagName("authMechanisms");
        for (int i = 0; i < authMechanismsList.getLength(); ++i) {
            Element authMechanismsElem = (Element)authMechanismsList.item(i);
            if (ltpaAuthMechanism != null || !"security:LTPA".equals(authMechanismsElem.getAttribute("xmi:type"))) continue;
            ltpaAuthMechanism = TwasXmlUtilities.loadLTPAAuthMechanism(authMechanismsElem);
        }
        NodeList userRegistriesList = securityXml.getElementsByTagName("userRegistries");
        for (int i = 0; i < userRegistriesList.getLength(); ++i) {
            Element userRegistriesElem = (Element)userRegistriesList.item(i);
            if (standaloneLDAPUserRegistry == null && "security:LDAPUserRegistry".equals(userRegistriesElem.getAttribute("xmi:type"))) {
                standaloneLDAPUserRegistry = TwasXmlUtilities.loadStandaloneLDAPUserRegistry(userRegistriesElem, cellName);
                continue;
            }
            if (wimUserRegistry != null || !"security:WIMUserRegistry".equals(userRegistriesElem.getAttribute("xmi:type"))) continue;
            wimUserRegistry = TwasXmlUtilities.loadWIMUserRegistry(userRegistriesElem, wimconfigXml, cellName);
        }
        TreeMap<String, SSLConfig> repertoires = new TreeMap<String, SSLConfig>();
        NodeList repertoiresList = securityXml.getElementsByTagName("repertoire");
        for (int i = 0; i < repertoiresList.getLength(); ++i) {
            Element repertoireElem = (Element)repertoiresList.item(i);
            if (repertoireElem == null) continue;
            SSLConfig repertoire = TwasXmlUtilities.loadSslConfig(repertoireElem, cellName);
            repertoires.put(repertoire.getAlias(), repertoire);
        }
        ArrayList<ManagementScope> managementScopes = new ArrayList<ManagementScope>();
        NodeList managementScopeList = securityXml.getElementsByTagName("managementScopes");
        for (int i = 0; i < managementScopeList.getLength(); ++i) {
            Element managementScopeElem = (Element)managementScopeList.item(i);
            if (managementScopeElem == null) continue;
            ManagementScope managementScope = TwasXmlUtilities.loadManagementScope(managementScopeElem);
            managementScopes.add(managementScope);
        }
        ArrayList<DynamicSSLConfigSelection> dynamicSslConfigSelections = new ArrayList<DynamicSSLConfigSelection>();
        NodeList dynamicSslConfigSelectionList = securityXml.getElementsByTagName("dynamicSSLConfigSelections");
        for (int i = 0; i < dynamicSslConfigSelectionList.getLength(); ++i) {
            Element dynamicSslConfigElem = (Element)dynamicSslConfigSelectionList.item(i);
            if (dynamicSslConfigElem == null) continue;
            DynamicSSLConfigSelection configSelection = TwasXmlUtilities.loadDynamicSslConfigSelection(dynamicSslConfigElem);
            dynamicSslConfigSelections.add(configSelection);
        }
        ArrayList<KeyStore> keyStores = new ArrayList<KeyStore>();
        NodeList keyStoresList = securityXml.getElementsByTagName("keyStores");
        for (int i = 0; i < keyStoresList.getLength(); ++i) {
            Element keyStoreElem = (Element)keyStoresList.item(i);
            if (keyStoreElem == null) continue;
            KeyStore keyStore = TwasXmlUtilities.loadKeyStore(keyStoreElem, cellName);
            keyStores.add(keyStore);
        }
        ArrayList<KeySetGroups> keySetGroups = new ArrayList<KeySetGroups>();
        NodeList keySetGroupsList = securityXml.getElementsByTagName("keySetGroups");
        for (int i = 0; i < keySetGroupsList.getLength(); ++i) {
            Element keySetGroupsElem = (Element)keySetGroupsList.item(i);
            if (keySetGroupsElem == null) continue;
            KeySetGroups keySetGroup = TwasXmlUtilities.loadKeySetGroups(keySetGroupsElem);
            keySetGroups.add(keySetGroup);
        }
        ArrayList<KeySet> keySets = new ArrayList<KeySet>();
        NodeList keySetsList = securityXml.getElementsByTagName("keySets");
        for (int i = 0; i < keySetsList.getLength(); ++i) {
            Element keySetsElem = (Element)keySetsList.item(i);
            if (keySetsElem == null) continue;
            KeySet keySet = TwasXmlUtilities.loadKeySet(keySetsElem);
            keySets.add(keySet);
        }
        ArrayList<KeyManager> keyManagers = new ArrayList<KeyManager>();
        NodeList keyManagersList = securityXml.getElementsByTagName("keyManagers");
        for (int i = 0; i < keyManagersList.getLength(); ++i) {
            Element keyManagerElem = (Element)keyManagersList.item(i);
            if (keyManagerElem == null) continue;
            KeyManager keyManager = TwasXmlUtilities.loadKeyManager(keyManagerElem);
            keyManagers.add(keyManager);
        }
        ArrayList<TrustManager> trustManagers = new ArrayList<TrustManager>();
        NodeList trustManagersList = securityXml.getElementsByTagName("trustManagers");
        for (int i = 0; i < trustManagersList.getLength(); ++i) {
            Element trustManagerElem = (Element)trustManagersList.item(i);
            if (trustManagerElem == null) continue;
            TrustManager trustManager = TwasXmlUtilities.loadTrustManager(trustManagerElem);
            trustManagers.add(trustManager);
        }
        WSCertificateExpirationMonitor wsCertificateExpirationMonitor = null;
        NodeList wsCertMonList = securityXml.getElementsByTagName("wsCertificateExpirationMonitor");
        if (wsCertMonList.getLength() > 0 && (wsCertMonElem = (Element)wsCertMonList.item(0)) != null) {
            wsCertificateExpirationMonitor = TwasXmlUtilities.loadWsCertificateExpirationMonitor(wsCertMonElem);
        }
        ArrayList<WSNotification> wsNotifications = new ArrayList<WSNotification>();
        NodeList wsNotificationsList = securityXml.getElementsByTagName("wsNotifications");
        for (int i = 0; i < wsNotificationsList.getLength(); ++i) {
            Element wsNotificationElem = (Element)wsNotificationsList.item(i);
            if (wsNotificationElem == null) continue;
            WSNotification wsNotification = TwasXmlUtilities.loadWsNotification(wsNotificationElem);
            wsNotifications.add(wsNotification);
        }
        ArrayList<WSSchedule> wsSchedules = new ArrayList<WSSchedule>();
        NodeList wsSchedulesList = securityXml.getElementsByTagName("wsSchedules");
        for (int i = 0; i < wsSchedulesList.getLength(); ++i) {
            Element wsScheduleElem = (Element)wsSchedulesList.item(i);
            if (wsScheduleElem == null) continue;
            WSSchedule wsSchedule = TwasXmlUtilities.loadWsSchedule(wsScheduleElem);
            wsSchedules.add(wsSchedule);
        }
        ArrayList<SSLConfigGroup> sslConfigGroups = new ArrayList<SSLConfigGroup>();
        NodeList sslConfigGroupsList = securityXml.getElementsByTagName("sslConfigGroups");
        for (int i = 0; i < sslConfigGroupsList.getLength(); ++i) {
            Element sslConfigGroupElem = (Element)sslConfigGroupsList.item(i);
            if (sslConfigGroupElem == null) continue;
            SSLConfigGroup sslConfigGroup = TwasXmlUtilities.loadSslConfigGroup(sslConfigGroupElem);
            sslConfigGroups.add(sslConfigGroup);
        }
        TreeMap<String, Property> properties = new TreeMap<String, Property>();
        NodeList props = securityXml.getElementsByTagName("properties");
        for (int i = 0; i < props.getLength(); ++i) {
            Element propertyElement = (Element)props.item(i);
            Property result = TwasXmlUtilities.loadProperty(propertyElement);
            properties.put(result.getName(), result);
        }
        return new Security(enabled, appEnabled, authData, activeUserRegistry, activeAuthMechanisms, standaloneLDAPUserRegistry, wimUserRegistry, repertoires, managementScopes, keyStores, keyManagers, keySetGroups, keySets, trustManagers, dynamicSslConfigSelections, wsCertificateExpirationMonitor, wsNotifications, wsSchedules, sslConfigGroups, properties);
    }

    public static DomainSecurity loadDomainSecurity(Document securityXml, Document wimconfigXml, String name2, String cellName) {
        Map<String, AuthDataEntry> authData = TwasXmlUtilities.loadAuthDataEntries(securityXml);
        String appEnabled = "";
        String activeUserRegistryId = "";
        LDAPUserRegistry standaloneLDAPUserRegistry = null;
        WIMUserRegistry wimUserRegistry = null;
        NodeList securityList = securityXml.getElementsByTagName("security:AppSecurity");
        if (securityList.getLength() > 0) {
            Element securityElem = (Element)securityList.item(0);
            appEnabled = securityElem.getAttribute("appEnabled");
            activeUserRegistryId = securityElem.getAttribute("activeUserRegistry");
        }
        Reference<UserRegistry> activeUserRegistry = null;
        if (!"".equals(activeUserRegistryId)) {
            activeUserRegistry = new Reference<UserRegistry>(activeUserRegistryId, UserRegistry.class);
        }
        NodeList userRegistriesList = securityXml.getElementsByTagName("userRegistries");
        for (int i = 0; i < userRegistriesList.getLength(); ++i) {
            Element userRegistriesElem = (Element)userRegistriesList.item(i);
            if (standaloneLDAPUserRegistry == null && "security:LDAPUserRegistry".equals(userRegistriesElem.getAttribute("xmi:type"))) {
                standaloneLDAPUserRegistry = TwasXmlUtilities.loadStandaloneLDAPUserRegistry(userRegistriesElem, cellName);
                continue;
            }
            if (wimUserRegistry != null || !"security:WIMUserRegistry".equals(userRegistriesElem.getAttribute("xmi:type"))) continue;
            wimUserRegistry = TwasXmlUtilities.loadWIMUserRegistry(userRegistriesElem, wimconfigXml, cellName);
        }
        TreeMap<String, Property> properties = new TreeMap<String, Property>();
        NodeList props = securityXml.getElementsByTagName("properties");
        for (int i = 0; i < props.getLength(); ++i) {
            Element propertyElement = (Element)props.item(i);
            Property result = TwasXmlUtilities.loadProperty(propertyElement);
            properties.put(result.getName(), result);
        }
        return new DomainSecurity(name2, appEnabled, authData, activeUserRegistry, standaloneLDAPUserRegistry, wimUserRegistry, properties);
    }

    public static void loadBuses(Map<String, SIBus> buses, File busesDir) {
        for (File busFolder : busesDir.listFiles()) {
            if (busFolder.isDirectory()) {
                File sibBusFile = new File(busFolder, "sib-bus.xml");
                File sibDestinationsFile = new File(busFolder, "sib-destinations.xml");
                try {
                    Document sibBus;
                    if (sibBusFile.exists() && (sibBus = FileUtilities.getDocument(sibBusFile)) != null) {
                        Document sibBusDestinations;
                        Element elem = (Element)sibBus.getElementsByTagName("sibresources:SIBus").item(0);
                        String name2 = elem.getAttribute("name");
                        String secure = elem.getAttribute("secure");
                        ArrayList<SIBDestination> sibDestinations = new ArrayList<SIBDestination>();
                        if (sibDestinationsFile.exists() && (sibBusDestinations = FileUtilities.getDocument(sibDestinationsFile)) != null) {
                            NodeList topics = sibBusDestinations.getElementsByTagName("sibresources:SIBTopicSpace");
                            for (int i = 0; i < topics.getLength(); ++i) {
                                Element topic = (Element)topics.item(i);
                                sibDestinations.add(new SIBDestination(SIBDestination.Type.TOPIC_SPACE, topic.getAttribute("identifier")));
                            }
                            NodeList queues = sibBusDestinations.getElementsByTagName("sibresources:SIBQueue");
                            for (int i = 0; i < queues.getLength(); ++i) {
                                Element queue = (Element)queues.item(i);
                                sibDestinations.add(new SIBDestination(SIBDestination.Type.QUEUE, queue.getAttribute("identifier")));
                            }
                        } else {
                            ReportUtility.logger.get().log(Level.FINEST, "Unable to find or parse expected sib-destinations.xml file here: " + busFolder.getAbsolutePath());
                        }
                        SIBus bus = new SIBus(name2, secure, sibDestinations);
                        ReportUtility.logger.get().log(Level.FINEST, "Created ServiceIntegrationBus: " + bus);
                        buses.put(name2, bus);
                        continue;
                    }
                    ReportUtility.logger.get().log(Level.FINE, "Unable to find or parse expected sib-bus.xml file here: " + busFolder.getAbsolutePath());
                }
                catch (Exception e) {
                    ReportUtility.logger.get().log(Level.FINE, "Error loading bus: " + busFolder.getAbsolutePath() + ". Exception: " + e);
                }
                continue;
            }
            ReportUtility.logger.get().log(Level.FINE, "Unexpected file found in buses directory " + busFolder.getAbsolutePath());
        }
    }

    public static ProcessDefinition loadProcessDefinition(Element processDefElement) {
        ArrayList<JvmEntry> jvmEntries = new ArrayList<JvmEntry>();
        NodeList jvmEntryList = processDefElement.getElementsByTagName("jvmEntries");
        if (jvmEntryList != null) {
            for (int i = 0; i < jvmEntryList.getLength(); ++i) {
                Element entry = (Element)jvmEntryList.item(i);
                jvmEntries.add(TwasXmlUtilities.loadJvmEntry(entry));
            }
        }
        return new ProcessDefinition(jvmEntries);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<AppModule> loadApplicationModules(Document applicationXml, File applicationDeploymentDir) {
        ArrayList<AppModule> result = new ArrayList<AppModule>();
        NodeList moduleElements = applicationXml.getElementsByTagName("module");
        int i = 0;
        while (true) {
            block23: {
                String moduleId;
                block17: {
                    Element moduleSubElement;
                    String contextRoot;
                    EjbJarBnd ejbJarBnd;
                    String modulePath;
                    AppModule.ModuleType moduleType;
                    String moduleDisplayName;
                    block26: {
                        block24: {
                            block25: {
                                block19: {
                                    block22: {
                                        String moduleTypeString;
                                        block21: {
                                            block20: {
                                                block18: {
                                                    if (i >= moduleElements.getLength()) {
                                                        return result;
                                                    }
                                                    Element moduleElement = (Element)moduleElements.item(i);
                                                    moduleId = moduleElement.getAttribute("id");
                                                    moduleDisplayName = "";
                                                    moduleType = AppModule.ModuleType.UNKNOWN;
                                                    modulePath = "";
                                                    ejbJarBnd = null;
                                                    contextRoot = "";
                                                    FileUtilities.stripEmptyTextNodes(moduleElement);
                                                    NodeList moduleSubElements = moduleElement.getChildNodes();
                                                    if (moduleSubElements.getLength() <= 0) break block17;
                                                    moduleSubElement = (Element)moduleSubElements.item(0);
                                                    moduleTypeString = moduleSubElement.getTagName();
                                                    if (!moduleTypeString.equalsIgnoreCase("connector")) break block18;
                                                    moduleType = AppModule.ModuleType.CONNECTOR;
                                                    break block19;
                                                }
                                                if (!moduleTypeString.equalsIgnoreCase("ejb")) break block20;
                                                moduleType = AppModule.ModuleType.EJB;
                                                break block19;
                                            }
                                            if (!moduleTypeString.equalsIgnoreCase("java")) break block21;
                                            moduleType = AppModule.ModuleType.JAVA;
                                            break block19;
                                        }
                                        if (moduleTypeString.equalsIgnoreCase("web")) break block22;
                                        ReportUtility.logger.get().log(Level.FINE, "Module " + moduleId + " has subelement of unknown type " + moduleTypeString + ". Data for module will not be migrated.");
                                        break block23;
                                    }
                                    moduleType = AppModule.ModuleType.WEB;
                                }
                                if (moduleType != AppModule.ModuleType.WEB) break block24;
                                NodeList webUriList = moduleSubElement.getElementsByTagName("web-uri");
                                if (webUriList.getLength() <= 0) break block25;
                                Element webUri = (Element)webUriList.item(0);
                                modulePath = webUri.getTextContent();
                                break block26;
                            }
                            ReportUtility.logger.get().log(Level.FINE, "Web module " + moduleId + " has no web-uri. Data for module will not be migrated.");
                            break block23;
                        }
                        modulePath = moduleSubElement.getTextContent();
                    }
                    String moduleMetadataDir = "META-INF";
                    if (moduleType == AppModule.ModuleType.EJB) {
                        File ejbJarFile = new File(applicationDeploymentDir, modulePath + File.separator + moduleMetadataDir + File.separator + "ejb-jar.xml").getAbsoluteFile();
                        if (ejbJarFile != null && ejbJarFile.exists() && ejbJarFile.canRead()) {
                            try {
                                Document ejbJarDoc = FileUtilities.getDocument(ejbJarFile);
                                moduleDisplayName = TwasXmlUtilities.getModuleDisplayName(ejbJarDoc);
                            }
                            catch (Exception e) {
                                ReportUtility.logger.get().log(Level.FINEST, "EJB module " + modulePath + " did not have expected file " + ejbJarFile.getAbsolutePath() + ". ejb-jar data will not be migrated.", e);
                            }
                        }
                    } else if (moduleType == AppModule.ModuleType.WEB) {
                        moduleMetadataDir = "WEB-INF";
                        File webFile = new File(applicationDeploymentDir, modulePath + File.separator + moduleMetadataDir + File.separator + "web.xml").getAbsoluteFile();
                        if (webFile != null && webFile.exists() && webFile.canRead()) {
                            try {
                                Document webDoc = FileUtilities.getDocument(webFile);
                                moduleDisplayName = TwasXmlUtilities.getModuleDisplayName(webDoc);
                            }
                            catch (Exception e) {
                                ReportUtility.logger.get().log(Level.FINEST, "Web module " + modulePath + " did not have expected file " + webFile.getAbsolutePath() + ". web data will not be migrated.", e);
                            }
                        }
                    }
                    if (moduleType == AppModule.ModuleType.EJB || moduleType == AppModule.ModuleType.WEB) {
                        String ejbJarBndDir = moduleType == AppModule.ModuleType.EJB ? "META-INF" : "WEB-INF";
                        File ejbJarBndFile = new File(applicationDeploymentDir, modulePath + File.separator + ejbJarBndDir + File.separator + "ibm-ejb-jar-bnd.xml").getAbsoluteFile();
                        try {
                            Document ejbJarBndDoc = FileUtilities.getDocument(ejbJarBndFile);
                            ejbJarBnd = TwasXmlUtilities.loadEjbJarBnd(ejbJarBndDoc);
                        }
                        catch (Exception e) {
                            ReportUtility.logger.get().log(Level.FINEST, "EJB module " + modulePath + " did not have expected file " + ejbJarBndFile.getAbsolutePath() + ". ejb-jar-bnd data will not be migrated.", e);
                        }
                    }
                    if (moduleType == AppModule.ModuleType.WEB) {
                        NodeList contextRootList = moduleSubElement.getElementsByTagName("context-root");
                        if (contextRootList.getLength() > 0) {
                            Element contextRootElement = (Element)contextRootList.item(0);
                            contextRoot = contextRootElement.getTextContent();
                        } else {
                            ReportUtility.logger.get().log(Level.FINE, "Web module " + moduleId + " has no context-root specified.");
                        }
                    }
                    AppModule module = new AppModule(moduleId, moduleDisplayName, moduleType, modulePath, ejbJarBnd, contextRoot);
                    result.add(module);
                    break block23;
                }
                ReportUtility.logger.get().log(Level.FINEST, "Module " + moduleId + " has no data defined in application.xml. Data for module will not be migrated.");
            }
            ++i;
        }
    }

    public static String getModuleDisplayName(Document moduleDescriptorDoc) {
        if (moduleDescriptorDoc == null) {
            return "";
        }
        Element rootElem = moduleDescriptorDoc.getDocumentElement();
        FileUtilities.stripEmptyTextNodes(rootElem);
        NodeList rootChildren = rootElem.getChildNodes();
        for (int i = 0; i < rootChildren.getLength(); ++i) {
            Element childElem = (Element)rootChildren.item(i);
            if (!childElem.getTagName().equalsIgnoreCase("display-name")) continue;
            String result = childElem.getTextContent();
            return result;
        }
        return "";
    }

    public static EjbJarBnd loadEjbJarBnd(Document ejbJarBndDoc) {
        if (ejbJarBndDoc == null) {
            return null;
        }
        Element ejbJarBndElem = ejbJarBndDoc.getDocumentElement();
        FileUtilities.stripEmptyTextNodes(ejbJarBndElem);
        ArrayList<MessageDriven> messageDrivens = new ArrayList<MessageDriven>();
        NodeList bndChildren = ejbJarBndElem.getChildNodes();
        for (int i = 0; i < bndChildren.getLength(); ++i) {
            MessageDriven messageDriven;
            Element childElem = (Element)bndChildren.item(i);
            if (!childElem.getTagName().equalsIgnoreCase("message-driven") || (messageDriven = TwasXmlUtilities.loadMessageDriven(childElem)) == null) continue;
            messageDrivens.add(messageDriven);
        }
        EjbJarBnd result = new EjbJarBnd(messageDrivens);
        return result;
    }

    public static MessageDriven loadMessageDriven(Element messageDrivenElement) {
        if (messageDrivenElement == null) {
            return null;
        }
        String name2 = messageDrivenElement.getAttribute("name");
        ArrayList<JcaAdapter> jcaAdapters = new ArrayList<JcaAdapter>();
        NodeList mdChildren = messageDrivenElement.getChildNodes();
        for (int i = 0; i < mdChildren.getLength(); ++i) {
            JcaAdapter adapter;
            Element childElem = (Element)mdChildren.item(i);
            if (!childElem.getTagName().equalsIgnoreCase("jca-adapter") || (adapter = TwasXmlUtilities.loadJcaAdapter(childElem)) == null) continue;
            jcaAdapters.add(adapter);
        }
        MessageDriven result = new MessageDriven(name2, jcaAdapters);
        return result;
    }

    public static JcaAdapter loadJcaAdapter(Element jcaAdapterElement) {
        if (jcaAdapterElement == null) {
            return null;
        }
        String activationSpecBindingName = jcaAdapterElement.getAttribute("activation-spec-binding-name");
        String destinationBindingName = jcaAdapterElement.getAttribute("destination-binding-name");
        String activationSpecAuthAlias = jcaAdapterElement.getAttribute("activation-spec-auth-alias");
        return new JcaAdapter(activationSpecBindingName, destinationBindingName, activationSpecAuthAlias);
    }

    public static String loadApplicationDisplayName(Document applicationXml) {
        String displayName = "";
        NodeList displayNameList = applicationXml.getElementsByTagName("display-name");
        if (displayNameList.getLength() > 0) {
            Node displayNameElement = displayNameList.item(0).getFirstChild();
            if (displayNameElement != null) {
                displayName = displayNameElement.getNodeValue();
            }
            if (displayNameList.getLength() != 1) {
                ReportUtility.logger.get().log(Level.FINE, "Expected 1 display-name but found " + displayNameList.getLength() + ". Using the first name found: " + displayName);
            }
        }
        return displayName;
    }

    public static String loadApplicationVersion(Document applicationXml) {
        String version = "";
        NodeList applicationList = applicationXml.getElementsByTagName("application");
        if (applicationList.getLength() > 0) {
            Element applicationElement = (Element)applicationList.item(0);
            if (applicationElement != null) {
                version = applicationElement.getAttribute("version");
            }
            if (version.isEmpty()) {
                ReportUtility.logger.get().log(Level.FINEST, "Unable to determine version of application from application attribute, using doctype.");
                DocumentType docType = applicationXml.getDoctype();
                if (null != docType) {
                    String docTypeName = docType.getPublicId();
                    try {
                        version = docTypeName.substring(docTypeName.indexOf("J2EE Application ") + "J2EE Application ".length(), docTypeName.lastIndexOf("//"));
                    }
                    catch (Exception e) {
                        ReportUtility.logger.get().log(Level.FINE, "Unable to determine version of application from docType \"" + docTypeName + "\". Reason: " + e.getMessage());
                        ReportUtility.logger.get().log(Level.FINEST, "Exception:", e);
                        version = "";
                    }
                } else {
                    ReportUtility.logger.get().log(Level.FINE, "Unable to find docType in application.xml, returning no version");
                }
            }
            if (applicationList.getLength() != 1) {
                ReportUtility.logger.get().log(Level.FINE, "Expected 1 application element but found " + applicationList.getLength() + ". Using the first version found: " + version);
            }
        }
        return version;
    }

    public static List<SecurityRole> loadApplicationSecurityRolesXml(Document ibmApplicationBndXml, String cellName) {
        ArrayList<SecurityRole> securityRoleList = new ArrayList<SecurityRole>();
        NodeList securityRoleNodes = ibmApplicationBndXml.getElementsByTagName("security-role");
        for (int i = 0; i < securityRoleNodes.getLength(); ++i) {
            Element securityRoleElem = (Element)securityRoleNodes.item(i);
            String name2 = securityRoleElem.getAttribute("name");
            ArrayList<UserOrGroup> groups = new ArrayList<UserOrGroup>();
            ArrayList<UserOrGroup> users = new ArrayList<UserOrGroup>();
            ArrayList<String> specialSubjectTypes = new ArrayList<String>();
            RunAs runAs = null;
            NodeList children = securityRoleElem.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (!(children.item(j) instanceof Element)) continue;
                Element childElem = (Element)children.item(j);
                if (childElem.getTagName().equalsIgnoreCase("group")) {
                    UserOrGroup group = TwasXmlUtilities.loadUserOrGroup(childElem, true);
                    groups.add(group);
                    continue;
                }
                if (childElem.getTagName().equalsIgnoreCase("user")) {
                    UserOrGroup user = TwasXmlUtilities.loadUserOrGroup(childElem, true);
                    users.add(user);
                    continue;
                }
                if (childElem.getTagName().equalsIgnoreCase("special-subject")) {
                    String subject = childElem.getAttribute("type");
                    if ("".equals(subject)) continue;
                    specialSubjectTypes.add(subject);
                    continue;
                }
                if (!childElem.getTagName().equalsIgnoreCase("run-as") || runAs != null) continue;
                runAs = TwasXmlUtilities.loadRunAs(childElem, true, name2 + "_" + cellName);
            }
            securityRoleList.add(new SecurityRole(name2, groups, users, specialSubjectTypes, runAs, cellName));
        }
        return securityRoleList;
    }

    public static List<SecurityRole> loadApplicationSecurityRolesXmi(Document ibmApplicationBndXmi, Document applicationXml, String appName, String cellName) {
        RunAs runAs;
        ArrayList<SecurityRole> securityRoleList = new ArrayList<SecurityRole>();
        HashMap<String, RunAs> runAsMap = new HashMap<String, RunAs>();
        String standardHrefPrefix = "META-INF/application.xml#";
        if (applicationXml == null) {
            ReportUtility.logger.get().log(Level.FINE, "application.xml document is null. No bindings from ibm-application-bnd.xmi will be processed");
            return securityRoleList;
        }
        Map<String, String> securityRoleNameById = TwasXmlUtilities.getSecurityRoleNameById(applicationXml);
        NodeList runAsBindingsNodes = ibmApplicationBndXmi.getElementsByTagName("runAsBindings");
        for (int i = 0; i < runAsBindingsNodes.getLength(); ++i) {
            Element runAsElem = (Element)runAsBindingsNodes.item(i);
            NodeList runAsChildren = runAsElem.getChildNodes();
            String roleHref = "";
            runAs = null;
            for (int j = 0; j < runAsChildren.getLength(); ++j) {
                if (!(runAsChildren.item(j) instanceof Element)) continue;
                Element childElement = (Element)runAsChildren.item(j);
                if ("securityRole".equalsIgnoreCase(childElement.getTagName())) {
                    roleHref = childElement.getAttribute("href");
                    continue;
                }
                if (!"authData".equalsIgnoreCase(childElement.getTagName())) continue;
                runAs = TwasXmlUtilities.loadRunAs(childElement, false, appName + "_" + cellName);
            }
            if (!"".equals(roleHref)) {
                runAsMap.put(roleHref, runAs);
                continue;
            }
            ReportUtility.logger.get().log(Level.FINE, "No href found for a runAs binding from ibm-application-bnd.xmi, the binding will not be read.");
        }
        NodeList securityRoleNodes = ibmApplicationBndXmi.getElementsByTagName("authorizations");
        for (int i = 0; i < securityRoleNodes.getLength(); ++i) {
            Element securityRoleElem = (Element)securityRoleNodes.item(i);
            NodeList securityRoleChildren = securityRoleElem.getChildNodes();
            String roleHref = "";
            ArrayList<UserOrGroup> groups = new ArrayList<UserOrGroup>();
            ArrayList<UserOrGroup> users = new ArrayList<UserOrGroup>();
            ArrayList<String> specialSubjectTypes = new ArrayList<String>();
            RunAs runAs2 = null;
            for (int j = 0; j < securityRoleChildren.getLength(); ++j) {
                String translatedSpecialSubject;
                if (!(securityRoleChildren.item(j) instanceof Element)) continue;
                Element childElement = (Element)securityRoleChildren.item(j);
                if ("role".equalsIgnoreCase(childElement.getTagName())) {
                    roleHref = childElement.getAttribute("href");
                    continue;
                }
                if ("users".equalsIgnoreCase(childElement.getTagName())) {
                    UserOrGroup user = TwasXmlUtilities.loadUserOrGroup(childElement, false);
                    users.add(user);
                    continue;
                }
                if ("groups".equalsIgnoreCase(childElement.getTagName())) {
                    UserOrGroup group = TwasXmlUtilities.loadUserOrGroup(childElement, false);
                    groups.add(group);
                    continue;
                }
                if (!"specialSubjects".equalsIgnoreCase(childElement.getTagName()) || "".equals(translatedSpecialSubject = TwasXmlUtilities.loadXmiSpecialSubjects(childElement))) continue;
                specialSubjectTypes.add(translatedSpecialSubject);
            }
            if (!"".equals(roleHref)) {
                runAs2 = (RunAs)runAsMap.remove(roleHref);
                String name2 = null;
                if (roleHref.startsWith("META-INF/application.xml#")) {
                    String id = roleHref.substring("META-INF/application.xml#".length());
                    name2 = securityRoleNameById.get(id);
                } else {
                    ReportUtility.logger.get().log(Level.FINE, "The security role href did not reference the standard application.xml location. The binding will not be migrated. href: " + roleHref);
                }
                if (name2 != null) {
                    securityRoleList.add(new SecurityRole(name2, groups, users, specialSubjectTypes, runAs2, cellName));
                    continue;
                }
                ReportUtility.logger.get().log(Level.FINE, "The security role for the following reference was not found in the application.xml. The binding will not be migrated. href: " + roleHref);
                continue;
            }
            ReportUtility.logger.get().log(Level.FINE, "No href found for a security role binding from ibm-application-bnd.xmi, the binding will not be migrated.");
        }
        for (Map.Entry entry : runAsMap.entrySet()) {
            String href = (String)entry.getKey();
            runAs = (RunAs)entry.getValue();
            String name3 = null;
            if (href.startsWith("META-INF/application.xml#")) {
                String id = href.substring("META-INF/application.xml#".length());
                name3 = securityRoleNameById.get(id);
            } else {
                ReportUtility.logger.get().log(Level.FINE, "The security role href did not reference the standard application.xml location. The binding will not be migrated. href: " + href);
            }
            if (name3 != null) {
                securityRoleList.add(new SecurityRole(name3, new ArrayList<UserOrGroup>(), new ArrayList<UserOrGroup>(), new ArrayList<String>(), runAs, cellName));
                continue;
            }
            ReportUtility.logger.get().log(Level.FINE, "The security role for the following reference was not found in the application.xml. The binding will not be migrated. href: " + href);
        }
        return securityRoleList;
    }

    public static SessionManager loadSessionManager(Element sessionMgrElem, Scope scope) {
        NodeList sessionDRSPersistenceElements;
        NodeList sessionDatabasePersistenceElements;
        NodeList tuningParamElements;
        String enable = sessionMgrElem.getAttribute("enable");
        String enableUrlRewriting = sessionMgrElem.getAttribute("enableUrlRewriting");
        String enableCookies = sessionMgrElem.getAttribute("enableCookies");
        String enableSSLTracking = sessionMgrElem.getAttribute("enableSSLTracking");
        String enableProtocolSwitchRewriting = sessionMgrElem.getAttribute("enableProtocolSwitchRewriting");
        String sessionPersistenceMode = sessionMgrElem.getAttribute("sessionPersistenceMode");
        String enableSecurityIntegration = sessionMgrElem.getAttribute("enableSecurityIntegration");
        String allowSerializedSessionAccess = sessionMgrElem.getAttribute("allowSerializedSessionAccess");
        String maxWaitTime = sessionMgrElem.getAttribute("maxWaitTime");
        String accessSessionOnTimeout = sessionMgrElem.getAttribute("accessSessionOnTimeout");
        Cookie cookie = null;
        SessionDatabasePersistence sessionDatabasePersistence = null;
        TuningParams tuningParams = null;
        DRSSettings sessionDRSPersistence = null;
        ArrayList<Property> properties = new ArrayList<Property>();
        NodeList cookieElements = sessionMgrElem.getElementsByTagName("defaultCookieSettings");
        if (cookieElements.getLength() > 0) {
            cookie = TwasXmlUtilities.loadCookie((Element)cookieElements.item(0));
        }
        if ((tuningParamElements = sessionMgrElem.getElementsByTagName("tuningParams")).getLength() > 0) {
            tuningParams = TwasXmlUtilities.loadTuningParams((Element)tuningParamElements.item(0));
        }
        if ((sessionDatabasePersistenceElements = sessionMgrElem.getElementsByTagName("sessionDatabasePersistence")).getLength() > 0) {
            sessionDatabasePersistence = TwasXmlUtilities.loadSessionDatabasePersistence((Element)sessionDatabasePersistenceElements.item(0));
        }
        if ((sessionDRSPersistenceElements = sessionMgrElem.getElementsByTagName("sessionDRSPersistence")).getLength() > 0) {
            sessionDRSPersistence = TwasXmlUtilities.loadDRSSettings((Element)sessionDRSPersistenceElements.item(0));
        }
        NodeList props = sessionMgrElem.getElementsByTagName("properties");
        for (int i = 0; i < props.getLength(); ++i) {
            Element propertyElement = (Element)props.item(i);
            Property result = TwasXmlUtilities.loadProperty(propertyElement);
            properties.add(result);
        }
        return new SessionManager(scope, enable, enableUrlRewriting, enableCookies, enableSSLTracking, enableProtocolSwitchRewriting, sessionPersistenceMode, enableSecurityIntegration, allowSerializedSessionAccess, maxWaitTime, accessSessionOnTimeout, cookie, sessionDatabasePersistence, tuningParams, sessionDRSPersistence, properties);
    }

    public static List<JNDIBinding> loadJNDIBinding(Document nameBindingsXml, Scope scope, String prefix) {
        ArrayList<JNDIBinding> bindings = new ArrayList<JNDIBinding>();
        NodeList nameBindings = nameBindingsXml.getElementsByTagName("namebindings:StringNameSpaceBinding");
        for (int i = 0; i < nameBindings.getLength(); ++i) {
            Element serverElem = (Element)nameBindings.item(i);
            String name2 = serverElem.getAttribute("name");
            String jndiName = serverElem.getAttribute("nameInNameSpace");
            String value = serverElem.getAttribute("stringToBind");
            String xmiId = serverElem.getAttribute("xmi:id");
            if (name2 == null || jndiName == null || value == null) continue;
            bindings.add(new JNDIBinding(scope, name2, prefix + jndiName, value, true, xmiId));
            if (scope.getLevel() != Scope.Level.SERVER && scope.getLevel() != Scope.Level.CLUSTER) continue;
            bindings.add(new JNDIBinding(scope, name2, jndiName, value, false, xmiId));
        }
        return bindings;
    }

    public static List<VirtualHost> loadVirtualHosts(Document VirtualHostsXml, Scope scope) {
        ArrayList<VirtualHost> vh = new ArrayList<VirtualHost>();
        NodeList virtualHosts = VirtualHostsXml.getElementsByTagName("host:VirtualHost");
        for (int i = 0; i < virtualHosts.getLength(); ++i) {
            Element vhEle = (Element)virtualHosts.item(i);
            String id = vhEle.getAttribute("xmi:id");
            String name2 = vhEle.getAttribute("name");
            NodeList mimeTypesNodeList = vhEle.getElementsByTagName("mimeTypes");
            ArrayList<MimeType> mimeTypes = new ArrayList<MimeType>();
            for (int x = 0; x < mimeTypesNodeList.getLength(); ++x) {
                Element mimeEle = (Element)mimeTypesNodeList.item(x);
                String mimeId = mimeEle.getAttribute("xmi:id");
                String mimeType = mimeEle.getAttribute("type");
                NodeList extensions = mimeEle.getElementsByTagName("extensions");
                ArrayList<String> extList = new ArrayList<String>();
                for (int e = 0; e < extensions.getLength(); ++e) {
                    Node extEle = extensions.item(e);
                    String ext = extEle.getTextContent();
                    extList.add(ext);
                }
                mimeTypes.add(new MimeType(mimeId, mimeType, extList, scope));
            }
            NodeList hostAliasesND = vhEle.getElementsByTagName("aliases");
            ArrayList<HostAlias> hostAliases = new ArrayList<HostAlias>();
            for (int x = 0; x < hostAliasesND.getLength(); ++x) {
                Element hostAlias = (Element)hostAliasesND.item(x);
                String hostAliasId = hostAlias.getAttribute("xmi:id");
                String hostAliasHostName = hostAlias.getAttribute("hostname");
                String hostAliasPort = hostAlias.getAttribute("port") != null ? hostAlias.getAttribute("port") : "";
                hostAliases.add(new HostAlias(hostAliasId, hostAliasHostName, hostAliasPort));
            }
            if (id == null || name2 == null) continue;
            vh.add(new VirtualHost(id, name2, mimeTypes, hostAliases, scope));
        }
        return vh;
    }

    public static TransactionService loadTransactionService(Element txSvcElem, Element recoveryLogElem, Scope scope, List<Property> TransactionCustomProps) {
        TransactionService result = null;
        String acceptHeuristicHazard = txSvcElem.getAttribute("acceptHeuristicHazard");
        String clientInactivityTimeout = txSvcElem.getAttribute("clientInactivityTimeout");
        String enableLoggingForHeuristicReporting = txSvcElem.getAttribute("enableLoggingForHeuristicReporting");
        String heuristicRetryLimit = txSvcElem.getAttribute("heuristicRetryLimit");
        String heuristicRetryWait = txSvcElem.getAttribute("heuristicRetryWait");
        String lpsHeuristicCompletion = txSvcElem.getAttribute("LPSHeuristicCompletion");
        String propogatedOrBMTTranLifetimeTimeout = txSvcElem.getAttribute("propogatedOrBMTTranLifetimeTimeout");
        String totalTranLifetimeTimeout = txSvcElem.getAttribute("totalTranLifetimeTimeout");
        String OnePCOptimization = txSvcElem.getAttribute("OnePCOptimization");
        String defaultMaxShutdownDelay = txSvcElem.getAttribute("defaultMaxShutdownDelay");
        String enableLogRetries = txSvcElem.getAttribute("enableLogRetries");
        String heuristicRetryInterval = txSvcElem.getAttribute("heuristicRetryInterval");
        String leaseCheckInterval = txSvcElem.getAttribute("leaseCheckInterval");
        String leaseLength = txSvcElem.getAttribute("leaseLength");
        String leaseRenewalThreshold = txSvcElem.getAttribute("leaseRenewalThreshold");
        String logRetryInterval = txSvcElem.getAttribute("logRetryInterval");
        String logRetryLimit = txSvcElem.getAttribute("logRetryLimit");
        String shutdownOnLogFailure = txSvcElem.getAttribute("shutdownOnLogFailure");
        String timeoutGracePeriodEnabled = txSvcElem.getAttribute("timeoutGracePeriodEnabled");
        String transactionLogDBTableSuffix = txSvcElem.getAttribute("transactionLogDBTableSuffix");
        String transactionLogSize = txSvcElem.getAttribute("transactionLogSize");
        String waitForRecovery = txSvcElem.getAttribute("waitForRecovery");
        String recoverOnStartup = txSvcElem.getAttribute("recoverOnStartup");
        String recoveryIdentity = txSvcElem.getAttribute("recoveryIdentity");
        String recoveryGroup = txSvcElem.getAttribute("recoveryGroup");
        String datasourceJNDIName = txSvcElem.getAttribute("datasourceJNDIName");
        String backendURL = txSvcElem.getAttribute("backendURL");
        String leaseExpiryThreshold = txSvcElem.getAttribute("leaseExpiryThreshold");
        String propagateXAResourceTransactionTimeout = txSvcElem.getAttribute("propagateXAResourceTransactionTimeout");
        String transactionLogDBName = txSvcElem.getAttribute("transactionLogDBName");
        String throwCheckedExceptions = txSvcElem.getAttribute("throwCheckedExceptions");
        String transactionLogDirectory = "";
        if (!ConfigManagerFactory.isLondon()) {
            transactionLogDirectory = "";
            if (recoveryLogElem != null) {
                transactionLogDirectory = recoveryLogElem.getAttribute("transactionLogDirectory");
            }
        } else {
            transactionLogDirectory = txSvcElem.getAttribute("transactionLogDirectory");
            for (int i = 0; i < TransactionCustomProps.size(); ++i) {
                Property p = TransactionCustomProps.get(i);
                otherAttributes.put(p.getName(), p.getValue());
            }
        }
        result = new TransactionService(scope, otherAttributes, acceptHeuristicHazard, clientInactivityTimeout, enableLoggingForHeuristicReporting, heuristicRetryLimit, heuristicRetryWait, lpsHeuristicCompletion, propogatedOrBMTTranLifetimeTimeout, totalTranLifetimeTimeout, transactionLogDirectory, backendURL, leaseExpiryThreshold, propagateXAResourceTransactionTimeout, transactionLogDBName, OnePCOptimization, defaultMaxShutdownDelay, enableLogRetries, heuristicRetryInterval, leaseCheckInterval, leaseLength, leaseRenewalThreshold, logRetryInterval, logRetryLimit, shutdownOnLogFailure, timeoutGracePeriodEnabled, transactionLogDBTableSuffix, transactionLogSize, waitForRecovery, recoverOnStartup, recoveryIdentity, recoveryGroup, datasourceJNDIName, throwCheckedExceptions);
        return result;
    }

    public static TraceService loadTraceService(Element traceSvcElem, Scope scope) {
        TraceService result = null;
        String enable = traceSvcElem.getAttribute("enable");
        String startupTraceSpecification = traceSvcElem.getAttribute("startupTraceSpecification");
        String traceOutputType = traceSvcElem.getAttribute("traceOutputType");
        String traceFormat = traceSvcElem.getAttribute("traceFormat");
        String memoryBufferSize = traceSvcElem.getAttribute("memoryBufferSize");
        Element traceLogElem = (Element)traceSvcElem.getElementsByTagName("traceLog").item(0);
        TraceLog traceLog = new TraceLog(traceLogElem.getAttribute("fileName"), traceLogElem.getAttribute("rolloverSize"), traceLogElem.getAttribute("maxNumberOfBackupFiles"));
        result = new TraceService(scope, enable, startupTraceSpecification, traceOutputType, traceFormat, memoryBufferSize, traceLog);
        return result;
    }

    public static JpaService loadJpaService(Element jpaSvcElem, List<ProcessDefinition> processDefs, Scope scope) {
        String defaultNonJTADataSourceJNDIName = jpaSvcElem.getAttribute("defaultNonJTADataSourceJNDIName");
        String defaultJTADataSourceJNDIName = jpaSvcElem.getAttribute("defaultJTADataSourceJNDIName");
        String entityManagerPoolCapacity = null;
        List<String> excludedApplications = new ArrayList<String>();
        for (ProcessDefinition pd : processDefs) {
            for (JvmEntry jv : pd.getJvmEntries()) {
                for (Property p : jv.getSystemProperties()) {
                    String apps;
                    if (p.getName().equals("com.ibm.websphere.jpa.entitymanager.poolcapacity")) {
                        entityManagerPoolCapacity = p.getValue();
                        continue;
                    }
                    if (!p.getName().equals("com.ibm.websphere.persistence.ApplicationsExcludedFromJpaProcessing") || (apps = p.getValue()) == null || apps.isEmpty()) continue;
                    excludedApplications = Arrays.asList(apps.split(":"));
                }
            }
        }
        return new JpaService(scope, defaultJTADataSourceJNDIName, defaultNonJTADataSourceJNDIName, entityManagerPoolCapacity, excludedApplications);
    }

    private static Map<String, AuthDataEntry> loadAuthDataEntries(Document securityXml) {
        NodeList entries = securityXml.getElementsByTagName("authDataEntries");
        TreeMap<String, AuthDataEntry> authDataEntries = new TreeMap<String, AuthDataEntry>();
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            String xmiId = entry.getAttribute("xmi:id");
            String alias = entry.getAttribute("alias");
            String userId = entry.getAttribute("userId");
            String password = entry.getAttribute("password");
            String description = entry.getAttribute("description");
            AuthDataEntry authDataEntry = new AuthDataEntry(xmiId, alias, userId, password, description);
            authDataEntries.put(alias, authDataEntry);
            ReportUtility.logger.get().log(Level.FINEST, "Created Auth Data: " + authDataEntry);
        }
        return authDataEntries;
    }

    private static Cookie loadCookie(Element cookie) {
        String name2 = cookie.getAttribute("name");
        String domain = cookie.getAttribute("domain");
        String maximumAge = cookie.getAttribute("maximumAge");
        String path = cookie.getAttribute("path");
        String secure = cookie.getAttribute("secure");
        String httpOnly = cookie.getAttribute("httpOnly");
        String useContextRootAsPath = cookie.getAttribute("useContextRootAsPath");
        return new Cookie(name2, domain, maximumAge, path, secure, httpOnly, useContextRootAsPath);
    }

    private static TuningParams loadTuningParams(Element tuningParams) {
        String usingMultiRowSchema = tuningParams.getAttribute("usingMultiRowSchema");
        String maxInMemorySessionCount = tuningParams.getAttribute("maxInMemorySessionCount");
        String allowOverflow = tuningParams.getAttribute("allowOverflow");
        String scheduleInvalidation = tuningParams.getAttribute("scheduleInvalidation");
        String writeFrequency = tuningParams.getAttribute("writeFrequency");
        String writeInterval = tuningParams.getAttribute("writeInterval");
        String writeContents = tuningParams.getAttribute("writeContents");
        String invalidationTimeout = tuningParams.getAttribute("invalidationTimeout");
        InvalidationSchedule invalidationSchedule = null;
        NodeList invalidationScheduleElements = tuningParams.getElementsByTagName("invalidationSchedule");
        if (invalidationScheduleElements.getLength() > 0) {
            invalidationSchedule = TwasXmlUtilities.loadInvalidationSchedule((Element)invalidationScheduleElements.item(0));
        }
        return new TuningParams(usingMultiRowSchema, maxInMemorySessionCount, allowOverflow, scheduleInvalidation, writeFrequency, writeInterval, writeContents, invalidationTimeout, invalidationSchedule);
    }

    private static InvalidationSchedule loadInvalidationSchedule(Element invalidationSchedule) {
        String firstHour = invalidationSchedule.getAttribute("firstHour");
        String secondHour = invalidationSchedule.getAttribute("secondHour");
        return new InvalidationSchedule(firstHour, secondHour);
    }

    private static SessionDatabasePersistence loadSessionDatabasePersistence(Element sessionDbPersistence) {
        String datasourceJNDIName = sessionDbPersistence.getAttribute("datasourceJNDIName");
        String userId = sessionDbPersistence.getAttribute("userId");
        String password = sessionDbPersistence.getAttribute("password");
        String db2RowSize = sessionDbPersistence.getAttribute("db2RowSize");
        String tableSpaceName = sessionDbPersistence.getAttribute("tableSpaceName");
        return new SessionDatabasePersistence(datasourceJNDIName, userId, password, db2RowSize, tableSpaceName);
    }

    private static DRSSettings loadDRSSettings(Element drsSettings) {
        String dataReplicationMode = drsSettings.getAttribute("dataReplicationMode");
        String messageBrokerDomainName = drsSettings.getAttribute("messageBrokerDomainName");
        return new DRSSettings(dataReplicationMode, messageBrokerDomainName);
    }

    private static JvmEntry loadJvmEntry(Element jvmEntryElement) {
        ArrayList<String> classpath = new ArrayList<String>();
        NodeList classpathEntries = jvmEntryElement.getElementsByTagName("classpath");
        if (classpathEntries != null) {
            for (int i = 0; i < classpathEntries.getLength(); ++i) {
                NodeList values = classpathEntries.item(i).getChildNodes();
                if (values.getLength() <= 0) continue;
                classpath.add(values.item(0).getNodeValue());
            }
        }
        String initialHeapSize = jvmEntryElement.getAttribute("initialHeapSize");
        String maximumHeapSize = jvmEntryElement.getAttribute("maximumHeapSize");
        String genericJvmArguments = jvmEntryElement.getAttribute("genericJvmArguments");
        String debugMode = jvmEntryElement.getAttribute("debugMode");
        String debugArgs = jvmEntryElement.getAttribute("debugArgs");
        String verboseModeClass = jvmEntryElement.getAttribute("verboseModeClass");
        String verboseModeGarbageCollection = jvmEntryElement.getAttribute("verboseModeGarbageCollection");
        ArrayList<Property> systemProperties = new ArrayList<Property>();
        NodeList properties = jvmEntryElement.getElementsByTagName("systemProperties");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            Property result = TwasXmlUtilities.loadProperty(propertyElement);
            systemProperties.add(result);
        }
        return new JvmEntry(classpath, initialHeapSize, maximumHeapSize, genericJvmArguments, systemProperties, debugMode, debugArgs, verboseModeClass, verboseModeGarbageCollection);
    }

    public static Property loadProperty(Element propertyElement) {
        String name2 = propertyElement.getAttribute("name");
        String value = propertyElement.getAttribute("value");
        String description = propertyElement.getAttribute("description");
        String required = propertyElement.getAttribute("required");
        String validationExpression = propertyElement.getAttribute("validationExpression");
        return new Property(name2, value, description, required, validationExpression);
    }

    private static MailProvider loadMailProvider(Element mailProviderElement, Scope scope, ScopedMap<MailSession> currentMailSessions) {
        String name2 = TwasXmlUtilities.getNameOfMailProvider(mailProviderElement.getAttribute("name").replace(" ", "_"), currentMailSessions);
        String description = mailProviderElement.getAttribute("description");
        ArrayList<String> classpath = new ArrayList<String>();
        NodeList classpathEntries = mailProviderElement.getElementsByTagName("classpath");
        if (classpathEntries != null) {
            for (int i = 0; i < classpathEntries.getLength(); ++i) {
                NodeList values = classpathEntries.item(i).getChildNodes();
                if (values.getLength() <= 0) continue;
                classpath.add(values.item(0).getNodeValue());
            }
        }
        ArrayList<String> nativepath = new ArrayList<String>();
        NodeList nativepathEntries = mailProviderElement.getElementsByTagName("nativepath");
        if (nativepathEntries != null) {
            for (int i = 0; i < nativepathEntries.getLength(); ++i) {
                NodeList values = nativepathEntries.item(i).getChildNodes();
                if (values.getLength() <= 0) continue;
                nativepath.add(values.item(0).getNodeValue());
            }
        }
        String providerType = mailProviderElement.getAttribute("providerType");
        String isolatedClassLoader = mailProviderElement.getAttribute("isolatedClassLoader");
        TreeMap<String, MailSession> mailSessions = new TreeMap<String, MailSession>();
        TreeMap<String, J2EEResourceProperty> propertySet = new TreeMap<String, J2EEResourceProperty>();
        NodeList properties = mailProviderElement.getElementsByTagName("propertySet");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            J2EEResourceProperty result = TwasXmlUtilities.loadResourceProperty(propertyElement);
            propertySet.put(result.getName(), result);
        }
        String xmiId = mailProviderElement.getAttribute("xmi:id");
        MailProvider result = new MailProvider(scope, name2, description, classpath, nativepath, providerType, isolatedClassLoader, mailSessions, propertySet, xmiId);
        NodeList protocolProviders = mailProviderElement.getElementsByTagName("protocolProviders");
        for (int i = 0; i < protocolProviders.getLength(); ++i) {
            Element protocolProvidersElem = (Element)protocolProviders.item(i);
            TwasXmlUtilities.loadProtocolProviders(protocolProvidersElem);
        }
        NodeList factories = mailProviderElement.getElementsByTagName("factories");
        if (factories != null) {
            for (int i = 0; i < factories.getLength(); ++i) {
                Element factory;
                if (!(factories.item(i) instanceof Element) || !(factory = (Element)factories.item(i)).getAttribute("xmi:type").equals("resources.mail:MailSession")) continue;
                mailSessions.put(factory.getAttribute("jndiName"), TwasXmlUtilities.loadMailSession(factory, scope, result));
            }
        }
        ReportUtility.logger.get().log(Level.FINEST, "Finished Populating Provider: " + System.getProperty("line.separator") + result);
        return result;
    }

    private static JdbcProvider loadJdbcProvider(Element jdbcProviderElement, Scope scope, ScopedMap<DataSource> currentDataSources) {
        String implementationClassName;
        String name2 = TwasXmlUtilities.getNameOfJdbcProvider(jdbcProviderElement.getAttribute("name").replace(" ", "_"), currentDataSources);
        String description = jdbcProviderElement.getAttribute("description");
        ArrayList<String> classpath = new ArrayList<String>();
        NodeList classpathEntries = jdbcProviderElement.getElementsByTagName("classpath");
        if (classpathEntries != null) {
            for (int i = 0; i < classpathEntries.getLength(); ++i) {
                NodeList values = classpathEntries.item(i).getChildNodes();
                if (values.getLength() <= 0) continue;
                classpath.add(values.item(0).getNodeValue());
            }
        }
        ArrayList<String> nativepath = new ArrayList<String>();
        NodeList nativepathEntries = jdbcProviderElement.getElementsByTagName("nativepath");
        if (nativepathEntries != null) {
            for (int i = 0; i < nativepathEntries.getLength(); ++i) {
                NodeList values = nativepathEntries.item(i).getChildNodes();
                if (values.getLength() <= 0) continue;
                nativepath.add(values.item(0).getNodeValue());
            }
        }
        String providerType = jdbcProviderElement.getAttribute("providerType");
        String isolatedClassLoader = jdbcProviderElement.getAttribute("isolatedClassLoader");
        TreeMap<String, DataSource> dataSources = new TreeMap<String, DataSource>();
        TreeMap<String, J2EEResourceProperty> propertySet = new TreeMap<String, J2EEResourceProperty>();
        NodeList properties = jdbcProviderElement.getElementsByTagName("propertySet");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            J2EEResourceProperty result = TwasXmlUtilities.loadResourceProperty(propertyElement);
            propertySet.put(result.getName(), result);
        }
        String driverName = implementationClassName = jdbcProviderElement.getAttribute("implementationClassName");
        String xa = jdbcProviderElement.getAttribute("xa");
        String xmiId = jdbcProviderElement.getAttribute("xmi:id");
        JdbcProvider result = new JdbcProvider(scope, name2, description, classpath, nativepath, providerType, isolatedClassLoader, dataSources, propertySet, implementationClassName, driverName, xa, xmiId);
        NodeList factories = jdbcProviderElement.getElementsByTagName("factories");
        if (factories != null) {
            for (int i = 0; i < factories.getLength(); ++i) {
                Element factory;
                if (!(factories.item(i) instanceof Element) || !(factory = (Element)factories.item(i)).getAttribute("xmi:type").equals("resources.jdbc:DataSource")) continue;
                dataSources.put(factory.getAttribute("jndiName"), TwasXmlUtilities.loadDataSource(factory, scope, result));
            }
        }
        ReportUtility.logger.get().log(Level.FINEST, "Finished Populating JdbcProvider: " + System.getProperty("line.separator") + result);
        return result;
    }

    private static String getNameOfJdbcProvider(String defaultName, ScopedMap<DataSource> currentDataSources) {
        return TwasXmlUtilities.getNameOfJdbcProvider(defaultName, currentDataSources, 0);
    }

    private static String getNameOfJdbcProvider(String defaultName, ScopedMap<DataSource> currentDataSources, int providerId) {
        String retName = null;
        retName = providerId == 0 ? defaultName : defaultName + "_" + providerId;
        for (String key : currentDataSources.keySet()) {
            if (!retName.equals(currentDataSources.get(key, null).getProvider().getName())) continue;
            retName = TwasXmlUtilities.getNameOfJdbcProvider(defaultName, currentDataSources, providerId + 1);
        }
        return retName;
    }

    private static String getNameOfMailProvider(String defaultName, ScopedMap<MailSession> currentMailSessions) {
        return TwasXmlUtilities.getNameOfMailProvider(defaultName, currentMailSessions, 0);
    }

    private static String getNameOfMailProvider(String defaultName, ScopedMap<MailSession> currentMailSessions, int providerId) {
        String retName = null;
        retName = providerId == 0 ? defaultName : defaultName + "_" + providerId;
        for (String key : currentMailSessions.keySet()) {
            if (!retName.equals(currentMailSessions.get(key, null).getProvider().getName())) continue;
            retName = TwasXmlUtilities.getNameOfMailProvider(defaultName, currentMailSessions, providerId + 1);
        }
        return retName;
    }

    private static DataSource loadDataSource(Element datasourceElement, Scope scope, JdbcProvider provider) {
        String name2 = datasourceElement.getAttribute("name");
        String jndiName = datasourceElement.getAttribute("jndiName");
        String description = datasourceElement.getAttribute("description");
        String providerType = datasourceElement.getAttribute("providerType");
        String authMechanismPreference = datasourceElement.getAttribute("authMechanismPreference");
        String componentAuthDataAlias = datasourceElement.getAttribute("authDataAlias");
        String manageCachedHandles = datasourceElement.getAttribute("manageCachedHandles");
        String logMissingTransactionContext = datasourceElement.getAttribute("logMissingTransactionContext");
        String diagnoseConnectionUsage = datasourceElement.getAttribute("diagnoseConnectionUsage");
        String relationalResourceAdapter = datasourceElement.getAttribute("relationalResourceAdapter");
        String statementCacheSize = datasourceElement.getAttribute("statementCacheSize");
        String datasourceHelperClassname = datasourceElement.getAttribute("datasourceHelperClassname");
        String category = datasourceElement.getAttribute("category");
        String xaRecoveryAuthAlias = datasourceElement.getAttribute("xaRecoveryAuthAlias");
        String xmiId = datasourceElement.getAttribute("xmi:id");
        String mappingConfigAlias = "";
        String containerAuthDataAlias = "";
        ConnectionPool connectionPool = null;
        TreeMap<String, J2EEResourceProperty> propertySet = new TreeMap<String, J2EEResourceProperty>();
        NodeList dataSourceChildren = datasourceElement.getChildNodes();
        for (int i = 0; i < dataSourceChildren.getLength(); ++i) {
            if (!(dataSourceChildren.item(i) instanceof Element)) continue;
            Element child = (Element)dataSourceChildren.item(i);
            if (child.getTagName().equals("propertySet")) {
                NodeList properties = child.getChildNodes();
                for (int j = 0; j < properties.getLength(); ++j) {
                    if (!(properties.item(j) instanceof Element)) continue;
                    Element property = (Element)properties.item(j);
                    J2EEResourceProperty resourceProperty = TwasXmlUtilities.loadResourceProperty(property);
                    propertySet.put(resourceProperty.getName(), resourceProperty);
                }
                continue;
            }
            if (child.getTagName().equals("connectionPool")) {
                connectionPool = TwasXmlUtilities.loadConnectionPool(child);
                continue;
            }
            if (!child.getTagName().equals("mapping")) continue;
            mappingConfigAlias = child.getAttribute("mappingConfigAlias");
            containerAuthDataAlias = child.getAttribute("authDataAlias");
        }
        return new DataSource(scope, name2, jndiName, description, category, providerType, provider, propertySet, authMechanismPreference, componentAuthDataAlias, mappingConfigAlias, containerAuthDataAlias, manageCachedHandles, logMissingTransactionContext, diagnoseConnectionUsage, relationalResourceAdapter, statementCacheSize, datasourceHelperClassname, connectionPool, xaRecoveryAuthAlias, xmiId);
    }

    private static MailSession loadMailSession(Element mailSessionElement, Scope scope, MailProvider provider) {
        String name2 = mailSessionElement.getAttribute("name");
        String jndiName = mailSessionElement.getAttribute("jndiName");
        String description = mailSessionElement.getAttribute("description");
        String category = mailSessionElement.getAttribute("category");
        String providerType = mailSessionElement.getAttribute("providerType");
        String mailTransportHost = mailSessionElement.getAttribute("mailTransportHost");
        String mailTransportUser = mailSessionElement.getAttribute("mailTransportUser");
        String mailTransportPassword = mailSessionElement.getAttribute("mailTransportPassword");
        String debug = mailSessionElement.getAttribute("false");
        String mailFrom = mailSessionElement.getAttribute("mailFrom");
        String strict = mailSessionElement.getAttribute("strict");
        String mailTransportProtocol = mailSessionElement.getAttribute("mailTransportProtocol");
        String mailStoreProtocol = mailSessionElement.getAttribute("mailStoreProtocol");
        String mailStoreHost = mailSessionElement.getAttribute("mailStoreHost");
        String mailStoreUser = mailSessionElement.getAttribute("mailStoreUser");
        String mailStorePassword = mailSessionElement.getAttribute("mailStorePassword");
        Reference<ProtocolProviders> mailTransportProtocolRef = null;
        Reference<ProtocolProviders> mailStoreProtocolRef = null;
        String xmiId = mailSessionElement.getAttribute("xmi:id");
        TreeMap<String, J2EEResourceProperty> propertySet = new TreeMap<String, J2EEResourceProperty>();
        NodeList mailSessionChildren = mailSessionElement.getChildNodes();
        for (int i = 0; i < mailSessionChildren.getLength(); ++i) {
            Element child;
            if (!(mailSessionChildren.item(i) instanceof Element) || !(child = (Element)mailSessionChildren.item(i)).getTagName().equals("propertySet")) continue;
            NodeList properties = child.getChildNodes();
            for (int j = 0; j < properties.getLength(); ++j) {
                if (!(properties.item(j) instanceof Element)) continue;
                Element property = (Element)properties.item(j);
                J2EEResourceProperty resourceProperty = TwasXmlUtilities.loadResourceProperty(property);
                propertySet.put(resourceProperty.getName(), resourceProperty);
            }
        }
        if (mailStoreProtocol != null && !mailStoreProtocol.isEmpty()) {
            mailStoreProtocolRef = new Reference<ProtocolProviders>(mailStoreProtocol, ProtocolProviders.class);
        }
        if (mailTransportProtocol != null && !mailTransportProtocol.isEmpty()) {
            mailTransportProtocolRef = new Reference<ProtocolProviders>(mailTransportProtocol, ProtocolProviders.class);
        }
        return new MailSession(name2, jndiName, description, category, providerType, provider, propertySet, xmiId, scope, mailTransportHost, mailTransportUser, mailTransportPassword, debug, mailFrom, strict, mailTransportProtocol, mailStoreProtocol, mailStoreHost, mailStoreUser, mailStorePassword, mailTransportProtocolRef, mailStoreProtocolRef);
    }

    private static JmsProvider loadJmsProvider(Element jmsProviderElement, Scope scope) {
        String name2 = jmsProviderElement.getAttribute("name");
        String description = jmsProviderElement.getAttribute("description");
        String providerType = jmsProviderElement.getAttribute("providerType");
        String isolatedClassLoader = jmsProviderElement.getAttribute("isolatedClassLoader");
        String externalInitialContextFactory = jmsProviderElement.getAttribute("externalInitialContextFactory");
        String externalProviderURL = jmsProviderElement.getAttribute("externalProviderURL");
        String supportsASF = jmsProviderElement.getAttribute("supportsASF");
        ArrayList<String> classpathList = new ArrayList<String>();
        NodeList classpathEntries = jmsProviderElement.getElementsByTagName("classpath");
        if (classpathEntries != null) {
            for (int i = 0; i < classpathEntries.getLength(); ++i) {
                NodeList values = classpathEntries.item(i).getChildNodes();
                if (values.getLength() <= 0) continue;
                classpathList.add(values.item(0).getNodeValue());
            }
        }
        ArrayList<String> nativepathList = new ArrayList<String>();
        NodeList nativepathEntries = jmsProviderElement.getElementsByTagName("nativepath");
        if (nativepathEntries != null) {
            for (int i = 0; i < nativepathEntries.getLength(); ++i) {
                NodeList values = nativepathEntries.item(i).getChildNodes();
                if (values.getLength() <= 0) continue;
                nativepathList.add(values.item(0).getNodeValue());
            }
        }
        TreeMap<String, J2EEResourceFactory> factories = new TreeMap<String, J2EEResourceFactory>();
        TreeMap<String, J2EEResourceProperty> propertySet = new TreeMap<String, J2EEResourceProperty>();
        NodeList properties = jmsProviderElement.getElementsByTagName("propertySet");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            J2EEResourceProperty result = TwasXmlUtilities.loadResourceProperty(propertyElement);
            propertySet.put(result.getName(), result);
        }
        JmsProvider result = new JmsProvider(scope, name2, description, classpathList, nativepathList, providerType, isolatedClassLoader, factories, propertySet, externalInitialContextFactory, externalProviderURL, supportsASF);
        NodeList factoriesList = jmsProviderElement.getElementsByTagName("factories");
        for (int i = 0; i < factoriesList.getLength(); ++i) {
            Element factoryElement = (Element)factoriesList.item(i);
            J2EEResourceFactory factory = TwasXmlUtilities.loadJ2EEResourceFactory(factoryElement, scope, result);
            factories.put(factory.getJndiName(), factory);
        }
        ReportUtility.logger.get().log(Level.FINEST, "Finished Populating JmsProvider: " + System.getProperty("line.separator") + result);
        return result;
    }

    private static ConnectionPool loadConnectionPool(Element child) {
        String connectionTimeout = child.getAttribute("connectionTimeout");
        String maxConnections = child.getAttribute("maxConnections");
        String minConnections = child.getAttribute("minConnections");
        String reapTime = child.getAttribute("reapTime");
        String unusedTimeout = child.getAttribute("unusedTimeout");
        String agedTimeout = child.getAttribute("agedTimeout");
        String purgePolicy = child.getAttribute("purgePolicy");
        String numberOfSharedPoolPartitions = child.getAttribute("numberOfSharedPoolPartitions");
        String numberOfUnsharedPoolPartitions = child.getAttribute("numberOfUnsharedPoolPartitions");
        String numberOfFreePoolPartitions = child.getAttribute("numberOfFreePoolPartitions");
        String freePoolDistributionTableSize = child.getAttribute("freePoolDistributionTableSize");
        String surgeThreshold = child.getAttribute("surgeThreshold");
        String surgeCreationInterval = child.getAttribute("surgeCreationInterval");
        String testConnection = child.getAttribute("testConnection");
        String testConnectionInterval = child.getAttribute("testConnectionInterval");
        String stuckTimerTime = child.getAttribute("stuckTimerTime");
        String stuckTime = child.getAttribute("stuckTime");
        String stuckThreshold = child.getAttribute("stuckThreshold");
        TreeMap<String, String> properties = new TreeMap<String, String>();
        NodeList props = child.getElementsByTagName("properties");
        for (int i = 0; i < props.getLength(); ++i) {
            Element item = (Element)props.item(i);
            properties.put(item.getAttribute("name"), item.getAttribute("value"));
        }
        return new ConnectionPool(connectionTimeout, maxConnections, minConnections, reapTime, unusedTimeout, agedTimeout, purgePolicy, numberOfSharedPoolPartitions, numberOfUnsharedPoolPartitions, numberOfFreePoolPartitions, freePoolDistributionTableSize, surgeThreshold, surgeCreationInterval, testConnection, testConnectionInterval, stuckTimerTime, stuckTime, stuckThreshold, properties);
    }

    private static J2CResourceAdapter loadJ2CResourceAdapter(Element resourceAdapter, Scope scope) {
        String name2 = resourceAdapter.getAttribute("name").replaceAll(" ", "");
        String description = resourceAdapter.getAttribute("description");
        ArrayList<String> classpath = new ArrayList<String>();
        NodeList classpathList = resourceAdapter.getElementsByTagName("classpath");
        for (int i = 0; i < classpathList.getLength(); ++i) {
            NodeList values = classpathList.item(i).getChildNodes();
            if (values.getLength() <= 0) continue;
            classpath.add(values.item(0).getNodeValue());
        }
        ArrayList<String> nativepath = new ArrayList<String>();
        NodeList nativepathList = resourceAdapter.getElementsByTagName("nativepath");
        for (int i = 0; i < nativepathList.getLength(); ++i) {
            NodeList values = nativepathList.item(i).getChildNodes();
            if (values.getLength() <= 0) continue;
            nativepath.add(values.item(0).getNodeValue());
        }
        String providerType = resourceAdapter.getAttribute("providerType");
        String isolatedClassLoader = resourceAdapter.getAttribute("isolatedClassLoader");
        TreeMap<String, J2CConnectionFactory> connectionFactories = new TreeMap<String, J2CConnectionFactory>();
        TreeMap<String, J2EEResourceProperty> propertySet = new TreeMap<String, J2EEResourceProperty>();
        NodeList properties = resourceAdapter.getElementsByTagName("propertySet");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            NodeList resourceProperties = propertyElement.getElementsByTagName("resourceProperties");
            for (int x = 0; x < resourceProperties.getLength() - 1; ++x) {
                Element resourceProperty = (Element)resourceProperties.item(x);
                J2EEResourceProperty result = TwasXmlUtilities.loadResourceProperty(resourceProperty);
                propertySet.put(result.getName(), result);
            }
        }
        String archivePath = resourceAdapter.getAttribute("archivePath");
        String threadPoolAlias = resourceAdapter.getAttribute("threadPoolAlias");
        String singleton = resourceAdapter.getAttribute("singleton");
        String hACapability = resourceAdapter.getAttribute("hACapability");
        String isEnableHASupport = resourceAdapter.getAttribute("isEnableHASupport");
        TreeMap<String, J2CAdminObject> adminObjects = new TreeMap<String, J2CAdminObject>();
        NodeList adminObjectNodes = resourceAdapter.getElementsByTagName("j2cAdminObjects");
        for (int i = 0; i < adminObjectNodes.getLength(); ++i) {
            Element adminObjectElement = (Element)adminObjectNodes.item(i);
            J2CAdminObject adminObject = TwasXmlUtilities.loadJ2CAdminObject(adminObjectElement, scope);
            adminObject.setResourceAdapterId(name2);
            adminObjects.put(adminObject.getJndiName(), adminObject);
        }
        TreeMap<String, J2CActivationSpec> activationSpecs = new TreeMap<String, J2CActivationSpec>();
        NodeList activationSpecNodes = resourceAdapter.getElementsByTagName("j2cActivationSpec");
        for (int i = 0; i < activationSpecNodes.getLength(); ++i) {
            Element activationSpecElement = (Element)activationSpecNodes.item(i);
            J2CActivationSpec activationSpec = TwasXmlUtilities.loadJ2CActivationSpec(activationSpecElement, scope);
            activationSpec.setResourceAdapterId(name2);
            activationSpecs.put(activationSpec.getJndiName(), activationSpec);
        }
        Connector deploymentDescriptor = null;
        NodeList deploymentDescriptorList = resourceAdapter.getElementsByTagName("deploymentDescriptor");
        if (deploymentDescriptorList.getLength() > 0) {
            deploymentDescriptor = TwasXmlUtilities.loadConnector((Element)deploymentDescriptorList.item(0));
        }
        J2CResourceAdapter result = new J2CResourceAdapter(scope, name2, description, classpath, nativepath, providerType, isolatedClassLoader, connectionFactories, propertySet, archivePath, threadPoolAlias, singleton, hACapability, isEnableHASupport, adminObjects, activationSpecs, deploymentDescriptor);
        NodeList factories = resourceAdapter.getElementsByTagName("factories");
        for (int i = 0; i < factories.getLength(); ++i) {
            Element factoryElement = (Element)factories.item(i);
            if (!factoryElement.getAttribute("xmi:type").equals("resources.j2c:J2CConnectionFactory")) continue;
            J2CConnectionFactory connectionFactory = TwasXmlUtilities.loadJ2CConnectionFactory(factoryElement, scope, result);
            connectionFactory.setResourceAdapterId(name2);
            connectionFactories.put(connectionFactory.getJndiName(), connectionFactory);
        }
        ReportUtility.logger.get().log(Level.FINEST, "Finished Populating J2CResourceAdapter: " + System.getProperty("line.separator") + result);
        return result;
    }

    private static J2CConnectionFactory loadJ2CConnectionFactory(Element connectionFactory, Scope scope, J2EEResourceProvider provider) {
        NodeList mappingList;
        String name2 = connectionFactory.getAttribute("name");
        String jndiName = connectionFactory.getAttribute("jndiName");
        String description = connectionFactory.getAttribute("description");
        String category = connectionFactory.getAttribute("category");
        String providerType = connectionFactory.getAttribute("providerType");
        String authMechanismPreference = connectionFactory.getAttribute("authMechanismPreference");
        String manageCachedHandles = connectionFactory.getAttribute("manageCachedHandles");
        String diagnoseConnectionUsage = connectionFactory.getAttribute("diagnoseConnectionUsage");
        String logMissingTransactionContext = connectionFactory.getAttribute("logMissingTransactionContext");
        String xaRecoveryAuthAlias = connectionFactory.getAttribute("xaRecoveryAuthAlias");
        String xmiId = connectionFactory.getAttribute("xmi:id");
        String mappingConfigAlias = "";
        String containerAuthDataAlias = "";
        ConnectionPool connectionPool = null;
        String componentAuthDataAlias = connectionFactory.getAttribute("authDataAlias");
        String connectionDefinitionId = connectionFactory.getAttribute("connectionDefinition");
        Reference<ConnectionDefinition> connectionDefinition = null;
        if (connectionDefinitionId != null) {
            connectionDefinition = new Reference<ConnectionDefinition>(connectionDefinitionId, ConnectionDefinition.class);
        }
        TreeMap<String, J2EEResourceProperty> resourceProperties = new TreeMap<String, J2EEResourceProperty>();
        NodeList properties = connectionFactory.getElementsByTagName("resourceProperties");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            J2EEResourceProperty result = TwasXmlUtilities.loadResourceProperty(propertyElement);
            resourceProperties.put(result.getName(), result);
        }
        NodeList connectionPoolList = connectionFactory.getElementsByTagName("connectionPool");
        if (connectionPoolList != null && connectionPoolList.getLength() >= 1) {
            Element connectionPoolElement = (Element)connectionPoolList.item(0);
            connectionPool = TwasXmlUtilities.loadConnectionPool(connectionPoolElement);
            if (connectionPoolList.getLength() > 1) {
                ReportUtility.logger.get().log(Level.FINE, "Expected one connectionPool, found " + connectionPoolList.getLength());
            }
        }
        if ((mappingList = connectionFactory.getElementsByTagName("mapping")) != null && mappingList.getLength() >= 1) {
            Element mappingElement = (Element)mappingList.item(0);
            mappingConfigAlias = mappingElement.getAttribute("mappingConfigAlias");
            containerAuthDataAlias = mappingElement.getAttribute("authDataAlias");
        }
        return new J2CConnectionFactory(name2, jndiName, description, category, providerType, provider, resourceProperties, connectionDefinition, authMechanismPreference, componentAuthDataAlias, mappingConfigAlias, containerAuthDataAlias, manageCachedHandles, diagnoseConnectionUsage, logMissingTransactionContext, connectionPool, xaRecoveryAuthAlias, scope, xmiId);
    }

    private static J2EEResourceProperty loadResourceProperty(Element resourceProperty) {
        String name2 = resourceProperty.getAttribute("name");
        String type = resourceProperty.getAttribute("type");
        String value = resourceProperty.getAttribute("value");
        String description = resourceProperty.getAttribute("description");
        String required = resourceProperty.getAttribute("required");
        String ignore = resourceProperty.getAttribute("ignore");
        String confidential = resourceProperty.getAttribute("confidential");
        String supportsDynamicUpdates = resourceProperty.getAttribute("supportsDynamicUpdates");
        return new J2EEResourceProperty(name2, type, value, description, required, ignore, confidential, supportsDynamicUpdates);
    }

    private static J2CAdminObject loadJ2CAdminObject(Element adminObject, Scope scope) {
        String name2 = adminObject.getAttribute("name");
        String jndiName = adminObject.getAttribute("jndiName");
        String xmiId = adminObject.getAttribute("xmi:id");
        String description = adminObject.getAttribute("description");
        TreeMap<String, J2EEResourceProperty> properties = new TreeMap<String, J2EEResourceProperty>();
        NodeList propertiesList = adminObject.getElementsByTagName("properties");
        for (int i = 0; i < propertiesList.getLength(); ++i) {
            Element propertyElement = (Element)propertiesList.item(i);
            J2EEResourceProperty property = TwasXmlUtilities.loadResourceProperty(propertyElement);
            properties.put(property.getName(), property);
        }
        String adminObjectId = adminObject.getAttribute("adminObject");
        Reference<AdminObject> adminObjectReference = null;
        if (adminObjectId != null) {
            adminObjectReference = new Reference<AdminObject>(adminObjectId, AdminObject.class);
        }
        return new J2CAdminObject(scope, name2, jndiName, description, properties, adminObjectReference, xmiId);
    }

    private static Connector loadConnector(Element connector) {
        String vendorName = connector.getAttribute("vendorName");
        String specVersion = connector.getAttribute("specVersion");
        String eisType = connector.getAttribute("eisType");
        String version = connector.getAttribute("version");
        Element resourceAdapterElement = (Element)connector.getElementsByTagName("resourceAdapter").item(0);
        ResourceAdapter resourceAdapter = TwasXmlUtilities.loadResourceAdapter(resourceAdapterElement);
        return new Connector(vendorName, specVersion, eisType, version, resourceAdapter);
    }

    private static ResourceAdapter loadResourceAdapter(Element adapter) {
        TreeMap<String, AdminObject> adminObjects = new TreeMap<String, AdminObject>();
        NodeList adminObjectsList = adapter.getElementsByTagName("adminObjects");
        for (int i = 0; i < adminObjectsList.getLength(); ++i) {
            Element adminObjectElement = (Element)adminObjectsList.item(i);
            AdminObject adminObject = TwasXmlUtilities.loadAdminObject(adminObjectElement);
            adminObjects.put(adminObject.getId(), adminObject);
        }
        OutboundResourceAdapter outboundResourceAdapter = null;
        NodeList outboundResourceAdapterList = adapter.getElementsByTagName("outboundResourceAdapter");
        if (outboundResourceAdapterList != null && outboundResourceAdapterList.getLength() > 0) {
            Element outboundResourceAdapterElement = (Element)outboundResourceAdapterList.item(0);
            outboundResourceAdapter = TwasXmlUtilities.loadOutboundResourceAdapter(outboundResourceAdapterElement);
        }
        InboundResourceAdapter inboundResourceAdapter = null;
        NodeList inboundResourceAdapterList = adapter.getElementsByTagName("inboundResourceAdapter");
        if (inboundResourceAdapterList != null && inboundResourceAdapterList.getLength() > 0) {
            Element inboundResourceAdapaterElement = (Element)inboundResourceAdapterList.item(0);
            inboundResourceAdapter = TwasXmlUtilities.loadInboundResourceAdapter(inboundResourceAdapaterElement);
        }
        return new ResourceAdapter(adminObjects, outboundResourceAdapter, inboundResourceAdapter);
    }

    public static WebContainer loadWebContainer(Element web, Scope scope) {
        ArrayList<Property> properties = new ArrayList<Property>();
        NodeList props = web.getElementsByTagName("properties");
        for (int i = 0; i < props.getLength(); ++i) {
            Element propertyElement = (Element)props.item(i);
            Property result = TwasXmlUtilities.loadProperty(propertyElement);
            properties.add(result);
        }
        return new WebContainer(scope, properties);
    }

    private static AdminObject loadAdminObject(Element adminObject) {
        String id = adminObject.getAttribute("xmi:id");
        String adminObjectInterface = adminObject.getAttribute("adminObjectInterface");
        String adminObjectClass = adminObject.getAttribute("adminObjectClass");
        AdminObject result = new AdminObject(id, adminObjectInterface, adminObjectClass);
        References.register(id, result);
        return result;
    }

    private static OutboundResourceAdapter loadOutboundResourceAdapter(Element outboundRA) {
        String reauthenticationSupport = outboundRA.getAttribute("reauthenticationSupport");
        String transactionSupport = outboundRA.getAttribute("transactionSupport");
        ArrayList<ConnectionDefinition> connectionDefinitions = new ArrayList<ConnectionDefinition>();
        NodeList connectionDefs = outboundRA.getElementsByTagName("connectionDefinitions");
        for (int i = 0; i < connectionDefs.getLength(); ++i) {
            Element connectionDefElement = (Element)connectionDefs.item(i);
            ConnectionDefinition connectionDefinition = TwasXmlUtilities.loadConnectionDefinition(connectionDefElement);
            References.register(connectionDefinition.getId(), connectionDefinition);
            connectionDefinitions.add(connectionDefinition);
        }
        OutboundResourceAdapter result = new OutboundResourceAdapter(reauthenticationSupport, transactionSupport, connectionDefinitions);
        return result;
    }

    private static ConnectionDefinition loadConnectionDefinition(Element connectionDef) {
        String id = connectionDef.getAttribute("xmi:id");
        String managedConnectionFactoryClass = connectionDef.getAttribute("managedConnectionFactoryClass");
        String connectionFactoryInterface = connectionDef.getAttribute("connectionFactoryInterface");
        String connectionFactoryImplClass = connectionDef.getAttribute("connectionFactoryImplClass");
        String connectionInterface = connectionDef.getAttribute("connectionInterface");
        String connectionImplClass = connectionDef.getAttribute("connectionImplClass");
        ConnectionDefinition result = new ConnectionDefinition(id, managedConnectionFactoryClass, connectionFactoryInterface, connectionFactoryImplClass, connectionInterface, connectionImplClass);
        return result;
    }

    private static J2CActivationSpec loadJ2CActivationSpec(Element activationSpec, Scope scope) {
        String name2 = activationSpec.getAttribute("name");
        String jndiName = activationSpec.getAttribute("jndiName");
        String description = activationSpec.getAttribute("description");
        String authenticationAlias = activationSpec.getAttribute("authenticationAlias");
        String destinationJndiName = activationSpec.getAttribute("destinationJndiName");
        String activationSpecId = activationSpec.getAttribute("activationSpec");
        Reference<ActivationSpec> activationSpecReference = null;
        if (activationSpecId != null) {
            activationSpecReference = new Reference<ActivationSpec>(activationSpecId, ActivationSpec.class);
        }
        TreeMap<String, J2EEResourceProperty> properties = new TreeMap<String, J2EEResourceProperty>();
        NodeList propertiesList = activationSpec.getElementsByTagName("resourceProperties");
        for (int i = 0; i < propertiesList.getLength(); ++i) {
            Element propertyElement = (Element)propertiesList.item(i);
            J2EEResourceProperty property = TwasXmlUtilities.loadResourceProperty(propertyElement);
            properties.put(property.getName(), property);
        }
        return new J2CActivationSpec(scope, name2, jndiName, description, authenticationAlias, destinationJndiName, activationSpecReference, properties);
    }

    private static InboundResourceAdapter loadInboundResourceAdapter(Element inboundAdapter) {
        MessageAdapter messageAdapter = null;
        NodeList messageAdapterList = inboundAdapter.getElementsByTagName("messageAdapter");
        if (messageAdapterList != null && messageAdapterList.getLength() > 0) {
            Element messageAdapterElement = (Element)messageAdapterList.item(0);
            messageAdapter = TwasXmlUtilities.loadMessageAdapter(messageAdapterElement);
        }
        return new InboundResourceAdapter(messageAdapter);
    }

    private static MessageAdapter loadMessageAdapter(Element adapter) {
        ArrayList<MessageListener> messageListeners = new ArrayList<MessageListener>();
        NodeList messageListenerList = adapter.getElementsByTagName("messageListeners");
        if (messageListenerList != null && messageListenerList.getLength() > 0) {
            for (int i = 0; i < messageListenerList.getLength(); ++i) {
                Element listener = (Element)messageListenerList.item(i);
                messageListeners.add(TwasXmlUtilities.loadMessageListener(listener));
            }
        }
        return new MessageAdapter(messageListeners);
    }

    private static MessageListener loadMessageListener(Element listener) {
        String messageListenerType = listener.getAttribute("messageListenerType");
        ActivationSpec activationSpec = null;
        NodeList activationSpecList = listener.getElementsByTagName("activationSpec");
        if (activationSpecList != null && activationSpecList.getLength() > 0) {
            Element activationSpecElement = (Element)activationSpecList.item(0);
            activationSpec = TwasXmlUtilities.loadActivationSpec(activationSpecElement);
        }
        return new MessageListener(messageListenerType, activationSpec);
    }

    private static ActivationSpec loadActivationSpec(Element spec) {
        String id = spec.getAttribute("xmi:id");
        String activationSpecClass = spec.getAttribute("activationSpecClass");
        ActivationSpec activationSpec = new ActivationSpec(id, activationSpecClass);
        References.register(id, activationSpec);
        return activationSpec;
    }

    private static J2EEResourceFactory loadJ2EEResourceFactory(Element factory, Scope scope, J2EEResourceProvider provider) {
        String type = factory.getAttribute("xmi:type");
        if (type.equals("resources.j2c:J2CConnectionFactory")) {
            return TwasXmlUtilities.loadJ2CConnectionFactory(factory, scope, provider);
        }
        if (type.equals("resources.jdbc:DataSource") && provider instanceof JdbcProvider) {
            return TwasXmlUtilities.loadDataSource(factory, scope, (JdbcProvider)provider);
        }
        if (type.equals("resources.jms.mqseries:MQQueueConnectionFactory")) {
            return TwasXmlUtilities.loadMqQueueConnectionFactory(factory, scope, provider);
        }
        if (type.equals("resources.jms.mqseries:MQTopicConnectionFactory")) {
            return TwasXmlUtilities.loadMqTopicConnectionFactory(factory, scope, provider);
        }
        if (type.equals("resources.jms.mqseries:MQConnectionFactory")) {
            return TwasXmlUtilities.loadMqConnectionFactory(factory, scope, provider);
        }
        if (type.equals("resources.jms.mqseries:MQQueue")) {
            return TwasXmlUtilities.loadMqQueue(factory, scope, provider);
        }
        if (type.equals("resources.jms.mqseries:MQTopic")) {
            return TwasXmlUtilities.loadMqTopic(factory, scope, provider);
        }
        String name2 = factory.getAttribute("name");
        String jndiName = factory.getAttribute("jndiName");
        String description = factory.getAttribute("description");
        String category = factory.getAttribute("category");
        String providerType = factory.getAttribute("providerType");
        String xmiId = factory.getAttribute("xmi:id");
        TreeMap<String, J2EEResourceProperty> resourceProperties = new TreeMap<String, J2EEResourceProperty>();
        NodeList properties = factory.getElementsByTagName("resourceProperties");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            J2EEResourceProperty result = TwasXmlUtilities.loadResourceProperty(propertyElement);
            resourceProperties.put(result.getName(), result);
        }
        return new J2EEResourceFactory(name2, jndiName, description, category, providerType, provider, resourceProperties, xmiId, scope);
    }

    private static MqQueueConnectionFactory loadMqQueueConnectionFactory(Element factory, Scope scope, J2EEResourceProvider provider) {
        NodeList mappingList;
        String name2 = factory.getAttribute("name");
        String jndiName = factory.getAttribute("jndiName");
        String description = factory.getAttribute("description");
        String category = factory.getAttribute("category");
        String providerType = factory.getAttribute("providerType");
        String mappingConfigAlias = "";
        String containerAuthDataAlias = "";
        TreeMap<String, J2EEResourceProperty> propertySet = new TreeMap<String, J2EEResourceProperty>();
        NodeList properties = factory.getElementsByTagName("resourceProperties");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            J2EEResourceProperty result = TwasXmlUtilities.loadResourceProperty(propertyElement);
            propertySet.put(result.getName(), result);
        }
        String componentAuthDataAlias = factory.getAttribute("authDataAlias");
        ConnectionPool connectionPool = null;
        NodeList connPoolElements = factory.getElementsByTagName("connectionPool");
        if (connPoolElements != null && connPoolElements.getLength() > 0) {
            Element connPoolElement = (Element)connPoolElements.item(0);
            connectionPool = TwasXmlUtilities.loadConnectionPool(connPoolElement);
        }
        if ((mappingList = factory.getElementsByTagName("mapping")) != null && mappingList.getLength() >= 1) {
            Element mappingElement = (Element)mappingList.item(0);
            mappingConfigAlias = mappingElement.getAttribute("mappingConfigAlias");
            containerAuthDataAlias = mappingElement.getAttribute("authDataAlias");
        }
        String xaRecoveryAuthAlias = factory.getAttribute("xaRecoveryAuthAlias");
        String queueManager = factory.getAttribute("queueManager");
        String host = factory.getAttribute("host");
        String port = factory.getAttribute("port");
        String channel = factory.getAttribute("channel");
        String transportType = factory.getAttribute("transportType");
        String tempModel = factory.getAttribute("tempModel");
        String clientID = factory.getAttribute("clientID");
        String CCSID = factory.getAttribute("CCSID");
        String msgRetention = factory.getAttribute("msgRetention");
        String failIfQuiesce = factory.getAttribute("failIfQuiesce");
        String localAddress = factory.getAttribute("localAddress");
        String pollingInterval = factory.getAttribute("pollingInterval");
        String rescanInterval = factory.getAttribute("rescanInterval");
        String sslCipherSuite = factory.getAttribute("sslCipherSuite");
        String sslCrl = factory.getAttribute("sslCrl");
        String sslPeerName = factory.getAttribute("sslPeerName");
        String tempQueuePrefix = factory.getAttribute("tempQueuePrefix");
        String ccdtUrl = factory.getAttribute("ccdtUrl");
        String providerVersion = factory.getAttribute("providerVersion");
        String sslResetCount = factory.getAttribute("sslResetCount");
        String rcvExit = factory.getAttribute("rcvExit");
        String rcvExitInitData = factory.getAttribute("rcvExitInitData");
        String sendExit = factory.getAttribute("sendExit");
        String sendExitInitData = factory.getAttribute("sendExitInitData");
        String secExit = factory.getAttribute("secExit");
        String secExitInitData = factory.getAttribute("secExitInitData");
        String compressHeaders = factory.getAttribute("compressHeaders");
        String compressPayload = factory.getAttribute("compressPayload");
        String replyWithRFH2 = factory.getAttribute("replyWithRFH2");
        String sslType = factory.getAttribute("sslType");
        String connameList = factory.getAttribute("connameList");
        String sslConfiguration = factory.getAttribute("sslConfiguration");
        String xmiId = factory.getAttribute("xmi:id");
        return new MqQueueConnectionFactory(name2, jndiName, description, category, providerType, provider, propertySet, componentAuthDataAlias, mappingConfigAlias, containerAuthDataAlias, connectionPool, xaRecoveryAuthAlias, queueManager, host, port, channel, transportType, tempModel, clientID, CCSID, msgRetention, failIfQuiesce, localAddress, pollingInterval, rescanInterval, sslCipherSuite, sslCrl, sslPeerName, tempQueuePrefix, ccdtUrl, providerVersion, sslResetCount, rcvExit, rcvExitInitData, sendExit, sendExitInitData, secExit, secExitInitData, compressHeaders, compressPayload, replyWithRFH2, sslType, sslConfiguration, connameList, scope, xmiId);
    }

    private static MqTopicConnectionFactory loadMqTopicConnectionFactory(Element factory, Scope scope, J2EEResourceProvider provider) {
        NodeList mappingList;
        String name2 = factory.getAttribute("name");
        String jndiName = factory.getAttribute("jndiName");
        String description = factory.getAttribute("description");
        String category = factory.getAttribute("category");
        String providerType = factory.getAttribute("providerType");
        String mappingConfigAlias = "";
        String containerAuthDataAlias = "";
        TreeMap<String, J2EEResourceProperty> propertySet = new TreeMap<String, J2EEResourceProperty>();
        NodeList properties = factory.getElementsByTagName("resourceProperties");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            J2EEResourceProperty result = TwasXmlUtilities.loadResourceProperty(propertyElement);
            propertySet.put(result.getName(), result);
        }
        String componentAuthDataAlias = factory.getAttribute("authDataAlias");
        ConnectionPool connectionPool = null;
        NodeList connPoolElements = factory.getElementsByTagName("connectionPool");
        if (connPoolElements != null && connPoolElements.getLength() > 0) {
            Element connPoolElement = (Element)connPoolElements.item(0);
            connectionPool = TwasXmlUtilities.loadConnectionPool(connPoolElement);
        }
        if ((mappingList = factory.getElementsByTagName("mapping")) != null && mappingList.getLength() >= 1) {
            Element mappingElement = (Element)mappingList.item(0);
            mappingConfigAlias = mappingElement.getAttribute("mappingConfigAlias");
            containerAuthDataAlias = mappingElement.getAttribute("authDataAlias");
        }
        String xaRecoveryAuthAlias = factory.getAttribute("xaRecoveryAuthAlias");
        String host = factory.getAttribute("host");
        String port = factory.getAttribute("port");
        String transportType = factory.getAttribute("transportType");
        String channel = factory.getAttribute("channel");
        String queueManager = factory.getAttribute("queueManager");
        String brokerControlQueue = factory.getAttribute("brokerControlQueue");
        String brokerQueueManager = factory.getAttribute("brokerQueueManager");
        String brokerPubQueue = factory.getAttribute("brokerPubQueue");
        String brokerSubQueue = factory.getAttribute("brokerSubQueue");
        String brokerCCSubQ = factory.getAttribute("brokerCCSubQ");
        String brokerVersion = factory.getAttribute("brokerVersion");
        String tempModel = factory.getAttribute("tempModel");
        String clientID = factory.getAttribute("clientID");
        String CCSID = factory.getAttribute("CCSID");
        String cloneSupport = factory.getAttribute("cloneSupport");
        String pubSubCleanup = factory.getAttribute("pubSubCleanup");
        String pubSubCleanupInterval = factory.getAttribute("pubSubCleanupInterval");
        String msgSelection = factory.getAttribute("msgSelection");
        String publishAckInterval = factory.getAttribute("publishAckInterval");
        String sparseSubscriptions = factory.getAttribute("sparseSubscriptions");
        String statRefreshInterval = factory.getAttribute("statRefreshInterval");
        String substore = factory.getAttribute("substore");
        String failIfQuiesce = factory.getAttribute("failIfQuiesce");
        String localAddress = factory.getAttribute("localAddress");
        String pollingInterval = factory.getAttribute("pollingInterval");
        String rescanInterval = factory.getAttribute("rescanInterval");
        String sslCipherSuite = factory.getAttribute("sslCipherSuite");
        String sslCrl = factory.getAttribute("sslCrl");
        String sslPeerName = factory.getAttribute("sslPeerName");
        String ccdtUrl = factory.getAttribute("ccdtUrl");
        String providerVersion = factory.getAttribute("providerVersion");
        String sslResetCount = factory.getAttribute("sslResetCount");
        String rcvExit = factory.getAttribute("rcvExit");
        String rcvExitInitData = factory.getAttribute("rcvExitInitData");
        String sendExit = factory.getAttribute("sendExit");
        String sendExitInitData = factory.getAttribute("sendExitInitData");
        String secExit = factory.getAttribute("secExit");
        String secExitInitData = factory.getAttribute("secExitInitData");
        String compressHeaders = factory.getAttribute("compressHeaders");
        String compressPayload = factory.getAttribute("compressPayload");
        String wildcardFormat = factory.getAttribute("wildcardFormat");
        String tempTopicPrefix = factory.getAttribute("tempTopicPrefix");
        String sslType = factory.getAttribute("sslType");
        String sslConfiguration = factory.getAttribute("sslConfiguration");
        String connameList = factory.getAttribute("connameList");
        String xmiId = factory.getAttribute("xmi:id");
        return new MqTopicConnectionFactory(name2, jndiName, description, category, providerType, provider, propertySet, componentAuthDataAlias, mappingConfigAlias, containerAuthDataAlias, connectionPool, xaRecoveryAuthAlias, host, port, transportType, channel, queueManager, brokerControlQueue, brokerQueueManager, brokerPubQueue, brokerSubQueue, brokerCCSubQ, brokerVersion, tempModel, clientID, CCSID, cloneSupport, pubSubCleanup, pubSubCleanupInterval, msgSelection, publishAckInterval, sparseSubscriptions, statRefreshInterval, substore, failIfQuiesce, localAddress, pollingInterval, rescanInterval, sslCipherSuite, sslCrl, sslPeerName, ccdtUrl, providerVersion, sslResetCount, rcvExit, rcvExitInitData, sendExit, sendExitInitData, secExit, secExitInitData, compressHeaders, compressPayload, wildcardFormat, tempTopicPrefix, sslType, sslConfiguration, connameList, scope, xmiId);
    }

    private static MqConnectionFactory loadMqConnectionFactory(Element factory, Scope scope, J2EEResourceProvider provider) {
        NodeList mappingList;
        String name2 = factory.getAttribute("name");
        String jndiName = factory.getAttribute("jndiName");
        String description = factory.getAttribute("description");
        String category = factory.getAttribute("category");
        String providerType = factory.getAttribute("providerType");
        String mappingConfigAlias = "";
        String containerAuthDataAlias = "";
        TreeMap<String, J2EEResourceProperty> propertySet = new TreeMap<String, J2EEResourceProperty>();
        NodeList properties = factory.getElementsByTagName("resourceProperties");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            J2EEResourceProperty result = TwasXmlUtilities.loadResourceProperty(propertyElement);
            propertySet.put(result.getName(), result);
        }
        String componentAuthDataAlias = factory.getAttribute("authDataAlias");
        ConnectionPool connectionPool = null;
        NodeList connPoolElements = factory.getElementsByTagName("connectionPool");
        if (connPoolElements != null && connPoolElements.getLength() > 0) {
            Element connPoolElement = (Element)connPoolElements.item(0);
            connectionPool = TwasXmlUtilities.loadConnectionPool(connPoolElement);
        }
        if ((mappingList = factory.getElementsByTagName("mapping")) != null && mappingList.getLength() >= 1) {
            Element mappingElement = (Element)mappingList.item(0);
            mappingConfigAlias = mappingElement.getAttribute("mappingConfigAlias");
            containerAuthDataAlias = mappingElement.getAttribute("authDataAlias");
        }
        String xaRecoveryAuthAlias = factory.getAttribute("xaRecoveryAuthAlias");
        String host = factory.getAttribute("host");
        String port = factory.getAttribute("port");
        String transportType = factory.getAttribute("transportType");
        String channel = factory.getAttribute("channel");
        String queueManager = factory.getAttribute("queueManager");
        String brokerControlQueue = factory.getAttribute("brokerControlQueue");
        String brokerQueueManager = factory.getAttribute("brokerQueueManager");
        String brokerPubQueue = factory.getAttribute("brokerPubQueue");
        String brokerSubQueue = factory.getAttribute("brokerSubQueue");
        String brokerCCSubQ = factory.getAttribute("brokerCCSubQ");
        String brokerVersion = factory.getAttribute("brokerVersion");
        String pubSubCleanup = factory.getAttribute("pubSubCleanup");
        String pubSubCleanupInterval = factory.getAttribute("pubSubCleanupInterval");
        String msgSelection = factory.getAttribute("msgSelection");
        String publishAckInterval = factory.getAttribute("publishAckInterval");
        String sparseSubscriptions = factory.getAttribute("sparseSubscriptions");
        String statRefreshInterval = factory.getAttribute("statRefreshInterval");
        String substore = factory.getAttribute("substore");
        String tempModel = factory.getAttribute("tempModel");
        String clientID = factory.getAttribute("clientID");
        String CCSID = factory.getAttribute("CCSID");
        String msgRetention = factory.getAttribute("msgRetention");
        String cloneSupport = factory.getAttribute("cloneSupport");
        String failIfQuiesce = factory.getAttribute("failIfQuiesce");
        String localAddress = factory.getAttribute("localAddress");
        String pollingInterval = factory.getAttribute("pollingInterval");
        String rescanInterval = factory.getAttribute("rescanInterval");
        String sslCipherSuite = factory.getAttribute("sslCipherSuite");
        String sslCrl = factory.getAttribute("sslCrl");
        String sslPeerName = factory.getAttribute("sslPeerName");
        String tempQueuePrefix = factory.getAttribute("tempQueuePrefix");
        String ccdtUrl = factory.getAttribute("ccdtUrl");
        String providerVersion = factory.getAttribute("providerVersion");
        String sslResetCount = factory.getAttribute("sslResetCount");
        String rcvExit = factory.getAttribute("rcvExit");
        String rcvExitInitData = factory.getAttribute("rcvExitInitData");
        String sendExit = factory.getAttribute("sendExit");
        String sendExitInitData = factory.getAttribute("sendExitInitData");
        String secExit = factory.getAttribute("secExit");
        String secExitInitData = factory.getAttribute("secExitInitData");
        String compressHeaders = factory.getAttribute("compressHeaders");
        String compressPayload = factory.getAttribute("compressPayload");
        String wildcardFormat = factory.getAttribute("wildcardFormat");
        String tempTopicPrefix = factory.getAttribute("tempTopicPrefix");
        String replyWithRFH2 = factory.getAttribute("replyWithRFH2");
        String sslType = factory.getAttribute("sslType");
        String sslConfiguration = factory.getAttribute("sslConfiguration");
        String connameList = factory.getAttribute("connameList");
        String xmiId = factory.getAttribute("xmiId");
        return new MqConnectionFactory(name2, jndiName, description, category, providerType, provider, propertySet, componentAuthDataAlias, mappingConfigAlias, containerAuthDataAlias, connectionPool, xaRecoveryAuthAlias, host, port, transportType, channel, queueManager, brokerControlQueue, brokerQueueManager, brokerPubQueue, brokerSubQueue, brokerCCSubQ, brokerVersion, pubSubCleanup, pubSubCleanupInterval, msgSelection, publishAckInterval, sparseSubscriptions, statRefreshInterval, substore, tempModel, clientID, CCSID, msgRetention, cloneSupport, failIfQuiesce, localAddress, pollingInterval, rescanInterval, sslCipherSuite, sslCrl, sslPeerName, tempQueuePrefix, ccdtUrl, providerVersion, sslResetCount, rcvExit, rcvExitInitData, sendExit, sendExitInitData, secExit, secExitInitData, compressHeaders, compressPayload, wildcardFormat, tempTopicPrefix, replyWithRFH2, sslType, sslConfiguration, connameList, scope, xmiId);
    }

    private static MqQueue loadMqQueue(Element factory, Scope scope, J2EEResourceProvider provider) {
        String name2 = factory.getAttribute("name");
        String jndiName = factory.getAttribute("jndiName");
        String description = factory.getAttribute("description");
        String category = factory.getAttribute("category");
        String providerType = factory.getAttribute("providerType");
        TreeMap<String, J2EEResourceProperty> propertySet = new TreeMap<String, J2EEResourceProperty>();
        NodeList properties = factory.getElementsByTagName("resourceProperties");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            J2EEResourceProperty result = TwasXmlUtilities.loadResourceProperty(propertyElement);
            propertySet.put(result.getName(), result);
        }
        String persistence = factory.getAttribute("persistence");
        String priority = factory.getAttribute("priority");
        String specifiedPriority = factory.getAttribute("specifiedPriority");
        String expiry = factory.getAttribute("expiry");
        String specifiedExpiry = factory.getAttribute("specifiedExpiry");
        String baseQueueName = factory.getAttribute("baseQueueName");
        String baseQueueManagerName = factory.getAttribute("baseQueueManagerName");
        String CCSID = factory.getAttribute("CCSID");
        String useNativeEncoding = factory.getAttribute("useNativeEncoding");
        String integerEncoding = factory.getAttribute("integerEncoding");
        String decimalEncoding = factory.getAttribute("decimalEncoding");
        String floatingPointEncoding = factory.getAttribute("floatingPointEncoding");
        String targetClient = factory.getAttribute("targetClient");
        String sendAsync = factory.getAttribute("sendAsync");
        String readAhead = factory.getAttribute("readAhead");
        String readAheadClose = factory.getAttribute("readAheadClose");
        String receiveCCSID = factory.getAttribute("receiveCCSID");
        String receiveConvert = factory.getAttribute("receiveConvert");
        String xmiId = factory.getAttribute("xmi:id");
        return new MqQueue(name2, jndiName, description, category, providerType, provider, propertySet, persistence, priority, specifiedPriority, expiry, specifiedExpiry, baseQueueName, baseQueueManagerName, CCSID, useNativeEncoding, integerEncoding, decimalEncoding, floatingPointEncoding, targetClient, sendAsync, readAhead, readAheadClose, receiveCCSID, receiveConvert, scope, xmiId);
    }

    private static MqTopic loadMqTopic(Element factory, Scope scope, J2EEResourceProvider provider) {
        String name2 = factory.getAttribute("name");
        String jndiName = factory.getAttribute("jndiName");
        String description = factory.getAttribute("description");
        String category = factory.getAttribute("category");
        String providerType = factory.getAttribute("providerType");
        TreeMap<String, J2EEResourceProperty> propertySet = new TreeMap<String, J2EEResourceProperty>();
        NodeList properties = factory.getElementsByTagName("resourceProperties");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            J2EEResourceProperty result = TwasXmlUtilities.loadResourceProperty(propertyElement);
            propertySet.put(result.getName(), result);
        }
        String persistence = factory.getAttribute("persistence");
        String priority = factory.getAttribute("priority");
        String specifiedPriority = factory.getAttribute("specifiedPriority");
        String expiry = factory.getAttribute("expiry");
        String specifiedExpiry = factory.getAttribute("specifiedExpiry");
        String baseTopicName = factory.getAttribute("baseTopicName");
        String CCSID = factory.getAttribute("CCSID");
        String useNativeEncoding = factory.getAttribute("useNativeEncoding");
        String integerEncoding = factory.getAttribute("integerEncoding");
        String decimalEncoding = factory.getAttribute("decimalEncoding");
        String floatingPointEncoding = factory.getAttribute("floatingPointEncoding");
        String targetClient = factory.getAttribute("targetClient");
        String brokenDurSubQueue = factory.getAttribute("brokenDurSubQueue");
        String brokenCCDurSubQueue = factory.getAttribute("brokenCCDurSubQueue");
        String sendAsync = factory.getAttribute("sendAsync");
        String readAhead = factory.getAttribute("readAhead");
        String readAheadClose = factory.getAttribute("readAheadClose");
        String wildcardFormat = factory.getAttribute("wildcardFormat");
        String brokerPubQueue = factory.getAttribute("brokerPubQueue");
        String brokerPubQmgr = factory.getAttribute("brokerPubQmgr");
        String brokerVersion = factory.getAttribute("brokerVersion");
        String receiveCCSID = factory.getAttribute("receiveCCSID");
        String receiveConvert = factory.getAttribute("receiveConvert");
        String xmiId = factory.getAttribute("xmi:id");
        return new MqTopic(name2, jndiName, description, category, providerType, provider, propertySet, persistence, priority, specifiedPriority, expiry, specifiedExpiry, baseTopicName, CCSID, useNativeEncoding, integerEncoding, decimalEncoding, floatingPointEncoding, targetClient, brokenDurSubQueue, brokenCCDurSubQueue, sendAsync, readAhead, readAheadClose, wildcardFormat, brokerPubQueue, brokerPubQmgr, brokerVersion, receiveCCSID, receiveConvert, scope, xmiId);
    }

    private static LDAPUserRegistry loadStandaloneLDAPUserRegistry(Element userRegistriesElem, String cellName) {
        String id = userRegistriesElem.getAttribute("xmi:id");
        String realm = userRegistriesElem.getAttribute("realm");
        String type = userRegistriesElem.getAttribute("type");
        String baseDN = userRegistriesElem.getAttribute("baseDN");
        String bindDN = userRegistriesElem.getAttribute("bindDN");
        String bindPassword = userRegistriesElem.getAttribute("bindPassword");
        String ignoreCase = userRegistriesElem.getAttribute("ignoreCase");
        String reuseConnection = userRegistriesElem.getAttribute("reuseConnection");
        String searchTimeout = userRegistriesElem.getAttribute("searchTimeout");
        String sslEnabled = userRegistriesElem.getAttribute("sslEnabled");
        String sslConfig = userRegistriesElem.getAttribute("sslConfig");
        String monitorInterval = userRegistriesElem.getAttribute("monitorInterval");
        String serverId = userRegistriesElem.getAttribute("serverId");
        String serverPassword = userRegistriesElem.getAttribute("serverPassword");
        String limit = userRegistriesElem.getAttribute("limit");
        String useRegistryServerId = userRegistriesElem.getAttribute("useRegistryServerId");
        String primaryAdminId = userRegistriesElem.getAttribute("primaryAdminId");
        String useRegistryRealm = userRegistriesElem.getAttribute("useRegistryRealm");
        ArrayList<EndPoint> hosts = new ArrayList<EndPoint>();
        ArrayList<Property> properties = new ArrayList<Property>();
        LDAPSearchFilter searchFilter = null;
        NodeList props = userRegistriesElem.getElementsByTagName("properties");
        for (int i = 0; i < props.getLength(); ++i) {
            Element propertyElement = (Element)props.item(i);
            Property result = TwasXmlUtilities.loadProperty(propertyElement);
            properties.add(result);
        }
        NodeList hostsElements = userRegistriesElem.getElementsByTagName("hosts");
        for (int i = 0; i < hostsElements.getLength(); ++i) {
            Element hostsElem = (Element)hostsElements.item(i);
            EndPoint endPoint = TwasXmlUtilities.loadEndPoint(hostsElem);
            hosts.add(endPoint);
        }
        NodeList searchFilterElements = userRegistriesElem.getElementsByTagName("searchFilter");
        if (searchFilterElements.getLength() > 0) {
            searchFilter = TwasXmlUtilities.loadLDAPSearchFilter((Element)searchFilterElements.item(0));
        }
        LDAPUserRegistry ldapUserRegistry = new LDAPUserRegistry(id, realm, type, baseDN, bindDN, bindPassword, ignoreCase, reuseConnection, searchTimeout, sslEnabled, sslConfig, monitorInterval, hosts, properties, searchFilter, serverId, serverPassword, limit, useRegistryServerId, primaryAdminId, useRegistryRealm, cellName);
        References.register(id, ldapUserRegistry);
        return ldapUserRegistry;
    }

    private static ProtocolProviders loadProtocolProviders(Element protocolProvidersElem) {
        String id = protocolProvidersElem.getAttribute("xmi:id");
        String protocol = protocolProvidersElem.getAttribute("protocol");
        String classname = protocolProvidersElem.getAttribute("classname");
        String type = protocolProvidersElem.getAttribute("type");
        ProtocolProviders protocolProviders = new ProtocolProviders(id, protocol, classname, type);
        References.register(id, protocolProviders);
        return protocolProviders;
    }

    private static EndPoint loadEndPoint(Element endPointElem) {
        String host = endPointElem.getAttribute("host");
        String port = endPointElem.getAttribute("port");
        return new EndPoint(host, port);
    }

    private static LDAPSearchFilter loadLDAPSearchFilter(Element searchFilterElem) {
        String userFilter = searchFilterElem.getAttribute("userFilter");
        String krbUserFilter = searchFilterElem.getAttribute("krbUserFilter");
        String groupFilter = searchFilterElem.getAttribute("groupFilter");
        String userIdMap = searchFilterElem.getAttribute("userIdMap");
        String groupIdMap = searchFilterElem.getAttribute("groupIdMap");
        String groupMemberIdMap = searchFilterElem.getAttribute("groupMemberIdMap");
        String certificateMapMode = searchFilterElem.getAttribute("certificateMapMode");
        String certificateFilter = searchFilterElem.getAttribute("certificateFilter");
        return new LDAPSearchFilter(userFilter, krbUserFilter, groupFilter, userIdMap, groupIdMap, groupMemberIdMap, certificateMapMode, certificateFilter);
    }

    private static LTPAAuthMechanism loadLTPAAuthMechanism(Element ltpaAuthMechanismsElem) {
        String _xmiId = ltpaAuthMechanismsElem.getAttribute("xmi:id");
        String _oid = ltpaAuthMechanismsElem.getAttribute("OID");
        String _authContextImplClass = ltpaAuthMechanismsElem.getAttribute("authContextImplClass");
        String _authConfig = ltpaAuthMechanismsElem.getAttribute("authConfig");
        String _simpleAuthConfig = ltpaAuthMechanismsElem.getAttribute("simpleAuthConfig");
        String _authValidationConfig = ltpaAuthMechanismsElem.getAttribute("authValidationConfig");
        String _timeout = ltpaAuthMechanismsElem.getAttribute("timeout");
        String _keySetGroup = ltpaAuthMechanismsElem.getAttribute("keySetGroup");
        Reference<KeySetGroups> _keySetGroupRef = new Reference<KeySetGroups>(_keySetGroup, KeySetGroups.class);
        SingleSignOn sso = null;
        NodeList singleSignOnElements = ltpaAuthMechanismsElem.getElementsByTagName("singleSignon");
        if (singleSignOnElements.getLength() > 0) {
            Element ssoElement = (Element)singleSignOnElements.item(0);
            sso = new SingleSignOn(ssoElement.getAttribute("requiresSSL"), ssoElement.getAttribute("enabled"));
        }
        LTPAAuthMechanism result = new LTPAAuthMechanism(_xmiId, _oid, _authContextImplClass, _authConfig, _simpleAuthConfig, _authValidationConfig, _timeout, _keySetGroupRef, sso);
        References.register(_xmiId, result);
        return result;
    }

    private static WIMUserRegistry loadWIMUserRegistry(Element userRegistriesElem, Document wimconfigXml, String cellName) {
        String id = userRegistriesElem.getAttribute("xmi:id");
        String realm = userRegistriesElem.getAttribute("realm");
        String ignoreCase = userRegistriesElem.getAttribute("ignoreCase");
        String registryClassName = userRegistriesElem.getAttribute("registryClassName");
        String serverId = userRegistriesElem.getAttribute("serverId");
        String serverPassword = userRegistriesElem.getAttribute("serverPassword");
        String limit = userRegistriesElem.getAttribute("limit");
        String useRegistryServerId = userRegistriesElem.getAttribute("useRegistryServerId");
        String primaryAdminId = userRegistriesElem.getAttribute("primaryAdminId");
        String useRegistryRealm = userRegistriesElem.getAttribute("useRegistryRealm");
        ArrayList<Property> properties = new ArrayList<Property>();
        NodeList props = userRegistriesElem.getElementsByTagName("properties");
        for (int i = 0; i < props.getLength(); ++i) {
            Element propertyElement = (Element)props.item(i);
            Property result = TwasXmlUtilities.loadProperty(propertyElement);
            properties.add(result);
        }
        WimConfig wimConfig = null;
        if (wimconfigXml != null) {
            wimConfig = TwasXmlUtilities.loadWimConfig(wimconfigXml, cellName);
        }
        WIMUserRegistry result = new WIMUserRegistry(id, realm, ignoreCase, properties, registryClassName, wimConfig, serverId, serverPassword, limit, useRegistryServerId, primaryAdminId, useRegistryRealm, cellName);
        References.register(id, result);
        return result;
    }

    private static WimConfig loadWimConfig(Document wimconfigXml, String cellName) {
        ArrayList<LdapRepository> repositories = new ArrayList<LdapRepository>();
        NodeList repositoriesNodes = wimconfigXml.getElementsByTagName("config:repositories");
        for (int i = 0; i < repositoriesNodes.getLength(); ++i) {
            Element repositoryElement = (Element)repositoriesNodes.item(i);
            String repoType = repositoryElement.getAttribute("xsi:type");
            if (!"config:LdapRepositoryType".equals(repoType)) continue;
            LdapRepository repo = TwasXmlUtilities.loadWimLdapRepository(repositoryElement, cellName);
            repositories.add(repo);
        }
        RealmConfiguration realmConfiguration = null;
        NodeList realmConfigNodes = wimconfigXml.getElementsByTagName("config:realmConfiguration");
        if (realmConfigNodes.getLength() > 0) {
            realmConfiguration = TwasXmlUtilities.loadRealmConfiguration((Element)realmConfigNodes.item(0));
        }
        String maxPagingResults = null;
        String maxSearchResults = null;
        String maxTotalPagingResults = null;
        String pagedCacheTimeOut = null;
        String pagingEntityObject = null;
        String searchTimeOut = null;
        NodeList configurationProviderNodes = wimconfigXml.getElementsByTagName("config:configurationProvider");
        if (configurationProviderNodes.getLength() > 0) {
            Element configurationProvider = (Element)configurationProviderNodes.item(0);
            maxPagingResults = configurationProvider.getAttribute("maxPagingResults");
            maxSearchResults = configurationProvider.getAttribute("maxSearchResults");
            maxTotalPagingResults = configurationProvider.getAttribute("maxTotalPagingResults");
            pagedCacheTimeOut = configurationProvider.getAttribute("pagedCacheTimeOut");
            pagingEntityObject = configurationProvider.getAttribute("pagingEntityObject");
            searchTimeOut = configurationProvider.getAttribute("searchTimeOut");
        }
        return new WimConfig(repositories, realmConfiguration, maxPagingResults, maxSearchResults, maxTotalPagingResults, pagedCacheTimeOut, pagingEntityObject, searchTimeOut);
    }

    private static LdapRepository loadWimLdapRepository(Element repositoryElem, String cellName) {
        String id = repositoryElem.getAttribute("id");
        String isExtIdUnique = repositoryElem.getAttribute("isExtIdUnique");
        String supportAsyncMode = repositoryElem.getAttribute("supportAsyncMode");
        String supportExternalName = repositoryElem.getAttribute("supportExternalName");
        String supportPaging = repositoryElem.getAttribute("supportPaging");
        String supportSorting = repositoryElem.getAttribute("supportSorting");
        String supportTransactions = repositoryElem.getAttribute("supportTransactions");
        String supportChangeLog = repositoryElem.getAttribute("supportChangeLog");
        String certificateFilter = repositoryElem.getAttribute("certificateFilter");
        String certificateMapMode = repositoryElem.getAttribute("certificateMapMode");
        String ldapServerType = repositoryElem.getAttribute("ldapServerType");
        String translateRDN = repositoryElem.getAttribute("translateRDN");
        String libertyId = id + "_" + cellName;
        ArrayList<BaseEntry> baseEntries = new ArrayList<BaseEntry>();
        NodeList baseEntryNodes = repositoryElem.getElementsByTagName("config:baseEntries");
        for (int i = 0; i < baseEntryNodes.getLength(); ++i) {
            Element baseEntryElement = (Element)baseEntryNodes.item(i);
            BaseEntry baseEntry = TwasXmlUtilities.loadBaseEntry(baseEntryElement, libertyId);
            baseEntries.add(baseEntry);
        }
        ArrayList<String> loginProperties = new ArrayList<String>();
        NodeList loginPropertyNodes = repositoryElem.getElementsByTagName("config:loginProperties");
        for (int i = 0; i < loginPropertyNodes.getLength(); ++i) {
            Element loginPropertyElement = (Element)loginPropertyNodes.item(i);
            String loginProperty = TwasXmlUtilities.loadLoginProperty(loginPropertyElement);
            loginProperties.add(loginProperty);
        }
        LdapServerConfiguration ldapServerConfiguration = null;
        NodeList serverConfigNodes = repositoryElem.getElementsByTagName("config:ldapServerConfiguration");
        if (serverConfigNodes.getLength() > 0) {
            ldapServerConfiguration = TwasXmlUtilities.loadLdapServerConfiguration((Element)serverConfigNodes.item(0), libertyId);
        }
        ArrayList<LdapEntityType> ldapEntityTypes = new ArrayList<LdapEntityType>();
        NodeList ldapEntityTypeNodes = repositoryElem.getElementsByTagName("config:ldapEntityTypes");
        for (int i = 0; i < ldapEntityTypeNodes.getLength(); ++i) {
            Element ldapEntityTypeElement = (Element)ldapEntityTypeNodes.item(i);
            LdapEntityType ldapEntityType = TwasXmlUtilities.loadLdapEntityType(ldapEntityTypeElement);
            ldapEntityTypes.add(ldapEntityType);
        }
        GroupConfiguration groupConfiguration = null;
        NodeList groupConfigNodes = repositoryElem.getElementsByTagName("config:groupConfiguration");
        if (groupConfigNodes.getLength() > 0) {
            groupConfiguration = TwasXmlUtilities.loadGroupConfiguration((Element)groupConfigNodes.item(0));
        }
        AttributeConfiguration attributeConfiguration = null;
        NodeList attributeConfigNodes = repositoryElem.getElementsByTagName("config:attributeConfiguration");
        if (attributeConfigNodes.getLength() > 0) {
            attributeConfiguration = TwasXmlUtilities.loadAttributeConfiguration((Element)attributeConfigNodes.item(0));
        }
        ContextPool contextPool = null;
        NodeList contextPoolNodes = repositoryElem.getElementsByTagName("config:contextPool");
        if (contextPoolNodes.getLength() > 0) {
            contextPool = TwasXmlUtilities.loadContextPool((Element)contextPoolNodes.item(0));
        }
        CacheConfiguration cacheConfiguration = null;
        NodeList cacheConfigNodes = repositoryElem.getElementsByTagName("config:cacheConfiguration");
        if (cacheConfigNodes.getLength() > 0) {
            cacheConfiguration = TwasXmlUtilities.loadCacheConfiguration((Element)cacheConfigNodes.item(0));
        }
        return new LdapRepository(id, isExtIdUnique, supportAsyncMode, supportExternalName, supportPaging, supportSorting, supportTransactions, supportChangeLog, certificateFilter, certificateMapMode, ldapServerType, translateRDN, baseEntries, loginProperties, ldapServerConfiguration, ldapEntityTypes, groupConfiguration, attributeConfiguration, contextPool, cacheConfiguration);
    }

    private static BaseEntry loadBaseEntry(Element entryElement, String libertyId) {
        String name2 = entryElement.getAttribute("name");
        String nameInRepository = entryElement.getAttribute("nameInRepository");
        return new BaseEntry(name2, nameInRepository, libertyId);
    }

    private static String loadLoginProperty(Element propertyElement) {
        Node propertyNode = propertyElement.getFirstChild();
        if (propertyNode != null) {
            return propertyNode.getTextContent();
        }
        return null;
    }

    private static LdapServerConfiguration loadLdapServerConfiguration(Element ldapConfigElement, String libertyId) {
        String primaryServerQueryTimeInterval = ldapConfigElement.getAttribute("primaryServerQueryTimeInterval");
        String returnToPrimaryServer = ldapConfigElement.getAttribute("returnToPrimaryServer");
        String sslConfiguration = ldapConfigElement.getAttribute("sslConfiguration");
        ArrayList<LdapServer> ldapServers = new ArrayList<LdapServer>();
        NodeList ldapServerNodes = ldapConfigElement.getElementsByTagName("config:ldapServers");
        for (int i = 0; i < ldapServerNodes.getLength(); ++i) {
            Element ldapServerElement = (Element)ldapServerNodes.item(i);
            LdapServer ldapServer = TwasXmlUtilities.loadLdapServer(ldapServerElement, libertyId);
            ldapServers.add(ldapServer);
        }
        return new LdapServerConfiguration(primaryServerQueryTimeInterval, returnToPrimaryServer, sslConfiguration, ldapServers);
    }

    private static LdapServer loadLdapServer(Element ldapServerElement, String libertyId) {
        String authentication = ldapServerElement.getAttribute("authentication");
        String bindDN = ldapServerElement.getAttribute("bindDN");
        String bindPassword = ldapServerElement.getAttribute("bindPassword");
        String connectionPool = ldapServerElement.getAttribute("connectionPool");
        String connectTimeout = ldapServerElement.getAttribute("connectTimeout");
        String derefAliases = ldapServerElement.getAttribute("derefAliases");
        String referal = ldapServerElement.getAttribute("referal");
        String sslEnabled = ldapServerElement.getAttribute("sslEnabled");
        ArrayList<Connection> connections = new ArrayList<Connection>();
        NodeList connectionNodes = ldapServerElement.getElementsByTagName("config:connections");
        for (int i = 0; i < connectionNodes.getLength(); ++i) {
            Element connectionElement = (Element)connectionNodes.item(i);
            Connection connection = TwasXmlUtilities.loadConnection(connectionElement, libertyId);
            connections.add(connection);
        }
        return new LdapServer(authentication, bindDN, bindPassword, connectionPool, connectTimeout, derefAliases, referal, sslEnabled, connections, libertyId);
    }

    private static Connection loadConnection(Element connectionElement, String libertyId) {
        String host = connectionElement.getAttribute("host");
        String port = connectionElement.getAttribute("port");
        return new Connection(host, port, libertyId);
    }

    private static LdapEntityType loadLdapEntityType(Element ldapEntityElement) {
        String name2 = ldapEntityElement.getAttribute("name");
        String searchFilter = ldapEntityElement.getAttribute("searchFilter");
        ArrayList<String> objectClasses = new ArrayList<String>();
        NodeList objectClassNodes = ldapEntityElement.getElementsByTagName("config:objectClasses");
        for (int i = 0; i < objectClassNodes.getLength(); ++i) {
            Element objectClassElement = (Element)objectClassNodes.item(i);
            String objectClass = TwasXmlUtilities.loadBareTextChild(objectClassElement);
            objectClasses.add(objectClass);
        }
        ArrayList<RdnAttribute> rdnAttributes = new ArrayList<RdnAttribute>();
        NodeList rdnAttributeNodes = ldapEntityElement.getElementsByTagName("config:rdnAttributes");
        for (int i = 0; i < rdnAttributeNodes.getLength(); ++i) {
            Element rdnAttributeElement = (Element)rdnAttributeNodes.item(i);
            RdnAttribute rdnAttribute = TwasXmlUtilities.loadRdnAttribute(rdnAttributeElement);
            rdnAttributes.add(rdnAttribute);
        }
        ArrayList<String> objectClassesForCreate = new ArrayList<String>();
        NodeList objectClassesForCreateNodes = ldapEntityElement.getElementsByTagName("config:objectClassesForCreate");
        for (int i = 0; i < objectClassesForCreateNodes.getLength(); ++i) {
            Element objectClassForCreateElement = (Element)objectClassesForCreateNodes.item(i);
            String objectClassForCreate = TwasXmlUtilities.loadBareTextChild(objectClassForCreateElement);
            objectClassesForCreate.add(objectClassForCreate);
        }
        ArrayList<String> searchBases = new ArrayList<String>();
        NodeList searchBasesNodes = ldapEntityElement.getElementsByTagName("config:searchBases");
        for (int i = 0; i < searchBasesNodes.getLength(); ++i) {
            Element searchBasesElement = (Element)searchBasesNodes.item(i);
            String searchBase = TwasXmlUtilities.loadBareTextChild(searchBasesElement);
            searchBases.add(searchBase);
        }
        return new LdapEntityType(name2, searchFilter, objectClasses, rdnAttributes, objectClassesForCreate, searchBases);
    }

    private static String loadBareTextChild(Element element) {
        Node objectClassNode = element.getFirstChild();
        if (objectClassNode != null) {
            return objectClassNode.getTextContent();
        }
        return null;
    }

    private static RdnAttribute loadRdnAttribute(Element rdnAttributeElement) {
        String name2 = rdnAttributeElement.getAttribute("name");
        String objectClass = rdnAttributeElement.getAttribute("objectClass");
        return new RdnAttribute(name2, objectClass);
    }

    private static GroupConfiguration loadGroupConfiguration(Element groupConfigElement) {
        ArrayList<MemberAttribute> memberAttributes = new ArrayList<MemberAttribute>();
        ArrayList<MembershipAttribute> membershipAttributes = new ArrayList<MembershipAttribute>();
        NodeList memberAttributeNodes = groupConfigElement.getElementsByTagName("config:memberAttributes");
        for (int i = 0; i < memberAttributeNodes.getLength(); ++i) {
            Element memberAttributeElement = (Element)memberAttributeNodes.item(i);
            MemberAttribute memberAttribute = TwasXmlUtilities.loadMemberAttribute(memberAttributeElement);
            memberAttributes.add(memberAttribute);
        }
        NodeList membershipAttributeNodes = groupConfigElement.getElementsByTagName("config:membershipAttribute");
        for (int i = 0; i < membershipAttributeNodes.getLength(); ++i) {
            Element membershipAttributeElement = (Element)membershipAttributeNodes.item(i);
            MembershipAttribute membershipAttribute = TwasXmlUtilities.loadMembershipAttribute(membershipAttributeElement);
            membershipAttributes.add(membershipAttribute);
        }
        return new GroupConfiguration(memberAttributes, membershipAttributes);
    }

    private static MemberAttribute loadMemberAttribute(Element memberAttributeElement) {
        String dummyMember = memberAttributeElement.getAttribute("dummyMember");
        String name2 = memberAttributeElement.getAttribute("name");
        String objectClass = memberAttributeElement.getAttribute("objectClass");
        String scope = memberAttributeElement.getAttribute("scope");
        return new MemberAttribute(dummyMember, name2, objectClass, scope);
    }

    private static MembershipAttribute loadMembershipAttribute(Element membershipAttributeElement) {
        String name2 = membershipAttributeElement.getAttribute("name");
        String scope = membershipAttributeElement.getAttribute("scope");
        return new MembershipAttribute(name2, scope);
    }

    private static AttributeConfiguration loadAttributeConfiguration(Element attributeConfigElement) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        NodeList attributeNodes = attributeConfigElement.getElementsByTagName("config:attributes");
        for (int i = 0; i < attributeNodes.getLength(); ++i) {
            Element attributeElement = (Element)attributeNodes.item(i);
            Attribute attribute = TwasXmlUtilities.loadAttribute(attributeElement);
            attributes.add(attribute);
        }
        return new AttributeConfiguration(attributes);
    }

    private static Attribute loadAttribute(Element attributeElement) {
        String name2 = attributeElement.getAttribute("name");
        String propertyName = attributeElement.getAttribute("propertyName");
        String defaultValue = attributeElement.getAttribute("defaultValue");
        String defaultAttribute = attributeElement.getAttribute("defaultAttribute");
        String syntax = attributeElement.getAttribute("syntax");
        ArrayList<String> entityTypes = new ArrayList<String>();
        NodeList entityTypeNodes = attributeElement.getElementsByTagName("config:entityTypes");
        for (int i = 0; i < entityTypeNodes.getLength(); ++i) {
            Element entityTypeElement = (Element)entityTypeNodes.item(i);
            String entityType = TwasXmlUtilities.loadEntityType(entityTypeElement);
            entityTypes.add(entityType);
        }
        return new Attribute(name2, propertyName, entityTypes, defaultValue, defaultAttribute, syntax);
    }

    private static String loadEntityType(Element entityTypeElement) {
        Node entityTypeNode = entityTypeElement.getFirstChild();
        if (entityTypeNode != null) {
            return entityTypeNode.getTextContent();
        }
        return null;
    }

    private static ContextPool loadContextPool(Element contextPoolElement) {
        String enabled = contextPoolElement.getAttribute("enabled");
        String initPoolSize = contextPoolElement.getAttribute("initPoolSize");
        String maxPoolSize = contextPoolElement.getAttribute("maxPoolSize");
        String poolTimeOut = contextPoolElement.getAttribute("poolTimeOut");
        String poolWaitTime = contextPoolElement.getAttribute("poolWaitTime");
        String prefPoolSize = contextPoolElement.getAttribute("prefPoolSize");
        return new ContextPool(enabled, initPoolSize, maxPoolSize, poolTimeOut, poolWaitTime, prefPoolSize);
    }

    private static CacheConfiguration loadCacheConfiguration(Element cacheConfigElement) {
        AttributesCache attributesCache = null;
        NodeList attributesCacheNodes = cacheConfigElement.getElementsByTagName("config:attributesCache");
        if (attributesCacheNodes.getLength() > 0) {
            attributesCache = TwasXmlUtilities.loadAttributesCache((Element)attributesCacheNodes.item(0));
        }
        SearchResultsCache searchResultsCache = null;
        NodeList searchResultsCacheNodes = cacheConfigElement.getElementsByTagName("config:searchResultsCache");
        if (searchResultsCacheNodes.getLength() > 0) {
            searchResultsCache = TwasXmlUtilities.loadSearchResultsCache((Element)searchResultsCacheNodes.item(0));
        }
        return new CacheConfiguration(attributesCache, searchResultsCache);
    }

    private static AttributesCache loadAttributesCache(Element attributesCacheElement) {
        String attributeSizeLimit = attributesCacheElement.getAttribute("attributeSizeLimit");
        String cacheSize = attributesCacheElement.getAttribute("cacheSize");
        String cacheTimeOut = attributesCacheElement.getAttribute("cacheTimeOut");
        String enabled = attributesCacheElement.getAttribute("enabled");
        return new AttributesCache(attributeSizeLimit, cacheSize, cacheTimeOut, enabled);
    }

    private static SearchResultsCache loadSearchResultsCache(Element searchResultsCacheElement) {
        String cacheSize = searchResultsCacheElement.getAttribute("cacheSize");
        String cacheTimeOut = searchResultsCacheElement.getAttribute("cacheTimeOut");
        String enabled = searchResultsCacheElement.getAttribute("enabled");
        String searchResultSizeLimit = searchResultsCacheElement.getAttribute("searchResultSizeLimit");
        return new SearchResultsCache(cacheSize, cacheTimeOut, enabled, searchResultSizeLimit);
    }

    private static RealmConfiguration loadRealmConfiguration(Element realmConfigElement) {
        String defaultRealmName = realmConfigElement.getAttribute("defaultRealm");
        ArrayList<Realm> realms = new ArrayList<Realm>();
        NodeList realmNodes = realmConfigElement.getElementsByTagName("config:realms");
        for (int i = 0; i < realmNodes.getLength(); ++i) {
            Element realmElement = (Element)realmNodes.item(i);
            Realm realm = TwasXmlUtilities.loadRealm(realmElement);
            realms.add(realm);
        }
        return new RealmConfiguration(defaultRealmName, realms);
    }

    private static Realm loadRealm(Element realmElement) {
        String name2 = realmElement.getAttribute("name");
        String allowOpIfRepoDown = realmElement.getAttribute("allowOperationIfReposDown");
        String delimiter = realmElement.getAttribute("delimiter");
        ArrayList<String> participatingBaseEntries = new ArrayList<String>();
        NodeList participatingNodes = realmElement.getElementsByTagName("config:participatingBaseEntries");
        for (int i = 0; i < participatingNodes.getLength(); ++i) {
            Element participatingEntryElement = (Element)participatingNodes.item(i);
            String participatingBaseEntry = TwasXmlUtilities.loadParticipatingBaseEntry(participatingEntryElement);
            participatingBaseEntries.add(participatingBaseEntry);
        }
        PropertyMapping uniqueUserIdMapping = null;
        NodeList uniqueUserMappingNodes = realmElement.getElementsByTagName("config:uniqueUserIdMapping");
        for (int i = 0; i < uniqueUserMappingNodes.getLength(); ++i) {
            Element uniqueUserMappingElement = (Element)uniqueUserMappingNodes.item(i);
            uniqueUserIdMapping = TwasXmlUtilities.loadPropertyMapping(uniqueUserMappingElement);
        }
        PropertyMapping userSecurityNameMapping = null;
        NodeList userSecurityNameNodes = realmElement.getElementsByTagName("config:userSecurityNameMapping");
        for (int i = 0; i < userSecurityNameNodes.getLength(); ++i) {
            Element userSecurityNameElement = (Element)userSecurityNameNodes.item(i);
            userSecurityNameMapping = TwasXmlUtilities.loadPropertyMapping(userSecurityNameElement);
        }
        PropertyMapping userDisplayNameMapping = null;
        NodeList userDisplayNameMappingNodes = realmElement.getElementsByTagName("config:userDisplayNameMapping");
        for (int i = 0; i < userDisplayNameMappingNodes.getLength(); ++i) {
            Element userDisplayNameMappingElement = (Element)userDisplayNameMappingNodes.item(i);
            userDisplayNameMapping = TwasXmlUtilities.loadPropertyMapping(userDisplayNameMappingElement);
        }
        PropertyMapping uniqueGroupIdMapping = null;
        NodeList uniqueGroupMappingNodes = realmElement.getElementsByTagName("config:uniqueGroupIdMapping");
        for (int i = 0; i < uniqueGroupMappingNodes.getLength(); ++i) {
            Element uniqueGroupMappingElement = (Element)uniqueGroupMappingNodes.item(i);
            uniqueGroupIdMapping = TwasXmlUtilities.loadPropertyMapping(uniqueGroupMappingElement);
        }
        PropertyMapping groupSecurityNameMapping = null;
        NodeList groupSecurityNameMappingNodes = realmElement.getElementsByTagName("config:groupSecurityNameMapping");
        for (int i = 0; i < groupSecurityNameMappingNodes.getLength(); ++i) {
            Element groupSecurityNameMappingElement = (Element)groupSecurityNameMappingNodes.item(i);
            groupSecurityNameMapping = TwasXmlUtilities.loadPropertyMapping(groupSecurityNameMappingElement);
        }
        PropertyMapping groupDisplayNameMapping = null;
        NodeList groupDisplayNameMappingNodes = realmElement.getElementsByTagName("config:groupDisplayNameMapping");
        for (int i = 0; i < groupDisplayNameMappingNodes.getLength(); ++i) {
            Element groupDisplayNameMappingElement = (Element)groupDisplayNameMappingNodes.item(i);
            groupDisplayNameMapping = TwasXmlUtilities.loadPropertyMapping(groupDisplayNameMappingElement);
        }
        return new Realm(name2, allowOpIfRepoDown, delimiter, participatingBaseEntries, uniqueUserIdMapping, userSecurityNameMapping, userDisplayNameMapping, uniqueGroupIdMapping, groupSecurityNameMapping, groupDisplayNameMapping);
    }

    private static String loadParticipatingBaseEntry(Element participatingEntryElement) {
        return participatingEntryElement.getAttribute("name");
    }

    private static PropertyMapping loadPropertyMapping(Element propertyMappingElement) {
        String propertyForInput = propertyMappingElement.getAttribute("propertyForInput");
        String propertyForOutput = propertyMappingElement.getAttribute("propertyForOutput");
        return new PropertyMapping(propertyForInput, propertyForOutput);
    }

    private static UserOrGroup loadUserOrGroup(Element userOrGroupElem, boolean isXml) {
        String name2 = userOrGroupElem.getAttribute("name");
        String accessId = isXml ? userOrGroupElem.getAttribute("access-id") : userOrGroupElem.getAttribute("accessId");
        return new UserOrGroup(name2, accessId);
    }

    private static RunAs loadRunAs(Element runAsElem, boolean isXml, String parentLibertyId) {
        String userid = isXml ? runAsElem.getAttribute("userid") : runAsElem.getAttribute("userId");
        String password = runAsElem.getAttribute("password");
        return new RunAs(userid, password, parentLibertyId);
    }

    private static String loadXmiSpecialSubjects(Element childElement) {
        String translatedValue = "";
        String xmiValue = childElement.getAttribute("name");
        if ("AllAuthenticatedUsers".equals(xmiValue)) {
            translatedValue = "ALL_AUTHENTICATED_USERS";
        } else if ("Everyone".equals(xmiValue)) {
            translatedValue = "EVERYONE";
        } else if ("AllAuthenticatedInTrustedRealms".equals(xmiValue)) {
            translatedValue = "ALL_AUTHENTICATED_IN_TRUSTED_REALMS";
        }
        return translatedValue;
    }

    private static Map<String, String> getSecurityRoleNameById(Document applicationXml) {
        HashMap<String, String> roleMap = new HashMap<String, String>();
        NodeList securityRoleNodes = applicationXml.getElementsByTagName("security-role");
        for (int i = 0; i < securityRoleNodes.getLength(); ++i) {
            Element securityRoleElement = (Element)securityRoleNodes.item(i);
            String id = securityRoleElement.getAttribute("id");
            NodeList securityRoleChildren = securityRoleElement.getChildNodes();
            String roleName = "";
            for (int j = 0; j < securityRoleChildren.getLength(); ++j) {
                Node child;
                Element childElement;
                if (!(securityRoleChildren.item(j) instanceof Element) || !"role-name".equalsIgnoreCase((childElement = (Element)securityRoleChildren.item(j)).getTagName()) || (child = childElement.getFirstChild()) == null) continue;
                roleName = child.getNodeValue();
                break;
            }
            if ("".equals(id) || "".equals(roleName)) continue;
            roleMap.put(id, roleName);
        }
        return roleMap;
    }

    private static SSLConfig loadSslConfig(Element repertoire, String cellName) {
        String id = repertoire.getAttribute("xmi:id");
        String alias = repertoire.getAttribute("alias");
        String type = repertoire.getAttribute("type");
        String libertyId = alias;
        if (!ConfigManagerFactory.isLondon() || alias.equals("CellDefaultSSLSettings") || alias.equals("NodeDefaultSSLSettings") || alias.equals("XDADefaultSSLSettings")) {
            libertyId = alias + "_" + cellName + "_" + id;
        }
        SecureSocketLayer setting = null;
        NodeList settingsList = repertoire.getElementsByTagName("setting");
        if (settingsList != null && settingsList.getLength() > 0) {
            Element settingElem = (Element)settingsList.item(0);
            setting = TwasXmlUtilities.loadSecureSocketLayer(settingElem, libertyId);
        }
        String managementScope = repertoire.getAttribute("managementScope");
        Reference<ManagementScope> managementScopeRef = new Reference<ManagementScope>(managementScope, ManagementScope.class);
        SSLConfig result = new SSLConfig(id, alias, type, setting, managementScopeRef, libertyId);
        References.register(id, result);
        return result;
    }

    private static SecureSocketLayer loadSecureSocketLayer(Element setting, String parentLibertyId) {
        String keyFileName = setting.getAttribute("keyFileName");
        String keyFilePassword = setting.getAttribute("keyFilePassword");
        String keyFileFormat = setting.getAttribute("keyFileFormat");
        String clientKeyAlias = setting.getAttribute("clientKeyAlias");
        String serverKeyAlias = setting.getAttribute("serverKeyAlias");
        String trustFileName = setting.getAttribute("trustFileName");
        String trustFilePassword = setting.getAttribute("trustFilePassword");
        String trustFileFormat = setting.getAttribute("trustFileFormat");
        String clientAuthentication = setting.getAttribute("clientAuthentication");
        String securityLevel = setting.getAttribute("securityLevel");
        String enableCryptoHardwareSupport = setting.getAttribute("enableCryptoHardwareSupport");
        String enabledCiphers = setting.getAttribute("enabledCiphers");
        String jsseProvider = setting.getAttribute("jsseProvider");
        String clientAuthenticationSupported = setting.getAttribute("clientAuthenticationSupported");
        String sslProtocol = setting.getAttribute("sslProtocol");
        String keyStore = setting.getAttribute("keyStore");
        Reference<KeyStore> keyStoreRef = new Reference<KeyStore>(keyStore, KeyStore.class);
        String trustStore = setting.getAttribute("trustStore");
        Reference<KeyStore> trustStoreRef = new Reference<KeyStore>(trustStore, KeyStore.class);
        String keyManager = setting.getAttribute("keyManager");
        Reference<KeyManager> keyManagerRef = new Reference<KeyManager>(keyManager, KeyManager.class);
        ArrayList<Reference<TrustManager>> trustManagerRefs = new ArrayList<Reference<TrustManager>>();
        String trustManagers = setting.getAttribute("trustManager");
        if (trustManagers != null && !trustManagers.trim().isEmpty()) {
            String[] trustManagerIds;
            for (String trustManagerId : trustManagerIds = trustManagers.trim().split(" ")) {
                Reference<TrustManager> trustManagerRef = new Reference<TrustManager>(trustManagerId, TrustManager.class);
                trustManagerRefs.add(trustManagerRef);
            }
        }
        ArrayList<Property> propertyList = new ArrayList<Property>();
        NodeList properties = setting.getElementsByTagName("properties");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            Property result = TwasXmlUtilities.loadProperty(propertyElement);
            propertyList.add(result);
        }
        return new SecureSocketLayer(keyFileName, keyFilePassword, keyFileFormat, clientKeyAlias, serverKeyAlias, trustFileName, trustFilePassword, trustFileFormat, clientAuthentication, securityLevel, enableCryptoHardwareSupport, enabledCiphers, jsseProvider, clientAuthenticationSupported, sslProtocol, propertyList, keyStoreRef, trustStoreRef, keyManagerRef, trustManagerRefs, parentLibertyId);
    }

    private static ManagementScope loadManagementScope(Element managementScopeElem) {
        String id = managementScopeElem.getAttribute("xmi:id");
        String scopeName = managementScopeElem.getAttribute("scopeName");
        String scopeType = managementScopeElem.getAttribute("scopeType");
        ManagementScope result = new ManagementScope(id, scopeName, scopeType);
        References.register(id, result);
        return result;
    }

    private static DynamicSSLConfigSelection loadDynamicSslConfigSelection(Element dynamicElem) {
        String name2 = dynamicElem.getAttribute("name");
        String description = dynamicElem.getAttribute("description");
        String dynamicSelectionInfo = dynamicElem.getAttribute("dynamicSelectionInfo");
        String certificateAlias = dynamicElem.getAttribute("certificateAlias");
        String sslConfig = dynamicElem.getAttribute("sslConfig");
        Reference<SSLConfig> sslConfigRef = new Reference<SSLConfig>(sslConfig, SSLConfig.class);
        String managementScope = dynamicElem.getAttribute("managementScope");
        Reference<ManagementScope> managementScopeRef = new Reference<ManagementScope>(managementScope, ManagementScope.class);
        return new DynamicSSLConfigSelection(name2, description, dynamicSelectionInfo, certificateAlias, sslConfigRef, managementScopeRef);
    }

    private static KeyStore loadKeyStore(Element keyStoreElem, String cellName) {
        String id = keyStoreElem.getAttribute("xmi:id");
        String name2 = keyStoreElem.getAttribute("name");
        String password = keyStoreElem.getAttribute("password");
        String provider = keyStoreElem.getAttribute("provider");
        String location = keyStoreElem.getAttribute("location");
        String type = keyStoreElem.getAttribute("type");
        String fileBased = keyStoreElem.getAttribute("fileBased");
        String hostList = keyStoreElem.getAttribute("hostList");
        String readOnly = keyStoreElem.getAttribute("readOnly");
        String initializeAtStartup = keyStoreElem.getAttribute("initializeAtStartup");
        String customProviderClass = keyStoreElem.getAttribute("customProviderClass");
        String createStashFileForCMS = keyStoreElem.getAttribute("createStashFileForCMS");
        String slot = keyStoreElem.getAttribute("slot");
        String useForAcceleration = keyStoreElem.getAttribute("useForAcceleration");
        String description = keyStoreElem.getAttribute("description");
        String usage = keyStoreElem.getAttribute("usage");
        String managementScope = keyStoreElem.getAttribute("managementScope");
        Reference<ManagementScope> managementScopeRef = new Reference<ManagementScope>(managementScope, ManagementScope.class);
        KeyStore result = new KeyStore(id, name2, password, provider, location, type, fileBased, hostList, readOnly, initializeAtStartup, customProviderClass, createStashFileForCMS, slot, useForAcceleration, description, usage, managementScopeRef, cellName);
        References.register(id, result);
        return result;
    }

    private static KeyManager loadKeyManager(Element keyManagerElem) {
        String id = keyManagerElem.getAttribute("xmi:id");
        String name2 = keyManagerElem.getAttribute("name");
        String provider = keyManagerElem.getAttribute("provider");
        String algorithm = keyManagerElem.getAttribute("algorithm");
        String keyManagerClass = keyManagerElem.getAttribute("keyManagerClass");
        String managementScope = keyManagerElem.getAttribute("managementScope");
        Reference<ManagementScope> managementScopeRef = new Reference<ManagementScope>(managementScope, ManagementScope.class);
        ArrayList<Property> propertyList = new ArrayList<Property>();
        NodeList properties = keyManagerElem.getElementsByTagName("properties");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            Property result = TwasXmlUtilities.loadProperty(propertyElement);
            propertyList.add(result);
        }
        KeyManager result = new KeyManager(id, name2, provider, algorithm, keyManagerClass, propertyList, managementScopeRef);
        References.register(id, result);
        return result;
    }

    private static KeySetGroups loadKeySetGroups(Element keySetGroupsElem) {
        String id = keySetGroupsElem.getAttribute("xmi:id");
        String name2 = keySetGroupsElem.getAttribute("name");
        String wsSchedule = keySetGroupsElem.getAttribute("wsSchedule");
        String keySetStr = keySetGroupsElem.getAttribute("keySet");
        List<String> keySets = Arrays.asList(keySetStr.split(" "));
        ArrayList<Reference<KeySet>> keySetRefs = new ArrayList<Reference<KeySet>>();
        String managementScope = keySetGroupsElem.getAttribute("managementScope");
        Reference<ManagementScope> managementScopeRef = new Reference<ManagementScope>(managementScope, ManagementScope.class);
        for (String keySet : keySets) {
            Reference<KeySet> keySetRef = new Reference<KeySet>(keySet, KeySet.class);
            keySetRefs.add(keySetRef);
        }
        KeySetGroups result = new KeySetGroups(id, name2, wsSchedule, keySetRefs, managementScopeRef);
        References.register(id, result);
        return result;
    }

    private static KeySet loadKeySet(Element keySetElem) {
        String id = keySetElem.getAttribute("xmi:id");
        String name2 = keySetElem.getAttribute("name");
        String aliasPrefix = keySetElem.getAttribute("aliasPrefix");
        String password = keySetElem.getAttribute("password");
        String maxKeyReferences = keySetElem.getAttribute("maxKeyReferences");
        String deleteOldKeys = keySetElem.getAttribute("deleteOldKeys");
        String keyGenerationClass = keySetElem.getAttribute("keyGenerationClass");
        String isKeyPair = keySetElem.getAttribute("isKeyPair");
        String keyStore = keySetElem.getAttribute("keyStore");
        String managementScope = keySetElem.getAttribute("managementScope");
        Reference<ManagementScope> managementScopeRef = new Reference<ManagementScope>(managementScope, ManagementScope.class);
        Reference<KeyStore> keyStoreRef = new Reference<KeyStore>(keyStore, KeyStore.class);
        KeySet result = new KeySet(id, name2, aliasPrefix, password, maxKeyReferences, deleteOldKeys, keyGenerationClass, isKeyPair, keyStoreRef, managementScopeRef);
        References.register(id, result);
        return result;
    }

    private static TrustManager loadTrustManager(Element trustManagerElem) {
        String id = trustManagerElem.getAttribute("xmi:id");
        String name2 = trustManagerElem.getAttribute("name");
        String algorithm = trustManagerElem.getAttribute("algorithm");
        String trustManagerClass = trustManagerElem.getAttribute("trustManagerClass");
        String managementScope = trustManagerElem.getAttribute("managementScope");
        Reference<ManagementScope> managementScopeRef = new Reference<ManagementScope>(managementScope, ManagementScope.class);
        ArrayList<Property> propertyList = new ArrayList<Property>();
        NodeList properties = trustManagerElem.getElementsByTagName("properties");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            Property result = TwasXmlUtilities.loadProperty(propertyElement);
            propertyList.add(result);
        }
        TrustManager result = new TrustManager(id, name2, algorithm, trustManagerClass, propertyList, managementScopeRef);
        References.register(id, result);
        return result;
    }

    private static WSCertificateExpirationMonitor loadWsCertificateExpirationMonitor(Element wsCertMonElem) {
        String name2 = wsCertMonElem.getAttribute("name");
        String autoReplace = wsCertMonElem.getAttribute("autoReplace");
        String deleteOld = wsCertMonElem.getAttribute("deleteOld");
        String daysBeforeNotification = wsCertMonElem.getAttribute("daysBeforeNotification");
        String isEnabled = wsCertMonElem.getAttribute("isEnabled");
        String certImplClassToReplaceCert = wsCertMonElem.getAttribute("certImplClassToReplaceCert");
        String wsNotification = wsCertMonElem.getAttribute("wsNotification");
        Reference<WSNotification> wsNotificationRef = new Reference<WSNotification>(wsNotification, WSNotification.class);
        String wsSchedule = wsCertMonElem.getAttribute("wsSchedule");
        Reference<WSSchedule> wsScheduleRef = new Reference<WSSchedule>(wsSchedule, WSSchedule.class);
        return new WSCertificateExpirationMonitor(name2, autoReplace, deleteOld, daysBeforeNotification, isEnabled, certImplClassToReplaceCert, wsNotificationRef, wsScheduleRef);
    }

    private static WSNotification loadWsNotification(Element wsNotificationElem) {
        String id = wsNotificationElem.getAttribute("xmi:id");
        String name2 = wsNotificationElem.getAttribute("name");
        String logToSystemOut = wsNotificationElem.getAttribute("logToSystemOut");
        String sendEmail = wsNotificationElem.getAttribute("sendEmail");
        String emailList = wsNotificationElem.getAttribute("emailList");
        String emailFormat = wsNotificationElem.getAttribute("emailFormat");
        String sendSecure = wsNotificationElem.getAttribute("sendSecure");
        String sslConfig = wsNotificationElem.getAttribute("sslConfig");
        ArrayList<Property> propertyList = new ArrayList<Property>();
        NodeList properties = wsNotificationElem.getElementsByTagName("properties");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            Property result = TwasXmlUtilities.loadProperty(propertyElement);
            propertyList.add(result);
        }
        WSNotification result = new WSNotification(id, name2, logToSystemOut, sendEmail, emailList, emailFormat, sendSecure, sslConfig, propertyList);
        References.register(id, result);
        return result;
    }

    private static WSSchedule loadWsSchedule(Element wsScheduleElem) {
        String id = wsScheduleElem.getAttribute("xmi:id");
        String name2 = wsScheduleElem.getAttribute("name");
        String frequency = wsScheduleElem.getAttribute("frequency");
        String dayOfWeek = wsScheduleElem.getAttribute("dayOfWeek");
        String hour = wsScheduleElem.getAttribute("hour");
        String minute = wsScheduleElem.getAttribute("minute");
        String nextStartDate = wsScheduleElem.getAttribute("nextStartDate");
        WSSchedule result = new WSSchedule(id, name2, frequency, dayOfWeek, hour, minute, nextStartDate);
        References.register(id, result);
        return result;
    }

    private static SSLConfigGroup loadSslConfigGroup(Element sslConfigGroupElem) {
        String name2 = sslConfigGroupElem.getAttribute("name");
        String direction = sslConfigGroupElem.getAttribute("direction");
        String certificateAlias = sslConfigGroupElem.getAttribute("certificateAlias");
        String sslConfig = sslConfigGroupElem.getAttribute("sslConfig");
        Reference<SSLConfig> sslConfigRef = new Reference<SSLConfig>(sslConfig, SSLConfig.class);
        String managementScope = sslConfigGroupElem.getAttribute("managementScope");
        Reference<ManagementScope> managementScopeRef = new Reference<ManagementScope>(managementScope, ManagementScope.class);
        return new SSLConfigGroup(name2, direction, certificateAlias, sslConfigRef, managementScopeRef);
    }
}

