/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.featurelist;

import com.ibm.ws.kernel.feature.internal.FeatureResolverImpl;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.report.binary.featurelist.Feature;
import com.ibm.ws.report.binary.featurelist.FeatureList;
import com.ibm.ws.report.binary.featurelist.ResolverFeatureAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Document;

public class FeatureListFeatureResolver {
    public static ResolverResult resolve(Document featureListResource, List<String> features) {
        final ConcurrentHashMap<String, Feature> featureMap = FeatureList.getFeatureMap(featureListResource);
        final ConcurrentHashMap<String, Feature> allFeaturesKeyedBySymbolicName = FeatureList.getAllFeaturesKeyedBySymbolicName(featureListResource);
        FeatureResolverImpl featureResolver = new FeatureResolverImpl();
        FeatureResolver.Repository repository = new FeatureResolver.Repository(){

            @Override
            public ProvisioningFeatureDefinition getFeature(String featureNameOrSymbolicName) {
                Feature feature = (Feature)featureMap.get(featureNameOrSymbolicName);
                if (feature == null) {
                    feature = (Feature)allFeaturesKeyedBySymbolicName.get(featureNameOrSymbolicName);
                }
                if (feature != null) {
                    return new ResolverFeatureAdapter(feature);
                }
                return null;
            }

            @Override
            public List<String> getConfiguredTolerates(String arg0) {
                return Collections.emptyList();
            }

            @Override
            public Collection<ProvisioningFeatureDefinition> getAutoFeatures() {
                ArrayList<ProvisioningFeatureDefinition> autoFeatures = new ArrayList<ProvisioningFeatureDefinition>();
                for (Feature feature : allFeaturesKeyedBySymbolicName.values()) {
                    ResolverFeatureAdapter resolverFeatureAdapter = new ResolverFeatureAdapter(feature);
                    if (!resolverFeatureAdapter.isAutoFeature()) continue;
                    autoFeatures.add(resolverFeatureAdapter);
                }
                return autoFeatures;
            }
        };
        FeatureResolver.Result result = featureResolver.resolveFeatures(repository, features, Collections.<String>emptySet(), false);
        HashSet<FeatureConflict> featureConflicts = new HashSet<FeatureConflict>();
        for (Map.Entry<String, Collection<FeatureResolver.Chain>> conflict : result.getConflicts().entrySet()) {
            String conflictA = null;
            String conflictB = null;
            ArrayList<String> dependencyChainA = new ArrayList<String>();
            ArrayList<String> dependencyChainB = new ArrayList<String>();
            for (FeatureResolver.Chain chain : conflict.getValue()) {
                List<String> candidates = chain.getCandidates();
                if (conflictA == null) {
                    conflictA = candidates.get(0);
                    if (chain.getChain().isEmpty()) {
                        dependencyChainA.add(conflictA);
                        continue;
                    }
                    dependencyChainA.addAll(chain.getChain());
                    dependencyChainA.add(conflictA);
                    continue;
                }
                if (conflictA.equals(candidates.get(0))) continue;
                conflictB = candidates.get(0);
                if (chain.getChain().isEmpty()) {
                    dependencyChainB.add(conflictB);
                    break;
                }
                dependencyChainB.addAll(chain.getChain());
                dependencyChainB.add(conflictB);
                break;
            }
            featureConflicts.add(new FeatureConflict(dependencyChainA, dependencyChainB));
        }
        return new ResolverResult(featureConflicts, result.getMissing(), result.getNonPublicRoots(), result.getResolvedFeatures());
    }

    public static String getDependencyChainString(List<String> dependencyChain, Document featureListResource) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = dependencyChain.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(String.valueOf('\'') + FeatureList.getPublicFeatureName(iterator.next(), featureListResource) + '\'');
        }
        while (iterator.hasNext()) {
            stringBuilder.append(" --> '").append(String.valueOf(FeatureList.getPublicFeatureName(iterator.next(), featureListResource)) + '\'');
        }
        if (dependencyChain.size() > 1) {
            stringBuilder.insert(0, "[");
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public static class FeatureConflict
    implements Serializable {
        private static final long serialVersionUID = 9091468059230107746L;
        private final List<String> dependencyChainA;
        private final List<String> dependencyChainB;

        public FeatureConflict(List<String> dependencyChainA, List<String> dependencyChainB) {
            this.dependencyChainA = dependencyChainA;
            this.dependencyChainB = dependencyChainB;
        }

        public String getConfiguredFeatureA() {
            return this.dependencyChainA.get(0);
        }

        public String getConfiguredFeatureB() {
            return this.dependencyChainB.get(0);
        }

        public String getConflictingFeatureA() {
            return this.dependencyChainA.get(this.dependencyChainA.size() - 1);
        }

        public String getConflictingFeatureB() {
            return this.dependencyChainB.get(this.dependencyChainB.size() - 1);
        }

        public List<String> getDependencyChainA() {
            return this.dependencyChainA;
        }

        public List<String> getDependencyChainB() {
            return this.dependencyChainB;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.dependencyChainA == null ? 0 : this.dependencyChainA.hashCode());
            result = 31 * result + (this.dependencyChainB == null ? 0 : this.dependencyChainB.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FeatureConflict other = (FeatureConflict)obj;
            if (this.dependencyChainA == null || other.dependencyChainA == null) {
                return this.dependencyChainA == other.dependencyChainA;
            }
            if (!this.dependencyChainA.containsAll(other.dependencyChainA) && !this.dependencyChainA.containsAll(other.dependencyChainB)) {
                return false;
            }
            if (this.dependencyChainB == null || other.dependencyChainB == null) {
                return this.dependencyChainB == other.dependencyChainB;
            }
            return this.dependencyChainB.containsAll(other.dependencyChainB) || this.dependencyChainB.containsAll(other.dependencyChainA);
        }

        public String toString() {
            return "DependencyChainA: " + this.dependencyChainA.toString() + "\n DependencyChainB: " + this.dependencyChainB.toString();
        }
    }

    public static class ResolverResult {
        private final Set<FeatureConflict> featureConflicts;
        private final Set<String> missingFeatures;
        private final Set<String> nonPublicFeatures;
        private final Set<String> resolvedFeatures;

        public ResolverResult(Set<FeatureConflict> featureConflicts, Set<String> missingFeatures, Set<String> nonPublicFeatures, Set<String> resolvedFeatures) {
            this.featureConflicts = featureConflicts;
            this.missingFeatures = missingFeatures;
            this.nonPublicFeatures = nonPublicFeatures;
            this.resolvedFeatures = resolvedFeatures;
        }

        public Set<FeatureConflict> getFeatureConflicts() {
            return this.featureConflicts;
        }

        public Set<String> getMissingFeatures() {
            return this.missingFeatures;
        }

        public Set<String> getNonPublicFeatures() {
            return this.nonPublicFeatures;
        }

        public Set<String> getResolvedFeatures() {
            return this.resolvedFeatures;
        }
    }
}

