/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageDetails;
import com.ibm.ws.report.binary.asm.utilities.ClassOrPackageOccurrence;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.RuleHelper;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DetectClass
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected String[] classNames = null;
    protected boolean useAppProvidedLibraries = false;
    protected boolean skipScanForUsage = false;
    protected String[] extendsClass = null;
    protected String[] implementsClass = null;
    protected String[] missingMethods = null;
    protected String[] missingMethodArgs = null;
    protected String[] implementsMethods = null;
    protected String[] implementsMethodArgs = null;
    protected String[] implementsMethodAccessFlags = null;
    protected String classNameRegex = null;
    protected boolean flagOnlyNonPublicImplementsMethod = false;

    public DetectClass(String ruleName, String desc, String[] classNames) {
        super(ruleName, desc, false);
        this.classNames = classNames;
    }

    public DetectClass(String ruleName, String desc, String[] classNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, boolean flagOnce, String[] extendsClass, String[] implementsClass, String[] missingMethods, String[] missingMethodArgs, String[] implementsMethods, String[] implementsMethodArgs) {
        this(ruleName, desc, classNames, useAppProvidedLibraries, skipScanForUsage, flagOnce, extendsClass, implementsClass, missingMethods, missingMethodArgs, implementsMethods, implementsMethodArgs, null);
    }

    public DetectClass(String ruleName, String desc, String[] classNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, boolean flagOnce, String[] extendsClass, String[] implementsClass, String[] missingMethods, String[] missingMethodArgs, String[] implementsMethods, String[] implementsMethodArgs, String classNameRegex) {
        this(ruleName, desc, classNames, useAppProvidedLibraries, skipScanForUsage, flagOnce ? DetectRule.FlagOnce.ARCHIVE : DetectRule.FlagOnce.NONE, false, extendsClass, implementsClass, missingMethods, missingMethodArgs, implementsMethods, implementsMethodArgs, classNameRegex, null);
    }

    public DetectClass(String ruleName, String desc, String[] classNames, boolean useAppProvidedLibraries, boolean skipScanForUsage, DetectRule.FlagOnce flagOnceType, boolean hideResult, String[] extendsClass, String[] implementsClass, String[] missingMethods, String[] missingMethodArgs, String[] implementsMethods, String[] implementsMethodArgs, String classNameRegex, String[] implementsMethodAccessFlags) {
        super(ruleName, desc, flagOnceType, hideResult);
        this.classNames = classNames;
        this.useAppProvidedLibraries = useAppProvidedLibraries;
        this.skipScanForUsage = skipScanForUsage;
        this.extendsClass = extendsClass;
        this.implementsClass = implementsClass;
        this.missingMethods = missingMethods;
        this.missingMethodArgs = missingMethodArgs;
        this.implementsMethods = implementsMethods;
        this.implementsMethodArgs = implementsMethodArgs;
        this.classNameRegex = classNameRegex;
        this.implementsMethodAccessFlags = implementsMethodAccessFlags;
    }

    @Override
    public String[] getClassNames() {
        if (this.classNames == null) {
            return new String[0];
        }
        return this.classNames;
    }

    @Override
    public String[] getMethodNames() {
        String[] returnMethods = null;
        if (this.missingMethods == null && this.implementsMethods == null) {
            return new String[0];
        }
        if (this.missingMethods == null) {
            return this.implementsMethods;
        }
        if (this.implementsMethods == null) {
            return this.missingMethods;
        }
        int size = this.missingMethods.length + this.implementsMethods.length;
        returnMethods = new String[size];
        int i = 0;
        while (i < this.missingMethods.length) {
            returnMethods[i] = this.missingMethods[i];
            ++i;
        }
        i = 0;
        while (i < this.implementsMethods.length) {
            returnMethods[this.missingMethods.length + i] = this.implementsMethods[i];
            ++i;
        }
        return returnMethods;
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        this.modulesFlagged.clear();
        this.filesFlagged.clear();
        if (this.skipScanForUsage) {
            boolean allClassesFound = true;
            String[] stringArray = this.classNames;
            int n = this.classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                if (!this.useAppProvidedLibraries || !store.containsImplementedClassName(className)) {
                    allClassesFound = false;
                    break;
                }
                this.detailResults.add(new DetailResult(this.ruleName, Messages.getString("Report_File_Name_Unavailable"), this.ruleDescription, className));
                ++n2;
            }
            if (!allClassesFound) {
                this.detailResults.clear();
            }
        } else if (!this.detailResults.isEmpty() && (this.useAppProvidedLibraries || this.flagOnce)) {
            ArrayList<DetailResult> newResults = new ArrayList<DetailResult>();
            ReportUtility.sortDetailResults(this.detailResults);
            if (this.useAppProvidedLibraries) {
                for (DetailResult result : this.detailResults) {
                    String criteria = result.getCriteria();
                    if (store.containsImplementedClassName(criteria) || !this.flag(result.getFileName())) continue;
                    if (this.flagOnce) {
                        result.setNumberOfOccurrences(1);
                    }
                    newResults.add(result);
                }
            } else if (this.flagOnce) {
                for (DetailResult result : this.detailResults) {
                    if (!this.flag(result.getFileName())) continue;
                    result.setNumberOfOccurrences(1);
                    newResults.add(result);
                }
            }
            return newResults;
        }
        return this.detailResults;
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        block39: {
            block40: {
                if (this.skipScanForUsage) break block39;
                if (!detectOnce) break block40;
                if (this.extendsClass != null) {
                    Set<String> keys = store.getClassDataStoreKeys();
                    for (String key : keys) {
                        ClassDataStore data = store.getClassDataStore(key);
                        if (!this.flagExtendsClass(data, key, detectOnce)) continue;
                        return;
                    }
                } else if (this.implementsClass != null) {
                    Set<String> keys = store.getClassDataStoreKeys();
                    for (String key : keys) {
                        ClassDataStore data = store.getClassDataStore(key);
                        if (!this.flagImplementsClass(data, key, detectOnce)) continue;
                        return;
                    }
                } else {
                    String[] data = this.classNames;
                    int n = this.classNames.length;
                    int key = 0;
                    while (key < n) {
                        String className = data[key];
                        if (store.containsClassName(className) && (!this.useAppProvidedLibraries || this.useAppProvidedLibraries && !store.containsImplementedClassName(className))) {
                            this.detailResults.add(new DetailResult(this.ruleName, Messages.getString("Report_File_Name_Unavailable"), this.ruleDescription, className));
                        }
                        ++key;
                    }
                }
                break block39;
            }
            Set<String> keys = store.getClassDataStoreKeys();
            if (keys.isEmpty()) break block39;
            for (String key : keys) {
                if (!this.shouldFlag(key)) continue;
                ClassDataStore data = store.getClassDataStore(key);
                if (this.extendsClass != null) {
                    if (!this.flagExtendsClass(data, key, detectOnce) || !this.flagOnce) continue;
                    return;
                }
                if (this.implementsClass != null) {
                    if (!this.flagImplementsClass(data, key, detectOnce) || !this.flagOnce) continue;
                    return;
                }
                String[] stringArray = this.classNames;
                int n = this.classNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String className = stringArray[n2];
                    if (data.containsClassName(className) && (!this.useAppProvidedLibraries || this.useAppProvidedLibraries && !store.containsImplementedClassName(className)) && this.includeInResults(data, key)) {
                        ClassOrPackageDetails cd = data.getClassDetails(className);
                        if (cd != null) {
                            Map<String, ClassOrPackageOccurrence> info = cd.getReferenceAndLineInfo();
                            Set<String> methodKeys = info.keySet();
                            ArrayList<String> sortedKeys = new ArrayList<String>(methodKeys);
                            Collections.sort(sortedKeys);
                            int numKeys = sortedKeys.size();
                            int i = 0;
                            while (i < numKeys) {
                                String methodKey;
                                String reference = methodKey = (String)sortedKeys.get(i);
                                if (methodKey.contains("<init>")) {
                                    reference = Messages.getString("Report_Reference_Constructor");
                                } else if (methodKey.contains("<clinit>")) {
                                    reference = Messages.getString("Report_Reference_Static_Initializer");
                                }
                                ClassOrPackageOccurrence copo = info.get(methodKey);
                                List<Integer> sortedLines = copo.getLineNumbers();
                                Collections.sort(sortedLines);
                                int numLines = sortedLines.size();
                                int numLineOccurrences = 0;
                                int lastLineNumber = 0;
                                boolean lastLineNumberSet = false;
                                int j = 0;
                                while (j < numLines) {
                                    Integer lineNumber = sortedLines.get(j);
                                    int thisLineNumber = lineNumber;
                                    if (lastLineNumberSet && thisLineNumber == lastLineNumber) {
                                        ++numLineOccurrences;
                                    } else if (lastLineNumberSet) {
                                        if (lastLineNumber == 0 && (copo.getReturnTypeOccurrences() > 0 || copo.getAnnotationOccurrences() > 0 || copo.getCatchExceptionOccurrences() > 0 || copo.getThrowsExceptionOccurrences() > 0 || copo.getParameterOccurrences() > 0)) {
                                            int numOccurrences;
                                            String desc;
                                            if (copo.getReturnTypeOccurrences() > 0) {
                                                desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(1));
                                                numOccurrences = copo.getReturnTypeOccurrences();
                                                this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, numOccurrences, desc, lastLineNumber));
                                            }
                                            if (copo.getAnnotationOccurrences() > 0) {
                                                desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(2));
                                                numOccurrences = copo.getAnnotationOccurrences();
                                                this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, numOccurrences, desc, lastLineNumber));
                                            }
                                            if (copo.getThrowsExceptionOccurrences() > 0) {
                                                desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(5));
                                                numOccurrences = copo.getThrowsExceptionOccurrences();
                                                this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, numOccurrences, desc, lastLineNumber));
                                            }
                                            if (copo.getCatchExceptionOccurrences() > 0) {
                                                desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(6));
                                                numOccurrences = copo.getCatchExceptionOccurrences();
                                                this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, numOccurrences, desc, lastLineNumber));
                                            }
                                            if (copo.getParameterOccurrences() > 0) {
                                                desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(3));
                                                numOccurrences = copo.getParameterOccurrences();
                                                this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, numOccurrences, desc, lastLineNumber));
                                            }
                                        } else {
                                            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, numLineOccurrences, reference, lastLineNumber));
                                        }
                                        lastLineNumber = thisLineNumber;
                                        numLineOccurrences = 1;
                                    } else {
                                        lastLineNumberSet = true;
                                        lastLineNumber = thisLineNumber;
                                        numLineOccurrences = 1;
                                    }
                                    ++j;
                                }
                                if (lastLineNumberSet) {
                                    if (lastLineNumber == 0 && (copo.getReturnTypeOccurrences() > 0 || copo.getAnnotationOccurrences() > 0 || copo.getCatchExceptionOccurrences() > 0 || copo.getThrowsExceptionOccurrences() > 0 || copo.getParameterOccurrences() > 0)) {
                                        if (copo.getReturnTypeOccurrences() > 0) {
                                            String desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(1));
                                            int numOccurrences = copo.getReturnTypeOccurrences();
                                            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, numOccurrences, desc, lastLineNumber));
                                        }
                                        if (copo.getAnnotationOccurrences() > 0) {
                                            String desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(2));
                                            int numOccurrences = copo.getAnnotationOccurrences();
                                            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, numOccurrences, desc, lastLineNumber));
                                        }
                                        if (copo.getThrowsExceptionOccurrences() > 0) {
                                            String desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(5));
                                            int numOccurrences = copo.getThrowsExceptionOccurrences();
                                            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, numOccurrences, desc, lastLineNumber));
                                        }
                                        if (copo.getCatchExceptionOccurrences() > 0) {
                                            String desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(6));
                                            int numOccurrences = copo.getCatchExceptionOccurrences();
                                            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, numOccurrences, desc, lastLineNumber));
                                        }
                                        if (copo.getParameterOccurrences() > 0) {
                                            String desc = Messages.getFormattedMessage(Messages.getString("Report_File_Name_Plus_Description"), reference, ClassOrPackageDetails.getTypeDescription(3));
                                            int numOccurrences = copo.getParameterOccurrences();
                                            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, numOccurrences, desc, lastLineNumber));
                                        }
                                    } else {
                                        this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className, numLineOccurrences, reference, lastLineNumber));
                                    }
                                }
                                ++i;
                            }
                        } else {
                            this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, className));
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    protected boolean includeInResults(ClassDataStore data, String filename) {
        return true;
    }

    protected boolean flagExtendsClass(ClassDataStore data, String fileName, boolean detectOnce) {
        boolean flag = false;
        if (this.classNameRegex == null || this.classNameRegex != null && data.getClassNameWithContext().matches(this.classNameRegex)) {
            String[] stringArray = this.extendsClass;
            int n = this.extendsClass.length;
            int n2 = 0;
            while (n2 < n) {
                String thisClass = stringArray[n2];
                if (data.doesClassExtend(thisClass)) {
                    if (this.missingMethods != null && this.missingMethods.length > 0 || this.implementsMethods != null && this.implementsMethods.length > 0) {
                        return this.flagMissingMethods(data, thisClass, fileName, Messages.getString("Report_Reference_Class_Extends"), detectOnce) || this.flagImplementsMethods(data, thisClass, fileName, Messages.getString("Report_Reference_Class_Extends"), detectOnce);
                    }
                    if (this.includeInResults(data, fileName)) {
                        if (this.flag(fileName)) {
                            this.detailResults.add(new DetailResult(this.ruleName, fileName, this.ruleDescription, thisClass, 1, Messages.getString("Report_Reference_Class_Extends"), 0));
                        }
                        return true;
                    }
                }
                ++n2;
            }
        }
        return flag;
    }

    protected boolean flagImplementsClass(ClassDataStore data, String fileName, boolean detectOnce) {
        boolean flag = false;
        if (this.classNameRegex == null || this.classNameRegex != null && data.getClassNameWithContext().matches(this.classNameRegex)) {
            String[] stringArray = this.implementsClass;
            int n = this.implementsClass.length;
            int n2 = 0;
            while (n2 < n) {
                String thisClass = stringArray[n2];
                if (data.doesClassImplement(thisClass)) {
                    if (this.missingMethods != null && this.missingMethods.length > 0 || this.implementsMethods != null && this.implementsMethods.length > 0) {
                        boolean bl = flag = this.flagMissingMethods(data, thisClass, fileName, Messages.getString("Report_Reference_Class_Implements"), detectOnce) || this.flagImplementsMethods(data, thisClass, fileName, Messages.getString("Report_Reference_Class_Implements"), detectOnce) || flag;
                        if (flag && (detectOnce || this.flagOnce)) {
                            return flag;
                        }
                    } else if (this.includeInResults(data, fileName)) {
                        if (this.flag(fileName)) {
                            this.detailResults.add(new DetailResult(this.ruleName, fileName, this.ruleDescription, thisClass, 1, Messages.getString("Report_Reference_Class_Implements"), 0));
                        }
                        flag = true;
                        if (detectOnce || this.flagOnce) {
                            return flag;
                        }
                    }
                }
                ++n2;
            }
        }
        return flag;
    }

    protected boolean flagMissingMethods(ClassDataStore data, String thisClass, String fileName, String reference, boolean detectOnce) {
        boolean flag = false;
        if (this.missingMethods != null && this.missingMethods.length > 0) {
            int numMissingMethods = this.missingMethods.length;
            int i = 0;
            while (i < numMissingMethods) {
                String methodName = this.missingMethods[i];
                String methodArgs = this.missingMethodArgs[i];
                if (!data.doesClassImplementMethod(methodName, RuleHelper.splitArgs(methodArgs)) && this.includeInResults(data, fileName)) {
                    flag = true;
                    String args = methodArgs == null ? "*" : methodArgs;
                    String matchCriteria = Messages.getFormattedMessage(Messages.getString("Report_Criteria_Missing_Method"), thisClass, methodName, args);
                    if (detectOnce) {
                        this.detailResults.add(new DetailResult(this.ruleName, fileName, this.ruleDescription, matchCriteria));
                        break;
                    }
                    if (!this.flag(fileName)) break;
                    this.detailResults.add(new DetailResult(this.ruleName, fileName, this.ruleDescription, matchCriteria, 1, reference, 0));
                    break;
                }
                ++i;
            }
        }
        return flag;
    }

    protected boolean flagImplementsMethods(ClassDataStore data, String thisClass, String fileName, String reference, boolean detectOnce) {
        boolean flag = false;
        if (this.implementsMethods != null && this.implementsMethods.length > 0) {
            int numMethods = this.implementsMethods.length;
            int i = 0;
            while (i < numMethods) {
                String methodName = this.implementsMethods[i];
                String methodArgs = null;
                String methodAccessFlag = null;
                if (this.implementsMethodArgs != null) {
                    methodArgs = this.implementsMethodArgs[i];
                }
                if (this.implementsMethodAccessFlags != null) {
                    methodAccessFlag = this.implementsMethodAccessFlags[i];
                }
                if (data.doesClassImplementMethod(methodName, RuleHelper.splitArgs(methodArgs), methodAccessFlag) && this.includeInResults(data, fileName)) {
                    flag = true;
                    String args = methodArgs == null ? "" : methodArgs;
                    String matchCriteria = Messages.getFormattedMessage(Messages.getString("Report_Criteria_Implements_Method"), thisClass, methodName, args);
                    if (detectOnce) {
                        this.detailResults.add(new DetailResult(this.ruleName, fileName, this.ruleDescription, matchCriteria));
                        return flag;
                    }
                    if (this.flag(fileName)) {
                        this.detailResults.add(new DetailResult(this.ruleName, fileName, this.ruleDescription, matchCriteria, 1, reference, 0));
                        if (this.flagOnce) {
                            return true;
                        }
                    }
                }
                ++i;
            }
        }
        return flag;
    }
}

