/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules;

import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectMultipleCriteria;
import com.ibm.ws.report.binary.rules.DetectPackage;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.Rule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.JakartaJavaEEFeatureVersions;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class DetectFeature
extends DetectRule {
    protected EnumSet<RuleType> _ruleType = EnumSet.noneOf(RuleType.class);
    protected String _featureName = null;
    protected Rule _implProvidedRuleJavax = null;
    protected Rule _implProvidedRuleJakarta = null;
    protected Map<String, List<Rule>> _usageRules = null;

    public DetectFeature(String ruleName, String desc, Rule detectJavaxImplProvided, Rule detectJakartaImplProvided, Map<String, List<Rule>> detectUsage) {
        super(ruleName, desc, false);
        this._featureName = desc;
        this._implProvidedRuleJavax = detectJavaxImplProvided;
        this._implProvidedRuleJakarta = detectJakartaImplProvided;
        if (this._implProvidedRuleJavax != null) {
            this._ruleType.addAll(this._implProvidedRuleJavax.getRuleTypes());
        }
        if (this._implProvidedRuleJakarta != null) {
            this._ruleType.addAll(this._implProvidedRuleJakarta.getRuleTypes());
        }
        if (!detectUsage.isEmpty()) {
            this._usageRules = detectUsage;
            Set<String> keys = detectUsage.keySet();
            for (String key : keys) {
                List<Rule> usageRules = detectUsage.get(key);
                for (Rule nextRule : usageRules) {
                    this._ruleType.addAll(nextRule.getRuleTypes());
                }
            }
        }
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return this._ruleType;
    }

    public Map<String, List<Rule>> getUsageRules() {
        return this._usageRules;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        if (this._implProvidedRuleJavax != null) {
            this._implProvidedRuleJavax.clearResults();
        }
        if (this._implProvidedRuleJakarta != null) {
            this._implProvidedRuleJakarta.clearResults();
        }
        Set<String> keys = this._usageRules.keySet();
        for (String key : keys) {
            List<Rule> usageRules = this._usageRules.get(key);
            for (Rule nextRule : usageRules) {
                nextRule.clearResults();
            }
        }
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        List<DetailResult> jakartaResults;
        List<DetailResult> javaxResults = this._implProvidedRuleJavax == null ? null : this._implProvidedRuleJavax.getResults(store);
        List<DetailResult> list = jakartaResults = this._implProvidedRuleJakarta == null ? null : this._implProvidedRuleJakarta.getResults(store);
        if (javaxResults != null && !javaxResults.isEmpty() && jakartaResults != null && !jakartaResults.isEmpty()) {
            ArrayList<DetailResult> resultCollection = new ArrayList<DetailResult>();
            resultCollection.addAll(javaxResults);
            resultCollection.addAll(jakartaResults);
            this.processImplProvidedResults(resultCollection, store);
        } else {
            boolean javaEEProvided = false;
            boolean jakartaEEProvided = false;
            if (javaxResults != null && !javaxResults.isEmpty()) {
                this.processImplProvidedResults(javaxResults, store);
                javaEEProvided = true;
            } else if (jakartaResults != null && !jakartaResults.isEmpty()) {
                this.processImplProvidedResults(jakartaResults, store);
                jakartaEEProvided = true;
            }
            ArrayList<DetailResult> tempResults = new ArrayList<DetailResult>();
            ArrayList<Rule> packagesToRemove = new ArrayList<Rule>();
            Set<String> features = this._usageRules.keySet();
            for (String featureName : features) {
                List<Rule> usageRules = this._usageRules.get(featureName);
                for (Rule nextRule : usageRules) {
                    List<DetailResult> usageResults = nextRule.getResults(store);
                    if (!usageResults.isEmpty()) {
                        if (ReportUtility.isDebug()) {
                            ReportUtility.logger.get().log(Level.FINEST, "DetectFeature: the following result is the first usage result detected for the " + nextRule.getRuleName() + " rule: " + usageResults.get(0));
                        }
                        if (DetectFeature.containsEEFeature(featureName, true) && javaEEProvided) {
                            ReportUtility.logger.get().log(Level.FINEST, "The result for " + nextRule.getRuleName() + " will not be added because a Java EE impl was provided.");
                        } else if (DetectFeature.containsEEFeature(featureName, false) && jakartaEEProvided) {
                            ReportUtility.logger.get().log(Level.FINEST, "The result for " + nextRule.getRuleName() + " will not be added because a Jakarta EE impl was provided.");
                        } else {
                            tempResults.add(new DetailResult(this.ruleName, Messages.getString("Report_File_Name_Unavailable"), this.ruleDescription, featureName));
                        }
                    }
                    if (nextRule instanceof DetectPackage) {
                        packagesToRemove.add(nextRule);
                        continue;
                    }
                    if (!(nextRule instanceof DetectMultipleCriteria)) continue;
                    for (Rule nextRuleInMultipleCriteria : ((DetectMultipleCriteria)nextRule).getRules()) {
                        if (!(nextRuleInMultipleCriteria instanceof DetectPackage)) continue;
                        packagesToRemove.add(nextRuleInMultipleCriteria);
                    }
                }
            }
            for (Rule rule : packagesToRemove) {
                this.removePackageReferences(store, (DetectPackage)rule);
            }
            if (!tempResults.isEmpty()) {
                DetailResult firstResult = (DetailResult)tempResults.get(0);
                if (tempResults.size() > 1) {
                    this.detailResults = this.getUniqueFeatures(tempResults);
                } else {
                    this.detailResults.add(firstResult);
                }
            }
        }
        if (ReportUtility.isDebug() && !this.detailResults.isEmpty()) {
            for (DetailResult result : this.detailResults) {
                ReportUtility.logger.get().log(Level.FINEST, "DetectFeature: adding the following final feature result " + result);
            }
        }
        return this.detailResults;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean containsEEFeature(String featureName, boolean javaEE) {
        featureNames = null;
        featureNames = featureName.contains(",") != false ? featureName.split(",") : new String[]{featureName};
        i = 0;
        while (i < featureNames.length) {
            block13: {
                block12: {
                    block11: {
                        feature = featureNames[i];
                        featurePrefix = "";
                        featurePrefix = feature.contains("-") != false ? feature.split("-")[0] : feature;
                        if (!javaEE) break block11;
                        if (JakartaJavaEEFeatureVersions.JAVAEE_PREFIXES_TO_JAKARTA_PREFIXES.containsKey(featurePrefix)) {
                            return true;
                        }
                        if (!JakartaJavaEEFeatureVersions.JAKARTA_PREFIXES_TO_JAVAEE_PREFIXES.containsKey(featurePrefix)) break block12;
                        break block13;
                    }
                    if (!JakartaJavaEEFeatureVersions.JAVAEE_PREFIXES_TO_JAKARTA_PREFIXES.containsKey(featurePrefix)) {
                        if (JakartaJavaEEFeatureVersions.JAKARTA_PREFIXES_TO_JAVAEE_PREFIXES.containsKey(featurePrefix)) {
                            return true;
                        } else {
                            ** GOTO lbl18
                        }
                    }
                    break block13;
                }
                if (!feature.contains("-")) {
                    return true;
                }
                latestJavaEEFeature = JakartaJavaEEFeatureVersions.LATEST_NON_JAKARTA_FEATURE_VERSIONS.get(featurePrefix);
                if (latestJavaEEFeature != null) {
                    block10: {
                        version = feature.split("-")[1];
                        latestJavaEEVersion = latestJavaEEFeature.split("-")[1];
                        v = Double.valueOf(version);
                        latestJavaEEv = Double.valueOf(latestJavaEEVersion);
                        if (!(v <= latestJavaEEv) || !javaEE) break block10;
                        return true;
                    }
                    try {
                        if (v > latestJavaEEv && !javaEE) {
                            return true;
                        }
                    }
                    catch (Exception ex) {
                        ReportUtility.logger.get().log(Level.FINE, "Error parsing feature version in DetectFeature. Version: " + version + ", latest version: " + latestJavaEEVersion + ". Exception: " + ex);
                    }
                }
            }
            ++i;
        }
        return false;
    }

    private void processImplProvidedResults(List<DetailResult> results, SimpleDataStore store) {
        if (ReportUtility.isDebug()) {
            ReportUtility.logger.get().log(Level.FINEST, "DetectFeature: the following are features with implementations provided results");
            for (DetailResult result : results) {
                ReportUtility.logger.get().log(Level.FINEST, "DetectFeature: implementations provided results feature " + result);
            }
        }
        for (DetailResult nextResult : results) {
            String packageName = nextResult.getCriteria();
            store.removeReferencedPackageName(packageName);
        }
        Set<String> keys = this._usageRules.keySet();
        for (String key : keys) {
            List<Rule> usageRules = this._usageRules.get(key);
            for (Rule nextRule : usageRules) {
                if (!(nextRule instanceof DetectPackage)) continue;
                this.removePackageReferences(store, (DetectPackage)nextRule);
            }
        }
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce, RuleType type) {
        if (this._implProvidedRuleJavax != null && type == RuleType.JavaRule) {
            this._implProvidedRuleJavax.analyze(store, detectOnce, type);
        }
        if (this._implProvidedRuleJakarta != null && type == RuleType.JavaRule) {
            this._implProvidedRuleJakarta.analyze(store, detectOnce, type);
        }
        Set<String> keys = this._usageRules.keySet();
        for (String key : keys) {
            List<Rule> usageRules = this._usageRules.get(key);
            for (Rule nextRule : usageRules) {
                if (type != null && !nextRule.getRuleTypes().contains((Object)type)) continue;
                try {
                    nextRule.analyze(store, detectOnce);
                }
                catch (Exception e) {
                    if (ReportUtility.isDebug()) {
                        ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Processing_Rule_Log"), nextRule.getRuleDescription()), e);
                        continue;
                    }
                    ReportUtility.logger.get().log(Level.SEVERE, Messages.getFormattedMessage(Messages.getString("BinaryReportReader_Error_Processing_Rule"), nextRule.getRuleDescription(), e.toString()));
                }
            }
        }
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this.analyze(store, detectOnce, null);
    }

    protected void removePackageReferences(SimpleDataStore store, DetectPackage packageRule) {
        this.removePackageReferences(store, packageRule, true, true);
    }

    protected void removePackageReferences(SimpleDataStore store, DetectPackage packageRule, boolean removeJavaxPackages, boolean removeJakartaPackages) {
        String[] packages;
        String[] stringArray = packages = packageRule.getPackageNames();
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String nextPackage = stringArray[n2];
            if (nextPackage.startsWith("javax")) {
                if (removeJavaxPackages) {
                    store.removeReferencedPackageName(nextPackage);
                }
            } else if (nextPackage.startsWith("jakarta")) {
                if (removeJakartaPackages) {
                    store.removeReferencedPackageName(nextPackage);
                }
            } else {
                store.removeReferencedPackageName(nextPackage);
            }
            ++n2;
        }
    }

    @Override
    public String[] getFileNames() {
        HashSet<String> allFileNames = new HashSet<String>();
        Set<String> keys = this._usageRules.keySet();
        for (String key : keys) {
            List<Rule> usageRules = this._usageRules.get(key);
            for (Rule nextRule : usageRules) {
                String[] fileNames;
                if (!nextRule.getRuleTypes().contains((Object)RuleType.XmlRule)) continue;
                if (nextRule instanceof DetectMultipleCriteria) {
                    for (Rule innerRule : ((DetectMultipleCriteria)nextRule).getRules()) {
                        String[] fileNames2;
                        String[] stringArray = fileNames2 = innerRule.getFileNames();
                        int n = fileNames2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String fileName = stringArray[n2];
                            allFileNames.add(fileName);
                            ++n2;
                        }
                    }
                    continue;
                }
                String[] stringArray = fileNames = nextRule.getFileNames();
                int n = fileNames.length;
                int n3 = 0;
                while (n3 < n) {
                    String fileName = stringArray[n3];
                    allFileNames.add(fileName);
                    ++n3;
                }
            }
        }
        String[] xmlFiles = allFileNames.toArray(new String[allFileNames.size()]);
        return xmlFiles;
    }

    @Override
    public String[] getClassNames() {
        HashSet<String> allFileNames = new HashSet<String>();
        Set<String> keys = this._usageRules.keySet();
        for (String key : keys) {
            List<Rule> usageRules = this._usageRules.get(key);
            for (Rule nextRule : usageRules) {
                String[] fileNames;
                if (!nextRule.getRuleTypes().contains((Object)RuleType.JavaRule)) continue;
                if (nextRule instanceof DetectMultipleCriteria) {
                    for (Rule innerRule : ((DetectMultipleCriteria)nextRule).getRules()) {
                        String[] fileNames2;
                        String[] stringArray = fileNames2 = innerRule.getClassNames();
                        int n = fileNames2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String fileName = stringArray[n2];
                            allFileNames.add(fileName);
                            ++n2;
                        }
                    }
                    continue;
                }
                String[] stringArray = fileNames = nextRule.getClassNames();
                int n = fileNames.length;
                int n3 = 0;
                while (n3 < n) {
                    String fileName = stringArray[n3];
                    allFileNames.add(fileName);
                    ++n3;
                }
            }
        }
        String[] classNames = allFileNames.toArray(new String[allFileNames.size()]);
        return classNames;
    }

    private List<DetailResult> getUniqueFeatures(List<DetailResult> results) {
        Iterator<DetailResult> it = results.iterator();
        HashMap<String, DetailResult> uniqueFeatures = new HashMap<String, DetailResult>();
        new HashSet();
        while (it.hasNext()) {
            DetailResult nextResult = it.next();
            String resultFeatureName = nextResult.getCriteria();
            if (!uniqueFeatures.isEmpty()) {
                String prefix;
                int indexOfDash = resultFeatureName.indexOf(45);
                if (indexOfDash != -1 && uniqueFeatures.containsKey(prefix = resultFeatureName.substring(0, indexOfDash))) {
                    uniqueFeatures.remove(prefix);
                    uniqueFeatures.put(resultFeatureName, nextResult);
                    continue;
                }
                Set uniqueKeySet = uniqueFeatures.keySet();
                boolean featureIsSubset = false;
                for (String feature : uniqueKeySet) {
                    if (!feature.startsWith(String.valueOf(resultFeatureName) + "-")) continue;
                    featureIsSubset = true;
                }
                if (featureIsSubset) continue;
                uniqueFeatures.put(resultFeatureName, nextResult);
                continue;
            }
            uniqueFeatures.put(resultFeatureName, nextResult);
        }
        ArrayList<DetailResult> uniqueResults = new ArrayList<DetailResult>(uniqueFeatures.values());
        return uniqueResults;
    }
}

