/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.DetectMethod;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DetectFinalizeMethod
extends DetectMethod {
    protected static final String[] _methodNames = new String[]{"finalize"};
    protected static final String[] _owner = new String[]{"*"};
    DetectClass detectExtendedClassesOfInterest = null;
    Set<String> classesOfInterest = new HashSet<String>();

    public DetectFinalizeMethod(String ruleName, String desc, String[] interestedExtendedClasses) {
        this(ruleName, desc, _methodNames, _owner, interestedExtendedClasses);
    }

    public DetectFinalizeMethod(String ruleName, String desc, String[] methodNames, String[] owners, String[] interestedExtendedClasses) {
        super(ruleName, desc, methodNames, owners, null, null, null, false, null, null, null);
        this.detectExtendedClassesOfInterest = new DetectClass(ruleName, desc, null, false, false, false, interestedExtendedClasses, null, null, null, null, null){

            @Override
            protected boolean includeInResults(ClassDataStore data, String filename) {
                DetectFinalizeMethod.this.classesOfInterest.add(data.getClassName());
                return false;
            }
        };
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this.detectExtendedClassesOfInterest.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        HashSet<String> flaggedCode = new HashSet<String>();
        List<DetailResult> parentResults = super.getResults(store);
        ArrayList<DetailResult> results = new ArrayList<DetailResult>();
        for (DetailResult result : parentResults) {
            String fileName = result.getFileName();
            String signature = String.valueOf(fileName) + "-" + result.getLineNumber();
            String owner = ReportUtility.getQualifiedClassName(fileName);
            if (flaggedCode.contains(signature) || !this.classesOfInterest.contains(owner)) continue;
            results.add(result);
            flaggedCode.add(signature);
        }
        return results;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.classesOfInterest.clear();
    }
}

