/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DetectJAXRPCCalendar
extends DetectElement {
    protected static String RULE_NAME = "DetectJAXRPCCalendar";
    protected static String RULE_DESC = "com.ibm.ws.report.binary.java.DetectJAXRPCCalendar";
    protected static final String[] fileNames = new String[]{"WEB-INF/webservices.xml", "WEB-INF/web.xml", "META-INF/webservices.xml", "META-INF/web.xml"};
    protected static final String[] allXmlNames = new String[]{".xml"};
    protected static final String JAXRPC_MAPPING_FILE = "jaxrpc-mapping-file";
    protected static final String ROOT_TYPE_QNAME = "root-type-qname";
    protected static final String[] calendarTagValues = new String[]{".*:duration", ".*:dateTime", ".*:time", ".*:date", ".*:gYearMonth", ".*:gYear", ".*:gMonth", ".*:gDay"};
    protected DetectElement _detectJaxrpcElement = null;
    protected Set<String> listOfMappingFiles = new HashSet<String>();

    public DetectJAXRPCCalendar() {
        this(RULE_NAME, RULE_DESC, ROOT_TYPE_QNAME, allXmlNames, calendarTagValues, null, false, null, null, null, false);
    }

    public DetectJAXRPCCalendar(String ruleName, String desc, String tag, String[] fileNames, String[] values, String namespace, boolean flagOnce, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty) {
        super(ruleName, desc, tag, fileNames, values, namespace, flagOnce, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty);
        this._detectJaxrpcElement = new DetectElement(ruleName, desc, JAXRPC_MAPPING_FILE, fileNames, null, null, false, null, null, null, false){

            @Override
            protected boolean includeInResults(Node node, String fileName, XMLResource resource) {
                Node parent = node.getParentNode();
                List<Element> children = XMLRuleUtil.getChildElements((Element)parent, "*", DetectJAXRPCCalendar.JAXRPC_MAPPING_FILE);
                if (children != null && children.size() > 0) {
                    for (Element el : children) {
                        String value = XMLRuleUtil.getTextWithoutWhitespace(el);
                        if (value == null) continue;
                        DetectJAXRPCCalendar.this.listOfMappingFiles.add(value);
                    }
                }
                return false;
            }
        };
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._detectJaxrpcElement.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> calendarResults = new ArrayList<DetailResult>();
        List<DetailResult> results = super.getResults(store);
        if (!results.isEmpty()) {
            for (DetailResult dr : results) {
                String calendarFile = dr.getFileName();
                for (String mappingFileName : this.listOfMappingFiles) {
                    if (!calendarFile.endsWith(mappingFileName)) continue;
                    calendarResults.add(dr);
                }
            }
        }
        return calendarResults;
    }
}

