/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DetectJndiLookupElement
extends DetectElement {
    protected static final String RULE_NAME = "DetectJndiLookupElements";
    protected static final String RULE_DESC = "appconversion.framework.spring.xml.jndiLookupElement";
    protected static final String JNDI_LOOKUP_ELEMENT = "jndi-lookup";
    protected static final String PROXY_INTERFACE_ATTRIBUTE = "proxy-interface";
    protected static final String PROXY_INTERFACE_ATTRIBUTE_VALUE = "javax.sql.DataSource";
    protected static final String JNDI_NAME_ATTRIBUTE = "jndi-name";
    protected static final String JNDI_LOOKUP_PREFIX = "java:comp/env/";
    protected static final String RES_REF_NAME_ATTRIBUTE = "res-ref-name";
    protected static final String WEB_PROJECT_REGEX = ".*\\.war/.*";
    protected static final String[] fileNames = new String[]{".xml"};
    protected static final String[] webXMLFile = new String[]{"/web.xml"};
    protected static final String namespace = "*";
    protected static final String[] tags = new String[]{"jndi-lookup"};
    protected static DetectElement _resRefNameValue;
    protected Map<String, Set<String>> mapOfFilenameToResRefNames = new HashMap<String, Set<String>>();
    protected Map<String, DetailResult> jndiNameToResultMap = new HashMap<String, DetailResult>();

    public DetectJndiLookupElement() {
        this(RULE_NAME, RULE_DESC, tags, fileNames, DetectRule.XMLFileType.SPRING, false, null, namespace, DetectRule.FlagOnce.NONE, null, null, null, false, null, null, null, false, null, false);
    }

    public DetectJndiLookupElement(String ruleName, String desc, String[] tags, String[] fileNames, DetectRule.XMLFileType xmlFileType, boolean flagRootNode, String value, String namespace, DetectRule.FlagOnce flagOnceType, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty, String missingChildElementAttribute, String missingChildElementAttributeValue, String validateNamespace, boolean onlyValidateDocumentNamespaceIfPresent, String[] parentTags, boolean flagDuplicate) {
        super(ruleName, desc, tags, fileNames, xmlFileType, flagRootNode, value, namespace, flagOnceType, false, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty, missingChildElementAttribute, missingChildElementAttributeValue, validateNamespace, onlyValidateDocumentNamespaceIfPresent, parentTags, flagDuplicate);
        _resRefNameValue = new DetectElement(RULE_NAME, RULE_DESC, new String[]{RES_REF_NAME_ATTRIBUTE}, webXMLFile, DetectRule.XMLFileType.ALL, false, null, namespace, DetectRule.FlagOnce.NONE, false, null, null, null, false, null, null, null, false, null, false){

            @Override
            protected boolean includeInResults(Node result, String key, XMLResource resource) {
                String resultTextContent = XMLRuleUtil.getTextWithoutWhitespace(result);
                if (!resultTextContent.startsWith(DetectJndiLookupElement.JNDI_LOOKUP_PREFIX)) {
                    String filePath = ReportUtility.getLastArchiveFileName(key);
                    Set<String> resRefNamesFound = DetectJndiLookupElement.this.mapOfFilenameToResRefNames.get(filePath);
                    if (resRefNamesFound == null) {
                        resRefNamesFound = new HashSet<String>();
                        DetectJndiLookupElement.this.mapOfFilenameToResRefNames.put(filePath, resRefNamesFound);
                    }
                    resRefNamesFound.add(resultTextContent);
                }
                return false;
            }
        };
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.jndiNameToResultMap.clear();
        this.mapOfFilenameToResRefNames.clear();
        _resRefNameValue.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        _resRefNameValue.analyze(store, detectOnce);
    }

    @Override
    protected boolean includeInResults(Node result, String key, XMLResource resource) {
        NamedNodeMap resultMap;
        String jndiNameValue;
        if (key.matches(WEB_PROJECT_REGEX) && (jndiNameValue = XMLRuleUtil.getAttributeValue(resultMap = result.getAttributes(), namespace, JNDI_NAME_ATTRIBUTE)) != null && !jndiNameValue.isEmpty()) {
            String proxyInterfaceValue;
            if (jndiNameValue.startsWith(JNDI_LOOKUP_PREFIX)) {
                this.createResultandAddToMap(result, key, resource, jndiNameValue);
            } else if (!(jndiNameValue.contains("$") && jndiNameValue.contains("{") || (proxyInterfaceValue = XMLRuleUtil.getAttributeValue(resultMap, namespace, PROXY_INTERFACE_ATTRIBUTE)) == null || !proxyInterfaceValue.equals(PROXY_INTERFACE_ATTRIBUTE_VALUE))) {
                this.createResultandAddToMap(result, key, resource, jndiNameValue);
            }
        }
        return false;
    }

    private void createResultandAddToMap(Node result, String key, XMLResource resource, String jndiNameValue) {
        DetailResult dr = new DetailResult(this.ruleName, key, this.ruleDescription, result.getLocalName(), 1, null, resource.getNodeLineNumber(result));
        this.jndiNameToResultMap.put(jndiNameValue, dr);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> returnedResults = new ArrayList<DetailResult>();
        Iterator<Map.Entry<String, DetailResult>> itr = this.jndiNameToResultMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, DetailResult> mapEntry = itr.next();
            String archiveNameOfResult = ReportUtility.getLastArchiveFileName(mapEntry.getValue().getFileName());
            String mapEntryKey = mapEntry.getKey();
            Set<String> resRefNamesForArchive = this.mapOfFilenameToResRefNames.get(archiveNameOfResult);
            if (!this.mapOfFilenameToResRefNames.containsKey(archiveNameOfResult) || resRefNamesForArchive == null || resRefNamesForArchive.isEmpty() || !resRefNamesForArchive.contains(mapEntryKey)) continue;
            resRefNamesForArchive.remove(mapEntryKey);
            itr.remove();
        }
        returnedResults.addAll(this.jndiNameToResultMap.values());
        return returnedResults;
    }
}

