/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.utilities.XMLResource;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DetectJndiLookupElementNoQuickFix
extends DetectElement {
    protected static final String RULE_NAME = "DetectJndiLookupElementNoQuickFix";
    protected static final String RULE_DESC = "appconversion.framework.spring.xml.jndiLookupElementNoQuickFix";
    protected static final String JNDI_LOOKUP_ELEMENT = "jndi-lookup";
    protected static final String PROXY_INTERFACE_ATTRIBUTE = "proxy-interface";
    protected static final String PROXY_INTERFACE_ATTRIBUTE_VALUE = "javax.sql.DataSource";
    protected static final String JNDI_NAME_ATTRIBUTE = "jndi-name";
    protected static final String JNDI_NAME_VARIABLE_VALUE_REGEX = "(.*(\\$|\\{).*|\\s*)";
    protected static final String WEB_PROJECT_REGEX = ".*\\.war/.*";
    protected static final String[] fileNames = new String[]{".xml"};
    protected static final String namespace = "*";
    protected static final String[] tags = new String[]{"jndi-lookup"};

    public DetectJndiLookupElementNoQuickFix() {
        this(RULE_NAME, RULE_DESC, tags, fileNames, DetectRule.XMLFileType.SPRING, false, null, namespace, DetectRule.FlagOnce.NONE, null, null, null, false, null, null, null, false, null, false);
    }

    public DetectJndiLookupElementNoQuickFix(String ruleName, String desc, String[] tags, String[] fileNames, DetectRule.XMLFileType xmlFileType, boolean flagRootNode, String value, String namespace, DetectRule.FlagOnce flagOnceType, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty, String missingChildElementAttribute, String missingChildElementAttributeValue, String validateNamespace, boolean onlyValidateDocumentNamespaceIfPresent, String[] parentTags, boolean flagDuplicate) {
        super(ruleName, desc, tags, fileNames, xmlFileType, flagRootNode, value, namespace, flagOnceType, false, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty, missingChildElementAttribute, missingChildElementAttributeValue, validateNamespace, onlyValidateDocumentNamespaceIfPresent, parentTags, flagDuplicate);
    }

    @Override
    protected boolean includeInResults(Node result, String key, XMLResource resource) {
        if (key.matches(WEB_PROJECT_REGEX)) {
            NamedNodeMap resultMap = result.getAttributes();
            Node jndiNameNode = resultMap.getNamedItem(JNDI_NAME_ATTRIBUTE);
            if (jndiNameNode == null || jndiNameNode.getNodeValue() == null || jndiNameNode.getNodeValue().matches(JNDI_NAME_VARIABLE_VALUE_REGEX)) {
                return true;
            }
            Node proxyInterfaceNode = resultMap.getNamedItem(PROXY_INTERFACE_ATTRIBUTE);
            return proxyInterfaceNode == null || proxyInterfaceNode.getNodeValue() == null || !proxyInterfaceNode.getNodeValue().trim().equals(PROXY_INTERFACE_ATTRIBUTE_VALUE);
        }
        return true;
    }
}

