/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.AnnotationDetails;
import com.ibm.ws.report.binary.asm.utilities.AnnotationInfo;
import com.ibm.ws.report.binary.asm.utilities.ClassDataStore;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectAnnotation;
import com.ibm.ws.report.binary.rules.DetectClass;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocalAnnoCheck
extends DetectAnnotation {
    protected static final String regex = "(javax\\.ws\\.rs\\.ext\\.)?(MessageBodyReader|MessageBodyWriter|ExceptionMapper|ContextResolver)";
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected static final String RULE_NAME = "LocalAnnoCheck";
    protected static final String RULE_DESC = "appconversion.javaee7.jaxrs.LocalAnnoCheck";
    protected Map<String, List<String>> valuesThatAreNotImplementedMap = new HashMap<String, List<String>>();
    protected static final String[] classNames = new String[]{"javax.ejb.Local"};
    protected static final String[] extendsClasses = new String[]{"javax.ws.rs.ext.MessageBodyReader", "javax.ws.rs.ext.MessageBodyWriter", "javax.ws.rs.ext.ExceptionMapper", "javax.ws.rs.ext.ContextResolver"};
    protected DetectClass _classesExtendingPOJOInterface = null;
    protected Set<String> qualifiedNameOfClassesExtendingPOJOInterfaceSet = new HashSet<String>();

    public LocalAnnoCheck() {
        this(RULE_NAME, RULE_DESC, classNames, null, null, null, null, null, false, "class", null, null);
    }

    public LocalAnnoCheck(String ruleName, String desc, String[] classNames, String attributeName, String attributeType, String[] attributeValues, String defaultValue, String accessFlag, boolean flagOnce, String location, String defaultName, String missingAttributeName) {
        super(ruleName, desc, classNames, attributeName, attributeType, attributeValues, defaultValue, accessFlag, flagOnce, location, defaultName, missingAttributeName);
        this._classesExtendingPOJOInterface = new DetectClass(RULE_NAME, RULE_DESC, null, false, false, false, extendsClasses, null, null, null, null, null){

            @Override
            protected boolean flagExtendsClass(ClassDataStore data, String fileName, boolean detectOnce) {
                if (super.flagExtendsClass(data, fileName, detectOnce)) {
                    LocalAnnoCheck.this.qualifiedNameOfClassesExtendingPOJOInterfaceSet.add(data.getClassName());
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._classesExtendingPOJOInterface.clearResults();
        this.qualifiedNameOfClassesExtendingPOJOInterfaceSet.clear();
        this.valuesThatAreNotImplementedMap.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._classesExtendingPOJOInterface.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResultsList = new ArrayList<DetailResult>();
        List<DetailResult> parentResultsList = super.getResults(store);
        if (!parentResultsList.isEmpty()) {
            block0: for (DetailResult nextResult : parentResultsList) {
                List<String> unImplementedClassValues = this.valuesThatAreNotImplementedMap.get(nextResult.getFileName());
                for (String item : unImplementedClassValues) {
                    if (!item.matches(regex) && !this.qualifiedNameOfClassesExtendingPOJOInterfaceSet.contains(item)) continue;
                    finalResultsList.add(nextResult);
                    continue block0;
                }
            }
        }
        return finalResultsList;
    }

    @Override
    protected boolean includeInResults(String key, ClassDataStore data, AnnotationDetails ad) {
        Set<AnnotationInfo> ais = ad.getAnnotationInformation("java.lang.String");
        ArrayList<String> annoValuesNotImplementedList = new ArrayList<String>();
        for (AnnotationInfo ai : ais) {
            String stringValue = ai.getAttributeValue();
            if (data.doesClassImplement(stringValue)) continue;
            annoValuesNotImplementedList.add(stringValue);
        }
        if (annoValuesNotImplementedList.isEmpty()) {
            return false;
        }
        this.valuesThatAreNotImplementedMap.put(key, annoValuesNotImplementedList);
        return true;
    }
}

