/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectPackage;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class RemovedJaxBModuleProvided
extends DetectRule {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JavaRule);
    protected static final String RULE_NAME = "RemovedJaxBModuleProvided";
    protected static final String RULE_DESC = "appconversion.jre.189.RemovedJaxBModuleProvided";
    protected static final String[] javaActivationPackage = new String[]{"javax.activation"};
    protected static final String[] javaBindingPackages = new String[]{"javax.xml.bind", "javax.xml.bind.annotation", "javax.xml.bind.annotation.adapters", "javax.xml.bind.attachment", "javax.xml.bind.helpers", "javax.xml.bind.util"};
    protected DetectPackage javaActivationUsage = null;
    protected DetectPackage javaBindingUsage = null;
    protected DetectPackage javaActivationImplementation = null;
    protected DetectPackage javaBindingImplementation = null;

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    public RemovedJaxBModuleProvided() {
        this(RULE_NAME, RULE_DESC, true);
    }

    public RemovedJaxBModuleProvided(String ruleName, String desc, boolean flagOnce) {
        super(ruleName, desc, flagOnce);
        this.javaActivationUsage = new DetectPackage(ruleName, desc, javaActivationPackage, false, false, null, null, flagOnce);
        this.javaBindingUsage = new DetectPackage(ruleName, desc, javaBindingPackages, false, false, null, null, flagOnce);
        this.javaActivationImplementation = new DetectPackage(ruleName, desc, javaActivationPackage, true, true, null, null, flagOnce);
        this.javaBindingImplementation = new DetectPackage(ruleName, desc, javaBindingPackages, true, true, null, null, flagOnce);
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        this.javaActivationUsage.analyze(store, detectOnce);
        this.javaBindingUsage.analyze(store, detectOnce);
        this.javaActivationImplementation.analyze(store, detectOnce);
        this.javaBindingImplementation.analyze(store, detectOnce);
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.javaActivationUsage.clearResults();
        this.javaBindingUsage.clearResults();
        this.javaActivationImplementation.clearResults();
        this.javaBindingImplementation.clearResults();
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> javaActivationUsageResults = this.javaActivationUsage.getResults(store);
        List<DetailResult> javaActivationImplementationResults = this.javaActivationImplementation.getResults(store);
        List<DetailResult> javaBindingUsageResults = this.javaBindingUsage.getResults(store);
        List<DetailResult> javaBindingImplementationResults = this.javaBindingImplementation.getResults(store);
        if (!javaActivationUsageResults.isEmpty() && !javaActivationImplementationResults.isEmpty()) {
            finalResults.add(javaActivationUsageResults.get(0));
        } else if (!javaBindingUsageResults.isEmpty() && !javaBindingImplementationResults.isEmpty()) {
            finalResults.add(javaBindingUsageResults.get(0));
        }
        return finalResults;
    }
}

