/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectPackage;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.technology.DetailResult;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SSLUse
extends DetectElement {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.XmlRule, RuleType.JavaRule);
    protected static final String RULE_NAME = "SSLUse";
    protected static final String RULE_DESC = "appconversion.javaee7.jaxrs.SSLUse";
    protected static final String[] tags = new String[]{"transport-guarantee"};
    protected static final String[] fileNames = new String[]{"WEB-INF/web.xml"};
    protected static final String values = "CONFIDENTIAL";
    protected static final String namespace = "*";
    protected static final String[] packageNames = new String[]{"javax.ws.rs.client*"};
    protected DetectPackage _jaxrsPackages = new DetectPackage("SSLUse", "appconversion.javaee7.jaxrs.SSLUse", packageNames, false, false, null, null, false);

    public SSLUse() {
        this(RULE_NAME, RULE_DESC, tags, fileNames, values, namespace, false, null, null, null, false);
    }

    public SSLUse(String ruleName, String desc, String[] tags, String[] fileNames, String value, String namespace, boolean flagOnce, String docNamespace, String missingChildElement, String missingChildElementValue, boolean flagNotEmpty) {
        super(ruleName, desc, tags, fileNames, values, namespace, flagOnce, docNamespace, missingChildElement, missingChildElementValue, flagNotEmpty);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._jaxrsPackages.clearResults();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        super.analyze(store, detectOnce);
        this._jaxrsPackages.analyze(store, detectOnce);
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        ArrayList<DetailResult> finalResults = new ArrayList<DetailResult>();
        List<DetailResult> parentResults = super.getResults(store);
        List<DetailResult> jaxrsPackages = this._jaxrsPackages.getResults(store);
        if (!parentResults.isEmpty() && !jaxrsPackages.isEmpty()) {
            HashSet<String> warFileNames = new HashSet<String>();
            for (DetailResult nextResult : parentResults) {
                String fileName = nextResult.getFileName();
                int index = fileName.lastIndexOf(".war");
                if (index <= -1) continue;
                warFileNames.add(fileName.substring(0, index + 4));
            }
            Iterator<DetailResult> it = jaxrsPackages.iterator();
            if (!warFileNames.isEmpty()) {
                while (it.hasNext()) {
                    DetailResult nextResult = it.next();
                    String classNameWithPath = nextResult.getFileName();
                    if (!classNameWithPath.contains(".war/")) {
                        it.remove();
                        continue;
                    }
                    String warFileName = classNameWithPath.substring(0, classNameWithPath.lastIndexOf(".war") + 4);
                    if (warFileNames.contains(warFileName)) continue;
                    it.remove();
                }
            } else {
                jaxrsPackages.clear();
            }
            if (!jaxrsPackages.isEmpty()) {
                finalResults.add(jaxrsPackages.get(0));
            }
        }
        return finalResults;
    }
}

