/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.appconversion.jsp.core.model.CoreJspNodeModelMapper;
import com.ibm.ws.appconversion.jsp.core.model.JspNode;
import com.ibm.ws.appconversion.jsp.core.model.JspNodeType;
import com.ibm.ws.appconversion.jsp.core.util.CoreJspHelper;
import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.Constants;
import com.ibm.ws.report.binary.utilities.JSPResource;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class StaticIncludeJspRule
extends DetectRule {
    protected static EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JspRule);
    protected static final String RULE_NAME = "StaticIncludeJspRule";
    protected static final String RULE_DESC = "appconversion.competitive.StaticIncludeJspRule";
    private static final String HTML_TAG_REGEXP = ".*<\\s*(?i)html\\s*>.*";
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile(".*<\\s*(?i)html\\s*>.*");
    private static final String INCLUDE = "include";
    private static final String FILE = "file";
    private static final String DOT_DOT_FORWARD_SLASH = "../";
    List<String> processedJSPFiles = new ArrayList<String>();
    List<String> jspFilesWithHTMLTag = new ArrayList<String>();
    List<String> jspFilesWithoutHTMLTag = new ArrayList<String>();
    Set<String> includeNodeFileURLs = new HashSet<String>();
    List<DetailResult> finalResults = null;

    public StaticIncludeJspRule() {
        super(RULE_NAME, RULE_DESC, false);
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this.jspFilesWithHTMLTag.clear();
        this.jspFilesWithoutHTMLTag.clear();
        this.processedJSPFiles.clear();
        this.includeNodeFileURLs.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> keys = store.getJspKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                String data;
                JSPResource jspResource = store.getJsp(key);
                if (Constants.JSP_ONLY_REGEX.matcher(key).matches()) {
                    this.processedJSPFiles.add(key);
                    List<JspNode> htmlNodes = CoreJspHelper.filterForNodeType(jspResource.getJSPNodes(), JspNodeType.HTML);
                    for (JspNode jspNode : htmlNodes) {
                        data = jspNode.getData();
                        if (!HTML_TAG_PATTERN.matcher(data).matches()) continue;
                        this.jspFilesWithHTMLTag.add(key);
                        break;
                    }
                    if (!this.jspFilesWithHTMLTag.contains(key)) {
                        this.jspFilesWithoutHTMLTag.add(key);
                    }
                }
                List<JspNode> directiveNodes = CoreJspHelper.filterForNodeType(jspResource.getJSPNodes(), JspNodeType.DIRECTIVE);
                for (JspNode jspNode : directiveNodes) {
                    data = jspNode.getData();
                    String url = null;
                    if (!data.contains(INCLUDE) || !jspNode.getData().contains(FILE) || (url = CoreJspNodeModelMapper.getAttributeValue(FILE, data).getValue()) == null || !Constants.JSP_ONLY_REGEX.matcher(url).matches()) continue;
                    String absolutePath = this.getAbsolutePathForIncludeFile(key, url);
                    this.includeNodeFileURLs.add(absolutePath);
                }
            }
        }
    }

    private String getAbsolutePathForIncludeFile(String key, String url) {
        String jspPath = this.getContainingFolder(key);
        StringBuilder absolutePath = new StringBuilder();
        if (url.startsWith("/")) {
            String warFile = ReportUtility.getLastArchiveFileName(key);
            absolutePath.append(warFile).append(url);
        } else if (url.startsWith(DOT_DOT_FORWARD_SLASH)) {
            String currentPath = jspPath;
            String currentUrl = url;
            while (currentUrl.startsWith(DOT_DOT_FORWARD_SLASH)) {
                currentPath = this.getContainingFolder(currentPath);
                currentUrl = currentUrl.length() > 3 ? currentUrl.substring(3) : "";
            }
            absolutePath.append(currentPath).append("/").append(currentUrl);
        } else if (url.startsWith("./")) {
            absolutePath.append(jspPath).append(url.substring(1));
        } else {
            absolutePath.append(jspPath).append("/").append(url);
        }
        return absolutePath.toString();
    }

    private String getContainingFolder(String path) {
        String fileName = "";
        int index = path.lastIndexOf(47);
        if (index > -1) {
            fileName = path.substring(0, index);
        }
        return fileName;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        if (!this.includeNodeFileURLs.isEmpty()) {
            for (String nextIncludeFile : this.includeNodeFileURLs) {
                if (!this.jspFilesWithoutHTMLTag.contains(nextIncludeFile)) continue;
                this.detailResults.add(new DetailResult(this.ruleName, nextIncludeFile, this.ruleDescription, Messages.getString("Report_Criteria_Missing_HTML")));
            }
        }
        return this.detailResults;
    }
}

