/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.appconversion.jsp.core.model.TagIndex;
import com.ibm.ws.report.binary.Messages;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectElement;
import com.ibm.ws.report.binary.rules.DetectRule;
import com.ibm.ws.report.binary.rules.RuleType;
import com.ibm.ws.report.binary.utilities.JSPResource;
import com.ibm.ws.report.binary.utilities.JspRuleUtil;
import com.ibm.ws.report.binary.utilities.XMLResource;
import com.ibm.ws.report.binary.utilities.XMLRuleUtil;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TagAttributeCaseRule
extends DetectRule {
    protected static final EnumSet<RuleType> ruleType = EnumSet.of(RuleType.JspRule, RuleType.XmlRule);
    protected static final String RULE_NAME = "TagAttributeCaseRule";
    protected static final String RULE_DESC = "appconversion.competitive.rule.jspTagAttributeCaseRule";
    protected static final String METAINF_TAGLIB_LOCATION = "/META-INF/taglib.tld";
    protected static final String WEB_INF = "/WEB-INF/";
    protected static final String FORWARD_SLASH = "/";
    protected static final String ATTRIBUTE = "attribute";
    protected static final String NAME = "name";
    protected static final String[] tldFiles = new String[]{".*\\.tld"};
    protected static final String[] nameTag = new String[]{"name"};
    protected static final String[] tagTag = new String[]{"tag"};
    protected static final String[] uriTag = new String[]{"uri"};
    protected static final String[] taglibTag = new String[]{"taglib"};
    protected static final String[] webXmlFiles = new String[]{"WEB-INF/web.xml"};
    protected static final String namespace = "*";
    protected static final String[] webXmlTags = new String[]{"taglib-uri"};
    protected static final String TAGLIB_LOCATION = "taglib-location";
    protected static final String[] allFiles = new String[]{webXmlFiles[0], tldFiles[0]};
    protected Map<String, Map<String, Set<String>>> tldToElementNameToAttributeNames = new HashMap<String, Map<String, Set<String>>>();
    protected Map<String, Map<String, List<TagIndex>>> jspToURIToTagsMap = new HashMap<String, Map<String, List<TagIndex>>>();
    protected Map<String, Map<String, String>> webXmlToTagLibToTagLibLocation = new HashMap<String, Map<String, String>>();
    protected Map<String, String> uriToTld = new HashMap<String, String>();
    DetectElement _webXmlTagLib = null;
    DetectElement _tldTags = null;
    DetectElement _tldUris = null;

    public TagAttributeCaseRule() {
        this(RULE_NAME, RULE_DESC, DetectRule.FlagOnce.NONE);
    }

    public TagAttributeCaseRule(String ruleName, String desc, DetectRule.FlagOnce flagOnceType) {
        super(ruleName, desc, flagOnceType);
        this.tldToElementNameToAttributeNames.put("com/ibm/ws/appconversion/weblogic/jsp/default.tld", JspRuleUtil.defaultJspAttributes);
        this._webXmlTagLib = new DetectElement(ruleName, desc, webXmlTags, webXmlFiles, null, namespace, false, null, null, null, false){

            @Override
            protected boolean includeInResults(Node result, String key, XMLResource resource) {
                Element parent = (Element)result.getParentNode();
                String taglibLocation = XMLRuleUtil.getFirstChildElementValue(parent, this.namespace, TagAttributeCaseRule.TAGLIB_LOCATION);
                Map<Object, Object> tagLibUriToLocation = null;
                if (!TagAttributeCaseRule.this.webXmlToTagLibToTagLibLocation.containsKey(key)) {
                    tagLibUriToLocation = new HashMap();
                    TagAttributeCaseRule.this.webXmlToTagLibToTagLibLocation.put(key, tagLibUriToLocation);
                } else {
                    tagLibUriToLocation = TagAttributeCaseRule.this.webXmlToTagLibToTagLibLocation.get(key);
                }
                tagLibUriToLocation.put(XMLRuleUtil.getTextWithoutWhitespace(result), taglibLocation);
                return false;
            }
        };
        this._tldTags = new DetectElement(ruleName, desc, nameTag, tldFiles, null, namespace, DetectRule.FlagOnce.NONE, null, null, null, false, null, null, null, false, tagTag, false){

            @Override
            protected boolean includeInResults(Node result, String key, XMLResource resource) {
                String elementName = XMLRuleUtil.getTextWithoutWhitespace(result);
                Element parent = (Element)result.getParentNode();
                TagAttributeCaseRule.this.loadElementAttributes(parent, elementName, key);
                return false;
            }
        };
        this._tldUris = new DetectElement(ruleName, desc, uriTag, tldFiles, null, namespace, DetectRule.FlagOnce.NONE, null, null, null, false, null, null, null, false, taglibTag, false){

            @Override
            protected boolean includeInResults(Node result, String key, XMLResource resource) {
                String uri = XMLRuleUtil.getTextWithoutWhitespace(result);
                if (uri != null && !uri.isEmpty()) {
                    TagAttributeCaseRule.this.uriToTld.put(uri, key);
                }
                return false;
            }
        };
    }

    @Override
    public EnumSet<RuleType> getRuleTypes() {
        return ruleType;
    }

    @Override
    public String[] getFileNames() {
        return allFiles;
    }

    @Override
    public void clearResults() {
        super.clearResults();
        this._tldUris.clearResults();
        this._tldTags.clearResults();
        this._webXmlTagLib.clearResults();
        this.tldToElementNameToAttributeNames.clear();
        this.jspToURIToTagsMap.clear();
        this.webXmlToTagLibToTagLibLocation.clear();
        this.uriToTld.clear();
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> keys = store.getJspKeys();
        if (!keys.isEmpty()) {
            for (String key : keys) {
                JSPResource jspResource = store.getJsp(key);
                Map<String, String> prefixToTldUrlMap = JspRuleUtil.getPrefixToTldURLMap(jspResource);
                prefixToTldUrlMap.put("jsp", "com/ibm/ws/appconversion/weblogic/jsp/default.tld");
                List<TagIndex> tagIndexes = JspRuleUtil.getTagIndexes(jspResource);
                for (TagIndex ti : tagIndexes) {
                    if (!ti.isValidTag()) continue;
                    String url = prefixToTldUrlMap.get(ti.getPrefix());
                    if (url != null) {
                        List<TagIndex> tags;
                        Map<String, List<TagIndex>> urlToTags = this.jspToURIToTagsMap.get(key);
                        if (urlToTags == null) {
                            urlToTags = new HashMap<String, List<TagIndex>>();
                            tags = new ArrayList<TagIndex>();
                            tags.add(ti);
                            urlToTags.put(url, tags);
                            this.jspToURIToTagsMap.put(key, urlToTags);
                            continue;
                        }
                        tags = urlToTags.get(url);
                        if (tags == null) {
                            tags = new ArrayList<TagIndex>();
                            urlToTags.put(url, tags);
                        }
                        tags.add(ti);
                        continue;
                    }
                    ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("Report_Missing_Prefix_Library"), ti.getPrefix(), key));
                }
            }
        } else {
            this._tldUris.analyze(store, detectOnce);
            this._tldTags.analyze(store, detectOnce);
            this._webXmlTagLib.analyze(store, detectOnce);
        }
    }

    protected String resolveURI(String uri, String warFile) {
        String tldUriReferenceCase4;
        String case1PlusSlash;
        String fileNameReferenceCase1 = String.valueOf(warFile) + uri;
        if (this.tldToElementNameToAttributeNames.containsKey(fileNameReferenceCase1)) {
            return fileNameReferenceCase1;
        }
        if (!uri.startsWith(FORWARD_SLASH) && this.tldToElementNameToAttributeNames.containsKey(case1PlusSlash = String.valueOf(warFile) + FORWARD_SLASH + uri)) {
            return case1PlusSlash;
        }
        String jarFileReferenceCase2 = String.valueOf(warFile) + uri + METAINF_TAGLIB_LOCATION;
        if (this.tldToElementNameToAttributeNames.containsKey(jarFileReferenceCase2)) {
            return jarFileReferenceCase2;
        }
        String webXml = String.valueOf(warFile) + FORWARD_SLASH + webXmlFiles[0];
        Map<String, String> tagLibToLocation = this.webXmlToTagLibToTagLibLocation.get(webXml);
        if (tagLibToLocation != null && tagLibToLocation.containsKey(uri)) {
            String case3PlusSlash;
            String tagLibLocation = tagLibToLocation.get(uri);
            String taglib_uri_ReferenceCase3 = String.valueOf(warFile) + tagLibLocation;
            if (this.tldToElementNameToAttributeNames.containsKey(taglib_uri_ReferenceCase3)) {
                return taglib_uri_ReferenceCase3;
            }
            if (!tagLibLocation.startsWith(FORWARD_SLASH) && this.tldToElementNameToAttributeNames.containsKey(case3PlusSlash = String.valueOf(warFile) + WEB_INF + tagLibLocation)) {
                return case3PlusSlash;
            }
        }
        if (this.uriToTld.containsKey(uri) && this.tldToElementNameToAttributeNames.containsKey(tldUriReferenceCase4 = this.uriToTld.get(uri))) {
            return tldUriReferenceCase4;
        }
        return null;
    }

    @Override
    public List<DetailResult> getResults(SimpleDataStore store) {
        HashMap<String, String> resolvedURIs = new HashMap<String, String>();
        resolvedURIs.put("com/ibm/ws/appconversion/weblogic/jsp/default.tld", "com/ibm/ws/appconversion/weblogic/jsp/default.tld");
        for (Map.Entry<String, Map<String, List<TagIndex>>> entry : this.jspToURIToTagsMap.entrySet()) {
            String jsp = entry.getKey();
            String warFile = ReportUtility.getLastArchiveFileName(jsp);
            Map<String, List<TagIndex>> uriToTags = entry.getValue();
            for (Map.Entry<String, List<TagIndex>> nextEntry : uriToTags.entrySet()) {
                String uri = nextEntry.getKey();
                List<TagIndex> tags = nextEntry.getValue();
                String resolvedURI = null;
                resolvedURI = resolvedURIs.containsKey(uri) ? (String)resolvedURIs.get(uri) : this.resolveURI(uri, warFile);
                if (resolvedURI != null) {
                    Map<String, Set<String>> tldInfo = this.tldToElementNameToAttributeNames.get(resolvedURI);
                    if (tldInfo == null && resolvedURI.equals("com/ibm/ws/appconversion/weblogic/jsp/default.tld")) {
                        tldInfo = new HashMap<String, Set<String>>();
                        tldInfo.putAll(JspRuleUtil.defaultJspAttributes);
                    }
                    if (tldInfo == null) continue;
                    for (TagIndex ti : tags) {
                        String element = ti.getElement();
                        int line = ti.getLine();
                        Set<String> tldAttrs = tldInfo.get(element);
                        if (tldAttrs == null || tldAttrs.isEmpty()) continue;
                        Map<String, Integer> jspAttrs = ti.getAttributes();
                        block3: for (Map.Entry<String, Integer> attrEntry : jspAttrs.entrySet()) {
                            String attr = attrEntry.getKey();
                            if (tldAttrs.contains(attr)) continue;
                            for (String tldAttr : tldAttrs) {
                                if (!tldAttr.equalsIgnoreCase(attr)) continue;
                                StringBuilder attributeMismatch = new StringBuilder();
                                attributeMismatch.append(attr).append("!=").append(tldAttr);
                                this.detailResults.add(new DetailResult(this.ruleName, jsp, this.ruleDescription, attributeMismatch.toString(), 1, null, line));
                                continue block3;
                            }
                        }
                    }
                    continue;
                }
                ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("Report_Missing_Tag_Library"), uri, jsp));
            }
        }
        return this.detailResults;
    }

    protected void loadElementAttributes(Element tagElement, String elementName, String key) {
        Map<Object, Object> elementToAttrNames = null;
        Set<String> attrNames = null;
        if (this.tldToElementNameToAttributeNames.containsKey(key)) {
            elementToAttrNames = this.tldToElementNameToAttributeNames.get(key);
            if (elementToAttrNames.containsKey(elementName)) {
                attrNames = (Set)elementToAttrNames.get(elementName);
            } else {
                attrNames = new HashSet();
                elementToAttrNames.put(elementName, attrNames);
            }
        } else {
            elementToAttrNames = new HashMap();
            attrNames = new HashSet();
            elementToAttrNames.put(elementName, attrNames);
            this.tldToElementNameToAttributeNames.put(key, elementToAttrNames);
        }
        List<Element> children = XMLRuleUtil.getChildElements(tagElement, namespace, ATTRIBUTE);
        if (!children.isEmpty()) {
            for (Element child : children) {
                String attrName = XMLRuleUtil.getFirstChildElementValue(child, namespace, NAME);
                if (attrName == null) continue;
                attrNames.add(attrName);
            }
        }
    }
}

