/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.binary.rules.custom;

import com.ibm.ws.appconversion.jsp.core.model.JspNode;
import com.ibm.ws.appconversion.jsp.core.model.JspNodeType;
import com.ibm.ws.appconversion.jsp.core.util.CoreJspHelper;
import com.ibm.ws.report.binary.asm.utilities.SimpleDataStore;
import com.ibm.ws.report.binary.rules.DetectJspTaglib;
import com.ibm.ws.report.binary.utilities.JSPResource;
import com.ibm.ws.report.technology.DetailResult;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThreadSafeDirective
extends DetectJspTaglib {
    protected static final String RULE_NAME = "ThreadSafeDirective";
    protected static final String RULE_DESC = "com.ibm.ws.report.binary.jakartaee10.jsp.ThreadSafeDirective";
    private static final Pattern IS_THREAD_SAFE_PATTERN = Pattern.compile("(?s)<%@[^(%>)]*page[^(%>)]*isThreadSafe[^(%>)]*=[^(%>)]*%>");
    private static final String IS_THREAD_SAFE = "isThreadSafe";

    public ThreadSafeDirective() {
        this(RULE_NAME, RULE_DESC, (String[])null, false);
    }

    public ThreadSafeDirective(String ruleName, String desc, String[] taglibs, boolean flagOnce) {
        super(ruleName, desc, taglibs, flagOnce);
    }

    @Override
    public void analyze(SimpleDataStore store, boolean detectOnce) {
        Set<String> keys = store.getJspKeys();
        if (!keys.isEmpty()) {
            block0: for (String key : keys) {
                JSPResource jspData = store.getJsp(key);
                List<JspNode> jspNodes = jspData.getJSPNodes();
                jspNodes = CoreJspHelper.filterForNodeType(jspNodes, JspNodeType.DIRECTIVE);
                for (JspNode jspNode : jspNodes) {
                    Matcher data = IS_THREAD_SAFE_PATTERN.matcher(jspNode.getData());
                    if (!data.find()) continue;
                    this.detailResults.add(new DetailResult(this.ruleName, key, this.ruleDescription, IS_THREAD_SAFE, 1, null, jspNode.getLine()));
                    continue block0;
                }
            }
        }
    }
}

