/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.inventory;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.ws.report.Messages;
import com.ibm.ws.report.inventory.Archive;
import com.ibm.ws.report.inventory.UtilityJar;
import com.ibm.ws.report.utilities.ReportUtility;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ArchiveInventory
implements Iterable<Archive> {
    private final Map<String, Archive> map = new TreeMap<String, Archive>();
    private final Map<String, String> checksumSharedLibrariesMap = new TreeMap<String, String>();
    protected ArchiveInventory parentInv;
    private final int[] archiveCounts = new int[ArchiveTypes.values().length];

    @Override
    public Iterator<Archive> iterator() {
        return this.map.values().iterator();
    }

    public Set<String> getArchiveNames() {
        return this.map.keySet();
    }

    public Collection<Archive> getArchiveCollection() {
        return this.map.values();
    }

    public void put(Archive arc) {
        if (arc == null) {
            throw new IllegalArgumentException("The Archive to put into the Inventory must not be null.");
        }
        if (arc.parent != null) {
            throw new IllegalArgumentException("The archive " + arc.getFullName() + " is already contained within " + arc.parent);
        }
        assert (arc.inv.parentInv == null);
        if (this.map.containsKey(arc.getFullName())) {
            throw new IllegalArgumentException("There is already an Archive with the name and extension " + arc.getFullName() + " in this inventory");
        }
        Archive prev = this.map.put(arc.getFullName(), arc);
        assert (prev == null);
        arc.inv.parentInv = this;
        this.consolidateArchiveQuantities(arc);
    }

    /*
     * Unable to fully structure code
     */
    private void consolidateArchiveQuantities(Archive arc) {
        subInv = arc.inv;
        current = subInv.parentInv;
        if (ArchiveInventory.$assertionsDisabled || current == this) ** GOTO lbl17
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            var7_7 = ArchiveTypes.values();
            var6_6 = var7_7.length;
            var5_5 = 0;
            while (var5_5 < var6_6) {
                arcType = var7_7[var5_5];
                v0 = arcType.ordinal();
                current.archiveCounts[v0] = current.archiveCounts[v0] + subInv.archiveCounts[arcType.ordinal()];
                ++var5_5;
            }
            v1 = arc.getArchiveType().ordinal();
            current.archiveCounts[v1] = current.archiveCounts[v1] + 1;
            current = current.parentInv;
lbl17:
            // 2 sources

            ** while (current != null)
        }
lbl18:
        // 1 sources

    }

    public boolean contains(String fullName) {
        return this.map.containsKey(fullName);
    }

    public Archive get(String nameAndExtension) {
        if (nameAndExtension == null) {
            throw new IllegalArgumentException("The Archive to get must not be null.");
        }
        return this.map.get(nameAndExtension);
    }

    public int getArchiveCount(ArchiveTypes arcType) {
        return this.archiveCounts[arcType.ordinal()];
    }

    public int getSummaryFieldValue(Archive.Fields field) {
        int total = 0;
        Set<String> keys = this.map.keySet();
        for (String key : keys) {
            Archive arch = this.map.get(key);
            total += arch.getFieldTotal(field);
        }
        return total;
    }

    public int getSummaryFieldTotal(EnumSet<Archive.Fields> setOFFields) {
        int total = 0;
        Set<String> keys = this.map.keySet();
        for (String key : keys) {
            Archive arch = this.map.get(key);
            total += arch.getFieldTotal(setOFFields);
        }
        return total;
    }

    public int getTotalNumberOfArchives() {
        return this.map.size();
    }

    public void toJSON(OrderedJSONObject jsonObject, List<String> arrayOfProjects, List<String> arrayOfSharedLibraries) {
        JSONArray applicationsArray = new JSONArray();
        for (String appName : arrayOfProjects) {
            applicationsArray.add(appName);
        }
        jsonObject.put("applications", applicationsArray);
        JSONArray sharedLibrariesArray = new JSONArray();
        for (String appName : arrayOfSharedLibraries) {
            sharedLibrariesArray.add(appName);
        }
        jsonObject.put("sharedLibraries", sharedLibrariesArray);
        OrderedJSONObject archiveSummaryObject = new OrderedJSONObject();
        ArchiveTypes[] archiveTypesArray = ArchiveTypes.values();
        int n = archiveTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArchiveTypes arcType = archiveTypesArray[n2];
            int count = this.getArchiveCount(arcType);
            archiveSummaryObject.put(arcType.jsonKey, (Object)count);
            ++n2;
        }
        jsonObject.put("archives", archiveSummaryObject);
        OrderedJSONObject summaryObject = new OrderedJSONObject();
        Archive.Fields[] fieldsArray = Archive.Fields.values();
        int n3 = fieldsArray.length;
        n = 0;
        while (n < n3) {
            Archive.Fields field = fieldsArray[n];
            int count = this.getSummaryFieldValue(field);
            summaryObject.put(field.getJsonKey(), (Object)count);
            ++n;
        }
        jsonObject.put("summary", summaryObject);
        LinkedHashSet<UtilityJar> utilityJARSet = new LinkedHashSet<UtilityJar>();
        JSONArray archivesArray = new JSONArray();
        for (String key : arrayOfProjects) {
            Archive nextArchive = this.get(key);
            if (nextArchive == null) continue;
            OrderedJSONObject jsonArchive = nextArchive.toJSON(true, this.checksumSharedLibrariesMap);
            archivesArray.add(jsonArchive);
            for (Archive sharedLib : nextArchive.getSharedLibraries()) {
                utilityJARSet.add((UtilityJar)sharedLib);
            }
        }
        jsonObject.put("archiveInventory", archivesArray);
        JSONArray sharedLibDetailsArray = new JSONArray();
        this.addSharedLibDetails(utilityJARSet, sharedLibDetailsArray);
        jsonObject.put("sharedLibraryDetails", sharedLibDetailsArray);
    }

    public void putSharedLibChecksum(String sharedLib, String checksum) {
        this.checksumSharedLibrariesMap.put(sharedLib, checksum);
    }

    private void addSharedLibDetails(Set<UtilityJar> utilityJARSet, JSONArray sharedLibDetailsArray) {
        for (UtilityJar utilJar : utilityJARSet) {
            OrderedJSONObject sharedLibObject = new OrderedJSONObject();
            String archiveName = utilJar.getFullName();
            Iterator<String> itr = utilJar.iterator();
            JSONArray packageArray = new JSONArray();
            while (itr.hasNext()) {
                String utilPackage = itr.next();
                packageArray.add(utilPackage);
            }
            sharedLibObject.put("archive", archiveName);
            sharedLibObject.put("checksum", this.checksumSharedLibrariesMap.get(archiveName));
            sharedLibObject.put("packages", packageArray);
            sharedLibDetailsArray.add(sharedLibObject);
        }
    }

    public static final class ArchiveTypes
    extends Enum<ArchiveTypes> {
        public static final /* enum */ ArchiveTypes EAR = new ArchiveTypes("INVENTORY_REPORT_EAR_FILES", "ear", "INVENTORY_REPORT_EAR_TYPE", "ears", false, "application.xml");
        public static final /* enum */ ArchiveTypes WAR = new ArchiveTypes("INVENTORY_REPORT_WAR_FILES", "war", "INVENTORY_REPORT_WAR_TYPE", "wars", true, "web.xml");
        public static final /* enum */ ArchiveTypes RAR = new ArchiveTypes("INVENTORY_REPORT_RAR_FILES", "rar", "INVENTORY_REPORT_RAR_TYPE", "rars", true, "ra.xml");
        public static final /* enum */ ArchiveTypes EJB_JAR = new ArchiveTypes("INVENTORY_REPORT_EJB_JAR_FILES", "jar", "INVENTORY_REPORT_EJB_JAR_TYPE", "ejbs", true, "ejb-jar.xml");
        public static final /* enum */ ArchiveTypes WEB_FRAGMENT_JAR = new ArchiveTypes("INVENTORY_REPORT_WEB_FRAGMENT_JAR_FILES", "jar", "INVENTORY_REPORT_WEB_FRAGMENT_JAR_TYPE", "webFragments", true, "web-fragment.xml");
        public static final /* enum */ ArchiveTypes UTILITY_JAR = new ArchiveTypes("INVENTORY_REPORT_UTILITY_JAR_FILES", "jar", "INVENTORY_REPORT_UTILITY_JAR_TYPE", "utilityJars", false, null);
        public static final /* enum */ ArchiveTypes APP_CLIENT_JAR = new ArchiveTypes("INVENTORY_REPORT_APP_CLIENT_JAR_FILES", "jar", "INVENTORY_REPORT_APP_CLIENT_TYPE", "appClients", true, "application-client.xml");
        private final String messageKey;
        private final String extension;
        private final String archiveType;
        private final String jsonKey;
        private final boolean metadataCompletePossible;
        private final String descriptorFileName;
        private static EnumSet<ArchiveTypes> earContains;
        private static EnumSet<ArchiveTypes> warContains;
        private static EnumSet<ArchiveTypes> rarContains;
        private static EnumSet<ArchiveTypes> appClientJarContains;
        private static EnumSet<ArchiveTypes> ejbJarContains;
        private static EnumSet<ArchiveTypes> webFragmentJarContains;
        private static EnumSet<ArchiveTypes> utilityJarContains;
        private static EnumSet<ArchiveTypes> jarArchiveTypes;
        private static final /* synthetic */ ArchiveTypes[] ENUM$VALUES;

        static {
            ENUM$VALUES = new ArchiveTypes[]{EAR, WAR, RAR, EJB_JAR, WEB_FRAGMENT_JAR, UTILITY_JAR, APP_CLIENT_JAR};
            earContains = EnumSet.of(WAR, RAR, EJB_JAR, UTILITY_JAR, APP_CLIENT_JAR);
            warContains = EnumSet.of(EJB_JAR, WEB_FRAGMENT_JAR, UTILITY_JAR);
            rarContains = EnumSet.of(UTILITY_JAR);
            appClientJarContains = EnumSet.noneOf(ArchiveTypes.class);
            ejbJarContains = EnumSet.noneOf(ArchiveTypes.class);
            webFragmentJarContains = EnumSet.noneOf(ArchiveTypes.class);
            utilityJarContains = EnumSet.of(UTILITY_JAR);
            jarArchiveTypes = EnumSet.of(APP_CLIENT_JAR, EJB_JAR, UTILITY_JAR, WEB_FRAGMENT_JAR);
        }

        private ArchiveTypes(String key, String ext, String type, String json, boolean metadataComplete, String descriptorFileName) {
            assert (this.name().length() >= 3);
            this.messageKey = key;
            this.extension = ext;
            this.archiveType = type;
            this.jsonKey = json;
            this.metadataCompletePossible = metadataComplete;
            this.descriptorFileName = descriptorFileName;
        }

        public static boolean isJarArchiveType(ArchiveTypes type) {
            return jarArchiveTypes.contains((Object)type);
        }

        public static ArchiveTypes[] getAllowedArchiveTypes(ArchiveTypes type) {
            ArchiveTypes[] ats = new ArchiveTypes[]{};
            switch (type) {
                case APP_CLIENT_JAR: {
                    ats = appClientJarContains.toArray(new ArchiveTypes[appClientJarContains.size()]);
                    break;
                }
                case EAR: {
                    ats = earContains.toArray(new ArchiveTypes[earContains.size()]);
                    break;
                }
                case EJB_JAR: {
                    ats = ejbJarContains.toArray(new ArchiveTypes[ejbJarContains.size()]);
                    break;
                }
                case RAR: {
                    ats = rarContains.toArray(new ArchiveTypes[rarContains.size()]);
                    break;
                }
                case UTILITY_JAR: {
                    ats = utilityJarContains.toArray(new ArchiveTypes[utilityJarContains.size()]);
                    break;
                }
                case WAR: {
                    ats = warContains.toArray(new ArchiveTypes[warContains.size()]);
                    break;
                }
                case WEB_FRAGMENT_JAR: {
                    ats = webFragmentJarContains.toArray(new ArchiveTypes[webFragmentJarContains.size()]);
                    break;
                }
            }
            return ats;
        }

        public boolean canContain(ArchiveTypes type) {
            boolean flag = false;
            switch (this) {
                case EAR: {
                    flag = earContains.contains((Object)type);
                    break;
                }
                case APP_CLIENT_JAR: {
                    flag = appClientJarContains.contains((Object)type);
                    break;
                }
                case EJB_JAR: {
                    flag = ejbJarContains.contains((Object)type);
                    break;
                }
                case RAR: {
                    flag = rarContains.contains((Object)type);
                    break;
                }
                case UTILITY_JAR: {
                    flag = utilityJarContains.contains((Object)type);
                    break;
                }
                case WAR: {
                    flag = warContains.contains((Object)type);
                    break;
                }
                case WEB_FRAGMENT_JAR: {
                    flag = webFragmentJarContains.contains((Object)type);
                    break;
                }
            }
            return flag;
        }

        public String typeExtension() {
            return this.extension;
        }

        public String toString() {
            return Messages.getMessage(this.messageKey, new Object[0]);
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public String getType() {
            return Messages.getMessage(this.archiveType, new Object[0]);
        }

        public boolean isCorrectDescriptor(String filePath) {
            return filePath != null ? ReportUtility.getFileName(filePath).equals(this.descriptorFileName) : this.descriptorFileName == null;
        }

        public String getJsonKey() {
            return this.jsonKey;
        }

        public boolean isMetadataCompletePossible() {
            return this.metadataCompletePossible;
        }

        public static ArchiveTypes[] values() {
            ArchiveTypes[] archiveTypesArray = ENUM$VALUES;
            int n = archiveTypesArray.length;
            ArchiveTypes[] archiveTypesArray2 = new ArchiveTypes[n];
            System.arraycopy(ENUM$VALUES, 0, archiveTypesArray2, 0, n);
            return archiveTypesArray2;
        }

        public static ArchiveTypes valueOf(String string) {
            return Enum.valueOf(ArchiveTypes.class, string);
        }
    }
}

