/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.utilities;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.utilities.FileComparator;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.utilities.XmlParserErrorHandler;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileHelper {
    private static Pattern scriptPattern = Pattern.compile("\\<script[^>]+\\>([\\s\\S]+?)<\\/script");

    public static Document getParsedDocument(InputStream is) throws Exception {
        return FileHelper.getParsedDocument(is, false);
    }

    public static Document getParsedDocument(InputStream is, boolean isXHTML) throws Exception {
        Document thisDocument = null;
        if (is != null) {
            try {
                Matcher m;
                DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                if (impl == null) {
                    System.setProperty("org.w3c.dom.DOMImplementationSourceList", "com.sun.org.apache.xerces.internal.dom.DOMImplementationSourceImpl");
                    registry = DOMImplementationRegistry.newInstance();
                    impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                }
                DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
                f.setNamespaceAware(true);
                f.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                f.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                FileHelper.secureXMLReading(f);
                DocumentBuilder builder = f.newDocumentBuilder();
                builder.setErrorHandler(new XmlParserErrorHandler());
                BufferedInputStream bis = new BufferedInputStream(is);
                byte[] contents = null;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    int nextByte;
                    while ((nextByte = bis.read()) != -1) {
                        baos.write(nextByte);
                    }
                    contents = baos.toByteArray();
                }
                finally {
                    if (baos != null) {
                        baos.close();
                    }
                }
                String xmlString = new String(contents, "UTF-8");
                if (!xmlString.contains("xml")) {
                    ReportUtility.logger.get().log(Level.FINE, "The xml file did not contain the text \"xml\" when read with a UTF-8 encoding. Trying to read with an IBM-1047 encoding.");
                    String ebcdicString = new String(contents, "IBM-1047");
                    ebcdicString = ebcdicString.replaceAll(String.valueOf('\u0085'), System.getProperty("line.separator"));
                    if (ebcdicString.contains("xml")) {
                        xmlString = ebcdicString;
                    } else {
                        ReportUtility.logger.get().log(Level.FINE, "The xml file did not contain the text \"xml\" when read with an IBM-1047 encoding. Attempting to parse using the UTF-8 encoding.");
                    }
                }
                if (isXHTML && (m = scriptPattern.matcher(xmlString)).find()) {
                    String scriptContent = m.group(1);
                    String encodedScriptContent = scriptContent.replace("<", "&lt;").replace(">", "&gt;").replace("&", "&#38;").replace("'", "&#39;").replace("\"", "&#34;");
                    xmlString = xmlString.replace(scriptContent, encodedScriptContent);
                }
                InputSource in = new InputSource(new StringReader(xmlString));
                thisDocument = builder.parse(in);
                thisDocument.normalize();
            }
            catch (ClassNotFoundException e) {
                throw new Exception(e.getLocalizedMessage(), e);
            }
            catch (InstantiationException e) {
                throw new Exception(e.getLocalizedMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new Exception(e.getLocalizedMessage(), e);
            }
            catch (SAXException e) {
                throw new Exception(e.getLocalizedMessage(), e);
            }
            catch (IOException e) {
                throw new Exception(e.getLocalizedMessage(), e);
            }
            catch (Exception e) {
                throw e;
            }
        }
        return thisDocument;
    }

    public static void secureXMLReading(DocumentBuilderFactory factory) {
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static String getStringFromDocument(Document doc, boolean isCompleteFile) throws TransformerException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        if (!isCompleteFile) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        transformer.transform(domSource, result);
        return writer.toString().replace("?><", "?>" + System.getProperty("line.separator") + "<");
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static void mergeAllFiles(List<File> filesToMerge, File outputFile, Map<String, String> londonServerEnvVars) {
        finalXMLNodes = new ArrayList<Node>();
        mapOfDupeNodeNameToOrigNodeName = new HashMap<String, String>();
        mapOfProcessedNodeValuesToNodeName = new HashMap<String, String>();
        allEnvVars = new HashMap<String, String>();
        filesWithoutServerEnv = new ArrayList<File>();
        serverNode = null;
        Collections.sort(filesToMerge, new FileComparator());
        for (File file : filesToMerge) {
            if (file.getName().endsWith("_server.env")) {
                br = null;
                try {
                    try {
                        br = new BufferedReader(new FileReader(file));
                        line = br.readLine();
                        while (line != null) {
                            index = line.indexOf("=");
                            if (index > 0 && index < line.length() - 1) {
                                allEnvVars.put(line.substring(0, index), line.substring(index + 1, line.length()));
                            }
                            line = br.readLine();
                        }
                    }
                    catch (Exception e) {
                        ReportUtility.logger.get().log(Level.WARNING, Messages.getFormattedMessage(Messages.getString("File_Not_Loaded_Log"), new Object[]{file.getName()}), e);
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        file.delete();
                        continue;
                    }
                }
                catch (Throwable var14_26) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    file.delete();
                    throw var14_26;
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                file.delete();
                continue;
            }
            filesWithoutServerEnv.add(file);
        }
        for (Map.Entry entry : londonServerEnvVars.entrySet()) {
            if (entry.getValue() == null) continue;
            allEnvVars.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (File file : filesWithoutServerEnv) {
            block53: {
                is = null;
                try {
                    is = new FileInputStream(file);
                    if (file.getName().endsWith("_jvm.options")) {
                        jvmOptionsFile = new File(String.valueOf(file.getParent()) + File.separator + "jvm.options");
                        Files.copy(is, jvmOptionsFile.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    } else if (file.getName().endsWith(".xml")) {
                        xmlDoc = FileHelper.getParsedDocument(is);
                        server = xmlDoc.getFirstChild();
                        if (serverNode == null) {
                            serverNode = server;
                        }
                        serverChildNodes = server.getChildNodes();
                        i = 0;
                        while (i < serverChildNodes.getLength()) {
                            node = serverChildNodes.item(i);
                            if (node.getNodeType() != 8) {
                                if (node.getNodeName().equals("variable")) {
                                    name = node.getAttributes().getNamedItem("name").getNodeValue();
                                    value = node.getAttributes().getNamedItem("defaultValue").getNodeValue();
                                    if (!allEnvVars.keySet().contains(name) && !londonServerEnvVars.keySet().contains(name)) {
                                        if (mapOfProcessedNodeValuesToNodeName.containsKey(value)) {
                                            mapOfDupeNodeNameToOrigNodeName.put(name, (String)mapOfProcessedNodeValuesToNodeName.get(value));
                                        } else {
                                            mapOfProcessedNodeValuesToNodeName.put(value, name);
                                            finalXMLNodes.add(node);
                                        }
                                    }
                                } else if (!FileHelper.listContainsEquivalentNode(finalXMLNodes, node)) {
                                    finalXMLNodes.add(node);
                                }
                            }
                            ++i;
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    file.delete();
                    continue;
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        continue;
                    }
                    catch (Throwable var19_36) {
                        throw var19_36;
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        file.delete();
                    }
                }
                if (is == null) break block53;
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            file.delete();
        }
        if (serverNode != null) ** GOTO lbl143
        ReportUtility.logger.get().log(Level.WARNING, Messages.getString("ReportBuilder_Server_Merge_Error"));
        return;
lbl-1000:
        // 1 sources

        {
            serverNode.removeChild(serverNode.getFirstChild());
lbl143:
            // 2 sources

            ** while (serverNode.hasChildNodes())
        }
lbl144:
        // 1 sources

        try {
            FileHelper.writeServerEnv(allEnvVars, outputFile);
            xmlDoc = null;
            f = DocumentBuilderFactory.newInstance();
            builder = f.newDocumentBuilder();
            xmlDoc = builder.newDocument();
            xmlDoc.adoptNode(serverNode);
            comment = xmlDoc.createComment(Messages.getString("Do_Not_Modify_Server_XML"));
            serverNode.appendChild(comment);
            for (Node n : finalXMLNodes) {
                xmlDoc.adoptNode(n);
                serverNode.appendChild(n);
            }
            xmlDoc.appendChild(serverNode);
            FileHelper.removeDupeVariables(xmlDoc, mapOfDupeNodeNameToOrigNodeName);
            serverXml = FileHelper.getStringFromDocument(xmlDoc, true);
            serverXml = serverXml.replace(" standalone=\"no\"", "");
            ReportUtility.writeOutStream(outputFile, serverXml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeServerEnv(Map<String, String> allEnvVars, File outputFile) throws Exception {
        boolean isWindows = ReportUtility.OS.startsWith("windows");
        StringBuilder servEnvStrBlder = new StringBuilder();
        if (!isWindows) {
            servEnvStrBlder.append("# enable_variable_expansion" + System.getProperty("line.separator"));
        }
        for (Map.Entry<String, String> entry : allEnvVars.entrySet()) {
            String newEntry = entry.getValue();
            if (isWindows) {
                newEntry = newEntry.contains("${") ? entry.getValue().replace("${", "!").replace("}", "!") : newEntry;
            }
            servEnvStrBlder.append(String.valueOf(entry.getKey()) + "=" + newEntry + System.getProperty("line.separator"));
        }
        File servEnvOutFile = new File(outputFile.getParent(), "server.env");
        ReportUtility.writeOutStream(servEnvOutFile, servEnvStrBlder.toString());
    }

    private static void removeDupeVariables(Document xmlDoc, Map<String, String> mapOfDupeNodeNameToOrigNodeName) {
        Node server = xmlDoc.getFirstChild();
        NodeList serverElements = server.getChildNodes();
        ArrayList<Node> finalList = new ArrayList<Node>();
        ArrayList<Node> toRemove = new ArrayList<Node>();
        int i = 0;
        while (i < serverElements.getLength()) {
            Node n = serverElements.item(i);
            Boolean isDup = false;
            if (!n.getNodeName().equals("variable")) {
                FileHelper.changeVariableReferences(n, mapOfDupeNodeNameToOrigNodeName);
                isDup = n.getNodeName().equals("dataSource") ? FileHelper.checkDuplicateDataSource(finalList, n) : Boolean.valueOf(FileHelper.listContainsEquivalentNode(finalList, n));
                if (isDup.booleanValue()) {
                    toRemove.add(n);
                } else {
                    finalList.add(n);
                }
            }
            ++i;
        }
        for (Node node : toRemove) {
            server.removeChild(node);
        }
    }

    private static boolean listContainsEquivalentNode(List<Node> nodeList, Node node) {
        for (Node fin : nodeList) {
            if (!node.isEqualNode(fin)) continue;
            return true;
        }
        return false;
    }

    private static Boolean checkDuplicateDataSource(List<Node> nodeList, Node node) {
        String nodeJndiName = node.getAttributes().getNamedItem("jndiName").getNodeValue();
        for (Node fin : nodeList) {
            NamedNodeMap attris;
            String jndiName;
            if (fin.getLocalName() == null || !fin.getLocalName().equals("dataSource") || !nodeJndiName.equals(jndiName = (attris = fin.getAttributes()).getNamedItem("jndiName").getNodeValue())) continue;
            return true;
        }
        return false;
    }

    private static void changeVariableReferences(Node element, Map<String, String> mapOfDupeNodeNameToOrigNodeName) {
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                String oldVal;
                String nodeVal = attributes.item(i).getNodeValue();
                if (nodeVal.contains("${") && nodeVal.contains("}") && mapOfDupeNodeNameToOrigNodeName.containsKey(oldVal = nodeVal.substring(nodeVal.indexOf("${") + 2, nodeVal.indexOf("}")))) {
                    String replacementValue = nodeVal.replace(oldVal, mapOfDupeNodeNameToOrigNodeName.get(oldVal));
                    attributes.item(i).setNodeValue(replacementValue);
                }
                ++i;
            }
        }
        if (element.hasChildNodes()) {
            int j = 0;
            while (j < element.getChildNodes().getLength()) {
                FileHelper.changeVariableReferences(element.getChildNodes().item(j), mapOfDupeNodeNameToOrigNodeName);
                ++j;
            }
        }
    }
}

