/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.report.writer.html;

import com.ibm.ws.report.Messages;
import com.ibm.ws.report.analyze.AnalysisResults;
import com.ibm.ws.report.analyze.AnalysisRule;
import com.ibm.ws.report.technology.DetailResult;
import com.ibm.ws.report.utilities.ReportUtility;
import com.ibm.ws.report.utilities.RuleInfo;
import com.ibm.ws.report.utilities.RuleSeverity;
import com.ibm.ws.report.writer.DetailAnalysisReportWriter;
import com.ibm.ws.report.writer.ModuleData;
import com.ibm.ws.report.writer.ModuleHierarchy;
import com.ibm.ws.report.writer.ReportWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class HTMLDetailAnalysisStreamlinedReportWriter
extends DetailAnalysisReportWriter
implements ReportWriter {
    protected AnalysisResults analysisResults;
    protected boolean helpExists = false;
    protected SortedMap<String, String> helpContent = new TreeMap<String, String>();
    protected Set<String> helpLoaded = new HashSet<String>();
    protected Set<String> helpWritten = new HashSet<String>();
    int offsetOfSummary = 0;
    int offsetOfJumpToRule = 0;
    boolean includeConnectivitySummary = false;
    boolean includeAdditionalRuleHelp = false;
    Map<String, AnalysisRule> connectivityRuleToTableId = null;
    ModuleData moduleData = null;
    private final boolean hasResults;
    private final boolean showAllHelp;
    private final boolean allRulesLoaded;
    int maxUserDefinedRuleResults;
    public static final String AUTOMATED_FIX_SVG = "<svg title=\"Automated Fix\" class=\"%s\" enable-background=\"new 0 0 32 32\" version=\"1.1\" viewBox=\"0 0 32 32\" xml:space=\"preserve\" xmlns=\"http://www.w3.org/2000/svg\"><style type=\"text/css\">.st0{fill:none;}</style><switch><foreignObject width=\"1\" height=\"1\" requiredExtensions=\"http://ns.adobe.com/AdobeIllustrator/10.0/\"></foreignObject><g><path d=\"M16,27c-3.6,0-7.1-1.8-9.2-5H12v-2H4v8h2v-3.7c2.5,3,6.1,4.7,10,4.7V27z\"/><path d=\"m31 23v-2h-2.1c-0.1-0.6-0.4-1.2-0.7-1.8l1.5-1.5-1.4-1.4-1.5 1.5c-0.5-0.3-1.1-0.6-1.8-0.7v-2.1h-2v2.1c-0.6 0.1-1.2 0.4-1.8 0.7l-1.5-1.5-1.4 1.4 1.5 1.5c-0.3 0.5-0.6 1.1-0.7 1.8h-2.1v2h2.1c0.1 0.6 0.4 1.2 0.7 1.8l-1.5 1.5 1.4 1.4 1.5-1.5c0.5 0.3 1.1 0.6 1.8 0.7v2.1h2v-2.1c0.6-0.1 1.2-0.4 1.8-0.7l1.5 1.5 1.4-1.4-1.5-1.5c0.3-0.5 0.6-1.1 0.7-1.8h2.1zm-7 2c-1.7 0-3-1.3-3-3s1.3-3 3-3 3 1.3 3 3-1.3 3-3 3z\"/><path d=\"M20,10h5.2C21.9,4.9,15.1,3.5,10,6.8c-3.1,2-5,5.5-5,9.2H3C3,8.8,8.8,3,16,3c3.9,0,7.5,1.7,10,4.7V4h2v8h-8V10z\"/><rect class=\"st0\" width=\"32\" height=\"32\"/></g></switch></svg>";
    private int severityItr = 1;

    public HTMLDetailAnalysisStreamlinedReportWriter(List<String> arrayOfProjects, String[] sourceOptions, String[] targetOptions, SortedMap<String, String> scanOptions, Map<String, Map<String, Map<String, List<String>>>> rulesAnalyzed, boolean formatByFile, AnalysisResults analysisResults, List<String> connectivityRulesAnalyzed, boolean showAllHelp, boolean allRulesLoaded, int maxUserDefinedRuleResults, Map<String, RuleInfo> ruleCosts) {
        super(arrayOfProjects, sourceOptions, targetOptions, scanOptions, null, rulesAnalyzed, formatByFile, null, connectivityRulesAnalyzed, null, null, true, null);
        this.showAllHelp = showAllHelp;
        this.allRulesLoaded = allRulesLoaded;
        this.analysisResults = analysisResults;
        this.helpContent = analysisResults.getMapOfHelpContent();
        this.helpLoaded = analysisResults.getHelpLoaded();
        this.moduleData = analysisResults.getModuleData();
        this.includeConnectivitySummary = analysisResults.includeConnectivitySummary();
        this.connectivityRuleToTableId = analysisResults.getConnectivityRules();
        this.hasResults = analysisResults.getTotalNumberOfResults() > 0;
        this.maxUserDefinedRuleResults = maxUserDefinedRuleResults;
        this.ruleCosts = ruleCosts;
    }

    private void buildHeader() {
        ReportUtility.writeHtmlTag(this.resultBuffer);
        ReportUtility.writeHeader(this.resultBuffer, Messages.getString("ANALYSIS_REPORT_HEADER"), Messages.getString("TECH_EVAL_REPORT_AUTHOR_BINARY_SCANNER"), false, 0);
        this.resultBuffer.append("<body id=\"top\" class=\"analyze\">\n");
        this.resultBuffer.append("  <div id=\"wrapper\" class=\"wrapper\" role=\"main\">\n");
        this.offsetOfJumpToRule = this.resultBuffer.length();
    }

    private void buildJumpToRule() {
        StringBuilder tempResultBuffer = new StringBuilder();
        tempResultBuffer.append("  <div class=\"nav-wrapper na-fixed noprint\" role=\"navigation\" aria-label=\"Report Navigation Menu\">\n");
        tempResultBuffer.append("    <nav class=\"jump-to-nav\" aria-label=\"Report Navigation Menu Links\">\n");
        tempResultBuffer.append("      <ul>\n");
        tempResultBuffer.append("        <li><a href=\"#\">");
        tempResultBuffer.append(Messages.getString("ANALYSIS_REPORT_JUMP_TO_RULE"));
        tempResultBuffer.append("<div class=\"scroll-bottom-caret show\">v</div></a>\n");
        tempResultBuffer.append("          <ul class=\"inner--list--hide\">\n");
        tempResultBuffer.append("            <li id=\"backToTopNav\"><a href=\"#top\" class=\"na-title jump-item\">");
        tempResultBuffer.append(Messages.getString("ANALYSIS_REPORT_BACK_TO_TOP"));
        tempResultBuffer.append("</a></li>\n");
        if (!this.formatByFile && this.hasResults) {
            tempResultBuffer.append("            <li><a href=\"#ruleSeveritySummary\" class=\"na-title jump-item\">");
            tempResultBuffer.append(Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_SUMMARY"));
            tempResultBuffer.append("</a></li>\n");
            if (this.includeConnectivitySummary) {
                tempResultBuffer.append("            <li><a href=\"#analyze_ConnectivitySummary\" class=\"na-title jump-item\">");
                tempResultBuffer.append(Messages.getString("ANALYSIS_REPORT_CONNECTIVITY_SUMMARY"));
                tempResultBuffer.append("</a></li>\n");
            }
            tempResultBuffer.append("            <li><a href=\"#detailResultsByRule\" class=\"na-title jump-item\">");
            tempResultBuffer.append(Messages.getString("ANALYSIS_REPORT_DETAILED_RESULTS_BY_RULE"));
            tempResultBuffer.append("</a></li>\n");
            int currentSeverity = 1;
            int currentCategory = 1;
            int totalRulesInCategory = 0;
            String severityString = "";
            SortedMap<RuleSeverity, SortedMap<String, TreeSet<AnalysisRule>>> mapOfSeverityToAnalysisRules = this.analysisResults.getMapOfSeverityToAnalysisRules();
            for (RuleSeverity sev : mapOfSeverityToAnalysisRules.keySet()) {
                SortedMap mapOfCategoriesToRule = (SortedMap)mapOfSeverityToAnalysisRules.get((Object)sev);
                switch (sev) {
                    case SEVERE: {
                        severityString = "<li><a href=\"#analyze_severity" + currentSeverity + "\" class=\"na-sub-title jump-item\">" + this.buildSevIcon(sev, true, "jump-to-" + RuleSeverity.SEVERE.toString() + "-title") + "<span class=\"center\">" + Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_SEVERE") + "</span></a></li>";
                        break;
                    }
                    case WARNING: {
                        severityString = "<li><a href=\"#analyze_severity" + currentSeverity + "\" class=\"na-sub-title jump-item\">" + this.buildSevIcon(sev, true, "jump-to-" + RuleSeverity.WARNING.toString() + "-title") + "<span class=\"center\">" + Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_WARNING") + "</span></a></li>";
                        break;
                    }
                    case INFO: {
                        severityString = "<li><a href=\"#analyze_severity" + currentSeverity + "\" class=\"na-sub-title jump-item\">" + this.buildSevIcon(sev, true, "jump-to-" + RuleSeverity.INFO.toString() + "-title") + "<span class=\"center\">" + Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_INFO") + "</span></a></li>";
                        break;
                    }
                    case NONE: {
                        severityString = "<li><a href=\"#analyze_severity" + currentSeverity + "\" class=\"na-sub-title jump-item\">" + Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_NONE") + "</a></li>";
                    }
                }
                tempResultBuffer.append(severityString);
                for (String cat : mapOfCategoriesToRule.keySet()) {
                    TreeSet rules = (TreeSet)mapOfCategoriesToRule.get(cat);
                    for (AnalysisRule rule : rules) {
                        totalRulesInCategory += rule.getResultSize();
                    }
                    tempResultBuffer.append("            <li><a href=\"#category").append(currentCategory).append("\" class=\"na-sub-sub-title jump-item\">").append(ReportUtility.encodeHTMLEntities(cat)).append(" (").append(totalRulesInCategory).append(")").append("</a></li>\n");
                    totalRulesInCategory = 0;
                    ++currentCategory;
                }
                ++currentSeverity;
            }
        }
        if (this.includeAdditionalRuleHelp) {
            tempResultBuffer.append("            <li><a href=\"#analyze_AdditionalRuleHelp\" class=\"na-title jump-item\">");
            tempResultBuffer.append(Messages.getString("ANALYSIS_REPORT_ADDITIONAL_RULE_HELP"));
            tempResultBuffer.append("</a></li>\n");
        }
        if (this.analysisResults.containsAutomatedFix()) {
            tempResultBuffer.append("            <li><a href=\"#jsAutomatedFixConfigurationTitle\" class=\"na-title jump-item\">");
            tempResultBuffer.append(Messages.getString("ANALYSIS_REPORT_AUTOMATED_FIX_CONFIGURATION"));
            tempResultBuffer.append("</a></li>\n");
        }
        tempResultBuffer.append("            <li><a href=\"#jsRulesAnalyzedTitle\" class=\"na-title jump-item\">");
        tempResultBuffer.append(Messages.getString("ANALYSIS_REPORT_RULES_ANALYZED"));
        tempResultBuffer.append("</a></li>\n");
        tempResultBuffer.append("          </ul> <!-- end of first tier drop down -->\n");
        tempResultBuffer.append("        </li>\n");
        tempResultBuffer.append("      </ul>\n");
        tempResultBuffer.append("    </nav>\n");
        tempResultBuffer.append("  </div>\n");
        this.resultBuffer.insert(this.offsetOfJumpToRule, tempResultBuffer.toString());
    }

    public void buildJavaScript() {
        String minifiedJS;
        String js = ReportUtility.loadFileAsString("/help/ruleinfo/appconversion/resources/externalHelp.js");
        if (js != null) {
            this.resultBuffer.append("<script type=\"text/javascript\"> \n");
            minifiedJS = ReportUtility.minifyJS(js);
            if (minifiedJS != null) {
                this.resultBuffer.append(minifiedJS);
            }
            this.resultBuffer.append("</script> \n");
        }
        if ((js = ReportUtility.getSharedJS()) != null) {
            this.resultBuffer.append("<script type=\"text/javascript\"> \n");
            minifiedJS = ReportUtility.minifyJS(js);
            if (minifiedJS != null) {
                this.resultBuffer.append(minifiedJS);
            }
            this.resultBuffer.append("</script> \n");
        }
        if ((js = ReportUtility.loadFileAsString("/resources/copyButton.js")) != null) {
            this.resultBuffer.append("<script type=\"text/javascript\">\n");
            minifiedJS = ReportUtility.minifyJS(js);
            if (minifiedJS != null) {
                this.resultBuffer.append(minifiedJS);
            }
            this.resultBuffer.append("</script>\n");
        }
    }

    protected void buildArchiveQuantities(StringBuilder sb, boolean consolidated) {
        sb.append(!consolidated ? "  <div class=\"recap\">\n" : "  <div class=\"recap recap-alternate\">\n");
        if (consolidated) {
            sb.append("<h2 id=\"analyze_Summary\" class=\"detailed-results-title\">").append(Messages.getString("ANALYSIS_REPORT_SUMMARY")).append("</h2>");
        }
        sb.append("<ul>\n");
        NumberFormat formatter = NumberFormat.getNumberInstance();
        String formattedRulesFlagged = formatter.format(this.analysisResults.getAnalysisRulesRanInReport());
        sb.append("      <li><p class=\"flash__numbers bolden cons-li-p\">").append(formattedRulesFlagged).append("</p><p class=\"cons-li-p\">").append(Messages.getString("ANALYSIS_REPORT_RULES_FLAGGED_NO_NUMBER")).append("</p></li>\n");
        String formattedNumResults = formatter.format(this.analysisResults.getTotalNumberOfResults());
        sb.append("      <li><p class=\"flash__numbers bolden cons-li-p\">").append(formattedNumResults).append("</p><p class=\"cons-li-p\">").append(Messages.getString("ANALYSIS_REPORT_TOTAL_RESULTS")).append("</p></li>\n");
        if (!consolidated) {
            String allScanOptions;
            sb.append("    <li>\n");
            if (!this.allRulesLoaded) {
                String allTargetOptions;
                String allSourceOptions = ReportUtility.getOptions(this.sourceOptions, true);
                if (allSourceOptions.length() > 0) {
                    sb.append("          <p class=\"courier\"><span class=\"scan_options\">").append(Messages.getString("ANALYSIS_REPORT_SOURCE_OPTIONS_LABEL")).append("</span><br/>").append(allSourceOptions).append("</p>\n");
                }
                if ((allTargetOptions = ReportUtility.getOptions(this.targetOptions, true)).length() > 0) {
                    sb.append("          <p class=\"courier\"><span class=\"scan_options\">").append(Messages.getString("ANALYSIS_REPORT_TARGET_OPTIONS_LABEL")).append("</span><br/>").append(allTargetOptions).append("</p>\n");
                }
            }
            if ((allScanOptions = ReportUtility.getOptions(this.scanOptions, true)).length() > 0) {
                sb.append("          <p class=\"courier\"><span class=\"scan_options\">").append(Messages.getString("ANALYSIS_REPORT_SCAN_OPTIONS_LABEL")).append("</span><br/>").append(allScanOptions).append("</p>\n");
            }
            String excludedPackages = ReportUtility.encodeHTMLEntities((String)this.scanOptions.get("excludePackages"));
            String includedPackages = ReportUtility.encodeHTMLEntities((String)this.scanOptions.get("includePackages"));
            String excludedFiles = ReportUtility.encodeHTMLEntities((String)this.scanOptions.get("excludeFiles"));
            String excludedRules = ReportUtility.encodeHTMLEntities((String)this.scanOptions.get("excludeRules"));
            if (excludedPackages != null) {
                sb.append("          <p class=\"courier\"><span class=\"scan_options\">").append(Messages.getString("ANALYSIS_REPORT_EXCLUDED_PACKAGES_LABEL")).append("</span><br/>").append(excludedPackages).append("</p>\n");
            }
            if (includedPackages != null) {
                sb.append("          <p class=\"courier\"><span class=\"scan_options\">").append(Messages.getString("ANALYSIS_REPORT_INCLUDED_PACKAGES_LABEL")).append("</span><br/>").append(includedPackages).append("</p>\n");
            }
            if (excludedFiles != null) {
                sb.append("          <p class=\"courier\"><span class=\"scan_options\">").append(Messages.getString("ANALYSIS_REPORT_EXCLUDED_FILES_LABEL")).append("--excludeRules=").append("</span><br/>").append(excludedFiles).append("</p>\n");
            }
            if (excludedRules != null && !excludedRules.isEmpty()) {
                sb.append("          <p class=\"courier\"><span class=\"scan_options\">").append(Messages.getString("ANALYSIS_REPORT_EXCLUDED_RULES_LABEL")).append("</span><br/>").append(excludedRules).append("</p>\n");
            }
            sb.append("    </li>\n");
        }
        sb.append("    </ul>\n");
        sb.append("  </div>\n");
    }

    private void buildSummary() {
        this.resultBuffer.append("    <h1>");
        this.resultBuffer.append(Messages.getString("ANALYSIS_REPORT_HEADER"));
        this.resultBuffer.append("</h1>\n");
        this.buildGeneratedOn();
        this.buildArchiveQuantities(this.resultBuffer, false);
        this.buildRuleSeveritySummary(this.resultBuffer, false);
        this.offsetOfSummary = this.resultBuffer.length();
    }

    protected String buildConnectivitySummary() {
        if (this.includeConnectivitySummary) {
            int numConnectivityRules = this.connectivityRulesAnalyzed.size();
            int[] allResults = new int[numConnectivityRules];
            String[] connectivityRuleDescs = new String[numConnectivityRules];
            int i = 0;
            while (i < numConnectivityRules) {
                connectivityRuleDescs[i] = (String)this.connectivityRulesAnalyzed.get(i);
                ++i;
            }
            List<String> sortedModuleNames = this.moduleData.getSortedModuleNames();
            int numberOfModules = sortedModuleNames.size();
            boolean foundResults = false;
            StringBuilder tempResultBufferModuleSummaries = new StringBuilder();
            int mainModuleNumber = 1;
            while (mainModuleNumber <= numberOfModules) {
                String moduleName = sortedModuleNames.get(mainModuleNumber - 1);
                String moduleId = "rowHiddenMod" + mainModuleNumber + "-";
                int totalNumberOfHiddenRows = 1;
                String[] firstModuleWithResults = new String[numConnectivityRules];
                ModuleHierarchy mh = this.moduleData.getModuleHierarchy(moduleName);
                int[] resultsIncludingChildren = mh.getResultsPerRuleIncludingChildren();
                int[] resultsThisModule = mh.getResultsPerRuleThisModule();
                StringBuilder tempResultBufferModuleHiddenRows = new StringBuilder();
                tempResultBufferModuleHiddenRows.append("<tr class=\"hiddenRow\" id=\"").append(moduleId).append(totalNumberOfHiddenRows).append("\">\n");
                tempResultBufferModuleHiddenRows.append("<td class=\"col1main\">").append(ReportUtility.encodeHTMLEntities(mh.getDisplayModuleName())).append("</td>\n");
                int i2 = 0;
                while (i2 < resultsThisModule.length) {
                    if (resultsThisModule[i2] > 0) {
                        String href = String.valueOf(this.connectivityRuleToTableId.get(connectivityRuleDescs[i2]).getRuleId()) + "-" + moduleName;
                        if (firstModuleWithResults[i2] == null) {
                            firstModuleWithResults[i2] = href;
                        }
                        tempResultBufferModuleHiddenRows.append("<td class=\"col2thru12\"><a href=\"#analyze_").append(ReportUtility.encodeHTMLEntities(href)).append("\">").append(resultsThisModule[i2]).append("</a></td>\n");
                    } else {
                        tempResultBufferModuleHiddenRows.append("<td class=\"col2thru12\"></td>\n");
                    }
                    ++i2;
                }
                tempResultBufferModuleHiddenRows.append("</tr>\n");
                List<String> sortedChildren = mh.getSortedChildren();
                for (String child : sortedChildren) {
                    ModuleHierarchy childMh = mh.getChild(child);
                    int[] childResults = childMh.getResultsPerRuleThisModule();
                    tempResultBufferModuleHiddenRows.append("<tr class=\"hiddenRow\" id=\"").append(moduleId).append(++totalNumberOfHiddenRows).append("\">\n");
                    tempResultBufferModuleHiddenRows.append("<td class=\"col1child\">  ").append(ReportUtility.encodeHTMLEntities(childMh.getDisplayModuleName())).append("</td>\n");
                    int i3 = 0;
                    while (i3 < childResults.length) {
                        if (childResults[i3] > 0) {
                            String href = String.valueOf(this.connectivityRuleToTableId.get(connectivityRuleDescs[i3]).getRuleId()) + "-" + child;
                            if (firstModuleWithResults[i3] == null) {
                                firstModuleWithResults[i3] = href;
                            }
                            tempResultBufferModuleHiddenRows.append("<td class=\"col2thru12\"><a href=\"#analyze_").append(ReportUtility.encodeHTMLEntities(href)).append("\">").append(childResults[i3]).append("</a></td>\n");
                        } else {
                            tempResultBufferModuleHiddenRows.append("<td class=\"col2thru12\"></td>\n");
                        }
                        ++i3;
                    }
                    tempResultBufferModuleHiddenRows.append("</tr>\n");
                    List<String> sortedGrandChildren = childMh.getSortedChildren();
                    for (String grandChild : sortedGrandChildren) {
                        ModuleHierarchy grandChildMh = childMh.getChild(grandChild);
                        int[] grandChildResults = grandChildMh.getResultsPerRuleIncludingChildren();
                        tempResultBufferModuleHiddenRows.append("<tr class=\"hiddenRow\" id=\"").append(moduleId).append(++totalNumberOfHiddenRows).append("\">\n");
                        tempResultBufferModuleHiddenRows.append("<td class=\"col1grandchild\">    ").append(ReportUtility.encodeHTMLEntities(grandChildMh.getDisplayModuleName())).append("</td>\n");
                        int i4 = 0;
                        while (i4 < grandChildResults.length) {
                            if (grandChildResults[i4] > 0) {
                                String href = String.valueOf(this.connectivityRuleToTableId.get(connectivityRuleDescs[i4]).getRuleId()) + "-" + grandChild;
                                if (firstModuleWithResults[i4] == null) {
                                    firstModuleWithResults[i4] = href;
                                }
                                tempResultBufferModuleHiddenRows.append("<td class=\"col2thru12\"><a href=\"#analyze_").append(ReportUtility.encodeHTMLEntities(href)).append("\">").append(grandChildResults[i4]).append("</a></td>\n");
                            } else {
                                tempResultBufferModuleHiddenRows.append("<td class=\"col2thru12\"></td>\n");
                            }
                            ++i4;
                        }
                        tempResultBufferModuleHiddenRows.append("</tr>\n");
                    }
                }
                tempResultBufferModuleSummaries.append("<tr class=\"summary\">");
                tempResultBufferModuleSummaries.append("<td class=\"col1summarymodule\"><span class=\"status\">&#43;</span> ").append(ReportUtility.encodeHTMLEntities(mh.getDisplayModuleName())).append("</td>\n");
                int i5 = 0;
                while (i5 < resultsIncludingChildren.length) {
                    allResults[i5] = allResults[i5] + resultsIncludingChildren[i5];
                    if (resultsIncludingChildren[i5] > 0) {
                        foundResults = true;
                        tempResultBufferModuleSummaries.append("<td class=\"col2thru12\"><a href=\"#analyze_").append(ReportUtility.encodeHTMLEntities(firstModuleWithResults[i5])).append("\"><b>").append(resultsIncludingChildren[i5]).append("</b></a></td>\n");
                    } else {
                        tempResultBufferModuleSummaries.append("<td class=\"col2thru12\"></td>\n");
                    }
                    ++i5;
                }
                tempResultBufferModuleSummaries.append("</tr>\n");
                tempResultBufferModuleSummaries.append((CharSequence)tempResultBufferModuleHiddenRows);
                ++mainModuleNumber;
            }
            StringBuilder tempResultBuffer = new StringBuilder();
            tempResultBuffer.append("<div class=\"header-sections list-header\">");
            tempResultBuffer.append("<h2 id=\"analyze_ConnectivitySummary\" class=\"detailed-results-title\">").append(Messages.getString("ANALYSIS_REPORT_CONNECTIVITY_SUMMARY")).append("</h2>\n");
            tempResultBuffer.append("</div>\n");
            if (foundResults) {
                tempResultBuffer.append("<div class=\"connectivity-summary\">\n");
                tempResultBuffer.append("<table summary=\"").append(Messages.getString("ANALYSIS_REPORT_CONNECTIVITY_SUMMARY_DESCRIPTION")).append("\">\n");
                tempResultBuffer.append("<caption>").append(Messages.getString("ANALYSIS_REPORT_CONNECTIVITY_CAPTION_DESCRIPTION")).append("</caption>\n");
                tempResultBuffer.append("<thead>\n");
                tempResultBuffer.append("<tr class=\"results\"> \n");
                tempResultBuffer.append("<th class=\"col1module\"></th>\n");
                int i6 = 0;
                while (i6 < numConnectivityRules) {
                    if (allResults[i6] > 0) {
                        tempResultBuffer.append("<th class=\"col2thru12\"><a href=\"#analyze_").append(ReportUtility.encodeHTMLEntities(this.connectivityRuleToTableId.get(connectivityRuleDescs[i6]).getRuleId())).append("\">").append(ReportUtility.encodeHTMLEntities(connectivityRuleDescs[i6])).append("</a></th>\n");
                    } else {
                        tempResultBuffer.append("<th class=\"col2thru12\">").append(ReportUtility.encodeHTMLEntities(connectivityRuleDescs[i6])).append("</th>\n");
                    }
                    ++i6;
                }
                tempResultBuffer.append("</tr>\n");
                tempResultBuffer.append("</thead>\n");
                tempResultBuffer.append("<tbody>\n");
                tempResultBuffer.append((CharSequence)tempResultBufferModuleSummaries);
                tempResultBuffer.append("</tbody>\n");
                tempResultBuffer.append("</table>\n");
                tempResultBuffer.append("</div>\n");
            } else {
                tempResultBuffer.append("<p>").append(Messages.getString("ANALYSIS_REPORT_CONNECTIVITY_SUMMARY_NO_RESULTS")).append("</p>\n");
            }
            return tempResultBuffer.toString();
        }
        return null;
    }

    public String buildSevIcon(RuleSeverity sev, boolean generateSmallIcon, String svgId) {
        StringBuilder sb = new StringBuilder();
        if (RuleSeverity.NONE != sev) {
            String svgClass;
            String severityClass = this.getCSSClassForSeverity(sev);
            String string = svgClass = generateSmallIcon ? "class=\"center svg-small\"" : "class=\"center svg\"";
            if (!severityClass.isEmpty()) {
                svgClass = svgClass.replaceAll("\"$", " " + severityClass + "\"");
            }
            sb.append("<svg ").append(svgClass).append(" aria-labelledby=\"").append(ReportUtility.encodeHTMLEntities(svgId)).append("\" viewBox=\"0 0 32 32\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n");
            sb.append("<title id=\"").append(ReportUtility.encodeHTMLEntities(svgId)).append("\">").append(sev.getTranslatableLabel()).append("</title>\n");
            sb.append("<desc>").append(sev.getDesc()).append("</desc>\n");
            switch (sev) {
                case SEVERE: {
                    sb.append("<defs>\n");
                    sb.append("<style> .cls-critical { fill: #da1e28; } </style>\n");
                    sb.append("</defs>\n");
                    sb.append("<g>\n");
                    sb.append("<path d=\"M16,2A13.91,13.91,0,0,0,2,16,13.91,13.91,0,0,0,16,30,13.91,13.91,0,0,0,30,16,13.91,13.91,0,0,0,16,2Zm5.4,21L9,10.6,10.6,9,23,21.4Z\" class=\"cls-critical\" />\n");
                    sb.append("<path d=\"M21.4,23,9,10.6,10.6,9,23,21.4Z\" fill=\"none\" />\n");
                    sb.append("</g>\n");
                    break;
                }
                case WARNING: {
                    sb.append("<g>\n");
                    sb.append("<path d=\"M29.89,28.07,17.06,3a1,1,0,0,0-1.35-.41,1,1,0,0,0-.41.4L2.13,27.88a1,1,0,0,0,0,1,1,1,0,0,0,.88.49l26,.18a1,1,0,0,0,.86-.49A1,1,0,0,0,29.89,28.07Z\" fill=\"#f1c21b\"/>\n");
                    sb.append("<path d=\"M15,10.45l2.25,0-.07,10-2.25,0Zm1,16A1.5,1.5,0,1,1,17.53,25,1.5,1.5,0,0,1,16,26.46Zm-1-16,2.25,0-.07,10-2.25,0Zm1,16A1.5,1.5,0,1,1,17.53,25,1.5,1.5,0,0,1,16,26.46Z\" fill=\"#161616\"/>\n");
                    sb.append("</g>\n");
                    break;
                }
                case INFO: {
                    sb.append("<defs>\n");
                    sb.append("<style> .cls-info { fill: #0f62fe; } </style>\n");
                    sb.append("</defs>\n");
                    sb.append("<path d=\"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM16.14,8.29a1.29,1.29,0,0,1,0,2.57,1.29,1.29,0,1,1,0-2.57ZM19.57,23H12.71V21h2.47V15.25H13.57V13.33H17.1V21h2.47Z\" class=\"cls-info\"/>\n");
                }
            }
            sb.append("</svg>\n");
        }
        return sb.toString();
    }

    private String getCSSClassForSeverity(RuleSeverity severity) {
        switch (severity) {
            case SEVERE: {
                return "critical-icon";
            }
            case WARNING: {
                return "warning-icon";
            }
            case INFO: {
                return "info-icon";
            }
        }
        return "";
    }

    protected void buildResultsByRule(StringBuilder sb) {
        if (this.hasResults || this.showAllHelp) {
            int currentSeverity = 1;
            int currentCategory = 1;
            SortedMap<RuleSeverity, SortedMap<String, TreeSet<AnalysisRule>>> mapOfSeverityToAnalysisRules = this.analysisResults.getMapOfSeverityToAnalysisRules();
            for (RuleSeverity severity : mapOfSeverityToAnalysisRules.keySet()) {
                SortedMap mapOfCategoryToRules = (SortedMap)mapOfSeverityToAnalysisRules.get((Object)severity);
                String severityLabel = RuleSeverity.SEVERE == severity ? Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_SEVERE") : (RuleSeverity.WARNING == severity ? Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_WARNING") : (RuleSeverity.INFO == severity ? Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_INFO") : ""));
                sb.append("<div class=\"detailed-results-by-severity\">\n");
                sb.append("<div class=\"detailed-results-header\">\n");
                sb.append("<h2 class=\"detailed-results-title\" id=\"analyze_severity").append(currentSeverity).append("\">").append(severityLabel).append("</h2>");
                sb.append("</div>");
                sb.append("<div class=\"detailed-results-by-rule\">");
                for (String category : mapOfCategoryToRules.keySet()) {
                    TreeSet rulesBySeverity = (TreeSet)mapOfCategoryToRules.get(category);
                    sb.append("<p>\n");
                    sb.append("<span class=\"rule-category\" id=\"category");
                    sb.append(currentCategory);
                    sb.append("\">\n");
                    sb.append(ReportUtility.encodeHTMLEntities(category));
                    sb.append("</span>");
                    sb.append("</p>");
                    sb.append("  <ul class=\"rules\">\n");
                    for (AnalysisRule rule : rulesBySeverity) {
                        int resultSize = rule.getResultSize();
                        boolean ruleHasResults = resultSize > 0;
                        String desc = ReportUtility.getRuleNameForHTML(rule.getRuleName());
                        String thisHelpContent = null;
                        String ruleId = rule.getRuleId();
                        String helpId = rule.getHelpId();
                        String helpFileName = rule.getHelpFileName();
                        RuleInfo costEntry = (RuleInfo)this.ruleCosts.get(ruleId);
                        String devCost = "undefined";
                        String instanceCost = "undefined";
                        if (costEntry != null) {
                            devCost = this.formatCost(Float.valueOf(costEntry.devCost));
                            instanceCost = this.formatCost(Float.valueOf(costEntry.instanceCost));
                        }
                        if (rule.hasRecipe()) {
                            if ((double)Float.parseFloat(devCost) > 0.1) {
                                devCost = "0.1";
                            }
                            instanceCost = "0";
                        }
                        if (helpFileName != null) {
                            thisHelpContent = !this.helpLoaded.contains(helpFileName) ? rule.getHelpContent() : (String)this.helpContent.get(helpId);
                        }
                        StringBuffer tempResultBuffer = new StringBuffer();
                        String ruleName = rule.getRuleName();
                        if (ruleHasResults) {
                            this.buildRuleResultsTable(tempResultBuffer, ruleName, rule, ruleId);
                        }
                        String svgID = String.valueOf(ruleName.toLowerCase().replace(' ', '-').replaceAll("\"", "&quot;")) + "-" + severity.toString() + "-title";
                        sb.append("    <li id=\"analyze_").append(ReportUtility.encodeHTMLEntities(ruleId)).append("\" data-dev-cost=\"").append(devCost).append("\" data-instance-cost=\"").append(instanceCost).append("\" class=\"rule\">\n");
                        sb.append("      <div class=\"rule-title\">");
                        if (rule.hasRecipe()) {
                            sb.append("        <h3>").append(this.buildSevIcon(severity, false, svgID)).append(String.format(AUTOMATED_FIX_SVG, "center svg")).append("<span class=\"center\">").append(desc).append(" <em>(").append(resultSize).append(")</em></span></h3>\n");
                        } else {
                            sb.append("        <h3>").append(this.buildSevIcon(severity, false, svgID)).append("<span class=\"center\">").append(desc).append(" <em>(").append(resultSize).append(")</em></span></h3>\n");
                        }
                        sb.append("        <div class=\"js-toggle-actions noprint\">\n");
                        sb.append("          <a href=\"#\" class=\"recommendation-toggle-help rule-help-toggle\">").append(Messages.getString("ANALYSIS_REPORT_SHOW_RULE_HELP")).append("</a>\n");
                        if (ruleHasResults) {
                            sb.append("          <a href=\"#\" class=\"recommendation-toggle-results results-toggle\">").append(Messages.getString("ANALYSIS_REPORT_SHOW_RESULTS")).append("</a>\n");
                        }
                        sb.append("        </div>\n");
                        sb.append("      </div>\n");
                        if (thisHelpContent != null) {
                            if (this.helpWritten.contains(helpId)) {
                                sb.append("      <div class=\"rule-fix shared hide\">\n");
                            } else {
                                this.helpWritten.add(helpId);
                                sb.append("      <div id=\"").append(ReportUtility.encodeHTMLEntities(helpId)).append("\" class=\"rule-fix shared hide\">\n");
                            }
                            sb.append("        <h3>").append(Messages.getString("ANALYSIS_REPORT_HELP_BY_RULE")).append("</h3>\n");
                            int indexOfEndOfTitle = thisHelpContent.indexOf("</h3>");
                            if (indexOfEndOfTitle > -1) {
                                String helpContentWithoutTitle = thisHelpContent.substring(indexOfEndOfTitle + "</h3>".length());
                                sb.append(helpContentWithoutTitle);
                            } else {
                                sb.append(thisHelpContent);
                            }
                            sb.append("      </div>\n");
                        } else {
                            sb.append("      <div class=\"rule-fix shared hide\">\n");
                            sb.append("        <h3>").append(Messages.getString("ANALYSIS_REPORT_HELP_BY_RULE")).append("</h3>\n");
                            sb.append("      <p>").append(Messages.getString("ANALYSIS_REPORT_HELP_FOR_CUSTOM_RULE")).append("</p>\n");
                            sb.append("      </div>\n");
                        }
                        if (ruleHasResults) {
                            sb.append("      <div class=\"rule-result hide\">\n");
                            sb.append("        <h3>").append(Messages.getString("ANALYSIS_REPORT_RESULTS")).append("</h3>\n");
                            sb.append(tempResultBuffer);
                            sb.append("      </div>\n");
                        }
                        sb.append("    </li>\n");
                    }
                    sb.append("  </ul>\n");
                    ++currentCategory;
                }
                sb.append("</div>");
                sb.append("</div>\n");
                ++currentSeverity;
            }
        }
    }

    private int buildRuleResultsTable(StringBuffer tableResultBuffer, String desc, AnalysisRule rule, String ruleID) {
        SortedMap<String, TreeSet<DetailResult>> mapOfFileNameToResults = rule.getResults();
        String descWithDash = desc.replace(' ', '-');
        String fileNameColumnID = "file_" + descWithDash;
        String referenceColumnID = "ref_" + descWithDash;
        String criteriaColumnID = "criteria_" + descWithDash;
        String lineColumnID = "line_" + descWithDash;
        int numberOfResults = 0;
        tableResultBuffer.append("<table summary=\"").append(Messages.getString("ANALYSIS_REPORT_TABLE_RULE_RESULTS")).append("\">\n");
        tableResultBuffer.append("<thead>\n");
        tableResultBuffer.append("  <tr>\n");
        tableResultBuffer.append("    <th id=\"").append(ReportUtility.encodeHTMLEntities(fileNameColumnID)).append("\">").append(Messages.getString("ANALYSIS_REPORT_TABLE_FILE_NAME")).append("</th>\n");
        tableResultBuffer.append("    <th id=\"").append(ReportUtility.encodeHTMLEntities(referenceColumnID)).append("\">").append(Messages.getString("ANALYSIS_REPORT_TABLE_REFERENCE_DETAILS")).append("</th>\n");
        tableResultBuffer.append("    <th id=\"").append(ReportUtility.encodeHTMLEntities(criteriaColumnID)).append("\">").append(Messages.getString("ANALYSIS_REPORT_MATCH_CRITERIA")).append("</th>\n");
        tableResultBuffer.append("    <th id=\"").append(ReportUtility.encodeHTMLEntities(lineColumnID)).append("\">").append(Messages.getString("ANALYSIS_REPORT_TABLE_LINE_NUMBER")).append("</th>\n");
        tableResultBuffer.append("  </tr>\n");
        tableResultBuffer.append("</thead>\n");
        tableResultBuffer.append("<tbody>\n");
        int indexOfConnectivityRule = this.includeConnectivitySummary ? this.connectivityRulesAnalyzed.indexOf(desc) : -1;
        int totalNumberOfOccurrences = 0;
        boolean maxUserDefinedRuleResultsExceeded = false;
        StringBuilder moduleReferenceContent = new StringBuilder();
        StringBuilder colspanRow = new StringBuilder();
        StringBuilder row = new StringBuilder();
        String prevMinusModuleName = null;
        for (String colspanFileName : mapOfFileNameToResults.keySet()) {
            boolean skippedFile = false;
            if (this.maxUserDefinedRuleResults != -1 && rule.getRuleId().startsWith("userDefined_") && totalNumberOfOccurrences >= this.maxUserDefinedRuleResults) {
                skippedFile = true;
                maxUserDefinedRuleResultsExceeded = true;
            }
            prevMinusModuleName = colspanFileName;
            boolean hasResultAtColspanRow = false;
            TreeSet results = (TreeSet)mapOfFileNameToResults.get(colspanFileName);
            String moduleReference = String.valueOf(ruleID) + "-" + colspanFileName.replace(' ', '-');
            String listID = "analyze_" + moduleReference;
            for (DetailResult result : results) {
                if (this.maxUserDefinedRuleResults != -1 && rule.getRuleId().startsWith("userDefined_") && totalNumberOfOccurrences >= this.maxUserDefinedRuleResults) {
                    totalNumberOfOccurrences += result.getNumberOfOccurrences();
                    maxUserDefinedRuleResultsExceeded = true;
                    continue;
                }
                String resultLocation = result.getFileName();
                if (!resultLocation.equals(colspanFileName)) {
                    row.append("<tr>\n");
                    String fileNameMinusModuleName = resultLocation.substring(colspanFileName.length() + 1);
                    String fileNameCol = !prevMinusModuleName.equals(fileNameMinusModuleName) ? "<td class=\"indentFileName\" headers=\"" + ReportUtility.encodeHTMLEntities(fileNameColumnID) + " " + ReportUtility.encodeHTMLEntities(listID) + "\">" + ReportUtility.encodeHTMLEntities(fileNameMinusModuleName) + "</td>\n" : "<td headers=\"" + ReportUtility.encodeHTMLEntities(listID) + "\"></td>";
                    row.append(fileNameCol);
                    prevMinusModuleName = fileNameMinusModuleName;
                } else {
                    row.append("<tr>\n");
                    String fileNameCol = prevMinusModuleName.equals(colspanFileName) ? "<td class=\"indentFileName\" headers=\"" + ReportUtility.encodeHTMLEntities(fileNameColumnID) + " " + ReportUtility.encodeHTMLEntities(listID) + "\"><b>" + ReportUtility.encodeHTMLEntities(colspanFileName) + "</b></td>\n" : "<td headers=\"" + ReportUtility.encodeHTMLEntities(listID) + "\"></td>";
                    row.append(fileNameCol);
                }
                String criteria = result.getCriteria();
                String ref = result.getReference();
                if (ref != null && (ref.contains("<") || ref.contains(">"))) {
                    ref = ref.replace("<", "&lt;");
                    ref = ref.replace(">", "&gt;");
                }
                if (criteria != null && (criteria.contains("<") || criteria.contains(">"))) {
                    criteria = criteria.replace("<", "&lt;");
                    criteria = criteria.replace(">", "&gt;");
                }
                int numOccurrences = result.getNumberOfOccurrences();
                totalNumberOfOccurrences += numOccurrences;
                String refDetails = numOccurrences > 1 ? Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_REFERENCE_AND_OCCURRENCES"), ref, numOccurrences) : (ref != null ? ref : "");
                row.append("<td headers=\"").append(ReportUtility.encodeHTMLEntities(referenceColumnID)).append(" ").append(ReportUtility.encodeHTMLEntities(listID)).append("\">").append(refDetails).append("</td>\n");
                if (criteria != null && criteria.contains("\"")) {
                    row.append("<td headers=\"").append(ReportUtility.encodeHTMLEntities(criteriaColumnID)).append(" ").append(ReportUtility.encodeHTMLEntities(listID)).append("\">").append(criteria.replace("\"", "")).append("</td>\n");
                } else {
                    row.append("<td headers=\"").append(ReportUtility.encodeHTMLEntities(criteriaColumnID)).append(" ").append(ReportUtility.encodeHTMLEntities(listID)).append("\">").append(criteria).append("</td>\n");
                }
                int lineNumber = result.getLineNumber();
                if (lineNumber > 0) {
                    row.append("<td headers=\"").append(ReportUtility.encodeHTMLEntities(lineColumnID)).append(" ").append(ReportUtility.encodeHTMLEntities(listID)).append("\">").append(lineNumber).append("</td>\n");
                } else {
                    row.append("<td headers=\"").append(ReportUtility.encodeHTMLEntities(lineColumnID)).append(" ").append(ReportUtility.encodeHTMLEntities(listID)).append("\"></td>\n");
                }
                row.append("</tr>\n");
                if (!row.toString().contains("data-header")) {
                    moduleReferenceContent.append((CharSequence)row);
                } else {
                    colspanRow.append((CharSequence)row);
                }
                row.setLength(0);
                if (indexOfConnectivityRule <= -1 || totalNumberOfOccurrences <= 0) continue;
                this.moduleData.addModulesForFileNameWithOccurrences(resultLocation, numOccurrences, indexOfConnectivityRule);
            }
            if (!skippedFile) {
                if (!hasResultAtColspanRow) {
                    tableResultBuffer.append("<tr class=\"header-archive\">\n");
                    tableResultBuffer.append("<th id=\"").append(ReportUtility.encodeHTMLEntities(listID)).append("\" colspan=\"4\">").append("<b>").append(ReportUtility.encodeHTMLEntities(colspanFileName)).append("</b></th>\n");
                    tableResultBuffer.append("</tr>\n");
                } else {
                    tableResultBuffer.append((CharSequence)colspanRow);
                    colspanRow.setLength(0);
                }
                tableResultBuffer.append((CharSequence)moduleReferenceContent);
            }
            moduleReferenceContent.setLength(0);
        }
        if (maxUserDefinedRuleResultsExceeded) {
            tableResultBuffer.append("<tr class=\"header-archive\">\n");
            tableResultBuffer.append("<th id=\"maxUserDefinedRuleResultsExceeded\" colspan=\"4\"><b>").append(Messages.getFormattedMessage(Messages.getString("User_Defined_Rules_Max_Results_Exceeded"), this.maxUserDefinedRuleResults, totalNumberOfOccurrences)).append("</b></th>\n");
            tableResultBuffer.append("</tr>\n");
        }
        tableResultBuffer.append("</tbody>\n");
        tableResultBuffer.append("</table>\n");
        return numberOfResults;
    }

    protected boolean buildAdditionalHelp(StringBuilder sb, boolean consolidated) {
        StringBuilder tempHelpBuffer = new StringBuilder();
        Set<String> helpIdKeys = this.helpContent.keySet();
        for (String nextHelpId : helpIdKeys) {
            if (this.helpWritten.contains(nextHelpId)) continue;
            String thisHelpContent = (String)this.helpContent.get(nextHelpId);
            tempHelpBuffer.append("      <div id=\"").append(ReportUtility.encodeHTMLEntities(nextHelpId)).append("\" class=\"rule-additional-help shared\">\n");
            tempHelpBuffer.append(thisHelpContent);
            tempHelpBuffer.append("      </div>\n");
        }
        if (tempHelpBuffer.length() > 0) {
            this.includeAdditionalRuleHelp = true;
            sb.append(!consolidated ? "<div class=\"detailed-results-header header-sections\">\n" : "<div class=\"detailed-results-header header-sections horizontal-breaks\">\n");
            sb.append("  <h2 id=\"analyze_AdditionalRuleHelp\" class=\"detailed-results-title\">").append(Messages.getString("ANALYSIS_REPORT_ADDITIONAL_RULE_HELP")).append("</h2>\n");
            sb.append("</div>\n");
            sb.append("<div>\n");
            sb.append((CharSequence)tempHelpBuffer);
            sb.append("</div>\n");
        }
        return this.includeAdditionalRuleHelp;
    }

    protected void buildRuleSeveritySummary(StringBuilder sb, boolean isConsolidated) {
        if (this.hasResults) {
            String automated_svg_class = "center svg-small";
            if (!isConsolidated) {
                sb.append("<div id=\"ruleSeveritySummary\" class=\"detailed-results-header header-sections\">\n");
                sb.append("  <h2 class=\"detailed-results-title\">").append(Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_SUMMARY")).append("</h2>\n");
                sb.append("</div>\n");
            }
            sb.append("<div id=\"js-rule-severity\" class=\"rule-severity-summary\">\n");
            sb.append("<div class=\"rule-severity\">\n");
            sb.append("<table summary=\"").append(Messages.getString("ANALYSIS_REPORT_TABLE_RULE_SEVERITY_SUMMARY")).append("\">\n");
            sb.append("<thead>\n");
            sb.append("  <tr>\n");
            sb.append("    <th class=\"center\">").append(Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_SYMBOL")).append("</th>\n");
            sb.append("    <th class=\"severity-label\">").append(Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_LABEL")).append("</th>\n");
            sb.append("    <th class=\"center\">").append(Messages.getString("ANALYSIS_REPORT_RULES_FLAGGED_NO_NUMBER")).append("</th>\n");
            sb.append("    <th class=\"center\">").append(Messages.getString("ANALYSIS_REPORT_TOTAL_RESULTS")).append("</th>\n");
            sb.append("    <th class=\"center\">").append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_RULES_WITH_RECIPE"), String.format(AUTOMATED_FIX_SVG, automated_svg_class))).append("</th>\n");
            sb.append("    <th class=\"center\">").append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_RECIPE_OCCURRENCES"), String.format(AUTOMATED_FIX_SVG, automated_svg_class))).append("</th>\n");
            sb.append("    <th>").append(Messages.getString("ANALYSIS_REPORT_RULE_SEVERITY_DESCRIPTION")).append("</th>\n");
            sb.append("  </tr>\n");
            sb.append("</thead>\n");
            sb.append("<tbody>\n");
            this.addRuleSeveritySection(sb, this.buildSevIcon(RuleSeverity.SEVERE, false, "summary-" + RuleSeverity.SEVERE.toString() + "-title"), RuleSeverity.SEVERE, this.analysisResults.getSeverityRuleCount(RuleSeverity.SEVERE), this.analysisResults.getSeverityResultCount(RuleSeverity.SEVERE), this.analysisResults.getSeverityRecipeCount(RuleSeverity.SEVERE), this.analysisResults.getSeverityRecipeResultCount(RuleSeverity.SEVERE));
            this.addRuleSeveritySection(sb, this.buildSevIcon(RuleSeverity.WARNING, false, "summary-" + RuleSeverity.WARNING.toString() + "-title"), RuleSeverity.WARNING, this.analysisResults.getSeverityRuleCount(RuleSeverity.WARNING), this.analysisResults.getSeverityResultCount(RuleSeverity.WARNING), this.analysisResults.getSeverityRecipeCount(RuleSeverity.WARNING), this.analysisResults.getSeverityRecipeResultCount(RuleSeverity.WARNING));
            this.addRuleSeveritySection(sb, this.buildSevIcon(RuleSeverity.INFO, false, "summary-" + RuleSeverity.INFO.toString() + "-title"), RuleSeverity.INFO, this.analysisResults.getSeverityRuleCount(RuleSeverity.INFO), this.analysisResults.getSeverityResultCount(RuleSeverity.INFO), this.analysisResults.getSeverityRecipeCount(RuleSeverity.INFO), this.analysisResults.getSeverityRecipeResultCount(RuleSeverity.INFO));
            this.addRuleSeveritySection(sb, "", RuleSeverity.NONE, this.analysisResults.getSeverityRuleCount(RuleSeverity.NONE), this.analysisResults.getSeverityResultCount(RuleSeverity.NONE), this.analysisResults.getSeverityRecipeCount(RuleSeverity.NONE), this.analysisResults.getSeverityRecipeResultCount(RuleSeverity.NONE));
            sb.append("</tbody>\n");
            sb.append("</table>\n");
            sb.append("</div>\n");
            sb.append("</div>\n");
            sb.append("<div class=\"summary-tooltip\">").append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_AUTOMATED_FIX_CONFIGURATION_DESC"), String.format(AUTOMATED_FIX_SVG, automated_svg_class))).append("</div>");
        }
    }

    private void addRuleSeveritySection(StringBuilder sb, String symbol, RuleSeverity sev, int numRules, int numResults, int numRecipes, int numRecipeResults) {
        if (numRules > 0) {
            sb.append("<tr>\n");
            sb.append("<td>").append(symbol).append("</td>\n");
            sb.append("<td class=\"severity-label\">");
            sb.append("<a class=\"blueAnchor jump-item\" href=\"#analyze_severity").append(this.severityItr).append("\">").append(sev.getTranslatableLabel()).append("</a>");
            sb.append("</td>\n");
            sb.append("<td class=\"center\">").append(numRules).append("</td>\n");
            sb.append("<td class=\"center\">").append(numResults).append("</td>\n");
            sb.append("<td class=\"center\">").append(numRecipes).append("</td>\n");
            sb.append("<td class=\"center\">").append(numRecipeResults).append("</td>\n");
            sb.append("<td>").append(sev.getDesc()).append("</td>\n");
            sb.append("</tr>\n");
            ++this.severityItr;
        }
    }

    protected void buildAutomatedFixConfiguration(StringBuilder sb, boolean consolidated) {
        sb.append(!consolidated ? "<div id=\"jsAutomatedFixConfigurationTitle\" class=\"detailed-results-header header-sections\" role=\"complementary\" aria-labelledby=\"analyze_AutomatedFixConfiguration\">\n" : "<div id=\"jsAutomatedFixConfiguration\" class=\"detailed-results-header header-sections horizontal-breaks\" role=\"complementary\" aria-labelledby=\"analyze_AutomatedFixConfiguration\" aria-label=\"Automated Fix Configuration Title\">\n");
        sb.append("  <h2 id=\"analyze_AutomatedFixConfiguration\" class=\"detailed-results-title\">").append(Messages.getString("ANALYSIS_REPORT_AUTOMATED_FIX_CONFIGURATION")).append("</h2>\n");
        sb.append("  <div class=\"maven-gradle-holder noprint\">\n");
        sb.append("    <a href=\"#\" class=\"maven-config disabled\">").append(Messages.getString("ANALYSIS_REPORT_MAVEN")).append("</a>\n");
        sb.append("    <a href=\"#\" class=\"gradle-config\">").append(Messages.getString("ANALYSIS_REPORT_GRADLE")).append("</a>\n");
        sb.append("  </div>\n");
        sb.append("</div>\n");
        sb.append("<div id=\"js-maven-config\" class=\"detailed-results-config show\">\n");
        sb.append("  <div>\n");
        sb.append("  <p>").append(Messages.getString("ANALYSIS_REPORT_MAVEN_STEP_1")).append("</p>");
        sb.append(ReportUtility.buildCopyArea(this.analysisResults.getRewriteMavenConfig(), "rewriteMavenConfig"));
        sb.append("  <p>").append(Messages.getString("ANALYSIS_REPORT_COMMON_STEP_2")).append("\n<div class=\"command-text indent\">./mvnw rewrite:run</div>").append("</p>");
        sb.append("  <p>").append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_COMMON_STEP_3"), "<a class=\"blueAnchor\" href=\"https://github.com/openrewrite\">https://github.com/openrewrite</a>")).append("</p>");
        sb.append("  <p>").append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_COMMON_STEP_WCA4J_PLUGIN"), new Object[0])).append("</p>");
        sb.append("  </div>\n");
        sb.append("</div>\n");
        sb.append("<div id=\"js-gradle-config\" class=\"detailed-results-config hide\">\n");
        sb.append("  <div>\n");
        sb.append("  <p>").append(Messages.getString("ANALYSIS_REPORT_GRADLE_STEP_1")).append("</p>");
        sb.append(ReportUtility.buildCopyArea(this.analysisResults.getRewriteGradleConfig(), "rewriteGradleConfig"));
        sb.append("  <p>").append(Messages.getString("ANALYSIS_REPORT_COMMON_STEP_2")).append("\n<div class=\"command-text indent\">./gradlew rewriteRun</div>").append("</p>");
        sb.append("  <p>").append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_COMMON_STEP_3"), "<a class=\"blueAnchor\" href=\"https://github.com/openrewrite\">https://github.com/openrewrite</a>")).append("</p>");
        sb.append("  <p>").append(Messages.getFormattedMessage(Messages.getString("ANALYSIS_REPORT_COMMON_STEP_WCA4J_PLUGIN"), new Object[0])).append("</p>");
        sb.append("  </div>\n");
        sb.append("</div>\n");
    }

    protected void buildRulesAnalyzed(StringBuilder sb, boolean consolidated) {
        sb.append(!consolidated ? "<div id=\"jsRulesAnalyzedTitle\" class=\"detailed-results-header header-sections\" role=\"complementary\" aria-labelledby=\"analyze_RulesAnalyzed\">\n" : "<div id=\"jsRulesAnalyzedTitle\" class=\"detailed-results-header header-sections horizontal-breaks\" role=\"complementary\" aria-labelledby=\"analyze_RulesAnalyzed\" aria-label=\"Rules Analyzed Title\">\n");
        sb.append("  <h2 id=\"analyze_RulesAnalyzed\" class=\"detailed-results-title\">").append(Messages.getString("ANALYSIS_REPORT_RULES_ANALYZED")).append("</h2>\n");
        sb.append("  <div class=\"expand-collapse-holder noprint\">\n");
        sb.append("    <a href=\"#\" class=\"read-more almighty\">").append(Messages.getString("ANALYSIS_REPORT_SHOW_MORE")).append("</a>\n");
        sb.append("    <a href=\"#\" class=\"read-less almighty disabled\">").append(Messages.getString("ANALYSIS_REPORT_SHOW_LESS")).append("</a>\n");
        sb.append("  </div>\n");
        sb.append("</div>\n");
        sb.append("<div id=\"js-rules-analyzed-detail\" class=\"detailed-analysis-by-rule clear read-less\">\n");
        sb.append("  <a href=\"#\" title=\"").append(Messages.getString("ANALYSIS_REPORT_SHOW_MORE")).append("\" class=\"detailed-read-more-button\">").append(Messages.getString("ANALYSIS_REPORT_SHOW_MORE")).append("</a>\n");
        sb.append("  <ul>\n");
        Set keys = this.rulesAnalyzed.keySet();
        TreeSet sortedMainCatKeys = new TreeSet(keys);
        for (String mainCatKey : sortedMainCatKeys) {
            sb.append("    <li class=\"analyzed-rule shared\">\n");
            Map subcats = (Map)this.rulesAnalyzed.get(mainCatKey);
            TreeSet sortedSubCatKeys = new TreeSet(subcats.keySet());
            sb.append("<h3>").append(ReportUtility.encodeHTMLEntities(mainCatKey)).append("</h3>\n");
            for (String subcatKey : sortedSubCatKeys) {
                if (!mainCatKey.equals(subcatKey)) {
                    sb.append("<div class=\"analyze-bold\">").append(ReportUtility.encodeHTMLEntities(subcatKey)).append("</div>\n");
                }
                Map rulesByType = (Map)subcats.get(subcatKey);
                this.buildRulesAnalyzedByType(sb, mainCatKey, subcatKey, rulesByType);
            }
            sb.append("    </li>\n");
        }
        sb.append("  </ul>\n");
        sb.append("</div>\n");
    }

    public void buildRulesAnalyzedByType(StringBuilder sb, String mainCat, String secondaryCat, Map<String, List<String>> rulesByType) {
        Set<String> keys = rulesByType.keySet();
        ArrayList<String> sortedKeys = new ArrayList<String>(keys);
        Collections.sort(sortedKeys);
        String ruleTypeHeaderBegin = "<div class=\"rule-type\">";
        String ruleTypeHeaderEnd = "</div>";
        if (!mainCat.equals(secondaryCat)) {
            ruleTypeHeaderBegin = "<div class=\"analyze-bold-small rule-type\">";
            ruleTypeHeaderEnd = "</div>";
        }
        for (String key : sortedKeys) {
            String ruleType = null;
            if (key.equals("file")) {
                ruleType = Messages.getString("ANALYSIS_REPORT_FILE_RULES");
            } else if (key.equals("java")) {
                ruleType = Messages.getString("ANALYSIS_REPORT_JAVA_RULES");
            } else if (key.equals("jsp")) {
                ruleType = Messages.getString("ANALYSIS_REPORT_JSP_RULES");
            } else if (key.equals("mf")) {
                ruleType = Messages.getString("ANALYSIS_REPORT_MANIFEST_RULES");
            } else if (key.equals("property")) {
                ruleType = Messages.getString("ANALYSIS_REPORT_PROPERTY_RULES");
            } else if (key.equals("xml")) {
                ruleType = Messages.getString("ANALYSIS_REPORT_XML_RULES");
            }
            List<String> rules = rulesByType.get(key);
            if (rules.size() <= 0) continue;
            sb.append(ruleTypeHeaderBegin).append(ruleType).append(ruleTypeHeaderEnd).append("\n");
            sb.append("<ul>\n");
            for (String rule : rules) {
                String ruleName = this.parseRuleNameFromIdentfier(ReportUtility.getRuleNameForHTML(rule));
                sb.append("<li>").append(ruleName).append("</li>\n");
            }
            sb.append("</ul>\n");
        }
    }

    public void buildGeneratedOn() {
        this.resultBuffer.append("    <p class=\"date-time\"><span class=\"date\">").append(ReportUtility.getCreatedDate()).append("</span></p>\n");
        this.resultBuffer.append("<p class=\"courier archivePath\">");
        if (this.projects != null) {
            int rowCounter = 0;
            int total = this.projects.size();
            for (String item : this.projects) {
                if (++rowCounter < total) {
                    this.resultBuffer.append(ReportUtility.encodeHTMLEntities(item)).append(", ");
                    continue;
                }
                this.resultBuffer.append(ReportUtility.encodeHTMLEntities(item)).append(" </p>\n");
            }
        }
    }

    @Override
    public void writeReport() {
        this.buildHeader();
        this.buildSummary();
        if (!this.formatByFile) {
            this.resultBuffer.append("<div id=\"detailResultsByRule\" class=\"detailed-results-header header-sections\">\n");
            this.resultBuffer.append("  <h2 class=\"detailed-results-title\">").append(Messages.getString("ANALYSIS_REPORT_DETAILED_RESULTS_BY_RULE")).append("</h2>\n");
            this.resultBuffer.append("  <div class=\"expand-collapse-holder noprint\">\n");
            this.resultBuffer.append("    <a href=\"#\" class=\"expand-all almighty\">").append(Messages.getString("ANALYSIS_REPORT_EXPAND_ALL")).append("</a>\n");
            this.resultBuffer.append("    <a href=\"#\" class=\"collapse-all almighty disabled\">").append(Messages.getString("ANALYSIS_REPORT_COLLAPSE_ALL")).append("</a>\n");
            this.resultBuffer.append("  </div>\n");
            this.resultBuffer.append("</div>\n");
            this.buildResultsByRule(this.resultBuffer);
            String connectivitySummary = this.buildConnectivitySummary();
            if (connectivitySummary != null) {
                this.resultBuffer.insert(this.offsetOfSummary, connectivitySummary);
            }
        }
        this.buildAdditionalHelp(this.resultBuffer, false);
        this.buildJumpToRule();
        if (this.analysisResults.containsAutomatedFix()) {
            this.buildAutomatedFixConfiguration(this.resultBuffer, false);
        }
        this.buildRulesAnalyzed(this.resultBuffer, false);
        this.resultBuffer.append("</div>\n");
        this.buildJavaScript();
        this.resultBuffer.append("</body>\n");
        this.resultBuffer.append("</html>\n");
        this.close();
    }
}

