/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import org.eclipse.osgi.internal.permadmin.SecurityRow;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public class SecurityRowSnapShot
implements ConditionalPermissionInfo {
    private final String name;
    private final ConditionInfo[] conditionInfos;
    private final PermissionInfo[] permissionInfos;
    private final String decision;

    public SecurityRowSnapShot(String name2, ConditionInfo[] conditionInfos, PermissionInfo[] permissionInfos, String decision) {
        boolean a;
        if (permissionInfos == null || permissionInfos.length == 0) {
            throw new IllegalArgumentException("It is invalid to have empty permissionInfos");
        }
        boolean d = "deny".equals(decision = decision.toLowerCase());
        if (!(d | (a = "allow".equals(decision)))) {
            throw new IllegalArgumentException("Invalid decision: " + decision);
        }
        conditionInfos = conditionInfos == null ? new ConditionInfo[]{} : conditionInfos;
        this.name = name2;
        this.conditionInfos = (ConditionInfo[])SecurityRow.cloneArray(conditionInfos);
        this.permissionInfos = (PermissionInfo[])SecurityRow.cloneArray(permissionInfos);
        this.decision = decision;
    }

    @Override
    public ConditionInfo[] getConditionInfos() {
        return (ConditionInfo[])SecurityRow.cloneArray(this.conditionInfos);
    }

    @Override
    public String getAccessDecision() {
        return this.decision;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PermissionInfo[] getPermissionInfos() {
        return (PermissionInfo[])SecurityRow.cloneArray(this.permissionInfos);
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getEncoded();
    }

    @Override
    public String getEncoded() {
        return SecurityRow.getEncoded(this.name, this.conditionInfos, this.permissionInfos, "deny".equalsIgnoreCase(this.decision));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConditionalPermissionInfo)) {
            return false;
        }
        return this.getEncoded().equals(((ConditionalPermissionInfo)obj).getEncoded());
    }

    @Override
    public int hashCode() {
        return SecurityRow.getHashCode(this.name, this.conditionInfos, this.permissionInfos, this.getAccessDecision());
    }
}

