/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.javaee.dd.common.InjectionTarget;
import com.ibm.ws.javaee.dd.common.PersistenceUnitRef;
import com.ibm.ws.jpa.JPAAccessor;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.management.AbstractJPAComponent;
import com.ibm.ws.jpa.management.AbstractJPAInjectionBinding;
import com.ibm.ws.jpa.management.JPAPUnitInjectionBinding;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionProcessor;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnit;
import jakarta.persistence.PersistenceUnits;
import java.lang.reflect.Member;
import java.util.List;
import javax.naming.Reference;

public class JPAPUnitProcessor
extends InjectionProcessor<PersistenceUnit, PersistenceUnits> {
    private static final TraceComponent tc = Tr.register(JPAPUnitProcessor.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");

    public JPAPUnitProcessor() {
        super(PersistenceUnit.class, PersistenceUnits.class);
    }

    public InjectionBinding<PersistenceUnit> createInjectionBinding(PersistenceUnit annotation, Class<?> instanceClass, Member member, String jndiName) throws InjectionException {
        JPAPUnitInjectionBinding injectionBindingResource = new JPAPUnitInjectionBinding(annotation, this.ivNameSpaceConfig);
        return injectionBindingResource;
    }

    public void processXML() throws InjectionException {
        List pUnitRefs;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processXML : " + this.ivNameSpaceConfig.getPersistenceUnitRefs()), (Object[])new Object[0]);
        }
        if ((pUnitRefs = this.ivNameSpaceConfig.getPersistenceUnitRefs()) != null && pUnitRefs.size() > 0) {
            for (PersistenceUnitRef pUnitRef : pUnitRefs) {
                String jndiName;
                InjectionBinding injectionBinding;
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" pUnitRef = " + pUnitRef), (Object[])new Object[0]);
                }
                if ((injectionBinding = (InjectionBinding)this.ivAllAnnotationsCollection.get(jndiName = pUnitRef.getName())) != null) {
                    ((JPAPUnitInjectionBinding)injectionBinding).merge(pUnitRef);
                } else {
                    injectionBinding = new JPAPUnitInjectionBinding(pUnitRef, this.ivNameSpaceConfig);
                    this.addInjectionBinding(injectionBinding);
                }
                ((AbstractJPAInjectionBinding)injectionBinding).addRefComponents(jndiName);
                List targets = pUnitRef.getInjectionTargets();
                if (targets == null || targets.isEmpty()) continue;
                for (InjectionTarget target : targets) {
                    String injectionClassName = target.getInjectionTargetClassName();
                    String injectionName = target.getInjectionTargetName();
                    injectionBinding.addInjectionTarget(EntityManagerFactory.class, injectionName, injectionClassName);
                }
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processXML : " + this.ivAllAnnotationsCollection.size()));
        }
    }

    public void resolve(InjectionBinding<PersistenceUnit> injectionBinding) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("resolve : " + injectionBinding), (Object[])new Object[0]);
        }
        JPAPUnitInjectionBinding pUnitBinding = (JPAPUnitInjectionBinding)injectionBinding;
        String applName = pUnitBinding.getApplName();
        String modJarName = pUnitBinding.getModJarName();
        String puName = ((PersistenceUnit)pUnitBinding.getAnnotation()).unitName();
        boolean isEJBinWar = this.ivNameSpaceConfig.getOwningFlow() == ComponentNameSpaceConfiguration.ReferenceFlowKind.HYBRID;
        JPAPuId puId = new JPAPuId(applName, modJarName, puName);
        AbstractJPAComponent jpaComponent = (AbstractJPAComponent)JPAAccessor.getJPAComponent();
        Reference ref = jpaComponent.createPersistenceUnitReference(isEJBinWar, puId, this.ivNameSpaceConfig.getJ2EEName(), pUnitBinding.getJndiName(), this.ivNameSpaceConfig.isSFSB());
        pUnitBinding.setObjects(null, ref);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("resolve : " + (Object)((Object)pUnitBinding)));
        }
    }

    public String getJndiName(PersistenceUnit annotation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("annotation.name=" + annotation.name()), (Object[])new Object[0]);
        }
        return annotation.name();
    }

    public PersistenceUnit[] getAnnotations(PersistenceUnits annotation) {
        return annotation.value();
    }
}

