/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics50.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.http.monitor.HttpStatAttributes;
import io.openliberty.http.monitor.metrics.HTTPMetricAdapter;
import io.openliberty.microprofile.metrics50.SharedMetricRegistries;
import java.time.Duration;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={HTTPMetricAdapter.class}, configurationPolicy=ConfigurationPolicy.IGNORE)
public class MPMetricsHTTPMetricsAdapterImpl
implements HTTPMetricAdapter {
    static SharedMetricRegistries sharedMetricRegistries;
    static final long serialVersionUID = -6465860922180003628L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    public void activate() {
    }

    @Reference
    public void setSharedMetricRegistries(SharedMetricRegistries sharedMetricRegistry) {
        sharedMetricRegistries = sharedMetricRegistry;
    }

    public void updateHttpMetrics(HttpStatAttributes httpStatAttributes, Duration duration) {
        if (sharedMetricRegistries == null) {
            return;
        }
        MetricRegistry vendorRegistry = sharedMetricRegistries.getOrCreate("vendor");
        Metadata md = new MetadataBuilder().withName("http.server.request.duration").withDescription("Duration of HTTP server requests.").build();
        Timer httpTimer = vendorRegistry.timer(md, this.retrieveTags(httpStatAttributes));
        httpTimer.update(duration);
    }

    private Tag[] retrieveTags(HttpStatAttributes httpStatAttributes) {
        Tag requestMethodTag = new Tag("http_request_method", httpStatAttributes.getRequestMethod());
        Tag urlSchemeTag = new Tag("url_scheme", httpStatAttributes.getScheme());
        Integer status = httpStatAttributes.getResponseStatus().orElse(-1);
        Tag responseStatusTag = new Tag("http_response_status_code", status == -1 ? "" : status.toString().trim());
        Tag httpRouteTag = new Tag("http_route", httpStatAttributes.getHttpRoute().orElse(""));
        Tag networkProtocolVersionTag = new Tag("network_protocol_version", httpStatAttributes.getNetworkProtocolVersion());
        Tag serverNameTag = new Tag("server_address", httpStatAttributes.getServerName());
        Tag serverPortTag = new Tag("server_port", String.valueOf(httpStatAttributes.getServerPort()));
        String errorType = httpStatAttributes.getErrorType().orElse("");
        Tag errorTypeTag = new Tag("error_type", errorType);
        Tag[] ret = new Tag[]{requestMethodTag, urlSchemeTag, responseStatusTag, httpRouteTag, networkProtocolVersionTag, serverNameTag, serverPortTag, errorTypeTag};
        return ret;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics50.http.MPMetricsHTTPMetricsAdapterImpl", MPMetricsHTTPMetricsAdapterImpl.class, null, null);
    }
}

