/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSetChangeCallback;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ConsumerMonitorListenerCache {
    public static final String $sccsid = "@(#) 1.5 SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/ConsumerMonitorListenerCache, SIB.comms, WASX.SIB";
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceComponent tc = SibTr.register(ConsumerMonitorListenerCache.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private final Map<Short, ConsumerSetChangeCallback> cache = Collections.synchronizedMap(new HashMap());

    public boolean contains(ConsumerSetChangeCallback csc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"contains", (Object)csc);
        }
        boolean rc = this.cache.containsValue(csc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"contains", (Object)rc);
        }
        return rc;
    }

    public boolean contains(short id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"contains", (Object)id);
        }
        boolean rc = this.cache.containsKey(id);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"contains", (Object)rc);
        }
        return rc;
    }

    public ConsumerSetChangeCallback get(short id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"get", (Object)id);
        }
        ConsumerSetChangeCallback rc = this.cache.get(id);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"get", (Object)rc);
        }
        return rc;
    }

    public synchronized short add(ConsumerSetChangeCallback csc) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"add", (Object)csc);
        }
        short rc = 0;
        if (this.cache.containsValue(csc)) {
            for (Short s : this.cache.keySet()) {
                if (!this.cache.get((short)s).equals(csc)) continue;
                rc = s;
                break;
            }
        } else {
            for (short s = 1; s <= Short.MAX_VALUE; s = (short)(s + 1)) {
                if (this.cache.containsKey(s)) continue;
                rc = s;
                break;
            }
            if (rc == 0) {
                throw new SIResourceException(nls.getFormattedMessage("UNABLE_TO_ADD_CONSUMER_MONITOR_LISTENER_ID_TO_CACHE_SICO1072", null, null));
            }
            this.cache.put(rc, csc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"add", (Object)rc);
        }
        return rc;
    }

    public synchronized void add(short id, ConsumerSetChangeCallback csc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"add", (Object)new Object[]{id, csc});
        }
        this.cache.put(id, csc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"add");
        }
    }

    public String toString() {
        return "cache=" + this.cache.toString();
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) 1.5 SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/ConsumerMonitorListenerCache, SIB.comms, WASX.SIB");
        }
    }
}

